/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.Closeable;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.gradle.internal.IoActions;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourceAccessor
implements ExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceAccessor.class);
    private final HttpClientHelper http;

    public HttpResourceAccessor(HttpClientHelper http) {
        this.http = http;
    }

    @Nullable
    public HttpResponseResource openResource(URI uri, boolean revalidate) {
        String location = uri.toString();
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        CloseableHttpResponse response = this.http.performGet(location, revalidate);
        if (response != null) {
            return this.wrapResponse(uri, response);
        }
        return null;
    }

    public HttpResponseResource getRawResource(URI uri, boolean revalidate) {
        String location = uri.toString();
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        CloseableHttpResponse response = this.http.performRawGet(location, revalidate);
        return this.wrapResponse(uri, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalResourceMetaData getMetaData(URI uri, boolean revalidate) {
        String location = uri.toString();
        LOGGER.debug("Constructing external resource metadata: {}", (Object)location);
        CloseableHttpResponse response = this.http.performHead(location, revalidate);
        ExternalResourceMetaData result = null;
        if (response != null) {
            HttpResponseResource resource = new HttpResponseResource("HEAD", uri, response);
            try {
                result = resource.getMetaData();
            }
            finally {
                IoActions.closeQuietly((Closeable)((Object)resource));
            }
        }
        return result;
    }

    private HttpResponseResource wrapResponse(URI uri, CloseableHttpResponse response) {
        return new HttpResponseResource("GET", uri, response);
    }
}

