/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.bean;

import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNodeFactory;

class IterableRuntimeBeanNode
extends RuntimeBeanNode<Iterable<?>> {
    public IterableRuntimeBeanNode(RuntimeBeanNode<?> parentNode, String propertyName, Iterable<?> iterable, TypeMetadata typeMetadata) {
        super(parentNode, propertyName, iterable, typeMetadata);
    }

    private static String determinePropertyName(@Nullable Object input, int count) {
        String prefix = input instanceof Named ? ((Named)input).getName() : "";
        return prefix + "$" + count;
    }

    @Override
    public void visitNode(PropertyVisitor visitor, PropertySpecFactory specFactory, Queue<RuntimeBeanNode<?>> queue, RuntimeBeanNodeFactory nodeFactory) {
        int count = 0;
        for (Object input : (Iterable)this.getBean()) {
            String propertyName = IterableRuntimeBeanNode.determinePropertyName(input, count);
            ++count;
            queue.add(this.createChildNode(propertyName, input, nodeFactory));
        }
    }
}

