/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import com.google.common.collect.ImmutableCollection;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.execution.taskgraph.TaskDependencyResolver;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.execution.taskgraph.WorkInfo;

public class LocalTaskInfo
extends TaskInfo {
    private final TaskInternal task;

    public LocalTaskInfo(TaskInternal task) {
        this.task = task;
    }

    public TaskInternal getTask() {
        return this.task;
    }

    @Override
    public void collectTaskInto(ImmutableCollection.Builder<Task> builder) {
        builder.add((Object)this.task);
    }

    @Override
    public Throwable getWorkFailure() {
        return this.task.getState().getFailure();
    }

    @Override
    public void rethrowFailure() {
        this.task.getState().rethrowFailure();
    }

    @Override
    public void prepareForExecution() {
        ((TaskContainerInternal)this.task.getProject().getTasks()).prepareForExecution(this.task);
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<WorkInfo> processHardSuccessor) {
        for (WorkInfo targetNode : this.getDependencies(dependencyResolver)) {
            this.addDependencySuccessor(targetNode);
            processHardSuccessor.execute((Object)targetNode);
        }
        for (WorkInfo targetNode : this.getFinalizedBy(dependencyResolver)) {
            if (!(targetNode instanceof TaskInfo)) {
                throw new IllegalStateException("Only tasks can be finalizers: " + targetNode);
            }
            this.addFinalizerNode((TaskInfo)targetNode);
            processHardSuccessor.execute((Object)targetNode);
        }
        for (WorkInfo targetNode : this.getMustRunAfter(dependencyResolver)) {
            this.addMustSuccessor(targetNode);
        }
        for (WorkInfo targetNode : this.getShouldRunAfter(dependencyResolver)) {
            this.addShouldSuccessor(targetNode);
        }
    }

    private void addFinalizerNode(TaskInfo finalizerNode) {
        this.addFinalizer(finalizerNode);
        if (!finalizerNode.isInKnownState()) {
            finalizerNode.mustNotRun();
        }
    }

    private Set<WorkInfo> getDependencies(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getTaskDependencies());
    }

    private Set<WorkInfo> getFinalizedBy(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getFinalizedBy());
    }

    private Set<WorkInfo> getMustRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getMustRunAfter());
    }

    private Set<WorkInfo> getShouldRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getShouldRunAfter());
    }

    @Override
    public int compareTo(WorkInfo other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        LocalTaskInfo localTask = (LocalTaskInfo)other;
        return this.task.compareTo(localTask.task);
    }

    @Override
    public String toString() {
        return this.task.getIdentityPath().toString();
    }
}

