/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.initialization.AbstractProjectSpec;

public class BuildFileProjectSpec
extends AbstractProjectSpec {
    private final File buildFile;

    public BuildFileProjectSpec(File buildFile) {
        this.buildFile = buildFile;
    }

    @Override
    protected String formatNoMatchesMessage() {
        return String.format("No projects in this build have build file '%s'.", this.buildFile);
    }

    @Override
    protected String formatMultipleMatchesMessage(Iterable<? extends ProjectIdentifier> matches) {
        return String.format("Multiple projects in this build have build file '%s': %s", this.buildFile, matches);
    }

    @Override
    protected <T extends ProjectIdentifier> void select(ProjectRegistry<? extends T> candidates, List<? super T> matches) {
        for (ProjectIdentifier candidate : candidates.getAllProjects()) {
            if (!candidate.getBuildFile().equals(this.buildFile)) continue;
            matches.add(candidate);
        }
    }

    @Override
    protected void checkPreconditions(ProjectRegistry<?> registry) {
        if (!this.buildFile.exists()) {
            throw new InvalidUserDataException(String.format("Build file '%s' does not exist.", this.buildFile));
        }
        if (!this.buildFile.isFile()) {
            throw new InvalidUserDataException(String.format("Build file '%s' is not a file.", this.buildFile));
        }
    }
}

