#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: easytest
version: 0.2
id: easytest-0.2-DAeYIYp7gTGHoZGwup5uEC
key: easytest-0.2-DAeYIYp7gTGHoZGwup5uEC
license: MIT
copyright: Copyright (C) 2017-2018 Joel Burget, Copyright (C) 2016 Paul Chiusano and contributors
maintainer: Joel Burget <joelburget@gmail.com>
author: Joel Burget, Paul Chiusano
stability: provisional
homepage: https://github.com/joelburget/easytest
synopsis: Simple, expressive testing library
description:
    EasyTest is a simple testing toolkit, meant to replace most uses of QuickCheck, SmallCheck, HUnit, and frameworks like Tasty, etc. Here'\''s an example usage:
    .
    > module Main where
    >
    > import EasyTest
    > import Control.Applicative
    > import Control.Monad
    >
    > suite :: Test ()
    > suite = tests
    >   [ scope "addition.ex1" $ expect (1 + 1 == 2)
    >   , scope "addition.ex2" $ expect (2 + 3 == 5)
    >   , scope "list.reversal" . fork $ do
    >       -- generate lists from size 0 to 10, of Ints in (0,43)
    >       -- shorthand: listsOf [0..10] (int'\'' 0 43)
    >       ns <- [0..10] `forM` \n -> replicateM n (int'\'' 0 43)
    >       ns `forM_` \ns -> expect (reverse (reverse ns) == ns)
    >   -- equivalent to `scope "addition.ex3"`
    >   , scope "addition" . scope "ex3" $ expect (3 + 3 == 6)
    >   , scope "always passes" $ do
    >       note "I'\''m running this test, even though it always passes!"
    >       ok -- like `pure ()`, but records a success result
    >   , scope "failing test" $ crash "oh noes!!" ]
    >
    > -- NB: `run suite` would run all tests, but we only run
    > -- tests whose scopes are prefixed by "addition"
    > main = runOnly "addition" suite
    .
    This generates the output:
    .
    > Randomness seed for this run is 5104092164859451056
    > Raw test output to follow ...
    > ------------------------------------------------------------
    > OK addition.ex1
    > OK addition.ex2
    > OK addition.ex3
    > ------------------------------------------------------------
    > ✅  3 tests passed, no failures! 👍 🎉
    The idea here is to write tests with ordinary Haskell code, with control flow explicit and under programmer control.
category: Testing
abi: 8f98f604dc60de83ec7fa22b0404f827
exposed: True
exposed-modules:
    EasyTest EasyTest.Internal
hidden-modules: EasyTest.Generators EasyTest.Porcelain
import-dirs: /usr/lib/ghc-8.4.3/site-local/easytest-0.2
library-dirs: /usr/lib/ghc-8.4.3/site-local/easytest-0.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/easytest-0.2
hs-libraries: HSeasytest-0.2-DAeYIYp7gTGHoZGwup5uEC
depends:
    async-2.2.1-B6m2kYywRJu7nicgTBxsJe base-4.11.1.0 mtl-2.2.2
    containers-0.5.11.0 stm-2.4.5.0 random-1.1-9LLJAJa4iQFLJiLXBOBXBV
    text-1.2.3.0 transformers-0.5.5.0
    call-stack-0.1.0-Eiz5FM8yQXpI3vyQ1Rt4Jq
abi-depends: async-2.2.1-B6m2kYywRJu7nicgTBxsJe=32776142fda961cc693aa4db742773f9
             base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             stm-2.4.5.0=4e743cb5a370ac3fbade528432951c3f
             random-1.1-9LLJAJa4iQFLJiLXBOBXBV=2cade9e72fa19fe7a43e5ace84505d9f
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             call-stack-0.1.0-Eiz5FM8yQXpI3vyQ1Rt4Jq=c76ca250c7cf6b5c2ee744c15760c93f
haddock-interfaces: /usr/share/doc/haskell-easytest/html/easytest.haddock
haddock-html: /usr/share/doc/haskell-easytest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

