#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: HTTP
version: 4000.3.12
id: HTTP-4000.3.12-73tuAL5moiZAn4d1gi4CPa
key: HTTP-4000.3.12-73tuAL5moiZAn4d1gi4CPa
license: BSD-3-Clause
maintainer: Ganesh Sittampalam <ganesh@earth.li>
author: Warrick Gray <warrick.gray@hotmail.com>
homepage: https://github.com/haskell/HTTP
synopsis: A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.
    .
    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.
    .
    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).
    .
    Here'\''s an example use:
    .
    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))
    .
    __Note:__ This package does not support HTTPS connections.
    If you need HTTPS, take a look at the following packages:
    .
    * <http://hackage.haskell.org/package/http-streams http-streams>
    .
    * <http://hackage.haskell.org/package/http-client http-client> (in combination with
    <http://hackage.haskell.org/package/http-client-tls http-client-tls>)
    .
    * <http://hackage.haskell.org/package/req req>
    .
    * <http://hackage.haskell.org/package/wreq wreq>
    .
category: Network
abi: 56986b91b20f69fc6522273286e07752
exposed: True
exposed-modules:
    Network.Browser Network.BufferType Network.HTTP Network.HTTP.Auth
    Network.HTTP.Base Network.HTTP.Cookie Network.HTTP.HandleStream
    Network.HTTP.Headers Network.HTTP.Proxy Network.HTTP.Stream
    Network.Stream Network.StreamDebugger Network.StreamSocket
    Network.TCP
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
import-dirs: /usr/lib/ghc-8.4.3/site-local/HTTP-4000.3.12
library-dirs: /usr/lib/ghc-8.4.3/site-local/HTTP-4000.3.12
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/HTTP-4000.3.12
hs-libraries: HSHTTP-4000.3.12-73tuAL5moiZAn4d1gi4CPa
depends:
    base-4.11.1.0 parsec-3.1.13.0 array-0.5.2.0 bytestring-0.10.8.2
    time-1.8.0.2 mtl-2.2.2 network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9
    network-2.7.0.2-CxFtLVxZlCwGfUj2kt7Tsu
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             parsec-3.1.13.0=3626e7cedd22de76a8b10339d955721a
             array-0.5.2.0=dc85b03ee806d784249cc791da6109c3
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9=4ea8f0efa7a1ade0af4e9ce0cffcff8c
             network-2.7.0.2-CxFtLVxZlCwGfUj2kt7Tsu=43a70846fe67ebce9998ba267f800e6d
haddock-interfaces: /usr/share/doc/haskell-http/html/HTTP.haddock
haddock-html: /usr/share/doc/haskell-http/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

