/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javajs.util.PT;
import javajs.util.SB;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.gennbo.GIFWriter;
import org.gennbo.NBOConfig;
import org.gennbo.NBODialog;
import org.gennbo.NBOFileHandler;
import org.gennbo.NBORequest;
import org.gennbo.NBOUtil;
import org.jmol.awt.AwtColor;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.util.C;
import org.jmol.viewer.Viewer;

class NBOView {
    protected NBODialog dialog;
    protected Viewer vwr;
    private static final int MODE_VIEW_IMAGE = 13;
    private static final int MODE_VIEW_LIST = 23;
    private static final int MODE_VIEW_VIDEO = 33;
    protected final int BASIS_AO = 0;
    protected final int BASIS_PNAO = 1;
    protected final int BASIS_NAO = 2;
    protected final int BASIS_PNHO = 3;
    protected final int BASIS_NHO = 4;
    protected final int BASIS_PNBO = 5;
    protected final int BASIS_NBO = 6;
    protected final int BASIS_PNLMO = 7;
    protected final int BASIS_NLMO = 8;
    protected final int BASIS_MO = 9;
    protected static final String[] basSet = new String[]{"AO", "PNAO", "NAO", "PNHO", "NHO", "PNBO", "NBO", "PNLMO", "NLMO", "MO"};
    protected static final int[] basisLabelKey = new int[]{0, 1, 1, 2, 2, 3, 3, 3, 3, 4, 0, 1, 1, 5, 5, 6, 6, 6, 6, 4};
    private String[][] orbitalLabels;
    private JScrollPane orbScroll;
    private Box centerBox;
    private Box bottomBox;
    private Box vecBox;
    private Box planeBox;
    private JRadioButton profileBtn;
    private JRadioButton contourBtn;
    private JRadioButton viewBtn;
    private JRadioButton atomOrient;
    private DefaultListModel<String> alphaList;
    private DefaultListModel<String> betaList;
    private boolean jmolView;
    protected OrbitalList orbitals;
    protected int viewState;
    protected static final int VIEW_STATE_MAIN = 0;
    protected static final int VIEW_STATE_PLANE = 1;
    protected static final int VIEW_STATE_VECTOR = 2;
    protected static final int VIEW_STATE_CAMERA = 3;
    protected JComboBox<String> comboBasis1;
    protected JRadioButton alphaSpin;
    protected JRadioButton betaSpin;
    protected boolean isNewModel = true;
    protected String currOrb = "";
    protected int currOrbIndex;
    private String[] plVal;
    private String[] vecVal;
    private String[] lineVal;
    private String videoInputFileType;
    private JRadioButton video;
    private JDialog videoDialog;
    private NBOFileHandler scriptVideoFileHandler;
    private NBOFileHandler gifVideoFileHandler;
    private final int SCRIPT_MODE = 0;
    private final int GIF_MODE = 1;
    private JRadioButton createVideo;
    private JRadioButton saveVideo;
    private JRadioButton playVideo;
    private boolean validScriptFilePath;
    private boolean validGifFilePath;
    private JComboBox<String> dropDownMenu;
    private int frameRate;
    private String scriptVideoPath;
    private String gifVideoPath;
    public String savevideo_jobstem;
    private final JTextField[] vectorFields = new JTextField[8];
    private final JTextField[] planeFields = new JTextField[12];
    private final JTextField[] camFields = new JTextField[53];
    private final JTextField[] lineFields = new JTextField[7];
    private String[] camVal = new String[]{"6.43", "0.0", "0.0", "50.0", "2.0", "2.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.5", "1.0", "1.0", "1.0", "0.8", "0.0", "0.0", "1.0", "0.8", "0.4", "0.0", "1.0", "1.0", "0.5", "0.5", "0.5", "0.0", "0.7", "1.0", "0.22", "0.40", "0.10", "0.05", "0.0316", "0.0001", "0.4000", "1"};
    private String[] camFieldIDs = new String[]{"1a", "1b", "1c", "1d", "1e", "1f", "1g", "2a", "2b", "2c", "2d", "2e", "2f", "2g", "2h", "2i", "2j", "2k", "2l", "2m", "2n", "2o", "2p", "2q", "2r", "2s", "2t", "3a", "3b", "3c", "3d", "3e", "3f", "3g", "3h", "3i", "3j", "3k", "3l", "3m", "3n", "3o", "3p", "3q", "3r", "4a", "4b", "4c", "4d", "5a", "5b", "5c", "6"};
    private int viewVectorPt = 0;
    private int viewPlanePt = 0;
    private boolean includeRydberg = false;

    protected NBOView(NBODialog dialog) {
        this.dialog = dialog;
        this.vwr = dialog.vwr;
    }

    private void clearLabelSet() {
        this.orbitalLabels = new String[7][];
    }

    private String[] getLabelSet(int ibas, boolean isAlpha) {
        return this.orbitalLabels[this.getIbasKey(ibas, isAlpha)];
    }

    private int getIbasKey(int ibas, boolean isBeta) {
        return basisLabelKey[ibas + (isBeta ? 10 : 0)];
    }

    private void addBasisLabel(int ikey, String[] tokens) {
        this.orbitalLabels[ikey] = tokens;
    }

    protected void setDefaultParameterArrays() {
        this.plVal = new String[]{"1", "2", "3", "0.5", "0.0", "0.0", "0.0", "-3.0", "3.0", "-3.0", "3.0", "25"};
        this.vecVal = new String[]{"1", "2", "0.5", "-2.0", "2.0", "-1.0", "1.0", "100"};
        this.lineVal = new String[]{"0.03", "0.05", "4", "0.05", "0.05", "0.1", "0.1"};
    }

    protected JPanel buildViewPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.viewState = 0;
        this.dialog.runScriptQueued("set bondpicking true");
        Box b = this.createViewSearchJobBox(3, true);
        if (!this.dialog.jmolOptionNONBO) {
            panel.add((Component)b, "North");
        }
        this.centerBox = NBOUtil.createTitleBox(" Select Orbital(s) ", this.createSelectOrbitalBox());
        this.centerBox.setVisible(false);
        this.centerBox.add(this.createOrbitalPanel());
        panel.add((Component)this.centerBox, "Center");
        panel.add(this.createBottomBox(), "South");
        this.updateViewSettings();
        this.frameRate = -1;
        this.dialog.inputFileHandler.setBrowseEnabled(true);
        return panel;
    }

    private Box createTitleBox(String title, Component rightSideComponent) {
        Box box = Box.createVerticalBox();
        JLabel label = new JLabel(title);
        label.setAlignmentX(0.0f);
        label.setBackground(NBOConfig.titleColor);
        label.setForeground(Color.white);
        label.setFont(NBOConfig.titleFont);
        label.setOpaque(true);
        this.video = new JRadioButton("Video");
        this.video.setHorizontalAlignment(0);
        this.video.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBOView.this.doVideo();
            }
        });
        if (rightSideComponent != null) {
            JPanel box2 = new JPanel(new BorderLayout());
            box2.setAlignmentX(0.0f);
            box2.setMaximumSize(new Dimension(360, 25));
            box2.add((Component)label, "West");
            box2.add((Component)this.video, "Center");
            box2.add(rightSideComponent, "East");
            box.add(box2);
        } else {
            box.add((Component)label, "West");
            box.add((Component)this.video, "Center");
        }
        this.video.setVisible(false);
        box.setAlignmentX(0.0f);
        return box;
    }

    public static Box createTitleBoxForVideoMenu(String title, Component rightSideComponent) {
        Box box = Box.createVerticalBox();
        JLabel label = new JLabel(title);
        label.setAlignmentX(0.0f);
        label.setBackground(NBOConfig.titleColor);
        label.setForeground(Color.white);
        label.setFont(NBOConfig.titleFont);
        label.setOpaque(true);
        if (rightSideComponent != null) {
            JPanel box2 = new JPanel(new BorderLayout());
            box2.setAlignmentX(0.0f);
            box2.add((Component)label, "West");
            box2.add(rightSideComponent, "East");
            box2.setMaximumSize(new Dimension(400, 25));
            box.add(box2);
        } else {
            box.add((Component)label, "West");
        }
        box.setAlignmentX(0.0f);
        return box;
    }

    private NBOFileHandler getFileHandlerForVideo(int mode) {
        NBOFileHandler fileHandler = null;
        if (mode == 0) {
            fileHandler = new NBOFileHandler("", "", 6, "script", this.dialog){

                @Override
                protected boolean doFileBrowsePressed() {
                    int button;
                    String folder = this.tfDir.getText().trim();
                    String name = this.tfName.getText();
                    String ext = this.tfExt.getText().trim();
                    if (name.length() == 0) {
                        name = "*";
                    }
                    if (ext.length() == 0) {
                        ext = "script";
                    }
                    folder = NBOUtil.getWindowsFullNameFor(folder, name, ext);
                    JFileChooser myChooser = new JFileChooser();
                    this.useExt = ext.equals("") ? "script" : ext;
                    NBOView.this.videoInputFileType = "script";
                    String filter = this.useExt;
                    myChooser.setFileFilter(new FileNameExtensionFilter(filter, filter));
                    myChooser.setFileHidingEnabled(true);
                    if (folder.endsWith("/")) {
                        folder = folder + "*.*";
                    }
                    if (!folder.equals("")) {
                        myChooser.setSelectedFile(new File(folder));
                    }
                    if ((button = myChooser.showDialog(this, GT.$("Select"))) == 0) {
                        if (PT.isOneOf(NBOView.this.videoInputFileType, "script")) {
                            File newFile = myChooser.getSelectedFile();
                            if (newFile.toString().indexOf(".") < 0) {
                                this.dialog.logError("File not found");
                                NBOView.this.validScriptFilePath = false;
                                return false;
                            }
                            NBOView.this.scriptVideoPath = newFile.getAbsolutePath();
                            this.jobStem = NBOUtil.getJobStem(newFile);
                            this.tfName.setText(this.jobStem);
                            this.dialog.inputFileHandler.setInput(this.fullFilePath, this.jobStem, NBOUtil.getExt(newFile));
                            NBOView.this.validScriptFilePath = true;
                            return true;
                        }
                        this.dialog.logError("Invalid input file type defined");
                    }
                    NBOView.this.validScriptFilePath = false;
                    return false;
                }
            };
        } else if (mode == 1) {
            fileHandler = new NBOFileHandler("", "", 6, "gif", this.dialog){

                @Override
                protected boolean doFileBrowsePressed() {
                    int button;
                    String folder = this.tfDir.getText().trim();
                    String name = this.tfName.getText();
                    String ext = this.tfExt.getText().trim();
                    if (name.length() == 0) {
                        name = "*";
                    }
                    if (ext.length() == 0) {
                        ext = "gif";
                    }
                    folder = NBOUtil.getWindowsFullNameFor(folder, name, ext);
                    JFileChooser myChooser = new JFileChooser();
                    String filter = this.useExt = ext.equals("") ? "gif" : ext;
                    myChooser.setFileFilter(new FileNameExtensionFilter(filter, filter));
                    myChooser.setFileHidingEnabled(true);
                    if (folder.endsWith("/")) {
                        folder = folder + "*.*";
                    }
                    if (!folder.equals("")) {
                        myChooser.setSelectedFile(new File(folder));
                    }
                    if ((button = myChooser.showDialog(this, GT.$("Select"))) == 0) {
                        if (PT.isOneOf(this.useExt, "gif")) {
                            File newFile = myChooser.getSelectedFile();
                            if (newFile.toString().indexOf(".") < 0) {
                                this.dialog.logError("File not found");
                                NBOView.this.validGifFilePath = false;
                                return false;
                            }
                            this.jobStem = NBOUtil.getJobStem(newFile);
                            this.tfName.setText(this.jobStem);
                            this.dialog.inputFileHandler.setInput(this.fullFilePath, this.jobStem, NBOUtil.getExt(newFile));
                            NBOView.this.gifVideoPath = newFile.getAbsolutePath();
                            NBOView.this.validGifFilePath = true;
                            return true;
                        }
                        this.dialog.logError("Invalid input file type defined. Only gif file is accepted.");
                    }
                    NBOView.this.validGifFilePath = false;
                    return false;
                }
            };
        }
        return fileHandler;
    }

    private void createDropDownMenuForGIFCreation() {
        String[] frameRate = new String[]{"Select frames/sec", "20", "40", "60", "80", "100"};
        this.dropDownMenu = new JComboBox<String>(frameRate);
        this.dropDownMenu.setPrototypeDisplayValue("Select frames/sec");
        this.dropDownMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doDropDownMenuAction(NBOView.this.dropDownMenu.getSelectedIndex() > 0 ? NBOView.this.dropDownMenu.getSelectedItem().toString() : "-1");
            }
        });
    }

    private void doDropDownMenuAction(String num) {
        int number = Integer.parseInt(num);
        if (number == -1) {
            this.frameRate = -1;
        } else {
            this.frameRate = 1 / number;
            this.frameRate *= 1000;
        }
    }

    public void doVideo() {
        if (this.videoDialog != null) {
            this.videoDialog.setVisible(true);
            return;
        }
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        Box box = NBOView.createTitleBoxForVideoMenu("Animated GIF Sequence", nBODialog.new NBODialog.HelpBtn("view_video_help.htm"));
        ButtonGroup buttonGroup = new ButtonGroup();
        JLabel scriptFileIn = new JLabel(" Script File");
        scriptFileIn.setFont(NBOConfig.monoFont);
        JLabel gifFileIn = new JLabel(" GIF File");
        gifFileIn.setFont(NBOConfig.monoFont);
        this.validScriptFilePath = false;
        this.validGifFilePath = false;
        final JButton goBtn = new JButton("GO ");
        goBtn.setMinimumSize(new Dimension(60, 30));
        goBtn.setMaximumSize(new Dimension(60, 30));
        goBtn.setPreferredSize(new Dimension(60, 30));
        goBtn.setEnabled(false);
        ActionListener goEnableAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                goBtn.setEnabled(true);
            }
        };
        ButtonGroup bg = new ButtonGroup();
        this.createVideo = new JRadioButton("CREATE frames from script");
        this.createVideo.setSelected(false);
        this.createVideo.addActionListener(goEnableAction);
        this.saveVideo = new JRadioButton("SAVE frames to GIF file");
        this.saveVideo.setSelected(false);
        this.saveVideo.addActionListener(goEnableAction);
        this.playVideo = new JRadioButton("PLAY GIF file as animated video");
        this.playVideo.setSelected(false);
        this.playVideo.addActionListener(goEnableAction);
        bg.add(this.createVideo);
        bg.add(this.saveVideo);
        bg.add(this.playVideo);
        this.scriptVideoFileHandler = this.getFileHandlerForVideo(0);
        this.scriptVideoFileHandler.tfExt.setText("script");
        this.gifVideoFileHandler = this.getFileHandlerForVideo(1);
        this.gifVideoFileHandler.tfExt.setText("gif");
        JPanel fileHandlerPanel = new JPanel(new GridLayout(4, 1, 0, 0));
        fileHandlerPanel.setMaximumSize(new Dimension(400, 175));
        fileHandlerPanel.setPreferredSize(new Dimension(400, 175));
        fileHandlerPanel.setMinimumSize(new Dimension(400, 175));
        fileHandlerPanel.setAlignmentX(0.0f);
        fileHandlerPanel.add(scriptFileIn);
        fileHandlerPanel.add(this.scriptVideoFileHandler);
        fileHandlerPanel.add(gifFileIn);
        fileHandlerPanel.add(this.gifVideoFileHandler);
        this.createDropDownMenuForGIFCreation();
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1, 0, 0));
        buttonPanel.setMaximumSize(new Dimension(250, 150));
        buttonPanel.setPreferredSize(new Dimension(250, 150));
        buttonPanel.setMinimumSize(new Dimension(250, 150));
        buttonPanel.setAlignmentX(0.0f);
        buttonPanel.add(this.createVideo);
        buttonPanel.add(this.saveVideo);
        buttonPanel.add(this.dropDownMenu);
        buttonPanel.add(this.playVideo);
        JPanel goPanel = new JPanel(new BorderLayout());
        goPanel.setMaximumSize(new Dimension(380, 40));
        goPanel.setMinimumSize(new Dimension(380, 40));
        goPanel.setPreferredSize(new Dimension(380, 40));
        goPanel.setAlignmentX(0.0f);
        goPanel.add((Component)goBtn, "East");
        goBtn.setHorizontalAlignment(4);
        goBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doVideoGoPressed();
            }
        });
        Box box2 = Box.createVerticalBox();
        box2.add(fileHandlerPanel);
        box2.add(buttonPanel);
        box.add(box2);
        box2.setAlignmentX(0.0f);
        box.add(goPanel);
        this.videoDialog = new JDialog((Dialog)this.dialog, "Video Menu");
        this.videoDialog.setSize(400, 450);
        this.videoDialog.setVisible(true);
        this.videoDialog.add(box);
        this.centerDialog(this.videoDialog, 200);
    }

    private void doVideoGoPressed() {
        if (this.createVideo.isSelected()) {
            this.createVideo();
        } else if (this.saveVideo.isSelected()) {
            this.saveVideo();
        } else if (this.playVideo.isSelected()) {
            this.playVideo();
        }
        this.videoDialog.setVisible(false);
    }

    private void createVideo() {
        if (!this.validScriptFilePath) {
            this.dialog.logInfo("Error: Invalid path for script file", 2);
            return;
        }
        SB sb = new SB();
        NBOUtil.postAddCmd(sb, "VC " + this.scriptVideoPath);
        this.postNBO_v(sb, 33, -1, null, "Sending video create command..", null, null);
    }

    private File[] finder(String directoryName, String jobstem) {
        int counter = 0;
        this.savevideo_jobstem = jobstem;
        File dir = new File(directoryName);
        File[] bmpFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                String curr_filename = filename.trim();
                return curr_filename.startsWith(NBOView.this.savevideo_jobstem + "_");
            }
        });
        ArrayList<BMP_Files> files = new ArrayList<BMP_Files>();
        for (File file : bmpFiles) {
            files.add(new BMP_Files(file, file.getName()));
            ++counter;
        }
        Collections.sort(files);
        File[] bmps = new File[counter];
        for (int i = 0; i < counter; ++i) {
            bmps[i] = ((BMP_Files)files.get((int)i)).file;
        }
        return bmps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveVideo() {
        String folder = this.gifVideoFileHandler.tfDir.getText().trim();
        String name = this.gifVideoFileHandler.tfName.getText();
        String ext = this.gifVideoFileHandler.tfExt.getText().trim();
        if ((folder.equals("") || name.equals("") || ext.equals("")) && !this.validGifFilePath) {
            this.dialog.logInfo("Error: Invalid path for gif file", 2);
            return;
        }
        if (this.frameRate == -1) {
            this.dialog.logInfo("Error: Please select a framerate", 2);
            return;
        }
        File[] bmpFiles = this.finder(folder, name);
        int timeBetweenFrameInMS = this.frameRate;
        GIFWriter writer = null;
        ImageInputStream output = null;
        int strLength = folder.length();
        if (folder.charAt(strLength - 1) != '/') {
            folder = folder + "/";
        }
        this.gifVideoPath = folder + name + "." + ext;
        try {
            BufferedImage firstImage = ImageIO.read(bmpFiles[0]);
            output = new FileImageOutputStream(new File(this.gifVideoPath));
            writer = new GIFWriter((ImageOutputStream)output, firstImage.getType(), timeBetweenFrameInMS, true);
            writer.writeToSequence(firstImage);
            for (int i = 1; i < bmpFiles.length; ++i) {
                BufferedImage nextImage = ImageIO.read(bmpFiles[i]);
                writer.writeToSequence(nextImage);
            }
        }
        catch (IIOException e1) {
            this.dialog.logInfo("Error creating GIF: " + e1, 2);
        }
        catch (IOException e2) {
            this.dialog.logInfo("Error creating GIF: " + e2, 2);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ioError) {
                this.dialog.logInfo("Fatal Error: Unable to close gifWriter or output stream", 2);
            }
        }
        this.dialog.logValue("GIF file has been successfully created at " + this.gifVideoPath);
    }

    private void playVideo() {
        String folder = this.gifVideoFileHandler.tfDir.getText().trim();
        String name = this.gifVideoFileHandler.tfName.getText();
        String ext = this.gifVideoFileHandler.tfExt.getText().trim();
        if ((folder.equals("") || name.equals("") || ext.equals("")) && !this.validGifFilePath) {
            this.dialog.logInfo("Error: Invalid path for gif file", 2);
            return;
        }
        int strLength = folder.length();
        if (folder.charAt(strLength - 1) != '/') {
            folder = folder + "/";
        }
        this.gifVideoPath = folder + name + "." + ext;
        File file = new File(this.gifVideoPath);
        if (!file.exists()) {
            this.dialog.logInfo("Error: Invalid path for gif file", 2);
            return;
        }
        ImageIcon icon = new ImageIcon(this.gifVideoPath);
        JLabel label = new JLabel(icon);
        JFrame f = new JFrame("Animation");
        f.getContentPane().add(label);
        f.setDefaultCloseOperation(2);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    protected Box createViewSearchJobBox(int mode, boolean isNBOView) {
        Box topBox;
        if (isNBOView) {
            NBODialog nBODialog = this.dialog;
            nBODialog.getClass();
            topBox = this.createTitleBox(" Select Job ", nBODialog.new NBODialog.HelpBtn((mode == 4 ? "search" : "view") + "_job_help.htm"));
        } else {
            NBODialog nBODialog = this.dialog;
            nBODialog.getClass();
            topBox = NBOUtil.createTitleBox(" Select Job ", nBODialog.new NBODialog.HelpBtn((mode == 4 ? "search" : "view") + "_job_help.htm"));
        }
        Box inputBox = NBOUtil.createBorderBox(true);
        inputBox.setPreferredSize(new Dimension(360, 50));
        inputBox.setMaximumSize(new Dimension(360, 50));
        topBox.add(inputBox);
        this.dialog.getNewInputFileHandler(mode);
        inputBox.add(Box.createVerticalStrut(5));
        inputBox.add(this.dialog.inputFileHandler);
        return topBox;
    }

    private Component createBottomBox() {
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        this.bottomBox = NBOUtil.createTitleBox(" Display Type ", nBODialog.new NBODialog.HelpBtn("view_display_help.htm"));
        JPanel profBox = new JPanel(new GridLayout(2, 3, 0, 0));
        profBox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        profBox.setAlignmentX(0.0f);
        ButtonGroup bg = new ButtonGroup();
        this.profileBtn = new JRadioButton("1D Profile");
        this.profileBtn.setToolTipText("Produce profile plot from axis parameters");
        bg.add(this.profileBtn);
        final JButton goBtn = new JButton("GO");
        goBtn.setEnabled(false);
        ActionListener goEnableAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                goBtn.setEnabled(true);
            }
        };
        this.profileBtn.addActionListener(goEnableAction);
        profBox.add(this.profileBtn);
        this.contourBtn = new JRadioButton("2D Contour");
        this.contourBtn.setToolTipText("Produce contour plot from plane parameters");
        profBox.add(this.contourBtn);
        this.contourBtn.addActionListener(goEnableAction);
        bg.add(this.contourBtn);
        this.viewBtn = new JRadioButton("3D view");
        this.viewBtn.addActionListener(goEnableAction);
        bg.add(this.viewBtn);
        profBox.add(this.viewBtn);
        this.vecBox = Box.createHorizontalBox();
        this.vecBox.setAlignmentX(0.0f);
        this.vecBox.setMaximumSize(new Dimension(120, 25));
        profBox.add(this.vecBox);
        this.planeBox = Box.createHorizontalBox();
        this.planeBox.setAlignmentX(0.0f);
        this.planeBox.setMaximumSize(new Dimension(120, 25));
        profBox.add(this.planeBox);
        goBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doGoPressed();
            }
        });
        profBox.add(goBtn);
        this.viewBtn.setSelected(true);
        goBtn.setEnabled(true);
        this.bottomBox.add(profBox);
        this.bottomBox.setVisible(false);
        return this.bottomBox;
    }

    private Component createSelectOrbitalBox() {
        Box horizBox = Box.createHorizontalBox();
        this.betaList = null;
        this.alphaList = null;
        this.comboBasis1 = new JComboBox<String>(basSet);
        this.comboBasis1.setMaximumSize(new Dimension(70, 25));
        horizBox.add(this.comboBasis1);
        this.comboBasis1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBOView.this.comboBasis1.isEnabled()) {
                    NBOView.this.doSetNewBasis(false, true);
                }
            }
        });
        this.betaSpin = new JRadioButton("<html>&#x3B2</html>");
        this.alphaSpin = new JRadioButton("<html>&#x3B1</html>");
        this.alphaSpin.setSelected(true);
        ButtonGroup spinSelection = new ButtonGroup();
        spinSelection.add(this.alphaSpin);
        spinSelection.add(this.betaSpin);
        this.betaSpin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NBOView.this.doSetSpin(NBOView.this.isAlphaSpin() ? null : "beta");
                    }
                });
            }
        });
        this.alphaSpin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NBOView.this.doSetSpin(NBOView.this.isAlphaSpin() ? "alpha" : null);
                    }
                });
            }
        });
        horizBox.add(this.alphaSpin);
        horizBox.add(this.betaSpin);
        this.alphaSpin.setVisible(this.dialog.isOpenShell());
        this.betaSpin.setVisible(this.dialog.isOpenShell());
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        horizBox.add(nBODialog.new NBODialog.HelpBtn("view_orbital_help.htm"));
        return horizBox;
    }

    private Component createOrbitalPanel() {
        JPanel orbPanel = new JPanel(new BorderLayout());
        orbPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.orbScroll = new JScrollPane();
        this.orbScroll.setMaximumSize(new Dimension(355, 400));
        this.orbScroll.getViewport().setMinimumSize(new Dimension(250, 400));
        this.orbScroll.setVerticalScrollBarPolicy(21);
        orbPanel.add((Component)this.orbScroll, "Center");
        orbPanel.setAlignmentX(0.0f);
        orbPanel.add((Component)new JLabel("click to turn up to 9 orbitals on/off; hold to reverse phase"), "South");
        this.newOrbitals();
        return orbPanel;
    }

    protected void doGoPressed() {
        int n = this.orbitals.bsOn.cardinality();
        if (n > 9) {
            this.vwr.alert("More than 9 orbitals are selected!");
            return;
        }
        if (this.orbitals.bsOn.isEmpty()) {
            this.vwr.alert("Pick an orbital to plot.");
            return;
        }
        this.initializeImage();
        if (this.profileBtn.isSelected()) {
            this.createImage1or2D(true);
        } else if (this.contourBtn.isSelected()) {
            this.createImage1or2D(false);
        } else if (this.viewBtn.isSelected()) {
            this.createImage3D();
        }
    }

    protected void doSetSpin(String type) {
        if (type != null) {
            this.dialog.doSetStructure(type);
        }
        if (NBOConfig.nboView) {
            this.dialog.runScriptQueued("select *;color bonds lightgrey");
        }
        this.doSetNewBasis(false, false);
    }

    private File ensurePlotFile(int fileNum) {
        File f;
        if (fileNum == 0) {
            fileNum = 31 + this.comboBasis1.getSelectedIndex();
        }
        if (!(f = this.dialog.inputFileHandler.newNBOFileForExt("" + fileNum)).exists() || f.length() == 0L) {
            this.dialog.runPanel.doRunGenNBOJob("PLOT");
            return null;
        }
        return f;
    }

    protected void doViewPlane() {
        this.viewPlanePt = 0;
        this.dialog.runScriptQueued("set bondpicking false");
        this.viewState = 1;
        Box box = NBOUtil.createTitleBox(" Definiton of Plane ", null);
        JPanel plane = new JPanel(new BorderLayout());
        JPanel labs = new JPanel(new GridLayout(6, 1, 5, 0));
        labs.add(new JLabel("Enter fraction to locate origin:"));
        labs.add(new JLabel("Enter two rotation angles:"));
        labs.add(new JLabel("Enter shift of plane along normal:"));
        labs.add(new JLabel("Enter min and max X values:"));
        labs.add(new JLabel("Enter min and max Y values:"));
        labs.add(new JLabel("Enter number of steps NX:"));
        plane.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(6, 1, 5, 0));
        in.add(this.planeFields[3]);
        Box bo = Box.createHorizontalBox();
        bo.add(this.planeFields[4]);
        bo.add(this.planeFields[5]);
        in.add(bo);
        in.add(this.planeFields[6]);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[7]);
        bo.add(this.planeFields[8]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[9]);
        bo.add(this.planeFields[10]);
        in.add(bo);
        in.add(this.planeFields[11]);
        plane.add((Component)in, "Center");
        JButton b = new JButton("OK");
        plane.add((Component)b, "South");
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(plane);
        box2.setAlignmentX(0.0f);
        box2.setMaximumSize(new Dimension(355, 250));
        box.add(box2);
        final JDialog d = new JDialog((Dialog)this.dialog, "Vector definition");
        d.setSize(new Dimension(300, 300));
        d.setVisible(true);
        d.add(box);
        this.centerDialog(d, 175);
        this.showSelected(this.planeFields);
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBOView.this.dialog.runScriptQueued("select off;set bondpicking true");
                NBOView.this.viewState = 0;
            }
        });
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
                NBOView.this.dialog.runScriptQueued("select off;set bondpicking true");
                NBOView.this.viewState = 0;
            }
        });
        plane.setVisible(true);
    }

    private void showSelected(JTextField[] t) {
        String s = "";
        int i = t.length;
        while (--i >= 0) {
            s = s + " " + t[i].getText();
        }
        this.dialog.showSelected(s);
    }

    protected void doViewAxis() {
        this.dialog.runScriptQueued("set bondpicking false");
        this.viewState = 2;
        this.viewVectorPt = 0;
        Box box = NBOUtil.createTitleBox(" Vector Definition ", null);
        JPanel vect = new JPanel(new BorderLayout());
        JPanel labs = new JPanel(new GridLayout(4, 1, 4, 0));
        labs.add(new JLabel("Enter fraction to locate origin:"));
        labs.add(new JLabel("Enter min and max X values:"));
        labs.add(new JLabel("Enter min and max function values:"));
        labs.add(new JLabel("Enter number of steps NX:"));
        vect.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 4, 0));
        in.add(this.vectorFields[2]);
        Box bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[3]);
        bo.add(this.vectorFields[4]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[5]);
        bo.add(this.vectorFields[6]);
        in.add(bo);
        in.add(this.vectorFields[7]);
        vect.add((Component)in, "Center");
        JButton b = new JButton("OK");
        Box box2 = Box.createVerticalBox();
        vect.add((Component)b, "South");
        vect.setAlignmentX(0.0f);
        box2.setAlignmentX(0.0f);
        box.setAlignmentX(0.0f);
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(vect);
        box2.setMaximumSize(new Dimension(355, 250));
        box.add(box2);
        final JDialog d = new JDialog((Dialog)this.dialog, "Vector definition");
        d.setSize(new Dimension(300, 300));
        d.setVisible(true);
        d.add(box);
        this.centerDialog(d, 150);
        this.showSelected(this.vectorFields);
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBOView.this.dialog.runScriptQueued("select off;set bondpicking true");
                NBOView.this.viewState = 0;
            }
        });
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
                NBOView.this.dialog.runScriptQueued("select off;set bondpicking true");
                NBOView.this.viewState = 0;
            }
        });
    }

    protected void doViewLines() {
        Box box = NBOUtil.createTitleBox(" Contour lines ", null);
        JPanel lines = new JPanel(new BorderLayout());
        JPanel labs = new JPanel(new GridLayout(5, 1, 5, 0));
        labs.add(new JLabel("Enter first contour line:"));
        labs.add(new JLabel("Enter contour step size:"));
        labs.add(new JLabel("Enter number of contours:"));
        labs.add(new JLabel("Enter length of dash (cm):"));
        labs.add(new JLabel("Enter length of space (cm):"));
        lines.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(5, 1, 5, 0));
        in.add(this.lineFields[0]);
        in.add(this.lineFields[1]);
        in.add(this.lineFields[2]);
        in.add(this.lineFields[3]);
        in.add(this.lineFields[4]);
        lines.add((Component)in, "Center");
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(lines);
        box.add(box2);
        box2.setAlignmentX(0.0f);
        final JDialog d = new JDialog((Dialog)this.dialog, "Line settings");
        d.setSize(new Dimension(300, 300));
        d.setVisible(true);
        d.add(box);
        box = NBOUtil.createTitleBox(" Orbital diagram lines ", null);
        lines = new JPanel(new BorderLayout());
        labs = new JPanel(new GridLayout(2, 1, 5, 0));
        labs.add(new JLabel("Enter length of dash (cm):"));
        labs.add(new JLabel("Enter length of space (cm):"));
        lines.add((Component)labs, "West");
        in = new JPanel(new GridLayout(2, 1, 5, 0));
        in.add(this.lineFields[5]);
        in.add(this.lineFields[6]);
        lines.add((Component)in, "Center");
        box2 = Box.createVerticalBox();
        box2.setAlignmentX(0.0f);
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(lines);
        box.add(box2);
        JButton b = new JButton("OK");
        lines.add((Component)b, "South");
        d.add((Component)box, "South");
        this.centerDialog(d, 150);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
                NBOView.this.viewState = 0;
            }
        });
        lines.setVisible(true);
    }

    private void centerDialog(JDialog d, int h) {
        int x = (this.dialog.getX() + this.dialog.getWidth()) / 2 + 150;
        int y = (this.dialog.getY() + this.dialog.getHeight()) / 2 - h;
        d.setLocation(x, y);
    }

    protected void doCam1() {
        this.viewState = 3;
        JPanel panel = new JPanel();
        JPanel cam1 = new JPanel();
        cam1.setLayout(new BorderLayout());
        cam1.setMinimumSize(new Dimension(350, 200));
        cam1.setVisible(true);
        cam1.setBorder(BorderFactory.createLineBorder(Color.black));
        Box box = NBOUtil.createTitleBox(" Camera and Light-Source ", null);
        JPanel labs = new JPanel(new GridLayout(5, 1, 5, 0));
        labs.add(new JLabel("Bounding sphere radius"));
        labs.add(new JLabel("Camera distance from screen center:"));
        labs.add(new JLabel("Two rotation angles (about X, Y):"));
        labs.add(new JLabel("Camera view angle:"));
        labs.add(new JLabel("Lighting (RL, UD, BF w.r.t. camera):"));
        cam1.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(5, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        in.add(this.camFields[52]);
        in.add(this.camFields[0]);
        bo.add(this.camFields[1]);
        bo.add(this.camFields[2]);
        in.add(bo);
        in.add(this.camFields[3]);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[4]);
        bo.add(this.camFields[5]);
        bo.add(this.camFields[6]);
        in.add(bo);
        cam1.add((Component)in, "Center");
        cam1.setAlignmentX(0.0f);
        box.add(cam1);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(box);
        this.cam2(panel);
        this.cam3(panel);
        this.cam4(panel);
        this.cam5(panel);
        JScrollPane sp = new JScrollPane();
        sp.setMaximumSize(new Dimension(350, 500));
        sp.getViewport().add(panel);
        final JDialog d = new JDialog((Dialog)this.dialog, "Camera parameters");
        d.setSize(new Dimension(360, 500));
        d.setVisible(true);
        d.add((Component)sp, "Center");
        this.centerDialog(d, 250);
        JButton b = new JButton("OK");
        d.add((Component)b, "South");
        b.setAlignmentX(0.0f);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
            }
        });
    }

    private void cam2(JPanel panel) {
        Box box = NBOUtil.createTitleBox(" Surface Optical Parameters: ", null);
        JPanel cam2 = new JPanel(new BorderLayout());
        cam2.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(4, 1, 5, 0));
        labs.add(new JLabel("atoms:"));
        labs.add(new JLabel("bonds:"));
        labs.add(new JLabel("H-bonds:"));
        labs.add(new JLabel("orbitals:"));
        cam2.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.camFields[7]);
        bo.add(this.camFields[8]);
        bo.add(this.camFields[9]);
        bo.add(this.camFields[10]);
        bo.add(this.camFields[11]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[12]);
        bo.add(this.camFields[13]);
        bo.add(this.camFields[14]);
        bo.add(this.camFields[15]);
        bo.add(this.camFields[16]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[17]);
        bo.add(this.camFields[18]);
        bo.add(this.camFields[19]);
        bo.add(this.camFields[20]);
        bo.add(this.camFields[21]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[22]);
        bo.add(this.camFields[23]);
        bo.add(this.camFields[24]);
        bo.add(this.camFields[25]);
        bo.add(this.camFields[26]);
        in.add(bo);
        cam2.add((Component)in, "Center");
        cam2.add((Component)new JLabel("                    amb              diff           spec        pow        transp"), "North");
        cam2.setAlignmentX(0.0f);
        box.add(cam2);
        panel.add(box);
    }

    private void cam3(JPanel panel) {
        JPanel cam3 = new JPanel(new BorderLayout());
        Box box = NBOUtil.createTitleBox(" Color (Blue/Green/Red) Parameters: ", null);
        cam3.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(6, 1, 5, 0));
        labs.add(new JLabel("light source color:"));
        labs.add(new JLabel("background color:"));
        labs.add(new JLabel("orbital (+ phase) color:"));
        labs.add(new JLabel("orbital (- phase) color:"));
        labs.add(new JLabel("bond color"));
        labs.add(new JLabel("H-Bond color"));
        cam3.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(6, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.camFields[27]);
        bo.add(this.camFields[28]);
        bo.add(this.camFields[29]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[30]);
        bo.add(this.camFields[31]);
        bo.add(this.camFields[32]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[33]);
        bo.add(this.camFields[34]);
        bo.add(this.camFields[35]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[36]);
        bo.add(this.camFields[37]);
        bo.add(this.camFields[38]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[39]);
        bo.add(this.camFields[40]);
        bo.add(this.camFields[41]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[42]);
        bo.add(this.camFields[43]);
        bo.add(this.camFields[44]);
        in.add(bo);
        cam3.add((Component)in, "Center");
        cam3.add((Component)new JLabel("                                                 Blue               Green             Red"), "North");
        cam3.setAlignmentX(0.0f);
        box.add(cam3);
        panel.add(box);
    }

    private void cam4(JPanel panel) {
        JPanel cam4 = new JPanel(new BorderLayout());
        Box box = NBOUtil.createTitleBox(" Atomic and Bond Radii: ", null);
        cam4.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(4, 1, 5, 0));
        labs.add(new JLabel("Atomic radius for H:"));
        labs.add(new JLabel("Atomic radius for C:"));
        labs.add(new JLabel("Bond radius:"));
        labs.add(new JLabel("H-bond radius:"));
        cam4.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 5, 0));
        in.add(this.camFields[45]);
        in.add(this.camFields[46]);
        in.add(this.camFields[47]);
        in.add(this.camFields[48]);
        cam4.add((Component)in, "Center");
        cam4.setAlignmentX(0.0f);
        box.add(cam4);
        panel.add(box);
    }

    private void cam5(JPanel panel) {
        JPanel cam5 = new JPanel(new BorderLayout());
        Box box = NBOUtil.createTitleBox(" Contour Parameters: ", null);
        cam5.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(3, 1, 5, 0));
        labs.add(new JLabel("Contour value:"));
        labs.add(new JLabel("Contour tolerance:"));
        labs.add(new JLabel("Stepsize:"));
        cam5.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(3, 1, 5, 0));
        in.add(this.camFields[49]);
        in.add(this.camFields[50]);
        in.add(this.camFields[51]);
        cam5.add((Component)in, "Center");
        cam5.setAlignmentX(0.0f);
        box.add(cam5);
        panel.add(box);
    }

    private void newOrbitals() {
        if (this.orbitals != null) {
            this.orbitals.removeListSelectionListener(this.orbitals);
            this.orbitals.removeMouseListener(this.orbitals);
            this.orbScroll.getViewport().remove(this.orbitals);
        }
        this.orbitals = new OrbitalList();
        this.orbScroll.getViewport().add(this.orbitals);
    }

    private void updateViewSettings() {
        this.dialog.viewSettingsBox.removeAll();
        this.dialog.viewSettingsBox.setLayout(new BorderLayout());
        JLabel lab = new JLabel("Settings:");
        lab.setBackground(Color.black);
        lab.setForeground(Color.white);
        lab.setOpaque(true);
        lab.setFont(NBOConfig.nboFont);
        Box middle = Box.createVerticalBox();
        Box tmp = Box.createHorizontalBox();
        tmp.add(new JLabel("Orientation: "));
        this.atomOrient = new JRadioButton("Atoms");
        this.atomOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBOView.this.doViewByAtoms();
            }
        });
        tmp.add(this.atomOrient);
        JRadioButton jmolOrient = new JRadioButton("Jmol");
        jmolOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBOView.this.doViewByJmol();
            }
        });
        tmp.add(jmolOrient);
        ButtonGroup bg = new ButtonGroup();
        bg.add(jmolOrient);
        bg.add(this.atomOrient);
        this.dialog.viewSettingsBox.add((Component)lab, "North");
        middle.add(tmp);
        tmp = Box.createHorizontalBox();
        JButton btnVec = new JButton("Axis");
        JButton btnPla = new JButton("Plane");
        JButton btnLines = new JButton("Lines");
        btnVec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doViewAxis();
            }
        });
        btnPla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doViewPlane();
            }
        });
        btnLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doViewLines();
            }
        });
        btnPla.setMargin(null);
        tmp.add(btnVec);
        tmp.add(btnPla);
        tmp.add(btnLines);
        middle.add(tmp);
        this.dialog.viewSettingsBox.add((Component)middle, "Center");
        JButton btnCam = new JButton("Camera");
        btnCam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doCam1();
            }
        });
        jmolOrient.setSelected(true);
        this.doViewByJmol();
        this.dialog.viewSettingsBox.add((Component)btnCam, "South");
        this.dialog.repaint();
        this.dialog.revalidate();
    }

    protected void doViewByJmol() {
        this.jmolView = true;
    }

    protected void doViewByAtoms() {
        this.dialog.nboService.restartIfNecessary();
        this.setDefaultParameterArrays();
        this.jmolView = false;
    }

    protected File doSetNewBasis(boolean isFileLoading, boolean clearAlphaBeta) {
        DefaultListModel<String> list;
        if (clearAlphaBeta) {
            this.betaList = null;
            this.alphaList = null;
        }
        this.dialog.runScriptQueued("isosurface delete");
        this.resetCurrentOrbitalClicked();
        if (this.comboBasis1.getSelectedIndex() == 9 && !this.dialog.runPanel.cleanNBOKeylist(this.dialog.inputFileHandler.read47File(false)[1], true).contains("CMO")) {
            this.dialog.runPanel.doRunGenNBOJob("CMO");
            return null;
        }
        if (this.orbitals == null) {
            return null;
        }
        this.isNewModel = true;
        this.orbitals.removeAll();
        File f = this.ensurePlotFile(0);
        if (f == null) {
            return null;
        }
        boolean isBeta = this.dialog.isOpenShell() && !this.isAlphaSpin();
        DefaultListModel<String> defaultListModel = list = isBeta ? this.betaList : this.alphaList;
        if (list != null && list.size() > 0) {
            this.orbitals.setModelList(list, false);
            return null;
        }
        list = new DefaultListModel();
        if (isBeta) {
            this.betaList = list;
        } else {
            this.alphaList = list;
        }
        if (isFileLoading) {
            return f;
        }
        this.dialog.logCmd("select " + this.comboBasis1.getSelectedItem() + " " + (isBeta ? "beta" : (this.dialog.isOpenShell() ? "alpha" : "")));
        int ibasis = this.comboBasis1.getSelectedIndex();
        String[] tokens = this.getLabelSet(ibasis, isBeta);
        if (tokens != null) {
            this.orbitals.loadList(tokens, list);
            return f;
        }
        if (this.dialog.jmolOptionNONBO) {
            return f;
        }
        this.postNBO_v(NBOUtil.postAddCmd(this.getMetaHeader(true), "LABEL"), 23, this.getIbasKey(ibasis, isBeta), list, "Getting list", null, null);
        return null;
    }

    protected SB getMetaHeader(boolean addBasis) {
        SB sb = new SB();
        NBOUtil.postAddGlobalC(sb, "PATH", this.dialog.inputFileHandler.inputFile.getParent());
        NBOUtil.postAddGlobalC(sb, "JOBSTEM", this.dialog.inputFileHandler.jobStem);
        if (addBasis) {
            NBOUtil.postAddGlobalI(sb, "BAS_1", 1, this.comboBasis1);
        }
        NBOUtil.postAddGlobalI(sb, "SPIN", !this.dialog.isOpenShell() ? 0 : (this.isAlphaSpin() ? 1 : -1), null);
        return sb;
    }

    private void appendCameraParams(SB sb) {
        int n = this.camFields.length;
        for (int i = 0; i < n; ++i) {
            NBOUtil.postAddGlobalT(sb, "CAMERA_" + this.camFieldIDs[i], this.camFields[i]);
        }
    }

    private void appendOrbitalPhaseSign(SB sb, int i) {
        NBOUtil.postAddGlobal(sb, "SIGN", this.orbitals.bsNeg.get(i) ? "-1" : "+1");
    }

    protected void createImage1or2D(boolean oneD) {
        if (this.jmolView) {
            this.setJmolView(true);
        } else {
            this.setAtomsView();
        }
        if (this.orbitals.bsOn.cardinality() > 1) {
            this.createImage1or2DMultiple(oneD);
            return;
        }
        SB sb = this.getMetaHeader(true);
        int ind = this.orbitals.bsOn.nextSetBit(0);
        this.appendOrbitalPhaseSign(sb, ind);
        this.appendLineParams(sb);
        if (oneD) {
            this.appendVectorParams(sb);
        } else {
            this.appendPlaneParams(sb);
        }
        String cmd = (oneD ? "Profile " : "Contour ") + (ind + 1);
        this.dialog.logCmd(cmd);
        NBOUtil.postAddCmd(sb, cmd);
        this.postNBO_v(sb, 13, -1, null, oneD ? "Profiling.." : "Contouring..", null, null);
    }

    private void appendLineParams(SB sb) {
        for (int i = 0; i < this.lineFields.length; ++i) {
            this.lineVal[i] = this.lineFields[i].getText();
            NBOUtil.postAddGlobal(sb, "LINES_" + (char)(97 + i), this.lineVal[i]);
        }
    }

    private void appendVectorParams(SB sb) {
        for (int i = 0; i < this.vectorFields.length; ++i) {
            this.vecVal[i] = this.vectorFields[i].getText();
            NBOUtil.postAddGlobal(sb, "VECTOR_" + (char)(97 + i), this.vecVal[i]);
        }
    }

    private void appendPlaneParams(SB sb) {
        for (int i = 0; i < this.planeFields.length; ++i) {
            this.plVal[i] = this.planeFields[i].getText();
            NBOUtil.postAddGlobal(sb, "PLANE_" + (char)(97 + i), this.plVal[i]);
        }
    }

    private void setJmolView(boolean is2D) {
        String key = is2D ? "a U" : "a V_U";
        SB sb = new SB();
        for (int i = 1; i <= 3; ++i) {
            String tmp2 = "";
            for (int j = 1; j <= 3; ++j) {
                Object oi = this.vwr.getProperty("string", "orientationInfo.rotationMatrix[" + j + "][" + i + "]", null);
                tmp2 = tmp2 + oi.toString() + " ";
            }
            sb.append(key + i + " " + tmp2 + NBOUtil.sep);
        }
        this.postNBO_v(NBOUtil.postAddCmd(this.getMetaHeader(true), "LABEL"), 0, -1, null, "", "jview.txt", sb.toString());
        this.postNBO_v(NBOUtil.postAddCmd(new SB(), "JVIEW"), 0, -1, null, "Sending Jmol orientation", null, null);
    }

    private void setAtomsView() {
        this.postNBO_v(NBOUtil.postAddCmd(this.getMetaHeader(true), "LABEL"), 0, -1, null, "", null, null);
        this.postNBO_v(NBOUtil.postAddCmd(new SB(), "AVIEW"), 0, -1, null, "Sending Jmol orientation", null, null);
    }

    protected void createImage1or2DMultiple(boolean oneD) {
        SB sb = new SB();
        String msg = oneD ? "Profile" : "Contour";
        String profileList = "";
        int pt = 0;
        int i = this.orbitals.bsOn.nextSetBit(0);
        while (i >= 0) {
            sb = this.getMetaHeader(true);
            this.appendOrbitalPhaseSign(sb, i);
            NBOUtil.postAddCmd(sb, (oneD ? "PROFILE " : "CONTOUR ") + (i + 1));
            msg = msg + " " + (i + 1);
            profileList = profileList + " " + ++pt;
            this.postNBO_v(sb, 0, -1, null, "Sending " + msg, null, null);
            i = this.orbitals.bsOn.nextSetBit(i + 1);
        }
        this.dialog.logCmd(msg);
        sb = this.getMetaHeader(false);
        this.appendLineParams(sb);
        NBOUtil.postAddCmd(sb, "DRAW" + profileList);
        this.postNBO_v(sb, 13, -1, null, "Drawing...", null, null);
    }

    protected void createImage3D() {
        if (this.jmolView) {
            this.postNBO_v(NBOUtil.postAddCmd(this.getMetaHeader(true), "LABEL"), 0, -1, null, "", null, null);
            this.postNBO_v(NBOUtil.postAddCmd(new SB(), "JVIEW"), 0, -1, null, "Sending Jmol orientation", null, null);
        } else {
            this.setAtomsView();
        }
        SB sb = new SB();
        String tmp = "View";
        String list = "";
        BS bs = this.orbitals.bsOn;
        int pt = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            sb = this.getMetaHeader(true);
            this.appendOrbitalPhaseSign(sb, i);
            NBOUtil.postAddCmd(sb, "PROFILE " + (i + 1));
            this.postNBO_v(sb, 0, -1, null, "Sending profile " + (i + 1), null, null);
            tmp = tmp + " " + (i + 1);
            list = list + " " + ++pt;
            i = bs.nextSetBit(i + 1);
        }
        this.dialog.logCmd(tmp);
        String jviewData = sb.toString();
        sb = this.getMetaHeader(false);
        this.appendCameraParams(sb);
        NBOUtil.postAddCmd(sb, "VIEW" + list);
        this.postNBO_v(sb, 13, -1, null, "Raytracing...", null, jviewData);
    }

    private void initializeImage() {
        this.dialog.runScriptQueued("image close");
        this.dialog.nboService.restart();
        this.setDefaultParameterArrays();
        if (this.jmolView) {
            this.setJmolView(false);
        }
    }

    protected void notifyPick_v(int[] picked) {
        this.dialog.runScriptQueued("isosurface delete");
        int at1 = picked[0];
        int at2 = picked[1];
        block0 : switch (this.viewState) {
            case 2: {
                if (at2 != Integer.MIN_VALUE) {
                    return;
                }
                this.vectorFields[this.viewVectorPt++].setText("" + at1);
                this.showSelected(this.vectorFields);
                this.viewVectorPt %= 2;
                break;
            }
            case 1: {
                if (at2 != Integer.MIN_VALUE) {
                    return;
                }
                this.planeFields[this.viewPlanePt++].setText("" + at1);
                this.showSelected(this.planeFields);
                this.viewPlanePt %= 3;
                break;
            }
            case 0: {
                if (at2 == Integer.MIN_VALUE) {
                    this.showOrbital(this.nextOrbitalForAtomPick(at1, (DefaultListModel)this.orbitals.getModel()));
                    return;
                }
                switch (this.comboBasis1.getSelectedIndex()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 9: {
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        String sat1 = this.vwr.ms.at[at1 - 1].getElementSymbol() + at1;
                        String sat2 = this.vwr.ms.at[at2 - 1].getElementSymbol() + at2;
                        this.showOrbital(this.nextOrbitalForBondPick(sat1 + "(" + sat2 + ")", sat2 + "(" + at1 + ")"));
                        break block0;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        String sat1 = this.vwr.ms.at[at1 - 1].getElementSymbol() + at1;
                        String sat2 = this.vwr.ms.at[at2 - 1].getElementSymbol() + at2;
                        this.showOrbital(this.nextOrbitalForBondPick(sat1 + "-" + sat2, sat2 + "-" + sat1));
                    }
                }
            }
        }
    }

    protected int nextOrbitalForAtomPick(int atomno, AbstractListModel<String> list) {
        String at = this.vwr.ms.at[atomno - 1].getElementSymbol() + atomno + "(";
        int curr = this.currOrb.contains(at) ? this.currOrbIndex : -1;
        int size = list.getSize();
        for (int i = curr + 1; i < size + curr; ++i) {
            int ipt = i % size;
            String str = ((String)list.getElementAt(ipt)).replaceAll(" ", "");
            if (!str.contains(at + "lp)") && !str.contains(at + "lv)") && (!this.includeRydberg || !str.contains(at + "ry)"))) continue;
            this.orbitals.setSelectedIndex(ipt);
            this.currOrb = str;
            this.currOrbIndex = ipt;
            return ipt;
        }
        return curr;
    }

    private int nextOrbitalForBondPick(String b1, String b2) {
        int size = this.orbitals.getModel().getSize();
        int curr = this.currOrb.contains(b1) ? this.currOrbIndex : -1;
        for (int i = curr + 1; i < size + curr; ++i) {
            int ipt = i % size;
            String listOrb = (String)this.orbitals.getModel().getElementAt(ipt);
            String str = listOrb.replace(" ", "");
            if (!str.contains(b1) && (b2 == null || !str.contains(b2))) continue;
            this.orbitals.setSelectedIndex(ipt);
            this.currOrb = str;
            this.currOrbIndex = ipt;
            return ipt;
        }
        return curr;
    }

    protected void resetCurrentOrbitalClicked() {
        this.currOrb = "";
        this.currOrbIndex = -1;
    }

    protected void showOrbital(int i) {
        if (i < 0) {
            return;
        }
        this.orbitals.bsOn.clearAll();
        this.orbitals.bsNeg.clearAll();
        this.dialog.runScriptQueued("isosurface * off");
        this.orbitals.updateIsosurfacesInJmol(i);
    }

    protected void notifyList(AbstractListModel<String> list) {
        if (list != null) {
            this.orbitals.setLayoutOrientation(1);
            this.orbitals.requestFocus();
        }
    }

    protected void notifyFileLoaded_v() {
        if (this.vwr.ms.ac == 0) {
            return;
        }
        this.clearLabelSet();
        this.video.setVisible(true);
        if (this.videoDialog != null) {
            this.videoDialog.dispose();
        }
        this.centerBox.setVisible(true);
        this.bottomBox.setVisible(!this.dialog.jmolOptionNONBO);
        Map moData = (Map)this.vwr.getCurrentModelAuxInfo().get("moData");
        String type = this.comboBasis1.getSelectedItem().toString();
        int ibas = this.comboBasis1.getSelectedIndex();
        if (type.charAt(0) == 'P') {
            type = type.substring(1);
        }
        boolean isBeta = this.dialog.isOpenShell() && !this.isAlphaSpin() && this.betaList != null;
        try {
            DefaultListModel<String> list;
            int i;
            boolean needab = this.getIbasKey(ibas, true) != this.getIbasKey(ibas, false);
            this.alphaSpin.setVisible(needab && this.dialog.isOpenShell());
            this.betaSpin.setVisible(needab && this.dialog.isOpenShell());
            this.setDefaultParameterArrays();
            for (i = 0; i < this.planeFields.length; ++i) {
                this.planeFields[i] = new JTextField(this.plVal[i]);
            }
            for (i = 0; i < this.vectorFields.length; ++i) {
                this.vectorFields[i] = new JTextField(this.vecVal[i]);
            }
            for (i = 0; i < this.lineFields.length; ++i) {
                this.lineFields[i] = new JTextField(this.lineVal[i]);
            }
            for (i = 0; i < this.camFields.length; ++i) {
                this.camFields[i] = new JTextField(this.camVal[i]);
            }
            this.vecBox.removeAll();
            this.vecBox.add(new JLabel("Axis: "));
            this.vecBox.add(this.vectorFields[0]);
            this.vecBox.add(this.vectorFields[1]);
            this.planeBox.removeAll();
            this.planeBox.add(new JLabel("Plane: "));
            this.planeBox.add(this.planeFields[0]);
            this.planeBox.add(this.planeFields[1]);
            this.planeBox.add(this.planeFields[2]);
            this.dialog.viewSettingsBox.setVisible(!this.dialog.jmolOptionNONBO);
            DefaultListModel<String> defaultListModel = list = isBeta ? this.betaList : this.alphaList;
            if (this.dialog.jmolOptionNONBO) {
                if (type.startsWith("P")) {
                    type = type.substring(1);
                }
                if (type.equalsIgnoreCase("NLMO")) {
                    type = "NBO";
                }
                String[] a = (String[])((Map)moData.get("nboLabelMap")).get((isBeta ? "beta_" : "") + type);
                list.clear();
                for (int i2 = 0; i2 < a.length; ++i2) {
                    list.addElement(i2 + 1 + ". " + a[i2] + "   ");
                }
            } else {
                this.doSetNewBasis(false, true);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        NBODialog.colorMeshes();
    }

    protected void loadNewFileIfAble() {
        this.dialog.nboService.restart();
        this.comboBasis1.setEnabled(false);
        if (this.comboBasis1.getSelectedIndex() != 9) {
            this.comboBasis1.setSelectedIndex(5);
        } else {
            this.comboBasis1.setSelectedIndex(9);
        }
        this.comboBasis1.setEnabled(true);
        File f = this.doSetNewBasis(true, true);
        if (f == null) {
            return;
        }
        this.dialog.loadModelFileQueued(f, NBOUtil.pathWithoutExtension(f.getAbsolutePath()).equals(NBOUtil.pathWithoutExtension(this.dialog.getJmolFilename())));
    }

    protected void showLewisStructure() {
        this.dialog.doSetStructure(this.isAlphaSpin() ? "alpha" : "beta");
    }

    protected boolean isAlphaSpin() {
        return this.alphaSpin.isSelected() || !this.alphaSpin.isVisible();
    }

    protected void resetView() {
        this.isNewModel = true;
        this.orbitals.clearOrbitals(true);
        this.clearLabelSet();
    }

    private void postNBO_v(SB sb, final int mode, final int ikey, final DefaultListModel<String> list, String statusMessage, String dataFileName, String fileData) {
        final NBORequest req = new NBORequest();
        req.set(new Runnable(){

            @Override
            public void run() {
                NBOView.this.processNBO_v(req, mode, ikey, list);
            }
        }, false, statusMessage, "v_cmd.txt", sb.toString(), dataFileName, fileData);
        if (mode == 33) {
            req.isVideoCreate = true;
        }
        this.dialog.nboService.postToNBO(req);
    }

    protected void processNBO_v(NBORequest req, int mode, int ikey, DefaultListModel<String> list) {
        String[] lines = req.getReplyLines();
        switch (mode) {
            case 23: {
                this.addBasisLabel(ikey, lines);
                this.orbitals.loadList(lines, list);
                break;
            }
            case 13: {
                String fname = this.dialog.inputFileHandler.inputFile.getParent() + "\\" + this.dialog.inputFileHandler.jobStem + ".bmp";
                File f = new File(fname);
                SB title = new SB();
                String id = "id " + PT.esc(title.toString().trim());
                String script = "image " + id + " close;image id \"\" " + PT.esc(f.toString().replace('\\', '/'));
                this.dialog.runScriptQueued(script);
                break;
            }
            case 33: {
                break;
            }
        }
    }

    class OrbitalList
    extends JList<String>
    implements ListSelectionListener,
    MouseListener,
    KeyListener {
        protected BS bsOn = new BS();
        protected BS bsNeg = new BS();
        protected BS bsKnown = new BS();
        private JLabel cellLabel;
        protected boolean myTurn;
        protected boolean toggled;
        private static final int DBLCLICK_THRESHOLD_MS = 300;
        private Timer mouseTimer;

        public OrbitalList() {
            this.setLayoutOrientation(1);
            this.setVisibleRowCount(-1);
            this.setFont(NBOConfig.nboFontLarge);
            this.setFont(NBOConfig.listFont);
            this.setModel(new DefaultListModel<String>(){

                @Override
                public void addElement(String s) {
                    s = s + "   ";
                    super.addElement(s);
                }
            });
            this.setCellRenderer(new ListCellRenderer<String>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                    return OrbitalList.this.renderCell(index);
                }
            });
            this.addListSelectionListener(this);
            this.addMouseListener(this);
        }

        public void loadList(String[] lines, DefaultListModel<String> list) {
            list.clear();
            for (int i = 0; i < lines.length; ++i) {
                list.addElement(lines[i]);
            }
            this.setModelList(list, true);
        }

        void setModelList(DefaultListModel<String> list, boolean isNew) {
            this.setSelectedIndices(new int[0]);
            this.setModel(list);
            this.clearOrbitals(true);
            NBOView.this.showLewisStructure();
            this.updateIsosurfacesInJmol(Integer.MIN_VALUE);
        }

        protected Component renderCell(int index) {
            if (this.cellLabel == null) {
                this.cellLabel = new JLabel(){

                    @Override
                    public void setBackground(Color bg) {
                        if (OrbitalList.this.myTurn) {
                            super.setBackground(bg);
                        }
                    }
                };
                this.cellLabel.setFont(NBOConfig.listFont);
                this.cellLabel.setMinimumSize(new Dimension(180, 20));
                this.cellLabel.setPreferredSize(new Dimension(180, 20));
                this.cellLabel.setMaximumSize(new Dimension(180, 20));
                this.cellLabel.setOpaque(true);
            }
            this.cellLabel.setText((String)this.getModel().getElementAt(index));
            this.myTurn = true;
            Color bgcolor = !this.bsOn.get(index) ? Color.WHITE : (this.bsNeg.get(index) ? NBOConfig.orbColor2 : NBOConfig.orbColor1);
            this.cellLabel.setBackground(bgcolor);
            this.cellLabel.setForeground(this.getContrastColor(bgcolor));
            this.myTurn = false;
            return this.cellLabel;
        }

        private Color getContrastColor(Color bgcolor) {
            return new AwtColor(C.getArgb(C.getBgContrast(bgcolor.getRGB())));
        }

        void clearOrbitals(boolean clearAll) {
            this.bsKnown.clearAll();
            if (clearAll) {
                this.bsOn.clearAll();
                this.bsNeg.clearAll();
            }
        }

        protected void updateIsosurfacesInJmol(int iClicked) {
            DefaultListModel model = (DefaultListModel)this.getModel();
            boolean isBeta = NBOView.this.betaSpin.isSelected();
            String type = NBOView.this.comboBasis1.getSelectedItem().toString();
            String script = "select 1.1;";
            if (iClicked == Integer.MAX_VALUE) {
                script = script + this.updateBitSetFromModel();
            } else {
                this.updateModelFromBitSet();
            }
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                boolean isOn = this.bsOn.get(i);
                if (i != iClicked && (!isOn || this.bsKnown.get(i)) && this.isSelectedIndex(i) == isOn) continue;
                String id = "mo" + i;
                if (!isOn || this.bsKnown.get(i)) {
                    if (isOn && this.bsNeg.get(i)) {
                        this.bsKnown.clear(i);
                        this.bsNeg.clear(i);
                    }
                    isOn = !isOn;
                    this.bsOn.setBitTo(i, isOn);
                }
                boolean isKnown = this.bsKnown.get(i);
                if (!this.bsOn.get(i)) {
                    script = script + "isosurface mo" + i + " off;";
                    continue;
                }
                if (isKnown) {
                    script = script + "isosurface mo" + i + " on;";
                    continue;
                }
                this.bsKnown.set(i);
                script = script + NBOConfig.getJmolIsosurfaceScript(id, type, i + 1, isBeta, this.bsNeg.get(i));
            }
            this.updateModelFromBitSet();
            NBOView.this.dialog.runScriptQueued(script);
        }

        private String updateBitSetFromModel() {
            int[] a = this.getSelectedIndices();
            BS bsModel = new BS();
            int i = a.length;
            while (--i >= 0) {
                bsModel.set(i);
            }
            String script = "";
            int i2 = this.getModel().getSize();
            while (--i2 >= 0) {
                if (bsModel.get(i2) == this.bsOn.get(i2)) continue;
                if (this.bsOn.get(i2)) {
                    script = script + "isosurface mo" + i2 + " off;";
                    this.bsOn.clear(i2);
                    continue;
                }
                this.bsOn.set(i2);
            }
            return script;
        }

        private void updateModelFromBitSet() {
            int[] a = new int[this.bsOn.cardinality()];
            int i = this.bsOn.nextSetBit(0);
            int pt = 0;
            while (i >= 0) {
                a[pt++] = i;
                i = this.bsOn.nextSetBit(i + 1);
            }
            try {
                this.setSelectedIndices(a);
            }
            catch (Exception e) {
                System.out.println("render error " + e);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.killMouseTimer();
            this.mouseTimer = this.getMouseTimer();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.killMouseTimer();
            int i = this.getSelectedIndex();
            this.toggled = false;
            this.updateIsosurfacesInJmol(i);
        }

        private void killMouseTimer() {
            if (this.mouseTimer != null) {
                this.mouseTimer.stop();
            }
            this.mouseTimer = null;
            this.toggled = false;
        }

        private Timer getMouseTimer() {
            Timer t = new Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrbitalList.this.doHoldTimerEvent();
                }
            });
            t.setRepeats(false);
            t.start();
            System.out.println("timer started");
            return t;
        }

        protected void doHoldTimerEvent() {
            int i = this.getSelectedIndex();
            if (this.bsOn.get(i)) {
                this.toggled = true;
                this.bsNeg.setBitTo(i, !this.bsNeg.get(i));
                this.bsKnown.clear(i);
                this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.updateIsosurfacesInJmol(Integer.MAX_VALUE);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class BMP_Files
    implements Comparable<BMP_Files> {
        public File file;
        public String filename;

        public BMP_Files(File file, String filename) {
            this.file = file;
            this.filename = filename;
        }

        @Override
        public int compareTo(BMP_Files other) {
            return this.filename.compareTo(other.filename);
        }
    }
}

