/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.OsmIdSelectionDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class HistoryInfoAction
extends JosmAction {
    public HistoryInfoAction() {
        super(I18n.tr("History", new Object[0]), "dialogs/history", I18n.tr("Display history information about OSM ways, nodes, or relations.", new Object[0]), Shortcut.registerShortcut("core:historyinfo", I18n.tr("History", new Object[0]), 72, 5006), false);
        this.putValue("help", HelpUtil.ht("/Action/ObjectHistory"));
        this.putValue("toolbar", "action/historyinfo");
        MainApplication.getToolbar().register(this);
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        OsmData<?, ?, ?, ?> set = this.getLayerManager().getActiveData();
        if (set != null && !set.selectionEmpty()) {
            HistoryBrowserDialogManager.getInstance().showHistory(set.getAllSelected());
        } else {
            HistoryObjectIDDialog dialog = new HistoryObjectIDDialog();
            if (dialog.showDialog().getValue() == dialog.getContinueButtonIndex()) {
                HistoryBrowserDialogManager.getInstance().showHistory(dialog.getOsmIds());
            }
        }
    }

    public static class HistoryObjectIDDialog
    extends OsmIdSelectionDialog {
        public HistoryObjectIDDialog() {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Show history", new Object[0]), I18n.tr("Show history", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.setButtonIcons("dialogs/history", "cancel");
            this.init();
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            ((JButton)this.buttons.get(0)).setEnabled(!NetworkManager.isOffline(OnlineResource.OSM_API));
        }
    }
}

