/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class HelpAction
extends AbstractAction {
    private final JTable tagTable;
    private final IntFunction<String> tagKeySupplier;
    private final IntFunction<Map<String, Integer>> tagValuesSupplier;
    private final JTable membershipTable;
    private final IntFunction<IRelation<?>> memberValueSupplier;

    public HelpAction(JTable tagTable, IntFunction<String> tagKeySupplier, IntFunction<Map<String, Integer>> tagValuesSupplier, JTable membershipTable, IntFunction<IRelation<?>> memberValueSupplier) {
        this.tagTable = Objects.requireNonNull(tagTable);
        this.tagKeySupplier = Objects.requireNonNull(tagKeySupplier);
        this.tagValuesSupplier = Objects.requireNonNull(tagValuesSupplier);
        this.membershipTable = membershipTable;
        this.memberValueSupplier = memberValueSupplier;
        this.putValue("Name", I18n.tr("Go to OSM wiki for tag help", new Object[0]));
        this.putValue("ShortDescription", I18n.tr("Launch browser with wiki help for selected object", new Object[0]));
        new ImageProvider("dialogs", "search").getResource().attachImageIcon(this, true);
        this.putValue("AcceleratorKey", this.getKeyStroke());
    }

    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(112, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String base = Config.getPref().get("url.openstreetmap-wiki", "https://wiki.openstreetmap.org/wiki/");
            String lang = LanguageInfo.getWikiLanguagePrefix();
            ArrayList<URI> uris = new ArrayList<URI>();
            if (this.tagTable.getSelectedRowCount() == 1) {
                int row = this.tagTable.getSelectedRow();
                String key = Utils.encodeUrl(this.tagKeySupplier.apply(row));
                Map<String, Integer> m = this.tagValuesSupplier.apply(row);
                if (!m.isEmpty()) {
                    String val = Utils.encodeUrl(m.entrySet().iterator().next().getKey());
                    uris.addAll(HelpAction.getTagURIs(base, lang, key, val));
                }
            } else if (this.membershipTable != null && this.membershipTable.getSelectedRowCount() == 1) {
                int row = this.membershipTable.getSelectedRow();
                uris.addAll(HelpAction.getRelationURIs(base, lang, this.memberValueSupplier.apply(row)));
            } else {
                uris.addAll(HelpAction.getGenericURIs(base, lang));
            }
            MainApplication.worker.execute(() -> HelpAction.displayHelp(uris));
        }
        catch (URISyntaxException e1) {
            Logging.error(e1);
        }
    }

    public static List<URI> getTagURIs(String base, String lang, String key, String val) throws URISyntaxException {
        return Arrays.asList(new URI(String.format("%s%sTag:%s=%s", base, lang, key, val)), new URI(String.format("%sTag:%s=%s", base, key, val)), new URI(String.format("%s%sKey:%s", base, lang, key)), new URI(String.format("%sKey:%s", base, key)), new URI(String.format("%s%sMap_Features", base, lang)), new URI(String.format("%sMap_Features", base)));
    }

    public static List<URI> getRelationURIs(String base, String lang, IRelation<?> rel) throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>();
        String type = rel.get("type");
        if (type != null) {
            type = Utils.encodeUrl(type);
        }
        if (type != null && !type.isEmpty()) {
            uris.add(new URI(String.format("%s%sRelation:%s", base, lang, type)));
            uris.add(new URI(String.format("%sRelation:%s", base, type)));
        }
        uris.add(new URI(String.format("%s%sRelations", base, lang)));
        uris.add(new URI(String.format("%sRelations", base)));
        return uris;
    }

    public static List<URI> getGenericURIs(String base, String lang) throws URISyntaxException {
        return Arrays.asList(new URI(String.format("%s%sMap_Features", base, lang)), new URI(String.format("%sMap_Features", base)));
    }

    public static void displayHelp(List<URI> uris) {
        try {
            for (URI u : uris) {
                HttpClient.Response conn = HttpClient.create(u.toURL(), "HEAD").connect();
                if (conn.getResponseCode() != 200) {
                    conn.disconnect();
                    continue;
                }
                long osize = conn.getContentLength();
                if (osize > -1L) {
                    conn.disconnect();
                    URI newURI = new URI(u.toString().replace("=", "%3D").replaceFirst("/wiki/", "/w/index.php?redirect=no&title="));
                    conn = HttpClient.create(newURI.toURL(), "HEAD").connect();
                }
                if (osize > -1L && conn.getContentLength() != -1L && Math.abs(conn.getContentLength() - osize) > 200L) {
                    Logging.info("{0} is a mediawiki redirect", u);
                    conn.disconnect();
                    continue;
                }
                conn.disconnect();
                OpenBrowser.displayUrl(u.toString());
                break;
            }
        }
        catch (IOException | URISyntaxException e1) {
            Logging.error(e1);
        }
    }
}

