/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerHistoryReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class HistoryLoadTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private final Set<PrimitiveId> toLoad = new HashSet<PrimitiveId>();
    private HistoryDataSet loadedData;
    private OsmServerHistoryReader reader;

    public HistoryLoadTask() {
        super(I18n.tr("Load history", new Object[0]), true);
    }

    public HistoryLoadTask(Component parent) {
        super(parent, I18n.tr("Load history", new Object[0]), true);
        CheckParameterUtil.ensureParameterNotNull(parent, "parent");
    }

    public HistoryLoadTask add(PrimitiveId pid) {
        CheckParameterUtil.ensure(pid, "pid", "pid > 0", id -> id.getUniqueId() > 0L);
        this.toLoad.add(pid);
        return this;
    }

    public HistoryLoadTask add(HistoryOsmPrimitive primitive) {
        CheckParameterUtil.ensureParameterNotNull(primitive, "primitive");
        return this.add(primitive.getPrimitiveId());
    }

    public HistoryLoadTask add(History history) {
        CheckParameterUtil.ensureParameterNotNull(history, "history");
        return this.add(history.getPrimitiveId());
    }

    public HistoryLoadTask add(OsmPrimitive primitive) {
        CheckParameterUtil.ensure(primitive, "primitive", "id > 0", prim -> prim.getOsmId() > 0L);
        return this.add(primitive.getOsmPrimitiveId());
    }

    public HistoryLoadTask add(Collection<? extends OsmPrimitive> primitives) {
        CheckParameterUtil.ensureParameterNotNull(primitives, "primitives");
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive == null) continue;
            this.add(osmPrimitive);
        }
        return this;
    }

    @Override
    protected void cancel() {
        if (this.reader != null) {
            this.reader.cancel();
        }
        this.canceled = true;
    }

    @Override
    protected void finish() {
        if (this.isCanceled()) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        HistoryDataSet.getInstance().mergeInto(this.loadedData);
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.loadedData = new HistoryDataSet();
        try {
            this.progressMonitor.setTicksCount(this.toLoad.size());
            for (PrimitiveId pid : this.toLoad) {
                if (!this.canceled) {
                    this.loadHistory(pid);
                    continue;
                }
                break;
            }
        }
        catch (OsmTransferException e) {
            this.lastException = e;
        }
    }

    private void loadHistory(PrimitiveId pid) throws OsmTransferException {
        HistoryDataSet ds;
        String msg = HistoryLoadTask.getLoadingMessage(pid);
        this.progressMonitor.indeterminateSubTask(I18n.tr(msg, Long.toString(pid.getUniqueId())));
        this.reader = null;
        try {
            this.reader = new OsmServerHistoryReader(pid.getType(), pid.getUniqueId());
            ds = HistoryLoadTask.loadHistory(this.reader, this.progressMonitor);
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            throw e;
        }
        this.loadedData.mergeInto(ds);
    }

    protected static HistoryDataSet loadHistory(OsmServerHistoryReader reader, ProgressMonitor progressMonitor) throws OsmTransferException {
        HistoryDataSet ds = reader.parseHistory(progressMonitor.createSubTaskMonitor(1, false));
        if (ds != null) {
            OsmServerChangesetReader changesetReader = new OsmServerChangesetReader();
            ArrayList<Long> changesetIds = new ArrayList<Long>(ds.getChangesetIds());
            int n = 100;
            for (int i = 0; i < changesetIds.size(); i += n) {
                for (Changeset c : changesetReader.queryChangesets(new ChangesetQuery().forChangesetIds(changesetIds.subList(i, Math.min(i + n, changesetIds.size()))), progressMonitor.createSubTaskMonitor(1, false))) {
                    ds.putChangeset(c);
                }
            }
        }
        return ds;
    }

    protected static String getLoadingMessage(PrimitiveId pid) {
        switch (pid.getType()) {
            case NODE: {
                return I18n.marktr("Loading history for node {0}");
            }
            case WAY: {
                return I18n.marktr("Loading history for way {0}");
            }
            case RELATION: {
                return I18n.marktr("Loading history for relation {0}");
            }
        }
        return "";
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

