"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const debug_1 = require("debug");
const debug = debug_1.default('axm:coverageaction');
const coverage_1 = require("../features/coverage");
const miscellaneous_1 = require("../utils/miscellaneous");
const transport_1 = require("../utils/transport");
const file_1 = require("../utils/file");
class CoverageAction {
    constructor(actionFeature) {
        this.actionFeature = actionFeature;
    }
    init() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.coverageFeature = new coverage_1.default();
            try {
                yield this.coverageFeature.init();
                // expose actions only if the feature is available
                this.exposeActions();
            }
            catch (err) {
                debug(`Failed to load coverage profiler: ${err.message}`);
            }
        });
    }
    destroy() {
        if (this.coverageFeature)
            this.coverageFeature.destroy();
    }
    stopCoverage(reply) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const dumpFile = yield this.coverageFeature.stop();
                let size;
                try {
                    size = yield file_1.default.getFileSize(dumpFile);
                }
                catch (err) {
                    size = -1;
                }
                return reply({
                    success: true,
                    coverage: true,
                    dump_file: dumpFile,
                    dump_file_size: size,
                    uuid: this.uuid
                });
            }
            catch (err) {
                return reply({
                    success: false,
                    err: err,
                    uuid: this.uuid
                });
            }
        });
    }
    exposeActions() {
        this.actionFeature.action('km:coverage:start', (opts, reply) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!reply) {
                reply = opts;
                opts = {};
            }
            try {
                this.uuid = miscellaneous_1.default.generateUUID();
                yield this.coverageFeature.start(opts);
                reply({ success: true, uuid: this.uuid });
                if (opts.timeout && typeof opts.timeout === 'number') {
                    setTimeout((_) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const reply = (data) => transport_1.default.send({
                            type: 'axm:reply',
                            data: {
                                return: data,
                                action_name: 'km:coverage:stop'
                            }
                        });
                        yield this.stopCoverage(reply);
                    }), opts.timeout);
                }
            }
            catch (err) {
                return reply({
                    success: false,
                    err: err,
                    uuid: this.uuid
                });
            }
        }));
        this.actionFeature.action('km:coverage:stop', this.stopCoverage.bind(this));
    }
}
exports.default = CoverageAction;
//# sourceMappingURL=data:application/json;base64,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