/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.Current;
import Ice.DispatchInterceptorAsyncCallback;
import Ice.EncodingVersion;
import Ice.FacetNotExistException;
import Ice.FormatType;
import Ice.InputStream;
import Ice.Instrumentation.CommunicatorObserver;
import Ice.LocalObjectHolder;
import Ice.MarshalException;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.OperationMode;
import Ice.Request;
import Ice.ResponseSentException;
import IceInternal.IncomingAsync;
import IceInternal.IncomingBase;
import IceInternal.Instance;
import IceInternal.ResponseHandler;
import IceInternal.ServantError;
import IceInternal.ServantManager;
import java.util.HashMap;
import java.util.LinkedList;

public final class Incoming
extends IncomingBase
implements Request {
    public Incoming next;
    private InputStream _is;
    private IncomingAsync _inAsync;
    private int _inParamPos = -1;

    public Incoming(Instance instance, ResponseHandler responseHandler, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        super(instance, responseHandler, connection, adapter, response, compress, requestId);
    }

    @Override
    public Current getCurrent() {
        return this._current;
    }

    @Override
    public void reclaim() {
        super.reclaim();
        this._inAsync = null;
        this._inParamPos = -1;
    }

    public final void push(DispatchInterceptorAsyncCallback cb) {
        if (this._interceptorCBs == null) {
            this._interceptorCBs = new LinkedList();
        }
        this._interceptorCBs.addFirst(cb);
    }

    public final void pop() {
        assert (this._interceptorCBs != null);
        this._interceptorCBs.removeFirst();
    }

    public final void startOver() {
        if (this._inParamPos == -1) {
            this._inParamPos = this._is.pos();
        } else {
            if (this._inAsync != null) {
                this._inAsync.kill(this);
                this._inAsync = null;
            }
            this._os = null;
            this._is.pos(this._inParamPos);
        }
    }

    public void setAsync(IncomingAsync inAsync) {
        assert (this._inAsync == null);
        this._inAsync = inAsync;
    }

    public void setFormat(FormatType format) {
        this._format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(ServantManager servantManager, InputStream stream) {
        this._is = stream;
        int start = this._is.pos();
        this._current.id.ice_readMembers(this._is);
        String[] facetPath = this._is.readStringSeq();
        if (facetPath.length > 0) {
            if (facetPath.length > 1) {
                throw new MarshalException();
            }
            this._current.facet = facetPath[0];
        } else {
            this._current.facet = "";
        }
        this._current.operation = this._is.readString();
        this._current.mode = OperationMode.values()[this._is.readByte()];
        this._current.ctx = new HashMap<String, String>();
        int sz = this._is.readSize();
        while (sz-- > 0) {
            String first = this._is.readString();
            String second = this._is.readString();
            this._current.ctx.put(first, second);
        }
        CommunicatorObserver obsv = this._instance.initializationData().observer;
        if (obsv != null) {
            int size = this._is.readInt();
            this._is.pos(this._is.pos() - 4);
            this._observer = obsv.getDispatchObserver(this._current, this._is.pos() - start + size);
            if (this._observer != null) {
                this._observer.attach();
            }
        }
        if (servantManager != null) {
            this._servant = servantManager.findServant(this._current.id, this._current.facet);
            if (this._servant == null) {
                this._locator = servantManager.findServantLocator(this._current.id.category);
                if (this._locator == null && this._current.id.category.length() > 0) {
                    this._locator = servantManager.findServantLocator("");
                }
                if (this._locator != null) {
                    try {
                        if (this._cookie == null) {
                            this._cookie = new LocalObjectHolder();
                        }
                        assert (this._cookie.value == null);
                        this._servant = this._locator.locate(this._current, this._cookie);
                    }
                    catch (Throwable ex) {
                        this.skipReadParams();
                        this.handleException(ex, false);
                        return;
                    }
                }
            }
        }
        if (this._servant == null) {
            try {
                if (servantManager != null && servantManager.hasServant(this._current.id)) {
                    throw new FacetNotExistException(this._current.id, this._current.facet, this._current.operation);
                }
                throw new ObjectNotExistException(this._current.id, this._current.facet, this._current.operation);
            }
            catch (Exception ex) {
                this.skipReadParams();
                this.handleException(ex, false);
                return;
            }
        }
        try {
            if (this._instance.useApplicationClassLoader()) {
                Thread.currentThread().setContextClassLoader(this._servant.getClass().getClassLoader());
            }
            this._servant._iceDispatch(this, this._current);
            if (this._inAsync == null) {
                this.response(false);
            }
        }
        catch (Throwable ex) {
            if (this._inAsync != null) {
                try {
                    this._inAsync.kill(this);
                    this._inAsync = null;
                }
                catch (ResponseSentException exc) {
                    if (ex instanceof Error) {
                        throw new ServantError((Error)ex);
                    }
                    if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                        this.warning(ex);
                    }
                    return;
                }
            }
            this.exception(ex, false);
        }
        finally {
            if (this._instance.useApplicationClassLoader()) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public final InputStream startReadParams() {
        this._current.encoding = this._is.startEncapsulation();
        return this._is;
    }

    public final void endReadParams() {
        this._is.endEncapsulation();
    }

    public final void readEmptyParams() {
        this._current.encoding = this._is.skipEmptyEncapsulation();
    }

    public final void skipReadParams() {
        this._current.encoding = this._is.skipEncapsulation();
    }

    public final byte[] readParamEncaps() {
        this._current.encoding = new EncodingVersion();
        return this._is.readEncapsulation(this._current.encoding);
    }
}

