/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.CommunicatorI;
import Ice.Properties;
import IceInternal.Instance;
import IceInternal.ProtocolPluginFacade;
import IceInternal.ProtocolPluginFacadeI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ThreadFactory;

public final class Util {
    static String createThreadName(Properties properties, String name) {
        String threadName = properties.getProperty("Ice.ProgramName");
        if (threadName.length() > 0) {
            threadName = threadName + "-";
        }
        threadName = threadName + name;
        return threadName;
    }

    static ThreadFactory createThreadFactory(final Properties properties, final String name) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(name);
                if (properties.getProperty("Ice.ThreadPriority").length() > 0) {
                    t.setPriority(Util.getThreadPriorityProperty(properties, "Ice"));
                }
                return t;
            }
        };
    }

    public static Instance getInstance(Communicator communicator) {
        CommunicatorI p = (CommunicatorI)communicator;
        return p.getInstance();
    }

    public static ProtocolPluginFacade getProtocolPluginFacade(Communicator communicator) {
        return new ProtocolPluginFacadeI(communicator);
    }

    public static InputStream openResource(ClassLoader cl, String path) throws IOException {
        InputStream stream = null;
        try {
            stream = cl.getResourceAsStream(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (stream == null) {
            try {
                File f = new File(path);
                if (f.exists()) {
                    stream = new FileInputStream(f);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return stream;
    }

    public static Class<?> findClass(String className, ClassLoader cl) throws LinkageError {
        Class<?> c = null;
        if (cl != null) {
            c = Util.loadClass(className, cl);
        }
        if (c == null) {
            try {
                cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    c = Util.loadClass(className, cl);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            if (c == null) {
                c = Class.forName(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
                if (cl != null) {
                    c = Util.loadClass(className, cl);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return c;
    }

    private static Class<?> loadClass(String className, ClassLoader cl) {
        if (cl != null) {
            try {
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getThreadPriorityProperty(Properties properties, String prefix) {
        String pri = properties.getProperty(prefix + ".ThreadPriority");
        if (pri.equals("MIN_PRIORITY") || pri.equals("java.lang.Thread.MIN_PRIORITY")) {
            return 1;
        }
        if (pri.equals("NORM_PRIORITY") || pri.equals("java.lang.Thread.NORM_PRIORITY")) {
            return 5;
        }
        if (pri.equals("MAX_PRIORITY") || pri.equals("java.lang.Thread.MAX_PRIORITY")) {
            return 10;
        }
        try {
            return Integer.parseInt(pri);
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
    }

    public static String typeIdToClassName(String typeId) {
        if (!typeId.startsWith("::")) {
            return null;
        }
        StringBuilder buf = new StringBuilder(typeId.length());
        int start = 2;
        boolean done = false;
        while (!done) {
            String s;
            int end = typeId.indexOf(58, start);
            if (end != -1) {
                s = typeId.substring(start, end);
                start = end + 2;
            } else {
                s = typeId.substring(start);
                done = true;
            }
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(Util.fixKwd(s));
        }
        return buf.toString();
    }

    private static String fixKwd(String name) {
        Object[] keywordList = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "checkedCast", "class", "clone", "const", "continue", "default", "do", "double", "else", "enum", "equals", "extends", "false", "final", "finalize", "finally", "float", "for", "getClass", "goto", "hashCode", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "notify", "notifyAll", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "toString", "transient", "true", "try", "uncheckedCast", "void", "volatile", "wait", "while"};
        boolean found = Arrays.binarySearch(keywordList, name) >= 0;
        return found ? "_" + name : name;
    }

    public static boolean isAndroid() {
        return System.getProperty("java.vm.name").startsWith("Dalvik");
    }
}

