/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public final class Util {
    public static final String jdkTarget = "1.5";

    public static X509Certificate createCertificate(String certPEM) throws CertificateException {
        String header = "-----BEGIN CERTIFICATE-----";
        String footer = "-----END CERTIFICATE-----";
        int pos = certPEM.indexOf("-----BEGIN CERTIFICATE-----");
        if (pos == -1) {
            certPEM = "-----BEGIN CERTIFICATE-----\n" + certPEM;
        } else if (pos > 0) {
            certPEM = certPEM.substring(pos);
        }
        if (certPEM.indexOf("-----END CERTIFICATE-----") == -1) {
            certPEM = certPEM + "-----END CERTIFICATE-----";
        }
        byte[] bytes = null;
        try {
            bytes = certPEM.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            assert (false);
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(in);
    }

    public static void main(String[] args) {
        System.out.println(jdkTarget);
    }
}

