/*
 * Decompiled with CFR 0.152.
 */
package IceStorm;

import Ice.Current;
import Ice.Identity;
import Ice.IdentitySeqHelper;
import Ice.InputStream;
import Ice.ObjectImpl;
import Ice.ObjectPrx;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.OutputStream;
import Ice.UserException;
import IceInternal.Incoming;
import IceStorm.AlreadySubscribed;
import IceStorm.BadQoS;
import IceStorm.InvalidSubscriber;
import IceStorm.LinkExists;
import IceStorm.LinkInfo;
import IceStorm.LinkInfoSeqHelper;
import IceStorm.NoSuchLink;
import IceStorm.QoSHelper;
import IceStorm.Topic;
import IceStorm.TopicPrx;
import IceStorm.TopicPrxHelper;
import java.util.Arrays;
import java.util.Map;

public abstract class _TopicDisp
extends ObjectImpl
implements Topic {
    private static final String[] _ids = new String[]{"::Ice::Object", "::IceStorm::Topic"};
    private static final String[] _all = new String[]{"destroy", "getLinkInfoSeq", "getName", "getNonReplicatedPublisher", "getPublisher", "getSubscribers", "ice_id", "ice_ids", "ice_isA", "ice_ping", "link", "subscribeAndGetPublisher", "unlink", "unsubscribe"};
    public static final long serialVersionUID = 0L;

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(_ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current current) {
        return Arrays.binarySearch(_ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return _ids;
    }

    @Override
    public String[] ice_ids(Current current) {
        return _ids;
    }

    @Override
    public String ice_id() {
        return _ids[1];
    }

    @Override
    public String ice_id(Current current) {
        return _ids[1];
    }

    public static String ice_staticId() {
        return _ids[1];
    }

    @Override
    public final void destroy() {
        this.destroy(null);
    }

    @Override
    public final LinkInfo[] getLinkInfoSeq() {
        return this.getLinkInfoSeq(null);
    }

    @Override
    public final String getName() {
        return this.getName(null);
    }

    @Override
    public final ObjectPrx getNonReplicatedPublisher() {
        return this.getNonReplicatedPublisher(null);
    }

    @Override
    public final ObjectPrx getPublisher() {
        return this.getPublisher(null);
    }

    @Override
    public final Identity[] getSubscribers() {
        return this.getSubscribers(null);
    }

    @Override
    public final void link(TopicPrx linkTo, int cost) throws LinkExists {
        this.link(linkTo, cost, null);
    }

    @Override
    public final ObjectPrx subscribeAndGetPublisher(Map<String, String> theQoS, ObjectPrx subscriber) throws AlreadySubscribed, BadQoS, InvalidSubscriber {
        return this.subscribeAndGetPublisher(theQoS, subscriber, null);
    }

    @Override
    public final void unlink(TopicPrx linkTo) throws NoSuchLink {
        this.unlink(linkTo, null);
    }

    @Override
    public final void unsubscribe(ObjectPrx subscriber) {
        this.unsubscribe(subscriber, null);
    }

    public static boolean _iceD_getName(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String ret = obj.getName(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_getPublisher(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        ObjectPrx ret = obj.getPublisher(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_getNonReplicatedPublisher(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        ObjectPrx ret = obj.getNonReplicatedPublisher(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_subscribeAndGetPublisher(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Normal, current.mode);
        InputStream istr = inS.startReadParams();
        Map<String, String> iceP_theQoS = QoSHelper.read(istr);
        ObjectPrx iceP_subscriber = istr.readProxy();
        inS.endReadParams();
        ObjectPrx ret = obj.subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_unsubscribe(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        ObjectPrx iceP_subscriber = istr.readProxy();
        inS.endReadParams();
        obj.unsubscribe(iceP_subscriber, current);
        inS.writeEmptyParams();
        return true;
    }

    public static boolean _iceD_link(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Normal, current.mode);
        InputStream istr = inS.startReadParams();
        TopicPrx iceP_linkTo = TopicPrxHelper.read(istr);
        int iceP_cost = istr.readInt();
        inS.endReadParams();
        obj.link(iceP_linkTo, iceP_cost, current);
        inS.writeEmptyParams();
        return true;
    }

    public static boolean _iceD_unlink(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Normal, current.mode);
        InputStream istr = inS.startReadParams();
        TopicPrx iceP_linkTo = TopicPrxHelper.read(istr);
        inS.endReadParams();
        obj.unlink(iceP_linkTo, current);
        inS.writeEmptyParams();
        return true;
    }

    public static boolean _iceD_getLinkInfoSeq(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        LinkInfo[] ret = obj.getLinkInfoSeq(current);
        OutputStream ostr = inS.startWriteParams();
        LinkInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_getSubscribers(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Normal, current.mode);
        inS.readEmptyParams();
        Identity[] ret = obj.getSubscribers(current);
        OutputStream ostr = inS.startWriteParams();
        IdentitySeqHelper.write(ostr, ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_destroy(Topic obj, Incoming inS, Current current) throws UserException {
        _TopicDisp._iceCheckMode(OperationMode.Normal, current.mode);
        inS.readEmptyParams();
        obj.destroy(current);
        inS.writeEmptyParams();
        return true;
    }

    @Override
    public boolean _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_all, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return _TopicDisp._iceD_destroy(this, in, current);
            }
            case 1: {
                return _TopicDisp._iceD_getLinkInfoSeq(this, in, current);
            }
            case 2: {
                return _TopicDisp._iceD_getName(this, in, current);
            }
            case 3: {
                return _TopicDisp._iceD_getNonReplicatedPublisher(this, in, current);
            }
            case 4: {
                return _TopicDisp._iceD_getPublisher(this, in, current);
            }
            case 5: {
                return _TopicDisp._iceD_getSubscribers(this, in, current);
            }
            case 6: {
                return _TopicDisp._iceD_ice_id(this, in, current);
            }
            case 7: {
                return _TopicDisp._iceD_ice_ids(this, in, current);
            }
            case 8: {
                return _TopicDisp._iceD_ice_isA(this, in, current);
            }
            case 9: {
                return _TopicDisp._iceD_ice_ping(this, in, current);
            }
            case 10: {
                return _TopicDisp._iceD_link(this, in, current);
            }
            case 11: {
                return _TopicDisp._iceD_subscribeAndGetPublisher(this, in, current);
            }
            case 12: {
                return _TopicDisp._iceD_unlink(this, in, current);
            }
            case 13: {
                return _TopicDisp._iceD_unsubscribe(this, in, current);
            }
        }
        assert (false);
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    @Override
    protected void _iceWriteImpl(OutputStream ostr_) {
        ostr_.startSlice(_TopicDisp.ice_staticId(), -1, true);
        ostr_.endSlice();
    }

    @Override
    protected void _iceReadImpl(InputStream istr_) {
        istr_.startSlice();
        istr_.endSlice();
    }
}

