// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `FileServer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IcePatch2;

/**
 * The interface that provides access to files.
 *
 **/
public interface FileServerPrx extends Ice.ObjectPrx
{
    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @return A sequence containing information about the files in the
     * specified partition.
     *
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public FileInfo[] getFileInfoSeq(int partition)
        throws FileSizeRangeException,
               PartitionOutOfRangeException;

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     *
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public FileInfo[] getFileInfoSeq(int partition, java.util.Map<String, String> context)
        throws FileSizeRangeException,
               PartitionOutOfRangeException;

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition, java.util.Map<String, String> context);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition, Ice.Callback cb);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition, Callback_FileServer_getFileInfoSeq cb);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition, java.util.Map<String, String> context, Callback_FileServer_getFileInfoSeq cb);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition,
                                                IceInternal.Functional_GenericCallback1<FileInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition,
                                                IceInternal.Functional_GenericCallback1<FileInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<FileInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     * @deprecated getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.
     **/
    public Ice.AsyncResult begin_getFileInfoSeq(int partition,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<FileInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Return file information for the specified partition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param result The asynchronous result object.
     * @return A sequence containing information about the files in the
     * specified partition.
     *
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     **/
    public FileInfo[] end_getFileInfoSeq(Ice.AsyncResult result)
        throws FileSizeRangeException,
               PartitionOutOfRangeException;

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @return A sequence containing information about the files in the
     * specified partition.
     *
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     **/
    public LargeFileInfo[] getLargeFileInfoSeq(int partition)
        throws PartitionOutOfRangeException;

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @return A sequence containing information about the files in the
     * specified partition.
     *
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     **/
    public LargeFileInfo[] getLargeFileInfoSeq(int partition, java.util.Map<String, String> context)
        throws PartitionOutOfRangeException;

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition);

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition, java.util.Map<String, String> context);

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition, Ice.Callback cb);

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition, Callback_FileServer_getLargeFileInfoSeq cb);

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition, java.util.Map<String, String> context, Callback_FileServer_getLargeFileInfoSeq cb);

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition,
                                                     IceInternal.Functional_GenericCallback1<LargeFileInfo[]> responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition,
                                                     IceInternal.Functional_GenericCallback1<LargeFileInfo[]> responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                     IceInternal.Functional_BoolCallback sentCb);

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition,
                                                     java.util.Map<String, String> context,
                                                     IceInternal.Functional_GenericCallback1<LargeFileInfo[]> responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Returns file information for the specified partition.
     *
     * @param partition The partition number in the range 0-255.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileInfoSeq(int partition,
                                                     java.util.Map<String, String> context,
                                                     IceInternal.Functional_GenericCallback1<LargeFileInfo[]> responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                     IceInternal.Functional_BoolCallback sentCb);

    /**
     * Returns file information for the specified partition.
     *
     * @param result The asynchronous result object.
     * @return A sequence containing information about the files in the
     * specified partition.
     *
     * @throws PartitionOutOfRangeException If the partition number is out of range.
     **/
    public LargeFileInfo[] end_getLargeFileInfoSeq(Ice.AsyncResult result)
        throws PartitionOutOfRangeException;

    /**
     * Return the checksums for all partitions.
     *
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     *
     **/
    public byte[][] getChecksumSeq();

    /**
     * Return the checksums for all partitions.
     *
     * @param context The Context map to send with the invocation.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     *
     **/
    public byte[][] getChecksumSeq(java.util.Map<String, String> context);

    /**
     * Return the checksums for all partitions.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq();

    /**
     * Return the checksums for all partitions.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq(java.util.Map<String, String> context);

    /**
     * Return the checksums for all partitions.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq(Ice.Callback cb);

    /**
     * Return the checksums for all partitions.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Return the checksums for all partitions.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq(Callback_FileServer_getChecksumSeq cb);

    /**
     * Return the checksums for all partitions.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq(java.util.Map<String, String> context, Callback_FileServer_getChecksumSeq cb);

    /**
     * Return the checksums for all partitions.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq(IceInternal.Functional_GenericCallback1<byte[][]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Return the checksums for all partitions.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq(IceInternal.Functional_GenericCallback1<byte[][]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Return the checksums for all partitions.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<byte[][]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Return the checksums for all partitions.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksumSeq(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<byte[][]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Return the checksums for all partitions.
     *
     * @param result The asynchronous result object.
     * @return A sequence containing 256 checksums. Partitions with a
     * checksum that differs from the previous checksum for the same
     * partition contain updated files. Partitions with a checksum
     * that is identical to the previous checksum do not contain
     * updated files.
     *
     **/
    public byte[][] end_getChecksumSeq(Ice.AsyncResult result);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @return The master checksum for the file set.
     *
     **/
    public byte[] getChecksum();

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param context The Context map to send with the invocation.
     * @return The master checksum for the file set.
     *
     **/
    public byte[] getChecksum(java.util.Map<String, String> context);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum();

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum(java.util.Map<String, String> context);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum(Ice.Callback cb);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum(Callback_FileServer_getChecksum cb);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum(java.util.Map<String, String> context, Callback_FileServer_getChecksum cb);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum(IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum(IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum(java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getChecksum(java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Return the master checksum for all partitions. If this checksum is the same
     * as for a previous run, the entire file set is up-to-date.
     *
     * @param result The asynchronous result object.
     * @return The master checksum for the file set.
     *
     **/
    public byte[] end_getChecksum(Ice.AsyncResult result);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @return A sequence containing the compressed file contents.
     *
     * @throws FileAccessException If an error occurred while trying to read the file.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public byte[] getFileCompressed(String path, int pos, int num)
        throws FileAccessException,
               FileSizeRangeException;

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     *
     * @throws FileAccessException If an error occurred while trying to read the file.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     *
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public byte[] getFileCompressed(String path, int pos, int num, java.util.Map<String, String> context)
        throws FileAccessException,
               FileSizeRangeException;

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path, int pos, int num);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path, int pos, int num, java.util.Map<String, String> context);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path, int pos, int num, Ice.Callback cb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path, int pos, int num, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path, int pos, int num, Callback_FileServer_getFileCompressed cb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path, int pos, int num, java.util.Map<String, String> context, Callback_FileServer_getFileCompressed cb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path,
                                                   int pos,
                                                   int num,
                                                   IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path,
                                                   int pos,
                                                   int num,
                                                   IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path,
                                                   int pos,
                                                   int num,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     * @deprecated getFileCompressed() is deprecated, use getLargeFileCompressed() instead.
     **/
    public Ice.AsyncResult begin_getFileCompressed(String path,
                                                   int pos,
                                                   int num,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * <p class="Deprecated"> This operation is deprecated and only present for
     * compatibility with old Ice clients (older than version 3.6).
     *
     * @param result The asynchronous result object.
     * @return A sequence containing the compressed file contents.
     *
     * @throws FileAccessException If an error occurred while trying to read the file.
     * @throws FileSizeRangeException If a file is larger than 2.1GB.
     *
     **/
    public byte[] end_getFileCompressed(Ice.AsyncResult result)
        throws FileAccessException,
               FileSizeRangeException;

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @return A sequence containing the compressed file contents.
     *
     * @throws FileAccessException If an error occurred while trying to read the file.
     *
     **/
    public byte[] getLargeFileCompressed(String path, long pos, int num)
        throws FileAccessException;

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @return A sequence containing the compressed file contents.
     *
     * @throws FileAccessException If an error occurred while trying to read the file.
     *
     **/
    public byte[] getLargeFileCompressed(String path, long pos, int num, java.util.Map<String, String> context)
        throws FileAccessException;

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path, long pos, int num);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path, long pos, int num, java.util.Map<String, String> context);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path, long pos, int num, Ice.Callback cb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path, long pos, int num, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path, long pos, int num, Callback_FileServer_getLargeFileCompressed cb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path, long pos, int num, java.util.Map<String, String> context, Callback_FileServer_getLargeFileCompressed cb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path,
                                                        long pos,
                                                        int num,
                                                        IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path,
                                                        long pos,
                                                        int num,
                                                        IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path,
                                                        long pos,
                                                        int num,
                                                        java.util.Map<String, String> context,
                                                        IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param path The pathname (relative to the data directory) for
     * the file to be read.
     *
     * @param pos The file offset at which to begin reading.
     *
     * @param num The number of bytes to be read.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLargeFileCompressed(String path,
                                                        long pos,
                                                        int num,
                                                        java.util.Map<String, String> context,
                                                        IceInternal.Functional_GenericCallback1<byte[]> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Read the specified file. This operation may only return fewer bytes than requested
     * in case there was an end-of-file condition.
     *
     * @param result The asynchronous result object.
     * @return A sequence containing the compressed file contents.
     *
     * @throws FileAccessException If an error occurred while trying to read the file.
     *
     **/
    public byte[] end_getLargeFileCompressed(Ice.AsyncResult result)
        throws FileAccessException;
}
