// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `IceBox.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceBox;

/**
 * Administers a set of {@link Service} instances.
 *
 * @see Service
 *
 **/
public interface _ServiceManagerOperations
{
    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(Ice.Current current);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @throws AlreadyStartedException If the service is already running.
     * @throws NoSuchServiceException If no service could be found with the given name.
     * @param current The Current object for the invocation.
     **/
    void startService(String service, Ice.Current current)
        throws AlreadyStartedException,
               NoSuchServiceException;

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @throws AlreadyStoppedException If the service is already stopped.
     * @throws NoSuchServiceException If no service could be found with the given name.
     * @param current The Current object for the invocation.
     **/
    void stopService(String service, Ice.Current current)
        throws AlreadyStoppedException,
               NoSuchServiceException;

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param current The Current object for the invocation.
     **/
    void addObserver(ServiceObserverPrx observer, Ice.Current current);

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     *
     * @param current The Current object for the invocation.
     **/
    void shutdown(Ice.Current current);
}
