// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The Ice router interface. Routers can be set either globally with
 * {@link Communicator#setDefaultRouter}, or with <tt>ice_router</tt> on specific
 * proxies.
 *
 **/
public interface _RouterOperationsNC
{
    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     *
     * @param hasRoutingTable Indicates whether or not the router supports a routing
     * table. If it is supported, the Ice runtime will call addProxies to populate the
     * routing table. This out parameter is only supported starting with Ice 3.7.
     * The Ice runtime assumes the router has a routing table if the optional is not
     * set.
     *
     * @return The router's client proxy.
     *
     **/
    Ice.ObjectPrx getClientProxy(Ice.BooleanHolder hasRoutingTable);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     *
     * @return The router's server proxy.
     *
     **/
    Ice.ObjectPrx getServerProxy();

    /**
     * Add new proxy information to the router's routing table.
     *
     * @param proxies The proxies to add.
     *
     * @return Proxies discarded by the router.
     *
     **/
    Ice.ObjectPrx[] addProxies(Ice.ObjectPrx[] proxies);
}
