// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * This interface allows applications to monitor the state of object
 * adapters that are registered with IceGrid.
 **/
public interface AdapterObserverPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * <tt>adapterInit</tt> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     **/
    default void adapterInit(AdapterInfo[] adpts)
    {
        adapterInit(adpts, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * <tt>adapterInit</tt> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     **/
    default void adapterInit(AdapterInfo[] adpts, java.util.Map<String, String> context)
    {
        _iceI_adapterInitAsync(adpts, context, true).waitForResponse();
    }

    /**
     * <tt>adapterInit</tt> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> adapterInitAsync(AdapterInfo[] adpts)
    {
        return _iceI_adapterInitAsync(adpts, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * <tt>adapterInit</tt> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> adapterInitAsync(AdapterInfo[] adpts, java.util.Map<String, String> context)
    {
        return _iceI_adapterInitAsync(adpts, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_adapterInitAsync(AdapterInfo[] iceP_adpts, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "adapterInit", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     AdapterInfoSeqHelper.write(ostr, iceP_adpts);
                 }, null);
        return f;
    }

    /**
     * The <tt>adapterAdded</tt> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     **/
    default void adapterAdded(AdapterInfo info)
    {
        adapterAdded(info, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * The <tt>adapterAdded</tt> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param context The Context map to send with the invocation.
     **/
    default void adapterAdded(AdapterInfo info, java.util.Map<String, String> context)
    {
        _iceI_adapterAddedAsync(info, context, true).waitForResponse();
    }

    /**
     * The <tt>adapterAdded</tt> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> adapterAddedAsync(AdapterInfo info)
    {
        return _iceI_adapterAddedAsync(info, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * The <tt>adapterAdded</tt> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> adapterAddedAsync(AdapterInfo info, java.util.Map<String, String> context)
    {
        return _iceI_adapterAddedAsync(info, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_adapterAddedAsync(AdapterInfo iceP_info, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "adapterAdded", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     AdapterInfo.ice_write(ostr, iceP_info);
                 }, null);
        return f;
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     **/
    default void adapterUpdated(AdapterInfo info)
    {
        adapterUpdated(info, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param context The Context map to send with the invocation.
     **/
    default void adapterUpdated(AdapterInfo info, java.util.Map<String, String> context)
    {
        _iceI_adapterUpdatedAsync(info, context, true).waitForResponse();
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> adapterUpdatedAsync(AdapterInfo info)
    {
        return _iceI_adapterUpdatedAsync(info, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> adapterUpdatedAsync(AdapterInfo info, java.util.Map<String, String> context)
    {
        return _iceI_adapterUpdatedAsync(info, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_adapterUpdatedAsync(AdapterInfo iceP_info, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "adapterUpdated", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     AdapterInfo.ice_write(ostr, iceP_info);
                 }, null);
        return f;
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     **/
    default void adapterRemoved(String id)
    {
        adapterRemoved(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param context The Context map to send with the invocation.
     **/
    default void adapterRemoved(String id, java.util.Map<String, String> context)
    {
        _iceI_adapterRemovedAsync(id, context, true).waitForResponse();
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> adapterRemovedAsync(String id)
    {
        return _iceI_adapterRemovedAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> adapterRemovedAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_adapterRemovedAsync(id, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_adapterRemovedAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "adapterRemoved", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, null);
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdapterObserverPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), AdapterObserverPrx.class, _AdapterObserverPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdapterObserverPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), AdapterObserverPrx.class, _AdapterObserverPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdapterObserverPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), AdapterObserverPrx.class, _AdapterObserverPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdapterObserverPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), AdapterObserverPrx.class, _AdapterObserverPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static AdapterObserverPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, AdapterObserverPrx.class, _AdapterObserverPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static AdapterObserverPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, AdapterObserverPrx.class, _AdapterObserverPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default AdapterObserverPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (AdapterObserverPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default AdapterObserverPrx ice_adapterId(String newAdapterId)
    {
        return (AdapterObserverPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default AdapterObserverPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (AdapterObserverPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default AdapterObserverPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (AdapterObserverPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default AdapterObserverPrx ice_invocationTimeout(int newTimeout)
    {
        return (AdapterObserverPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default AdapterObserverPrx ice_connectionCached(boolean newCache)
    {
        return (AdapterObserverPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default AdapterObserverPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (AdapterObserverPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default AdapterObserverPrx ice_secure(boolean b)
    {
        return (AdapterObserverPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default AdapterObserverPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (AdapterObserverPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default AdapterObserverPrx ice_preferSecure(boolean b)
    {
        return (AdapterObserverPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default AdapterObserverPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (AdapterObserverPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default AdapterObserverPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (AdapterObserverPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default AdapterObserverPrx ice_collocationOptimized(boolean b)
    {
        return (AdapterObserverPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default AdapterObserverPrx ice_twoway()
    {
        return (AdapterObserverPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default AdapterObserverPrx ice_oneway()
    {
        return (AdapterObserverPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default AdapterObserverPrx ice_batchOneway()
    {
        return (AdapterObserverPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default AdapterObserverPrx ice_datagram()
    {
        return (AdapterObserverPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default AdapterObserverPrx ice_batchDatagram()
    {
        return (AdapterObserverPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default AdapterObserverPrx ice_compress(boolean co)
    {
        return (AdapterObserverPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default AdapterObserverPrx ice_timeout(int t)
    {
        return (AdapterObserverPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default AdapterObserverPrx ice_connectionId(String connectionId)
    {
        return (AdapterObserverPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default AdapterObserverPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (AdapterObserverPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceGrid::AdapterObserver";
    }
}
