/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.profile.aggregation.ProfilingAggregator;

public class AggregatorFactories {
    public static final Pattern VALID_AGG_NAME = Pattern.compile("[^\\[\\]>]+");
    public static final AggregatorFactories EMPTY = new AggregatorFactories(null, new AggregatorFactory[0], new ArrayList<PipelineAggregationBuilder>());
    private AggregatorFactory<?> parent;
    private AggregatorFactory<?>[] factories;
    private List<PipelineAggregationBuilder> pipelineAggregatorFactories;

    public static Builder parseAggregators(XContentParser parser) throws IOException {
        return AggregatorFactories.parseAggregators(parser, 0);
    }

    private static Builder parseAggregators(XContentParser parser, int level) throws IOException {
        Matcher validAggMatcher = VALID_AGG_NAME.matcher("");
        Builder factories = new Builder();
        XContentParser.Token token = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " in [aggs]: aggregations definitions must start with the name of the aggregation.", new Object[0]);
            }
            String aggregationName = parser.currentName();
            if (!validAggMatcher.reset(aggregationName).matches()) {
                throw new ParsingException(parser.getTokenLocation(), "Invalid aggregation name [" + aggregationName + "]. Aggregation names must be alpha-numeric and can only contain '_' and '-'", new Object[0]);
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Aggregation definition for [" + aggregationName + " starts with a [" + (Object)((Object)token) + "], expected a [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "].", new Object[0]);
            }
            BaseAggregationBuilder aggBuilder = null;
            Builder subFactories = null;
            Map<String, Object> metaData = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.FIELD_NAME) + "] under a [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "], but got a [" + (Object)((Object)token) + "] in [" + aggregationName + "]", parser.getTokenLocation());
                }
                String fieldName = parser.currentName();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    switch (fieldName) {
                        case "meta": {
                            metaData = parser.map();
                            break;
                        }
                        case "aggregations": 
                        case "aggs": {
                            if (subFactories != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two sub aggregation definitions under [" + aggregationName + "]", new Object[0]);
                            }
                            subFactories = AggregatorFactories.parseAggregators(parser, level + 1);
                            break;
                        }
                        default: {
                            if (aggBuilder != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two aggregation type definitions in [" + aggregationName + "]: [" + aggBuilder.getType() + "] and [" + fieldName + "]", new Object[0]);
                            }
                            aggBuilder = parser.namedObject(BaseAggregationBuilder.class, fieldName, new AggParseContext(aggregationName));
                            break;
                        }
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "] under [" + fieldName + "], but got a [" + (Object)((Object)token) + "] in [" + aggregationName + "]", new Object[0]);
            }
            if (aggBuilder == null) {
                throw new ParsingException(parser.getTokenLocation(), "Missing definition for aggregation [" + aggregationName + "]", parser.getTokenLocation());
            }
            if (metaData != null) {
                aggBuilder.setMetaData(metaData);
            }
            if (subFactories != null) {
                aggBuilder.subAggregations(subFactories);
            }
            if (aggBuilder instanceof AggregationBuilder) {
                factories.addAggregator((AggregationBuilder)aggBuilder);
                continue;
            }
            factories.addPipelineAggregator((PipelineAggregationBuilder)aggBuilder);
        }
        return factories;
    }

    public static Builder builder() {
        return new Builder();
    }

    private AggregatorFactories(AggregatorFactory<?> parent, AggregatorFactory<?>[] factories, List<PipelineAggregationBuilder> pipelineAggregators) {
        this.parent = parent;
        this.factories = factories;
        this.pipelineAggregatorFactories = pipelineAggregators;
    }

    public List<PipelineAggregator> createPipelineAggregators() throws IOException {
        ArrayList<PipelineAggregator> pipelineAggregators = new ArrayList<PipelineAggregator>(this.pipelineAggregatorFactories.size());
        for (PipelineAggregationBuilder factory : this.pipelineAggregatorFactories) {
            pipelineAggregators.add(factory.create());
        }
        return pipelineAggregators;
    }

    public Aggregator[] createSubAggregators(Aggregator parent) throws IOException {
        Aggregator[] aggregators = new Aggregator[this.countAggregators()];
        for (int i = 0; i < this.factories.length; ++i) {
            boolean collectsFromSingleBucket = false;
            Aggregator factory = this.factories[i].create(parent, false);
            Profilers profilers = factory.context().getProfilers();
            if (profilers != null) {
                factory = new ProfilingAggregator(factory, profilers.getAggregationProfiler());
            }
            aggregators[i] = factory;
        }
        return aggregators;
    }

    public Aggregator[] createTopLevelAggregators() throws IOException {
        Aggregator[] aggregators = new Aggregator[this.factories.length];
        for (int i = 0; i < this.factories.length; ++i) {
            boolean collectsFromSingleBucket = true;
            Aggregator factory = this.factories[i].create(null, true);
            Profilers profilers = factory.context().getProfilers();
            if (profilers != null) {
                factory = new ProfilingAggregator(factory, profilers.getAggregationProfiler());
            }
            aggregators[i] = factory;
        }
        return aggregators;
    }

    public int countAggregators() {
        return this.factories.length;
    }

    public int countPipelineAggregators() {
        return this.pipelineAggregatorFactories.size();
    }

    public static class Builder
    implements Writeable,
    ToXContentObject {
        private final Set<String> names = new HashSet<String>();
        private final List<AggregationBuilder> aggregationBuilders = new ArrayList<AggregationBuilder>();
        private final List<PipelineAggregationBuilder> pipelineAggregatorBuilders = new ArrayList<PipelineAggregationBuilder>();
        private boolean skipResolveOrder;

        public Builder() {
        }

        public Builder(StreamInput in) throws IOException {
            int factoriesSize = in.readVInt();
            for (int i = 0; i < factoriesSize; ++i) {
                this.addAggregator(in.readNamedWriteable(AggregationBuilder.class));
            }
            int pipelineFactoriesSize = in.readVInt();
            for (int i = 0; i < pipelineFactoriesSize; ++i) {
                this.addPipelineAggregator(in.readNamedWriteable(PipelineAggregationBuilder.class));
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.aggregationBuilders.size());
            for (AggregationBuilder aggregationBuilder : this.aggregationBuilders) {
                out.writeNamedWriteable(aggregationBuilder);
            }
            out.writeVInt(this.pipelineAggregatorBuilders.size());
            for (PipelineAggregationBuilder pipelineAggregationBuilder : this.pipelineAggregatorBuilders) {
                out.writeNamedWriteable(pipelineAggregationBuilder);
            }
        }

        public boolean mustVisitAllDocs() {
            for (AggregationBuilder builder : this.aggregationBuilders) {
                if (builder instanceof GlobalAggregationBuilder) {
                    return true;
                }
                if (!(builder instanceof TermsAggregationBuilder) || ((TermsAggregationBuilder)builder).minDocCount() != 0L) continue;
                return true;
            }
            return false;
        }

        public Builder addAggregator(AggregationBuilder factory) {
            if (!this.names.add(factory.name)) {
                throw new IllegalArgumentException("Two sibling aggregations cannot have the same name: [" + factory.name + "]");
            }
            this.aggregationBuilders.add(factory);
            return this;
        }

        public Builder addPipelineAggregator(PipelineAggregationBuilder pipelineAggregatorFactory) {
            this.pipelineAggregatorBuilders.add(pipelineAggregatorFactory);
            return this;
        }

        Builder skipResolveOrder() {
            this.skipResolveOrder = true;
            return this;
        }

        public AggregatorFactories build(SearchContext context, AggregatorFactory<?> parent) throws IOException {
            if (this.aggregationBuilders.isEmpty() && this.pipelineAggregatorBuilders.isEmpty()) {
                return EMPTY;
            }
            List<PipelineAggregationBuilder> orderedpipelineAggregators = null;
            orderedpipelineAggregators = this.skipResolveOrder ? new ArrayList<PipelineAggregationBuilder>(this.pipelineAggregatorBuilders) : this.resolvePipelineAggregatorOrder(this.pipelineAggregatorBuilders, this.aggregationBuilders, parent);
            AggregatorFactory[] aggFactories = new AggregatorFactory[this.aggregationBuilders.size()];
            for (int i = 0; i < this.aggregationBuilders.size(); ++i) {
                aggFactories[i] = this.aggregationBuilders.get(i).build(context, parent);
            }
            return new AggregatorFactories(parent, aggFactories, orderedpipelineAggregators);
        }

        private List<PipelineAggregationBuilder> resolvePipelineAggregatorOrder(List<PipelineAggregationBuilder> pipelineAggregatorBuilders, List<AggregationBuilder> aggBuilders, AggregatorFactory<?> parent) {
            HashMap<String, PipelineAggregationBuilder> pipelineAggregatorBuildersMap = new HashMap<String, PipelineAggregationBuilder>();
            for (PipelineAggregationBuilder pipelineAggregationBuilder : pipelineAggregatorBuilders) {
                pipelineAggregatorBuildersMap.put(pipelineAggregationBuilder.getName(), pipelineAggregationBuilder);
            }
            HashMap<String, AggregationBuilder> aggBuildersMap = new HashMap<String, AggregationBuilder>();
            for (AggregationBuilder aggBuilder : aggBuilders) {
                aggBuildersMap.put(aggBuilder.name, aggBuilder);
            }
            LinkedList<PipelineAggregationBuilder> linkedList = new LinkedList<PipelineAggregationBuilder>();
            ArrayList<PipelineAggregationBuilder> unmarkedBuilders = new ArrayList<PipelineAggregationBuilder>(pipelineAggregatorBuilders);
            HashSet<PipelineAggregationBuilder> temporarilyMarked = new HashSet<PipelineAggregationBuilder>();
            while (!unmarkedBuilders.isEmpty()) {
                PipelineAggregationBuilder builder = (PipelineAggregationBuilder)unmarkedBuilders.get(0);
                builder.validate(parent, aggBuilders, pipelineAggregatorBuilders);
                this.resolvePipelineAggregatorOrder(aggBuildersMap, pipelineAggregatorBuildersMap, linkedList, unmarkedBuilders, temporarilyMarked, builder);
            }
            return linkedList;
        }

        private void resolvePipelineAggregatorOrder(Map<String, AggregationBuilder> aggBuildersMap, Map<String, PipelineAggregationBuilder> pipelineAggregatorBuildersMap, List<PipelineAggregationBuilder> orderedPipelineAggregators, List<PipelineAggregationBuilder> unmarkedBuilders, Set<PipelineAggregationBuilder> temporarilyMarked, PipelineAggregationBuilder builder) {
            if (temporarilyMarked.contains(builder)) {
                throw new IllegalArgumentException("Cyclical dependency found with pipeline aggregator [" + builder.getName() + "]");
            }
            if (unmarkedBuilders.contains(builder)) {
                String[] bucketsPaths;
                temporarilyMarked.add(builder);
                block0: for (String bucketsPath : bucketsPaths = builder.getBucketsPaths()) {
                    List<AggregationPath.PathElement> bucketsPathElements = AggregationPath.parse(bucketsPath).getPathElements();
                    String firstAggName = bucketsPathElements.get((int)0).name;
                    if (bucketsPath.equals("_count") || bucketsPath.equals("_key")) continue;
                    if (aggBuildersMap.containsKey(firstAggName)) {
                        AggregationBuilder aggBuilder = aggBuildersMap.get(firstAggName);
                        for (int i = 1; i < bucketsPathElements.size(); ++i) {
                            AggregationPath.PathElement pathElement = bucketsPathElements.get(i);
                            String aggName = pathElement.name;
                            if (i == bucketsPathElements.size() - 1 && (aggName.equalsIgnoreCase("_key") || aggName.equals("_count"))) continue block0;
                            List<AggregationBuilder> subBuilders = aggBuilder.factoriesBuilder.aggregationBuilders;
                            boolean foundSubBuilder = false;
                            for (AggregationBuilder subBuilder : subBuilders) {
                                if (!aggName.equals(subBuilder.name)) continue;
                                aggBuilder = subBuilder;
                                foundSubBuilder = true;
                                break;
                            }
                            if (!foundSubBuilder && i == bucketsPathElements.size() - 1) {
                                List<PipelineAggregationBuilder> subPipelineBuilders = aggBuilder.factoriesBuilder.pipelineAggregatorBuilders;
                                for (PipelineAggregationBuilder subFactory : subPipelineBuilders) {
                                    if (!aggName.equals(subFactory.getName())) continue;
                                    foundSubBuilder = true;
                                    break;
                                }
                            }
                            if (foundSubBuilder) continue;
                            throw new IllegalArgumentException("No aggregation [" + aggName + "] found for path [" + bucketsPath + "]");
                        }
                        continue;
                    }
                    PipelineAggregationBuilder matchingBuilder = pipelineAggregatorBuildersMap.get(firstAggName);
                    if (matchingBuilder != null) {
                        this.resolvePipelineAggregatorOrder(aggBuildersMap, pipelineAggregatorBuildersMap, orderedPipelineAggregators, unmarkedBuilders, temporarilyMarked, matchingBuilder);
                        continue;
                    }
                    throw new IllegalArgumentException("No aggregation found for path [" + bucketsPath + "]");
                }
                unmarkedBuilders.remove(builder);
                temporarilyMarked.remove(builder);
                orderedPipelineAggregators.add(builder);
            }
        }

        public List<AggregationBuilder> getAggregatorFactories() {
            return Collections.unmodifiableList(this.aggregationBuilders);
        }

        public List<PipelineAggregationBuilder> getPipelineAggregatorFactories() {
            return Collections.unmodifiableList(this.pipelineAggregatorBuilders);
        }

        public int count() {
            return this.aggregationBuilders.size() + this.pipelineAggregatorBuilders.size();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.aggregationBuilders != null) {
                for (AggregationBuilder aggregationBuilder : this.aggregationBuilders) {
                    aggregationBuilder.toXContent(builder, params);
                }
            }
            if (this.pipelineAggregatorBuilders != null) {
                for (PipelineAggregationBuilder pipelineAggregationBuilder : this.pipelineAggregatorBuilders) {
                    pipelineAggregationBuilder.toXContent(builder, params);
                }
            }
            builder.endObject();
            return builder;
        }

        public String toString() {
            return Strings.toString(this, true, true);
        }

        public int hashCode() {
            return Objects.hash(this.aggregationBuilders, this.pipelineAggregatorBuilders);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (!Objects.equals(this.aggregationBuilders, other.aggregationBuilders)) {
                return false;
            }
            return Objects.equals(this.pipelineAggregatorBuilders, other.pipelineAggregatorBuilders);
        }

        public Builder rewrite(QueryRewriteContext context) throws IOException {
            boolean changed = false;
            Builder newBuilder = new Builder();
            for (AggregationBuilder aggregationBuilder : this.aggregationBuilders) {
                AggregationBuilder result = AggregationBuilder.rewriteAggregation(aggregationBuilder, context);
                if (result != aggregationBuilder) {
                    changed = true;
                }
                newBuilder.addAggregator(result);
            }
            if (changed) {
                for (PipelineAggregationBuilder pipelineAggregationBuilder : this.pipelineAggregatorBuilders) {
                    newBuilder.addPipelineAggregator(pipelineAggregationBuilder);
                }
                return newBuilder;
            }
            return this;
        }
    }

    public static final class AggParseContext {
        public final String name;

        public AggParseContext(String name) {
            this.name = name;
        }
    }
}

