/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.hipchat;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.notification.NotificationService;
import org.elasticsearch.xpack.watcher.notification.hipchat.HipChatAccount;
import org.elasticsearch.xpack.watcher.notification.hipchat.HipChatServer;

public class HipChatService
extends NotificationService<HipChatAccount> {
    private static final Setting<String> SETTING_DEFAULT_ACCOUNT = Setting.simpleString((String)"xpack.notification.hipchat.default_account", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    static final Setting<String> SETTING_DEFAULT_HOST = Setting.simpleString((String)"xpack.notification.hipchat.host", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    static final Setting<Integer> SETTING_DEFAULT_PORT = Setting.intSetting((String)"xpack.notification.hipchat.port", (int)443, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Setting.AffixSetting<String> SETTING_AUTH_TOKEN = Setting.affixKeySetting((String)"xpack.notification.hipchat.account.", (String)"auth_token", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<SecureString> SETTING_AUTH_TOKEN_SECURE = Setting.affixKeySetting((String)"xpack.notification.hipchat.account.", (String)"secure_auth_token", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<String> SETTING_PROFILE = Setting.affixKeySetting((String)"xpack.notification.hipchat.account.", (String)"profile", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<String> SETTING_ROOM = Setting.affixKeySetting((String)"xpack.notification.hipchat.account.", (String)"room", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<String> SETTING_HOST = Setting.affixKeySetting((String)"xpack.notification.hipchat.account.", (String)"host", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<Integer> SETTING_PORT = Setting.affixKeySetting((String)"xpack.notification.hipchat.account.", (String)"port", key -> Setting.intSetting((String)key, (int)443, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<Settings> SETTING_MESSAGE_DEFAULTS = Setting.affixKeySetting((String)"xpack.notification.hipchat.account.", (String)"message", key -> Setting.groupSetting((String)(key + "."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private final HttpClient httpClient;
    private HipChatServer defaultServer;

    public HipChatService(Settings settings, HttpClient httpClient, ClusterSettings clusterSettings) {
        super(settings, "hipchat", clusterSettings, HipChatService.getSettings());
        this.httpClient = httpClient;
        clusterSettings.addSettingsUpdateConsumer(SETTING_DEFAULT_ACCOUNT, s -> {});
        clusterSettings.addSettingsUpdateConsumer(SETTING_DEFAULT_HOST, s -> {});
        clusterSettings.addSettingsUpdateConsumer(SETTING_DEFAULT_PORT, s -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_AUTH_TOKEN, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_AUTH_TOKEN_SECURE, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_PROFILE, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_ROOM, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_HOST, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_PORT, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_MESSAGE_DEFAULTS, (s, o) -> {}, (s, o) -> {});
        this.reload(settings);
    }

    @Override
    public synchronized void reload(Settings settings) {
        this.defaultServer = new HipChatServer(settings.getByPrefix("xpack.notification.hipchat."));
        super.reload(settings);
    }

    @Override
    protected HipChatAccount createAccount(String name, Settings accountSettings) {
        HipChatAccount.Profile profile = HipChatAccount.Profile.resolve(accountSettings, "profile", null);
        if (profile == null) {
            throw new SettingsException("missing [profile] setting for hipchat account [" + name + "]");
        }
        return profile.createAccount(name, accountSettings, this.defaultServer, this.httpClient, this.logger);
    }

    public static List<Setting<?>> getSettings() {
        return Arrays.asList(SETTING_DEFAULT_ACCOUNT, SETTING_AUTH_TOKEN, SETTING_AUTH_TOKEN_SECURE, SETTING_PROFILE, SETTING_ROOM, SETTING_MESSAGE_DEFAULTS, SETTING_DEFAULT_HOST, SETTING_DEFAULT_PORT, SETTING_HOST, SETTING_PORT);
    }
}

