/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.swt;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.Window;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.newt.Debug;
import jogamp.newt.swt.SWTEDTUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class NewtCanvasSWT
extends Canvas
implements WindowClosingProtocol {
    private static final boolean DEBUG = Debug.debug("Window");
    private final AbstractGraphicsScreen screen;
    private WindowClosingProtocol.WindowClosingMode newtChildCloseOp = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    private volatile Rectangle clientArea;
    private volatile SWTNativeWindow nativeWindow;
    private volatile Window newtChild = null;
    private volatile boolean newtChildReady = false;
    private volatile boolean postSetSize = false;
    private volatile boolean postSetPos = false;

    public static NewtCanvasSWT create(final Composite composite, final int n, final Window window) {
        final NewtCanvasSWT[] newtCanvasSWTArray = new NewtCanvasSWT[]{null};
        composite.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                newtCanvasSWTArray[0] = new NewtCanvasSWT(composite, n, window);
            }
        });
        return newtCanvasSWTArray[0];
    }

    public NewtCanvasSWT(Composite composite, int n, Window window) {
        super(composite, n | 0x40000);
        SWTAccessor.setRealized((Control)this, true);
        this.clientArea = this.getClientArea();
        AbstractGraphicsDevice abstractGraphicsDevice = SWTAccessor.getDevice((Control)this);
        this.screen = SWTAccessor.getScreen(abstractGraphicsDevice, -1);
        this.nativeWindow = null;
        if (null != window) {
            this.setNEWTChild(window);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        if (DEBUG) {
                            System.err.println("NewtCanvasSWT.Event.PAINT, " + event);
                        }
                        if (null == NewtCanvasSWT.this.nativeWindow && !NewtCanvasSWT.this.validateNative() || !NewtCanvasSWT.this.newtChildReady) break;
                        if (NewtCanvasSWT.this.postSetSize) {
                            NewtCanvasSWT.this.newtChild.setSize(((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.width, ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.height);
                            NewtCanvasSWT.this.postSetSize = false;
                        }
                        if (NewtCanvasSWT.this.postSetPos) {
                            NewtCanvasSWT.this.newtChild.setPosition(((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.x, ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.y);
                            NewtCanvasSWT.this.postSetPos = false;
                        }
                        NewtCanvasSWT.this.newtChild.windowRepaint(0, 0, ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.width, ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.height);
                        break;
                    }
                    case 10: {
                        if (!DEBUG) break;
                        System.err.println("NewtCanvasSWT.Event.MOVE, " + event);
                        break;
                    }
                    case 11: {
                        if (DEBUG) {
                            System.err.println("NewtCanvasSWT.Event.RESIZE, " + event);
                        }
                        NewtCanvasSWT.this.updateSizeCheck();
                        break;
                    }
                    case 12: {
                        if (DEBUG) {
                            System.err.println("NewtCanvasSWT.Event.DISPOSE, " + event);
                        }
                        NewtCanvasSWT.this.dispose();
                        break;
                    }
                    default: {
                        if (!DEBUG) break;
                        System.err.println("NewtCanvasSWT.Event.misc: " + event.type + ", " + event);
                    }
                }
            }
        };
        this.addListener(11, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (DEBUG) {
            System.err.println("NewtCanvasSWT.setBounds: " + n + "/" + n2 + " " + n3 + "x" + n4);
        }
        if (SWTAccessor.isOSX) {
            this.updatePosSizeCheck(n, n2, n3, n4, true);
        }
    }

    protected final boolean validateNative() {
        this.updateSizeCheck();
        Rectangle rectangle = this.clientArea;
        if (0 >= rectangle.width || 0 >= rectangle.height) {
            return false;
        }
        this.screen.getDevice().open();
        long l = SWTAccessor.getWindowHandle((Control)this);
        int n = SWTAccessor.getNativeVisualID(this.screen.getDevice(), l);
        boolean bl = NativeWindowFactory.isNativeVisualIDValidForProcessing(n);
        if (DEBUG) {
            System.err.println("NewtCanvasSWT.validateNative() windowHandle 0x" + Long.toHexString(l) + ", visualID 0x" + Integer.toHexString(n) + ", valid " + bl);
        }
        if (bl) {
            Capabilities capabilities = new Capabilities();
            GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(this.screen.getDevice(), capabilities);
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilities, capabilities, null, this.screen, n);
            if (DEBUG) {
                System.err.println("NewtCanvasSWT.validateNative() factory: " + graphicsConfigurationFactory + ", windowHandle 0x" + Long.toHexString(l) + ", visualID 0x" + Integer.toHexString(n) + ", chosen config: " + abstractGraphicsConfiguration);
            }
            if (null == abstractGraphicsConfiguration) {
                throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
            }
            this.nativeWindow = new SWTNativeWindow(abstractGraphicsConfiguration, l);
            this.reparentWindow(true);
            if (SWTAccessor.isOSX && this.newtChildReady) {
                this.newtChild.setPosition(this.getLocation().x, this.getLocation().y);
            }
        }
        return null != this.nativeWindow;
    }

    protected final void updateSizeCheck() {
        Rectangle rectangle = this.getClientArea();
        if (null != rectangle) {
            this.updatePosSizeCheck(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }

    protected final void updatePosSizeCheck() {
        Rectangle rectangle = this.getClientArea();
        if (null != rectangle) {
            this.updatePosSizeCheck(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    protected final void updatePosSizeCheck(int n, int n2, int n3, int n4, boolean bl) {
        Rectangle rectangle;
        boolean bl2;
        Rectangle rectangle2 = this.clientArea;
        boolean bl3 = n3 != rectangle2.width || n4 != rectangle2.height;
        boolean bl4 = bl2 = n != rectangle2.x || n2 != rectangle2.y;
        if (bl3 || bl2) {
            this.clientArea = rectangle = new Rectangle(bl ? n : rectangle2.x, bl ? n2 : rectangle2.y, n3, n4);
        } else {
            rectangle = this.clientArea;
        }
        if (DEBUG) {
            long l = this.newtChildReady ? this.newtChild.getSurfaceHandle() : 0L;
            System.err.println("NewtCanvasSWT.updatePosSizeCheck: sizeChanged " + bl3 + ", posChanged " + bl2 + ", updatePos " + bl + ", (" + Thread.currentThread().getName() + "): newtChildReady " + this.newtChildReady + ", " + rectangle.x + "/" + rectangle.y + " " + rectangle.width + "x" + rectangle.height + " - surfaceHandle 0x" + Long.toHexString(l));
        }
        if (bl3) {
            if (this.newtChildReady) {
                this.newtChild.setSize(rectangle.width, rectangle.height);
            } else {
                this.postSetSize = true;
            }
        }
        if (bl && bl2) {
            if (this.newtChildReady) {
                this.newtChild.setPosition(rectangle.x, rectangle.y);
            } else {
                this.postSetPos = true;
            }
        }
    }

    public void update() {
    }

    public void dispose() {
        if (null != this.newtChild) {
            if (DEBUG) {
                System.err.println("NewtCanvasSWT.dispose.0: EDTUtil cur " + this.newtChild.getScreen().getDisplay().getEDTUtil() + ",\n\t" + this.newtChild);
            }
            this.configureNewtChild(false);
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null, -1, -1, 0);
            this.newtChild.destroy();
            this.newtChild = null;
        }
        this.screen.getDevice().close();
        this.nativeWindow = null;
        super.dispose();
    }

    private com.jogamp.nativewindow.util.Point getParentLocationOnScreen() {
        final Point[] pointArray = new Point[]{null};
        SWTAccessor.invoke(true, new Runnable(){

            @Override
            public void run() {
                pointArray[0] = NewtCanvasSWT.this.getParent().toDisplay(0, 0);
            }
        });
        return new com.jogamp.nativewindow.util.Point(pointArray[0].x, pointArray[0].y);
    }

    public NativeWindow getNativeWindow() {
        return this.nativeWindow;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.newtChildCloseOp;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        this.newtChildCloseOp = windowClosingMode;
        return this.newtChildCloseOp;
    }

    boolean isParent() {
        return null != this.newtChild;
    }

    boolean isFullscreen() {
        return null != this.newtChild && this.newtChild.isFullscreen();
    }

    public Window setNEWTChild(Window window) {
        Window window2 = this.newtChild;
        if (DEBUG) {
            System.err.println("NewtCanvasSWT.setNEWTChild.0: win " + NewtCanvasSWT.newtWinHandleToHexString(window2) + " -> " + NewtCanvasSWT.newtWinHandleToHexString(window));
        }
        if (null != this.newtChild) {
            this.reparentWindow(false);
            this.newtChild = null;
        }
        this.newtChild = window;
        if (null != this.nativeWindow && null != window) {
            this.reparentWindow(true);
        }
        return window2;
    }

    public Window getNEWTChild() {
        return this.newtChild;
    }

    public boolean setParent(Composite composite) {
        return super.setParent(composite);
    }

    void configureNewtChild(boolean bl) {
        this.newtChildReady = bl;
        if (null != this.newtChild) {
            this.newtChild.setKeyboardFocusHandler(null);
            if (bl) {
                this.newtChildCloseOp = this.newtChild.setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE);
            } else {
                this.newtChild.setFocusAction(null);
                this.newtChild.setDefaultCloseOperation(this.newtChildCloseOp);
            }
        }
    }

    void reparentWindow(boolean bl) {
        if (null == this.newtChild) {
            return;
        }
        if (DEBUG) {
            System.err.println("NewtCanvasSWT.reparentWindow.0: add=" + bl + ", win " + NewtCanvasSWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
        this.newtChild.setFocusAction(null);
        if (bl) {
            this.updateSizeCheck();
            int n = this.clientArea.width;
            int n2 = this.clientArea.height;
            Display display = this.newtChild.getScreen().getDisplay();
            SWTEDTUtil sWTEDTUtil = new SWTEDTUtil(display, this.getDisplay());
            sWTEDTUtil.start();
            display.setEDTUtil(sWTEDTUtil);
            this.newtChild.setSize(n, n2);
            this.newtChild.reparentWindow(this.nativeWindow, -1, -1, 2);
            this.newtChild.setVisible(true);
            this.configureNewtChild(true);
            this.newtChild.sendWindowEvent(100);
            this.setEnabled(true);
        } else {
            this.configureNewtChild(false);
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null, -1, -1, 0);
        }
        if (DEBUG) {
            System.err.println("NewtCanvasSWT.reparentWindow.X: add=" + bl + ", win " + NewtCanvasSWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
    }

    private final void requestFocusNEWTChild() {
        if (this.newtChildReady) {
            this.newtChild.setFocusAction(null);
            this.newtChild.requestFocus();
        }
    }

    public boolean forceFocus() {
        boolean bl = NewtCanvasSWT.super.forceFocus();
        this.requestFocusNEWTChild();
        return bl;
    }

    static String newtWinHandleToHexString(Window window) {
        return null != window ? NewtCanvasSWT.toHexString(window.getWindowHandle()) : "nil";
    }

    static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private class SWTNativeWindow
    implements NativeWindow {
        private final AbstractGraphicsConfiguration config;
        private final long nativeWindowHandle;
        private final InsetsImmutable insets;

        public SWTNativeWindow(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l) {
            this.config = abstractGraphicsConfiguration;
            this.nativeWindowHandle = l;
            this.insets = SWTAccessor.isOSX ? OSXUtil.GetInsets(l) : new Insets(0, 0, 0, 0);
        }

        @Override
        public int lockSurface() throws NativeWindowException, RuntimeException {
            return 3;
        }

        @Override
        public void unlockSurface() {
        }

        @Override
        public boolean isSurfaceLockedByOtherThread() {
            return false;
        }

        @Override
        public Thread getSurfaceLockOwner() {
            return null;
        }

        @Override
        public boolean surfaceSwap() {
            return false;
        }

        @Override
        public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        }

        @Override
        public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        }

        @Override
        public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        }

        @Override
        public long getSurfaceHandle() {
            return 0L;
        }

        @Override
        public int getWidth() {
            return this.getSurfaceWidth();
        }

        @Override
        public int getHeight() {
            return this.getSurfaceHeight();
        }

        @Override
        public final int[] convertToWindowUnits(int[] nArray) {
            return nArray;
        }

        @Override
        public final int[] convertToPixelUnits(int[] nArray) {
            return nArray;
        }

        @Override
        public int getSurfaceWidth() {
            return ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.width;
        }

        @Override
        public int getSurfaceHeight() {
            return ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.height;
        }

        @Override
        public final NativeSurface getNativeSurface() {
            return this;
        }

        @Override
        public AbstractGraphicsConfiguration getGraphicsConfiguration() {
            return this.config;
        }

        @Override
        public long getDisplayHandle() {
            return this.config.getScreen().getDevice().getHandle();
        }

        @Override
        public int getScreenIndex() {
            return this.config.getScreen().getIndex();
        }

        @Override
        public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        }

        @Override
        public void destroy() {
        }

        @Override
        public NativeWindow getParent() {
            return null;
        }

        @Override
        public long getWindowHandle() {
            return this.nativeWindowHandle;
        }

        @Override
        public InsetsImmutable getInsets() {
            return this.insets;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 0;
        }

        @Override
        public com.jogamp.nativewindow.util.Point getLocationOnScreen(com.jogamp.nativewindow.util.Point point) {
            com.jogamp.nativewindow.util.Point point2;
            if (SWTAccessor.isOSX) {
                point2 = NewtCanvasSWT.this.getParentLocationOnScreen();
            } else if (SWTAccessor.isX11) {
                AbstractGraphicsScreen abstractGraphicsScreen = this.config.getScreen();
                point2 = X11Lib.GetRelativeLocation(abstractGraphicsScreen.getDevice().getHandle(), abstractGraphicsScreen.getIndex(), this.nativeWindowHandle, 0L, 0, 0);
            } else {
                point2 = SWTAccessor.isWindows ? GDIUtil.GetRelativeLocation(this.nativeWindowHandle, 0L, 0, 0) : new com.jogamp.nativewindow.util.Point(0, 0);
            }
            if (null != point) {
                return point.translate(point2);
            }
            return point2;
        }

        @Override
        public boolean hasFocus() {
            return NewtCanvasSWT.this.isFocusControl();
        }
    }
}

