# Stubs for builtins (Python 3)

from typing import (
    TypeVar, Iterator, Iterable, overload, Container,
    Sequence, MutableSequence, Mapping, MutableMapping, NoReturn, Tuple, List, Any, Dict, Callable, Generic,
    Set, AbstractSet, FrozenSet, MutableSet, Sized, Reversible, SupportsInt, SupportsFloat,
    SupportsComplex, SupportsBytes, SupportsAbs, SupportsRound, IO, Union, ItemsView, KeysView,
    ValuesView, ByteString, Optional, AnyStr, Type,
)
from abc import abstractmethod, ABCMeta
from types import TracebackType, CodeType
import sys

# Note that names imported above are not automatically made visible via the
# implicit builtins import.

_T = TypeVar('_T')
_T_co = TypeVar('_T_co', covariant=True)
_KT = TypeVar('_KT')
_VT = TypeVar('_VT')
_S = TypeVar('_S')
_T1 = TypeVar('_T1')
_T2 = TypeVar('_T2')
_T3 = TypeVar('_T3')
_T4 = TypeVar('_T4')
_T5 = TypeVar('_T5')
_TT = TypeVar('_TT', bound='type')

class object:
    __doc__ = ...  # type: Optional[str]
    __class__ = ...  # type: type
    __dict__ = ...  # type: Dict[str, Any]
    __slots__ = ...  # type: Union[str, Iterable[str]]
    __module__ = ...  # type: str
    if sys.version_info >= (3, 6):
        __annotations__ = ...  # type: Dict[str, Any]

    def __init__(self) -> None: ...
    def __new__(cls) -> Any: ...
    def __setattr__(self, name: str, value: Any) -> None: ...
    def __eq__(self, o: object) -> bool: ...
    def __ne__(self, o: object) -> bool: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __hash__(self) -> int: ...
    def __format__(self, format_spec: str) -> str: ...
    def __getattribute__(self, name: str) -> Any: ...
    def __delattr__(self, name: str) -> None: ...
    def __sizeof__(self) -> int: ...
    def __reduce__(self) -> tuple: ...
    def __reduce_ex__(self, protocol: int) -> tuple: ...
    def __dir__(self) -> Iterable[str]: ...

    if sys.version_info >= (3, 6):
        def __init_subclass__(cls) -> None: ...

class staticmethod:  # Special, only valid as a decorator.
    __func__ = ...  # type: function
    __isabstractmethod__ = ...  # type: bool

    def __init__(self, f: function) -> None: ...
    def __new__(cls: Type[_T], *args: Any, **kwargs: Any) -> _T: ...
    def __get__(self, obj: _T, type: Optional[Type[_T]]=...) -> function: ...

class classmethod:  # Special, only valid as a decorator.
    __func__ = ...  # type: function
    __isabstractmethod__ = ...  # type: bool

    def __init__(self, f: function) -> None: ...
    def __new__(cls: Type[_T], *args: Any, **kwargs: Any) -> _T: ...
    def __get__(self, obj: _T, type: Optional[Type[_T]]=...) -> function: ...

class type:
    __bases__ = ...  # type: Tuple[type, ...]
    __name__ = ...  # type: str
    __qualname__ = ...  # type: str
    __module__ = ...  # type: str
    __dict__ = ...  # type: Dict[str, Any]
    __mro__ = ...  # type: Tuple[type, ...]

    @overload
    def __init__(self, o: object) -> None: ...
    @overload
    def __init__(self, name: str, bases: Tuple[type, ...], dict: Dict[str, Any]) -> None: ...
    @overload
    def __new__(cls, o: object) -> type: ...
    @overload
    def __new__(cls, name: str, bases: Tuple[type, ...], namespace: Dict[str, Any]) -> type: ...
    def __call__(self, *args: Any, **kwds: Any) -> Any: ...
    def __subclasses__(self: _TT) -> List[_TT]: ...
    # Note: the documentation doesnt specify what the return type is, the standard
    # implementation seems to be returning a list.
    def mro(self) -> List[type]: ...
    def __instancecheck__(self, instance: Any) -> bool: ...
    def __subclasscheck__(self, subclass: type) -> bool: ...

class super:
    @overload
    def __init__(self, t: Any, obj: Any) -> None: ...
    @overload
    def __init__(self, t: Any) -> None: ...
    @overload
    def __init__(self) -> None: ...

class int:
    @overload
    def __init__(self, x: Union[str, bytes, SupportsInt] = ...) -> None: ...
    @overload
    def __init__(self, x: Union[str, bytes], base: int) -> None: ...

    def bit_length(self) -> int: ...
    def to_bytes(self, length: int, byteorder: str, *, signed: bool = ...) -> bytes: ...
    @classmethod
    def from_bytes(cls, bytes: Sequence[int], byteorder: str, *,
                   signed: bool = ...) -> int: ...  # TODO buffer object argument

    def __add__(self, x: int) -> int: ...
    def __sub__(self, x: int) -> int: ...
    def __mul__(self, x: int) -> int: ...
    def __floordiv__(self, x: int) -> int: ...
    def __truediv__(self, x: int) -> float: ...
    def __mod__(self, x: int) -> int: ...
    def __divmod__(self, x: int) -> Tuple[int, int]: ...
    def __radd__(self, x: int) -> int: ...
    def __rsub__(self, x: int) -> int: ...
    def __rmul__(self, x: int) -> int: ...
    def __rfloordiv__(self, x: int) -> int: ...
    def __rtruediv__(self, x: int) -> float: ...
    def __rmod__(self, x: int) -> int: ...
    def __rdivmod__(self, x: int) -> Tuple[int, int]: ...
    def __pow__(self, x: int) -> Any: ...  # Return type can be int or float, depending on x.
    def __rpow__(self, x: int) -> Any: ...
    def __and__(self, n: int) -> int: ...
    def __or__(self, n: int) -> int: ...
    def __xor__(self, n: int) -> int: ...
    def __lshift__(self, n: int) -> int: ...
    def __rshift__(self, n: int) -> int: ...
    def __rand__(self, n: int) -> int: ...
    def __ror__(self, n: int) -> int: ...
    def __rxor__(self, n: int) -> int: ...
    def __rlshift__(self, n: int) -> int: ...
    def __rrshift__(self, n: int) -> int: ...
    def __neg__(self) -> int: ...
    def __pos__(self) -> int: ...
    def __invert__(self) -> int: ...
    def __round__(self, ndigits: Optional[int] = ...) -> int: ...

    def __eq__(self, x: object) -> bool: ...
    def __ne__(self, x: object) -> bool: ...
    def __lt__(self, x: int) -> bool: ...
    def __le__(self, x: int) -> bool: ...
    def __gt__(self, x: int) -> bool: ...
    def __ge__(self, x: int) -> bool: ...

    def __str__(self) -> str: ...
    def __float__(self) -> float: ...
    def __int__(self) -> int: ...
    def __abs__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __index__(self) -> int: ...

class float:
    def __init__(self, x: Union[SupportsFloat, str, bytes] = ...) -> None: ...
    def as_integer_ratio(self) -> Tuple[int, int]: ...
    def hex(self) -> str: ...
    def is_integer(self) -> bool: ...
    @classmethod
    def fromhex(cls, s: str) -> float: ...

    def __add__(self, x: float) -> float: ...
    def __sub__(self, x: float) -> float: ...
    def __mul__(self, x: float) -> float: ...
    def __floordiv__(self, x: float) -> float: ...
    def __truediv__(self, x: float) -> float: ...
    def __mod__(self, x: float) -> float: ...
    def __divmod__(self, x: float) -> Tuple[float, float]: ...
    def __pow__(self, x: float) -> float: ...
    def __radd__(self, x: float) -> float: ...
    def __rsub__(self, x: float) -> float: ...
    def __rmul__(self, x: float) -> float: ...
    def __rfloordiv__(self, x: float) -> float: ...
    def __rtruediv__(self, x: float) -> float: ...
    def __rmod__(self, x: float) -> float: ...
    def __rdivmod__(self, x: float) -> Tuple[float, float]: ...
    def __rpow__(self, x: float) -> float: ...
    @overload
    def __round__(self) -> int: ...
    @overload
    def __round__(self, ndigits: None) -> int: ...
    @overload
    def __round__(self, ndigits: int) -> float: ...

    def __eq__(self, x: object) -> bool: ...
    def __ne__(self, x: object) -> bool: ...
    def __lt__(self, x: float) -> bool: ...
    def __le__(self, x: float) -> bool: ...
    def __gt__(self, x: float) -> bool: ...
    def __ge__(self, x: float) -> bool: ...
    def __neg__(self) -> float: ...
    def __pos__(self) -> float: ...

    def __str__(self) -> str: ...
    def __int__(self) -> int: ...
    def __float__(self) -> float: ...
    def __abs__(self) -> float: ...
    def __hash__(self) -> int: ...
    def __bool__(self) -> bool: ...

class complex:
    @overload
    def __init__(self, re: float = ..., im: float = ...) -> None: ...
    @overload
    def __init__(self, s: str) -> None: ...
    @overload
    def __init__(self, s: SupportsComplex) -> None: ...

    @property
    def real(self) -> float: ...
    @property
    def imag(self) -> float: ...

    def conjugate(self) -> complex: ...

    def __add__(self, x: complex) -> complex: ...
    def __sub__(self, x: complex) -> complex: ...
    def __mul__(self, x: complex) -> complex: ...
    def __pow__(self, x: complex) -> complex: ...
    def __truediv__(self, x: complex) -> complex: ...
    def __radd__(self, x: complex) -> complex: ...
    def __rsub__(self, x: complex) -> complex: ...
    def __rmul__(self, x: complex) -> complex: ...
    def __rpow__(self, x: complex) -> complex: ...
    def __rtruediv__(self, x: complex) -> complex: ...

    def __eq__(self, x: object) -> bool: ...
    def __ne__(self, x: object) -> bool: ...
    def __neg__(self) -> complex: ...
    def __pos__(self) -> complex: ...

    def __str__(self) -> str: ...
    def __complex__(self) -> complex: ...
    def __abs__(self) -> float: ...
    def __hash__(self) -> int: ...
    def __bool__(self) -> bool: ...

class str(Sequence[str]):
    @overload
    def __init__(self, o: object = ...) -> None: ...
    @overload
    def __init__(self, o: bytes, encoding: str = ..., errors: str = ...) -> None: ...

    def capitalize(self) -> str: ...
    def casefold(self) -> str: ...
    def center(self, width: int, fillchar: str = ...) -> str: ...
    def count(self, x: str, __start: Optional[int] = ..., __end: Optional[int] = ...) -> int: ...
    def encode(self, encoding: str = ..., errors: str = ...) -> bytes: ...
    def endswith(self, suffix: Union[str, Tuple[str, ...]], start: Optional[int] = ...,
                 end: Optional[int] = ...) -> bool: ...
    def expandtabs(self, tabsize: int = ...) -> str: ...
    def find(self, sub: str, __start: Optional[int] = ..., __end: Optional[int] = ...) -> int: ...
    def format(self, *args: Any, **kwargs: Any) -> str: ...
    def format_map(self, map: Mapping[str, Any]) -> str: ...
    def index(self, sub: str, __start: Optional[int] = ..., __end: Optional[int] = ...) -> int: ...
    def isalnum(self) -> bool: ...
    def isalpha(self) -> bool: ...
    def isdecimal(self) -> bool: ...
    def isdigit(self) -> bool: ...
    def isidentifier(self) -> bool: ...
    def islower(self) -> bool: ...
    def isnumeric(self) -> bool: ...
    def isprintable(self) -> bool: ...
    def isspace(self) -> bool: ...
    def istitle(self) -> bool: ...
    def isupper(self) -> bool: ...
    def join(self, iterable: Iterable[str]) -> str: ...
    def ljust(self, width: int, fillchar: str = ...) -> str: ...
    def lower(self) -> str: ...
    def lstrip(self, chars: Optional[str] = ...) -> str: ...
    def partition(self, sep: str) -> Tuple[str, str, str]: ...
    def replace(self, old: str, new: str, count: int = ...) -> str: ...
    def rfind(self, sub: str, __start: Optional[int] = ..., __end: Optional[int] = ...) -> int: ...
    def rindex(self, sub: str, __start: Optional[int] = ..., __end: Optional[int] = ...) -> int: ...
    def rjust(self, width: int, fillchar: str = ...) -> str: ...
    def rpartition(self, sep: str) -> Tuple[str, str, str]: ...
    def rsplit(self, sep: Optional[str] = ..., maxsplit: int = ...) -> List[str]: ...
    def rstrip(self, chars: Optional[str] = ...) -> str: ...
    def split(self, sep: Optional[str] = ..., maxsplit: int = ...) -> List[str]: ...
    def splitlines(self, keepends: bool = ...) -> List[str]: ...
    def startswith(self, prefix: Union[str, Tuple[str, ...]], start: Optional[int] = ...,
                   end: Optional[int] = ...) -> bool: ...
    def strip(self, chars: Optional[str] = ...) -> str: ...
    def swapcase(self) -> str: ...
    def title(self) -> str: ...
    def translate(self, table: Union[Mapping[int, Union[int, str, None]], Sequence[Union[int, str, None]]]) -> str: ...
    def upper(self) -> str: ...
    def zfill(self, width: int) -> str: ...
    @staticmethod
    @overload
    def maketrans(x: Union[Dict[int, _T], Dict[str, _T], Dict[Union[str, int], _T]]) -> Dict[int, _T]: ...
    @staticmethod
    @overload
    def maketrans(x: str, y: str, z: str = ...) -> Dict[int, Union[int, None]]: ...

    def __getitem__(self, i: Union[int, slice]) -> str: ...
    def __add__(self, s: str) -> str: ...
    def __mul__(self, n: int) -> str: ...
    def __rmul__(self, n: int) -> str: ...
    def __mod__(self, value: Any) -> str: ...
    def __eq__(self, x: object) -> bool: ...
    def __ne__(self, x: object) -> bool: ...
    def __lt__(self, x: str) -> bool: ...
    def __le__(self, x: str) -> bool: ...
    def __gt__(self, x: str) -> bool: ...
    def __ge__(self, x: str) -> bool: ...

    def __len__(self) -> int: ...
    def __contains__(self, s: object) -> bool: ...
    def __iter__(self) -> Iterator[str]: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __hash__(self) -> int: ...

class bytes(ByteString):
    @overload
    def __init__(self, ints: Iterable[int]) -> None: ...
    @overload
    def __init__(self, string: str, encoding: str,
                 errors: str = ...) -> None: ...
    @overload
    def __init__(self, length: int) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: SupportsBytes) -> None: ...
    def capitalize(self) -> bytes: ...
    def center(self, width: int, fillchar: bytes = ...) -> bytes: ...
    def count(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    def decode(self, encoding: str = ..., errors: str = ...) -> str: ...
    def endswith(self, suffix: Union[bytes, Tuple[bytes, ...]]) -> bool: ...
    def expandtabs(self, tabsize: int = ...) -> bytes: ...
    def find(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    if sys.version_info >= (3, 5):
        def hex(self) -> str: ...
    def index(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    def isalnum(self) -> bool: ...
    def isalpha(self) -> bool: ...
    def isdigit(self) -> bool: ...
    def islower(self) -> bool: ...
    def isspace(self) -> bool: ...
    def istitle(self) -> bool: ...
    def isupper(self) -> bool: ...
    def join(self, iterable: Iterable[Union[ByteString, memoryview]]) -> bytes: ...
    def ljust(self, width: int, fillchar: bytes = ...) -> bytes: ...
    def lower(self) -> bytes: ...
    def lstrip(self, chars: Optional[bytes] = ...) -> bytes: ...
    def partition(self, sep: bytes) -> Tuple[bytes, bytes, bytes]: ...
    def replace(self, old: bytes, new: bytes, count: int = ...) -> bytes: ...
    def rfind(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    def rindex(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    def rjust(self, width: int, fillchar: bytes = ...) -> bytes: ...
    def rpartition(self, sep: bytes) -> Tuple[bytes, bytes, bytes]: ...
    def rsplit(self, sep: Optional[bytes] = ..., maxsplit: int = ...) -> List[bytes]: ...
    def rstrip(self, chars: Optional[bytes] = ...) -> bytes: ...
    def split(self, sep: Optional[bytes] = ..., maxsplit: int = ...) -> List[bytes]: ...
    def splitlines(self, keepends: bool = ...) -> List[bytes]: ...
    def startswith(self, prefix: Union[bytes, Tuple[bytes, ...]]) -> bool: ...
    def strip(self, chars: Optional[bytes] = ...) -> bytes: ...
    def swapcase(self) -> bytes: ...
    def title(self) -> bytes: ...
    def translate(self, table: Optional[bytes], delete: bytes = ...) -> bytes: ...
    def upper(self) -> bytes: ...
    def zfill(self, width: int) -> bytes: ...
    @classmethod
    def fromhex(cls, s: str) -> bytes: ...
    @classmethod
    def maketrans(cls, frm: bytes, to: bytes) -> bytes: ...

    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __int__(self) -> int: ...
    def __float__(self) -> float: ...
    def __hash__(self) -> int: ...
    @overload
    def __getitem__(self, i: int) -> int: ...
    @overload
    def __getitem__(self, s: slice) -> bytes: ...
    def __add__(self, s: bytes) -> bytes: ...
    def __mul__(self, n: int) -> bytes: ...
    def __rmul__(self, n: int) -> bytes: ...
    if sys.version_info >= (3, 5):
        def __mod__(self, value: Any) -> bytes: ...
    def __contains__(self, o: object) -> bool: ...
    def __eq__(self, x: object) -> bool: ...
    def __ne__(self, x: object) -> bool: ...
    def __lt__(self, x: bytes) -> bool: ...
    def __le__(self, x: bytes) -> bool: ...
    def __gt__(self, x: bytes) -> bool: ...
    def __ge__(self, x: bytes) -> bool: ...

class bytearray(MutableSequence[int], ByteString):
    @overload
    def __init__(self, ints: Iterable[int]) -> None: ...
    @overload
    def __init__(self, string: str, encoding: str, errors: str = ...) -> None: ...
    @overload
    def __init__(self, length: int) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def capitalize(self) -> bytearray: ...
    def center(self, width: int, fillchar: bytes = ...) -> bytearray: ...
    def count(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    def copy(self) -> bytearray: ...
    def decode(self, encoding: str = ..., errors: str = ...) -> str: ...
    def endswith(self, suffix: bytes) -> bool: ...
    def expandtabs(self, tabsize: int = ...) -> bytearray: ...
    def find(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    if sys.version_info >= (3, 5):
        def hex(self) -> str: ...
    def index(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    def insert(self, index: int, object: int) -> None: ...
    def isalnum(self) -> bool: ...
    def isalpha(self) -> bool: ...
    def isdigit(self) -> bool: ...
    def islower(self) -> bool: ...
    def isspace(self) -> bool: ...
    def istitle(self) -> bool: ...
    def isupper(self) -> bool: ...
    def join(self, iterable: Iterable[Union[ByteString, memoryview]]) -> bytearray: ...
    def ljust(self, width: int, fillchar: bytes = ...) -> bytearray: ...
    def lower(self) -> bytearray: ...
    def lstrip(self, chars: Optional[bytes] = ...) -> bytearray: ...
    def partition(self, sep: bytes) -> Tuple[bytearray, bytearray, bytearray]: ...
    def replace(self, old: bytes, new: bytes, count: int = ...) -> bytearray: ...
    def rfind(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    def rindex(self, sub: Union[bytes, int], start: Optional[int] = ..., end: Optional[int] = ...) -> int: ...
    def rjust(self, width: int, fillchar: bytes = ...) -> bytearray: ...
    def rpartition(self, sep: bytes) -> Tuple[bytearray, bytearray, bytearray]: ...
    def rsplit(self, sep: Optional[bytes] = ..., maxsplit: int = ...) -> List[bytearray]: ...
    def rstrip(self, chars: Optional[bytes] = ...) -> bytearray: ...
    def split(self, sep: Optional[bytes] = ..., maxsplit: int = ...) -> List[bytearray]: ...
    def splitlines(self, keepends: bool = ...) -> List[bytearray]: ...
    def startswith(self, prefix: bytes) -> bool: ...
    def strip(self, chars: Optional[bytes] = ...) -> bytearray: ...
    def swapcase(self) -> bytearray: ...
    def title(self) -> bytearray: ...
    def translate(self, table: Optional[bytes], delete: bytes = ...) -> bytearray: ...
    def upper(self) -> bytearray: ...
    def zfill(self, width: int) -> bytearray: ...
    @classmethod
    def fromhex(cls, s: str) -> bytearray: ...
    @classmethod
    def maketrans(cls, frm: bytes, to: bytes) -> bytes: ...

    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __int__(self) -> int: ...
    def __float__(self) -> float: ...
    def __hash__(self) -> int: ...
    @overload
    def __getitem__(self, i: int) -> int: ...
    @overload
    def __getitem__(self, s: slice) -> bytearray: ...
    @overload
    def __setitem__(self, i: int, x: int) -> None: ...
    @overload
    def __setitem__(self, s: slice, x: Union[Iterable[int], bytes]) -> None: ...
    def __delitem__(self, i: Union[int, slice]) -> None: ...
    def __add__(self, s: bytes) -> bytearray: ...
    def __iadd__(self, s: Iterable[int]) -> bytearray: ...
    def __mul__(self, n: int) -> bytearray: ...
    def __rmul__(self, n: int) -> bytearray: ...
    def __imul__(self, n: int) -> bytearray: ...
    if sys.version_info >= (3, 5):
        def __mod__(self, value: Any) -> bytes: ...
    def __contains__(self, o: object) -> bool: ...
    def __eq__(self, x: object) -> bool: ...
    def __ne__(self, x: object) -> bool: ...
    def __lt__(self, x: bytes) -> bool: ...
    def __le__(self, x: bytes) -> bool: ...
    def __gt__(self, x: bytes) -> bool: ...
    def __ge__(self, x: bytes) -> bool: ...

class memoryview(Sized, Container[int]):
    format = ...  # type: str
    itemsize = ...  # type: int
    shape = ...  # type: Optional[Tuple[int, ...]]
    strides = ...  # type: Optional[Tuple[int, ...]]
    suboffsets = ...  # type: Optional[Tuple[int, ...]]
    readonly = ...  # type: bool
    ndim = ...  # type: int

    def __init__(self, obj: Union[bytes, bytearray, memoryview]) -> None: ...

    @overload
    def __getitem__(self, i: int) -> int: ...
    @overload
    def __getitem__(self, s: slice) -> memoryview: ...

    def __contains__(self, x: object) -> bool: ...
    def __iter__(self) -> Iterator[int]: ...
    def __len__(self) -> int: ...

    @overload
    def __setitem__(self, i: int, o: bytes) -> None: ...
    @overload
    def __setitem__(self, s: slice, o: Sequence[bytes]) -> None: ...
    @overload
    def __setitem__(self, s: slice, o: memoryview) -> None: ...

    def tobytes(self) -> bytes: ...
    def tolist(self) -> List[int]: ...

    if sys.version_info >= (3, 5):
        def hex(self) -> str: ...

class bool(int):
    def __init__(self, o: object = ...) -> None: ...
    @overload  # type: ignore
    def __and__(self, x: bool) -> bool: ...
    @overload  # type: ignore
    def __and__(self, x: int) -> int: ...
    @overload  # type: ignore
    def __or__(self, x: bool) -> bool: ...
    @overload  # type: ignore
    def __or__(self, x: int) -> int: ...
    @overload  # type: ignore
    def __xor__(self, x: bool) -> bool: ...
    @overload  # type: ignore
    def __xor__(self, x: int) -> int: ...
    @overload  # type: ignore
    def __rand__(self, x: bool) -> bool: ...
    @overload  # type: ignore
    def __rand__(self, x: int) -> int: ...
    @overload  # type: ignore
    def __ror__(self, x: bool) -> bool: ...
    @overload  # type: ignore
    def __ror__(self, x: int) -> int: ...
    @overload  # type: ignore
    def __rxor__(self, x: bool) -> bool: ...
    @overload  # type: ignore
    def __rxor__(self, x: int) -> int: ...

class slice:
    start = ...  # type: Optional[int]
    step = ...  # type: Optional[int]
    stop = ...  # type: Optional[int]
    @overload
    def __init__(self, stop: Optional[int]) -> None: ...
    @overload
    def __init__(self, start: Optional[int], stop: Optional[int], step: Optional[int] = ...) -> None: ...
    def indices(self, len: int) -> Tuple[int, int, int]: ...

class tuple(Sequence[_T_co], Generic[_T_co]):
    def __new__(cls: Type[_T], iterable: Iterable[_T_co] = ...) -> _T: ...
    def __init__(self, iterable: Iterable[_T_co] = ...) -> None: ...
    def __len__(self) -> int: ...
    def __contains__(self, x: object) -> bool: ...
    @overload
    def __getitem__(self, x: int) -> _T_co: ...
    @overload
    def __getitem__(self, x: slice) -> Tuple[_T_co, ...]: ...
    def __iter__(self) -> Iterator[_T_co]: ...
    def __lt__(self, x: Tuple[_T_co, ...]) -> bool: ...
    def __le__(self, x: Tuple[_T_co, ...]) -> bool: ...
    def __gt__(self, x: Tuple[_T_co, ...]) -> bool: ...
    def __ge__(self, x: Tuple[_T_co, ...]) -> bool: ...
    def __add__(self, x: Tuple[_T_co, ...]) -> Tuple[_T_co, ...]: ...
    def __mul__(self, n: int) -> Tuple[_T_co, ...]: ...
    def __rmul__(self, n: int) -> Tuple[_T_co, ...]: ...
    def count(self, x: Any) -> int: ...
    if sys.version_info >= (3, 5):
        def index(self, x: Any, start: int = ..., end: int = ...) -> int: ...
    else:
        def index(self, x: Any) -> int: ...

class function:
    # TODO not defined in builtins!
    __name__ = ...  # type: str
    __qualname__ = ...  # type: str
    __module__ = ...  # type: str
    __code__ = ...  # type: CodeType
    __annotations__ = ...  # type: Dict[str, Any]

class list(MutableSequence[_T], Generic[_T]):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, iterable: Iterable[_T]) -> None: ...
    def clear(self) -> None: ...
    def copy(self) -> List[_T]: ...
    def append(self, object: _T) -> None: ...
    def extend(self, iterable: Iterable[_T]) -> None: ...
    def pop(self, index: int = ...) -> _T: ...
    def index(self, object: _T, start: int = ..., stop: int = ...) -> int: ...
    def count(self, object: _T) -> int: ...
    def insert(self, index: int, object: _T) -> None: ...
    def remove(self, object: _T) -> None: ...
    def reverse(self) -> None: ...
    def sort(self, *, key: Optional[Callable[[_T], Any]] = ..., reverse: bool = ...) -> None: ...

    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[_T]: ...
    def __str__(self) -> str: ...
    def __hash__(self) -> int: ...
    @overload
    def __getitem__(self, i: int) -> _T: ...
    @overload
    def __getitem__(self, s: slice) -> List[_T]: ...
    @overload
    def __setitem__(self, i: int, o: _T) -> None: ...
    @overload
    def __setitem__(self, s: slice, o: Iterable[_T]) -> None: ...
    def __delitem__(self, i: Union[int, slice]) -> None: ...
    def __add__(self, x: List[_T]) -> List[_T]: ...
    def __iadd__(self, x: Iterable[_T]) -> List[_T]: ...
    def __mul__(self, n: int) -> List[_T]: ...
    def __rmul__(self, n: int) -> List[_T]: ...
    def __imul__(self, n: int) -> List[_T]: ...
    def __contains__(self, o: object) -> bool: ...
    def __reversed__(self) -> Iterator[_T]: ...
    def __gt__(self, x: List[_T]) -> bool: ...
    def __ge__(self, x: List[_T]) -> bool: ...
    def __lt__(self, x: List[_T]) -> bool: ...
    def __le__(self, x: List[_T]) -> bool: ...

class dict(MutableMapping[_KT, _VT], Generic[_KT, _VT]):
    # NOTE: Keyword arguments are special. If they are used, _KT must include
    #       str, but we have no way of enforcing it here.
    @overload
    def __init__(self, **kwargs: _VT) -> None: ...
    @overload
    def __init__(self, map: Mapping[_KT, _VT], **kwargs: _VT) -> None: ...
    @overload
    def __init__(self, iterable: Iterable[Tuple[_KT, _VT]], **kwargs: _VT) -> None: ...

    def __new__(cls: Type[_T1], *args: Any, **kwargs: Any) -> _T1: ...

    def clear(self) -> None: ...
    def copy(self) -> Dict[_KT, _VT]: ...
    def popitem(self) -> Tuple[_KT, _VT]: ...
    def setdefault(self, k: _KT, default: Optional[_VT] = ...) -> _VT: ...
    @overload
    def update(self, __m: Mapping[_KT, _VT], **kwargs: _VT) -> None: ...
    @overload
    def update(self, __m: Iterable[Tuple[_KT, _VT]], **kwargs: _VT) -> None: ...
    @overload
    def update(self, **kwargs: _VT) -> None: ...
    def keys(self) -> KeysView[_KT]: ...
    def values(self) -> ValuesView[_VT]: ...
    def items(self) -> ItemsView[_KT, _VT]: ...
    @staticmethod
    @overload
    def fromkeys(seq: Iterable[_T]) -> Dict[_T, Any]: ...  # TODO: Actually a class method (mypy/issues#328)
    @staticmethod
    @overload
    def fromkeys(seq: Iterable[_T], value: _S) -> Dict[_T, _S]: ...
    def __len__(self) -> int: ...
    def __getitem__(self, k: _KT) -> _VT: ...
    def __setitem__(self, k: _KT, v: _VT) -> None: ...
    def __delitem__(self, v: _KT) -> None: ...
    def __iter__(self) -> Iterator[_KT]: ...
    def __str__(self) -> str: ...

class set(MutableSet[_T], Generic[_T]):
    def __init__(self, iterable: Iterable[_T] = ...) -> None: ...
    def add(self, element: _T) -> None: ...
    def clear(self) -> None: ...
    def copy(self) -> Set[_T]: ...
    def difference(self, *s: Iterable[object]) -> Set[_T]: ...
    def difference_update(self, *s: Iterable[object]) -> None: ...
    def discard(self, element: _T) -> None: ...
    def intersection(self, *s: Iterable[object]) -> Set[_T]: ...
    def intersection_update(self, *s: Iterable[Any]) -> None: ...
    def isdisjoint(self, s: Iterable[Any]) -> bool: ...
    def issubset(self, s: Iterable[Any]) -> bool: ...
    def issuperset(self, s: Iterable[Any]) -> bool: ...
    def pop(self) -> _T: ...
    def remove(self, element: _T) -> None: ...
    def symmetric_difference(self, s: Iterable[_T]) -> Set[_T]: ...
    def symmetric_difference_update(self, s: Iterable[_T]) -> None: ...
    def union(self, *s: Iterable[_T]) -> Set[_T]: ...
    def update(self, *s: Iterable[_T]) -> None: ...
    def __len__(self) -> int: ...
    def __contains__(self, o: object) -> bool: ...
    def __iter__(self) -> Iterator[_T]: ...
    def __str__(self) -> str: ...
    def __and__(self, s: AbstractSet[object]) -> Set[_T]: ...
    def __iand__(self, s: AbstractSet[object]) -> Set[_T]: ...
    def __or__(self, s: AbstractSet[_S]) -> Set[Union[_T, _S]]: ...
    def __ior__(self, s: AbstractSet[_S]) -> Set[Union[_T, _S]]: ...
    def __sub__(self, s: AbstractSet[object]) -> Set[_T]: ...
    def __isub__(self, s: AbstractSet[object]) -> Set[_T]: ...
    def __xor__(self, s: AbstractSet[_S]) -> Set[Union[_T, _S]]: ...
    def __ixor__(self, s: AbstractSet[_S]) -> Set[Union[_T, _S]]: ...
    def __le__(self, s: AbstractSet[object]) -> bool: ...
    def __lt__(self, s: AbstractSet[object]) -> bool: ...
    def __ge__(self, s: AbstractSet[object]) -> bool: ...
    def __gt__(self, s: AbstractSet[object]) -> bool: ...

class frozenset(AbstractSet[_T], Generic[_T]):
    def __init__(self, iterable: Iterable[_T] = ...) -> None: ...
    def copy(self) -> FrozenSet[_T]: ...
    def difference(self, *s: Iterable[object]) -> FrozenSet[_T]: ...
    def intersection(self, *s: Iterable[object]) -> FrozenSet[_T]: ...
    def isdisjoint(self, s: Iterable[_T]) -> bool: ...
    def issubset(self, s: Iterable[object]) -> bool: ...
    def issuperset(self, s: Iterable[object]) -> bool: ...
    def symmetric_difference(self, s: Iterable[_T]) -> FrozenSet[_T]: ...
    def union(self, *s: Iterable[_T]) -> FrozenSet[_T]: ...
    def __len__(self) -> int: ...
    def __contains__(self, o: object) -> bool: ...
    def __iter__(self) -> Iterator[_T]: ...
    def __str__(self) -> str: ...
    def __and__(self, s: AbstractSet[_T]) -> FrozenSet[_T]: ...
    def __or__(self, s: AbstractSet[_S]) -> FrozenSet[Union[_T, _S]]: ...
    def __sub__(self, s: AbstractSet[_T]) -> FrozenSet[_T]: ...
    def __xor__(self, s: AbstractSet[_S]) -> FrozenSet[Union[_T, _S]]: ...
    def __le__(self, s: AbstractSet[object]) -> bool: ...
    def __lt__(self, s: AbstractSet[object]) -> bool: ...
    def __ge__(self, s: AbstractSet[object]) -> bool: ...
    def __gt__(self, s: AbstractSet[object]) -> bool: ...

class enumerate(Iterator[Tuple[int, _T]], Generic[_T]):
    def __init__(self, iterable: Iterable[_T], start: int = ...) -> None: ...
    def __iter__(self) -> Iterator[Tuple[int, _T]]: ...
    def __next__(self) -> Tuple[int, _T]: ...

class range(Sequence[int]):
    start = ...  # type: int
    stop = ...  # type: int
    step = ...  # type: int
    @overload
    def __init__(self, stop: int) -> None: ...
    @overload
    def __init__(self, start: int, stop: int, step: int = ...) -> None: ...
    def count(self, value: int) -> int: ...
    def index(self, value: int, start: int = ..., stop: Optional[int] = ...) -> int: ...
    def __len__(self) -> int: ...
    def __contains__(self, o: object) -> bool: ...
    def __iter__(self) -> Iterator[int]: ...
    @overload
    def __getitem__(self, i: int) -> int: ...
    @overload
    def __getitem__(self, s: slice) -> range: ...
    def __repr__(self) -> str: ...
    def __reversed__(self) -> Iterator[int]: ...

class property:
    def __init__(self, fget: Optional[Callable[[Any], Any]] = ...,
                 fset: Optional[Callable[[Any, Any], None]] = ...,
                 fdel: Optional[Callable[[Any], None]] = ...,
                 doc: Optional[str] = ...) -> None: ...
    def getter(self, fget: Callable[[Any], Any]) -> property: ...
    def setter(self, fset: Callable[[Any, Any], None]) -> property: ...
    def deleter(self, fdel: Callable[[Any], None]) -> property: ...
    def __get__(self, obj: Any, type: Optional[type] = ...) -> Any: ...
    def __set__(self, obj: Any, value: Any) -> None: ...
    def __delete__(self, obj: Any) -> None: ...
    def fget(self) -> Any: ...
    def fset(self, value: Any) -> None: ...
    def fdel(self) -> None: ...

NotImplemented = ...  # type: Any

def abs(n: SupportsAbs[_T]) -> _T: ...
def all(i: Iterable[object]) -> bool: ...
def any(i: Iterable[object]) -> bool: ...
def ascii(o: object) -> str: ...
def bin(number: int) -> str: ...
if sys.version_info >= (3, 7):
    def breakpoint(*args: Any, **kws: Any) -> None: ...
def callable(o: object) -> bool: ...
def chr(code: int) -> str: ...
if sys.version_info >= (3, 6):
    # This class is to be exported as PathLike from os,
    # but we define it here as _PathLike to avoid import cycle issues.
    # See https://github.com/python/typeshed/pull/991#issuecomment-288160993
    class _PathLike(Generic[AnyStr]):
        def __fspath__(self) -> AnyStr: ...
    def compile(source: Any, filename: Union[str, bytes, _PathLike], mode: str, flags: int = ..., dont_inherit: int = ...) -> CodeType: ...
else:
    def compile(source: Any, filename: Union[str, bytes], mode: str, flags: int = ..., dont_inherit: int = ...) -> CodeType: ...
def copyright() -> None: ...
def credits() -> None: ...
def delattr(o: Any, name: str) -> None: ...
def dir(o: object = ...) -> List[str]: ...
_N = TypeVar('_N', int, float)
def divmod(a: _N, b: _N) -> Tuple[_N, _N]: ...
def eval(source: Union[str, bytes, CodeType], globals: Optional[Dict[str, Any]] = ..., locals: Optional[Mapping[str, Any]] = ...) -> Any: ...
def exec(object: Union[str, bytes, CodeType], globals: Optional[Dict[str, Any]] = ..., locals: Optional[Mapping[str, Any]] = ...) -> Any: ...
def exit(code: Any = ...) -> NoReturn: ...
@overload
def filter(function: None, iterable: Iterable[Optional[_T]]) -> Iterator[_T]: ...
@overload
def filter(function: Callable[[_T], Any], iterable: Iterable[_T]) -> Iterator[_T]: ...
def format(o: object, format_spec: str = ...) -> str: ...
def getattr(o: Any, name: str, default: Any = ...) -> Any: ...
def globals() -> Dict[str, Any]: ...
def hasattr(o: Any, name: str) -> bool: ...
def hash(o: object) -> int: ...
def help(*args: Any, **kwds: Any) -> None: ...
def hex(i: int) -> str: ...  # TODO __index__
def id(o: object) -> int: ...
def input(prompt: Optional[Any] = ...) -> str: ...
@overload
def iter(iterable: Iterable[_T]) -> Iterator[_T]: ...
@overload
def iter(function: Callable[[], _T], sentinel: _T) -> Iterator[_T]: ...
def isinstance(o: object, t: Union[type, Tuple[Union[type, Tuple], ...]]) -> bool: ...
def issubclass(cls: type, classinfo: Union[type, Tuple[Union[type, Tuple], ...]]) -> bool: ...
def len(o: Sized) -> int: ...
def license() -> None: ...
def locals() -> Dict[str, Any]: ...
@overload
def map(func: Callable[[_T1], _S], iter1: Iterable[_T1]) -> Iterator[_S]: ...
@overload
def map(func: Callable[[_T1, _T2], _S], iter1: Iterable[_T1],
        iter2: Iterable[_T2]) -> Iterator[_S]: ...
@overload
def map(func: Callable[[_T1, _T2, _T3], _S],
        iter1: Iterable[_T1],
        iter2: Iterable[_T2],
        iter3: Iterable[_T3]) -> Iterator[_S]: ...
@overload
def map(func: Callable[[_T1, _T2, _T3, _T4], _S],
        iter1: Iterable[_T1],
        iter2: Iterable[_T2],
        iter3: Iterable[_T3],
        iter4: Iterable[_T4]) -> Iterator[_S]: ...
@overload
def map(func: Callable[[_T1, _T2, _T3, _T4, _T5], _S],
        iter1: Iterable[_T1],
        iter2: Iterable[_T2],
        iter3: Iterable[_T3],
        iter4: Iterable[_T4],
        iter5: Iterable[_T5]) -> Iterator[_S]: ...
@overload
def map(func: Callable[..., _S],
        iter1: Iterable[Any],
        iter2: Iterable[Any],
        iter3: Iterable[Any],
        iter4: Iterable[Any],
        iter5: Iterable[Any],
        iter6: Iterable[Any],
        *iterables: Iterable[Any]) -> Iterator[_S]: ...
@overload
def max(arg1: _T, arg2: _T, *args: _T, key: Callable[[_T], Any] = ...) -> _T: ...
@overload
def max(iterable: Iterable[_T], key: Callable[[_T], Any] = ..., default: _T = ...) -> _T: ...
@overload
def min(arg1: _T, arg2: _T, *args: _T, key: Callable[[_T], Any] = ...) -> _T: ...
@overload
def min(iterable: Iterable[_T], key: Callable[[_T], Any] = ..., default: _T = ...) -> _T: ...
@overload
def next(i: Iterator[_T]) -> _T: ...
@overload
def next(i: Iterator[_T], default: _VT) -> Union[_T, _VT]: ...
def oct(i: int) -> str: ...  # TODO __index__

if sys.version_info >= (3, 6):
    def open(file: Union[str, bytes, int, _PathLike], mode: str = ..., buffering: int = ..., encoding: Optional[str] = ...,
             errors: Optional[str] = ..., newline: Optional[str] = ..., closefd: bool = ...) -> IO[Any]: ...
else:
    def open(file: Union[str, bytes, int], mode: str = ..., buffering: int = ..., encoding: Optional[str] = ...,
             errors: Optional[str] = ..., newline: Optional[str] = ..., closefd: bool = ...) -> IO[Any]: ...

def ord(c: Union[str, bytes, bytearray]) -> int: ...
def print(*values: Any, sep: str = ..., end: str = ..., file: Optional[IO[str]] = ..., flush: bool = ...) -> None: ...
@overload
def pow(x: int, y: int) -> Any: ...  # The return type can be int or float, depending on y
@overload
def pow(x: int, y: int, z: int) -> Any: ...
@overload
def pow(x: float, y: float) -> float: ...
@overload
def pow(x: float, y: float, z: float) -> float: ...
def quit(code: Optional[int] = ...) -> None: ...
@overload
def reversed(object: Sequence[_T]) -> Iterator[_T]: ...
@overload
def reversed(object: Reversible[_T]) -> Iterator[_T]: ...
def repr(o: object) -> str: ...
@overload
def round(number: float) -> int: ...
@overload
def round(number: float, ndigits: None) -> int: ...
@overload
def round(number: float, ndigits: int) -> float: ...
@overload
def round(number: SupportsRound[_T]) -> int: ...
@overload
def round(number: SupportsRound[_T], ndigits: None) -> int: ...  # type: ignore
@overload
def round(number: SupportsRound[_T], ndigits: int) -> _T: ...
def setattr(object: Any, name: str, value: Any) -> None: ...
def sorted(iterable: Iterable[_T], *,
           key: Optional[Callable[[_T], Any]] = ...,
           reverse: bool = ...) -> List[_T]: ...
@overload
def sum(iterable: Iterable[_T]) -> Union[_T, int]: ...
@overload
def sum(iterable: Iterable[_T], start: _S) -> Union[_T, _S]: ...
def vars(object: Any = ...) -> Dict[str, Any]: ...
@overload
def zip(iter1: Iterable[_T1]) -> Iterator[Tuple[_T1]]: ...
@overload
def zip(iter1: Iterable[_T1], iter2: Iterable[_T2]) -> Iterator[Tuple[_T1, _T2]]: ...
@overload
def zip(iter1: Iterable[_T1], iter2: Iterable[_T2],
        iter3: Iterable[_T3]) -> Iterator[Tuple[_T1, _T2, _T3]]: ...
@overload
def zip(iter1: Iterable[_T1], iter2: Iterable[_T2], iter3: Iterable[_T3],
        iter4: Iterable[_T4]) -> Iterator[Tuple[_T1, _T2,
                                               _T3, _T4]]: ...
@overload
def zip(iter1: Iterable[_T1], iter2: Iterable[_T2], iter3: Iterable[_T3],
        iter4: Iterable[_T4], iter5: Iterable[_T5]) -> Iterator[Tuple[_T1, _T2,
                                                                      _T3, _T4, _T5]]: ...
@overload
def zip(iter1: Iterable[Any], iter2: Iterable[Any], iter3: Iterable[Any],
        iter4: Iterable[Any], iter5: Iterable[Any], iter6: Iterable[Any],
        *iterables: Iterable[Any]) -> Iterator[Tuple[Any, ...]]: ...
def __import__(name: str, globals: Dict[str, Any] = ..., locals: Dict[str, Any] = ...,
               fromlist: List[str] = ..., level: int = ...) -> Any: ...

# Ellipsis

# Actually the type of Ellipsis is <type 'ellipsis'>, but since it's
# not exposed anywhere under that name, we make it private here.
class ellipsis: ...
Ellipsis = ...  # type: ellipsis

# Exceptions

class BaseException:
    args = ...  # type: Tuple[Any, ...]
    __cause__ = ...  # type: Optional[BaseException]
    __context__ = ...  # type: Optional[BaseException]
    __traceback__ = ...  # type: Optional[TracebackType]
    def __init__(self, *args: object) -> None: ...
    def with_traceback(self, tb: Optional[TracebackType]) -> BaseException: ...

class GeneratorExit(BaseException): ...
class KeyboardInterrupt(BaseException): ...
class SystemExit(BaseException):
    code = 0
class Exception(BaseException): ...
class ArithmeticError(Exception): ...
class OSError(Exception):
    errno = 0
    strerror = ...  # type: str
    # filename, filename2 are actually Union[str, bytes, None]
    filename = ...  # type: Any
    filename2 = ...  # type: Any
IOError = OSError
EnvironmentError = OSError
class WindowsError(OSError):
    winerror = ...  # type: int
class LookupError(Exception): ...
class RuntimeError(Exception): ...
class ValueError(Exception): ...
class AssertionError(Exception): ...
class AttributeError(Exception): ...
class BufferError(Exception): ...
class EOFError(Exception): ...
class FloatingPointError(ArithmeticError): ...
class ImportError(Exception):
    name = ...  # type: str
    path = ...  # type: str
if sys.version_info >= (3, 6):
    class ModuleNotFoundError(ImportError): ...
class IndexError(LookupError): ...
class KeyError(LookupError): ...
class MemoryError(Exception): ...
class NameError(Exception): ...
class NotImplementedError(RuntimeError): ...
class BlockingIOError(OSError):
    characters_written = 0
class ChildProcessError(OSError): ...
class ConnectionError(OSError): ...
class BrokenPipeError(ConnectionError): ...
class ConnectionAbortedError(ConnectionError): ...
class ConnectionRefusedError(ConnectionError): ...
class ConnectionResetError(ConnectionError): ...
class FileExistsError(OSError): ...
class FileNotFoundError(OSError): ...
class InterruptedError(OSError): ...
class IsADirectoryError(OSError): ...
class NotADirectoryError(OSError): ...
class PermissionError(OSError): ...
class ProcessLookupError(OSError): ...
class TimeoutError(OSError): ...
class OverflowError(ArithmeticError): ...
class ReferenceError(Exception): ...
class StopIteration(Exception):
    value = ...  # type: Any
if sys.version_info >= (3, 5):
    class StopAsyncIteration(Exception):
        value = ...  # type: Any
    class RecursionError(RuntimeError): ...
class SyntaxError(Exception):
    msg = ...  # type: str
    lineno = ...  # type: int
    offset = ...  # type: int
    text = ...  # type: str
    filename = ...  # type: str
class IndentationError(SyntaxError): ...
class TabError(IndentationError): ...
class SystemError(Exception): ...
class TypeError(Exception): ...
class UnboundLocalError(NameError): ...
class UnicodeError(ValueError): ...
class UnicodeDecodeError(UnicodeError):
    encoding = ...  # type: str
    object = ...  # type: bytes
    start = ...  # type: int
    end = ...  # type: int
    reason = ...  # type: str
    def __init__(self, __encoding: str, __object: bytes, __start: int, __end: int,
                 __reason: str) -> None: ...
class UnicodeEncodeError(UnicodeError):
    encoding = ...  # type: str
    object = ...  # type: str
    start = ...  # type: int
    end = ...  # type: int
    reason = ...  # type: str
    def __init__(self, __encoding: str, __object: str, __start: int, __end: int,
                 __reason: str) -> None: ...
class UnicodeTranslateError(UnicodeError): ...
class ZeroDivisionError(ArithmeticError): ...

class Warning(Exception): ...
class UserWarning(Warning): ...
class DeprecationWarning(Warning): ...
class SyntaxWarning(Warning): ...
class RuntimeWarning(Warning): ...
class FutureWarning(Warning): ...
class PendingDeprecationWarning(Warning): ...
class ImportWarning(Warning): ...
class UnicodeWarning(Warning): ...
class BytesWarning(Warning): ...
class ResourceWarning(Warning): ...
