/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jnlp.DownloadServiceListener;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheEntry;
import net.sourceforge.jnlp.cache.CacheLRUWrapper;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.ConnectionFactory;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.PropertiesFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public class CacheUtil {
    public static URL getCachedResourceURL(URL location, Version version, UpdatePolicy policy) {
        try {
            File f = CacheUtil.getCachedResourceFile(location, version, policy);
            if (f == null) {
                return null;
            }
            return f.toURL();
        }
        catch (MalformedURLException ex) {
            return location;
        }
    }

    public static File getCachedResourceFile(URL location, Version version, UpdatePolicy policy) {
        ResourceTracker rt = new ResourceTracker();
        rt.addResource(location, version, null, policy);
        File f = rt.getCacheFile(location);
        return f;
    }

    public static Permission getReadPermission(URL location, Version version) {
        Permission result = null;
        if (CacheUtil.isCacheable(location, version)) {
            File file = CacheUtil.getCacheFile(location, version);
            result = new FilePermission(file.getPath(), "read");
        } else {
            try {
                URLConnection conn = ConnectionFactory.getConnectionFactory().openConnection(location);
                result = conn.getPermission();
                ConnectionFactory.getConnectionFactory().disconnect(conn);
            }
            catch (IOException ioe) {
                OutputController.getLogger().log(ioe);
            }
        }
        return result;
    }

    public static boolean clearCache() {
        if (!CacheUtil.okToClearCache()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("CCannotClearCache"));
            return false;
        }
        CacheLRUWrapper lruHandler = CacheLRUWrapper.getInstance();
        File cacheDir = lruHandler.getCacheDir().getFile();
        if (!cacheDir.isDirectory()) {
            return false;
        }
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Clearing cache directory: " + cacheDir);
        lruHandler.lock();
        try {
            cacheDir = cacheDir.getCanonicalFile();
            FileUtils.recursiveDelete(cacheDir, cacheDir);
            cacheDir.mkdir();
            lruHandler.clearLRUSortedEntries();
            lruHandler.store();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            lruHandler.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean okToClearCache() {
        File otherJavawsRunning = PathsAndFiles.MAIN_LOCK.getFile();
        FileLock locking = null;
        try {
            if (otherJavawsRunning.isFile()) {
                FileOutputStream fis = new FileOutputStream(otherJavawsRunning);
                FileChannel channel = fis.getChannel();
                locking = channel.tryLock();
                if (locking == null) {
                    OutputController.getLogger().log("Other instances of netx are running");
                    boolean bl = false;
                    return bl;
                }
                OutputController.getLogger().log("No other instances of netx are running");
                boolean bl = true;
                return bl;
            }
            OutputController.getLogger().log("No instance file found");
            boolean fis = true;
            return fis;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (locking != null) {
                try {
                    locking.release();
                }
                catch (IOException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
        }
    }

    public static boolean isCurrent(URL source, Version version, long lastModifed) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", source));
        }
        try {
            CacheEntry entry = new CacheEntry(source, version);
            boolean result = entry.isCurrent(lastModifed);
            OutputController.getLogger().log("isCurrent: " + source + " = " + result);
            return result;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return CacheUtil.isCached(source, version);
        }
    }

    public static boolean isCached(URL source, Version version) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", source));
        }
        CacheEntry entry = new CacheEntry(source, version);
        boolean result = entry.isCached();
        OutputController.getLogger().log("isCached: " + source + " = " + result);
        return result;
    }

    public static boolean isCacheable(URL source, Version version) {
        if (source == null) {
            return false;
        }
        if (source.getProtocol().equals("file")) {
            return false;
        }
        return !source.getProtocol().equals("jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getCacheFile(URL source, Version version) {
        CacheLRUWrapper lruHandler;
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", source));
        }
        File cacheFile = null;
        CacheLRUWrapper cacheLRUWrapper = lruHandler = CacheLRUWrapper.getInstance();
        synchronized (cacheLRUWrapper) {
            try {
                lruHandler.lock();
                lruHandler.load();
                cacheFile = CacheUtil.getCacheFileIfExist(CacheUtil.urlToPath(source, ""));
                if (cacheFile == null) {
                    cacheFile = CacheUtil.makeNewCacheFile(source, version);
                } else {
                    lruHandler.store();
                }
            }
            finally {
                lruHandler.unlock();
            }
        }
        return cacheFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getCacheFileIfExist(File urlPath) {
        CacheLRUWrapper lruHandler;
        CacheLRUWrapper cacheLRUWrapper = lruHandler = CacheLRUWrapper.getInstance();
        synchronized (cacheLRUWrapper) {
            File cacheFile = null;
            List<Map.Entry<String, String>> entries = lruHandler.getLRUSortedEntries();
            for (Map.Entry<String, String> e : entries) {
                String key = e.getKey();
                String path = e.getValue();
                if (!CacheUtil.pathToURLPath(path).equals(urlPath.getPath())) continue;
                cacheFile = new File(path);
                lruHandler.updateEntry(key);
                break;
            }
            return cacheFile;
        }
    }

    private static String pathToURLPath(String path) {
        int len = CacheLRUWrapper.getInstance().getCacheDir().getFullPath().length();
        int index = path.indexOf(File.separatorChar, len + 1);
        return path.substring(index);
    }

    public static String getCacheParentDirectory(String filePath) {
        String tempPath;
        String path = filePath;
        String cacheDir = CacheLRUWrapper.getInstance().getCacheDir().getFullPath();
        while (path.startsWith(cacheDir) && !path.equals(cacheDir) && !(tempPath = new File(path).getParent()).equals(cacheDir)) {
            path = tempPath;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File makeNewCacheFile(URL source, Version version) {
        CacheLRUWrapper lruHandler;
        CacheLRUWrapper cacheLRUWrapper = lruHandler = CacheLRUWrapper.getInstance();
        synchronized (cacheLRUWrapper) {
            File cacheFile = null;
            try {
                lruHandler.lock();
                lruHandler.load();
                for (long i = 0L; i < Long.MAX_VALUE; ++i) {
                    String path = lruHandler.getCacheDir().getFullPath() + File.separator + i;
                    File cDir = new File(path);
                    if (cDir.exists()) continue;
                    try {
                        cacheFile = CacheUtil.urlToPath(source, path);
                        FileUtils.createParentDir(cacheFile);
                        File pf = new File(cacheFile.getPath() + ".info");
                        FileUtils.createRestrictedFile(pf, true);
                        lruHandler.addEntry(lruHandler.generateKey(cacheFile.getPath()), cacheFile.getPath());
                    }
                    catch (IOException ioe) {
                        OutputController.getLogger().log(ioe);
                    }
                    break;
                }
                lruHandler.store();
            }
            finally {
                lruHandler.unlock();
            }
            return cacheFile;
        }
    }

    public static OutputStream getOutputStream(URL source, Version version) throws IOException {
        File localFile = CacheUtil.getCacheFile(source, version);
        FileOutputStream out = new FileOutputStream(localFile);
        return new BufferedOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(InputStream is, OutputStream os) throws IOException {
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        if (!(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        try {
            int c;
            byte[] b = new byte[4096];
            while ((c = is.read(b, 0, b.length)) != -1) {
                os.write(b, 0, c);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static File urlToPath(URL location, String subdir) {
        File candidate;
        if (subdir == null) {
            throw new NullPointerException();
        }
        StringBuilder path = new StringBuilder();
        path.append(subdir);
        path.append(File.separatorChar);
        path.append(location.getProtocol());
        path.append(File.separatorChar);
        path.append(location.getHost());
        path.append(File.separatorChar);
        if (location.getPort() > 0) {
            path.append(location.getPort());
            path.append(File.separatorChar);
        }
        path.append(location.getPath().replace('/', File.separatorChar));
        if (location.getQuery() != null && !location.getQuery().trim().isEmpty()) {
            path.append(".").append(location.getQuery());
        }
        if ((candidate = new File(FileUtils.sanitizePath(path.toString()))).getName().length() > 255) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] sum = md.digest(candidate.getName().getBytes(StandardCharsets.UTF_8));
                StringBuilder hexString = new StringBuilder();
                for (int i = 0; i < sum.length; ++i) {
                    hexString.append(Integer.toHexString(0xFF & sum[i]));
                }
                String extension = "";
                int i = candidate.getName().lastIndexOf(46);
                if (i > 0) {
                    extension = candidate.getName().substring(i);
                }
                if (extension.length() < 10 && extension.length() > 1) {
                    hexString.append(extension);
                }
                candidate = new File(candidate.getParentFile(), hexString.toString());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException(ex);
            }
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForResources(ApplicationInstance app, ResourceTracker tracker, URL[] resources, String title) {
        DownloadIndicator indicator = JNLPRuntime.getDefaultDownloadIndicator();
        DownloadServiceListener listener = null;
        try {
            if (indicator == null) {
                tracker.waitForResources(resources, 0L);
                return;
            }
            if (tracker.waitForResources(resources, indicator.getInitialDelay())) {
                return;
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (URL url : resources) {
                if (tracker.checkResource(url)) continue;
                urlList.add(url);
            }
            URL[] undownloaded = urlList.toArray(new URL[urlList.size()]);
            listener = indicator.getListener(app, title, undownloaded);
            do {
                long read = 0L;
                long total = 0L;
                for (URL url : undownloaded) {
                    total += tracker.getTotalSize(url);
                    read += tracker.getAmountRead(url);
                }
                int percent = (int)(100L * read / Math.max(1L, total));
                for (URL url : undownloaded) {
                    listener.progress(url, "version", tracker.getAmountRead(url), tracker.getTotalSize(url), percent);
                }
            } while (!tracker.waitForResources(resources, indicator.getUpdateRate()));
            for (URL url : undownloaded) {
                listener.progress(url, "version", tracker.getTotalSize(url), tracker.getTotalSize(url), 100);
            }
            if (listener != null) {
                indicator.disposeListener(listener);
            }
        }
        catch (InterruptedException ex) {
            OutputController.getLogger().log(ex);
        }
        finally {
            if (listener != null) {
                indicator.disposeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanCache() {
        CacheLRUWrapper lruHandler = CacheLRUWrapper.getInstance();
        if (CacheUtil.okToClearCache()) {
            HashSet<String> keep = new HashSet<String>();
            HashSet<String> remove = new HashSet<String>();
            try {
                lruHandler.lock();
                lruHandler.load();
                long maxSize = -1L;
                try {
                    maxSize = Long.parseLong(JNLPRuntime.getConfiguration().getProperty("deployment.cache.max.size"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                maxSize <<= 20;
                long curSize = 0L;
                for (Map.Entry<String, String> e : lruHandler.getLRUSortedEntries()) {
                    String key = e.getKey();
                    String path = e.getValue();
                    File file = new File(path);
                    PropertiesFile pf = new PropertiesFile(new File(path + ".info"));
                    boolean delete = Boolean.parseBoolean(pf.getProperty("delete"));
                    String rStr = file.getPath().substring(lruHandler.getCacheDir().getFullPath().length());
                    rStr = lruHandler.getCacheDir().getFullPath() + rStr.substring(0, rStr.indexOf(File.separatorChar, 1));
                    long len = file.length();
                    if (keep.contains(file.getPath().substring(rStr.length()))) {
                        lruHandler.removeEntry(key);
                        continue;
                    }
                    if (delete || !file.isFile() || maxSize >= 0L && curSize + len > maxSize) {
                        lruHandler.removeEntry(key);
                        remove.add(rStr);
                        continue;
                    }
                    curSize += len;
                    keep.add(file.getPath().substring(rStr.length()));
                    for (File f : file.getParentFile().listFiles()) {
                        if (f.equals(file) || f.equals(pf.getStoreFile())) continue;
                        try {
                            FileUtils.recursiveDelete(f, f);
                        }
                        catch (IOException e1) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e1);
                        }
                    }
                }
                lruHandler.store();
            }
            finally {
                lruHandler.unlock();
            }
            CacheUtil.removeSetOfDirectories(remove);
        }
    }

    private static void removeSetOfDirectories(Set<String> remove) {
        for (String s : remove) {
            File f = new File(s);
            try {
                FileUtils.recursiveDelete(f, f);
            }
            catch (IOException iOException) {}
        }
    }
}

