#ifndef _EFL_INTERPOLATOR_DECELERATE_EO_H_
#define _EFL_INTERPOLATOR_DECELERATE_EO_H_

#ifndef _EFL_INTERPOLATOR_DECELERATE_EO_CLASS_TYPE
#define _EFL_INTERPOLATOR_DECELERATE_EO_CLASS_TYPE

typedef Eo Efl_Interpolator_Decelerate;

#endif

#ifndef _EFL_INTERPOLATOR_DECELERATE_EO_TYPES
#define _EFL_INTERPOLATOR_DECELERATE_EO_TYPES


#endif
/**
 * @brief Efl decelerate interpolator class
 *
 * output = sin(input * Pi / 2);
 *
 * @ingroup Efl_Interpolator_Decelerate
 */
#define EFL_INTERPOLATOR_DECELERATE_CLASS efl_interpolator_decelerate_class_get()

EWAPI const Efl_Class *efl_interpolator_decelerate_class_get(void);

/**
 * @brief Factor property
 *
 * @param[in] obj The object.
 * @param[in] factor Factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Decelerate
 */
EOAPI void efl_interpolator_decelerate_factor_set(Eo *obj, double factor);

/**
 * @brief Factor property
 *
 * @param[in] obj The object.
 *
 * @return Factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Decelerate
 */
EOAPI double efl_interpolator_decelerate_factor_get(const Eo *obj);

#endif
