#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 9
#define STATE_COUNT 3289
#define SYMBOL_COUNT 147
#define ALIAS_COUNT 5
#define TOKEN_COUNT 92
#define EXTERNAL_TOKEN_COUNT 12
#define MAX_ALIAS_SEQUENCE_LENGTH 8

enum {
  sym_heredoc_start = 1,
  sym__simple_heredoc_body = 2,
  sym__heredoc_body_beginning = 3,
  sym__heredoc_body_middle = 4,
  sym__heredoc_body_end = 5,
  sym_file_descriptor = 6,
  sym__empty_value = 7,
  sym__concat = 8,
  sym_variable_name = 9,
  anon_sym_for = 10,
  anon_sym_in = 11,
  anon_sym_LPAREN_LPAREN = 12,
  anon_sym_RPAREN_RPAREN = 13,
  anon_sym_while = 14,
  anon_sym_do = 15,
  anon_sym_done = 16,
  anon_sym_if = 17,
  anon_sym_then = 18,
  anon_sym_fi = 19,
  anon_sym_elif = 20,
  anon_sym_else = 21,
  anon_sym_case = 22,
  anon_sym_esac = 23,
  anon_sym_PIPE = 24,
  anon_sym_RPAREN = 25,
  anon_sym_SEMI_SEMI = 26,
  anon_sym_function = 27,
  anon_sym_LPAREN = 28,
  anon_sym_LBRACE = 29,
  anon_sym_RBRACE = 30,
  anon_sym_PIPE_AMP = 31,
  anon_sym_AMP_AMP = 32,
  anon_sym_PIPE_PIPE = 33,
  anon_sym_BANG = 34,
  anon_sym_LBRACK = 35,
  anon_sym_RBRACK = 36,
  anon_sym_LBRACK_LBRACK = 37,
  anon_sym_RBRACK_RBRACK = 38,
  anon_sym_declare = 39,
  anon_sym_typeset = 40,
  anon_sym_export = 41,
  anon_sym_readonly = 42,
  anon_sym_local = 43,
  anon_sym_unset = 44,
  anon_sym_unsetenv = 45,
  anon_sym_EQ_TILDE = 46,
  anon_sym_EQ_EQ = 47,
  anon_sym_EQ = 48,
  anon_sym_PLUS_EQ = 49,
  anon_sym_LT = 50,
  anon_sym_GT = 51,
  anon_sym_GT_GT = 52,
  anon_sym_AMP_GT = 53,
  anon_sym_AMP_GT_GT = 54,
  anon_sym_LT_AMP = 55,
  anon_sym_GT_AMP = 56,
  anon_sym_LT_LT = 57,
  anon_sym_LT_LT_DASH = 58,
  anon_sym_LT_LT_LT = 59,
  anon_sym_BANG_EQ = 60,
  sym__special_characters = 61,
  anon_sym_DQUOTE = 62,
  anon_sym_DOLLAR = 63,
  sym__string_content = 64,
  sym_raw_string = 65,
  anon_sym_POUND = 66,
  anon_sym_DOLLAR_LBRACE = 67,
  anon_sym_SLASH = 68,
  anon_sym_COLON = 69,
  anon_sym_COLON_QMARK = 70,
  anon_sym_COLON_DASH = 71,
  anon_sym_PERCENT = 72,
  anon_sym_DASH = 73,
  anon_sym_DOLLAR_LPAREN = 74,
  anon_sym_BQUOTE = 75,
  anon_sym_LT_LPAREN = 76,
  anon_sym_GT_LPAREN = 77,
  sym_comment = 78,
  aux_sym_SLASH_BSLASHw_PLUS_SLASH = 79,
  anon_sym_STAR = 80,
  anon_sym_AT = 81,
  anon_sym_QMARK = 82,
  anon_sym_0 = 83,
  anon_sym__ = 84,
  sym_word = 85,
  sym_test_operator = 86,
  sym_regex = 87,
  sym_regex_without_right_brace = 88,
  anon_sym_SEMI = 89,
  anon_sym_LF = 90,
  anon_sym_AMP = 91,
  sym_program = 92,
  sym__terminated_statement = 93,
  sym_for_statement = 94,
  sym_c_style_for_statement = 95,
  sym_while_statement = 96,
  sym_do_group = 97,
  sym_if_statement = 98,
  sym_elif_clause = 99,
  sym_else_clause = 100,
  sym_case_statement = 101,
  sym_case_item = 102,
  sym_last_case_item = 103,
  sym_function_definition = 104,
  sym_compound_statement = 105,
  sym_subshell = 106,
  sym_pipeline = 107,
  sym_list = 108,
  sym_negated_command = 109,
  sym_test_command = 110,
  sym_declaration_command = 111,
  sym_unset_command = 112,
  sym_command = 113,
  sym_command_name = 114,
  sym_variable_assignment = 115,
  sym_subscript = 116,
  sym_file_redirect = 117,
  sym_heredoc_redirect = 118,
  sym_heredoc_body = 119,
  sym_herestring_redirect = 120,
  sym__expression = 121,
  sym_binary_expression = 122,
  sym_unary_expression = 123,
  sym_parenthesized_expression = 124,
  sym_concatenation = 125,
  sym_string = 126,
  sym_array = 127,
  sym_simple_expansion = 128,
  sym_string_expansion = 129,
  sym_expansion = 130,
  sym_command_substitution = 131,
  sym_process_substitution = 132,
  aux_sym__statements_repeat1 = 133,
  aux_sym_for_statement_repeat1 = 134,
  aux_sym_while_statement_repeat1 = 135,
  aux_sym_if_statement_repeat1 = 136,
  aux_sym_case_statement_repeat1 = 137,
  aux_sym_case_item_repeat1 = 138,
  aux_sym_declaration_command_repeat1 = 139,
  aux_sym_unset_command_repeat1 = 140,
  aux_sym_command_repeat1 = 141,
  aux_sym_command_repeat2 = 142,
  aux_sym_heredoc_body_repeat1 = 143,
  aux_sym_concatenation_repeat1 = 144,
  aux_sym_string_repeat1 = 145,
  aux_sym_expansion_repeat1 = 146,
  alias_sym_case_item = 147,
  alias_sym_regex = 148,
  alias_sym_special_variable_name = 149,
  alias_sym_variable_name = 150,
  alias_sym_word = 151,
};

static const char *ts_symbol_names[] = {
  [sym_heredoc_start] = "heredoc_start",
  [sym__simple_heredoc_body] = "_simple_heredoc_body",
  [sym__heredoc_body_beginning] = "_heredoc_body_beginning",
  [sym__heredoc_body_middle] = "_heredoc_body_middle",
  [sym__heredoc_body_end] = "_heredoc_body_end",
  [sym_file_descriptor] = "file_descriptor",
  [sym__empty_value] = "_empty_value",
  [sym__concat] = "_concat",
  [sym_variable_name] = "variable_name",
  [ts_builtin_sym_end] = "END",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_LPAREN_LPAREN] = "((",
  [anon_sym_RPAREN_RPAREN] = "))",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_done] = "done",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_fi] = "fi",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_case] = "case",
  [anon_sym_esac] = "esac",
  [anon_sym_PIPE] = "|",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI_SEMI] = ";;",
  [anon_sym_function] = "function",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PIPE_AMP] = "|&",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_declare] = "declare",
  [anon_sym_typeset] = "typeset",
  [anon_sym_export] = "export",
  [anon_sym_readonly] = "readonly",
  [anon_sym_local] = "local",
  [anon_sym_unset] = "unset",
  [anon_sym_unsetenv] = "unsetenv",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_GT] = "&>",
  [anon_sym_AMP_GT_GT] = "&>>",
  [anon_sym_LT_AMP] = "<&",
  [anon_sym_GT_AMP] = ">&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_LT_LT_LT] = "<<<",
  [anon_sym_BANG_EQ] = "!=",
  [sym__special_characters] = "_special_characters",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DOLLAR] = "$",
  [sym__string_content] = "_string_content",
  [sym_raw_string] = "raw_string",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_COLON_QMARK] = ":?",
  [anon_sym_COLON_DASH] = ":-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DASH] = "-",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LT_LPAREN] = "<(",
  [anon_sym_GT_LPAREN] = ">(",
  [sym_comment] = "comment",
  [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = "/\\w+/",
  [anon_sym_STAR] = "*",
  [anon_sym_AT] = "@",
  [anon_sym_QMARK] = "?",
  [anon_sym_0] = "0",
  [anon_sym__] = "_",
  [sym_word] = "word",
  [sym_test_operator] = "test_operator",
  [sym_regex] = "regex",
  [sym_regex_without_right_brace] = "regex_without_right_brace",
  [anon_sym_SEMI] = ";",
  [anon_sym_LF] = "\n",
  [anon_sym_AMP] = "&",
  [sym_program] = "program",
  [sym__terminated_statement] = "_terminated_statement",
  [sym_for_statement] = "for_statement",
  [sym_c_style_for_statement] = "c_style_for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_group] = "do_group",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_case_statement] = "case_statement",
  [sym_case_item] = "case_item",
  [sym_last_case_item] = "last_case_item",
  [sym_function_definition] = "function_definition",
  [sym_compound_statement] = "compound_statement",
  [sym_subshell] = "subshell",
  [sym_pipeline] = "pipeline",
  [sym_list] = "list",
  [sym_negated_command] = "negated_command",
  [sym_test_command] = "test_command",
  [sym_declaration_command] = "declaration_command",
  [sym_unset_command] = "unset_command",
  [sym_command] = "command",
  [sym_command_name] = "command_name",
  [sym_variable_assignment] = "variable_assignment",
  [sym_subscript] = "subscript",
  [sym_file_redirect] = "file_redirect",
  [sym_heredoc_redirect] = "heredoc_redirect",
  [sym_heredoc_body] = "heredoc_body",
  [sym_herestring_redirect] = "herestring_redirect",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_concatenation] = "concatenation",
  [sym_string] = "string",
  [sym_array] = "array",
  [sym_simple_expansion] = "simple_expansion",
  [sym_string_expansion] = "string_expansion",
  [sym_expansion] = "expansion",
  [sym_command_substitution] = "command_substitution",
  [sym_process_substitution] = "process_substitution",
  [aux_sym__statements_repeat1] = "_statements_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_while_statement_repeat1] = "while_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_case_item_repeat1] = "case_item_repeat1",
  [aux_sym_declaration_command_repeat1] = "declaration_command_repeat1",
  [aux_sym_unset_command_repeat1] = "unset_command_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_command_repeat2] = "command_repeat2",
  [aux_sym_heredoc_body_repeat1] = "heredoc_body_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_expansion_repeat1] = "expansion_repeat1",
  [alias_sym_case_item] = "case_item",
  [alias_sym_regex] = "regex",
  [alias_sym_special_variable_name] = "special_variable_name",
  [alias_sym_variable_name] = "variable_name",
  [alias_sym_word] = "word",
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [sym_heredoc_start] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_heredoc_body] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_beginning] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_value] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_esac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsetenv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym__special_characters] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [sym_test_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_without_right_brace] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_c_style_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_group] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_last_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_subshell] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_command] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_command] = {
    .visible = true,
    .named = true,
  },
  [sym_unset_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_body] = {
    .visible = true,
    .named = true,
  },
  [sym_herestring_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_process_substitution] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_while_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unset_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_heredoc_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_regex] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_special_variable_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_word] = {
    .visible = true,
    .named = true,
  },
};

static TSSymbol ts_alias_sequences[23][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [1] = {
    [0] = alias_sym_word,
  },
  [2] = {
    [0] = alias_sym_variable_name,
  },
  [3] = {
    [1] = alias_sym_word,
  },
  [4] = {
    [1] = alias_sym_special_variable_name,
  },
  [5] = {
    [1] = alias_sym_variable_name,
  },
  [6] = {
    [2] = alias_sym_word,
  },
  [7] = {
    [2] = alias_sym_special_variable_name,
  },
  [8] = {
    [2] = alias_sym_variable_name,
  },
  [9] = {
    [3] = alias_sym_word,
  },
  [10] = {
    [1] = alias_sym_special_variable_name,
    [3] = alias_sym_regex,
  },
  [11] = {
    [1] = alias_sym_variable_name,
    [3] = alias_sym_regex,
  },
  [12] = {
    [3] = alias_sym_regex,
  },
  [13] = {
    [1] = alias_sym_word,
    [4] = alias_sym_case_item,
  },
  [14] = {
    [4] = alias_sym_case_item,
  },
  [15] = {
    [4] = alias_sym_word,
  },
  [16] = {
    [2] = alias_sym_special_variable_name,
    [4] = alias_sym_regex,
  },
  [17] = {
    [2] = alias_sym_variable_name,
    [4] = alias_sym_regex,
  },
  [18] = {
    [4] = alias_sym_regex,
  },
  [19] = {
    [1] = alias_sym_word,
    [5] = alias_sym_case_item,
  },
  [20] = {
    [5] = alias_sym_case_item,
  },
  [21] = {
    [1] = alias_sym_word,
    [6] = alias_sym_case_item,
  },
  [22] = {
    [6] = alias_sym_case_item,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == '*')
        ADVANCE(20);
      if (lookahead == '+')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(23);
      if (lookahead == '/')
        ADVANCE(24);
      if (lookahead == '0')
        ADVANCE(25);
      if (lookahead == ':')
        ADVANCE(26);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(31);
      if (lookahead == '=')
        ADVANCE(37);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '?')
        ADVANCE(44);
      if (lookahead == '@')
        ADVANCE(45);
      if (lookahead == '[')
        ADVANCE(46);
      if (lookahead == '\\')
        ADVANCE(48);
      if (lookahead == ']')
        ADVANCE(49);
      if (lookahead == '_')
        ADVANCE(50);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(52);
      if (lookahead == 'i')
        ADVANCE(56);
      if (lookahead == '{')
        ADVANCE(58);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(0);
      ADVANCE(5);
      END_STATE();
    case 1:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 2:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 4:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(5);
      END_STATE();
    case 5:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 6:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(')
        ADVANCE(9);
      if (lookahead == '{')
        ADVANCE(10);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&')
        ADVANCE(13);
      if (lookahead == '>')
        ADVANCE(14);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_AMP_GT);
      if (lookahead == '>')
        ADVANCE(15);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_AMP_GT_GT);
      END_STATE();
    case 16:
      if (lookahead == '\'')
        ADVANCE(17);
      if (lookahead != 0)
        ADVANCE(16);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(sym_raw_string);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=')
        ADVANCE(22);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-')
        ADVANCE(27);
      if (lookahead == '?')
        ADVANCE(28);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '?' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_COLON_DASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_COLON_QMARK);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == ';')
        ADVANCE(30);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(32);
      if (lookahead == '(')
        ADVANCE(33);
      if (lookahead == '<')
        ADVANCE(34);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LT_AMP);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '-')
        ADVANCE(35);
      if (lookahead == '<')
        ADVANCE(36);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_LT_LT_LT);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=')
        ADVANCE(38);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == '~')
        ADVANCE(39);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '~'))
        ADVANCE(5);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(41);
      if (lookahead == '(')
        ADVANCE(42);
      if (lookahead == '>')
        ADVANCE(43);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_GT_AMP);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[')
        ADVANCE(47);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 48:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(0);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 's')
        ADVANCE(53);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'a')
        ADVANCE(54);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          lookahead != 'a' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'c')
        ADVANCE(55);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'n')
        ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&')
        ADVANCE(60);
      if (lookahead == '|')
        ADVANCE(61);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_PIPE_AMP);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 63:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(65);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(46);
      if (lookahead == '\\')
        ADVANCE(67);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(63);
      if ((lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n')
        ADVANCE(64);
      END_STATE();
    case 65:
      if (lookahead == '>')
        ADVANCE(14);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(32);
      if (lookahead == '(')
        ADVANCE(33);
      END_STATE();
    case 67:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(63);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym__special_characters);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      END_STATE();
    case 69:
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '+')
        ADVANCE(70);
      if (lookahead == '=')
        ADVANCE(72);
      if (lookahead == '[')
        ADVANCE(73);
      if (lookahead == '\\')
        SKIP(74);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(69);
      END_STATE();
    case 70:
      if (lookahead == '=')
        ADVANCE(71);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 74:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(69);
      END_STATE();
    case 75:
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '(')
        ADVANCE(76);
      if (lookahead == '\\')
        SKIP(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(79);
      END_STATE();
    case 76:
      if (lookahead == '(')
        ADVANCE(77);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LPAREN_LPAREN);
      END_STATE();
    case 78:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(75);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(79);
      END_STATE();
    case 80:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(65);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(81);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(80);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 81:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(80);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 82:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(65);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(46);
      if (lookahead == '\\')
        ADVANCE(83);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(82);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 83:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(82);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 84:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == '-')
        ADVANCE(85);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(89);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(84);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(86);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '`' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(86);
      END_STATE();
    case 87:
      if (lookahead == '(')
        ADVANCE(33);
      END_STATE();
    case 88:
      if (lookahead == '(')
        ADVANCE(42);
      END_STATE();
    case 89:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(84);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 90:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(91);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(92);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(93);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&')
        ADVANCE(13);
      END_STATE();
    case 92:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(90);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(93);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 94:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(31);
      if (lookahead == '=')
        ADVANCE(95);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(96);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(94);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=')
        ADVANCE(38);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == '~')
        ADVANCE(39);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '~'))
        ADVANCE(5);
      END_STATE();
    case 96:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(94);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 97:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(98);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\\')
        ADVANCE(102);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(103);
      if (lookahead != 0)
        ADVANCE(99);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(99);
      if (lookahead == '\\')
        ADVANCE(101);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '$' &&
          lookahead != '`')
        ADVANCE(98);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\\')
        ADVANCE(100);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '$' &&
          lookahead != '`')
        ADVANCE(99);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(99);
      if (lookahead == '\\')
        ADVANCE(100);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(99);
      if (lookahead != 0)
        ADVANCE(99);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(99);
      if (lookahead == '\\')
        ADVANCE(101);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(98);
      if (lookahead != 0)
        ADVANCE(98);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(103);
      if (lookahead == '\\')
        ADVANCE(100);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(103);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(99);
      if (lookahead != 0)
        ADVANCE(99);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '#')
        ADVANCE(98);
      if (lookahead == '\\')
        ADVANCE(102);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(103);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          lookahead != '`')
        ADVANCE(99);
      END_STATE();
    case 104:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(105);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(106);
      if (lookahead == '-')
        ADVANCE(107);
      if (lookahead == '0')
        ADVANCE(108);
      if (lookahead == '?')
        ADVANCE(109);
      if (lookahead == '@')
        ADVANCE(110);
      if (lookahead == '\\')
        SKIP(111);
      if (lookahead == '_')
        ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(104);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(79);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(79);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 111:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(104);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(79);
      END_STATE();
    case 113:
      if (lookahead == '!')
        ADVANCE(114);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(105);
      if (lookahead == '*')
        ADVANCE(106);
      if (lookahead == '-')
        ADVANCE(107);
      if (lookahead == '0')
        ADVANCE(108);
      if (lookahead == '?')
        ADVANCE(109);
      if (lookahead == '@')
        ADVANCE(110);
      if (lookahead == '\\')
        SKIP(115);
      if (lookahead == '_')
        ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(113);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(79);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 115:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(113);
      END_STATE();
    case 116:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(31);
      if (lookahead == '=')
        ADVANCE(95);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(117);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(116);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 117:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(116);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 118:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '\\')
        SKIP(119);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(118);
      END_STATE();
    case 119:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(118);
      END_STATE();
    case 120:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(91);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '\\')
        SKIP(121);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(120);
      END_STATE();
    case 121:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(120);
      END_STATE();
    case 122:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(123);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(122);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 123:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(122);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 124:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(31);
      if (lookahead == '=')
        ADVANCE(95);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(125);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(124);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 125:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(124);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 126:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(127);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(126);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 127:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(126);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 128:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(129);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '-')
        ADVANCE(85);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(130);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(128);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 130:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(128);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 131:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(129);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '\\')
        SKIP(132);
      if (lookahead == 'i')
        ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(131);
      END_STATE();
    case 132:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(131);
      END_STATE();
    case 133:
      if (lookahead == 'n')
        ADVANCE(134);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 135:
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '\\')
        SKIP(136);
      if (lookahead == '{')
        ADVANCE(58);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(135);
      END_STATE();
    case 136:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(135);
      END_STATE();
    case 137:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(91);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(138);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(93);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 138:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(137);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 139:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(31);
      if (lookahead == '=')
        ADVANCE(95);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(140);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(139);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 140:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(139);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 141:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(142);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(141);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(141);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 143:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(91);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '\\')
        SKIP(144);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(145);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(143);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(143);
      END_STATE();
    case 145:
      if (lookahead == 's')
        ADVANCE(146);
      END_STATE();
    case 146:
      if (lookahead == 'a')
        ADVANCE(147);
      END_STATE();
    case 147:
      if (lookahead == 'c')
        ADVANCE(148);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_esac);
      END_STATE();
    case 149:
      if (lookahead == '!')
        ADVANCE(150);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(152);
      if (lookahead == '-')
        ADVANCE(153);
      if (lookahead == '<')
        ADVANCE(155);
      if (lookahead == '=')
        ADVANCE(156);
      if (lookahead == '>')
        ADVANCE(159);
      if (lookahead == '\\')
        SKIP(160);
      if (lookahead == ']')
        ADVANCE(49);
      if (lookahead == '|')
        ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(149);
      END_STATE();
    case 150:
      if (lookahead == '=')
        ADVANCE(151);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 152:
      if (lookahead == '&')
        ADVANCE(13);
      END_STATE();
    case 153:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(154);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(154);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=')
        ADVANCE(157);
      if (lookahead == '~')
        ADVANCE(158);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 160:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(149);
      END_STATE();
    case 161:
      if (lookahead == '|')
        ADVANCE(61);
      END_STATE();
    case 162:
      if (lookahead == '!')
        ADVANCE(150);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(152);
      if (lookahead == '-')
        ADVANCE(153);
      if (lookahead == '<')
        ADVANCE(155);
      if (lookahead == '=')
        ADVANCE(156);
      if (lookahead == '>')
        ADVANCE(159);
      if (lookahead == '\\')
        SKIP(163);
      if (lookahead == ']')
        ADVANCE(164);
      if (lookahead == '|')
        ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(162);
      END_STATE();
    case 163:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(162);
      END_STATE();
    case 164:
      if (lookahead == ']')
        ADVANCE(165);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 166:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(105);
      if (lookahead == '*')
        ADVANCE(106);
      if (lookahead == '-')
        ADVANCE(107);
      if (lookahead == '0')
        ADVANCE(167);
      if (lookahead == '?')
        ADVANCE(109);
      if (lookahead == '@')
        ADVANCE(110);
      if (lookahead == '\\')
        ADVANCE(169);
      if (lookahead == '_')
        ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(170);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(168);
      if (lookahead != 0 &&
          (lookahead < '_' || lookahead > 'z'))
        ADVANCE(99);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(168);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(168);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(170);
      if (lookahead == '\\')
        ADVANCE(100);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(170);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(99);
      if (lookahead != 0)
        ADVANCE(99);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '*')
        ADVANCE(106);
      if (lookahead == '-')
        ADVANCE(107);
      if (lookahead == '0')
        ADVANCE(167);
      if (lookahead == '?')
        ADVANCE(109);
      if (lookahead == '@')
        ADVANCE(110);
      if (lookahead == '\\')
        ADVANCE(169);
      if (lookahead == '_')
        ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(170);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(168);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '_' || lookahead > 'z'))
        ADVANCE(99);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(168);
      END_STATE();
    case 172:
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(105);
      if (lookahead == '*')
        ADVANCE(106);
      if (lookahead == '-')
        ADVANCE(107);
      if (lookahead == '0')
        ADVANCE(108);
      if (lookahead == '?')
        ADVANCE(109);
      if (lookahead == '@')
        ADVANCE(110);
      if (lookahead == '\\')
        SKIP(173);
      if (lookahead == '_')
        ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(172);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(79);
      END_STATE();
    case 173:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(172);
      END_STATE();
    case 174:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '-')
        ADVANCE(23);
      if (lookahead == '/')
        ADVANCE(24);
      if (lookahead == ':')
        ADVANCE(26);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '=')
        ADVANCE(175);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(176);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(174);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > ')') &&
          (lookahead < ':' || lookahead > '>') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 176:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(174);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 177:
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(178);
      if (lookahead == '\\')
        SKIP(179);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{')
        ADVANCE(10);
      END_STATE();
    case 179:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(177);
      END_STATE();
    case 180:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(181);
      if (lookahead == '$')
        ADVANCE(183);
      if (lookahead == '\'')
        ADVANCE(188);
      if (lookahead == '<')
        ADVANCE(191);
      if (lookahead == '>')
        ADVANCE(193);
      if (lookahead == '[')
        ADVANCE(195);
      if (lookahead == '\\')
        ADVANCE(196);
      if (lookahead == ']')
        ADVANCE(195);
      if (lookahead == '`')
        ADVANCE(202);
      if (lookahead == '{')
        ADVANCE(195);
      if (lookahead == '}')
        ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(180);
      if (('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '|')
        ADVANCE(186);
      if (lookahead != 0)
        ADVANCE(199);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(182);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(182);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(181);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(')
        ADVANCE(184);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead == '{')
        ADVANCE(187);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(186);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\'')
        ADVANCE(189);
      if (lookahead == '\\')
        ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(16);
      if (lookahead != 0)
        ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_raw_string);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\n')
        ADVANCE(16);
      if (lookahead == '\'')
        ADVANCE(189);
      if (lookahead == '\\')
        ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(188);
      if (lookahead != 0)
        ADVANCE(188);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '(')
        ADVANCE(192);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '(')
        ADVANCE(194);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '[')
        ADVANCE(195);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead == ']')
        ADVANCE(195);
      if (lookahead == '{')
        ADVANCE(195);
      if (lookahead == '}')
        ADVANCE(195);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(200);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(199);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(186);
      if (('\"' <= lookahead && lookahead <= '$') ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '<' ||
          lookahead == '>' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}'))
        ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(199);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(199);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(198);
      if (('\"' <= lookahead && lookahead <= '$') ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '<' ||
          lookahead == '>' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}'))
        ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\"')
        ADVANCE(201);
      if (lookahead == '#')
        ADVANCE(181);
      if (lookahead == '$')
        ADVANCE(183);
      if (lookahead == '\'')
        ADVANCE(188);
      if (lookahead == '<')
        ADVANCE(191);
      if (lookahead == '>')
        ADVANCE(193);
      if (lookahead == '[')
        ADVANCE(195);
      if (lookahead == '\\')
        ADVANCE(196);
      if (lookahead == ']')
        ADVANCE(195);
      if (lookahead == '`')
        ADVANCE(202);
      if (lookahead == '{')
        ADVANCE(195);
      if (lookahead == '}')
        ADVANCE(195);
      if (('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '|')
        ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(199);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 203:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(204);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(206);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(32);
      if (lookahead == '<')
        ADVANCE(34);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(41);
      if (lookahead == '>')
        ADVANCE(43);
      END_STATE();
    case 206:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(203);
      END_STATE();
    case 207:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(208);
      if (lookahead == ']')
        ADVANCE(49);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(207);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 208:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(207);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 209:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(210);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(209);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 210:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(209);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 211:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(150);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(91);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == '-')
        ADVANCE(153);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(155);
      if (lookahead == '=')
        ADVANCE(156);
      if (lookahead == '>')
        ADVANCE(159);
      if (lookahead == '\\')
        SKIP(212);
      if (lookahead == '|')
        ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(211);
      END_STATE();
    case 212:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(211);
      END_STATE();
    case 213:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(65);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(46);
      if (lookahead == '\\')
        ADVANCE(214);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(213);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 214:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(213);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 215:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(216);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(217);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(32);
      END_STATE();
    case 217:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(215);
      END_STATE();
    case 218:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(65);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(46);
      if (lookahead == '\\')
        ADVANCE(219);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(218);
      if (lookahead != 0 &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 219:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(218);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 220:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(204);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(221);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(220);
      END_STATE();
    case 221:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(220);
      END_STATE();
    case 222:
      if (lookahead == '!')
        ADVANCE(150);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(152);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == '-')
        ADVANCE(153);
      if (lookahead == '<')
        ADVANCE(155);
      if (lookahead == '=')
        ADVANCE(156);
      if (lookahead == '>')
        ADVANCE(159);
      if (lookahead == '\\')
        SKIP(223);
      if (lookahead == '|')
        ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(222);
      END_STATE();
    case 223:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(222);
      END_STATE();
    case 224:
      if (lookahead == '!')
        ADVANCE(225);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(181);
      if (lookahead == '$')
        ADVANCE(183);
      if (lookahead == '\'')
        ADVANCE(188);
      if (lookahead == '(')
        ADVANCE(226);
      if (lookahead == '-')
        ADVANCE(227);
      if (lookahead == '<')
        ADVANCE(191);
      if (lookahead == '>')
        ADVANCE(193);
      if (lookahead == '[')
        ADVANCE(195);
      if (lookahead == '\\')
        ADVANCE(229);
      if (lookahead == ']')
        ADVANCE(195);
      if (lookahead == '`')
        ADVANCE(202);
      if (lookahead == '{')
        ADVANCE(195);
      if (lookahead == '}')
        ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(224);
      if (('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '|')
        ADVANCE(186);
      if (lookahead != 0)
        ADVANCE(199);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\')
        ADVANCE(198);
      if (('\"' <= lookahead && lookahead <= '$') ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '<' ||
          lookahead == '>' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}'))
        ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(199);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(186);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(198);
      if (('\"' <= lookahead && lookahead <= '$') ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '<' ||
          lookahead == '>' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}'))
        ADVANCE(186);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(228);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(199);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(228);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(230);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(199);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '!')
        ADVANCE(225);
      if (lookahead == '\"')
        ADVANCE(201);
      if (lookahead == '#')
        ADVANCE(181);
      if (lookahead == '$')
        ADVANCE(183);
      if (lookahead == '\'')
        ADVANCE(188);
      if (lookahead == '(')
        ADVANCE(226);
      if (lookahead == '-')
        ADVANCE(227);
      if (lookahead == '<')
        ADVANCE(191);
      if (lookahead == '>')
        ADVANCE(193);
      if (lookahead == '[')
        ADVANCE(195);
      if (lookahead == '\\')
        ADVANCE(229);
      if (lookahead == ']')
        ADVANCE(195);
      if (lookahead == '`')
        ADVANCE(202);
      if (lookahead == '{')
        ADVANCE(195);
      if (lookahead == '}')
        ADVANCE(195);
      if (('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '|')
        ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || lookahead > '$'))
        ADVANCE(199);
      END_STATE();
    case 231:
      if (lookahead == '!')
        ADVANCE(150);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(152);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == '-')
        ADVANCE(153);
      if (lookahead == '<')
        ADVANCE(155);
      if (lookahead == '=')
        ADVANCE(156);
      if (lookahead == '>')
        ADVANCE(159);
      if (lookahead == '\\')
        SKIP(232);
      if (lookahead == ']')
        ADVANCE(164);
      if (lookahead == '|')
        ADVANCE(233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(231);
      END_STATE();
    case 232:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(231);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|')
        ADVANCE(61);
      END_STATE();
    case 234:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(235);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(234);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 235:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(234);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 236:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '-')
        ADVANCE(23);
      if (lookahead == ':')
        ADVANCE(26);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '=')
        ADVANCE(175);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(237);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(236);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > ')') &&
          (lookahead < ':' || lookahead > '>') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 237:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(236);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 238:
      if (lookahead == '#')
        ADVANCE(239);
      if (lookahead == '\\')
        ADVANCE(241);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(238);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '#' &&
          lookahead != '}')
        ADVANCE(243);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\\')
        ADVANCE(240);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '}')
        ADVANCE(239);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\\')
        ADVANCE(240);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '}')
        ADVANCE(239);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(239);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\\')
        ADVANCE(242);
      if (lookahead == '}')
        ADVANCE(243);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(244);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(243);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\\')
        ADVANCE(242);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '}')
        ADVANCE(243);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(243);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\\')
        ADVANCE(242);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '}')
        ADVANCE(243);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\"')
        ADVANCE(243);
      if (lookahead == '#')
        ADVANCE(239);
      if (lookahead == '\\')
        ADVANCE(241);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '}')
        ADVANCE(243);
      END_STATE();
    case 245:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(204);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(246);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(245);
      END_STATE();
    case 246:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(245);
      END_STATE();
    case 247:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(204);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(248);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(145);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(247);
      END_STATE();
    case 248:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(247);
      END_STATE();
    case 249:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ')')
        ADVANCE(250);
      if (lookahead == '-')
        ADVANCE(85);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(252);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(249);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 250:
      if (lookahead == ')')
        ADVANCE(251);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_RPAREN_RPAREN);
      END_STATE();
    case 252:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(249);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 253:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(150);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(91);
      if (lookahead == '-')
        ADVANCE(153);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(155);
      if (lookahead == '=')
        ADVANCE(156);
      if (lookahead == '>')
        ADVANCE(159);
      if (lookahead == '\\')
        SKIP(254);
      if (lookahead == 'e')
        ADVANCE(145);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(253);
      END_STATE();
    case 254:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(253);
      END_STATE();
    case 255:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(129);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(256);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(255);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 256:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(255);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 257:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(258);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(52);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(257);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 258:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(257);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 259:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(216);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(260);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(145);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(259);
      END_STATE();
    case 260:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(259);
      END_STATE();
    case 261:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(216);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(262);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(261);
      END_STATE();
    case 262:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(261);
      END_STATE();
    case 263:
      if (lookahead == '!')
        ADVANCE(150);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(152);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == '-')
        ADVANCE(153);
      if (lookahead == '<')
        ADVANCE(155);
      if (lookahead == '=')
        ADVANCE(156);
      if (lookahead == '>')
        ADVANCE(159);
      if (lookahead == '\\')
        SKIP(264);
      if (lookahead == ']')
        ADVANCE(164);
      if (lookahead == '|')
        ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(263);
      END_STATE();
    case 264:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(263);
      END_STATE();
    case 265:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(216);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(266);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(265);
      END_STATE();
    case 266:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(265);
      END_STATE();
    case 267:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(65);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ';')
        ADVANCE(268);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(46);
      if (lookahead == '\\')
        ADVANCE(269);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(267);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 268:
      if (lookahead == ';')
        ADVANCE(30);
      END_STATE();
    case 269:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(267);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 270:
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '\\')
        ADVANCE(271);
      if (lookahead == '{')
        ADVANCE(58);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(270);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 271:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(270);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 272:
      if (lookahead == '!')
        ADVANCE(150);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(152);
      if (lookahead == ')')
        ADVANCE(250);
      if (lookahead == '-')
        ADVANCE(153);
      if (lookahead == '<')
        ADVANCE(155);
      if (lookahead == '=')
        ADVANCE(156);
      if (lookahead == '>')
        ADVANCE(159);
      if (lookahead == '\\')
        SKIP(273);
      if (lookahead == '|')
        ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(272);
      END_STATE();
    case 273:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(272);
      END_STATE();
    case 274:
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == '\\')
        SKIP(275);
      if (lookahead == '|')
        ADVANCE(276);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(274);
      END_STATE();
    case 275:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(274);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 277:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(91);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '\\')
        SKIP(278);
      if (lookahead == 'e')
        ADVANCE(145);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(277);
      END_STATE();
    case 278:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(277);
      END_STATE();
    case 279:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(65);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ';')
        ADVANCE(268);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(46);
      if (lookahead == '\\')
        ADVANCE(280);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(52);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(279);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 280:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(279);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 281:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(91);
      if (lookahead == ')')
        ADVANCE(19);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '\\')
        SKIP(282);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(281);
      END_STATE();
    case 282:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(281);
      END_STATE();
    case 283:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(91);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(87);
      if (lookahead == '>')
        ADVANCE(88);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(284);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(285);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(93);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 284:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(283);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 's')
        ADVANCE(286);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(93);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'a')
        ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(93);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'c')
        ADVANCE(288);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(93);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(93);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 289:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(31);
      if (lookahead == '=')
        ADVANCE(95);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(290);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(52);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(289);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 290:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(289);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 291:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(31);
      if (lookahead == '=')
        ADVANCE(95);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(292);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(52);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(291);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 292:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(291);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 293:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(66);
      if (lookahead == '>')
        ADVANCE(40);
      if (lookahead == '[')
        ADVANCE(68);
      if (lookahead == '\\')
        ADVANCE(294);
      if (lookahead == ']')
        ADVANCE(68);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(52);
      if (lookahead == '{')
        ADVANCE(68);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '}')
        ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(293);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 294:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(293);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 295:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(204);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(296);
      if (lookahead == 'e')
        ADVANCE(145);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(295);
      END_STATE();
    case 296:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(295);
      END_STATE();
    case 297:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(64);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(29);
      if (lookahead == '<')
        ADVANCE(216);
      if (lookahead == '>')
        ADVANCE(205);
      if (lookahead == '\\')
        SKIP(298);
      if (lookahead == 'e')
        ADVANCE(145);
      if (lookahead == '|')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(297);
      END_STATE();
    case 298:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(297);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 'c')
        ADVANCE(1);
      if (lookahead == 'd')
        ADVANCE(5);
      if (lookahead == 'e')
        ADVANCE(15);
      if (lookahead == 'f')
        ADVANCE(26);
      if (lookahead == 'i')
        ADVANCE(37);
      if (lookahead == 'l')
        ADVANCE(39);
      if (lookahead == 'r')
        ADVANCE(44);
      if (lookahead == 't')
        ADVANCE(52);
      if (lookahead == 'u')
        ADVANCE(62);
      if (lookahead == 'w')
        ADVANCE(70);
      END_STATE();
    case 1:
      if (lookahead == 'a')
        ADVANCE(2);
      END_STATE();
    case 2:
      if (lookahead == 's')
        ADVANCE(3);
      END_STATE();
    case 3:
      if (lookahead == 'e')
        ADVANCE(4);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 5:
      if (lookahead == 'e')
        ADVANCE(6);
      if (lookahead == 'o')
        ADVANCE(12);
      END_STATE();
    case 6:
      if (lookahead == 'c')
        ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == 'l')
        ADVANCE(8);
      END_STATE();
    case 8:
      if (lookahead == 'a')
        ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == 'r')
        ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == 'e')
        ADVANCE(11);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'n')
        ADVANCE(13);
      END_STATE();
    case 13:
      if (lookahead == 'e')
        ADVANCE(14);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_done);
      END_STATE();
    case 15:
      if (lookahead == 'l')
        ADVANCE(16);
      if (lookahead == 'x')
        ADVANCE(21);
      END_STATE();
    case 16:
      if (lookahead == 'i')
        ADVANCE(17);
      if (lookahead == 's')
        ADVANCE(19);
      END_STATE();
    case 17:
      if (lookahead == 'f')
        ADVANCE(18);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 19:
      if (lookahead == 'e')
        ADVANCE(20);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 21:
      if (lookahead == 'p')
        ADVANCE(22);
      END_STATE();
    case 22:
      if (lookahead == 'o')
        ADVANCE(23);
      END_STATE();
    case 23:
      if (lookahead == 'r')
        ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == 't')
        ADVANCE(25);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 26:
      if (lookahead == 'i')
        ADVANCE(27);
      if (lookahead == 'o')
        ADVANCE(28);
      if (lookahead == 'u')
        ADVANCE(30);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_fi);
      END_STATE();
    case 28:
      if (lookahead == 'r')
        ADVANCE(29);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 30:
      if (lookahead == 'n')
        ADVANCE(31);
      END_STATE();
    case 31:
      if (lookahead == 'c')
        ADVANCE(32);
      END_STATE();
    case 32:
      if (lookahead == 't')
        ADVANCE(33);
      END_STATE();
    case 33:
      if (lookahead == 'i')
        ADVANCE(34);
      END_STATE();
    case 34:
      if (lookahead == 'o')
        ADVANCE(35);
      END_STATE();
    case 35:
      if (lookahead == 'n')
        ADVANCE(36);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 37:
      if (lookahead == 'f')
        ADVANCE(38);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 39:
      if (lookahead == 'o')
        ADVANCE(40);
      END_STATE();
    case 40:
      if (lookahead == 'c')
        ADVANCE(41);
      END_STATE();
    case 41:
      if (lookahead == 'a')
        ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == 'l')
        ADVANCE(43);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 44:
      if (lookahead == 'e')
        ADVANCE(45);
      END_STATE();
    case 45:
      if (lookahead == 'a')
        ADVANCE(46);
      END_STATE();
    case 46:
      if (lookahead == 'd')
        ADVANCE(47);
      END_STATE();
    case 47:
      if (lookahead == 'o')
        ADVANCE(48);
      END_STATE();
    case 48:
      if (lookahead == 'n')
        ADVANCE(49);
      END_STATE();
    case 49:
      if (lookahead == 'l')
        ADVANCE(50);
      END_STATE();
    case 50:
      if (lookahead == 'y')
        ADVANCE(51);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 52:
      if (lookahead == 'h')
        ADVANCE(53);
      if (lookahead == 'y')
        ADVANCE(56);
      END_STATE();
    case 53:
      if (lookahead == 'e')
        ADVANCE(54);
      END_STATE();
    case 54:
      if (lookahead == 'n')
        ADVANCE(55);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 56:
      if (lookahead == 'p')
        ADVANCE(57);
      END_STATE();
    case 57:
      if (lookahead == 'e')
        ADVANCE(58);
      END_STATE();
    case 58:
      if (lookahead == 's')
        ADVANCE(59);
      END_STATE();
    case 59:
      if (lookahead == 'e')
        ADVANCE(60);
      END_STATE();
    case 60:
      if (lookahead == 't')
        ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_typeset);
      END_STATE();
    case 62:
      if (lookahead == 'n')
        ADVANCE(63);
      END_STATE();
    case 63:
      if (lookahead == 's')
        ADVANCE(64);
      END_STATE();
    case 64:
      if (lookahead == 'e')
        ADVANCE(65);
      END_STATE();
    case 65:
      if (lookahead == 't')
        ADVANCE(66);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == 'e')
        ADVANCE(67);
      END_STATE();
    case 67:
      if (lookahead == 'n')
        ADVANCE(68);
      END_STATE();
    case 68:
      if (lookahead == 'v')
        ADVANCE(69);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_unsetenv);
      END_STATE();
    case 70:
      if (lookahead == 'h')
        ADVANCE(71);
      END_STATE();
    case 71:
      if (lookahead == 'i')
        ADVANCE(72);
      END_STATE();
    case 72:
      if (lookahead == 'l')
        ADVANCE(73);
      END_STATE();
    case 73:
      if (lookahead == 'e')
        ADVANCE(74);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 63, .external_lex_state = 2},
  [2] = {.lex_state = 63},
  [3] = {.lex_state = 69},
  [4] = {.lex_state = 75},
  [5] = {.lex_state = 63, .external_lex_state = 2},
  [6] = {.lex_state = 63, .external_lex_state = 2},
  [7] = {.lex_state = 80},
  [8] = {.lex_state = 80},
  [9] = {.lex_state = 63, .external_lex_state = 2},
  [10] = {.lex_state = 82, .external_lex_state = 2},
  [11] = {.lex_state = 84},
  [12] = {.lex_state = 84},
  [13] = {.lex_state = 90, .external_lex_state = 3},
  [14] = {.lex_state = 90, .external_lex_state = 4},
  [15] = {.lex_state = 80},
  [16] = {.lex_state = 94, .external_lex_state = 5},
  [17] = {.lex_state = 97},
  [18] = {.lex_state = 104},
  [19] = {.lex_state = 94, .external_lex_state = 5},
  [20] = {.lex_state = 113, .external_lex_state = 6},
  [21] = {.lex_state = 63, .external_lex_state = 2},
  [22] = {.lex_state = 63, .external_lex_state = 2},
  [23] = {.lex_state = 63, .external_lex_state = 2},
  [24] = {.lex_state = 116, .external_lex_state = 5},
  [25] = {.lex_state = 118},
  [26] = {.lex_state = 120, .external_lex_state = 4},
  [27] = {.lex_state = 94, .external_lex_state = 7},
  [28] = {.lex_state = 122, .external_lex_state = 8},
  [29] = {.lex_state = 69},
  [30] = {.lex_state = 80, .external_lex_state = 2},
  [31] = {.lex_state = 124, .external_lex_state = 7},
  [32] = {.lex_state = 63, .external_lex_state = 2},
  [33] = {.lex_state = 80, .external_lex_state = 2},
  [34] = {.lex_state = 80},
  [35] = {.lex_state = 80},
  [36] = {.lex_state = 126, .external_lex_state = 9},
  [37] = {.lex_state = 128, .external_lex_state = 4},
  [38] = {.lex_state = 131, .external_lex_state = 4},
  [39] = {.lex_state = 69},
  [40] = {.lex_state = 63, .external_lex_state = 2},
  [41] = {.lex_state = 80},
  [42] = {.lex_state = 82, .external_lex_state = 2},
  [43] = {.lex_state = 84},
  [44] = {.lex_state = 84},
  [45] = {.lex_state = 90, .external_lex_state = 3},
  [46] = {.lex_state = 90, .external_lex_state = 4},
  [47] = {.lex_state = 94, .external_lex_state = 5},
  [48] = {.lex_state = 94, .external_lex_state = 5},
  [49] = {.lex_state = 116, .external_lex_state = 5},
  [50] = {.lex_state = 80},
  [51] = {.lex_state = 90, .external_lex_state = 4},
  [52] = {.lex_state = 94, .external_lex_state = 7},
  [53] = {.lex_state = 122, .external_lex_state = 8},
  [54] = {.lex_state = 69},
  [55] = {.lex_state = 80, .external_lex_state = 2},
  [56] = {.lex_state = 80},
  [57] = {.lex_state = 131, .external_lex_state = 10},
  [58] = {.lex_state = 97},
  [59] = {.lex_state = 104},
  [60] = {.lex_state = 131, .external_lex_state = 10},
  [61] = {.lex_state = 113, .external_lex_state = 6},
  [62] = {.lex_state = 63, .external_lex_state = 2},
  [63] = {.lex_state = 63, .external_lex_state = 2},
  [64] = {.lex_state = 63, .external_lex_state = 2},
  [65] = {.lex_state = 131, .external_lex_state = 4},
  [66] = {.lex_state = 135},
  [67] = {.lex_state = 69},
  [68] = {.lex_state = 63, .external_lex_state = 2},
  [69] = {.lex_state = 80},
  [70] = {.lex_state = 82, .external_lex_state = 2},
  [71] = {.lex_state = 84},
  [72] = {.lex_state = 84},
  [73] = {.lex_state = 137, .external_lex_state = 3},
  [74] = {.lex_state = 137, .external_lex_state = 4},
  [75] = {.lex_state = 124, .external_lex_state = 5},
  [76] = {.lex_state = 124, .external_lex_state = 5},
  [77] = {.lex_state = 139, .external_lex_state = 5},
  [78] = {.lex_state = 137, .external_lex_state = 4},
  [79] = {.lex_state = 124, .external_lex_state = 7},
  [80] = {.lex_state = 141, .external_lex_state = 8},
  [81] = {.lex_state = 69},
  [82] = {.lex_state = 63, .external_lex_state = 2},
  [83] = {.lex_state = 80, .external_lex_state = 2},
  [84] = {.lex_state = 69},
  [85] = {.lex_state = 143, .external_lex_state = 4},
  [86] = {.lex_state = 69},
  [87] = {.lex_state = 84},
  [88] = {.lex_state = 84},
  [89] = {.lex_state = 149, .external_lex_state = 11},
  [90] = {.lex_state = 97},
  [91] = {.lex_state = 104},
  [92] = {.lex_state = 149, .external_lex_state = 11},
  [93] = {.lex_state = 113, .external_lex_state = 6},
  [94] = {.lex_state = 63, .external_lex_state = 2},
  [95] = {.lex_state = 63, .external_lex_state = 2},
  [96] = {.lex_state = 63, .external_lex_state = 2},
  [97] = {.lex_state = 149, .external_lex_state = 12},
  [98] = {.lex_state = 84},
  [99] = {.lex_state = 84},
  [100] = {.lex_state = 162, .external_lex_state = 13},
  [101] = {.lex_state = 97},
  [102] = {.lex_state = 104},
  [103] = {.lex_state = 162, .external_lex_state = 13},
  [104] = {.lex_state = 113, .external_lex_state = 6},
  [105] = {.lex_state = 63, .external_lex_state = 2},
  [106] = {.lex_state = 63, .external_lex_state = 2},
  [107] = {.lex_state = 63, .external_lex_state = 2},
  [108] = {.lex_state = 162},
  [109] = {.lex_state = 69},
  [110] = {.lex_state = 90, .external_lex_state = 14},
  [111] = {.lex_state = 97},
  [112] = {.lex_state = 104},
  [113] = {.lex_state = 90, .external_lex_state = 14},
  [114] = {.lex_state = 113, .external_lex_state = 6},
  [115] = {.lex_state = 63, .external_lex_state = 2},
  [116] = {.lex_state = 63, .external_lex_state = 2},
  [117] = {.lex_state = 63, .external_lex_state = 2},
  [118] = {.lex_state = 137, .external_lex_state = 3},
  [119] = {.lex_state = 69},
  [120] = {.lex_state = 90, .external_lex_state = 3},
  [121] = {.lex_state = 90, .external_lex_state = 10},
  [122] = {.lex_state = 97},
  [123] = {.lex_state = 104},
  [124] = {.lex_state = 90, .external_lex_state = 10},
  [125] = {.lex_state = 113, .external_lex_state = 6},
  [126] = {.lex_state = 63, .external_lex_state = 2},
  [127] = {.lex_state = 63, .external_lex_state = 2},
  [128] = {.lex_state = 63, .external_lex_state = 2},
  [129] = {.lex_state = 137, .external_lex_state = 4},
  [130] = {.lex_state = 90, .external_lex_state = 4},
  [131] = {.lex_state = 80, .external_lex_state = 15},
  [132] = {.lex_state = 97},
  [133] = {.lex_state = 104},
  [134] = {.lex_state = 80, .external_lex_state = 15},
  [135] = {.lex_state = 113, .external_lex_state = 6},
  [136] = {.lex_state = 63, .external_lex_state = 2},
  [137] = {.lex_state = 63, .external_lex_state = 2},
  [138] = {.lex_state = 63, .external_lex_state = 2},
  [139] = {.lex_state = 80, .external_lex_state = 2},
  [140] = {.lex_state = 80},
  [141] = {.lex_state = 94, .external_lex_state = 5},
  [142] = {.lex_state = 124, .external_lex_state = 5},
  [143] = {.lex_state = 166},
  [144] = {.lex_state = 97, .external_lex_state = 13},
  [145] = {.lex_state = 113, .external_lex_state = 6},
  [146] = {.lex_state = 63, .external_lex_state = 2},
  [147] = {.lex_state = 63, .external_lex_state = 2},
  [148] = {.lex_state = 97},
  [149] = {.lex_state = 124, .external_lex_state = 5},
  [150] = {.lex_state = 124, .external_lex_state = 5},
  [151] = {.lex_state = 124, .external_lex_state = 5},
  [152] = {.lex_state = 69},
  [153] = {.lex_state = 172, .external_lex_state = 6},
  [154] = {.lex_state = 174, .external_lex_state = 16},
  [155] = {.lex_state = 174, .external_lex_state = 16},
  [156] = {.lex_state = 174, .external_lex_state = 16},
  [157] = {.lex_state = 137, .external_lex_state = 4},
  [158] = {.lex_state = 141, .external_lex_state = 8},
  [159] = {.lex_state = 63, .external_lex_state = 2},
  [160] = {.lex_state = 63, .external_lex_state = 2},
  [161] = {.lex_state = 80},
  [162] = {.lex_state = 82, .external_lex_state = 2},
  [163] = {.lex_state = 84},
  [164] = {.lex_state = 84},
  [165] = {.lex_state = 90, .external_lex_state = 3},
  [166] = {.lex_state = 90, .external_lex_state = 4},
  [167] = {.lex_state = 116, .external_lex_state = 5},
  [168] = {.lex_state = 90, .external_lex_state = 4},
  [169] = {.lex_state = 94, .external_lex_state = 7},
  [170] = {.lex_state = 122, .external_lex_state = 8},
  [171] = {.lex_state = 63, .external_lex_state = 2},
  [172] = {.lex_state = 80, .external_lex_state = 2},
  [173] = {.lex_state = 137, .external_lex_state = 4},
  [174] = {.lex_state = 141, .external_lex_state = 8},
  [175] = {.lex_state = 63, .external_lex_state = 2},
  [176] = {.lex_state = 84},
  [177] = {.lex_state = 63, .external_lex_state = 2},
  [178] = {.lex_state = 63, .external_lex_state = 2},
  [179] = {.lex_state = 63, .external_lex_state = 2},
  [180] = {.lex_state = 143, .external_lex_state = 4},
  [181] = {.lex_state = 177, .external_lex_state = 17},
  [182] = {.lex_state = 63},
  [183] = {.lex_state = 180},
  [184] = {.lex_state = 80},
  [185] = {.lex_state = 63, .external_lex_state = 18},
  [186] = {.lex_state = 80},
  [187] = {.lex_state = 94, .external_lex_state = 5},
  [188] = {.lex_state = 94, .external_lex_state = 5},
  [189] = {.lex_state = 143, .external_lex_state = 4},
  [190] = {.lex_state = 203, .external_lex_state = 7},
  [191] = {.lex_state = 94, .external_lex_state = 7},
  [192] = {.lex_state = 120, .external_lex_state = 4},
  [193] = {.lex_state = 122, .external_lex_state = 8},
  [194] = {.lex_state = 63, .external_lex_state = 2},
  [195] = {.lex_state = 94, .external_lex_state = 7},
  [196] = {.lex_state = 80, .external_lex_state = 2},
  [197] = {.lex_state = 80, .external_lex_state = 15},
  [198] = {.lex_state = 80, .external_lex_state = 15},
  [199] = {.lex_state = 80, .external_lex_state = 2},
  [200] = {.lex_state = 207, .external_lex_state = 11},
  [201] = {.lex_state = 207, .external_lex_state = 11},
  [202] = {.lex_state = 207, .external_lex_state = 11},
  [203] = {.lex_state = 141, .external_lex_state = 8},
  [204] = {.lex_state = 209},
  [205] = {.lex_state = 122, .external_lex_state = 19},
  [206] = {.lex_state = 97},
  [207] = {.lex_state = 104},
  [208] = {.lex_state = 122, .external_lex_state = 19},
  [209] = {.lex_state = 113, .external_lex_state = 6},
  [210] = {.lex_state = 63, .external_lex_state = 2},
  [211] = {.lex_state = 63, .external_lex_state = 2},
  [212] = {.lex_state = 63, .external_lex_state = 2},
  [213] = {.lex_state = 128, .external_lex_state = 4},
  [214] = {.lex_state = 84},
  [215] = {.lex_state = 84},
  [216] = {.lex_state = 211, .external_lex_state = 10},
  [217] = {.lex_state = 97},
  [218] = {.lex_state = 104},
  [219] = {.lex_state = 211, .external_lex_state = 10},
  [220] = {.lex_state = 113, .external_lex_state = 6},
  [221] = {.lex_state = 63, .external_lex_state = 2},
  [222] = {.lex_state = 63, .external_lex_state = 2},
  [223] = {.lex_state = 63, .external_lex_state = 2},
  [224] = {.lex_state = 211, .external_lex_state = 4},
  [225] = {.lex_state = 80},
  [226] = {.lex_state = 80},
  [227] = {.lex_state = 126, .external_lex_state = 9},
  [228] = {.lex_state = 80},
  [229] = {.lex_state = 135},
  [230] = {.lex_state = 149, .external_lex_state = 12},
  [231] = {.lex_state = 162},
  [232] = {.lex_state = 69},
  [233] = {.lex_state = 90, .external_lex_state = 14},
  [234] = {.lex_state = 90, .external_lex_state = 14},
  [235] = {.lex_state = 69},
  [236] = {.lex_state = 90, .external_lex_state = 3},
  [237] = {.lex_state = 90, .external_lex_state = 10},
  [238] = {.lex_state = 90, .external_lex_state = 10},
  [239] = {.lex_state = 90, .external_lex_state = 4},
  [240] = {.lex_state = 94, .external_lex_state = 5},
  [241] = {.lex_state = 84},
  [242] = {.lex_state = 63, .external_lex_state = 2},
  [243] = {.lex_state = 203, .external_lex_state = 7},
  [244] = {.lex_state = 63, .external_lex_state = 2},
  [245] = {.lex_state = 80},
  [246] = {.lex_state = 63, .external_lex_state = 2},
  [247] = {.lex_state = 63},
  [248] = {.lex_state = 180},
  [249] = {.lex_state = 80},
  [250] = {.lex_state = 80},
  [251] = {.lex_state = 94, .external_lex_state = 5},
  [252] = {.lex_state = 94, .external_lex_state = 5},
  [253] = {.lex_state = 203, .external_lex_state = 7},
  [254] = {.lex_state = 94, .external_lex_state = 7},
  [255] = {.lex_state = 94, .external_lex_state = 7},
  [256] = {.lex_state = 63, .external_lex_state = 2},
  [257] = {.lex_state = 80},
  [258] = {.lex_state = 128, .external_lex_state = 4},
  [259] = {.lex_state = 131},
  [260] = {.lex_state = 131, .external_lex_state = 10},
  [261] = {.lex_state = 131, .external_lex_state = 10},
  [262] = {.lex_state = 166},
  [263] = {.lex_state = 97},
  [264] = {.lex_state = 131, .external_lex_state = 10},
  [265] = {.lex_state = 131, .external_lex_state = 10},
  [266] = {.lex_state = 131, .external_lex_state = 10},
  [267] = {.lex_state = 128, .external_lex_state = 4},
  [268] = {.lex_state = 131},
  [269] = {.lex_state = 69},
  [270] = {.lex_state = 172, .external_lex_state = 6},
  [271] = {.lex_state = 174, .external_lex_state = 16},
  [272] = {.lex_state = 174, .external_lex_state = 16},
  [273] = {.lex_state = 174, .external_lex_state = 16},
  [274] = {.lex_state = 137, .external_lex_state = 4},
  [275] = {.lex_state = 141, .external_lex_state = 8},
  [276] = {.lex_state = 63, .external_lex_state = 2},
  [277] = {.lex_state = 90, .external_lex_state = 4},
  [278] = {.lex_state = 122, .external_lex_state = 8},
  [279] = {.lex_state = 63, .external_lex_state = 2},
  [280] = {.lex_state = 137, .external_lex_state = 4},
  [281] = {.lex_state = 141, .external_lex_state = 8},
  [282] = {.lex_state = 63, .external_lex_state = 2},
  [283] = {.lex_state = 84},
  [284] = {.lex_state = 213, .external_lex_state = 20},
  [285] = {.lex_state = 215, .external_lex_state = 21},
  [286] = {.lex_state = 126, .external_lex_state = 9},
  [287] = {.lex_state = 80},
  [288] = {.lex_state = 135},
  [289] = {.lex_state = 149, .external_lex_state = 12},
  [290] = {.lex_state = 162},
  [291] = {.lex_state = 69},
  [292] = {.lex_state = 137, .external_lex_state = 14},
  [293] = {.lex_state = 137, .external_lex_state = 14},
  [294] = {.lex_state = 69},
  [295] = {.lex_state = 137, .external_lex_state = 3},
  [296] = {.lex_state = 137, .external_lex_state = 10},
  [297] = {.lex_state = 137, .external_lex_state = 10},
  [298] = {.lex_state = 137, .external_lex_state = 4},
  [299] = {.lex_state = 124, .external_lex_state = 5},
  [300] = {.lex_state = 84},
  [301] = {.lex_state = 63, .external_lex_state = 2},
  [302] = {.lex_state = 143, .external_lex_state = 4},
  [303] = {.lex_state = 218, .external_lex_state = 2},
  [304] = {.lex_state = 63, .external_lex_state = 2},
  [305] = {.lex_state = 63},
  [306] = {.lex_state = 180},
  [307] = {.lex_state = 80},
  [308] = {.lex_state = 80},
  [309] = {.lex_state = 124, .external_lex_state = 5},
  [310] = {.lex_state = 124, .external_lex_state = 5},
  [311] = {.lex_state = 220, .external_lex_state = 7},
  [312] = {.lex_state = 124, .external_lex_state = 7},
  [313] = {.lex_state = 137, .external_lex_state = 4},
  [314] = {.lex_state = 141, .external_lex_state = 8},
  [315] = {.lex_state = 124, .external_lex_state = 7},
  [316] = {.lex_state = 126, .external_lex_state = 9},
  [317] = {.lex_state = 84},
  [318] = {.lex_state = 222, .external_lex_state = 13},
  [319] = {.lex_state = 222, .external_lex_state = 13},
  [320] = {.lex_state = 211},
  [321] = {.lex_state = 149, .external_lex_state = 12},
  [322] = {.lex_state = 80},
  [323] = {.lex_state = 149, .external_lex_state = 11},
  [324] = {.lex_state = 149, .external_lex_state = 11},
  [325] = {.lex_state = 166},
  [326] = {.lex_state = 97},
  [327] = {.lex_state = 149, .external_lex_state = 11},
  [328] = {.lex_state = 149, .external_lex_state = 11},
  [329] = {.lex_state = 149, .external_lex_state = 11},
  [330] = {.lex_state = 69},
  [331] = {.lex_state = 172, .external_lex_state = 6},
  [332] = {.lex_state = 174, .external_lex_state = 16},
  [333] = {.lex_state = 174, .external_lex_state = 16},
  [334] = {.lex_state = 174, .external_lex_state = 16},
  [335] = {.lex_state = 137, .external_lex_state = 4},
  [336] = {.lex_state = 141, .external_lex_state = 8},
  [337] = {.lex_state = 63, .external_lex_state = 2},
  [338] = {.lex_state = 90, .external_lex_state = 4},
  [339] = {.lex_state = 122, .external_lex_state = 8},
  [340] = {.lex_state = 63, .external_lex_state = 2},
  [341] = {.lex_state = 137, .external_lex_state = 4},
  [342] = {.lex_state = 141, .external_lex_state = 8},
  [343] = {.lex_state = 63, .external_lex_state = 2},
  [344] = {.lex_state = 84},
  [345] = {.lex_state = 203, .external_lex_state = 21},
  [346] = {.lex_state = 224},
  [347] = {.lex_state = 211},
  [348] = {.lex_state = 162},
  [349] = {.lex_state = 80},
  [350] = {.lex_state = 162, .external_lex_state = 13},
  [351] = {.lex_state = 231, .external_lex_state = 13},
  [352] = {.lex_state = 166},
  [353] = {.lex_state = 97},
  [354] = {.lex_state = 231, .external_lex_state = 13},
  [355] = {.lex_state = 231, .external_lex_state = 13},
  [356] = {.lex_state = 231, .external_lex_state = 13},
  [357] = {.lex_state = 69},
  [358] = {.lex_state = 172, .external_lex_state = 6},
  [359] = {.lex_state = 174, .external_lex_state = 16},
  [360] = {.lex_state = 174, .external_lex_state = 16},
  [361] = {.lex_state = 174, .external_lex_state = 16},
  [362] = {.lex_state = 137, .external_lex_state = 4},
  [363] = {.lex_state = 141, .external_lex_state = 8},
  [364] = {.lex_state = 63, .external_lex_state = 2},
  [365] = {.lex_state = 90, .external_lex_state = 4},
  [366] = {.lex_state = 122, .external_lex_state = 8},
  [367] = {.lex_state = 63, .external_lex_state = 2},
  [368] = {.lex_state = 137, .external_lex_state = 4},
  [369] = {.lex_state = 141, .external_lex_state = 8},
  [370] = {.lex_state = 63, .external_lex_state = 2},
  [371] = {.lex_state = 84},
  [372] = {.lex_state = 224},
  [373] = {.lex_state = 126, .external_lex_state = 9},
  [374] = {.lex_state = 80},
  [375] = {.lex_state = 90, .external_lex_state = 14},
  [376] = {.lex_state = 137, .external_lex_state = 14},
  [377] = {.lex_state = 166},
  [378] = {.lex_state = 97},
  [379] = {.lex_state = 137, .external_lex_state = 14},
  [380] = {.lex_state = 137, .external_lex_state = 14},
  [381] = {.lex_state = 137, .external_lex_state = 14},
  [382] = {.lex_state = 69},
  [383] = {.lex_state = 172, .external_lex_state = 6},
  [384] = {.lex_state = 174, .external_lex_state = 16},
  [385] = {.lex_state = 174, .external_lex_state = 16},
  [386] = {.lex_state = 174, .external_lex_state = 16},
  [387] = {.lex_state = 137, .external_lex_state = 4},
  [388] = {.lex_state = 141, .external_lex_state = 8},
  [389] = {.lex_state = 63, .external_lex_state = 2},
  [390] = {.lex_state = 90, .external_lex_state = 4},
  [391] = {.lex_state = 122, .external_lex_state = 8},
  [392] = {.lex_state = 63, .external_lex_state = 2},
  [393] = {.lex_state = 137, .external_lex_state = 4},
  [394] = {.lex_state = 141, .external_lex_state = 8},
  [395] = {.lex_state = 63, .external_lex_state = 2},
  [396] = {.lex_state = 90, .external_lex_state = 3},
  [397] = {.lex_state = 80},
  [398] = {.lex_state = 90, .external_lex_state = 10},
  [399] = {.lex_state = 137, .external_lex_state = 10},
  [400] = {.lex_state = 166},
  [401] = {.lex_state = 97},
  [402] = {.lex_state = 137, .external_lex_state = 10},
  [403] = {.lex_state = 137, .external_lex_state = 10},
  [404] = {.lex_state = 137, .external_lex_state = 10},
  [405] = {.lex_state = 69},
  [406] = {.lex_state = 172, .external_lex_state = 6},
  [407] = {.lex_state = 174, .external_lex_state = 16},
  [408] = {.lex_state = 174, .external_lex_state = 16},
  [409] = {.lex_state = 174, .external_lex_state = 16},
  [410] = {.lex_state = 137, .external_lex_state = 4},
  [411] = {.lex_state = 141, .external_lex_state = 8},
  [412] = {.lex_state = 63, .external_lex_state = 2},
  [413] = {.lex_state = 90, .external_lex_state = 4},
  [414] = {.lex_state = 122, .external_lex_state = 8},
  [415] = {.lex_state = 63, .external_lex_state = 2},
  [416] = {.lex_state = 137, .external_lex_state = 4},
  [417] = {.lex_state = 141, .external_lex_state = 8},
  [418] = {.lex_state = 63, .external_lex_state = 2},
  [419] = {.lex_state = 90, .external_lex_state = 4},
  [420] = {.lex_state = 80},
  [421] = {.lex_state = 80, .external_lex_state = 15},
  [422] = {.lex_state = 80, .external_lex_state = 15},
  [423] = {.lex_state = 166},
  [424] = {.lex_state = 97},
  [425] = {.lex_state = 80, .external_lex_state = 15},
  [426] = {.lex_state = 80, .external_lex_state = 15},
  [427] = {.lex_state = 80, .external_lex_state = 15},
  [428] = {.lex_state = 69},
  [429] = {.lex_state = 172, .external_lex_state = 6},
  [430] = {.lex_state = 174, .external_lex_state = 16},
  [431] = {.lex_state = 174, .external_lex_state = 16},
  [432] = {.lex_state = 174, .external_lex_state = 16},
  [433] = {.lex_state = 137, .external_lex_state = 4},
  [434] = {.lex_state = 141, .external_lex_state = 8},
  [435] = {.lex_state = 63, .external_lex_state = 2},
  [436] = {.lex_state = 90, .external_lex_state = 4},
  [437] = {.lex_state = 122, .external_lex_state = 8},
  [438] = {.lex_state = 63, .external_lex_state = 2},
  [439] = {.lex_state = 137, .external_lex_state = 4},
  [440] = {.lex_state = 141, .external_lex_state = 8},
  [441] = {.lex_state = 63, .external_lex_state = 2},
  [442] = {.lex_state = 124, .external_lex_state = 5},
  [443] = {.lex_state = 94, .external_lex_state = 5},
  [444] = {.lex_state = 124, .external_lex_state = 5},
  [445] = {.lex_state = 97, .external_lex_state = 13},
  [446] = {.lex_state = 97, .external_lex_state = 13},
  [447] = {.lex_state = 97, .external_lex_state = 13},
  [448] = {.lex_state = 97},
  [449] = {.lex_state = 69},
  [450] = {.lex_state = 172, .external_lex_state = 6},
  [451] = {.lex_state = 174, .external_lex_state = 16},
  [452] = {.lex_state = 174, .external_lex_state = 16},
  [453] = {.lex_state = 174, .external_lex_state = 16},
  [454] = {.lex_state = 137, .external_lex_state = 4},
  [455] = {.lex_state = 141, .external_lex_state = 8},
  [456] = {.lex_state = 63, .external_lex_state = 2},
  [457] = {.lex_state = 90, .external_lex_state = 4},
  [458] = {.lex_state = 122, .external_lex_state = 8},
  [459] = {.lex_state = 63, .external_lex_state = 2},
  [460] = {.lex_state = 166},
  [461] = {.lex_state = 97},
  [462] = {.lex_state = 80},
  [463] = {.lex_state = 234, .external_lex_state = 16},
  [464] = {.lex_state = 69},
  [465] = {.lex_state = 174, .external_lex_state = 16},
  [466] = {.lex_state = 174, .external_lex_state = 16},
  [467] = {.lex_state = 174, .external_lex_state = 16},
  [468] = {.lex_state = 124, .external_lex_state = 5},
  [469] = {.lex_state = 236, .external_lex_state = 22},
  [470] = {.lex_state = 97},
  [471] = {.lex_state = 104},
  [472] = {.lex_state = 236, .external_lex_state = 22},
  [473] = {.lex_state = 113, .external_lex_state = 6},
  [474] = {.lex_state = 238},
  [475] = {.lex_state = 63, .external_lex_state = 2},
  [476] = {.lex_state = 63, .external_lex_state = 2},
  [477] = {.lex_state = 63, .external_lex_state = 2},
  [478] = {.lex_state = 236, .external_lex_state = 16},
  [479] = {.lex_state = 124, .external_lex_state = 5},
  [480] = {.lex_state = 238},
  [481] = {.lex_state = 236, .external_lex_state = 16},
  [482] = {.lex_state = 124, .external_lex_state = 5},
  [483] = {.lex_state = 238},
  [484] = {.lex_state = 236, .external_lex_state = 16},
  [485] = {.lex_state = 124, .external_lex_state = 5},
  [486] = {.lex_state = 218, .external_lex_state = 2},
  [487] = {.lex_state = 137, .external_lex_state = 4},
  [488] = {.lex_state = 141, .external_lex_state = 8},
  [489] = {.lex_state = 80},
  [490] = {.lex_state = 135},
  [491] = {.lex_state = 149, .external_lex_state = 12},
  [492] = {.lex_state = 162},
  [493] = {.lex_state = 90, .external_lex_state = 3},
  [494] = {.lex_state = 90, .external_lex_state = 4},
  [495] = {.lex_state = 84},
  [496] = {.lex_state = 63, .external_lex_state = 2},
  [497] = {.lex_state = 63, .external_lex_state = 2},
  [498] = {.lex_state = 63, .external_lex_state = 2},
  [499] = {.lex_state = 63},
  [500] = {.lex_state = 80},
  [501] = {.lex_state = 80},
  [502] = {.lex_state = 245, .external_lex_state = 7},
  [503] = {.lex_state = 94, .external_lex_state = 7},
  [504] = {.lex_state = 90, .external_lex_state = 4},
  [505] = {.lex_state = 122, .external_lex_state = 8},
  [506] = {.lex_state = 94, .external_lex_state = 7},
  [507] = {.lex_state = 124, .external_lex_state = 5},
  [508] = {.lex_state = 218, .external_lex_state = 2},
  [509] = {.lex_state = 137, .external_lex_state = 4},
  [510] = {.lex_state = 141, .external_lex_state = 8},
  [511] = {.lex_state = 135},
  [512] = {.lex_state = 143, .external_lex_state = 4},
  [513] = {.lex_state = 141, .external_lex_state = 8},
  [514] = {.lex_state = 120, .external_lex_state = 4},
  [515] = {.lex_state = 122, .external_lex_state = 8},
  [516] = {.lex_state = 143, .external_lex_state = 4},
  [517] = {.lex_state = 104},
  [518] = {.lex_state = 113, .external_lex_state = 6},
  [519] = {.lex_state = 177, .external_lex_state = 17},
  [520] = {.lex_state = 80},
  [521] = {.lex_state = 94, .external_lex_state = 5},
  [522] = {.lex_state = 94, .external_lex_state = 5},
  [523] = {.lex_state = 124, .external_lex_state = 7},
  [524] = {.lex_state = 203, .external_lex_state = 5},
  [525] = {.lex_state = 203, .external_lex_state = 5},
  [526] = {.lex_state = 247, .external_lex_state = 7},
  [527] = {.lex_state = 247, .external_lex_state = 7},
  [528] = {.lex_state = 203, .external_lex_state = 5},
  [529] = {.lex_state = 203, .external_lex_state = 5},
  [530] = {.lex_state = 247, .external_lex_state = 7},
  [531] = {.lex_state = 143, .external_lex_state = 4},
  [532] = {.lex_state = 203, .external_lex_state = 7},
  [533] = {.lex_state = 203, .external_lex_state = 7},
  [534] = {.lex_state = 94, .external_lex_state = 7},
  [535] = {.lex_state = 63, .external_lex_state = 2},
  [536] = {.lex_state = 90, .external_lex_state = 4},
  [537] = {.lex_state = 122, .external_lex_state = 8},
  [538] = {.lex_state = 94, .external_lex_state = 7},
  [539] = {.lex_state = 207, .external_lex_state = 12},
  [540] = {.lex_state = 69, .external_lex_state = 13},
  [541] = {.lex_state = 207, .external_lex_state = 11},
  [542] = {.lex_state = 207, .external_lex_state = 12},
  [543] = {.lex_state = 69, .external_lex_state = 13},
  [544] = {.lex_state = 149, .external_lex_state = 12},
  [545] = {.lex_state = 141, .external_lex_state = 8},
  [546] = {.lex_state = 209, .external_lex_state = 13},
  [547] = {.lex_state = 97},
  [548] = {.lex_state = 104},
  [549] = {.lex_state = 209, .external_lex_state = 13},
  [550] = {.lex_state = 113, .external_lex_state = 6},
  [551] = {.lex_state = 63, .external_lex_state = 2},
  [552] = {.lex_state = 63, .external_lex_state = 2},
  [553] = {.lex_state = 63, .external_lex_state = 2},
  [554] = {.lex_state = 209},
  [555] = {.lex_state = 80},
  [556] = {.lex_state = 122, .external_lex_state = 19},
  [557] = {.lex_state = 141, .external_lex_state = 19},
  [558] = {.lex_state = 166},
  [559] = {.lex_state = 97},
  [560] = {.lex_state = 141, .external_lex_state = 19},
  [561] = {.lex_state = 141, .external_lex_state = 19},
  [562] = {.lex_state = 141, .external_lex_state = 19},
  [563] = {.lex_state = 69},
  [564] = {.lex_state = 172, .external_lex_state = 6},
  [565] = {.lex_state = 174, .external_lex_state = 16},
  [566] = {.lex_state = 174, .external_lex_state = 16},
  [567] = {.lex_state = 174, .external_lex_state = 16},
  [568] = {.lex_state = 137, .external_lex_state = 4},
  [569] = {.lex_state = 141, .external_lex_state = 8},
  [570] = {.lex_state = 63, .external_lex_state = 2},
  [571] = {.lex_state = 90, .external_lex_state = 4},
  [572] = {.lex_state = 122, .external_lex_state = 8},
  [573] = {.lex_state = 63, .external_lex_state = 2},
  [574] = {.lex_state = 137, .external_lex_state = 4},
  [575] = {.lex_state = 141, .external_lex_state = 8},
  [576] = {.lex_state = 63, .external_lex_state = 2},
  [577] = {.lex_state = 249},
  [578] = {.lex_state = 211, .external_lex_state = 4},
  [579] = {.lex_state = 211},
  [580] = {.lex_state = 211, .external_lex_state = 4},
  [581] = {.lex_state = 80},
  [582] = {.lex_state = 211, .external_lex_state = 10},
  [583] = {.lex_state = 253, .external_lex_state = 10},
  [584] = {.lex_state = 166},
  [585] = {.lex_state = 97},
  [586] = {.lex_state = 253, .external_lex_state = 10},
  [587] = {.lex_state = 253, .external_lex_state = 10},
  [588] = {.lex_state = 253, .external_lex_state = 10},
  [589] = {.lex_state = 69},
  [590] = {.lex_state = 172, .external_lex_state = 6},
  [591] = {.lex_state = 174, .external_lex_state = 16},
  [592] = {.lex_state = 174, .external_lex_state = 16},
  [593] = {.lex_state = 174, .external_lex_state = 16},
  [594] = {.lex_state = 137, .external_lex_state = 4},
  [595] = {.lex_state = 141, .external_lex_state = 8},
  [596] = {.lex_state = 63, .external_lex_state = 2},
  [597] = {.lex_state = 90, .external_lex_state = 4},
  [598] = {.lex_state = 122, .external_lex_state = 8},
  [599] = {.lex_state = 63, .external_lex_state = 2},
  [600] = {.lex_state = 137, .external_lex_state = 4},
  [601] = {.lex_state = 141, .external_lex_state = 8},
  [602] = {.lex_state = 63, .external_lex_state = 2},
  [603] = {.lex_state = 128, .external_lex_state = 4},
  [604] = {.lex_state = 84},
  [605] = {.lex_state = 224},
  [606] = {.lex_state = 255, .external_lex_state = 10},
  [607] = {.lex_state = 97},
  [608] = {.lex_state = 104},
  [609] = {.lex_state = 255, .external_lex_state = 10},
  [610] = {.lex_state = 113, .external_lex_state = 6},
  [611] = {.lex_state = 63, .external_lex_state = 2},
  [612] = {.lex_state = 63, .external_lex_state = 2},
  [613] = {.lex_state = 63, .external_lex_state = 2},
  [614] = {.lex_state = 255, .external_lex_state = 4},
  [615] = {.lex_state = 63, .external_lex_state = 2},
  [616] = {.lex_state = 143, .external_lex_state = 4},
  [617] = {.lex_state = 122, .external_lex_state = 19},
  [618] = {.lex_state = 122, .external_lex_state = 19},
  [619] = {.lex_state = 203, .external_lex_state = 7},
  [620] = {.lex_state = 84},
  [621] = {.lex_state = 215, .external_lex_state = 21},
  [622] = {.lex_state = 203, .external_lex_state = 21},
  [623] = {.lex_state = 126, .external_lex_state = 9},
  [624] = {.lex_state = 90, .external_lex_state = 14},
  [625] = {.lex_state = 90, .external_lex_state = 3},
  [626] = {.lex_state = 90, .external_lex_state = 10},
  [627] = {.lex_state = 90, .external_lex_state = 4},
  [628] = {.lex_state = 94, .external_lex_state = 5},
  [629] = {.lex_state = 135},
  [630] = {.lex_state = 247, .external_lex_state = 7},
  [631] = {.lex_state = 63, .external_lex_state = 2},
  [632] = {.lex_state = 143, .external_lex_state = 4},
  [633] = {.lex_state = 203, .external_lex_state = 7},
  [634] = {.lex_state = 90, .external_lex_state = 4},
  [635] = {.lex_state = 122, .external_lex_state = 8},
  [636] = {.lex_state = 80},
  [637] = {.lex_state = 94, .external_lex_state = 5},
  [638] = {.lex_state = 94, .external_lex_state = 5},
  [639] = {.lex_state = 203, .external_lex_state = 5},
  [640] = {.lex_state = 203, .external_lex_state = 5},
  [641] = {.lex_state = 203, .external_lex_state = 5},
  [642] = {.lex_state = 203, .external_lex_state = 5},
  [643] = {.lex_state = 203, .external_lex_state = 7},
  [644] = {.lex_state = 203, .external_lex_state = 7},
  [645] = {.lex_state = 94, .external_lex_state = 7},
  [646] = {.lex_state = 94, .external_lex_state = 7},
  [647] = {.lex_state = 143, .external_lex_state = 4},
  [648] = {.lex_state = 63, .external_lex_state = 2},
  [649] = {.lex_state = 63, .external_lex_state = 2},
  [650] = {.lex_state = 80},
  [651] = {.lex_state = 80},
  [652] = {.lex_state = 63, .external_lex_state = 2},
  [653] = {.lex_state = 80},
  [654] = {.lex_state = 131, .external_lex_state = 10},
  [655] = {.lex_state = 257},
  [656] = {.lex_state = 128, .external_lex_state = 4},
  [657] = {.lex_state = 131, .external_lex_state = 10},
  [658] = {.lex_state = 131, .external_lex_state = 10},
  [659] = {.lex_state = 166},
  [660] = {.lex_state = 257},
  [661] = {.lex_state = 128, .external_lex_state = 4},
  [662] = {.lex_state = 234, .external_lex_state = 16},
  [663] = {.lex_state = 69},
  [664] = {.lex_state = 174, .external_lex_state = 16},
  [665] = {.lex_state = 174, .external_lex_state = 16},
  [666] = {.lex_state = 174, .external_lex_state = 16},
  [667] = {.lex_state = 131, .external_lex_state = 10},
  [668] = {.lex_state = 238},
  [669] = {.lex_state = 236, .external_lex_state = 16},
  [670] = {.lex_state = 131, .external_lex_state = 10},
  [671] = {.lex_state = 238},
  [672] = {.lex_state = 236, .external_lex_state = 16},
  [673] = {.lex_state = 131, .external_lex_state = 10},
  [674] = {.lex_state = 238},
  [675] = {.lex_state = 236, .external_lex_state = 16},
  [676] = {.lex_state = 131, .external_lex_state = 10},
  [677] = {.lex_state = 218, .external_lex_state = 2},
  [678] = {.lex_state = 137, .external_lex_state = 4},
  [679] = {.lex_state = 141, .external_lex_state = 8},
  [680] = {.lex_state = 63, .external_lex_state = 2},
  [681] = {.lex_state = 90, .external_lex_state = 4},
  [682] = {.lex_state = 122, .external_lex_state = 8},
  [683] = {.lex_state = 131, .external_lex_state = 10},
  [684] = {.lex_state = 218, .external_lex_state = 2},
  [685] = {.lex_state = 137, .external_lex_state = 4},
  [686] = {.lex_state = 141, .external_lex_state = 8},
  [687] = {.lex_state = 135},
  [688] = {.lex_state = 259, .external_lex_state = 21},
  [689] = {.lex_state = 90, .external_lex_state = 4},
  [690] = {.lex_state = 122, .external_lex_state = 8},
  [691] = {.lex_state = 213, .external_lex_state = 20},
  [692] = {.lex_state = 63},
  [693] = {.lex_state = 80},
  [694] = {.lex_state = 143, .external_lex_state = 4},
  [695] = {.lex_state = 141, .external_lex_state = 19},
  [696] = {.lex_state = 141, .external_lex_state = 19},
  [697] = {.lex_state = 220, .external_lex_state = 7},
  [698] = {.lex_state = 84},
  [699] = {.lex_state = 261, .external_lex_state = 21},
  [700] = {.lex_state = 220, .external_lex_state = 21},
  [701] = {.lex_state = 126, .external_lex_state = 9},
  [702] = {.lex_state = 137, .external_lex_state = 14},
  [703] = {.lex_state = 137, .external_lex_state = 3},
  [704] = {.lex_state = 137, .external_lex_state = 10},
  [705] = {.lex_state = 137, .external_lex_state = 4},
  [706] = {.lex_state = 124, .external_lex_state = 5},
  [707] = {.lex_state = 135},
  [708] = {.lex_state = 143, .external_lex_state = 4},
  [709] = {.lex_state = 137, .external_lex_state = 4},
  [710] = {.lex_state = 141, .external_lex_state = 8},
  [711] = {.lex_state = 80},
  [712] = {.lex_state = 124, .external_lex_state = 5},
  [713] = {.lex_state = 124, .external_lex_state = 5},
  [714] = {.lex_state = 220, .external_lex_state = 5},
  [715] = {.lex_state = 220, .external_lex_state = 5},
  [716] = {.lex_state = 220, .external_lex_state = 5},
  [717] = {.lex_state = 220, .external_lex_state = 5},
  [718] = {.lex_state = 220, .external_lex_state = 7},
  [719] = {.lex_state = 220, .external_lex_state = 7},
  [720] = {.lex_state = 124, .external_lex_state = 7},
  [721] = {.lex_state = 218, .external_lex_state = 2},
  [722] = {.lex_state = 124, .external_lex_state = 7},
  [723] = {.lex_state = 80, .external_lex_state = 2},
  [724] = {.lex_state = 209},
  [725] = {.lex_state = 80, .external_lex_state = 15},
  [726] = {.lex_state = 80, .external_lex_state = 15},
  [727] = {.lex_state = 211},
  [728] = {.lex_state = 222, .external_lex_state = 13},
  [729] = {.lex_state = 149, .external_lex_state = 12},
  [730] = {.lex_state = 84},
  [731] = {.lex_state = 224},
  [732] = {.lex_state = 149, .external_lex_state = 11},
  [733] = {.lex_state = 149, .external_lex_state = 11},
  [734] = {.lex_state = 149, .external_lex_state = 11},
  [735] = {.lex_state = 166},
  [736] = {.lex_state = 234, .external_lex_state = 16},
  [737] = {.lex_state = 69},
  [738] = {.lex_state = 174, .external_lex_state = 16},
  [739] = {.lex_state = 174, .external_lex_state = 16},
  [740] = {.lex_state = 174, .external_lex_state = 16},
  [741] = {.lex_state = 149, .external_lex_state = 11},
  [742] = {.lex_state = 238},
  [743] = {.lex_state = 236, .external_lex_state = 16},
  [744] = {.lex_state = 149, .external_lex_state = 11},
  [745] = {.lex_state = 238},
  [746] = {.lex_state = 236, .external_lex_state = 16},
  [747] = {.lex_state = 149, .external_lex_state = 11},
  [748] = {.lex_state = 238},
  [749] = {.lex_state = 236, .external_lex_state = 16},
  [750] = {.lex_state = 149, .external_lex_state = 11},
  [751] = {.lex_state = 218, .external_lex_state = 2},
  [752] = {.lex_state = 137, .external_lex_state = 4},
  [753] = {.lex_state = 141, .external_lex_state = 8},
  [754] = {.lex_state = 63, .external_lex_state = 2},
  [755] = {.lex_state = 90, .external_lex_state = 4},
  [756] = {.lex_state = 122, .external_lex_state = 8},
  [757] = {.lex_state = 149, .external_lex_state = 11},
  [758] = {.lex_state = 218, .external_lex_state = 2},
  [759] = {.lex_state = 137, .external_lex_state = 4},
  [760] = {.lex_state = 141, .external_lex_state = 8},
  [761] = {.lex_state = 149, .external_lex_state = 12},
  [762] = {.lex_state = 63},
  [763] = {.lex_state = 80},
  [764] = {.lex_state = 63, .external_lex_state = 18},
  [765] = {.lex_state = 80},
  [766] = {.lex_state = 203, .external_lex_state = 21},
  [767] = {.lex_state = 149, .external_lex_state = 12},
  [768] = {.lex_state = 263},
  [769] = {.lex_state = 231, .external_lex_state = 13},
  [770] = {.lex_state = 162, .external_lex_state = 13},
  [771] = {.lex_state = 231, .external_lex_state = 13},
  [772] = {.lex_state = 166},
  [773] = {.lex_state = 234, .external_lex_state = 16},
  [774] = {.lex_state = 69},
  [775] = {.lex_state = 174, .external_lex_state = 16},
  [776] = {.lex_state = 174, .external_lex_state = 16},
  [777] = {.lex_state = 174, .external_lex_state = 16},
  [778] = {.lex_state = 231, .external_lex_state = 13},
  [779] = {.lex_state = 238},
  [780] = {.lex_state = 236, .external_lex_state = 16},
  [781] = {.lex_state = 231, .external_lex_state = 13},
  [782] = {.lex_state = 238},
  [783] = {.lex_state = 236, .external_lex_state = 16},
  [784] = {.lex_state = 231, .external_lex_state = 13},
  [785] = {.lex_state = 238},
  [786] = {.lex_state = 236, .external_lex_state = 16},
  [787] = {.lex_state = 231, .external_lex_state = 13},
  [788] = {.lex_state = 218, .external_lex_state = 2},
  [789] = {.lex_state = 137, .external_lex_state = 4},
  [790] = {.lex_state = 141, .external_lex_state = 8},
  [791] = {.lex_state = 63, .external_lex_state = 2},
  [792] = {.lex_state = 90, .external_lex_state = 4},
  [793] = {.lex_state = 122, .external_lex_state = 8},
  [794] = {.lex_state = 231, .external_lex_state = 13},
  [795] = {.lex_state = 218, .external_lex_state = 2},
  [796] = {.lex_state = 137, .external_lex_state = 4},
  [797] = {.lex_state = 141, .external_lex_state = 8},
  [798] = {.lex_state = 263},
  [799] = {.lex_state = 263},
  [800] = {.lex_state = 137, .external_lex_state = 3},
  [801] = {.lex_state = 209},
  [802] = {.lex_state = 90, .external_lex_state = 14},
  [803] = {.lex_state = 90, .external_lex_state = 14},
  [804] = {.lex_state = 137, .external_lex_state = 14},
  [805] = {.lex_state = 90, .external_lex_state = 14},
  [806] = {.lex_state = 137, .external_lex_state = 14},
  [807] = {.lex_state = 166},
  [808] = {.lex_state = 234, .external_lex_state = 16},
  [809] = {.lex_state = 69},
  [810] = {.lex_state = 174, .external_lex_state = 16},
  [811] = {.lex_state = 174, .external_lex_state = 16},
  [812] = {.lex_state = 174, .external_lex_state = 16},
  [813] = {.lex_state = 137, .external_lex_state = 14},
  [814] = {.lex_state = 238},
  [815] = {.lex_state = 236, .external_lex_state = 16},
  [816] = {.lex_state = 137, .external_lex_state = 14},
  [817] = {.lex_state = 238},
  [818] = {.lex_state = 236, .external_lex_state = 16},
  [819] = {.lex_state = 137, .external_lex_state = 14},
  [820] = {.lex_state = 238},
  [821] = {.lex_state = 236, .external_lex_state = 16},
  [822] = {.lex_state = 137, .external_lex_state = 14},
  [823] = {.lex_state = 218, .external_lex_state = 2},
  [824] = {.lex_state = 137, .external_lex_state = 4},
  [825] = {.lex_state = 141, .external_lex_state = 8},
  [826] = {.lex_state = 63, .external_lex_state = 2},
  [827] = {.lex_state = 90, .external_lex_state = 4},
  [828] = {.lex_state = 122, .external_lex_state = 8},
  [829] = {.lex_state = 137, .external_lex_state = 14},
  [830] = {.lex_state = 218, .external_lex_state = 2},
  [831] = {.lex_state = 137, .external_lex_state = 4},
  [832] = {.lex_state = 141, .external_lex_state = 8},
  [833] = {.lex_state = 137, .external_lex_state = 10},
  [834] = {.lex_state = 90, .external_lex_state = 10},
  [835] = {.lex_state = 137, .external_lex_state = 10},
  [836] = {.lex_state = 166},
  [837] = {.lex_state = 234, .external_lex_state = 16},
  [838] = {.lex_state = 69},
  [839] = {.lex_state = 174, .external_lex_state = 16},
  [840] = {.lex_state = 174, .external_lex_state = 16},
  [841] = {.lex_state = 174, .external_lex_state = 16},
  [842] = {.lex_state = 137, .external_lex_state = 10},
  [843] = {.lex_state = 238},
  [844] = {.lex_state = 236, .external_lex_state = 16},
  [845] = {.lex_state = 137, .external_lex_state = 10},
  [846] = {.lex_state = 238},
  [847] = {.lex_state = 236, .external_lex_state = 16},
  [848] = {.lex_state = 137, .external_lex_state = 10},
  [849] = {.lex_state = 238},
  [850] = {.lex_state = 236, .external_lex_state = 16},
  [851] = {.lex_state = 137, .external_lex_state = 10},
  [852] = {.lex_state = 218, .external_lex_state = 2},
  [853] = {.lex_state = 137, .external_lex_state = 4},
  [854] = {.lex_state = 141, .external_lex_state = 8},
  [855] = {.lex_state = 63, .external_lex_state = 2},
  [856] = {.lex_state = 90, .external_lex_state = 4},
  [857] = {.lex_state = 122, .external_lex_state = 8},
  [858] = {.lex_state = 137, .external_lex_state = 10},
  [859] = {.lex_state = 218, .external_lex_state = 2},
  [860] = {.lex_state = 137, .external_lex_state = 4},
  [861] = {.lex_state = 141, .external_lex_state = 8},
  [862] = {.lex_state = 80, .external_lex_state = 15},
  [863] = {.lex_state = 80, .external_lex_state = 15},
  [864] = {.lex_state = 80, .external_lex_state = 15},
  [865] = {.lex_state = 166},
  [866] = {.lex_state = 234, .external_lex_state = 16},
  [867] = {.lex_state = 69},
  [868] = {.lex_state = 174, .external_lex_state = 16},
  [869] = {.lex_state = 174, .external_lex_state = 16},
  [870] = {.lex_state = 174, .external_lex_state = 16},
  [871] = {.lex_state = 80, .external_lex_state = 15},
  [872] = {.lex_state = 238},
  [873] = {.lex_state = 236, .external_lex_state = 16},
  [874] = {.lex_state = 80, .external_lex_state = 15},
  [875] = {.lex_state = 238},
  [876] = {.lex_state = 236, .external_lex_state = 16},
  [877] = {.lex_state = 80, .external_lex_state = 15},
  [878] = {.lex_state = 238},
  [879] = {.lex_state = 236, .external_lex_state = 16},
  [880] = {.lex_state = 80, .external_lex_state = 15},
  [881] = {.lex_state = 218, .external_lex_state = 2},
  [882] = {.lex_state = 137, .external_lex_state = 4},
  [883] = {.lex_state = 141, .external_lex_state = 8},
  [884] = {.lex_state = 63, .external_lex_state = 2},
  [885] = {.lex_state = 90, .external_lex_state = 4},
  [886] = {.lex_state = 122, .external_lex_state = 8},
  [887] = {.lex_state = 80, .external_lex_state = 15},
  [888] = {.lex_state = 218, .external_lex_state = 2},
  [889] = {.lex_state = 137, .external_lex_state = 4},
  [890] = {.lex_state = 141, .external_lex_state = 8},
  [891] = {.lex_state = 97},
  [892] = {.lex_state = 234, .external_lex_state = 16},
  [893] = {.lex_state = 69},
  [894] = {.lex_state = 174, .external_lex_state = 16},
  [895] = {.lex_state = 174, .external_lex_state = 16},
  [896] = {.lex_state = 174, .external_lex_state = 16},
  [897] = {.lex_state = 97, .external_lex_state = 13},
  [898] = {.lex_state = 238},
  [899] = {.lex_state = 236, .external_lex_state = 16},
  [900] = {.lex_state = 97, .external_lex_state = 13},
  [901] = {.lex_state = 238},
  [902] = {.lex_state = 236, .external_lex_state = 16},
  [903] = {.lex_state = 97, .external_lex_state = 13},
  [904] = {.lex_state = 238},
  [905] = {.lex_state = 236, .external_lex_state = 16},
  [906] = {.lex_state = 97, .external_lex_state = 13},
  [907] = {.lex_state = 218, .external_lex_state = 2},
  [908] = {.lex_state = 137, .external_lex_state = 4},
  [909] = {.lex_state = 141, .external_lex_state = 8},
  [910] = {.lex_state = 63, .external_lex_state = 2},
  [911] = {.lex_state = 90, .external_lex_state = 4},
  [912] = {.lex_state = 122, .external_lex_state = 8},
  [913] = {.lex_state = 124, .external_lex_state = 5},
  [914] = {.lex_state = 166},
  [915] = {.lex_state = 207, .external_lex_state = 11},
  [916] = {.lex_state = 207, .external_lex_state = 11},
  [917] = {.lex_state = 207, .external_lex_state = 11},
  [918] = {.lex_state = 124, .external_lex_state = 5},
  [919] = {.lex_state = 213, .external_lex_state = 22},
  [920] = {.lex_state = 97},
  [921] = {.lex_state = 104},
  [922] = {.lex_state = 213, .external_lex_state = 22},
  [923] = {.lex_state = 113, .external_lex_state = 6},
  [924] = {.lex_state = 63, .external_lex_state = 2},
  [925] = {.lex_state = 63, .external_lex_state = 2},
  [926] = {.lex_state = 63, .external_lex_state = 2},
  [927] = {.lex_state = 213, .external_lex_state = 16},
  [928] = {.lex_state = 234, .external_lex_state = 16},
  [929] = {.lex_state = 124, .external_lex_state = 5},
  [930] = {.lex_state = 238},
  [931] = {.lex_state = 236, .external_lex_state = 16},
  [932] = {.lex_state = 124, .external_lex_state = 5},
  [933] = {.lex_state = 238},
  [934] = {.lex_state = 236, .external_lex_state = 16},
  [935] = {.lex_state = 238},
  [936] = {.lex_state = 236, .external_lex_state = 16},
  [937] = {.lex_state = 80},
  [938] = {.lex_state = 236, .external_lex_state = 22},
  [939] = {.lex_state = 236, .external_lex_state = 22},
  [940] = {.lex_state = 166},
  [941] = {.lex_state = 97},
  [942] = {.lex_state = 236, .external_lex_state = 22},
  [943] = {.lex_state = 236, .external_lex_state = 22},
  [944] = {.lex_state = 236, .external_lex_state = 22},
  [945] = {.lex_state = 69},
  [946] = {.lex_state = 172, .external_lex_state = 6},
  [947] = {.lex_state = 174, .external_lex_state = 16},
  [948] = {.lex_state = 174, .external_lex_state = 16},
  [949] = {.lex_state = 174, .external_lex_state = 16},
  [950] = {.lex_state = 236, .external_lex_state = 16},
  [951] = {.lex_state = 137, .external_lex_state = 4},
  [952] = {.lex_state = 141, .external_lex_state = 8},
  [953] = {.lex_state = 63, .external_lex_state = 2},
  [954] = {.lex_state = 90, .external_lex_state = 4},
  [955] = {.lex_state = 122, .external_lex_state = 8},
  [956] = {.lex_state = 63, .external_lex_state = 2},
  [957] = {.lex_state = 137, .external_lex_state = 4},
  [958] = {.lex_state = 141, .external_lex_state = 8},
  [959] = {.lex_state = 63, .external_lex_state = 2},
  [960] = {.lex_state = 124, .external_lex_state = 5},
  [961] = {.lex_state = 236, .external_lex_state = 16},
  [962] = {.lex_state = 236, .external_lex_state = 16},
  [963] = {.lex_state = 124, .external_lex_state = 5},
  [964] = {.lex_state = 236, .external_lex_state = 16},
  [965] = {.lex_state = 124, .external_lex_state = 5},
  [966] = {.lex_state = 218, .external_lex_state = 2},
  [967] = {.lex_state = 245, .external_lex_state = 7},
  [968] = {.lex_state = 84},
  [969] = {.lex_state = 265, .external_lex_state = 21},
  [970] = {.lex_state = 245, .external_lex_state = 21},
  [971] = {.lex_state = 135},
  [972] = {.lex_state = 122, .external_lex_state = 8},
  [973] = {.lex_state = 90, .external_lex_state = 4},
  [974] = {.lex_state = 122, .external_lex_state = 8},
  [975] = {.lex_state = 80},
  [976] = {.lex_state = 245, .external_lex_state = 5},
  [977] = {.lex_state = 245, .external_lex_state = 5},
  [978] = {.lex_state = 245, .external_lex_state = 5},
  [979] = {.lex_state = 245, .external_lex_state = 5},
  [980] = {.lex_state = 245, .external_lex_state = 7},
  [981] = {.lex_state = 245, .external_lex_state = 7},
  [982] = {.lex_state = 63, .external_lex_state = 2},
  [983] = {.lex_state = 94, .external_lex_state = 7},
  [984] = {.lex_state = 124, .external_lex_state = 5},
  [985] = {.lex_state = 218, .external_lex_state = 2},
  [986] = {.lex_state = 215, .external_lex_state = 21},
  [987] = {.lex_state = 177, .external_lex_state = 17},
  [988] = {.lex_state = 177, .external_lex_state = 17},
  [989] = {.lex_state = 69},
  [990] = {.lex_state = 172, .external_lex_state = 6},
  [991] = {.lex_state = 174, .external_lex_state = 16},
  [992] = {.lex_state = 174, .external_lex_state = 16},
  [993] = {.lex_state = 174, .external_lex_state = 16},
  [994] = {.lex_state = 143, .external_lex_state = 4},
  [995] = {.lex_state = 177, .external_lex_state = 17},
  [996] = {.lex_state = 203, .external_lex_state = 5},
  [997] = {.lex_state = 203, .external_lex_state = 5},
  [998] = {.lex_state = 247, .external_lex_state = 7},
  [999] = {.lex_state = 203, .external_lex_state = 5},
  [1000] = {.lex_state = 143, .external_lex_state = 4},
  [1001] = {.lex_state = 267, .external_lex_state = 2},
  [1002] = {.lex_state = 203, .external_lex_state = 7},
  [1003] = {.lex_state = 69, .external_lex_state = 13},
  [1004] = {.lex_state = 69},
  [1005] = {.lex_state = 207, .external_lex_state = 11},
  [1006] = {.lex_state = 69, .external_lex_state = 13},
  [1007] = {.lex_state = 69},
  [1008] = {.lex_state = 80},
  [1009] = {.lex_state = 209, .external_lex_state = 13},
  [1010] = {.lex_state = 209, .external_lex_state = 13},
  [1011] = {.lex_state = 166},
  [1012] = {.lex_state = 97},
  [1013] = {.lex_state = 209, .external_lex_state = 13},
  [1014] = {.lex_state = 209, .external_lex_state = 13},
  [1015] = {.lex_state = 209, .external_lex_state = 13},
  [1016] = {.lex_state = 69},
  [1017] = {.lex_state = 172, .external_lex_state = 6},
  [1018] = {.lex_state = 174, .external_lex_state = 16},
  [1019] = {.lex_state = 174, .external_lex_state = 16},
  [1020] = {.lex_state = 174, .external_lex_state = 16},
  [1021] = {.lex_state = 137, .external_lex_state = 4},
  [1022] = {.lex_state = 141, .external_lex_state = 8},
  [1023] = {.lex_state = 63, .external_lex_state = 2},
  [1024] = {.lex_state = 90, .external_lex_state = 4},
  [1025] = {.lex_state = 122, .external_lex_state = 8},
  [1026] = {.lex_state = 63, .external_lex_state = 2},
  [1027] = {.lex_state = 137, .external_lex_state = 4},
  [1028] = {.lex_state = 141, .external_lex_state = 8},
  [1029] = {.lex_state = 63, .external_lex_state = 2},
  [1030] = {.lex_state = 141, .external_lex_state = 8},
  [1031] = {.lex_state = 209},
  [1032] = {.lex_state = 141, .external_lex_state = 19},
  [1033] = {.lex_state = 122, .external_lex_state = 19},
  [1034] = {.lex_state = 141, .external_lex_state = 19},
  [1035] = {.lex_state = 166},
  [1036] = {.lex_state = 234, .external_lex_state = 16},
  [1037] = {.lex_state = 69},
  [1038] = {.lex_state = 174, .external_lex_state = 16},
  [1039] = {.lex_state = 174, .external_lex_state = 16},
  [1040] = {.lex_state = 174, .external_lex_state = 16},
  [1041] = {.lex_state = 141, .external_lex_state = 19},
  [1042] = {.lex_state = 238},
  [1043] = {.lex_state = 236, .external_lex_state = 16},
  [1044] = {.lex_state = 141, .external_lex_state = 19},
  [1045] = {.lex_state = 238},
  [1046] = {.lex_state = 236, .external_lex_state = 16},
  [1047] = {.lex_state = 141, .external_lex_state = 19},
  [1048] = {.lex_state = 238},
  [1049] = {.lex_state = 236, .external_lex_state = 16},
  [1050] = {.lex_state = 141, .external_lex_state = 19},
  [1051] = {.lex_state = 218, .external_lex_state = 2},
  [1052] = {.lex_state = 137, .external_lex_state = 4},
  [1053] = {.lex_state = 141, .external_lex_state = 8},
  [1054] = {.lex_state = 63, .external_lex_state = 2},
  [1055] = {.lex_state = 90, .external_lex_state = 4},
  [1056] = {.lex_state = 122, .external_lex_state = 8},
  [1057] = {.lex_state = 141, .external_lex_state = 19},
  [1058] = {.lex_state = 218, .external_lex_state = 2},
  [1059] = {.lex_state = 137, .external_lex_state = 4},
  [1060] = {.lex_state = 141, .external_lex_state = 8},
  [1061] = {.lex_state = 270},
  [1062] = {.lex_state = 84},
  [1063] = {.lex_state = 84},
  [1064] = {.lex_state = 272, .external_lex_state = 13},
  [1065] = {.lex_state = 97},
  [1066] = {.lex_state = 104},
  [1067] = {.lex_state = 272, .external_lex_state = 13},
  [1068] = {.lex_state = 113, .external_lex_state = 6},
  [1069] = {.lex_state = 63, .external_lex_state = 2},
  [1070] = {.lex_state = 63, .external_lex_state = 2},
  [1071] = {.lex_state = 63, .external_lex_state = 2},
  [1072] = {.lex_state = 272},
  [1073] = {.lex_state = 249},
  [1074] = {.lex_state = 211, .external_lex_state = 4},
  [1075] = {.lex_state = 253, .external_lex_state = 10},
  [1076] = {.lex_state = 211, .external_lex_state = 10},
  [1077] = {.lex_state = 253, .external_lex_state = 10},
  [1078] = {.lex_state = 166},
  [1079] = {.lex_state = 234, .external_lex_state = 16},
  [1080] = {.lex_state = 69},
  [1081] = {.lex_state = 174, .external_lex_state = 16},
  [1082] = {.lex_state = 174, .external_lex_state = 16},
  [1083] = {.lex_state = 174, .external_lex_state = 16},
  [1084] = {.lex_state = 253, .external_lex_state = 10},
  [1085] = {.lex_state = 238},
  [1086] = {.lex_state = 236, .external_lex_state = 16},
  [1087] = {.lex_state = 253, .external_lex_state = 10},
  [1088] = {.lex_state = 238},
  [1089] = {.lex_state = 236, .external_lex_state = 16},
  [1090] = {.lex_state = 253, .external_lex_state = 10},
  [1091] = {.lex_state = 238},
  [1092] = {.lex_state = 236, .external_lex_state = 16},
  [1093] = {.lex_state = 253, .external_lex_state = 10},
  [1094] = {.lex_state = 218, .external_lex_state = 2},
  [1095] = {.lex_state = 137, .external_lex_state = 4},
  [1096] = {.lex_state = 141, .external_lex_state = 8},
  [1097] = {.lex_state = 63, .external_lex_state = 2},
  [1098] = {.lex_state = 90, .external_lex_state = 4},
  [1099] = {.lex_state = 122, .external_lex_state = 8},
  [1100] = {.lex_state = 253, .external_lex_state = 10},
  [1101] = {.lex_state = 218, .external_lex_state = 2},
  [1102] = {.lex_state = 137, .external_lex_state = 4},
  [1103] = {.lex_state = 141, .external_lex_state = 8},
  [1104] = {.lex_state = 211, .external_lex_state = 4},
  [1105] = {.lex_state = 211, .external_lex_state = 4},
  [1106] = {.lex_state = 211, .external_lex_state = 4},
  [1107] = {.lex_state = 80},
  [1108] = {.lex_state = 255, .external_lex_state = 10},
  [1109] = {.lex_state = 255, .external_lex_state = 10},
  [1110] = {.lex_state = 166},
  [1111] = {.lex_state = 97},
  [1112] = {.lex_state = 255, .external_lex_state = 10},
  [1113] = {.lex_state = 255, .external_lex_state = 10},
  [1114] = {.lex_state = 255, .external_lex_state = 10},
  [1115] = {.lex_state = 69},
  [1116] = {.lex_state = 172, .external_lex_state = 6},
  [1117] = {.lex_state = 174, .external_lex_state = 16},
  [1118] = {.lex_state = 174, .external_lex_state = 16},
  [1119] = {.lex_state = 174, .external_lex_state = 16},
  [1120] = {.lex_state = 137, .external_lex_state = 4},
  [1121] = {.lex_state = 141, .external_lex_state = 8},
  [1122] = {.lex_state = 63, .external_lex_state = 2},
  [1123] = {.lex_state = 90, .external_lex_state = 4},
  [1124] = {.lex_state = 122, .external_lex_state = 8},
  [1125] = {.lex_state = 63, .external_lex_state = 2},
  [1126] = {.lex_state = 137, .external_lex_state = 4},
  [1127] = {.lex_state = 141, .external_lex_state = 8},
  [1128] = {.lex_state = 63, .external_lex_state = 2},
  [1129] = {.lex_state = 80},
  [1130] = {.lex_state = 255, .external_lex_state = 4},
  [1131] = {.lex_state = 143, .external_lex_state = 4},
  [1132] = {.lex_state = 63, .external_lex_state = 2},
  [1133] = {.lex_state = 122, .external_lex_state = 19},
  [1134] = {.lex_state = 203, .external_lex_state = 7},
  [1135] = {.lex_state = 135},
  [1136] = {.lex_state = 63},
  [1137] = {.lex_state = 80},
  [1138] = {.lex_state = 63},
  [1139] = {.lex_state = 80},
  [1140] = {.lex_state = 80},
  [1141] = {.lex_state = 203, .external_lex_state = 21},
  [1142] = {.lex_state = 90, .external_lex_state = 14},
  [1143] = {.lex_state = 90, .external_lex_state = 14},
  [1144] = {.lex_state = 90, .external_lex_state = 14},
  [1145] = {.lex_state = 90, .external_lex_state = 10},
  [1146] = {.lex_state = 215, .external_lex_state = 21},
  [1147] = {.lex_state = 247, .external_lex_state = 7},
  [1148] = {.lex_state = 63, .external_lex_state = 2},
  [1149] = {.lex_state = 143, .external_lex_state = 4},
  [1150] = {.lex_state = 203, .external_lex_state = 5},
  [1151] = {.lex_state = 203, .external_lex_state = 5},
  [1152] = {.lex_state = 203, .external_lex_state = 5},
  [1153] = {.lex_state = 203, .external_lex_state = 7},
  [1154] = {.lex_state = 80},
  [1155] = {.lex_state = 63, .external_lex_state = 2},
  [1156] = {.lex_state = 143, .external_lex_state = 4},
  [1157] = {.lex_state = 80},
  [1158] = {.lex_state = 63, .external_lex_state = 2},
  [1159] = {.lex_state = 80},
  [1160] = {.lex_state = 80},
  [1161] = {.lex_state = 143, .external_lex_state = 4},
  [1162] = {.lex_state = 274, .external_lex_state = 13},
  [1163] = {.lex_state = 274, .external_lex_state = 13},
  [1164] = {.lex_state = 277},
  [1165] = {.lex_state = 274},
  [1166] = {.lex_state = 80},
  [1167] = {.lex_state = 257},
  [1168] = {.lex_state = 131, .external_lex_state = 10},
  [1169] = {.lex_state = 143, .external_lex_state = 4},
  [1170] = {.lex_state = 277},
  [1171] = {.lex_state = 80},
  [1172] = {.lex_state = 257},
  [1173] = {.lex_state = 131, .external_lex_state = 10},
  [1174] = {.lex_state = 213, .external_lex_state = 22},
  [1175] = {.lex_state = 213, .external_lex_state = 22},
  [1176] = {.lex_state = 213, .external_lex_state = 16},
  [1177] = {.lex_state = 234, .external_lex_state = 16},
  [1178] = {.lex_state = 131, .external_lex_state = 10},
  [1179] = {.lex_state = 238},
  [1180] = {.lex_state = 236, .external_lex_state = 16},
  [1181] = {.lex_state = 131, .external_lex_state = 10},
  [1182] = {.lex_state = 238},
  [1183] = {.lex_state = 236, .external_lex_state = 16},
  [1184] = {.lex_state = 238},
  [1185] = {.lex_state = 236, .external_lex_state = 16},
  [1186] = {.lex_state = 236, .external_lex_state = 16},
  [1187] = {.lex_state = 131, .external_lex_state = 10},
  [1188] = {.lex_state = 236, .external_lex_state = 16},
  [1189] = {.lex_state = 131, .external_lex_state = 10},
  [1190] = {.lex_state = 236, .external_lex_state = 16},
  [1191] = {.lex_state = 131, .external_lex_state = 10},
  [1192] = {.lex_state = 218, .external_lex_state = 2},
  [1193] = {.lex_state = 63, .external_lex_state = 2},
  [1194] = {.lex_state = 131, .external_lex_state = 10},
  [1195] = {.lex_state = 218, .external_lex_state = 2},
  [1196] = {.lex_state = 215, .external_lex_state = 21},
  [1197] = {.lex_state = 213, .external_lex_state = 20},
  [1198] = {.lex_state = 259, .external_lex_state = 21},
  [1199] = {.lex_state = 213, .external_lex_state = 20},
  [1200] = {.lex_state = 80},
  [1201] = {.lex_state = 120, .external_lex_state = 10},
  [1202] = {.lex_state = 120, .external_lex_state = 10},
  [1203] = {.lex_state = 143, .external_lex_state = 4},
  [1204] = {.lex_state = 141, .external_lex_state = 19},
  [1205] = {.lex_state = 220, .external_lex_state = 7},
  [1206] = {.lex_state = 135},
  [1207] = {.lex_state = 63},
  [1208] = {.lex_state = 80},
  [1209] = {.lex_state = 63},
  [1210] = {.lex_state = 80},
  [1211] = {.lex_state = 80},
  [1212] = {.lex_state = 220, .external_lex_state = 21},
  [1213] = {.lex_state = 137, .external_lex_state = 14},
  [1214] = {.lex_state = 137, .external_lex_state = 14},
  [1215] = {.lex_state = 137, .external_lex_state = 14},
  [1216] = {.lex_state = 137, .external_lex_state = 10},
  [1217] = {.lex_state = 261, .external_lex_state = 21},
  [1218] = {.lex_state = 220, .external_lex_state = 5},
  [1219] = {.lex_state = 220, .external_lex_state = 5},
  [1220] = {.lex_state = 220, .external_lex_state = 5},
  [1221] = {.lex_state = 143, .external_lex_state = 4},
  [1222] = {.lex_state = 220, .external_lex_state = 7},
  [1223] = {.lex_state = 80, .external_lex_state = 2},
  [1224] = {.lex_state = 209},
  [1225] = {.lex_state = 222, .external_lex_state = 13},
  [1226] = {.lex_state = 149, .external_lex_state = 11},
  [1227] = {.lex_state = 149, .external_lex_state = 11},
  [1228] = {.lex_state = 213, .external_lex_state = 22},
  [1229] = {.lex_state = 213, .external_lex_state = 22},
  [1230] = {.lex_state = 213, .external_lex_state = 16},
  [1231] = {.lex_state = 234, .external_lex_state = 16},
  [1232] = {.lex_state = 149, .external_lex_state = 11},
  [1233] = {.lex_state = 238},
  [1234] = {.lex_state = 236, .external_lex_state = 16},
  [1235] = {.lex_state = 149, .external_lex_state = 11},
  [1236] = {.lex_state = 238},
  [1237] = {.lex_state = 236, .external_lex_state = 16},
  [1238] = {.lex_state = 238},
  [1239] = {.lex_state = 236, .external_lex_state = 16},
  [1240] = {.lex_state = 236, .external_lex_state = 16},
  [1241] = {.lex_state = 149, .external_lex_state = 11},
  [1242] = {.lex_state = 236, .external_lex_state = 16},
  [1243] = {.lex_state = 149, .external_lex_state = 11},
  [1244] = {.lex_state = 236, .external_lex_state = 16},
  [1245] = {.lex_state = 149, .external_lex_state = 11},
  [1246] = {.lex_state = 218, .external_lex_state = 2},
  [1247] = {.lex_state = 63, .external_lex_state = 2},
  [1248] = {.lex_state = 149, .external_lex_state = 11},
  [1249] = {.lex_state = 218, .external_lex_state = 2},
  [1250] = {.lex_state = 80},
  [1251] = {.lex_state = 203, .external_lex_state = 23},
  [1252] = {.lex_state = 97},
  [1253] = {.lex_state = 104},
  [1254] = {.lex_state = 203, .external_lex_state = 23},
  [1255] = {.lex_state = 113, .external_lex_state = 6},
  [1256] = {.lex_state = 63, .external_lex_state = 2},
  [1257] = {.lex_state = 63, .external_lex_state = 2},
  [1258] = {.lex_state = 63, .external_lex_state = 2},
  [1259] = {.lex_state = 247, .external_lex_state = 21},
  [1260] = {.lex_state = 247, .external_lex_state = 21},
  [1261] = {.lex_state = 203, .external_lex_state = 23},
  [1262] = {.lex_state = 203, .external_lex_state = 23},
  [1263] = {.lex_state = 247, .external_lex_state = 21},
  [1264] = {.lex_state = 203, .external_lex_state = 21},
  [1265] = {.lex_state = 231, .external_lex_state = 13},
  [1266] = {.lex_state = 231, .external_lex_state = 13},
  [1267] = {.lex_state = 213, .external_lex_state = 22},
  [1268] = {.lex_state = 213, .external_lex_state = 22},
  [1269] = {.lex_state = 213, .external_lex_state = 16},
  [1270] = {.lex_state = 234, .external_lex_state = 16},
  [1271] = {.lex_state = 231, .external_lex_state = 13},
  [1272] = {.lex_state = 238},
  [1273] = {.lex_state = 236, .external_lex_state = 16},
  [1274] = {.lex_state = 231, .external_lex_state = 13},
  [1275] = {.lex_state = 238},
  [1276] = {.lex_state = 236, .external_lex_state = 16},
  [1277] = {.lex_state = 238},
  [1278] = {.lex_state = 236, .external_lex_state = 16},
  [1279] = {.lex_state = 236, .external_lex_state = 16},
  [1280] = {.lex_state = 231, .external_lex_state = 13},
  [1281] = {.lex_state = 236, .external_lex_state = 16},
  [1282] = {.lex_state = 231, .external_lex_state = 13},
  [1283] = {.lex_state = 236, .external_lex_state = 16},
  [1284] = {.lex_state = 231, .external_lex_state = 13},
  [1285] = {.lex_state = 218, .external_lex_state = 2},
  [1286] = {.lex_state = 63, .external_lex_state = 2},
  [1287] = {.lex_state = 231, .external_lex_state = 13},
  [1288] = {.lex_state = 218, .external_lex_state = 2},
  [1289] = {.lex_state = 137, .external_lex_state = 3},
  [1290] = {.lex_state = 209},
  [1291] = {.lex_state = 137, .external_lex_state = 14},
  [1292] = {.lex_state = 137, .external_lex_state = 14},
  [1293] = {.lex_state = 213, .external_lex_state = 22},
  [1294] = {.lex_state = 213, .external_lex_state = 22},
  [1295] = {.lex_state = 213, .external_lex_state = 16},
  [1296] = {.lex_state = 234, .external_lex_state = 16},
  [1297] = {.lex_state = 137, .external_lex_state = 14},
  [1298] = {.lex_state = 238},
  [1299] = {.lex_state = 236, .external_lex_state = 16},
  [1300] = {.lex_state = 137, .external_lex_state = 14},
  [1301] = {.lex_state = 238},
  [1302] = {.lex_state = 236, .external_lex_state = 16},
  [1303] = {.lex_state = 238},
  [1304] = {.lex_state = 236, .external_lex_state = 16},
  [1305] = {.lex_state = 236, .external_lex_state = 16},
  [1306] = {.lex_state = 137, .external_lex_state = 14},
  [1307] = {.lex_state = 236, .external_lex_state = 16},
  [1308] = {.lex_state = 137, .external_lex_state = 14},
  [1309] = {.lex_state = 236, .external_lex_state = 16},
  [1310] = {.lex_state = 137, .external_lex_state = 14},
  [1311] = {.lex_state = 218, .external_lex_state = 2},
  [1312] = {.lex_state = 63, .external_lex_state = 2},
  [1313] = {.lex_state = 137, .external_lex_state = 14},
  [1314] = {.lex_state = 218, .external_lex_state = 2},
  [1315] = {.lex_state = 137, .external_lex_state = 10},
  [1316] = {.lex_state = 137, .external_lex_state = 10},
  [1317] = {.lex_state = 213, .external_lex_state = 22},
  [1318] = {.lex_state = 213, .external_lex_state = 22},
  [1319] = {.lex_state = 213, .external_lex_state = 16},
  [1320] = {.lex_state = 234, .external_lex_state = 16},
  [1321] = {.lex_state = 137, .external_lex_state = 10},
  [1322] = {.lex_state = 238},
  [1323] = {.lex_state = 236, .external_lex_state = 16},
  [1324] = {.lex_state = 137, .external_lex_state = 10},
  [1325] = {.lex_state = 238},
  [1326] = {.lex_state = 236, .external_lex_state = 16},
  [1327] = {.lex_state = 238},
  [1328] = {.lex_state = 236, .external_lex_state = 16},
  [1329] = {.lex_state = 236, .external_lex_state = 16},
  [1330] = {.lex_state = 137, .external_lex_state = 10},
  [1331] = {.lex_state = 236, .external_lex_state = 16},
  [1332] = {.lex_state = 137, .external_lex_state = 10},
  [1333] = {.lex_state = 236, .external_lex_state = 16},
  [1334] = {.lex_state = 137, .external_lex_state = 10},
  [1335] = {.lex_state = 218, .external_lex_state = 2},
  [1336] = {.lex_state = 63, .external_lex_state = 2},
  [1337] = {.lex_state = 137, .external_lex_state = 10},
  [1338] = {.lex_state = 218, .external_lex_state = 2},
  [1339] = {.lex_state = 80, .external_lex_state = 15},
  [1340] = {.lex_state = 80, .external_lex_state = 15},
  [1341] = {.lex_state = 213, .external_lex_state = 22},
  [1342] = {.lex_state = 213, .external_lex_state = 22},
  [1343] = {.lex_state = 213, .external_lex_state = 16},
  [1344] = {.lex_state = 234, .external_lex_state = 16},
  [1345] = {.lex_state = 80, .external_lex_state = 15},
  [1346] = {.lex_state = 238},
  [1347] = {.lex_state = 236, .external_lex_state = 16},
  [1348] = {.lex_state = 80, .external_lex_state = 15},
  [1349] = {.lex_state = 238},
  [1350] = {.lex_state = 236, .external_lex_state = 16},
  [1351] = {.lex_state = 238},
  [1352] = {.lex_state = 236, .external_lex_state = 16},
  [1353] = {.lex_state = 236, .external_lex_state = 16},
  [1354] = {.lex_state = 80, .external_lex_state = 15},
  [1355] = {.lex_state = 236, .external_lex_state = 16},
  [1356] = {.lex_state = 80, .external_lex_state = 15},
  [1357] = {.lex_state = 236, .external_lex_state = 16},
  [1358] = {.lex_state = 80, .external_lex_state = 15},
  [1359] = {.lex_state = 218, .external_lex_state = 2},
  [1360] = {.lex_state = 63, .external_lex_state = 2},
  [1361] = {.lex_state = 80, .external_lex_state = 15},
  [1362] = {.lex_state = 218, .external_lex_state = 2},
  [1363] = {.lex_state = 97, .external_lex_state = 13},
  [1364] = {.lex_state = 213, .external_lex_state = 22},
  [1365] = {.lex_state = 213, .external_lex_state = 22},
  [1366] = {.lex_state = 213, .external_lex_state = 16},
  [1367] = {.lex_state = 234, .external_lex_state = 16},
  [1368] = {.lex_state = 97, .external_lex_state = 13},
  [1369] = {.lex_state = 238},
  [1370] = {.lex_state = 236, .external_lex_state = 16},
  [1371] = {.lex_state = 97, .external_lex_state = 13},
  [1372] = {.lex_state = 238},
  [1373] = {.lex_state = 236, .external_lex_state = 16},
  [1374] = {.lex_state = 238},
  [1375] = {.lex_state = 236, .external_lex_state = 16},
  [1376] = {.lex_state = 236, .external_lex_state = 16},
  [1377] = {.lex_state = 97, .external_lex_state = 13},
  [1378] = {.lex_state = 236, .external_lex_state = 16},
  [1379] = {.lex_state = 97, .external_lex_state = 13},
  [1380] = {.lex_state = 236, .external_lex_state = 16},
  [1381] = {.lex_state = 97, .external_lex_state = 13},
  [1382] = {.lex_state = 218, .external_lex_state = 2},
  [1383] = {.lex_state = 63, .external_lex_state = 2},
  [1384] = {.lex_state = 207, .external_lex_state = 12},
  [1385] = {.lex_state = 174, .external_lex_state = 22},
  [1386] = {.lex_state = 207, .external_lex_state = 12},
  [1387] = {.lex_state = 174, .external_lex_state = 22},
  [1388] = {.lex_state = 149, .external_lex_state = 12},
  [1389] = {.lex_state = 80},
  [1390] = {.lex_state = 124, .external_lex_state = 5},
  [1391] = {.lex_state = 213, .external_lex_state = 22},
  [1392] = {.lex_state = 213, .external_lex_state = 22},
  [1393] = {.lex_state = 166},
  [1394] = {.lex_state = 97},
  [1395] = {.lex_state = 213, .external_lex_state = 22},
  [1396] = {.lex_state = 213, .external_lex_state = 22},
  [1397] = {.lex_state = 213, .external_lex_state = 22},
  [1398] = {.lex_state = 124, .external_lex_state = 5},
  [1399] = {.lex_state = 69},
  [1400] = {.lex_state = 172, .external_lex_state = 6},
  [1401] = {.lex_state = 174, .external_lex_state = 16},
  [1402] = {.lex_state = 174, .external_lex_state = 16},
  [1403] = {.lex_state = 174, .external_lex_state = 16},
  [1404] = {.lex_state = 137, .external_lex_state = 4},
  [1405] = {.lex_state = 141, .external_lex_state = 8},
  [1406] = {.lex_state = 63, .external_lex_state = 2},
  [1407] = {.lex_state = 90, .external_lex_state = 4},
  [1408] = {.lex_state = 122, .external_lex_state = 8},
  [1409] = {.lex_state = 63, .external_lex_state = 2},
  [1410] = {.lex_state = 137, .external_lex_state = 4},
  [1411] = {.lex_state = 141, .external_lex_state = 8},
  [1412] = {.lex_state = 63, .external_lex_state = 2},
  [1413] = {.lex_state = 213, .external_lex_state = 22},
  [1414] = {.lex_state = 213, .external_lex_state = 22},
  [1415] = {.lex_state = 213, .external_lex_state = 16},
  [1416] = {.lex_state = 236, .external_lex_state = 16},
  [1417] = {.lex_state = 124, .external_lex_state = 5},
  [1418] = {.lex_state = 236, .external_lex_state = 16},
  [1419] = {.lex_state = 124, .external_lex_state = 5},
  [1420] = {.lex_state = 236, .external_lex_state = 16},
  [1421] = {.lex_state = 236, .external_lex_state = 22},
  [1422] = {.lex_state = 236, .external_lex_state = 22},
  [1423] = {.lex_state = 236, .external_lex_state = 22},
  [1424] = {.lex_state = 166},
  [1425] = {.lex_state = 234, .external_lex_state = 16},
  [1426] = {.lex_state = 69},
  [1427] = {.lex_state = 174, .external_lex_state = 16},
  [1428] = {.lex_state = 174, .external_lex_state = 16},
  [1429] = {.lex_state = 174, .external_lex_state = 16},
  [1430] = {.lex_state = 236, .external_lex_state = 22},
  [1431] = {.lex_state = 238},
  [1432] = {.lex_state = 236, .external_lex_state = 16},
  [1433] = {.lex_state = 236, .external_lex_state = 22},
  [1434] = {.lex_state = 238},
  [1435] = {.lex_state = 236, .external_lex_state = 16},
  [1436] = {.lex_state = 236, .external_lex_state = 22},
  [1437] = {.lex_state = 238},
  [1438] = {.lex_state = 236, .external_lex_state = 16},
  [1439] = {.lex_state = 124, .external_lex_state = 5},
  [1440] = {.lex_state = 236, .external_lex_state = 16},
  [1441] = {.lex_state = 236, .external_lex_state = 22},
  [1442] = {.lex_state = 218, .external_lex_state = 2},
  [1443] = {.lex_state = 137, .external_lex_state = 4},
  [1444] = {.lex_state = 141, .external_lex_state = 8},
  [1445] = {.lex_state = 63, .external_lex_state = 2},
  [1446] = {.lex_state = 90, .external_lex_state = 4},
  [1447] = {.lex_state = 122, .external_lex_state = 8},
  [1448] = {.lex_state = 236, .external_lex_state = 22},
  [1449] = {.lex_state = 218, .external_lex_state = 2},
  [1450] = {.lex_state = 137, .external_lex_state = 4},
  [1451] = {.lex_state = 141, .external_lex_state = 8},
  [1452] = {.lex_state = 124, .external_lex_state = 5},
  [1453] = {.lex_state = 236, .external_lex_state = 16},
  [1454] = {.lex_state = 124, .external_lex_state = 5},
  [1455] = {.lex_state = 236, .external_lex_state = 16},
  [1456] = {.lex_state = 124, .external_lex_state = 5},
  [1457] = {.lex_state = 245, .external_lex_state = 7},
  [1458] = {.lex_state = 135},
  [1459] = {.lex_state = 63},
  [1460] = {.lex_state = 80},
  [1461] = {.lex_state = 63},
  [1462] = {.lex_state = 80},
  [1463] = {.lex_state = 80},
  [1464] = {.lex_state = 245, .external_lex_state = 21},
  [1465] = {.lex_state = 265, .external_lex_state = 21},
  [1466] = {.lex_state = 245, .external_lex_state = 5},
  [1467] = {.lex_state = 245, .external_lex_state = 5},
  [1468] = {.lex_state = 245, .external_lex_state = 5},
  [1469] = {.lex_state = 245, .external_lex_state = 7},
  [1470] = {.lex_state = 124, .external_lex_state = 5},
  [1471] = {.lex_state = 143, .external_lex_state = 4},
  [1472] = {.lex_state = 234, .external_lex_state = 16},
  [1473] = {.lex_state = 69},
  [1474] = {.lex_state = 174, .external_lex_state = 16},
  [1475] = {.lex_state = 174, .external_lex_state = 16},
  [1476] = {.lex_state = 174, .external_lex_state = 16},
  [1477] = {.lex_state = 177, .external_lex_state = 17},
  [1478] = {.lex_state = 238},
  [1479] = {.lex_state = 236, .external_lex_state = 16},
  [1480] = {.lex_state = 177, .external_lex_state = 17},
  [1481] = {.lex_state = 238},
  [1482] = {.lex_state = 236, .external_lex_state = 16},
  [1483] = {.lex_state = 177, .external_lex_state = 17},
  [1484] = {.lex_state = 238},
  [1485] = {.lex_state = 236, .external_lex_state = 16},
  [1486] = {.lex_state = 203, .external_lex_state = 5},
  [1487] = {.lex_state = 143, .external_lex_state = 4},
  [1488] = {.lex_state = 69},
  [1489] = {.lex_state = 69},
  [1490] = {.lex_state = 209, .external_lex_state = 13},
  [1491] = {.lex_state = 209, .external_lex_state = 13},
  [1492] = {.lex_state = 209, .external_lex_state = 13},
  [1493] = {.lex_state = 166},
  [1494] = {.lex_state = 234, .external_lex_state = 16},
  [1495] = {.lex_state = 69},
  [1496] = {.lex_state = 174, .external_lex_state = 16},
  [1497] = {.lex_state = 174, .external_lex_state = 16},
  [1498] = {.lex_state = 174, .external_lex_state = 16},
  [1499] = {.lex_state = 209, .external_lex_state = 13},
  [1500] = {.lex_state = 238},
  [1501] = {.lex_state = 236, .external_lex_state = 16},
  [1502] = {.lex_state = 209, .external_lex_state = 13},
  [1503] = {.lex_state = 238},
  [1504] = {.lex_state = 236, .external_lex_state = 16},
  [1505] = {.lex_state = 209, .external_lex_state = 13},
  [1506] = {.lex_state = 238},
  [1507] = {.lex_state = 236, .external_lex_state = 16},
  [1508] = {.lex_state = 209, .external_lex_state = 13},
  [1509] = {.lex_state = 218, .external_lex_state = 2},
  [1510] = {.lex_state = 137, .external_lex_state = 4},
  [1511] = {.lex_state = 141, .external_lex_state = 8},
  [1512] = {.lex_state = 63, .external_lex_state = 2},
  [1513] = {.lex_state = 90, .external_lex_state = 4},
  [1514] = {.lex_state = 122, .external_lex_state = 8},
  [1515] = {.lex_state = 209, .external_lex_state = 13},
  [1516] = {.lex_state = 218, .external_lex_state = 2},
  [1517] = {.lex_state = 137, .external_lex_state = 4},
  [1518] = {.lex_state = 141, .external_lex_state = 8},
  [1519] = {.lex_state = 141, .external_lex_state = 19},
  [1520] = {.lex_state = 141, .external_lex_state = 19},
  [1521] = {.lex_state = 213, .external_lex_state = 22},
  [1522] = {.lex_state = 213, .external_lex_state = 22},
  [1523] = {.lex_state = 213, .external_lex_state = 16},
  [1524] = {.lex_state = 234, .external_lex_state = 16},
  [1525] = {.lex_state = 141, .external_lex_state = 19},
  [1526] = {.lex_state = 238},
  [1527] = {.lex_state = 236, .external_lex_state = 16},
  [1528] = {.lex_state = 141, .external_lex_state = 19},
  [1529] = {.lex_state = 238},
  [1530] = {.lex_state = 236, .external_lex_state = 16},
  [1531] = {.lex_state = 238},
  [1532] = {.lex_state = 236, .external_lex_state = 16},
  [1533] = {.lex_state = 236, .external_lex_state = 16},
  [1534] = {.lex_state = 141, .external_lex_state = 19},
  [1535] = {.lex_state = 236, .external_lex_state = 16},
  [1536] = {.lex_state = 141, .external_lex_state = 19},
  [1537] = {.lex_state = 236, .external_lex_state = 16},
  [1538] = {.lex_state = 141, .external_lex_state = 19},
  [1539] = {.lex_state = 218, .external_lex_state = 2},
  [1540] = {.lex_state = 63, .external_lex_state = 2},
  [1541] = {.lex_state = 141, .external_lex_state = 19},
  [1542] = {.lex_state = 218, .external_lex_state = 2},
  [1543] = {.lex_state = 213, .external_lex_state = 20},
  [1544] = {.lex_state = 143, .external_lex_state = 4},
  [1545] = {.lex_state = 211},
  [1546] = {.lex_state = 272},
  [1547] = {.lex_state = 80},
  [1548] = {.lex_state = 272, .external_lex_state = 13},
  [1549] = {.lex_state = 272, .external_lex_state = 13},
  [1550] = {.lex_state = 166},
  [1551] = {.lex_state = 97},
  [1552] = {.lex_state = 272, .external_lex_state = 13},
  [1553] = {.lex_state = 272, .external_lex_state = 13},
  [1554] = {.lex_state = 272, .external_lex_state = 13},
  [1555] = {.lex_state = 69},
  [1556] = {.lex_state = 172, .external_lex_state = 6},
  [1557] = {.lex_state = 174, .external_lex_state = 16},
  [1558] = {.lex_state = 174, .external_lex_state = 16},
  [1559] = {.lex_state = 174, .external_lex_state = 16},
  [1560] = {.lex_state = 137, .external_lex_state = 4},
  [1561] = {.lex_state = 141, .external_lex_state = 8},
  [1562] = {.lex_state = 63, .external_lex_state = 2},
  [1563] = {.lex_state = 90, .external_lex_state = 4},
  [1564] = {.lex_state = 122, .external_lex_state = 8},
  [1565] = {.lex_state = 63, .external_lex_state = 2},
  [1566] = {.lex_state = 137, .external_lex_state = 4},
  [1567] = {.lex_state = 141, .external_lex_state = 8},
  [1568] = {.lex_state = 63, .external_lex_state = 2},
  [1569] = {.lex_state = 270},
  [1570] = {.lex_state = 84},
  [1571] = {.lex_state = 224},
  [1572] = {.lex_state = 272},
  [1573] = {.lex_state = 253, .external_lex_state = 10},
  [1574] = {.lex_state = 253, .external_lex_state = 10},
  [1575] = {.lex_state = 213, .external_lex_state = 22},
  [1576] = {.lex_state = 213, .external_lex_state = 22},
  [1577] = {.lex_state = 213, .external_lex_state = 16},
  [1578] = {.lex_state = 234, .external_lex_state = 16},
  [1579] = {.lex_state = 253, .external_lex_state = 10},
  [1580] = {.lex_state = 238},
  [1581] = {.lex_state = 236, .external_lex_state = 16},
  [1582] = {.lex_state = 253, .external_lex_state = 10},
  [1583] = {.lex_state = 238},
  [1584] = {.lex_state = 236, .external_lex_state = 16},
  [1585] = {.lex_state = 238},
  [1586] = {.lex_state = 236, .external_lex_state = 16},
  [1587] = {.lex_state = 236, .external_lex_state = 16},
  [1588] = {.lex_state = 253, .external_lex_state = 10},
  [1589] = {.lex_state = 236, .external_lex_state = 16},
  [1590] = {.lex_state = 253, .external_lex_state = 10},
  [1591] = {.lex_state = 236, .external_lex_state = 16},
  [1592] = {.lex_state = 253, .external_lex_state = 10},
  [1593] = {.lex_state = 218, .external_lex_state = 2},
  [1594] = {.lex_state = 63, .external_lex_state = 2},
  [1595] = {.lex_state = 253, .external_lex_state = 10},
  [1596] = {.lex_state = 218, .external_lex_state = 2},
  [1597] = {.lex_state = 249},
  [1598] = {.lex_state = 255, .external_lex_state = 10},
  [1599] = {.lex_state = 255, .external_lex_state = 10},
  [1600] = {.lex_state = 255, .external_lex_state = 10},
  [1601] = {.lex_state = 166},
  [1602] = {.lex_state = 234, .external_lex_state = 16},
  [1603] = {.lex_state = 69},
  [1604] = {.lex_state = 174, .external_lex_state = 16},
  [1605] = {.lex_state = 174, .external_lex_state = 16},
  [1606] = {.lex_state = 174, .external_lex_state = 16},
  [1607] = {.lex_state = 255, .external_lex_state = 10},
  [1608] = {.lex_state = 238},
  [1609] = {.lex_state = 236, .external_lex_state = 16},
  [1610] = {.lex_state = 255, .external_lex_state = 10},
  [1611] = {.lex_state = 238},
  [1612] = {.lex_state = 236, .external_lex_state = 16},
  [1613] = {.lex_state = 255, .external_lex_state = 10},
  [1614] = {.lex_state = 238},
  [1615] = {.lex_state = 236, .external_lex_state = 16},
  [1616] = {.lex_state = 255, .external_lex_state = 10},
  [1617] = {.lex_state = 218, .external_lex_state = 2},
  [1618] = {.lex_state = 137, .external_lex_state = 4},
  [1619] = {.lex_state = 141, .external_lex_state = 8},
  [1620] = {.lex_state = 63, .external_lex_state = 2},
  [1621] = {.lex_state = 90, .external_lex_state = 4},
  [1622] = {.lex_state = 122, .external_lex_state = 8},
  [1623] = {.lex_state = 255, .external_lex_state = 10},
  [1624] = {.lex_state = 218, .external_lex_state = 2},
  [1625] = {.lex_state = 137, .external_lex_state = 4},
  [1626] = {.lex_state = 141, .external_lex_state = 8},
  [1627] = {.lex_state = 143, .external_lex_state = 4},
  [1628] = {.lex_state = 143, .external_lex_state = 4},
  [1629] = {.lex_state = 122, .external_lex_state = 19},
  [1630] = {.lex_state = 215, .external_lex_state = 21},
  [1631] = {.lex_state = 80},
  [1632] = {.lex_state = 120, .external_lex_state = 10},
  [1633] = {.lex_state = 120, .external_lex_state = 10},
  [1634] = {.lex_state = 80},
  [1635] = {.lex_state = 203, .external_lex_state = 23},
  [1636] = {.lex_state = 203, .external_lex_state = 23},
  [1637] = {.lex_state = 203, .external_lex_state = 23},
  [1638] = {.lex_state = 203, .external_lex_state = 23},
  [1639] = {.lex_state = 203, .external_lex_state = 21},
  [1640] = {.lex_state = 203, .external_lex_state = 5},
  [1641] = {.lex_state = 63, .external_lex_state = 2},
  [1642] = {.lex_state = 63, .external_lex_state = 2},
  [1643] = {.lex_state = 143, .external_lex_state = 4},
  [1644] = {.lex_state = 80},
  [1645] = {.lex_state = 80},
  [1646] = {.lex_state = 279, .external_lex_state = 2},
  [1647] = {.lex_state = 274},
  [1648] = {.lex_state = 274, .external_lex_state = 13},
  [1649] = {.lex_state = 279, .external_lex_state = 2},
  [1650] = {.lex_state = 274},
  [1651] = {.lex_state = 143, .external_lex_state = 4},
  [1652] = {.lex_state = 277},
  [1653] = {.lex_state = 80},
  [1654] = {.lex_state = 143, .external_lex_state = 4},
  [1655] = {.lex_state = 80},
  [1656] = {.lex_state = 143, .external_lex_state = 4},
  [1657] = {.lex_state = 277},
  [1658] = {.lex_state = 143, .external_lex_state = 4},
  [1659] = {.lex_state = 80},
  [1660] = {.lex_state = 131, .external_lex_state = 10},
  [1661] = {.lex_state = 131, .external_lex_state = 10},
  [1662] = {.lex_state = 213, .external_lex_state = 22},
  [1663] = {.lex_state = 213, .external_lex_state = 22},
  [1664] = {.lex_state = 213, .external_lex_state = 16},
  [1665] = {.lex_state = 236, .external_lex_state = 16},
  [1666] = {.lex_state = 131, .external_lex_state = 10},
  [1667] = {.lex_state = 236, .external_lex_state = 16},
  [1668] = {.lex_state = 131, .external_lex_state = 10},
  [1669] = {.lex_state = 236, .external_lex_state = 16},
  [1670] = {.lex_state = 131, .external_lex_state = 10},
  [1671] = {.lex_state = 236, .external_lex_state = 16},
  [1672] = {.lex_state = 131, .external_lex_state = 10},
  [1673] = {.lex_state = 236, .external_lex_state = 16},
  [1674] = {.lex_state = 131, .external_lex_state = 10},
  [1675] = {.lex_state = 236, .external_lex_state = 16},
  [1676] = {.lex_state = 131, .external_lex_state = 10},
  [1677] = {.lex_state = 131, .external_lex_state = 10},
  [1678] = {.lex_state = 143, .external_lex_state = 4},
  [1679] = {.lex_state = 120, .external_lex_state = 10},
  [1680] = {.lex_state = 120, .external_lex_state = 10},
  [1681] = {.lex_state = 143, .external_lex_state = 4},
  [1682] = {.lex_state = 120, .external_lex_state = 10},
  [1683] = {.lex_state = 141, .external_lex_state = 19},
  [1684] = {.lex_state = 261, .external_lex_state = 21},
  [1685] = {.lex_state = 80},
  [1686] = {.lex_state = 281, .external_lex_state = 10},
  [1687] = {.lex_state = 281, .external_lex_state = 10},
  [1688] = {.lex_state = 80},
  [1689] = {.lex_state = 220, .external_lex_state = 23},
  [1690] = {.lex_state = 220, .external_lex_state = 23},
  [1691] = {.lex_state = 220, .external_lex_state = 23},
  [1692] = {.lex_state = 220, .external_lex_state = 23},
  [1693] = {.lex_state = 220, .external_lex_state = 21},
  [1694] = {.lex_state = 220, .external_lex_state = 5},
  [1695] = {.lex_state = 80, .external_lex_state = 2},
  [1696] = {.lex_state = 149, .external_lex_state = 11},
  [1697] = {.lex_state = 149, .external_lex_state = 11},
  [1698] = {.lex_state = 213, .external_lex_state = 22},
  [1699] = {.lex_state = 213, .external_lex_state = 22},
  [1700] = {.lex_state = 213, .external_lex_state = 16},
  [1701] = {.lex_state = 236, .external_lex_state = 16},
  [1702] = {.lex_state = 149, .external_lex_state = 11},
  [1703] = {.lex_state = 236, .external_lex_state = 16},
  [1704] = {.lex_state = 149, .external_lex_state = 11},
  [1705] = {.lex_state = 236, .external_lex_state = 16},
  [1706] = {.lex_state = 149, .external_lex_state = 11},
  [1707] = {.lex_state = 236, .external_lex_state = 16},
  [1708] = {.lex_state = 149, .external_lex_state = 11},
  [1709] = {.lex_state = 236, .external_lex_state = 16},
  [1710] = {.lex_state = 149, .external_lex_state = 11},
  [1711] = {.lex_state = 236, .external_lex_state = 16},
  [1712] = {.lex_state = 149, .external_lex_state = 11},
  [1713] = {.lex_state = 149, .external_lex_state = 11},
  [1714] = {.lex_state = 203, .external_lex_state = 23},
  [1715] = {.lex_state = 203, .external_lex_state = 23},
  [1716] = {.lex_state = 247, .external_lex_state = 21},
  [1717] = {.lex_state = 80},
  [1718] = {.lex_state = 203, .external_lex_state = 23},
  [1719] = {.lex_state = 247, .external_lex_state = 23},
  [1720] = {.lex_state = 166},
  [1721] = {.lex_state = 97},
  [1722] = {.lex_state = 247, .external_lex_state = 23},
  [1723] = {.lex_state = 247, .external_lex_state = 23},
  [1724] = {.lex_state = 247, .external_lex_state = 23},
  [1725] = {.lex_state = 69},
  [1726] = {.lex_state = 172, .external_lex_state = 6},
  [1727] = {.lex_state = 174, .external_lex_state = 16},
  [1728] = {.lex_state = 174, .external_lex_state = 16},
  [1729] = {.lex_state = 174, .external_lex_state = 16},
  [1730] = {.lex_state = 137, .external_lex_state = 4},
  [1731] = {.lex_state = 141, .external_lex_state = 8},
  [1732] = {.lex_state = 63, .external_lex_state = 2},
  [1733] = {.lex_state = 90, .external_lex_state = 4},
  [1734] = {.lex_state = 122, .external_lex_state = 8},
  [1735] = {.lex_state = 63, .external_lex_state = 2},
  [1736] = {.lex_state = 137, .external_lex_state = 4},
  [1737] = {.lex_state = 141, .external_lex_state = 8},
  [1738] = {.lex_state = 63, .external_lex_state = 2},
  [1739] = {.lex_state = 231, .external_lex_state = 13},
  [1740] = {.lex_state = 231, .external_lex_state = 13},
  [1741] = {.lex_state = 213, .external_lex_state = 22},
  [1742] = {.lex_state = 213, .external_lex_state = 22},
  [1743] = {.lex_state = 213, .external_lex_state = 16},
  [1744] = {.lex_state = 236, .external_lex_state = 16},
  [1745] = {.lex_state = 231, .external_lex_state = 13},
  [1746] = {.lex_state = 236, .external_lex_state = 16},
  [1747] = {.lex_state = 231, .external_lex_state = 13},
  [1748] = {.lex_state = 236, .external_lex_state = 16},
  [1749] = {.lex_state = 231, .external_lex_state = 13},
  [1750] = {.lex_state = 236, .external_lex_state = 16},
  [1751] = {.lex_state = 231, .external_lex_state = 13},
  [1752] = {.lex_state = 236, .external_lex_state = 16},
  [1753] = {.lex_state = 231, .external_lex_state = 13},
  [1754] = {.lex_state = 236, .external_lex_state = 16},
  [1755] = {.lex_state = 231, .external_lex_state = 13},
  [1756] = {.lex_state = 231, .external_lex_state = 13},
  [1757] = {.lex_state = 137, .external_lex_state = 3},
  [1758] = {.lex_state = 137, .external_lex_state = 14},
  [1759] = {.lex_state = 137, .external_lex_state = 14},
  [1760] = {.lex_state = 213, .external_lex_state = 22},
  [1761] = {.lex_state = 213, .external_lex_state = 22},
  [1762] = {.lex_state = 213, .external_lex_state = 16},
  [1763] = {.lex_state = 236, .external_lex_state = 16},
  [1764] = {.lex_state = 137, .external_lex_state = 14},
  [1765] = {.lex_state = 236, .external_lex_state = 16},
  [1766] = {.lex_state = 137, .external_lex_state = 14},
  [1767] = {.lex_state = 236, .external_lex_state = 16},
  [1768] = {.lex_state = 137, .external_lex_state = 14},
  [1769] = {.lex_state = 236, .external_lex_state = 16},
  [1770] = {.lex_state = 137, .external_lex_state = 14},
  [1771] = {.lex_state = 236, .external_lex_state = 16},
  [1772] = {.lex_state = 137, .external_lex_state = 14},
  [1773] = {.lex_state = 236, .external_lex_state = 16},
  [1774] = {.lex_state = 137, .external_lex_state = 14},
  [1775] = {.lex_state = 137, .external_lex_state = 14},
  [1776] = {.lex_state = 137, .external_lex_state = 10},
  [1777] = {.lex_state = 137, .external_lex_state = 10},
  [1778] = {.lex_state = 213, .external_lex_state = 22},
  [1779] = {.lex_state = 213, .external_lex_state = 22},
  [1780] = {.lex_state = 213, .external_lex_state = 16},
  [1781] = {.lex_state = 236, .external_lex_state = 16},
  [1782] = {.lex_state = 137, .external_lex_state = 10},
  [1783] = {.lex_state = 236, .external_lex_state = 16},
  [1784] = {.lex_state = 137, .external_lex_state = 10},
  [1785] = {.lex_state = 236, .external_lex_state = 16},
  [1786] = {.lex_state = 137, .external_lex_state = 10},
  [1787] = {.lex_state = 236, .external_lex_state = 16},
  [1788] = {.lex_state = 137, .external_lex_state = 10},
  [1789] = {.lex_state = 236, .external_lex_state = 16},
  [1790] = {.lex_state = 137, .external_lex_state = 10},
  [1791] = {.lex_state = 236, .external_lex_state = 16},
  [1792] = {.lex_state = 137, .external_lex_state = 10},
  [1793] = {.lex_state = 137, .external_lex_state = 10},
  [1794] = {.lex_state = 80, .external_lex_state = 15},
  [1795] = {.lex_state = 80, .external_lex_state = 15},
  [1796] = {.lex_state = 213, .external_lex_state = 22},
  [1797] = {.lex_state = 213, .external_lex_state = 22},
  [1798] = {.lex_state = 213, .external_lex_state = 16},
  [1799] = {.lex_state = 236, .external_lex_state = 16},
  [1800] = {.lex_state = 80, .external_lex_state = 15},
  [1801] = {.lex_state = 236, .external_lex_state = 16},
  [1802] = {.lex_state = 80, .external_lex_state = 15},
  [1803] = {.lex_state = 236, .external_lex_state = 16},
  [1804] = {.lex_state = 80, .external_lex_state = 15},
  [1805] = {.lex_state = 236, .external_lex_state = 16},
  [1806] = {.lex_state = 80, .external_lex_state = 15},
  [1807] = {.lex_state = 236, .external_lex_state = 16},
  [1808] = {.lex_state = 80, .external_lex_state = 15},
  [1809] = {.lex_state = 236, .external_lex_state = 16},
  [1810] = {.lex_state = 80, .external_lex_state = 15},
  [1811] = {.lex_state = 80, .external_lex_state = 15},
  [1812] = {.lex_state = 97, .external_lex_state = 13},
  [1813] = {.lex_state = 97, .external_lex_state = 13},
  [1814] = {.lex_state = 213, .external_lex_state = 22},
  [1815] = {.lex_state = 213, .external_lex_state = 22},
  [1816] = {.lex_state = 213, .external_lex_state = 16},
  [1817] = {.lex_state = 236, .external_lex_state = 16},
  [1818] = {.lex_state = 97, .external_lex_state = 13},
  [1819] = {.lex_state = 236, .external_lex_state = 16},
  [1820] = {.lex_state = 97, .external_lex_state = 13},
  [1821] = {.lex_state = 236, .external_lex_state = 16},
  [1822] = {.lex_state = 97, .external_lex_state = 13},
  [1823] = {.lex_state = 236, .external_lex_state = 16},
  [1824] = {.lex_state = 97, .external_lex_state = 13},
  [1825] = {.lex_state = 236, .external_lex_state = 16},
  [1826] = {.lex_state = 97, .external_lex_state = 13},
  [1827] = {.lex_state = 236, .external_lex_state = 16},
  [1828] = {.lex_state = 97, .external_lex_state = 13},
  [1829] = {.lex_state = 174, .external_lex_state = 22},
  [1830] = {.lex_state = 174, .external_lex_state = 16},
  [1831] = {.lex_state = 174, .external_lex_state = 22},
  [1832] = {.lex_state = 174, .external_lex_state = 16},
  [1833] = {.lex_state = 213, .external_lex_state = 22},
  [1834] = {.lex_state = 213, .external_lex_state = 22},
  [1835] = {.lex_state = 213, .external_lex_state = 22},
  [1836] = {.lex_state = 166},
  [1837] = {.lex_state = 234, .external_lex_state = 16},
  [1838] = {.lex_state = 69},
  [1839] = {.lex_state = 174, .external_lex_state = 16},
  [1840] = {.lex_state = 174, .external_lex_state = 16},
  [1841] = {.lex_state = 174, .external_lex_state = 16},
  [1842] = {.lex_state = 213, .external_lex_state = 22},
  [1843] = {.lex_state = 238},
  [1844] = {.lex_state = 236, .external_lex_state = 16},
  [1845] = {.lex_state = 213, .external_lex_state = 22},
  [1846] = {.lex_state = 238},
  [1847] = {.lex_state = 236, .external_lex_state = 16},
  [1848] = {.lex_state = 213, .external_lex_state = 22},
  [1849] = {.lex_state = 238},
  [1850] = {.lex_state = 236, .external_lex_state = 16},
  [1851] = {.lex_state = 213, .external_lex_state = 22},
  [1852] = {.lex_state = 218, .external_lex_state = 2},
  [1853] = {.lex_state = 137, .external_lex_state = 4},
  [1854] = {.lex_state = 141, .external_lex_state = 8},
  [1855] = {.lex_state = 63, .external_lex_state = 2},
  [1856] = {.lex_state = 90, .external_lex_state = 4},
  [1857] = {.lex_state = 122, .external_lex_state = 8},
  [1858] = {.lex_state = 213, .external_lex_state = 22},
  [1859] = {.lex_state = 218, .external_lex_state = 2},
  [1860] = {.lex_state = 137, .external_lex_state = 4},
  [1861] = {.lex_state = 141, .external_lex_state = 8},
  [1862] = {.lex_state = 124, .external_lex_state = 5},
  [1863] = {.lex_state = 124, .external_lex_state = 5},
  [1864] = {.lex_state = 124, .external_lex_state = 5},
  [1865] = {.lex_state = 236, .external_lex_state = 16},
  [1866] = {.lex_state = 124, .external_lex_state = 5},
  [1867] = {.lex_state = 236, .external_lex_state = 16},
  [1868] = {.lex_state = 124, .external_lex_state = 5},
  [1869] = {.lex_state = 236, .external_lex_state = 16},
  [1870] = {.lex_state = 236, .external_lex_state = 22},
  [1871] = {.lex_state = 236, .external_lex_state = 22},
  [1872] = {.lex_state = 213, .external_lex_state = 22},
  [1873] = {.lex_state = 213, .external_lex_state = 22},
  [1874] = {.lex_state = 213, .external_lex_state = 16},
  [1875] = {.lex_state = 234, .external_lex_state = 16},
  [1876] = {.lex_state = 236, .external_lex_state = 22},
  [1877] = {.lex_state = 238},
  [1878] = {.lex_state = 236, .external_lex_state = 16},
  [1879] = {.lex_state = 236, .external_lex_state = 22},
  [1880] = {.lex_state = 238},
  [1881] = {.lex_state = 236, .external_lex_state = 16},
  [1882] = {.lex_state = 238},
  [1883] = {.lex_state = 236, .external_lex_state = 16},
  [1884] = {.lex_state = 236, .external_lex_state = 16},
  [1885] = {.lex_state = 236, .external_lex_state = 22},
  [1886] = {.lex_state = 236, .external_lex_state = 16},
  [1887] = {.lex_state = 236, .external_lex_state = 22},
  [1888] = {.lex_state = 236, .external_lex_state = 16},
  [1889] = {.lex_state = 124, .external_lex_state = 5},
  [1890] = {.lex_state = 236, .external_lex_state = 22},
  [1891] = {.lex_state = 218, .external_lex_state = 2},
  [1892] = {.lex_state = 63, .external_lex_state = 2},
  [1893] = {.lex_state = 236, .external_lex_state = 22},
  [1894] = {.lex_state = 218, .external_lex_state = 2},
  [1895] = {.lex_state = 124, .external_lex_state = 5},
  [1896] = {.lex_state = 124, .external_lex_state = 5},
  [1897] = {.lex_state = 265, .external_lex_state = 21},
  [1898] = {.lex_state = 80},
  [1899] = {.lex_state = 143, .external_lex_state = 10},
  [1900] = {.lex_state = 143, .external_lex_state = 10},
  [1901] = {.lex_state = 80},
  [1902] = {.lex_state = 245, .external_lex_state = 23},
  [1903] = {.lex_state = 245, .external_lex_state = 23},
  [1904] = {.lex_state = 245, .external_lex_state = 23},
  [1905] = {.lex_state = 245, .external_lex_state = 23},
  [1906] = {.lex_state = 245, .external_lex_state = 21},
  [1907] = {.lex_state = 245, .external_lex_state = 5},
  [1908] = {.lex_state = 177, .external_lex_state = 17},
  [1909] = {.lex_state = 213, .external_lex_state = 22},
  [1910] = {.lex_state = 213, .external_lex_state = 22},
  [1911] = {.lex_state = 213, .external_lex_state = 16},
  [1912] = {.lex_state = 234, .external_lex_state = 16},
  [1913] = {.lex_state = 177, .external_lex_state = 17},
  [1914] = {.lex_state = 238},
  [1915] = {.lex_state = 236, .external_lex_state = 16},
  [1916] = {.lex_state = 177, .external_lex_state = 17},
  [1917] = {.lex_state = 238},
  [1918] = {.lex_state = 236, .external_lex_state = 16},
  [1919] = {.lex_state = 238},
  [1920] = {.lex_state = 236, .external_lex_state = 16},
  [1921] = {.lex_state = 236, .external_lex_state = 16},
  [1922] = {.lex_state = 177, .external_lex_state = 17},
  [1923] = {.lex_state = 236, .external_lex_state = 16},
  [1924] = {.lex_state = 177, .external_lex_state = 17},
  [1925] = {.lex_state = 236, .external_lex_state = 16},
  [1926] = {.lex_state = 209, .external_lex_state = 13},
  [1927] = {.lex_state = 209, .external_lex_state = 13},
  [1928] = {.lex_state = 213, .external_lex_state = 22},
  [1929] = {.lex_state = 213, .external_lex_state = 22},
  [1930] = {.lex_state = 213, .external_lex_state = 16},
  [1931] = {.lex_state = 234, .external_lex_state = 16},
  [1932] = {.lex_state = 209, .external_lex_state = 13},
  [1933] = {.lex_state = 238},
  [1934] = {.lex_state = 236, .external_lex_state = 16},
  [1935] = {.lex_state = 209, .external_lex_state = 13},
  [1936] = {.lex_state = 238},
  [1937] = {.lex_state = 236, .external_lex_state = 16},
  [1938] = {.lex_state = 238},
  [1939] = {.lex_state = 236, .external_lex_state = 16},
  [1940] = {.lex_state = 236, .external_lex_state = 16},
  [1941] = {.lex_state = 209, .external_lex_state = 13},
  [1942] = {.lex_state = 236, .external_lex_state = 16},
  [1943] = {.lex_state = 209, .external_lex_state = 13},
  [1944] = {.lex_state = 236, .external_lex_state = 16},
  [1945] = {.lex_state = 209, .external_lex_state = 13},
  [1946] = {.lex_state = 218, .external_lex_state = 2},
  [1947] = {.lex_state = 63, .external_lex_state = 2},
  [1948] = {.lex_state = 209, .external_lex_state = 13},
  [1949] = {.lex_state = 218, .external_lex_state = 2},
  [1950] = {.lex_state = 141, .external_lex_state = 19},
  [1951] = {.lex_state = 141, .external_lex_state = 19},
  [1952] = {.lex_state = 213, .external_lex_state = 22},
  [1953] = {.lex_state = 213, .external_lex_state = 22},
  [1954] = {.lex_state = 213, .external_lex_state = 16},
  [1955] = {.lex_state = 236, .external_lex_state = 16},
  [1956] = {.lex_state = 141, .external_lex_state = 19},
  [1957] = {.lex_state = 236, .external_lex_state = 16},
  [1958] = {.lex_state = 141, .external_lex_state = 19},
  [1959] = {.lex_state = 236, .external_lex_state = 16},
  [1960] = {.lex_state = 141, .external_lex_state = 19},
  [1961] = {.lex_state = 236, .external_lex_state = 16},
  [1962] = {.lex_state = 141, .external_lex_state = 19},
  [1963] = {.lex_state = 236, .external_lex_state = 16},
  [1964] = {.lex_state = 141, .external_lex_state = 19},
  [1965] = {.lex_state = 236, .external_lex_state = 16},
  [1966] = {.lex_state = 141, .external_lex_state = 19},
  [1967] = {.lex_state = 141, .external_lex_state = 19},
  [1968] = {.lex_state = 143, .external_lex_state = 4},
  [1969] = {.lex_state = 213, .external_lex_state = 20},
  [1970] = {.lex_state = 272},
  [1971] = {.lex_state = 272, .external_lex_state = 13},
  [1972] = {.lex_state = 272, .external_lex_state = 13},
  [1973] = {.lex_state = 272, .external_lex_state = 13},
  [1974] = {.lex_state = 166},
  [1975] = {.lex_state = 234, .external_lex_state = 16},
  [1976] = {.lex_state = 69},
  [1977] = {.lex_state = 174, .external_lex_state = 16},
  [1978] = {.lex_state = 174, .external_lex_state = 16},
  [1979] = {.lex_state = 174, .external_lex_state = 16},
  [1980] = {.lex_state = 272, .external_lex_state = 13},
  [1981] = {.lex_state = 238},
  [1982] = {.lex_state = 236, .external_lex_state = 16},
  [1983] = {.lex_state = 272, .external_lex_state = 13},
  [1984] = {.lex_state = 238},
  [1985] = {.lex_state = 236, .external_lex_state = 16},
  [1986] = {.lex_state = 272, .external_lex_state = 13},
  [1987] = {.lex_state = 238},
  [1988] = {.lex_state = 236, .external_lex_state = 16},
  [1989] = {.lex_state = 272, .external_lex_state = 13},
  [1990] = {.lex_state = 218, .external_lex_state = 2},
  [1991] = {.lex_state = 137, .external_lex_state = 4},
  [1992] = {.lex_state = 141, .external_lex_state = 8},
  [1993] = {.lex_state = 63, .external_lex_state = 2},
  [1994] = {.lex_state = 90, .external_lex_state = 4},
  [1995] = {.lex_state = 122, .external_lex_state = 8},
  [1996] = {.lex_state = 272, .external_lex_state = 13},
  [1997] = {.lex_state = 218, .external_lex_state = 2},
  [1998] = {.lex_state = 137, .external_lex_state = 4},
  [1999] = {.lex_state = 141, .external_lex_state = 8},
  [2000] = {.lex_state = 143, .external_lex_state = 4},
  [2001] = {.lex_state = 272},
  [2002] = {.lex_state = 272},
  [2003] = {.lex_state = 270},
  [2004] = {.lex_state = 253, .external_lex_state = 10},
  [2005] = {.lex_state = 253, .external_lex_state = 10},
  [2006] = {.lex_state = 213, .external_lex_state = 22},
  [2007] = {.lex_state = 213, .external_lex_state = 22},
  [2008] = {.lex_state = 213, .external_lex_state = 16},
  [2009] = {.lex_state = 236, .external_lex_state = 16},
  [2010] = {.lex_state = 253, .external_lex_state = 10},
  [2011] = {.lex_state = 236, .external_lex_state = 16},
  [2012] = {.lex_state = 253, .external_lex_state = 10},
  [2013] = {.lex_state = 236, .external_lex_state = 16},
  [2014] = {.lex_state = 253, .external_lex_state = 10},
  [2015] = {.lex_state = 236, .external_lex_state = 16},
  [2016] = {.lex_state = 253, .external_lex_state = 10},
  [2017] = {.lex_state = 236, .external_lex_state = 16},
  [2018] = {.lex_state = 253, .external_lex_state = 10},
  [2019] = {.lex_state = 236, .external_lex_state = 16},
  [2020] = {.lex_state = 253, .external_lex_state = 10},
  [2021] = {.lex_state = 253, .external_lex_state = 10},
  [2022] = {.lex_state = 272},
  [2023] = {.lex_state = 255, .external_lex_state = 10},
  [2024] = {.lex_state = 255, .external_lex_state = 10},
  [2025] = {.lex_state = 213, .external_lex_state = 22},
  [2026] = {.lex_state = 213, .external_lex_state = 22},
  [2027] = {.lex_state = 213, .external_lex_state = 16},
  [2028] = {.lex_state = 234, .external_lex_state = 16},
  [2029] = {.lex_state = 255, .external_lex_state = 10},
  [2030] = {.lex_state = 238},
  [2031] = {.lex_state = 236, .external_lex_state = 16},
  [2032] = {.lex_state = 255, .external_lex_state = 10},
  [2033] = {.lex_state = 238},
  [2034] = {.lex_state = 236, .external_lex_state = 16},
  [2035] = {.lex_state = 238},
  [2036] = {.lex_state = 236, .external_lex_state = 16},
  [2037] = {.lex_state = 236, .external_lex_state = 16},
  [2038] = {.lex_state = 255, .external_lex_state = 10},
  [2039] = {.lex_state = 236, .external_lex_state = 16},
  [2040] = {.lex_state = 255, .external_lex_state = 10},
  [2041] = {.lex_state = 236, .external_lex_state = 16},
  [2042] = {.lex_state = 255, .external_lex_state = 10},
  [2043] = {.lex_state = 218, .external_lex_state = 2},
  [2044] = {.lex_state = 63, .external_lex_state = 2},
  [2045] = {.lex_state = 255, .external_lex_state = 10},
  [2046] = {.lex_state = 218, .external_lex_state = 2},
  [2047] = {.lex_state = 120, .external_lex_state = 10},
  [2048] = {.lex_state = 120, .external_lex_state = 10},
  [2049] = {.lex_state = 120, .external_lex_state = 10},
  [2050] = {.lex_state = 203, .external_lex_state = 23},
  [2051] = {.lex_state = 203, .external_lex_state = 23},
  [2052] = {.lex_state = 203, .external_lex_state = 23},
  [2053] = {.lex_state = 63, .external_lex_state = 2},
  [2054] = {.lex_state = 143, .external_lex_state = 4},
  [2055] = {.lex_state = 274, .external_lex_state = 13},
  [2056] = {.lex_state = 274, .external_lex_state = 13},
  [2057] = {.lex_state = 274},
  [2058] = {.lex_state = 69},
  [2059] = {.lex_state = 63, .external_lex_state = 2},
  [2060] = {.lex_state = 257},
  [2061] = {.lex_state = 80},
  [2062] = {.lex_state = 82, .external_lex_state = 2},
  [2063] = {.lex_state = 84},
  [2064] = {.lex_state = 84},
  [2065] = {.lex_state = 283, .external_lex_state = 3},
  [2066] = {.lex_state = 283, .external_lex_state = 4},
  [2067] = {.lex_state = 289, .external_lex_state = 5},
  [2068] = {.lex_state = 97},
  [2069] = {.lex_state = 104},
  [2070] = {.lex_state = 289, .external_lex_state = 5},
  [2071] = {.lex_state = 113, .external_lex_state = 6},
  [2072] = {.lex_state = 63, .external_lex_state = 2},
  [2073] = {.lex_state = 63, .external_lex_state = 2},
  [2074] = {.lex_state = 63, .external_lex_state = 2},
  [2075] = {.lex_state = 291, .external_lex_state = 5},
  [2076] = {.lex_state = 277, .external_lex_state = 4},
  [2077] = {.lex_state = 289, .external_lex_state = 7},
  [2078] = {.lex_state = 293, .external_lex_state = 8},
  [2079] = {.lex_state = 69},
  [2080] = {.lex_state = 289, .external_lex_state = 7},
  [2081] = {.lex_state = 279, .external_lex_state = 2},
  [2082] = {.lex_state = 80, .external_lex_state = 2},
  [2083] = {.lex_state = 279, .external_lex_state = 2},
  [2084] = {.lex_state = 274},
  [2085] = {.lex_state = 274, .external_lex_state = 13},
  [2086] = {.lex_state = 257},
  [2087] = {.lex_state = 277, .external_lex_state = 4},
  [2088] = {.lex_state = 293, .external_lex_state = 8},
  [2089] = {.lex_state = 279, .external_lex_state = 2},
  [2090] = {.lex_state = 279, .external_lex_state = 2},
  [2091] = {.lex_state = 143, .external_lex_state = 4},
  [2092] = {.lex_state = 274, .external_lex_state = 13},
  [2093] = {.lex_state = 274, .external_lex_state = 13},
  [2094] = {.lex_state = 274},
  [2095] = {.lex_state = 277},
  [2096] = {.lex_state = 143, .external_lex_state = 4},
  [2097] = {.lex_state = 277},
  [2098] = {.lex_state = 131, .external_lex_state = 10},
  [2099] = {.lex_state = 131, .external_lex_state = 10},
  [2100] = {.lex_state = 131, .external_lex_state = 10},
  [2101] = {.lex_state = 236, .external_lex_state = 16},
  [2102] = {.lex_state = 131, .external_lex_state = 10},
  [2103] = {.lex_state = 236, .external_lex_state = 16},
  [2104] = {.lex_state = 131, .external_lex_state = 10},
  [2105] = {.lex_state = 236, .external_lex_state = 16},
  [2106] = {.lex_state = 131, .external_lex_state = 10},
  [2107] = {.lex_state = 131, .external_lex_state = 10},
  [2108] = {.lex_state = 131, .external_lex_state = 10},
  [2109] = {.lex_state = 120, .external_lex_state = 10},
  [2110] = {.lex_state = 281, .external_lex_state = 10},
  [2111] = {.lex_state = 281, .external_lex_state = 10},
  [2112] = {.lex_state = 281, .external_lex_state = 10},
  [2113] = {.lex_state = 220, .external_lex_state = 23},
  [2114] = {.lex_state = 220, .external_lex_state = 23},
  [2115] = {.lex_state = 220, .external_lex_state = 23},
  [2116] = {.lex_state = 149, .external_lex_state = 11},
  [2117] = {.lex_state = 149, .external_lex_state = 11},
  [2118] = {.lex_state = 149, .external_lex_state = 11},
  [2119] = {.lex_state = 236, .external_lex_state = 16},
  [2120] = {.lex_state = 149, .external_lex_state = 11},
  [2121] = {.lex_state = 236, .external_lex_state = 16},
  [2122] = {.lex_state = 149, .external_lex_state = 11},
  [2123] = {.lex_state = 236, .external_lex_state = 16},
  [2124] = {.lex_state = 149, .external_lex_state = 11},
  [2125] = {.lex_state = 149, .external_lex_state = 11},
  [2126] = {.lex_state = 149, .external_lex_state = 11},
  [2127] = {.lex_state = 247, .external_lex_state = 23},
  [2128] = {.lex_state = 203, .external_lex_state = 23},
  [2129] = {.lex_state = 247, .external_lex_state = 23},
  [2130] = {.lex_state = 166},
  [2131] = {.lex_state = 234, .external_lex_state = 16},
  [2132] = {.lex_state = 69},
  [2133] = {.lex_state = 174, .external_lex_state = 16},
  [2134] = {.lex_state = 174, .external_lex_state = 16},
  [2135] = {.lex_state = 174, .external_lex_state = 16},
  [2136] = {.lex_state = 247, .external_lex_state = 23},
  [2137] = {.lex_state = 238},
  [2138] = {.lex_state = 236, .external_lex_state = 16},
  [2139] = {.lex_state = 247, .external_lex_state = 23},
  [2140] = {.lex_state = 238},
  [2141] = {.lex_state = 236, .external_lex_state = 16},
  [2142] = {.lex_state = 247, .external_lex_state = 23},
  [2143] = {.lex_state = 238},
  [2144] = {.lex_state = 236, .external_lex_state = 16},
  [2145] = {.lex_state = 247, .external_lex_state = 23},
  [2146] = {.lex_state = 218, .external_lex_state = 2},
  [2147] = {.lex_state = 137, .external_lex_state = 4},
  [2148] = {.lex_state = 141, .external_lex_state = 8},
  [2149] = {.lex_state = 63, .external_lex_state = 2},
  [2150] = {.lex_state = 90, .external_lex_state = 4},
  [2151] = {.lex_state = 122, .external_lex_state = 8},
  [2152] = {.lex_state = 247, .external_lex_state = 23},
  [2153] = {.lex_state = 218, .external_lex_state = 2},
  [2154] = {.lex_state = 137, .external_lex_state = 4},
  [2155] = {.lex_state = 141, .external_lex_state = 8},
  [2156] = {.lex_state = 231, .external_lex_state = 13},
  [2157] = {.lex_state = 231, .external_lex_state = 13},
  [2158] = {.lex_state = 231, .external_lex_state = 13},
  [2159] = {.lex_state = 236, .external_lex_state = 16},
  [2160] = {.lex_state = 231, .external_lex_state = 13},
  [2161] = {.lex_state = 236, .external_lex_state = 16},
  [2162] = {.lex_state = 231, .external_lex_state = 13},
  [2163] = {.lex_state = 236, .external_lex_state = 16},
  [2164] = {.lex_state = 231, .external_lex_state = 13},
  [2165] = {.lex_state = 231, .external_lex_state = 13},
  [2166] = {.lex_state = 231, .external_lex_state = 13},
  [2167] = {.lex_state = 137, .external_lex_state = 14},
  [2168] = {.lex_state = 137, .external_lex_state = 14},
  [2169] = {.lex_state = 137, .external_lex_state = 14},
  [2170] = {.lex_state = 236, .external_lex_state = 16},
  [2171] = {.lex_state = 137, .external_lex_state = 14},
  [2172] = {.lex_state = 236, .external_lex_state = 16},
  [2173] = {.lex_state = 137, .external_lex_state = 14},
  [2174] = {.lex_state = 236, .external_lex_state = 16},
  [2175] = {.lex_state = 137, .external_lex_state = 14},
  [2176] = {.lex_state = 137, .external_lex_state = 14},
  [2177] = {.lex_state = 137, .external_lex_state = 14},
  [2178] = {.lex_state = 137, .external_lex_state = 10},
  [2179] = {.lex_state = 137, .external_lex_state = 10},
  [2180] = {.lex_state = 137, .external_lex_state = 10},
  [2181] = {.lex_state = 236, .external_lex_state = 16},
  [2182] = {.lex_state = 137, .external_lex_state = 10},
  [2183] = {.lex_state = 236, .external_lex_state = 16},
  [2184] = {.lex_state = 137, .external_lex_state = 10},
  [2185] = {.lex_state = 236, .external_lex_state = 16},
  [2186] = {.lex_state = 137, .external_lex_state = 10},
  [2187] = {.lex_state = 137, .external_lex_state = 10},
  [2188] = {.lex_state = 137, .external_lex_state = 10},
  [2189] = {.lex_state = 80, .external_lex_state = 15},
  [2190] = {.lex_state = 80, .external_lex_state = 15},
  [2191] = {.lex_state = 80, .external_lex_state = 15},
  [2192] = {.lex_state = 236, .external_lex_state = 16},
  [2193] = {.lex_state = 80, .external_lex_state = 15},
  [2194] = {.lex_state = 236, .external_lex_state = 16},
  [2195] = {.lex_state = 80, .external_lex_state = 15},
  [2196] = {.lex_state = 236, .external_lex_state = 16},
  [2197] = {.lex_state = 80, .external_lex_state = 15},
  [2198] = {.lex_state = 80, .external_lex_state = 15},
  [2199] = {.lex_state = 80, .external_lex_state = 15},
  [2200] = {.lex_state = 97, .external_lex_state = 13},
  [2201] = {.lex_state = 97, .external_lex_state = 13},
  [2202] = {.lex_state = 97, .external_lex_state = 13},
  [2203] = {.lex_state = 236, .external_lex_state = 16},
  [2204] = {.lex_state = 97, .external_lex_state = 13},
  [2205] = {.lex_state = 236, .external_lex_state = 16},
  [2206] = {.lex_state = 97, .external_lex_state = 13},
  [2207] = {.lex_state = 236, .external_lex_state = 16},
  [2208] = {.lex_state = 97, .external_lex_state = 13},
  [2209] = {.lex_state = 97, .external_lex_state = 13},
  [2210] = {.lex_state = 97, .external_lex_state = 13},
  [2211] = {.lex_state = 174, .external_lex_state = 16},
  [2212] = {.lex_state = 174, .external_lex_state = 16},
  [2213] = {.lex_state = 213, .external_lex_state = 22},
  [2214] = {.lex_state = 213, .external_lex_state = 22},
  [2215] = {.lex_state = 213, .external_lex_state = 22},
  [2216] = {.lex_state = 213, .external_lex_state = 22},
  [2217] = {.lex_state = 213, .external_lex_state = 16},
  [2218] = {.lex_state = 234, .external_lex_state = 16},
  [2219] = {.lex_state = 213, .external_lex_state = 22},
  [2220] = {.lex_state = 238},
  [2221] = {.lex_state = 236, .external_lex_state = 16},
  [2222] = {.lex_state = 213, .external_lex_state = 22},
  [2223] = {.lex_state = 238},
  [2224] = {.lex_state = 236, .external_lex_state = 16},
  [2225] = {.lex_state = 238},
  [2226] = {.lex_state = 236, .external_lex_state = 16},
  [2227] = {.lex_state = 236, .external_lex_state = 16},
  [2228] = {.lex_state = 213, .external_lex_state = 22},
  [2229] = {.lex_state = 236, .external_lex_state = 16},
  [2230] = {.lex_state = 213, .external_lex_state = 22},
  [2231] = {.lex_state = 236, .external_lex_state = 16},
  [2232] = {.lex_state = 213, .external_lex_state = 22},
  [2233] = {.lex_state = 218, .external_lex_state = 2},
  [2234] = {.lex_state = 63, .external_lex_state = 2},
  [2235] = {.lex_state = 213, .external_lex_state = 22},
  [2236] = {.lex_state = 218, .external_lex_state = 2},
  [2237] = {.lex_state = 124, .external_lex_state = 5},
  [2238] = {.lex_state = 124, .external_lex_state = 5},
  [2239] = {.lex_state = 124, .external_lex_state = 5},
  [2240] = {.lex_state = 236, .external_lex_state = 22},
  [2241] = {.lex_state = 236, .external_lex_state = 22},
  [2242] = {.lex_state = 213, .external_lex_state = 22},
  [2243] = {.lex_state = 213, .external_lex_state = 22},
  [2244] = {.lex_state = 213, .external_lex_state = 16},
  [2245] = {.lex_state = 236, .external_lex_state = 16},
  [2246] = {.lex_state = 236, .external_lex_state = 22},
  [2247] = {.lex_state = 236, .external_lex_state = 16},
  [2248] = {.lex_state = 236, .external_lex_state = 22},
  [2249] = {.lex_state = 236, .external_lex_state = 16},
  [2250] = {.lex_state = 236, .external_lex_state = 22},
  [2251] = {.lex_state = 236, .external_lex_state = 16},
  [2252] = {.lex_state = 236, .external_lex_state = 22},
  [2253] = {.lex_state = 236, .external_lex_state = 16},
  [2254] = {.lex_state = 236, .external_lex_state = 22},
  [2255] = {.lex_state = 236, .external_lex_state = 16},
  [2256] = {.lex_state = 236, .external_lex_state = 22},
  [2257] = {.lex_state = 236, .external_lex_state = 22},
  [2258] = {.lex_state = 143, .external_lex_state = 10},
  [2259] = {.lex_state = 143, .external_lex_state = 10},
  [2260] = {.lex_state = 143, .external_lex_state = 10},
  [2261] = {.lex_state = 245, .external_lex_state = 23},
  [2262] = {.lex_state = 245, .external_lex_state = 23},
  [2263] = {.lex_state = 245, .external_lex_state = 23},
  [2264] = {.lex_state = 177, .external_lex_state = 17},
  [2265] = {.lex_state = 177, .external_lex_state = 17},
  [2266] = {.lex_state = 213, .external_lex_state = 22},
  [2267] = {.lex_state = 213, .external_lex_state = 22},
  [2268] = {.lex_state = 213, .external_lex_state = 16},
  [2269] = {.lex_state = 236, .external_lex_state = 16},
  [2270] = {.lex_state = 177, .external_lex_state = 17},
  [2271] = {.lex_state = 236, .external_lex_state = 16},
  [2272] = {.lex_state = 177, .external_lex_state = 17},
  [2273] = {.lex_state = 236, .external_lex_state = 16},
  [2274] = {.lex_state = 177, .external_lex_state = 17},
  [2275] = {.lex_state = 236, .external_lex_state = 16},
  [2276] = {.lex_state = 177, .external_lex_state = 17},
  [2277] = {.lex_state = 236, .external_lex_state = 16},
  [2278] = {.lex_state = 177, .external_lex_state = 17},
  [2279] = {.lex_state = 236, .external_lex_state = 16},
  [2280] = {.lex_state = 209, .external_lex_state = 13},
  [2281] = {.lex_state = 209, .external_lex_state = 13},
  [2282] = {.lex_state = 213, .external_lex_state = 22},
  [2283] = {.lex_state = 213, .external_lex_state = 22},
  [2284] = {.lex_state = 213, .external_lex_state = 16},
  [2285] = {.lex_state = 236, .external_lex_state = 16},
  [2286] = {.lex_state = 209, .external_lex_state = 13},
  [2287] = {.lex_state = 236, .external_lex_state = 16},
  [2288] = {.lex_state = 209, .external_lex_state = 13},
  [2289] = {.lex_state = 236, .external_lex_state = 16},
  [2290] = {.lex_state = 209, .external_lex_state = 13},
  [2291] = {.lex_state = 236, .external_lex_state = 16},
  [2292] = {.lex_state = 209, .external_lex_state = 13},
  [2293] = {.lex_state = 236, .external_lex_state = 16},
  [2294] = {.lex_state = 209, .external_lex_state = 13},
  [2295] = {.lex_state = 236, .external_lex_state = 16},
  [2296] = {.lex_state = 209, .external_lex_state = 13},
  [2297] = {.lex_state = 209, .external_lex_state = 13},
  [2298] = {.lex_state = 141, .external_lex_state = 19},
  [2299] = {.lex_state = 141, .external_lex_state = 19},
  [2300] = {.lex_state = 141, .external_lex_state = 19},
  [2301] = {.lex_state = 236, .external_lex_state = 16},
  [2302] = {.lex_state = 141, .external_lex_state = 19},
  [2303] = {.lex_state = 236, .external_lex_state = 16},
  [2304] = {.lex_state = 141, .external_lex_state = 19},
  [2305] = {.lex_state = 236, .external_lex_state = 16},
  [2306] = {.lex_state = 141, .external_lex_state = 19},
  [2307] = {.lex_state = 141, .external_lex_state = 19},
  [2308] = {.lex_state = 141, .external_lex_state = 19},
  [2309] = {.lex_state = 143, .external_lex_state = 4},
  [2310] = {.lex_state = 272, .external_lex_state = 13},
  [2311] = {.lex_state = 272, .external_lex_state = 13},
  [2312] = {.lex_state = 213, .external_lex_state = 22},
  [2313] = {.lex_state = 213, .external_lex_state = 22},
  [2314] = {.lex_state = 213, .external_lex_state = 16},
  [2315] = {.lex_state = 234, .external_lex_state = 16},
  [2316] = {.lex_state = 272, .external_lex_state = 13},
  [2317] = {.lex_state = 238},
  [2318] = {.lex_state = 236, .external_lex_state = 16},
  [2319] = {.lex_state = 272, .external_lex_state = 13},
  [2320] = {.lex_state = 238},
  [2321] = {.lex_state = 236, .external_lex_state = 16},
  [2322] = {.lex_state = 238},
  [2323] = {.lex_state = 236, .external_lex_state = 16},
  [2324] = {.lex_state = 236, .external_lex_state = 16},
  [2325] = {.lex_state = 272, .external_lex_state = 13},
  [2326] = {.lex_state = 236, .external_lex_state = 16},
  [2327] = {.lex_state = 272, .external_lex_state = 13},
  [2328] = {.lex_state = 236, .external_lex_state = 16},
  [2329] = {.lex_state = 272, .external_lex_state = 13},
  [2330] = {.lex_state = 218, .external_lex_state = 2},
  [2331] = {.lex_state = 63, .external_lex_state = 2},
  [2332] = {.lex_state = 272, .external_lex_state = 13},
  [2333] = {.lex_state = 218, .external_lex_state = 2},
  [2334] = {.lex_state = 143, .external_lex_state = 4},
  [2335] = {.lex_state = 253, .external_lex_state = 10},
  [2336] = {.lex_state = 253, .external_lex_state = 10},
  [2337] = {.lex_state = 253, .external_lex_state = 10},
  [2338] = {.lex_state = 236, .external_lex_state = 16},
  [2339] = {.lex_state = 253, .external_lex_state = 10},
  [2340] = {.lex_state = 236, .external_lex_state = 16},
  [2341] = {.lex_state = 253, .external_lex_state = 10},
  [2342] = {.lex_state = 236, .external_lex_state = 16},
  [2343] = {.lex_state = 253, .external_lex_state = 10},
  [2344] = {.lex_state = 253, .external_lex_state = 10},
  [2345] = {.lex_state = 253, .external_lex_state = 10},
  [2346] = {.lex_state = 270},
  [2347] = {.lex_state = 255, .external_lex_state = 10},
  [2348] = {.lex_state = 255, .external_lex_state = 10},
  [2349] = {.lex_state = 213, .external_lex_state = 22},
  [2350] = {.lex_state = 213, .external_lex_state = 22},
  [2351] = {.lex_state = 213, .external_lex_state = 16},
  [2352] = {.lex_state = 236, .external_lex_state = 16},
  [2353] = {.lex_state = 255, .external_lex_state = 10},
  [2354] = {.lex_state = 236, .external_lex_state = 16},
  [2355] = {.lex_state = 255, .external_lex_state = 10},
  [2356] = {.lex_state = 236, .external_lex_state = 16},
  [2357] = {.lex_state = 255, .external_lex_state = 10},
  [2358] = {.lex_state = 236, .external_lex_state = 16},
  [2359] = {.lex_state = 255, .external_lex_state = 10},
  [2360] = {.lex_state = 236, .external_lex_state = 16},
  [2361] = {.lex_state = 255, .external_lex_state = 10},
  [2362] = {.lex_state = 236, .external_lex_state = 16},
  [2363] = {.lex_state = 255, .external_lex_state = 10},
  [2364] = {.lex_state = 255, .external_lex_state = 10},
  [2365] = {.lex_state = 120, .external_lex_state = 10},
  [2366] = {.lex_state = 203, .external_lex_state = 23},
  [2367] = {.lex_state = 126, .external_lex_state = 9},
  [2368] = {.lex_state = 80},
  [2369] = {.lex_state = 135},
  [2370] = {.lex_state = 149, .external_lex_state = 12},
  [2371] = {.lex_state = 162},
  [2372] = {.lex_state = 69},
  [2373] = {.lex_state = 283, .external_lex_state = 14},
  [2374] = {.lex_state = 97},
  [2375] = {.lex_state = 104},
  [2376] = {.lex_state = 283, .external_lex_state = 14},
  [2377] = {.lex_state = 113, .external_lex_state = 6},
  [2378] = {.lex_state = 63, .external_lex_state = 2},
  [2379] = {.lex_state = 63, .external_lex_state = 2},
  [2380] = {.lex_state = 63, .external_lex_state = 2},
  [2381] = {.lex_state = 283, .external_lex_state = 3},
  [2382] = {.lex_state = 69},
  [2383] = {.lex_state = 283, .external_lex_state = 3},
  [2384] = {.lex_state = 283, .external_lex_state = 10},
  [2385] = {.lex_state = 97},
  [2386] = {.lex_state = 104},
  [2387] = {.lex_state = 283, .external_lex_state = 10},
  [2388] = {.lex_state = 113, .external_lex_state = 6},
  [2389] = {.lex_state = 63, .external_lex_state = 2},
  [2390] = {.lex_state = 63, .external_lex_state = 2},
  [2391] = {.lex_state = 63, .external_lex_state = 2},
  [2392] = {.lex_state = 283, .external_lex_state = 4},
  [2393] = {.lex_state = 283, .external_lex_state = 4},
  [2394] = {.lex_state = 80},
  [2395] = {.lex_state = 289, .external_lex_state = 5},
  [2396] = {.lex_state = 289, .external_lex_state = 5},
  [2397] = {.lex_state = 166},
  [2398] = {.lex_state = 97},
  [2399] = {.lex_state = 289, .external_lex_state = 5},
  [2400] = {.lex_state = 289, .external_lex_state = 5},
  [2401] = {.lex_state = 289, .external_lex_state = 5},
  [2402] = {.lex_state = 69},
  [2403] = {.lex_state = 172, .external_lex_state = 6},
  [2404] = {.lex_state = 174, .external_lex_state = 16},
  [2405] = {.lex_state = 174, .external_lex_state = 16},
  [2406] = {.lex_state = 174, .external_lex_state = 16},
  [2407] = {.lex_state = 137, .external_lex_state = 4},
  [2408] = {.lex_state = 141, .external_lex_state = 8},
  [2409] = {.lex_state = 63, .external_lex_state = 2},
  [2410] = {.lex_state = 90, .external_lex_state = 4},
  [2411] = {.lex_state = 122, .external_lex_state = 8},
  [2412] = {.lex_state = 63, .external_lex_state = 2},
  [2413] = {.lex_state = 137, .external_lex_state = 4},
  [2414] = {.lex_state = 141, .external_lex_state = 8},
  [2415] = {.lex_state = 63, .external_lex_state = 2},
  [2416] = {.lex_state = 84},
  [2417] = {.lex_state = 63, .external_lex_state = 2},
  [2418] = {.lex_state = 279, .external_lex_state = 2},
  [2419] = {.lex_state = 63, .external_lex_state = 2},
  [2420] = {.lex_state = 279, .external_lex_state = 2},
  [2421] = {.lex_state = 63},
  [2422] = {.lex_state = 180},
  [2423] = {.lex_state = 80},
  [2424] = {.lex_state = 80},
  [2425] = {.lex_state = 289, .external_lex_state = 5},
  [2426] = {.lex_state = 289, .external_lex_state = 5},
  [2427] = {.lex_state = 295, .external_lex_state = 7},
  [2428] = {.lex_state = 289, .external_lex_state = 7},
  [2429] = {.lex_state = 257},
  [2430] = {.lex_state = 277, .external_lex_state = 4},
  [2431] = {.lex_state = 293, .external_lex_state = 8},
  [2432] = {.lex_state = 279, .external_lex_state = 2},
  [2433] = {.lex_state = 289, .external_lex_state = 7},
  [2434] = {.lex_state = 279, .external_lex_state = 2},
  [2435] = {.lex_state = 279, .external_lex_state = 2},
  [2436] = {.lex_state = 257},
  [2437] = {.lex_state = 277, .external_lex_state = 4},
  [2438] = {.lex_state = 293, .external_lex_state = 8},
  [2439] = {.lex_state = 279, .external_lex_state = 2},
  [2440] = {.lex_state = 267, .external_lex_state = 2},
  [2441] = {.lex_state = 274},
  [2442] = {.lex_state = 267, .external_lex_state = 2},
  [2443] = {.lex_state = 274},
  [2444] = {.lex_state = 143, .external_lex_state = 4},
  [2445] = {.lex_state = 143, .external_lex_state = 4},
  [2446] = {.lex_state = 131, .external_lex_state = 10},
  [2447] = {.lex_state = 131, .external_lex_state = 10},
  [2448] = {.lex_state = 131, .external_lex_state = 10},
  [2449] = {.lex_state = 281, .external_lex_state = 10},
  [2450] = {.lex_state = 220, .external_lex_state = 23},
  [2451] = {.lex_state = 149, .external_lex_state = 11},
  [2452] = {.lex_state = 149, .external_lex_state = 11},
  [2453] = {.lex_state = 149, .external_lex_state = 11},
  [2454] = {.lex_state = 247, .external_lex_state = 23},
  [2455] = {.lex_state = 247, .external_lex_state = 23},
  [2456] = {.lex_state = 213, .external_lex_state = 22},
  [2457] = {.lex_state = 213, .external_lex_state = 22},
  [2458] = {.lex_state = 213, .external_lex_state = 16},
  [2459] = {.lex_state = 234, .external_lex_state = 16},
  [2460] = {.lex_state = 247, .external_lex_state = 23},
  [2461] = {.lex_state = 238},
  [2462] = {.lex_state = 236, .external_lex_state = 16},
  [2463] = {.lex_state = 247, .external_lex_state = 23},
  [2464] = {.lex_state = 238},
  [2465] = {.lex_state = 236, .external_lex_state = 16},
  [2466] = {.lex_state = 238},
  [2467] = {.lex_state = 236, .external_lex_state = 16},
  [2468] = {.lex_state = 236, .external_lex_state = 16},
  [2469] = {.lex_state = 247, .external_lex_state = 23},
  [2470] = {.lex_state = 236, .external_lex_state = 16},
  [2471] = {.lex_state = 247, .external_lex_state = 23},
  [2472] = {.lex_state = 236, .external_lex_state = 16},
  [2473] = {.lex_state = 247, .external_lex_state = 23},
  [2474] = {.lex_state = 218, .external_lex_state = 2},
  [2475] = {.lex_state = 63, .external_lex_state = 2},
  [2476] = {.lex_state = 247, .external_lex_state = 23},
  [2477] = {.lex_state = 218, .external_lex_state = 2},
  [2478] = {.lex_state = 231, .external_lex_state = 13},
  [2479] = {.lex_state = 231, .external_lex_state = 13},
  [2480] = {.lex_state = 231, .external_lex_state = 13},
  [2481] = {.lex_state = 137, .external_lex_state = 14},
  [2482] = {.lex_state = 137, .external_lex_state = 14},
  [2483] = {.lex_state = 137, .external_lex_state = 14},
  [2484] = {.lex_state = 137, .external_lex_state = 10},
  [2485] = {.lex_state = 137, .external_lex_state = 10},
  [2486] = {.lex_state = 137, .external_lex_state = 10},
  [2487] = {.lex_state = 80, .external_lex_state = 15},
  [2488] = {.lex_state = 80, .external_lex_state = 15},
  [2489] = {.lex_state = 80, .external_lex_state = 15},
  [2490] = {.lex_state = 97, .external_lex_state = 13},
  [2491] = {.lex_state = 97, .external_lex_state = 13},
  [2492] = {.lex_state = 97, .external_lex_state = 13},
  [2493] = {.lex_state = 213, .external_lex_state = 22},
  [2494] = {.lex_state = 213, .external_lex_state = 22},
  [2495] = {.lex_state = 213, .external_lex_state = 22},
  [2496] = {.lex_state = 213, .external_lex_state = 22},
  [2497] = {.lex_state = 213, .external_lex_state = 16},
  [2498] = {.lex_state = 236, .external_lex_state = 16},
  [2499] = {.lex_state = 213, .external_lex_state = 22},
  [2500] = {.lex_state = 236, .external_lex_state = 16},
  [2501] = {.lex_state = 213, .external_lex_state = 22},
  [2502] = {.lex_state = 236, .external_lex_state = 16},
  [2503] = {.lex_state = 213, .external_lex_state = 22},
  [2504] = {.lex_state = 236, .external_lex_state = 16},
  [2505] = {.lex_state = 213, .external_lex_state = 22},
  [2506] = {.lex_state = 236, .external_lex_state = 16},
  [2507] = {.lex_state = 213, .external_lex_state = 22},
  [2508] = {.lex_state = 236, .external_lex_state = 16},
  [2509] = {.lex_state = 213, .external_lex_state = 22},
  [2510] = {.lex_state = 213, .external_lex_state = 22},
  [2511] = {.lex_state = 236, .external_lex_state = 22},
  [2512] = {.lex_state = 236, .external_lex_state = 22},
  [2513] = {.lex_state = 236, .external_lex_state = 22},
  [2514] = {.lex_state = 236, .external_lex_state = 16},
  [2515] = {.lex_state = 236, .external_lex_state = 22},
  [2516] = {.lex_state = 236, .external_lex_state = 16},
  [2517] = {.lex_state = 236, .external_lex_state = 22},
  [2518] = {.lex_state = 236, .external_lex_state = 16},
  [2519] = {.lex_state = 236, .external_lex_state = 22},
  [2520] = {.lex_state = 236, .external_lex_state = 22},
  [2521] = {.lex_state = 236, .external_lex_state = 22},
  [2522] = {.lex_state = 143, .external_lex_state = 10},
  [2523] = {.lex_state = 245, .external_lex_state = 23},
  [2524] = {.lex_state = 177, .external_lex_state = 17},
  [2525] = {.lex_state = 177, .external_lex_state = 17},
  [2526] = {.lex_state = 177, .external_lex_state = 17},
  [2527] = {.lex_state = 236, .external_lex_state = 16},
  [2528] = {.lex_state = 177, .external_lex_state = 17},
  [2529] = {.lex_state = 236, .external_lex_state = 16},
  [2530] = {.lex_state = 177, .external_lex_state = 17},
  [2531] = {.lex_state = 236, .external_lex_state = 16},
  [2532] = {.lex_state = 177, .external_lex_state = 17},
  [2533] = {.lex_state = 177, .external_lex_state = 17},
  [2534] = {.lex_state = 177, .external_lex_state = 17},
  [2535] = {.lex_state = 209, .external_lex_state = 13},
  [2536] = {.lex_state = 209, .external_lex_state = 13},
  [2537] = {.lex_state = 209, .external_lex_state = 13},
  [2538] = {.lex_state = 236, .external_lex_state = 16},
  [2539] = {.lex_state = 209, .external_lex_state = 13},
  [2540] = {.lex_state = 236, .external_lex_state = 16},
  [2541] = {.lex_state = 209, .external_lex_state = 13},
  [2542] = {.lex_state = 236, .external_lex_state = 16},
  [2543] = {.lex_state = 209, .external_lex_state = 13},
  [2544] = {.lex_state = 209, .external_lex_state = 13},
  [2545] = {.lex_state = 209, .external_lex_state = 13},
  [2546] = {.lex_state = 141, .external_lex_state = 19},
  [2547] = {.lex_state = 141, .external_lex_state = 19},
  [2548] = {.lex_state = 141, .external_lex_state = 19},
  [2549] = {.lex_state = 272, .external_lex_state = 13},
  [2550] = {.lex_state = 272, .external_lex_state = 13},
  [2551] = {.lex_state = 213, .external_lex_state = 22},
  [2552] = {.lex_state = 213, .external_lex_state = 22},
  [2553] = {.lex_state = 213, .external_lex_state = 16},
  [2554] = {.lex_state = 236, .external_lex_state = 16},
  [2555] = {.lex_state = 272, .external_lex_state = 13},
  [2556] = {.lex_state = 236, .external_lex_state = 16},
  [2557] = {.lex_state = 272, .external_lex_state = 13},
  [2558] = {.lex_state = 236, .external_lex_state = 16},
  [2559] = {.lex_state = 272, .external_lex_state = 13},
  [2560] = {.lex_state = 236, .external_lex_state = 16},
  [2561] = {.lex_state = 272, .external_lex_state = 13},
  [2562] = {.lex_state = 236, .external_lex_state = 16},
  [2563] = {.lex_state = 272, .external_lex_state = 13},
  [2564] = {.lex_state = 236, .external_lex_state = 16},
  [2565] = {.lex_state = 272, .external_lex_state = 13},
  [2566] = {.lex_state = 272, .external_lex_state = 13},
  [2567] = {.lex_state = 253, .external_lex_state = 10},
  [2568] = {.lex_state = 253, .external_lex_state = 10},
  [2569] = {.lex_state = 253, .external_lex_state = 10},
  [2570] = {.lex_state = 143, .external_lex_state = 4},
  [2571] = {.lex_state = 255, .external_lex_state = 10},
  [2572] = {.lex_state = 255, .external_lex_state = 10},
  [2573] = {.lex_state = 255, .external_lex_state = 10},
  [2574] = {.lex_state = 236, .external_lex_state = 16},
  [2575] = {.lex_state = 255, .external_lex_state = 10},
  [2576] = {.lex_state = 236, .external_lex_state = 16},
  [2577] = {.lex_state = 255, .external_lex_state = 10},
  [2578] = {.lex_state = 236, .external_lex_state = 16},
  [2579] = {.lex_state = 255, .external_lex_state = 10},
  [2580] = {.lex_state = 255, .external_lex_state = 10},
  [2581] = {.lex_state = 255, .external_lex_state = 10},
  [2582] = {.lex_state = 293, .external_lex_state = 8},
  [2583] = {.lex_state = 209},
  [2584] = {.lex_state = 293, .external_lex_state = 19},
  [2585] = {.lex_state = 97},
  [2586] = {.lex_state = 104},
  [2587] = {.lex_state = 293, .external_lex_state = 19},
  [2588] = {.lex_state = 113, .external_lex_state = 6},
  [2589] = {.lex_state = 63, .external_lex_state = 2},
  [2590] = {.lex_state = 63, .external_lex_state = 2},
  [2591] = {.lex_state = 63, .external_lex_state = 2},
  [2592] = {.lex_state = 295, .external_lex_state = 7},
  [2593] = {.lex_state = 84},
  [2594] = {.lex_state = 297, .external_lex_state = 21},
  [2595] = {.lex_state = 295, .external_lex_state = 21},
  [2596] = {.lex_state = 126, .external_lex_state = 9},
  [2597] = {.lex_state = 80},
  [2598] = {.lex_state = 283, .external_lex_state = 14},
  [2599] = {.lex_state = 283, .external_lex_state = 14},
  [2600] = {.lex_state = 166},
  [2601] = {.lex_state = 97},
  [2602] = {.lex_state = 283, .external_lex_state = 14},
  [2603] = {.lex_state = 283, .external_lex_state = 14},
  [2604] = {.lex_state = 283, .external_lex_state = 14},
  [2605] = {.lex_state = 69},
  [2606] = {.lex_state = 172, .external_lex_state = 6},
  [2607] = {.lex_state = 174, .external_lex_state = 16},
  [2608] = {.lex_state = 174, .external_lex_state = 16},
  [2609] = {.lex_state = 174, .external_lex_state = 16},
  [2610] = {.lex_state = 137, .external_lex_state = 4},
  [2611] = {.lex_state = 141, .external_lex_state = 8},
  [2612] = {.lex_state = 63, .external_lex_state = 2},
  [2613] = {.lex_state = 90, .external_lex_state = 4},
  [2614] = {.lex_state = 122, .external_lex_state = 8},
  [2615] = {.lex_state = 63, .external_lex_state = 2},
  [2616] = {.lex_state = 137, .external_lex_state = 4},
  [2617] = {.lex_state = 141, .external_lex_state = 8},
  [2618] = {.lex_state = 63, .external_lex_state = 2},
  [2619] = {.lex_state = 283, .external_lex_state = 3},
  [2620] = {.lex_state = 80},
  [2621] = {.lex_state = 283, .external_lex_state = 10},
  [2622] = {.lex_state = 283, .external_lex_state = 10},
  [2623] = {.lex_state = 166},
  [2624] = {.lex_state = 97},
  [2625] = {.lex_state = 283, .external_lex_state = 10},
  [2626] = {.lex_state = 283, .external_lex_state = 10},
  [2627] = {.lex_state = 283, .external_lex_state = 10},
  [2628] = {.lex_state = 69},
  [2629] = {.lex_state = 172, .external_lex_state = 6},
  [2630] = {.lex_state = 174, .external_lex_state = 16},
  [2631] = {.lex_state = 174, .external_lex_state = 16},
  [2632] = {.lex_state = 174, .external_lex_state = 16},
  [2633] = {.lex_state = 137, .external_lex_state = 4},
  [2634] = {.lex_state = 141, .external_lex_state = 8},
  [2635] = {.lex_state = 63, .external_lex_state = 2},
  [2636] = {.lex_state = 90, .external_lex_state = 4},
  [2637] = {.lex_state = 122, .external_lex_state = 8},
  [2638] = {.lex_state = 63, .external_lex_state = 2},
  [2639] = {.lex_state = 137, .external_lex_state = 4},
  [2640] = {.lex_state = 141, .external_lex_state = 8},
  [2641] = {.lex_state = 63, .external_lex_state = 2},
  [2642] = {.lex_state = 283, .external_lex_state = 4},
  [2643] = {.lex_state = 289, .external_lex_state = 5},
  [2644] = {.lex_state = 289, .external_lex_state = 5},
  [2645] = {.lex_state = 289, .external_lex_state = 5},
  [2646] = {.lex_state = 166},
  [2647] = {.lex_state = 234, .external_lex_state = 16},
  [2648] = {.lex_state = 69},
  [2649] = {.lex_state = 174, .external_lex_state = 16},
  [2650] = {.lex_state = 174, .external_lex_state = 16},
  [2651] = {.lex_state = 174, .external_lex_state = 16},
  [2652] = {.lex_state = 289, .external_lex_state = 5},
  [2653] = {.lex_state = 238},
  [2654] = {.lex_state = 236, .external_lex_state = 16},
  [2655] = {.lex_state = 289, .external_lex_state = 5},
  [2656] = {.lex_state = 238},
  [2657] = {.lex_state = 236, .external_lex_state = 16},
  [2658] = {.lex_state = 289, .external_lex_state = 5},
  [2659] = {.lex_state = 238},
  [2660] = {.lex_state = 236, .external_lex_state = 16},
  [2661] = {.lex_state = 289, .external_lex_state = 5},
  [2662] = {.lex_state = 218, .external_lex_state = 2},
  [2663] = {.lex_state = 137, .external_lex_state = 4},
  [2664] = {.lex_state = 141, .external_lex_state = 8},
  [2665] = {.lex_state = 63, .external_lex_state = 2},
  [2666] = {.lex_state = 90, .external_lex_state = 4},
  [2667] = {.lex_state = 122, .external_lex_state = 8},
  [2668] = {.lex_state = 289, .external_lex_state = 5},
  [2669] = {.lex_state = 218, .external_lex_state = 2},
  [2670] = {.lex_state = 137, .external_lex_state = 4},
  [2671] = {.lex_state = 141, .external_lex_state = 8},
  [2672] = {.lex_state = 135},
  [2673] = {.lex_state = 293, .external_lex_state = 8},
  [2674] = {.lex_state = 277, .external_lex_state = 4},
  [2675] = {.lex_state = 293, .external_lex_state = 8},
  [2676] = {.lex_state = 80},
  [2677] = {.lex_state = 289, .external_lex_state = 5},
  [2678] = {.lex_state = 289, .external_lex_state = 5},
  [2679] = {.lex_state = 289, .external_lex_state = 7},
  [2680] = {.lex_state = 295, .external_lex_state = 5},
  [2681] = {.lex_state = 97},
  [2682] = {.lex_state = 104},
  [2683] = {.lex_state = 295, .external_lex_state = 5},
  [2684] = {.lex_state = 113, .external_lex_state = 6},
  [2685] = {.lex_state = 63, .external_lex_state = 2},
  [2686] = {.lex_state = 63, .external_lex_state = 2},
  [2687] = {.lex_state = 63, .external_lex_state = 2},
  [2688] = {.lex_state = 295, .external_lex_state = 5},
  [2689] = {.lex_state = 295, .external_lex_state = 5},
  [2690] = {.lex_state = 295, .external_lex_state = 7},
  [2691] = {.lex_state = 295, .external_lex_state = 7},
  [2692] = {.lex_state = 289, .external_lex_state = 7},
  [2693] = {.lex_state = 279, .external_lex_state = 2},
  [2694] = {.lex_state = 90, .external_lex_state = 4},
  [2695] = {.lex_state = 122, .external_lex_state = 8},
  [2696] = {.lex_state = 289, .external_lex_state = 7},
  [2697] = {.lex_state = 257},
  [2698] = {.lex_state = 277, .external_lex_state = 4},
  [2699] = {.lex_state = 293, .external_lex_state = 8},
  [2700] = {.lex_state = 279, .external_lex_state = 2},
  [2701] = {.lex_state = 257},
  [2702] = {.lex_state = 277, .external_lex_state = 4},
  [2703] = {.lex_state = 293, .external_lex_state = 8},
  [2704] = {.lex_state = 80},
  [2705] = {.lex_state = 90, .external_lex_state = 4},
  [2706] = {.lex_state = 122, .external_lex_state = 8},
  [2707] = {.lex_state = 267, .external_lex_state = 2},
  [2708] = {.lex_state = 267, .external_lex_state = 2},
  [2709] = {.lex_state = 80},
  [2710] = {.lex_state = 90, .external_lex_state = 4},
  [2711] = {.lex_state = 122, .external_lex_state = 8},
  [2712] = {.lex_state = 267, .external_lex_state = 2},
  [2713] = {.lex_state = 267, .external_lex_state = 2},
  [2714] = {.lex_state = 247, .external_lex_state = 23},
  [2715] = {.lex_state = 247, .external_lex_state = 23},
  [2716] = {.lex_state = 213, .external_lex_state = 22},
  [2717] = {.lex_state = 213, .external_lex_state = 22},
  [2718] = {.lex_state = 213, .external_lex_state = 16},
  [2719] = {.lex_state = 236, .external_lex_state = 16},
  [2720] = {.lex_state = 247, .external_lex_state = 23},
  [2721] = {.lex_state = 236, .external_lex_state = 16},
  [2722] = {.lex_state = 247, .external_lex_state = 23},
  [2723] = {.lex_state = 236, .external_lex_state = 16},
  [2724] = {.lex_state = 247, .external_lex_state = 23},
  [2725] = {.lex_state = 236, .external_lex_state = 16},
  [2726] = {.lex_state = 247, .external_lex_state = 23},
  [2727] = {.lex_state = 236, .external_lex_state = 16},
  [2728] = {.lex_state = 247, .external_lex_state = 23},
  [2729] = {.lex_state = 236, .external_lex_state = 16},
  [2730] = {.lex_state = 247, .external_lex_state = 23},
  [2731] = {.lex_state = 247, .external_lex_state = 23},
  [2732] = {.lex_state = 213, .external_lex_state = 22},
  [2733] = {.lex_state = 213, .external_lex_state = 22},
  [2734] = {.lex_state = 213, .external_lex_state = 22},
  [2735] = {.lex_state = 236, .external_lex_state = 16},
  [2736] = {.lex_state = 213, .external_lex_state = 22},
  [2737] = {.lex_state = 236, .external_lex_state = 16},
  [2738] = {.lex_state = 213, .external_lex_state = 22},
  [2739] = {.lex_state = 236, .external_lex_state = 16},
  [2740] = {.lex_state = 213, .external_lex_state = 22},
  [2741] = {.lex_state = 213, .external_lex_state = 22},
  [2742] = {.lex_state = 213, .external_lex_state = 22},
  [2743] = {.lex_state = 236, .external_lex_state = 22},
  [2744] = {.lex_state = 236, .external_lex_state = 22},
  [2745] = {.lex_state = 236, .external_lex_state = 22},
  [2746] = {.lex_state = 177, .external_lex_state = 17},
  [2747] = {.lex_state = 177, .external_lex_state = 17},
  [2748] = {.lex_state = 177, .external_lex_state = 17},
  [2749] = {.lex_state = 209, .external_lex_state = 13},
  [2750] = {.lex_state = 209, .external_lex_state = 13},
  [2751] = {.lex_state = 209, .external_lex_state = 13},
  [2752] = {.lex_state = 272, .external_lex_state = 13},
  [2753] = {.lex_state = 272, .external_lex_state = 13},
  [2754] = {.lex_state = 272, .external_lex_state = 13},
  [2755] = {.lex_state = 236, .external_lex_state = 16},
  [2756] = {.lex_state = 272, .external_lex_state = 13},
  [2757] = {.lex_state = 236, .external_lex_state = 16},
  [2758] = {.lex_state = 272, .external_lex_state = 13},
  [2759] = {.lex_state = 236, .external_lex_state = 16},
  [2760] = {.lex_state = 272, .external_lex_state = 13},
  [2761] = {.lex_state = 272, .external_lex_state = 13},
  [2762] = {.lex_state = 272, .external_lex_state = 13},
  [2763] = {.lex_state = 255, .external_lex_state = 10},
  [2764] = {.lex_state = 255, .external_lex_state = 10},
  [2765] = {.lex_state = 255, .external_lex_state = 10},
  [2766] = {.lex_state = 293, .external_lex_state = 8},
  [2767] = {.lex_state = 209},
  [2768] = {.lex_state = 80},
  [2769] = {.lex_state = 293, .external_lex_state = 19},
  [2770] = {.lex_state = 293, .external_lex_state = 19},
  [2771] = {.lex_state = 166},
  [2772] = {.lex_state = 97},
  [2773] = {.lex_state = 293, .external_lex_state = 19},
  [2774] = {.lex_state = 293, .external_lex_state = 19},
  [2775] = {.lex_state = 293, .external_lex_state = 19},
  [2776] = {.lex_state = 69},
  [2777] = {.lex_state = 172, .external_lex_state = 6},
  [2778] = {.lex_state = 174, .external_lex_state = 16},
  [2779] = {.lex_state = 174, .external_lex_state = 16},
  [2780] = {.lex_state = 174, .external_lex_state = 16},
  [2781] = {.lex_state = 137, .external_lex_state = 4},
  [2782] = {.lex_state = 141, .external_lex_state = 8},
  [2783] = {.lex_state = 63, .external_lex_state = 2},
  [2784] = {.lex_state = 90, .external_lex_state = 4},
  [2785] = {.lex_state = 122, .external_lex_state = 8},
  [2786] = {.lex_state = 63, .external_lex_state = 2},
  [2787] = {.lex_state = 137, .external_lex_state = 4},
  [2788] = {.lex_state = 141, .external_lex_state = 8},
  [2789] = {.lex_state = 63, .external_lex_state = 2},
  [2790] = {.lex_state = 295, .external_lex_state = 7},
  [2791] = {.lex_state = 135},
  [2792] = {.lex_state = 63},
  [2793] = {.lex_state = 80},
  [2794] = {.lex_state = 63},
  [2795] = {.lex_state = 80},
  [2796] = {.lex_state = 80},
  [2797] = {.lex_state = 295, .external_lex_state = 21},
  [2798] = {.lex_state = 283, .external_lex_state = 3},
  [2799] = {.lex_state = 209},
  [2800] = {.lex_state = 283, .external_lex_state = 14},
  [2801] = {.lex_state = 283, .external_lex_state = 14},
  [2802] = {.lex_state = 283, .external_lex_state = 14},
  [2803] = {.lex_state = 283, .external_lex_state = 14},
  [2804] = {.lex_state = 283, .external_lex_state = 14},
  [2805] = {.lex_state = 166},
  [2806] = {.lex_state = 234, .external_lex_state = 16},
  [2807] = {.lex_state = 69},
  [2808] = {.lex_state = 174, .external_lex_state = 16},
  [2809] = {.lex_state = 174, .external_lex_state = 16},
  [2810] = {.lex_state = 174, .external_lex_state = 16},
  [2811] = {.lex_state = 283, .external_lex_state = 14},
  [2812] = {.lex_state = 238},
  [2813] = {.lex_state = 236, .external_lex_state = 16},
  [2814] = {.lex_state = 283, .external_lex_state = 14},
  [2815] = {.lex_state = 238},
  [2816] = {.lex_state = 236, .external_lex_state = 16},
  [2817] = {.lex_state = 283, .external_lex_state = 14},
  [2818] = {.lex_state = 238},
  [2819] = {.lex_state = 236, .external_lex_state = 16},
  [2820] = {.lex_state = 283, .external_lex_state = 14},
  [2821] = {.lex_state = 218, .external_lex_state = 2},
  [2822] = {.lex_state = 137, .external_lex_state = 4},
  [2823] = {.lex_state = 141, .external_lex_state = 8},
  [2824] = {.lex_state = 63, .external_lex_state = 2},
  [2825] = {.lex_state = 90, .external_lex_state = 4},
  [2826] = {.lex_state = 122, .external_lex_state = 8},
  [2827] = {.lex_state = 283, .external_lex_state = 14},
  [2828] = {.lex_state = 218, .external_lex_state = 2},
  [2829] = {.lex_state = 137, .external_lex_state = 4},
  [2830] = {.lex_state = 141, .external_lex_state = 8},
  [2831] = {.lex_state = 283, .external_lex_state = 10},
  [2832] = {.lex_state = 283, .external_lex_state = 10},
  [2833] = {.lex_state = 283, .external_lex_state = 10},
  [2834] = {.lex_state = 166},
  [2835] = {.lex_state = 234, .external_lex_state = 16},
  [2836] = {.lex_state = 69},
  [2837] = {.lex_state = 174, .external_lex_state = 16},
  [2838] = {.lex_state = 174, .external_lex_state = 16},
  [2839] = {.lex_state = 174, .external_lex_state = 16},
  [2840] = {.lex_state = 283, .external_lex_state = 10},
  [2841] = {.lex_state = 238},
  [2842] = {.lex_state = 236, .external_lex_state = 16},
  [2843] = {.lex_state = 283, .external_lex_state = 10},
  [2844] = {.lex_state = 238},
  [2845] = {.lex_state = 236, .external_lex_state = 16},
  [2846] = {.lex_state = 283, .external_lex_state = 10},
  [2847] = {.lex_state = 238},
  [2848] = {.lex_state = 236, .external_lex_state = 16},
  [2849] = {.lex_state = 283, .external_lex_state = 10},
  [2850] = {.lex_state = 218, .external_lex_state = 2},
  [2851] = {.lex_state = 137, .external_lex_state = 4},
  [2852] = {.lex_state = 141, .external_lex_state = 8},
  [2853] = {.lex_state = 63, .external_lex_state = 2},
  [2854] = {.lex_state = 90, .external_lex_state = 4},
  [2855] = {.lex_state = 122, .external_lex_state = 8},
  [2856] = {.lex_state = 283, .external_lex_state = 10},
  [2857] = {.lex_state = 218, .external_lex_state = 2},
  [2858] = {.lex_state = 137, .external_lex_state = 4},
  [2859] = {.lex_state = 141, .external_lex_state = 8},
  [2860] = {.lex_state = 289, .external_lex_state = 5},
  [2861] = {.lex_state = 289, .external_lex_state = 5},
  [2862] = {.lex_state = 213, .external_lex_state = 22},
  [2863] = {.lex_state = 213, .external_lex_state = 22},
  [2864] = {.lex_state = 213, .external_lex_state = 16},
  [2865] = {.lex_state = 234, .external_lex_state = 16},
  [2866] = {.lex_state = 289, .external_lex_state = 5},
  [2867] = {.lex_state = 238},
  [2868] = {.lex_state = 236, .external_lex_state = 16},
  [2869] = {.lex_state = 289, .external_lex_state = 5},
  [2870] = {.lex_state = 238},
  [2871] = {.lex_state = 236, .external_lex_state = 16},
  [2872] = {.lex_state = 238},
  [2873] = {.lex_state = 236, .external_lex_state = 16},
  [2874] = {.lex_state = 236, .external_lex_state = 16},
  [2875] = {.lex_state = 289, .external_lex_state = 5},
  [2876] = {.lex_state = 236, .external_lex_state = 16},
  [2877] = {.lex_state = 289, .external_lex_state = 5},
  [2878] = {.lex_state = 236, .external_lex_state = 16},
  [2879] = {.lex_state = 289, .external_lex_state = 5},
  [2880] = {.lex_state = 218, .external_lex_state = 2},
  [2881] = {.lex_state = 63, .external_lex_state = 2},
  [2882] = {.lex_state = 289, .external_lex_state = 5},
  [2883] = {.lex_state = 218, .external_lex_state = 2},
  [2884] = {.lex_state = 297, .external_lex_state = 21},
  [2885] = {.lex_state = 295, .external_lex_state = 5},
  [2886] = {.lex_state = 295, .external_lex_state = 5},
  [2887] = {.lex_state = 80},
  [2888] = {.lex_state = 295, .external_lex_state = 5},
  [2889] = {.lex_state = 295, .external_lex_state = 5},
  [2890] = {.lex_state = 166},
  [2891] = {.lex_state = 97},
  [2892] = {.lex_state = 295, .external_lex_state = 5},
  [2893] = {.lex_state = 295, .external_lex_state = 5},
  [2894] = {.lex_state = 295, .external_lex_state = 5},
  [2895] = {.lex_state = 69},
  [2896] = {.lex_state = 172, .external_lex_state = 6},
  [2897] = {.lex_state = 174, .external_lex_state = 16},
  [2898] = {.lex_state = 174, .external_lex_state = 16},
  [2899] = {.lex_state = 174, .external_lex_state = 16},
  [2900] = {.lex_state = 137, .external_lex_state = 4},
  [2901] = {.lex_state = 141, .external_lex_state = 8},
  [2902] = {.lex_state = 63, .external_lex_state = 2},
  [2903] = {.lex_state = 90, .external_lex_state = 4},
  [2904] = {.lex_state = 122, .external_lex_state = 8},
  [2905] = {.lex_state = 63, .external_lex_state = 2},
  [2906] = {.lex_state = 137, .external_lex_state = 4},
  [2907] = {.lex_state = 141, .external_lex_state = 8},
  [2908] = {.lex_state = 63, .external_lex_state = 2},
  [2909] = {.lex_state = 295, .external_lex_state = 7},
  [2910] = {.lex_state = 279, .external_lex_state = 2},
  [2911] = {.lex_state = 279, .external_lex_state = 2},
  [2912] = {.lex_state = 267, .external_lex_state = 2},
  [2913] = {.lex_state = 80},
  [2914] = {.lex_state = 90, .external_lex_state = 4},
  [2915] = {.lex_state = 122, .external_lex_state = 8},
  [2916] = {.lex_state = 267, .external_lex_state = 2},
  [2917] = {.lex_state = 267, .external_lex_state = 2},
  [2918] = {.lex_state = 267, .external_lex_state = 2},
  [2919] = {.lex_state = 80},
  [2920] = {.lex_state = 90, .external_lex_state = 4},
  [2921] = {.lex_state = 122, .external_lex_state = 8},
  [2922] = {.lex_state = 267, .external_lex_state = 2},
  [2923] = {.lex_state = 247, .external_lex_state = 23},
  [2924] = {.lex_state = 247, .external_lex_state = 23},
  [2925] = {.lex_state = 247, .external_lex_state = 23},
  [2926] = {.lex_state = 236, .external_lex_state = 16},
  [2927] = {.lex_state = 247, .external_lex_state = 23},
  [2928] = {.lex_state = 236, .external_lex_state = 16},
  [2929] = {.lex_state = 247, .external_lex_state = 23},
  [2930] = {.lex_state = 236, .external_lex_state = 16},
  [2931] = {.lex_state = 247, .external_lex_state = 23},
  [2932] = {.lex_state = 247, .external_lex_state = 23},
  [2933] = {.lex_state = 247, .external_lex_state = 23},
  [2934] = {.lex_state = 213, .external_lex_state = 22},
  [2935] = {.lex_state = 213, .external_lex_state = 22},
  [2936] = {.lex_state = 213, .external_lex_state = 22},
  [2937] = {.lex_state = 272, .external_lex_state = 13},
  [2938] = {.lex_state = 272, .external_lex_state = 13},
  [2939] = {.lex_state = 272, .external_lex_state = 13},
  [2940] = {.lex_state = 293, .external_lex_state = 8},
  [2941] = {.lex_state = 293, .external_lex_state = 19},
  [2942] = {.lex_state = 293, .external_lex_state = 19},
  [2943] = {.lex_state = 293, .external_lex_state = 19},
  [2944] = {.lex_state = 166},
  [2945] = {.lex_state = 234, .external_lex_state = 16},
  [2946] = {.lex_state = 69},
  [2947] = {.lex_state = 174, .external_lex_state = 16},
  [2948] = {.lex_state = 174, .external_lex_state = 16},
  [2949] = {.lex_state = 174, .external_lex_state = 16},
  [2950] = {.lex_state = 293, .external_lex_state = 19},
  [2951] = {.lex_state = 238},
  [2952] = {.lex_state = 236, .external_lex_state = 16},
  [2953] = {.lex_state = 293, .external_lex_state = 19},
  [2954] = {.lex_state = 238},
  [2955] = {.lex_state = 236, .external_lex_state = 16},
  [2956] = {.lex_state = 293, .external_lex_state = 19},
  [2957] = {.lex_state = 238},
  [2958] = {.lex_state = 236, .external_lex_state = 16},
  [2959] = {.lex_state = 293, .external_lex_state = 19},
  [2960] = {.lex_state = 218, .external_lex_state = 2},
  [2961] = {.lex_state = 137, .external_lex_state = 4},
  [2962] = {.lex_state = 141, .external_lex_state = 8},
  [2963] = {.lex_state = 63, .external_lex_state = 2},
  [2964] = {.lex_state = 90, .external_lex_state = 4},
  [2965] = {.lex_state = 122, .external_lex_state = 8},
  [2966] = {.lex_state = 293, .external_lex_state = 19},
  [2967] = {.lex_state = 218, .external_lex_state = 2},
  [2968] = {.lex_state = 137, .external_lex_state = 4},
  [2969] = {.lex_state = 141, .external_lex_state = 8},
  [2970] = {.lex_state = 297, .external_lex_state = 21},
  [2971] = {.lex_state = 80},
  [2972] = {.lex_state = 277, .external_lex_state = 10},
  [2973] = {.lex_state = 277, .external_lex_state = 10},
  [2974] = {.lex_state = 80},
  [2975] = {.lex_state = 295, .external_lex_state = 23},
  [2976] = {.lex_state = 295, .external_lex_state = 23},
  [2977] = {.lex_state = 295, .external_lex_state = 23},
  [2978] = {.lex_state = 295, .external_lex_state = 23},
  [2979] = {.lex_state = 295, .external_lex_state = 21},
  [2980] = {.lex_state = 283, .external_lex_state = 3},
  [2981] = {.lex_state = 209},
  [2982] = {.lex_state = 283, .external_lex_state = 14},
  [2983] = {.lex_state = 283, .external_lex_state = 14},
  [2984] = {.lex_state = 213, .external_lex_state = 22},
  [2985] = {.lex_state = 213, .external_lex_state = 22},
  [2986] = {.lex_state = 213, .external_lex_state = 16},
  [2987] = {.lex_state = 234, .external_lex_state = 16},
  [2988] = {.lex_state = 283, .external_lex_state = 14},
  [2989] = {.lex_state = 238},
  [2990] = {.lex_state = 236, .external_lex_state = 16},
  [2991] = {.lex_state = 283, .external_lex_state = 14},
  [2992] = {.lex_state = 238},
  [2993] = {.lex_state = 236, .external_lex_state = 16},
  [2994] = {.lex_state = 238},
  [2995] = {.lex_state = 236, .external_lex_state = 16},
  [2996] = {.lex_state = 236, .external_lex_state = 16},
  [2997] = {.lex_state = 283, .external_lex_state = 14},
  [2998] = {.lex_state = 236, .external_lex_state = 16},
  [2999] = {.lex_state = 283, .external_lex_state = 14},
  [3000] = {.lex_state = 236, .external_lex_state = 16},
  [3001] = {.lex_state = 283, .external_lex_state = 14},
  [3002] = {.lex_state = 218, .external_lex_state = 2},
  [3003] = {.lex_state = 63, .external_lex_state = 2},
  [3004] = {.lex_state = 283, .external_lex_state = 14},
  [3005] = {.lex_state = 218, .external_lex_state = 2},
  [3006] = {.lex_state = 283, .external_lex_state = 10},
  [3007] = {.lex_state = 283, .external_lex_state = 10},
  [3008] = {.lex_state = 213, .external_lex_state = 22},
  [3009] = {.lex_state = 213, .external_lex_state = 22},
  [3010] = {.lex_state = 213, .external_lex_state = 16},
  [3011] = {.lex_state = 234, .external_lex_state = 16},
  [3012] = {.lex_state = 283, .external_lex_state = 10},
  [3013] = {.lex_state = 238},
  [3014] = {.lex_state = 236, .external_lex_state = 16},
  [3015] = {.lex_state = 283, .external_lex_state = 10},
  [3016] = {.lex_state = 238},
  [3017] = {.lex_state = 236, .external_lex_state = 16},
  [3018] = {.lex_state = 238},
  [3019] = {.lex_state = 236, .external_lex_state = 16},
  [3020] = {.lex_state = 236, .external_lex_state = 16},
  [3021] = {.lex_state = 283, .external_lex_state = 10},
  [3022] = {.lex_state = 236, .external_lex_state = 16},
  [3023] = {.lex_state = 283, .external_lex_state = 10},
  [3024] = {.lex_state = 236, .external_lex_state = 16},
  [3025] = {.lex_state = 283, .external_lex_state = 10},
  [3026] = {.lex_state = 218, .external_lex_state = 2},
  [3027] = {.lex_state = 63, .external_lex_state = 2},
  [3028] = {.lex_state = 283, .external_lex_state = 10},
  [3029] = {.lex_state = 218, .external_lex_state = 2},
  [3030] = {.lex_state = 289, .external_lex_state = 5},
  [3031] = {.lex_state = 289, .external_lex_state = 5},
  [3032] = {.lex_state = 213, .external_lex_state = 22},
  [3033] = {.lex_state = 213, .external_lex_state = 22},
  [3034] = {.lex_state = 213, .external_lex_state = 16},
  [3035] = {.lex_state = 236, .external_lex_state = 16},
  [3036] = {.lex_state = 289, .external_lex_state = 5},
  [3037] = {.lex_state = 236, .external_lex_state = 16},
  [3038] = {.lex_state = 289, .external_lex_state = 5},
  [3039] = {.lex_state = 236, .external_lex_state = 16},
  [3040] = {.lex_state = 289, .external_lex_state = 5},
  [3041] = {.lex_state = 236, .external_lex_state = 16},
  [3042] = {.lex_state = 289, .external_lex_state = 5},
  [3043] = {.lex_state = 236, .external_lex_state = 16},
  [3044] = {.lex_state = 289, .external_lex_state = 5},
  [3045] = {.lex_state = 236, .external_lex_state = 16},
  [3046] = {.lex_state = 289, .external_lex_state = 5},
  [3047] = {.lex_state = 289, .external_lex_state = 5},
  [3048] = {.lex_state = 295, .external_lex_state = 5},
  [3049] = {.lex_state = 295, .external_lex_state = 5},
  [3050] = {.lex_state = 295, .external_lex_state = 5},
  [3051] = {.lex_state = 166},
  [3052] = {.lex_state = 234, .external_lex_state = 16},
  [3053] = {.lex_state = 69},
  [3054] = {.lex_state = 174, .external_lex_state = 16},
  [3055] = {.lex_state = 174, .external_lex_state = 16},
  [3056] = {.lex_state = 174, .external_lex_state = 16},
  [3057] = {.lex_state = 295, .external_lex_state = 5},
  [3058] = {.lex_state = 238},
  [3059] = {.lex_state = 236, .external_lex_state = 16},
  [3060] = {.lex_state = 295, .external_lex_state = 5},
  [3061] = {.lex_state = 238},
  [3062] = {.lex_state = 236, .external_lex_state = 16},
  [3063] = {.lex_state = 295, .external_lex_state = 5},
  [3064] = {.lex_state = 238},
  [3065] = {.lex_state = 236, .external_lex_state = 16},
  [3066] = {.lex_state = 295, .external_lex_state = 5},
  [3067] = {.lex_state = 218, .external_lex_state = 2},
  [3068] = {.lex_state = 137, .external_lex_state = 4},
  [3069] = {.lex_state = 141, .external_lex_state = 8},
  [3070] = {.lex_state = 63, .external_lex_state = 2},
  [3071] = {.lex_state = 90, .external_lex_state = 4},
  [3072] = {.lex_state = 122, .external_lex_state = 8},
  [3073] = {.lex_state = 295, .external_lex_state = 5},
  [3074] = {.lex_state = 218, .external_lex_state = 2},
  [3075] = {.lex_state = 137, .external_lex_state = 4},
  [3076] = {.lex_state = 141, .external_lex_state = 8},
  [3077] = {.lex_state = 267, .external_lex_state = 2},
  [3078] = {.lex_state = 80},
  [3079] = {.lex_state = 90, .external_lex_state = 4},
  [3080] = {.lex_state = 122, .external_lex_state = 8},
  [3081] = {.lex_state = 267, .external_lex_state = 2},
  [3082] = {.lex_state = 80},
  [3083] = {.lex_state = 90, .external_lex_state = 4},
  [3084] = {.lex_state = 122, .external_lex_state = 8},
  [3085] = {.lex_state = 247, .external_lex_state = 23},
  [3086] = {.lex_state = 247, .external_lex_state = 23},
  [3087] = {.lex_state = 247, .external_lex_state = 23},
  [3088] = {.lex_state = 293, .external_lex_state = 19},
  [3089] = {.lex_state = 293, .external_lex_state = 19},
  [3090] = {.lex_state = 213, .external_lex_state = 22},
  [3091] = {.lex_state = 213, .external_lex_state = 22},
  [3092] = {.lex_state = 213, .external_lex_state = 16},
  [3093] = {.lex_state = 234, .external_lex_state = 16},
  [3094] = {.lex_state = 293, .external_lex_state = 19},
  [3095] = {.lex_state = 238},
  [3096] = {.lex_state = 236, .external_lex_state = 16},
  [3097] = {.lex_state = 293, .external_lex_state = 19},
  [3098] = {.lex_state = 238},
  [3099] = {.lex_state = 236, .external_lex_state = 16},
  [3100] = {.lex_state = 238},
  [3101] = {.lex_state = 236, .external_lex_state = 16},
  [3102] = {.lex_state = 236, .external_lex_state = 16},
  [3103] = {.lex_state = 293, .external_lex_state = 19},
  [3104] = {.lex_state = 236, .external_lex_state = 16},
  [3105] = {.lex_state = 293, .external_lex_state = 19},
  [3106] = {.lex_state = 236, .external_lex_state = 16},
  [3107] = {.lex_state = 293, .external_lex_state = 19},
  [3108] = {.lex_state = 218, .external_lex_state = 2},
  [3109] = {.lex_state = 63, .external_lex_state = 2},
  [3110] = {.lex_state = 293, .external_lex_state = 19},
  [3111] = {.lex_state = 218, .external_lex_state = 2},
  [3112] = {.lex_state = 277, .external_lex_state = 10},
  [3113] = {.lex_state = 277, .external_lex_state = 10},
  [3114] = {.lex_state = 277, .external_lex_state = 10},
  [3115] = {.lex_state = 295, .external_lex_state = 23},
  [3116] = {.lex_state = 295, .external_lex_state = 23},
  [3117] = {.lex_state = 295, .external_lex_state = 23},
  [3118] = {.lex_state = 283, .external_lex_state = 3},
  [3119] = {.lex_state = 283, .external_lex_state = 14},
  [3120] = {.lex_state = 283, .external_lex_state = 14},
  [3121] = {.lex_state = 213, .external_lex_state = 22},
  [3122] = {.lex_state = 213, .external_lex_state = 22},
  [3123] = {.lex_state = 213, .external_lex_state = 16},
  [3124] = {.lex_state = 236, .external_lex_state = 16},
  [3125] = {.lex_state = 283, .external_lex_state = 14},
  [3126] = {.lex_state = 236, .external_lex_state = 16},
  [3127] = {.lex_state = 283, .external_lex_state = 14},
  [3128] = {.lex_state = 236, .external_lex_state = 16},
  [3129] = {.lex_state = 283, .external_lex_state = 14},
  [3130] = {.lex_state = 236, .external_lex_state = 16},
  [3131] = {.lex_state = 283, .external_lex_state = 14},
  [3132] = {.lex_state = 236, .external_lex_state = 16},
  [3133] = {.lex_state = 283, .external_lex_state = 14},
  [3134] = {.lex_state = 236, .external_lex_state = 16},
  [3135] = {.lex_state = 283, .external_lex_state = 14},
  [3136] = {.lex_state = 283, .external_lex_state = 14},
  [3137] = {.lex_state = 283, .external_lex_state = 10},
  [3138] = {.lex_state = 283, .external_lex_state = 10},
  [3139] = {.lex_state = 213, .external_lex_state = 22},
  [3140] = {.lex_state = 213, .external_lex_state = 22},
  [3141] = {.lex_state = 213, .external_lex_state = 16},
  [3142] = {.lex_state = 236, .external_lex_state = 16},
  [3143] = {.lex_state = 283, .external_lex_state = 10},
  [3144] = {.lex_state = 236, .external_lex_state = 16},
  [3145] = {.lex_state = 283, .external_lex_state = 10},
  [3146] = {.lex_state = 236, .external_lex_state = 16},
  [3147] = {.lex_state = 283, .external_lex_state = 10},
  [3148] = {.lex_state = 236, .external_lex_state = 16},
  [3149] = {.lex_state = 283, .external_lex_state = 10},
  [3150] = {.lex_state = 236, .external_lex_state = 16},
  [3151] = {.lex_state = 283, .external_lex_state = 10},
  [3152] = {.lex_state = 236, .external_lex_state = 16},
  [3153] = {.lex_state = 283, .external_lex_state = 10},
  [3154] = {.lex_state = 283, .external_lex_state = 10},
  [3155] = {.lex_state = 289, .external_lex_state = 5},
  [3156] = {.lex_state = 289, .external_lex_state = 5},
  [3157] = {.lex_state = 289, .external_lex_state = 5},
  [3158] = {.lex_state = 236, .external_lex_state = 16},
  [3159] = {.lex_state = 289, .external_lex_state = 5},
  [3160] = {.lex_state = 236, .external_lex_state = 16},
  [3161] = {.lex_state = 289, .external_lex_state = 5},
  [3162] = {.lex_state = 236, .external_lex_state = 16},
  [3163] = {.lex_state = 289, .external_lex_state = 5},
  [3164] = {.lex_state = 289, .external_lex_state = 5},
  [3165] = {.lex_state = 289, .external_lex_state = 5},
  [3166] = {.lex_state = 295, .external_lex_state = 5},
  [3167] = {.lex_state = 295, .external_lex_state = 5},
  [3168] = {.lex_state = 213, .external_lex_state = 22},
  [3169] = {.lex_state = 213, .external_lex_state = 22},
  [3170] = {.lex_state = 213, .external_lex_state = 16},
  [3171] = {.lex_state = 234, .external_lex_state = 16},
  [3172] = {.lex_state = 295, .external_lex_state = 5},
  [3173] = {.lex_state = 238},
  [3174] = {.lex_state = 236, .external_lex_state = 16},
  [3175] = {.lex_state = 295, .external_lex_state = 5},
  [3176] = {.lex_state = 238},
  [3177] = {.lex_state = 236, .external_lex_state = 16},
  [3178] = {.lex_state = 238},
  [3179] = {.lex_state = 236, .external_lex_state = 16},
  [3180] = {.lex_state = 236, .external_lex_state = 16},
  [3181] = {.lex_state = 295, .external_lex_state = 5},
  [3182] = {.lex_state = 236, .external_lex_state = 16},
  [3183] = {.lex_state = 295, .external_lex_state = 5},
  [3184] = {.lex_state = 236, .external_lex_state = 16},
  [3185] = {.lex_state = 295, .external_lex_state = 5},
  [3186] = {.lex_state = 218, .external_lex_state = 2},
  [3187] = {.lex_state = 63, .external_lex_state = 2},
  [3188] = {.lex_state = 295, .external_lex_state = 5},
  [3189] = {.lex_state = 218, .external_lex_state = 2},
  [3190] = {.lex_state = 267, .external_lex_state = 2},
  [3191] = {.lex_state = 267, .external_lex_state = 2},
  [3192] = {.lex_state = 293, .external_lex_state = 19},
  [3193] = {.lex_state = 293, .external_lex_state = 19},
  [3194] = {.lex_state = 213, .external_lex_state = 22},
  [3195] = {.lex_state = 213, .external_lex_state = 22},
  [3196] = {.lex_state = 213, .external_lex_state = 16},
  [3197] = {.lex_state = 236, .external_lex_state = 16},
  [3198] = {.lex_state = 293, .external_lex_state = 19},
  [3199] = {.lex_state = 236, .external_lex_state = 16},
  [3200] = {.lex_state = 293, .external_lex_state = 19},
  [3201] = {.lex_state = 236, .external_lex_state = 16},
  [3202] = {.lex_state = 293, .external_lex_state = 19},
  [3203] = {.lex_state = 236, .external_lex_state = 16},
  [3204] = {.lex_state = 293, .external_lex_state = 19},
  [3205] = {.lex_state = 236, .external_lex_state = 16},
  [3206] = {.lex_state = 293, .external_lex_state = 19},
  [3207] = {.lex_state = 236, .external_lex_state = 16},
  [3208] = {.lex_state = 293, .external_lex_state = 19},
  [3209] = {.lex_state = 293, .external_lex_state = 19},
  [3210] = {.lex_state = 277, .external_lex_state = 10},
  [3211] = {.lex_state = 295, .external_lex_state = 23},
  [3212] = {.lex_state = 283, .external_lex_state = 14},
  [3213] = {.lex_state = 283, .external_lex_state = 14},
  [3214] = {.lex_state = 283, .external_lex_state = 14},
  [3215] = {.lex_state = 236, .external_lex_state = 16},
  [3216] = {.lex_state = 283, .external_lex_state = 14},
  [3217] = {.lex_state = 236, .external_lex_state = 16},
  [3218] = {.lex_state = 283, .external_lex_state = 14},
  [3219] = {.lex_state = 236, .external_lex_state = 16},
  [3220] = {.lex_state = 283, .external_lex_state = 14},
  [3221] = {.lex_state = 283, .external_lex_state = 14},
  [3222] = {.lex_state = 283, .external_lex_state = 14},
  [3223] = {.lex_state = 283, .external_lex_state = 10},
  [3224] = {.lex_state = 283, .external_lex_state = 10},
  [3225] = {.lex_state = 283, .external_lex_state = 10},
  [3226] = {.lex_state = 236, .external_lex_state = 16},
  [3227] = {.lex_state = 283, .external_lex_state = 10},
  [3228] = {.lex_state = 236, .external_lex_state = 16},
  [3229] = {.lex_state = 283, .external_lex_state = 10},
  [3230] = {.lex_state = 236, .external_lex_state = 16},
  [3231] = {.lex_state = 283, .external_lex_state = 10},
  [3232] = {.lex_state = 283, .external_lex_state = 10},
  [3233] = {.lex_state = 283, .external_lex_state = 10},
  [3234] = {.lex_state = 289, .external_lex_state = 5},
  [3235] = {.lex_state = 289, .external_lex_state = 5},
  [3236] = {.lex_state = 289, .external_lex_state = 5},
  [3237] = {.lex_state = 295, .external_lex_state = 5},
  [3238] = {.lex_state = 295, .external_lex_state = 5},
  [3239] = {.lex_state = 213, .external_lex_state = 22},
  [3240] = {.lex_state = 213, .external_lex_state = 22},
  [3241] = {.lex_state = 213, .external_lex_state = 16},
  [3242] = {.lex_state = 236, .external_lex_state = 16},
  [3243] = {.lex_state = 295, .external_lex_state = 5},
  [3244] = {.lex_state = 236, .external_lex_state = 16},
  [3245] = {.lex_state = 295, .external_lex_state = 5},
  [3246] = {.lex_state = 236, .external_lex_state = 16},
  [3247] = {.lex_state = 295, .external_lex_state = 5},
  [3248] = {.lex_state = 236, .external_lex_state = 16},
  [3249] = {.lex_state = 295, .external_lex_state = 5},
  [3250] = {.lex_state = 236, .external_lex_state = 16},
  [3251] = {.lex_state = 295, .external_lex_state = 5},
  [3252] = {.lex_state = 236, .external_lex_state = 16},
  [3253] = {.lex_state = 295, .external_lex_state = 5},
  [3254] = {.lex_state = 295, .external_lex_state = 5},
  [3255] = {.lex_state = 293, .external_lex_state = 19},
  [3256] = {.lex_state = 293, .external_lex_state = 19},
  [3257] = {.lex_state = 293, .external_lex_state = 19},
  [3258] = {.lex_state = 236, .external_lex_state = 16},
  [3259] = {.lex_state = 293, .external_lex_state = 19},
  [3260] = {.lex_state = 236, .external_lex_state = 16},
  [3261] = {.lex_state = 293, .external_lex_state = 19},
  [3262] = {.lex_state = 236, .external_lex_state = 16},
  [3263] = {.lex_state = 293, .external_lex_state = 19},
  [3264] = {.lex_state = 293, .external_lex_state = 19},
  [3265] = {.lex_state = 293, .external_lex_state = 19},
  [3266] = {.lex_state = 283, .external_lex_state = 14},
  [3267] = {.lex_state = 283, .external_lex_state = 14},
  [3268] = {.lex_state = 283, .external_lex_state = 14},
  [3269] = {.lex_state = 283, .external_lex_state = 10},
  [3270] = {.lex_state = 283, .external_lex_state = 10},
  [3271] = {.lex_state = 283, .external_lex_state = 10},
  [3272] = {.lex_state = 295, .external_lex_state = 5},
  [3273] = {.lex_state = 295, .external_lex_state = 5},
  [3274] = {.lex_state = 295, .external_lex_state = 5},
  [3275] = {.lex_state = 236, .external_lex_state = 16},
  [3276] = {.lex_state = 295, .external_lex_state = 5},
  [3277] = {.lex_state = 236, .external_lex_state = 16},
  [3278] = {.lex_state = 295, .external_lex_state = 5},
  [3279] = {.lex_state = 236, .external_lex_state = 16},
  [3280] = {.lex_state = 295, .external_lex_state = 5},
  [3281] = {.lex_state = 295, .external_lex_state = 5},
  [3282] = {.lex_state = 295, .external_lex_state = 5},
  [3283] = {.lex_state = 293, .external_lex_state = 19},
  [3284] = {.lex_state = 293, .external_lex_state = 19},
  [3285] = {.lex_state = 293, .external_lex_state = 19},
  [3286] = {.lex_state = 295, .external_lex_state = 5},
  [3287] = {.lex_state = 295, .external_lex_state = 5},
  [3288] = {.lex_state = 295, .external_lex_state = 5},
};

enum {
  ts_external_token_heredoc_start,
  ts_external_token__simple_heredoc_body,
  ts_external_token__heredoc_body_beginning,
  ts_external_token__heredoc_body_middle,
  ts_external_token__heredoc_body_end,
  ts_external_token_file_descriptor,
  ts_external_token__empty_value,
  ts_external_token__concat,
  ts_external_token_variable_name,
  ts_external_token_RBRACE,
  ts_external_token_RBRACK,
  ts_external_token_LF,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_heredoc_start] = sym_heredoc_start,
  [ts_external_token__simple_heredoc_body] = sym__simple_heredoc_body,
  [ts_external_token__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [ts_external_token__heredoc_body_middle] = sym__heredoc_body_middle,
  [ts_external_token__heredoc_body_end] = sym__heredoc_body_end,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__empty_value] = sym__empty_value,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token_variable_name] = sym_variable_name,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_LF] = anon_sym_LF,
};

static bool ts_external_scanner_states[24][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_heredoc_start] = true,
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__empty_value] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_LF] = true,
  },
  [2] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [3] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [4] = {
    [ts_external_token_LF] = true,
  },
  [5] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [6] = {
    [ts_external_token_variable_name] = true,
  },
  [7] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LF] = true,
  },
  [8] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [9] = {
    [ts_external_token__empty_value] = true,
  },
  [10] = {
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [11] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACK] = true,
  },
  [12] = {
    [ts_external_token_RBRACK] = true,
  },
  [13] = {
    [ts_external_token__concat] = true,
  },
  [14] = {
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [15] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
  },
  [16] = {
    [ts_external_token_RBRACE] = true,
  },
  [17] = {
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
  },
  [18] = {
    [ts_external_token_heredoc_start] = true,
  },
  [19] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [20] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [21] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LF] = true,
  },
  [22] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACE] = true,
  },
  [23] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
};

static uint16_t ts_parse_table[STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_heredoc_start] = ACTIONS(1),
    [sym__simple_heredoc_body] = ACTIONS(1),
    [sym__heredoc_body_beginning] = ACTIONS(1),
    [sym__heredoc_body_middle] = ACTIONS(1),
    [sym__heredoc_body_end] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [sym__empty_value] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym_variable_name] = ACTIONS(1),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(3),
    [anon_sym_done] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_fi] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_esac] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PIPE_AMP] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_typeset] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_unset] = ACTIONS(3),
    [anon_sym_unsetenv] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(3),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(3),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_GT] = ACTIONS(3),
    [anon_sym_AMP_GT_GT] = ACTIONS(1),
    [anon_sym_LT_AMP] = ACTIONS(1),
    [anon_sym_GT_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(3),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_LT] = ACTIONS(1),
    [sym__special_characters] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(3),
    [sym_raw_string] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(3),
    [anon_sym_COLON_QMARK] = ACTIONS(1),
    [anon_sym_COLON_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LT_LPAREN] = ACTIONS(1),
    [anon_sym_GT_LPAREN] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(25),
    [sym__terminated_statement] = STATE(32),
    [sym_for_statement] = STATE(26),
    [sym_c_style_for_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym_subshell] = STATE(26),
    [sym_pipeline] = STATE(26),
    [sym_list] = STATE(26),
    [sym_negated_command] = STATE(26),
    [sym_test_command] = STATE(26),
    [sym_declaration_command] = STATE(26),
    [sym_unset_command] = STATE(26),
    [sym_command] = STATE(26),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(28),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym__statements_repeat1] = STATE(32),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [ts_builtin_sym_end] = ACTIONS(9),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [2] = {
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(57),
    [anon_sym_GT_GT] = ACTIONS(59),
    [anon_sym_AMP_GT] = ACTIONS(57),
    [anon_sym_AMP_GT_GT] = ACTIONS(59),
    [anon_sym_LT_AMP] = ACTIONS(59),
    [anon_sym_GT_AMP] = ACTIONS(59),
    [sym_comment] = ACTIONS(53),
  },
  [3] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(63),
    [anon_sym_PLUS_EQ] = ACTIONS(63),
    [sym_comment] = ACTIONS(53),
  },
  [4] = {
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(67),
  },
  [5] = {
    [sym__terminated_statement] = STATE(50),
    [sym_for_statement] = STATE(51),
    [sym_c_style_for_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_case_statement] = STATE(51),
    [sym_function_definition] = STATE(51),
    [sym_subshell] = STATE(51),
    [sym_pipeline] = STATE(51),
    [sym_list] = STATE(51),
    [sym_negated_command] = STATE(51),
    [sym_test_command] = STATE(51),
    [sym_declaration_command] = STATE(51),
    [sym_unset_command] = STATE(51),
    [sym_command] = STATE(51),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(53),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [6] = {
    [sym__terminated_statement] = STATE(56),
    [sym_for_statement] = STATE(51),
    [sym_c_style_for_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_case_statement] = STATE(51),
    [sym_function_definition] = STATE(51),
    [sym_subshell] = STATE(51),
    [sym_pipeline] = STATE(51),
    [sym_list] = STATE(51),
    [sym_negated_command] = STATE(51),
    [sym_test_command] = STATE(51),
    [sym_declaration_command] = STATE(51),
    [sym_unset_command] = STATE(51),
    [sym_command] = STATE(51),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(53),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [7] = {
    [sym_concatenation] = STATE(65),
    [sym_string] = STATE(60),
    [sym_simple_expansion] = STATE(60),
    [sym_string_expansion] = STATE(60),
    [sym_expansion] = STATE(60),
    [sym_command_substitution] = STATE(60),
    [sym_process_substitution] = STATE(60),
    [sym__special_characters] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym_raw_string] = ACTIONS(97),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(99),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_BQUOTE] = ACTIONS(103),
    [anon_sym_LT_LPAREN] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(105),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(97),
  },
  [8] = {
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(107),
  },
  [9] = {
    [sym__terminated_statement] = STATE(82),
    [sym_for_statement] = STATE(78),
    [sym_c_style_for_statement] = STATE(78),
    [sym_while_statement] = STATE(78),
    [sym_if_statement] = STATE(78),
    [sym_case_statement] = STATE(78),
    [sym_function_definition] = STATE(78),
    [sym_subshell] = STATE(78),
    [sym_pipeline] = STATE(78),
    [sym_list] = STATE(78),
    [sym_negated_command] = STATE(78),
    [sym_test_command] = STATE(78),
    [sym_declaration_command] = STATE(78),
    [sym_unset_command] = STATE(78),
    [sym_command] = STATE(78),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(80),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(82),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [10] = {
    [sym_subshell] = STATE(85),
    [sym_test_command] = STATE(85),
    [sym_command] = STATE(85),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(86),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(43),
  },
  [11] = {
    [sym__expression] = STATE(97),
    [sym_binary_expression] = STATE(97),
    [sym_unary_expression] = STATE(97),
    [sym_parenthesized_expression] = STATE(97),
    [sym_concatenation] = STATE(97),
    [sym_string] = STATE(92),
    [sym_simple_expansion] = STATE(92),
    [sym_string_expansion] = STATE(92),
    [sym_expansion] = STATE(92),
    [sym_command_substitution] = STATE(92),
    [sym_process_substitution] = STATE(92),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [12] = {
    [sym__expression] = STATE(108),
    [sym_binary_expression] = STATE(108),
    [sym_unary_expression] = STATE(108),
    [sym_parenthesized_expression] = STATE(108),
    [sym_concatenation] = STATE(108),
    [sym_string] = STATE(103),
    [sym_simple_expansion] = STATE(103),
    [sym_string_expansion] = STATE(103),
    [sym_expansion] = STATE(103),
    [sym_command_substitution] = STATE(103),
    [sym_process_substitution] = STATE(103),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [sym__special_characters] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(167),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(177),
    [sym_test_operator] = ACTIONS(179),
  },
  [13] = {
    [sym_variable_assignment] = STATE(120),
    [sym_subscript] = STATE(119),
    [sym_concatenation] = STATE(120),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [aux_sym_declaration_command_repeat1] = STATE(120),
    [sym_variable_name] = ACTIONS(181),
    [ts_builtin_sym_end] = ACTIONS(183),
    [anon_sym_PIPE] = ACTIONS(185),
    [anon_sym_SEMI_SEMI] = ACTIONS(183),
    [anon_sym_PIPE_AMP] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [sym__special_characters] = ACTIONS(187),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(193),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(203),
    [sym_word] = ACTIONS(205),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(183),
    [anon_sym_AMP] = ACTIONS(185),
  },
  [14] = {
    [sym_concatenation] = STATE(130),
    [sym_string] = STATE(124),
    [sym_simple_expansion] = STATE(124),
    [sym_string_expansion] = STATE(124),
    [sym_expansion] = STATE(124),
    [sym_command_substitution] = STATE(124),
    [sym_process_substitution] = STATE(124),
    [aux_sym_unset_command_repeat1] = STATE(130),
    [ts_builtin_sym_end] = ACTIONS(207),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_SEMI_SEMI] = ACTIONS(207),
    [anon_sym_PIPE_AMP] = ACTIONS(207),
    [anon_sym_AMP_AMP] = ACTIONS(207),
    [anon_sym_PIPE_PIPE] = ACTIONS(207),
    [sym__special_characters] = ACTIONS(211),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(227),
    [sym_word] = ACTIONS(229),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_LF] = ACTIONS(207),
    [anon_sym_AMP] = ACTIONS(209),
  },
  [15] = {
    [sym_concatenation] = STATE(139),
    [sym_string] = STATE(134),
    [sym_simple_expansion] = STATE(134),
    [sym_string_expansion] = STATE(134),
    [sym_expansion] = STATE(134),
    [sym_command_substitution] = STATE(134),
    [sym_process_substitution] = STATE(134),
    [sym__special_characters] = ACTIONS(231),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [anon_sym_DOLLAR] = ACTIONS(235),
    [sym_raw_string] = ACTIONS(237),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(239),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(241),
    [anon_sym_BQUOTE] = ACTIONS(243),
    [anon_sym_LT_LPAREN] = ACTIONS(245),
    [anon_sym_GT_LPAREN] = ACTIONS(245),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(237),
  },
  [16] = {
    [aux_sym_concatenation_repeat1] = STATE(141),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(247),
    [anon_sym_PIPE] = ACTIONS(251),
    [anon_sym_SEMI_SEMI] = ACTIONS(247),
    [anon_sym_PIPE_AMP] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_EQ_TILDE] = ACTIONS(251),
    [anon_sym_EQ_EQ] = ACTIONS(251),
    [anon_sym_LT] = ACTIONS(251),
    [anon_sym_GT] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(247),
    [anon_sym_AMP_GT] = ACTIONS(251),
    [anon_sym_AMP_GT_GT] = ACTIONS(247),
    [anon_sym_LT_AMP] = ACTIONS(247),
    [anon_sym_GT_AMP] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(251),
    [anon_sym_LT_LT_DASH] = ACTIONS(247),
    [anon_sym_LT_LT_LT] = ACTIONS(247),
    [sym__special_characters] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(251),
    [sym_raw_string] = ACTIONS(247),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(247),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(247),
    [anon_sym_BQUOTE] = ACTIONS(247),
    [anon_sym_LT_LPAREN] = ACTIONS(247),
    [anon_sym_GT_LPAREN] = ACTIONS(247),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(251),
    [anon_sym_SEMI] = ACTIONS(251),
    [anon_sym_LF] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(251),
  },
  [17] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(148),
    [anon_sym_DQUOTE] = ACTIONS(253),
    [anon_sym_DOLLAR] = ACTIONS(255),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [18] = {
    [sym_string] = STATE(150),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [sym_raw_string] = ACTIONS(269),
    [anon_sym_POUND] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(271),
    [anon_sym_STAR] = ACTIONS(267),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_QMARK] = ACTIONS(267),
    [anon_sym_0] = ACTIONS(273),
    [anon_sym__] = ACTIONS(273),
  },
  [19] = {
    [aux_sym_concatenation_repeat1] = STATE(141),
    [sym__simple_heredoc_body] = ACTIONS(275),
    [sym__heredoc_body_beginning] = ACTIONS(275),
    [sym_file_descriptor] = ACTIONS(275),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(275),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_SEMI_SEMI] = ACTIONS(275),
    [anon_sym_PIPE_AMP] = ACTIONS(275),
    [anon_sym_AMP_AMP] = ACTIONS(275),
    [anon_sym_PIPE_PIPE] = ACTIONS(275),
    [anon_sym_EQ_TILDE] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_GT_GT] = ACTIONS(275),
    [anon_sym_AMP_GT] = ACTIONS(277),
    [anon_sym_AMP_GT_GT] = ACTIONS(275),
    [anon_sym_LT_AMP] = ACTIONS(275),
    [anon_sym_GT_AMP] = ACTIONS(275),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(275),
    [anon_sym_LT_LT_LT] = ACTIONS(275),
    [sym__special_characters] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(275),
    [anon_sym_DOLLAR] = ACTIONS(277),
    [sym_raw_string] = ACTIONS(275),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(275),
    [anon_sym_LT_LPAREN] = ACTIONS(275),
    [anon_sym_GT_LPAREN] = ACTIONS(275),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_LF] = ACTIONS(275),
    [anon_sym_AMP] = ACTIONS(277),
  },
  [20] = {
    [sym_subscript] = STATE(156),
    [sym_variable_name] = ACTIONS(279),
    [anon_sym_BANG] = ACTIONS(281),
    [anon_sym_DOLLAR] = ACTIONS(283),
    [anon_sym_POUND] = ACTIONS(281),
    [anon_sym_DASH] = ACTIONS(283),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(285),
    [anon_sym_STAR] = ACTIONS(283),
    [anon_sym_AT] = ACTIONS(283),
    [anon_sym_QMARK] = ACTIONS(283),
    [anon_sym_0] = ACTIONS(287),
    [anon_sym__] = ACTIONS(287),
  },
  [21] = {
    [sym__terminated_statement] = STATE(159),
    [sym_for_statement] = STATE(157),
    [sym_c_style_for_statement] = STATE(157),
    [sym_while_statement] = STATE(157),
    [sym_if_statement] = STATE(157),
    [sym_case_statement] = STATE(157),
    [sym_function_definition] = STATE(157),
    [sym_subshell] = STATE(157),
    [sym_pipeline] = STATE(157),
    [sym_list] = STATE(157),
    [sym_negated_command] = STATE(157),
    [sym_test_command] = STATE(157),
    [sym_declaration_command] = STATE(157),
    [sym_unset_command] = STATE(157),
    [sym_command] = STATE(157),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(158),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(159),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [22] = {
    [sym__terminated_statement] = STATE(171),
    [sym_for_statement] = STATE(168),
    [sym_c_style_for_statement] = STATE(168),
    [sym_while_statement] = STATE(168),
    [sym_if_statement] = STATE(168),
    [sym_case_statement] = STATE(168),
    [sym_function_definition] = STATE(168),
    [sym_subshell] = STATE(168),
    [sym_pipeline] = STATE(168),
    [sym_list] = STATE(168),
    [sym_negated_command] = STATE(168),
    [sym_test_command] = STATE(168),
    [sym_declaration_command] = STATE(168),
    [sym_unset_command] = STATE(168),
    [sym_command] = STATE(168),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(170),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(171),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [23] = {
    [sym__terminated_statement] = STATE(175),
    [sym_for_statement] = STATE(173),
    [sym_c_style_for_statement] = STATE(173),
    [sym_while_statement] = STATE(173),
    [sym_if_statement] = STATE(173),
    [sym_case_statement] = STATE(173),
    [sym_function_definition] = STATE(173),
    [sym_subshell] = STATE(173),
    [sym_pipeline] = STATE(173),
    [sym_list] = STATE(173),
    [sym_negated_command] = STATE(173),
    [sym_test_command] = STATE(173),
    [sym_declaration_command] = STATE(173),
    [sym_unset_command] = STATE(173),
    [sym_command] = STATE(173),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(174),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(175),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [24] = {
    [aux_sym_concatenation_repeat1] = STATE(141),
    [sym__simple_heredoc_body] = ACTIONS(275),
    [sym__heredoc_body_beginning] = ACTIONS(275),
    [sym_file_descriptor] = ACTIONS(275),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(275),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_SEMI_SEMI] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(305),
    [anon_sym_PIPE_AMP] = ACTIONS(275),
    [anon_sym_AMP_AMP] = ACTIONS(275),
    [anon_sym_PIPE_PIPE] = ACTIONS(275),
    [anon_sym_EQ_TILDE] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_GT_GT] = ACTIONS(275),
    [anon_sym_AMP_GT] = ACTIONS(277),
    [anon_sym_AMP_GT_GT] = ACTIONS(275),
    [anon_sym_LT_AMP] = ACTIONS(275),
    [anon_sym_GT_AMP] = ACTIONS(275),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(275),
    [anon_sym_LT_LT_LT] = ACTIONS(275),
    [sym__special_characters] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(275),
    [anon_sym_DOLLAR] = ACTIONS(277),
    [sym_raw_string] = ACTIONS(275),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(275),
    [anon_sym_LT_LPAREN] = ACTIONS(275),
    [anon_sym_GT_LPAREN] = ACTIONS(275),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_LF] = ACTIONS(275),
    [anon_sym_AMP] = ACTIONS(277),
  },
  [25] = {
    [ts_builtin_sym_end] = ACTIONS(307),
    [sym_comment] = ACTIONS(53),
  },
  [26] = {
    [ts_builtin_sym_end] = ACTIONS(309),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_SEMI_SEMI] = ACTIONS(313),
    [anon_sym_PIPE_AMP] = ACTIONS(315),
    [anon_sym_AMP_AMP] = ACTIONS(317),
    [anon_sym_PIPE_PIPE] = ACTIONS(317),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_LF] = ACTIONS(313),
    [anon_sym_AMP] = ACTIONS(319),
  },
  [27] = {
    [sym_file_redirect] = STATE(190),
    [sym_heredoc_redirect] = STATE(190),
    [sym_heredoc_body] = STATE(189),
    [sym_herestring_redirect] = STATE(190),
    [sym_concatenation] = STATE(191),
    [sym_string] = STATE(188),
    [sym_simple_expansion] = STATE(188),
    [sym_string_expansion] = STATE(188),
    [sym_expansion] = STATE(188),
    [sym_command_substitution] = STATE(188),
    [sym_process_substitution] = STATE(188),
    [aux_sym_while_statement_repeat1] = STATE(190),
    [aux_sym_command_repeat2] = STATE(191),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(325),
    [ts_builtin_sym_end] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(327),
    [anon_sym_PIPE_AMP] = ACTIONS(327),
    [anon_sym_AMP_AMP] = ACTIONS(327),
    [anon_sym_PIPE_PIPE] = ACTIONS(327),
    [anon_sym_EQ_TILDE] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(331),
    [anon_sym_LT] = ACTIONS(333),
    [anon_sym_GT] = ACTIONS(333),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(341),
    [sym__special_characters] = ACTIONS(343),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(347),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_LF] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(329),
  },
  [28] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [ts_builtin_sym_end] = ACTIONS(309),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_SEMI_SEMI] = ACTIONS(313),
    [anon_sym_PIPE_AMP] = ACTIONS(315),
    [anon_sym_AMP_AMP] = ACTIONS(317),
    [anon_sym_PIPE_PIPE] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_LF] = ACTIONS(313),
    [anon_sym_AMP] = ACTIONS(319),
  },
  [29] = {
    [anon_sym_EQ] = ACTIONS(63),
    [anon_sym_PLUS_EQ] = ACTIONS(63),
    [sym_comment] = ACTIONS(53),
  },
  [30] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(349),
  },
  [31] = {
    [sym__simple_heredoc_body] = ACTIONS(275),
    [sym__heredoc_body_beginning] = ACTIONS(275),
    [sym_file_descriptor] = ACTIONS(275),
    [ts_builtin_sym_end] = ACTIONS(275),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_RPAREN] = ACTIONS(275),
    [anon_sym_SEMI_SEMI] = ACTIONS(275),
    [anon_sym_PIPE_AMP] = ACTIONS(275),
    [anon_sym_AMP_AMP] = ACTIONS(275),
    [anon_sym_PIPE_PIPE] = ACTIONS(275),
    [anon_sym_EQ_TILDE] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_GT_GT] = ACTIONS(275),
    [anon_sym_AMP_GT] = ACTIONS(277),
    [anon_sym_AMP_GT_GT] = ACTIONS(275),
    [anon_sym_LT_AMP] = ACTIONS(275),
    [anon_sym_GT_AMP] = ACTIONS(275),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(275),
    [anon_sym_LT_LT_LT] = ACTIONS(275),
    [sym__special_characters] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(275),
    [anon_sym_DOLLAR] = ACTIONS(277),
    [sym_raw_string] = ACTIONS(275),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(275),
    [anon_sym_LT_LPAREN] = ACTIONS(275),
    [anon_sym_GT_LPAREN] = ACTIONS(275),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_LF] = ACTIONS(275),
    [anon_sym_AMP] = ACTIONS(277),
  },
  [32] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(192),
    [sym_c_style_for_statement] = STATE(192),
    [sym_while_statement] = STATE(192),
    [sym_if_statement] = STATE(192),
    [sym_case_statement] = STATE(192),
    [sym_function_definition] = STATE(192),
    [sym_subshell] = STATE(192),
    [sym_pipeline] = STATE(192),
    [sym_list] = STATE(192),
    [sym_negated_command] = STATE(192),
    [sym_test_command] = STATE(192),
    [sym_declaration_command] = STATE(192),
    [sym_unset_command] = STATE(192),
    [sym_command] = STATE(192),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(193),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [33] = {
    [sym_command_name] = STATE(195),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(86),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(196),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(43),
  },
  [34] = {
    [sym_concatenation] = STATE(199),
    [sym_string] = STATE(198),
    [sym_simple_expansion] = STATE(198),
    [sym_string_expansion] = STATE(198),
    [sym_expansion] = STATE(198),
    [sym_command_substitution] = STATE(198),
    [sym_process_substitution] = STATE(198),
    [sym__special_characters] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [anon_sym_DOLLAR] = ACTIONS(235),
    [sym_raw_string] = ACTIONS(357),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(239),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(241),
    [anon_sym_BQUOTE] = ACTIONS(243),
    [anon_sym_LT_LPAREN] = ACTIONS(245),
    [anon_sym_GT_LPAREN] = ACTIONS(245),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(357),
  },
  [35] = {
    [sym_concatenation] = STATE(202),
    [sym_string] = STATE(201),
    [sym_simple_expansion] = STATE(201),
    [sym_string_expansion] = STATE(201),
    [sym_expansion] = STATE(201),
    [sym_command_substitution] = STATE(201),
    [sym_process_substitution] = STATE(201),
    [sym__special_characters] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(361),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(361),
  },
  [36] = {
    [sym_concatenation] = STATE(203),
    [sym_string] = STATE(208),
    [sym_array] = STATE(203),
    [sym_simple_expansion] = STATE(208),
    [sym_string_expansion] = STATE(208),
    [sym_expansion] = STATE(208),
    [sym_command_substitution] = STATE(208),
    [sym_process_substitution] = STATE(208),
    [sym__empty_value] = ACTIONS(363),
    [anon_sym_LPAREN] = ACTIONS(365),
    [sym__special_characters] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(373),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(375),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(377),
    [anon_sym_BQUOTE] = ACTIONS(379),
    [anon_sym_LT_LPAREN] = ACTIONS(381),
    [anon_sym_GT_LPAREN] = ACTIONS(381),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(373),
  },
  [37] = {
    [sym__expression] = STATE(224),
    [sym_binary_expression] = STATE(224),
    [sym_unary_expression] = STATE(224),
    [sym_parenthesized_expression] = STATE(224),
    [sym_concatenation] = STATE(224),
    [sym_string] = STATE(219),
    [sym_simple_expansion] = STATE(219),
    [sym_string_expansion] = STATE(219),
    [sym_expansion] = STATE(219),
    [sym_command_substitution] = STATE(219),
    [sym_process_substitution] = STATE(219),
    [anon_sym_SEMI_SEMI] = ACTIONS(383),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [sym__special_characters] = ACTIONS(389),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(395),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(397),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(401),
    [anon_sym_LT_LPAREN] = ACTIONS(403),
    [anon_sym_GT_LPAREN] = ACTIONS(403),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(405),
    [sym_test_operator] = ACTIONS(407),
    [anon_sym_SEMI] = ACTIONS(409),
    [anon_sym_LF] = ACTIONS(383),
    [anon_sym_AMP] = ACTIONS(383),
  },
  [38] = {
    [anon_sym_in] = ACTIONS(411),
    [anon_sym_SEMI_SEMI] = ACTIONS(413),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym_LF] = ACTIONS(413),
    [anon_sym_AMP] = ACTIONS(413),
  },
  [39] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(417),
    [anon_sym_PLUS_EQ] = ACTIONS(417),
    [sym_comment] = ACTIONS(53),
  },
  [40] = {
    [sym__terminated_statement] = STATE(228),
    [sym_for_statement] = STATE(51),
    [sym_c_style_for_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_case_statement] = STATE(51),
    [sym_function_definition] = STATE(51),
    [sym_subshell] = STATE(51),
    [sym_pipeline] = STATE(51),
    [sym_list] = STATE(51),
    [sym_negated_command] = STATE(51),
    [sym_test_command] = STATE(51),
    [sym_declaration_command] = STATE(51),
    [sym_unset_command] = STATE(51),
    [sym_command] = STATE(51),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(53),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [41] = {
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(419),
  },
  [42] = {
    [sym_subshell] = STATE(85),
    [sym_test_command] = STATE(85),
    [sym_command] = STATE(85),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(86),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(87),
  },
  [43] = {
    [sym__expression] = STATE(230),
    [sym_binary_expression] = STATE(230),
    [sym_unary_expression] = STATE(230),
    [sym_parenthesized_expression] = STATE(230),
    [sym_concatenation] = STATE(230),
    [sym_string] = STATE(92),
    [sym_simple_expansion] = STATE(92),
    [sym_string_expansion] = STATE(92),
    [sym_expansion] = STATE(92),
    [sym_command_substitution] = STATE(92),
    [sym_process_substitution] = STATE(92),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [44] = {
    [sym__expression] = STATE(231),
    [sym_binary_expression] = STATE(231),
    [sym_unary_expression] = STATE(231),
    [sym_parenthesized_expression] = STATE(231),
    [sym_concatenation] = STATE(231),
    [sym_string] = STATE(103),
    [sym_simple_expansion] = STATE(103),
    [sym_string_expansion] = STATE(103),
    [sym_expansion] = STATE(103),
    [sym_command_substitution] = STATE(103),
    [sym_process_substitution] = STATE(103),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [sym__special_characters] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(167),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(177),
    [sym_test_operator] = ACTIONS(179),
  },
  [45] = {
    [sym_variable_assignment] = STATE(236),
    [sym_subscript] = STATE(235),
    [sym_concatenation] = STATE(236),
    [sym_string] = STATE(234),
    [sym_simple_expansion] = STATE(234),
    [sym_string_expansion] = STATE(234),
    [sym_expansion] = STATE(234),
    [sym_command_substitution] = STATE(234),
    [sym_process_substitution] = STATE(234),
    [aux_sym_declaration_command_repeat1] = STATE(236),
    [sym_variable_name] = ACTIONS(421),
    [anon_sym_PIPE] = ACTIONS(185),
    [anon_sym_SEMI_SEMI] = ACTIONS(183),
    [anon_sym_PIPE_AMP] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [sym__special_characters] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(425),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(203),
    [sym_word] = ACTIONS(427),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(183),
    [anon_sym_AMP] = ACTIONS(185),
  },
  [46] = {
    [sym_concatenation] = STATE(239),
    [sym_string] = STATE(238),
    [sym_simple_expansion] = STATE(238),
    [sym_string_expansion] = STATE(238),
    [sym_expansion] = STATE(238),
    [sym_command_substitution] = STATE(238),
    [sym_process_substitution] = STATE(238),
    [aux_sym_unset_command_repeat1] = STATE(239),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_SEMI_SEMI] = ACTIONS(207),
    [anon_sym_PIPE_AMP] = ACTIONS(207),
    [anon_sym_AMP_AMP] = ACTIONS(207),
    [anon_sym_PIPE_PIPE] = ACTIONS(207),
    [sym__special_characters] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(431),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(227),
    [sym_word] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_LF] = ACTIONS(207),
    [anon_sym_AMP] = ACTIONS(209),
  },
  [47] = {
    [aux_sym_concatenation_repeat1] = STATE(240),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(251),
    [anon_sym_SEMI_SEMI] = ACTIONS(247),
    [anon_sym_PIPE_AMP] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_EQ_TILDE] = ACTIONS(251),
    [anon_sym_EQ_EQ] = ACTIONS(251),
    [anon_sym_LT] = ACTIONS(251),
    [anon_sym_GT] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(247),
    [anon_sym_AMP_GT] = ACTIONS(251),
    [anon_sym_AMP_GT_GT] = ACTIONS(247),
    [anon_sym_LT_AMP] = ACTIONS(247),
    [anon_sym_GT_AMP] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(251),
    [anon_sym_LT_LT_DASH] = ACTIONS(247),
    [anon_sym_LT_LT_LT] = ACTIONS(247),
    [sym__special_characters] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(251),
    [sym_raw_string] = ACTIONS(247),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(247),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(247),
    [anon_sym_BQUOTE] = ACTIONS(247),
    [anon_sym_LT_LPAREN] = ACTIONS(247),
    [anon_sym_GT_LPAREN] = ACTIONS(247),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(251),
    [anon_sym_SEMI] = ACTIONS(251),
    [anon_sym_LF] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(251),
  },
  [48] = {
    [aux_sym_concatenation_repeat1] = STATE(240),
    [sym__simple_heredoc_body] = ACTIONS(275),
    [sym__heredoc_body_beginning] = ACTIONS(275),
    [sym_file_descriptor] = ACTIONS(275),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_SEMI_SEMI] = ACTIONS(275),
    [anon_sym_PIPE_AMP] = ACTIONS(275),
    [anon_sym_AMP_AMP] = ACTIONS(275),
    [anon_sym_PIPE_PIPE] = ACTIONS(275),
    [anon_sym_EQ_TILDE] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_GT_GT] = ACTIONS(275),
    [anon_sym_AMP_GT] = ACTIONS(277),
    [anon_sym_AMP_GT_GT] = ACTIONS(275),
    [anon_sym_LT_AMP] = ACTIONS(275),
    [anon_sym_GT_AMP] = ACTIONS(275),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(275),
    [anon_sym_LT_LT_LT] = ACTIONS(275),
    [sym__special_characters] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(275),
    [anon_sym_DOLLAR] = ACTIONS(277),
    [sym_raw_string] = ACTIONS(275),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(275),
    [anon_sym_LT_LPAREN] = ACTIONS(275),
    [anon_sym_GT_LPAREN] = ACTIONS(275),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_LF] = ACTIONS(275),
    [anon_sym_AMP] = ACTIONS(277),
  },
  [49] = {
    [aux_sym_concatenation_repeat1] = STATE(240),
    [sym__simple_heredoc_body] = ACTIONS(275),
    [sym__heredoc_body_beginning] = ACTIONS(275),
    [sym_file_descriptor] = ACTIONS(275),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_SEMI_SEMI] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_PIPE_AMP] = ACTIONS(275),
    [anon_sym_AMP_AMP] = ACTIONS(275),
    [anon_sym_PIPE_PIPE] = ACTIONS(275),
    [anon_sym_EQ_TILDE] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_GT_GT] = ACTIONS(275),
    [anon_sym_AMP_GT] = ACTIONS(277),
    [anon_sym_AMP_GT_GT] = ACTIONS(275),
    [anon_sym_LT_AMP] = ACTIONS(275),
    [anon_sym_GT_AMP] = ACTIONS(275),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(275),
    [anon_sym_LT_LT_LT] = ACTIONS(275),
    [sym__special_characters] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(275),
    [anon_sym_DOLLAR] = ACTIONS(277),
    [sym_raw_string] = ACTIONS(275),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(275),
    [anon_sym_LT_LPAREN] = ACTIONS(275),
    [anon_sym_GT_LPAREN] = ACTIONS(275),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_LF] = ACTIONS(275),
    [anon_sym_AMP] = ACTIONS(277),
  },
  [50] = {
    [sym_do_group] = STATE(243),
    [anon_sym_do] = ACTIONS(437),
    [sym_comment] = ACTIONS(53),
  },
  [51] = {
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(441),
    [anon_sym_PIPE_AMP] = ACTIONS(443),
    [anon_sym_AMP_AMP] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(447),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(447),
  },
  [52] = {
    [sym_file_redirect] = STATE(253),
    [sym_heredoc_redirect] = STATE(253),
    [sym_heredoc_body] = STATE(189),
    [sym_herestring_redirect] = STATE(253),
    [sym_concatenation] = STATE(254),
    [sym_string] = STATE(252),
    [sym_simple_expansion] = STATE(252),
    [sym_string_expansion] = STATE(252),
    [sym_expansion] = STATE(252),
    [sym_command_substitution] = STATE(252),
    [sym_process_substitution] = STATE(252),
    [aux_sym_while_statement_repeat1] = STATE(253),
    [aux_sym_command_repeat2] = STATE(254),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(327),
    [anon_sym_PIPE_AMP] = ACTIONS(327),
    [anon_sym_AMP_AMP] = ACTIONS(327),
    [anon_sym_PIPE_PIPE] = ACTIONS(327),
    [anon_sym_EQ_TILDE] = ACTIONS(451),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(455),
    [anon_sym_AMP_GT] = ACTIONS(453),
    [anon_sym_AMP_GT_GT] = ACTIONS(455),
    [anon_sym_LT_AMP] = ACTIONS(455),
    [anon_sym_GT_AMP] = ACTIONS(455),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(457),
    [sym__special_characters] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(461),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_LF] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(329),
  },
  [53] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(441),
    [anon_sym_PIPE_AMP] = ACTIONS(443),
    [anon_sym_AMP_AMP] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(447),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(447),
  },
  [54] = {
    [anon_sym_EQ] = ACTIONS(417),
    [anon_sym_PLUS_EQ] = ACTIONS(417),
    [sym_comment] = ACTIONS(53),
  },
  [55] = {
    [sym_command_name] = STATE(255),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(86),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(196),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(87),
  },
  [56] = {
    [anon_sym_then] = ACTIONS(467),
    [sym_comment] = ACTIONS(53),
  },
  [57] = {
    [aux_sym_concatenation_repeat1] = STATE(260),
    [sym__concat] = ACTIONS(469),
    [anon_sym_in] = ACTIONS(471),
    [anon_sym_SEMI_SEMI] = ACTIONS(473),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(475),
    [anon_sym_LF] = ACTIONS(473),
    [anon_sym_AMP] = ACTIONS(473),
  },
  [58] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(263),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [anon_sym_DOLLAR] = ACTIONS(479),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [59] = {
    [sym_string] = STATE(265),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(481),
    [sym_raw_string] = ACTIONS(483),
    [anon_sym_POUND] = ACTIONS(481),
    [anon_sym_DASH] = ACTIONS(481),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(485),
    [anon_sym_STAR] = ACTIONS(481),
    [anon_sym_AT] = ACTIONS(481),
    [anon_sym_QMARK] = ACTIONS(481),
    [anon_sym_0] = ACTIONS(487),
    [anon_sym__] = ACTIONS(487),
  },
  [60] = {
    [aux_sym_concatenation_repeat1] = STATE(260),
    [sym__concat] = ACTIONS(469),
    [anon_sym_in] = ACTIONS(489),
    [anon_sym_SEMI_SEMI] = ACTIONS(491),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(493),
    [anon_sym_LF] = ACTIONS(491),
    [anon_sym_AMP] = ACTIONS(491),
  },
  [61] = {
    [sym_subscript] = STATE(273),
    [sym_variable_name] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(497),
    [anon_sym_DOLLAR] = ACTIONS(499),
    [anon_sym_POUND] = ACTIONS(497),
    [anon_sym_DASH] = ACTIONS(499),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(501),
    [anon_sym_STAR] = ACTIONS(499),
    [anon_sym_AT] = ACTIONS(499),
    [anon_sym_QMARK] = ACTIONS(499),
    [anon_sym_0] = ACTIONS(503),
    [anon_sym__] = ACTIONS(503),
  },
  [62] = {
    [sym__terminated_statement] = STATE(276),
    [sym_for_statement] = STATE(274),
    [sym_c_style_for_statement] = STATE(274),
    [sym_while_statement] = STATE(274),
    [sym_if_statement] = STATE(274),
    [sym_case_statement] = STATE(274),
    [sym_function_definition] = STATE(274),
    [sym_subshell] = STATE(274),
    [sym_pipeline] = STATE(274),
    [sym_list] = STATE(274),
    [sym_negated_command] = STATE(274),
    [sym_test_command] = STATE(274),
    [sym_declaration_command] = STATE(274),
    [sym_unset_command] = STATE(274),
    [sym_command] = STATE(274),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(275),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(276),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [63] = {
    [sym__terminated_statement] = STATE(279),
    [sym_for_statement] = STATE(277),
    [sym_c_style_for_statement] = STATE(277),
    [sym_while_statement] = STATE(277),
    [sym_if_statement] = STATE(277),
    [sym_case_statement] = STATE(277),
    [sym_function_definition] = STATE(277),
    [sym_subshell] = STATE(277),
    [sym_pipeline] = STATE(277),
    [sym_list] = STATE(277),
    [sym_negated_command] = STATE(277),
    [sym_test_command] = STATE(277),
    [sym_declaration_command] = STATE(277),
    [sym_unset_command] = STATE(277),
    [sym_command] = STATE(277),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(278),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(279),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [64] = {
    [sym__terminated_statement] = STATE(282),
    [sym_for_statement] = STATE(280),
    [sym_c_style_for_statement] = STATE(280),
    [sym_while_statement] = STATE(280),
    [sym_if_statement] = STATE(280),
    [sym_case_statement] = STATE(280),
    [sym_function_definition] = STATE(280),
    [sym_subshell] = STATE(280),
    [sym_pipeline] = STATE(280),
    [sym_list] = STATE(280),
    [sym_negated_command] = STATE(280),
    [sym_test_command] = STATE(280),
    [sym_declaration_command] = STATE(280),
    [sym_unset_command] = STATE(280),
    [sym_command] = STATE(280),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(281),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(282),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [65] = {
    [anon_sym_in] = ACTIONS(489),
    [anon_sym_SEMI_SEMI] = ACTIONS(491),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(493),
    [anon_sym_LF] = ACTIONS(491),
    [anon_sym_AMP] = ACTIONS(491),
  },
  [66] = {
    [sym_compound_statement] = STATE(285),
    [anon_sym_LPAREN] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [sym_comment] = ACTIONS(53),
  },
  [67] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(509),
    [anon_sym_PLUS_EQ] = ACTIONS(509),
    [sym_comment] = ACTIONS(53),
  },
  [68] = {
    [sym__terminated_statement] = STATE(287),
    [sym_for_statement] = STATE(51),
    [sym_c_style_for_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_case_statement] = STATE(51),
    [sym_function_definition] = STATE(51),
    [sym_subshell] = STATE(51),
    [sym_pipeline] = STATE(51),
    [sym_list] = STATE(51),
    [sym_negated_command] = STATE(51),
    [sym_test_command] = STATE(51),
    [sym_declaration_command] = STATE(51),
    [sym_unset_command] = STATE(51),
    [sym_command] = STATE(51),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(53),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [69] = {
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(511),
  },
  [70] = {
    [sym_subshell] = STATE(85),
    [sym_test_command] = STATE(85),
    [sym_command] = STATE(85),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(86),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(127),
  },
  [71] = {
    [sym__expression] = STATE(289),
    [sym_binary_expression] = STATE(289),
    [sym_unary_expression] = STATE(289),
    [sym_parenthesized_expression] = STATE(289),
    [sym_concatenation] = STATE(289),
    [sym_string] = STATE(92),
    [sym_simple_expansion] = STATE(92),
    [sym_string_expansion] = STATE(92),
    [sym_expansion] = STATE(92),
    [sym_command_substitution] = STATE(92),
    [sym_process_substitution] = STATE(92),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [72] = {
    [sym__expression] = STATE(290),
    [sym_binary_expression] = STATE(290),
    [sym_unary_expression] = STATE(290),
    [sym_parenthesized_expression] = STATE(290),
    [sym_concatenation] = STATE(290),
    [sym_string] = STATE(103),
    [sym_simple_expansion] = STATE(103),
    [sym_string_expansion] = STATE(103),
    [sym_expansion] = STATE(103),
    [sym_command_substitution] = STATE(103),
    [sym_process_substitution] = STATE(103),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [sym__special_characters] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(167),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(177),
    [sym_test_operator] = ACTIONS(179),
  },
  [73] = {
    [sym_variable_assignment] = STATE(295),
    [sym_subscript] = STATE(294),
    [sym_concatenation] = STATE(295),
    [sym_string] = STATE(293),
    [sym_simple_expansion] = STATE(293),
    [sym_string_expansion] = STATE(293),
    [sym_expansion] = STATE(293),
    [sym_command_substitution] = STATE(293),
    [sym_process_substitution] = STATE(293),
    [aux_sym_declaration_command_repeat1] = STATE(295),
    [sym_variable_name] = ACTIONS(513),
    [anon_sym_PIPE] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_SEMI_SEMI] = ACTIONS(183),
    [anon_sym_PIPE_AMP] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [sym__special_characters] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(517),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(203),
    [sym_word] = ACTIONS(519),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(183),
    [anon_sym_AMP] = ACTIONS(185),
  },
  [74] = {
    [sym_concatenation] = STATE(298),
    [sym_string] = STATE(297),
    [sym_simple_expansion] = STATE(297),
    [sym_string_expansion] = STATE(297),
    [sym_expansion] = STATE(297),
    [sym_command_substitution] = STATE(297),
    [sym_process_substitution] = STATE(297),
    [aux_sym_unset_command_repeat1] = STATE(298),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_RPAREN] = ACTIONS(207),
    [anon_sym_SEMI_SEMI] = ACTIONS(207),
    [anon_sym_PIPE_AMP] = ACTIONS(207),
    [anon_sym_AMP_AMP] = ACTIONS(207),
    [anon_sym_PIPE_PIPE] = ACTIONS(207),
    [sym__special_characters] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(523),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(227),
    [sym_word] = ACTIONS(525),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_LF] = ACTIONS(207),
    [anon_sym_AMP] = ACTIONS(209),
  },
  [75] = {
    [aux_sym_concatenation_repeat1] = STATE(299),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(251),
    [anon_sym_RPAREN] = ACTIONS(247),
    [anon_sym_SEMI_SEMI] = ACTIONS(247),
    [anon_sym_PIPE_AMP] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_EQ_TILDE] = ACTIONS(251),
    [anon_sym_EQ_EQ] = ACTIONS(251),
    [anon_sym_LT] = ACTIONS(251),
    [anon_sym_GT] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(247),
    [anon_sym_AMP_GT] = ACTIONS(251),
    [anon_sym_AMP_GT_GT] = ACTIONS(247),
    [anon_sym_LT_AMP] = ACTIONS(247),
    [anon_sym_GT_AMP] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(251),
    [anon_sym_LT_LT_DASH] = ACTIONS(247),
    [anon_sym_LT_LT_LT] = ACTIONS(247),
    [sym__special_characters] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(251),
    [sym_raw_string] = ACTIONS(247),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(247),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(247),
    [anon_sym_BQUOTE] = ACTIONS(247),
    [anon_sym_LT_LPAREN] = ACTIONS(247),
    [anon_sym_GT_LPAREN] = ACTIONS(247),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(251),
    [anon_sym_SEMI] = ACTIONS(251),
    [anon_sym_LF] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(251),
  },
  [76] = {
    [aux_sym_concatenation_repeat1] = STATE(299),
    [sym__simple_heredoc_body] = ACTIONS(275),
    [sym__heredoc_body_beginning] = ACTIONS(275),
    [sym_file_descriptor] = ACTIONS(275),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_RPAREN] = ACTIONS(275),
    [anon_sym_SEMI_SEMI] = ACTIONS(275),
    [anon_sym_PIPE_AMP] = ACTIONS(275),
    [anon_sym_AMP_AMP] = ACTIONS(275),
    [anon_sym_PIPE_PIPE] = ACTIONS(275),
    [anon_sym_EQ_TILDE] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_GT_GT] = ACTIONS(275),
    [anon_sym_AMP_GT] = ACTIONS(277),
    [anon_sym_AMP_GT_GT] = ACTIONS(275),
    [anon_sym_LT_AMP] = ACTIONS(275),
    [anon_sym_GT_AMP] = ACTIONS(275),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(275),
    [anon_sym_LT_LT_LT] = ACTIONS(275),
    [sym__special_characters] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(275),
    [anon_sym_DOLLAR] = ACTIONS(277),
    [sym_raw_string] = ACTIONS(275),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(275),
    [anon_sym_LT_LPAREN] = ACTIONS(275),
    [anon_sym_GT_LPAREN] = ACTIONS(275),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_LF] = ACTIONS(275),
    [anon_sym_AMP] = ACTIONS(277),
  },
  [77] = {
    [aux_sym_concatenation_repeat1] = STATE(299),
    [sym__simple_heredoc_body] = ACTIONS(275),
    [sym__heredoc_body_beginning] = ACTIONS(275),
    [sym_file_descriptor] = ACTIONS(275),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_RPAREN] = ACTIONS(275),
    [anon_sym_SEMI_SEMI] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(527),
    [anon_sym_PIPE_AMP] = ACTIONS(275),
    [anon_sym_AMP_AMP] = ACTIONS(275),
    [anon_sym_PIPE_PIPE] = ACTIONS(275),
    [anon_sym_EQ_TILDE] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_GT_GT] = ACTIONS(275),
    [anon_sym_AMP_GT] = ACTIONS(277),
    [anon_sym_AMP_GT_GT] = ACTIONS(275),
    [anon_sym_LT_AMP] = ACTIONS(275),
    [anon_sym_GT_AMP] = ACTIONS(275),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(275),
    [anon_sym_LT_LT_LT] = ACTIONS(275),
    [sym__special_characters] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(275),
    [anon_sym_DOLLAR] = ACTIONS(277),
    [sym_raw_string] = ACTIONS(275),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(275),
    [anon_sym_LT_LPAREN] = ACTIONS(275),
    [anon_sym_GT_LPAREN] = ACTIONS(275),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_LF] = ACTIONS(275),
    [anon_sym_AMP] = ACTIONS(277),
  },
  [78] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(531),
    [anon_sym_SEMI_SEMI] = ACTIONS(533),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_LF] = ACTIONS(533),
    [anon_sym_AMP] = ACTIONS(539),
  },
  [79] = {
    [sym_file_redirect] = STATE(311),
    [sym_heredoc_redirect] = STATE(311),
    [sym_heredoc_body] = STATE(189),
    [sym_herestring_redirect] = STATE(311),
    [sym_concatenation] = STATE(312),
    [sym_string] = STATE(310),
    [sym_simple_expansion] = STATE(310),
    [sym_string_expansion] = STATE(310),
    [sym_expansion] = STATE(310),
    [sym_command_substitution] = STATE(310),
    [sym_process_substitution] = STATE(310),
    [aux_sym_while_statement_repeat1] = STATE(311),
    [aux_sym_command_repeat2] = STATE(312),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(541),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_RPAREN] = ACTIONS(327),
    [anon_sym_SEMI_SEMI] = ACTIONS(327),
    [anon_sym_PIPE_AMP] = ACTIONS(327),
    [anon_sym_AMP_AMP] = ACTIONS(327),
    [anon_sym_PIPE_PIPE] = ACTIONS(327),
    [anon_sym_EQ_TILDE] = ACTIONS(543),
    [anon_sym_EQ_EQ] = ACTIONS(543),
    [anon_sym_LT] = ACTIONS(545),
    [anon_sym_GT] = ACTIONS(545),
    [anon_sym_GT_GT] = ACTIONS(547),
    [anon_sym_AMP_GT] = ACTIONS(545),
    [anon_sym_AMP_GT_GT] = ACTIONS(547),
    [anon_sym_LT_AMP] = ACTIONS(547),
    [anon_sym_GT_AMP] = ACTIONS(547),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(549),
    [sym__special_characters] = ACTIONS(551),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(553),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(555),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_LF] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(329),
  },
  [80] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(531),
    [anon_sym_SEMI_SEMI] = ACTIONS(533),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_LF] = ACTIONS(533),
    [anon_sym_AMP] = ACTIONS(539),
  },
  [81] = {
    [anon_sym_EQ] = ACTIONS(509),
    [anon_sym_PLUS_EQ] = ACTIONS(509),
    [sym_comment] = ACTIONS(53),
  },
  [82] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(313),
    [sym_c_style_for_statement] = STATE(313),
    [sym_while_statement] = STATE(313),
    [sym_if_statement] = STATE(313),
    [sym_case_statement] = STATE(313),
    [sym_function_definition] = STATE(313),
    [sym_subshell] = STATE(313),
    [sym_pipeline] = STATE(313),
    [sym_list] = STATE(313),
    [sym_negated_command] = STATE(313),
    [sym_test_command] = STATE(313),
    [sym_declaration_command] = STATE(313),
    [sym_unset_command] = STATE(313),
    [sym_command] = STATE(313),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(314),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [83] = {
    [sym_command_name] = STATE(315),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(86),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym_command_repeat1] = STATE(196),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(557),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(127),
  },
  [84] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(559),
    [anon_sym_PLUS_EQ] = ACTIONS(559),
    [sym_comment] = ACTIONS(53),
  },
  [85] = {
    [ts_builtin_sym_end] = ACTIONS(561),
    [anon_sym_esac] = ACTIONS(561),
    [anon_sym_PIPE] = ACTIONS(563),
    [anon_sym_RPAREN] = ACTIONS(561),
    [anon_sym_SEMI_SEMI] = ACTIONS(561),
    [anon_sym_PIPE_AMP] = ACTIONS(561),
    [anon_sym_AMP_AMP] = ACTIONS(561),
    [anon_sym_PIPE_PIPE] = ACTIONS(561),
    [anon_sym_BQUOTE] = ACTIONS(561),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(563),
    [anon_sym_LF] = ACTIONS(561),
    [anon_sym_AMP] = ACTIONS(563),
  },
  [86] = {
    [anon_sym_EQ] = ACTIONS(559),
    [anon_sym_PLUS_EQ] = ACTIONS(559),
    [sym_comment] = ACTIONS(53),
  },
  [87] = {
    [sym__expression] = STATE(320),
    [sym_binary_expression] = STATE(320),
    [sym_unary_expression] = STATE(320),
    [sym_parenthesized_expression] = STATE(320),
    [sym_concatenation] = STATE(320),
    [sym_string] = STATE(319),
    [sym_simple_expansion] = STATE(319),
    [sym_string_expansion] = STATE(319),
    [sym_expansion] = STATE(319),
    [sym_command_substitution] = STATE(319),
    [sym_process_substitution] = STATE(319),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(565),
    [sym__special_characters] = ACTIONS(567),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(569),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(571),
    [sym_test_operator] = ACTIONS(573),
  },
  [88] = {
    [sym__expression] = STATE(321),
    [sym_binary_expression] = STATE(321),
    [sym_unary_expression] = STATE(321),
    [sym_parenthesized_expression] = STATE(321),
    [sym_concatenation] = STATE(321),
    [sym_string] = STATE(92),
    [sym_simple_expansion] = STATE(92),
    [sym_string_expansion] = STATE(92),
    [sym_expansion] = STATE(92),
    [sym_command_substitution] = STATE(92),
    [sym_process_substitution] = STATE(92),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [89] = {
    [aux_sym_concatenation_repeat1] = STATE(323),
    [sym__concat] = ACTIONS(575),
    [anon_sym_AMP_AMP] = ACTIONS(577),
    [anon_sym_PIPE_PIPE] = ACTIONS(577),
    [anon_sym_RBRACK] = ACTIONS(577),
    [anon_sym_EQ_TILDE] = ACTIONS(577),
    [anon_sym_EQ_EQ] = ACTIONS(577),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_BANG_EQ] = ACTIONS(577),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(577),
  },
  [90] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(326),
    [anon_sym_DQUOTE] = ACTIONS(581),
    [anon_sym_DOLLAR] = ACTIONS(583),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [91] = {
    [sym_string] = STATE(328),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(585),
    [sym_raw_string] = ACTIONS(587),
    [anon_sym_POUND] = ACTIONS(585),
    [anon_sym_DASH] = ACTIONS(585),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(589),
    [anon_sym_STAR] = ACTIONS(585),
    [anon_sym_AT] = ACTIONS(585),
    [anon_sym_QMARK] = ACTIONS(585),
    [anon_sym_0] = ACTIONS(591),
    [anon_sym__] = ACTIONS(591),
  },
  [92] = {
    [aux_sym_concatenation_repeat1] = STATE(323),
    [sym__concat] = ACTIONS(575),
    [anon_sym_AMP_AMP] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_RBRACK] = ACTIONS(593),
    [anon_sym_EQ_TILDE] = ACTIONS(593),
    [anon_sym_EQ_EQ] = ACTIONS(593),
    [anon_sym_EQ] = ACTIONS(595),
    [anon_sym_LT] = ACTIONS(593),
    [anon_sym_GT] = ACTIONS(593),
    [anon_sym_BANG_EQ] = ACTIONS(593),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(593),
  },
  [93] = {
    [sym_subscript] = STATE(334),
    [sym_variable_name] = ACTIONS(597),
    [anon_sym_BANG] = ACTIONS(599),
    [anon_sym_DOLLAR] = ACTIONS(601),
    [anon_sym_POUND] = ACTIONS(599),
    [anon_sym_DASH] = ACTIONS(601),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(603),
    [anon_sym_STAR] = ACTIONS(601),
    [anon_sym_AT] = ACTIONS(601),
    [anon_sym_QMARK] = ACTIONS(601),
    [anon_sym_0] = ACTIONS(605),
    [anon_sym__] = ACTIONS(605),
  },
  [94] = {
    [sym__terminated_statement] = STATE(337),
    [sym_for_statement] = STATE(335),
    [sym_c_style_for_statement] = STATE(335),
    [sym_while_statement] = STATE(335),
    [sym_if_statement] = STATE(335),
    [sym_case_statement] = STATE(335),
    [sym_function_definition] = STATE(335),
    [sym_subshell] = STATE(335),
    [sym_pipeline] = STATE(335),
    [sym_list] = STATE(335),
    [sym_negated_command] = STATE(335),
    [sym_test_command] = STATE(335),
    [sym_declaration_command] = STATE(335),
    [sym_unset_command] = STATE(335),
    [sym_command] = STATE(335),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(336),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(337),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [95] = {
    [sym__terminated_statement] = STATE(340),
    [sym_for_statement] = STATE(338),
    [sym_c_style_for_statement] = STATE(338),
    [sym_while_statement] = STATE(338),
    [sym_if_statement] = STATE(338),
    [sym_case_statement] = STATE(338),
    [sym_function_definition] = STATE(338),
    [sym_subshell] = STATE(338),
    [sym_pipeline] = STATE(338),
    [sym_list] = STATE(338),
    [sym_negated_command] = STATE(338),
    [sym_test_command] = STATE(338),
    [sym_declaration_command] = STATE(338),
    [sym_unset_command] = STATE(338),
    [sym_command] = STATE(338),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(339),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(340),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [96] = {
    [sym__terminated_statement] = STATE(343),
    [sym_for_statement] = STATE(341),
    [sym_c_style_for_statement] = STATE(341),
    [sym_while_statement] = STATE(341),
    [sym_if_statement] = STATE(341),
    [sym_case_statement] = STATE(341),
    [sym_function_definition] = STATE(341),
    [sym_subshell] = STATE(341),
    [sym_pipeline] = STATE(341),
    [sym_list] = STATE(341),
    [sym_negated_command] = STATE(341),
    [sym_test_command] = STATE(341),
    [sym_declaration_command] = STATE(341),
    [sym_unset_command] = STATE(341),
    [sym_command] = STATE(341),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(342),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(343),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [97] = {
    [anon_sym_AMP_AMP] = ACTIONS(607),
    [anon_sym_PIPE_PIPE] = ACTIONS(607),
    [anon_sym_RBRACK] = ACTIONS(609),
    [anon_sym_EQ_TILDE] = ACTIONS(611),
    [anon_sym_EQ_EQ] = ACTIONS(611),
    [anon_sym_EQ] = ACTIONS(613),
    [anon_sym_LT] = ACTIONS(607),
    [anon_sym_GT] = ACTIONS(607),
    [anon_sym_BANG_EQ] = ACTIONS(607),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(607),
  },
  [98] = {
    [sym__expression] = STATE(347),
    [sym_binary_expression] = STATE(347),
    [sym_unary_expression] = STATE(347),
    [sym_parenthesized_expression] = STATE(347),
    [sym_concatenation] = STATE(347),
    [sym_string] = STATE(319),
    [sym_simple_expansion] = STATE(319),
    [sym_string_expansion] = STATE(319),
    [sym_expansion] = STATE(319),
    [sym_command_substitution] = STATE(319),
    [sym_process_substitution] = STATE(319),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(565),
    [sym__special_characters] = ACTIONS(567),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(569),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(571),
    [sym_test_operator] = ACTIONS(573),
  },
  [99] = {
    [sym__expression] = STATE(348),
    [sym_binary_expression] = STATE(348),
    [sym_unary_expression] = STATE(348),
    [sym_parenthesized_expression] = STATE(348),
    [sym_concatenation] = STATE(348),
    [sym_string] = STATE(103),
    [sym_simple_expansion] = STATE(103),
    [sym_string_expansion] = STATE(103),
    [sym_expansion] = STATE(103),
    [sym_command_substitution] = STATE(103),
    [sym_process_substitution] = STATE(103),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [sym__special_characters] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(167),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(177),
    [sym_test_operator] = ACTIONS(179),
  },
  [100] = {
    [aux_sym_concatenation_repeat1] = STATE(350),
    [sym__concat] = ACTIONS(615),
    [anon_sym_AMP_AMP] = ACTIONS(577),
    [anon_sym_PIPE_PIPE] = ACTIONS(577),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(577),
    [anon_sym_EQ_TILDE] = ACTIONS(577),
    [anon_sym_EQ_EQ] = ACTIONS(577),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_BANG_EQ] = ACTIONS(577),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(577),
  },
  [101] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(353),
    [anon_sym_DQUOTE] = ACTIONS(617),
    [anon_sym_DOLLAR] = ACTIONS(619),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [102] = {
    [sym_string] = STATE(355),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(621),
    [sym_raw_string] = ACTIONS(623),
    [anon_sym_POUND] = ACTIONS(621),
    [anon_sym_DASH] = ACTIONS(621),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(625),
    [anon_sym_STAR] = ACTIONS(621),
    [anon_sym_AT] = ACTIONS(621),
    [anon_sym_QMARK] = ACTIONS(621),
    [anon_sym_0] = ACTIONS(627),
    [anon_sym__] = ACTIONS(627),
  },
  [103] = {
    [aux_sym_concatenation_repeat1] = STATE(350),
    [sym__concat] = ACTIONS(615),
    [anon_sym_AMP_AMP] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(593),
    [anon_sym_EQ_TILDE] = ACTIONS(593),
    [anon_sym_EQ_EQ] = ACTIONS(593),
    [anon_sym_EQ] = ACTIONS(595),
    [anon_sym_LT] = ACTIONS(593),
    [anon_sym_GT] = ACTIONS(593),
    [anon_sym_BANG_EQ] = ACTIONS(593),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(593),
  },
  [104] = {
    [sym_subscript] = STATE(361),
    [sym_variable_name] = ACTIONS(629),
    [anon_sym_BANG] = ACTIONS(631),
    [anon_sym_DOLLAR] = ACTIONS(633),
    [anon_sym_POUND] = ACTIONS(631),
    [anon_sym_DASH] = ACTIONS(633),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(635),
    [anon_sym_STAR] = ACTIONS(633),
    [anon_sym_AT] = ACTIONS(633),
    [anon_sym_QMARK] = ACTIONS(633),
    [anon_sym_0] = ACTIONS(637),
    [anon_sym__] = ACTIONS(637),
  },
  [105] = {
    [sym__terminated_statement] = STATE(364),
    [sym_for_statement] = STATE(362),
    [sym_c_style_for_statement] = STATE(362),
    [sym_while_statement] = STATE(362),
    [sym_if_statement] = STATE(362),
    [sym_case_statement] = STATE(362),
    [sym_function_definition] = STATE(362),
    [sym_subshell] = STATE(362),
    [sym_pipeline] = STATE(362),
    [sym_list] = STATE(362),
    [sym_negated_command] = STATE(362),
    [sym_test_command] = STATE(362),
    [sym_declaration_command] = STATE(362),
    [sym_unset_command] = STATE(362),
    [sym_command] = STATE(362),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(363),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(364),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [106] = {
    [sym__terminated_statement] = STATE(367),
    [sym_for_statement] = STATE(365),
    [sym_c_style_for_statement] = STATE(365),
    [sym_while_statement] = STATE(365),
    [sym_if_statement] = STATE(365),
    [sym_case_statement] = STATE(365),
    [sym_function_definition] = STATE(365),
    [sym_subshell] = STATE(365),
    [sym_pipeline] = STATE(365),
    [sym_list] = STATE(365),
    [sym_negated_command] = STATE(365),
    [sym_test_command] = STATE(365),
    [sym_declaration_command] = STATE(365),
    [sym_unset_command] = STATE(365),
    [sym_command] = STATE(365),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(366),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(367),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [107] = {
    [sym__terminated_statement] = STATE(370),
    [sym_for_statement] = STATE(368),
    [sym_c_style_for_statement] = STATE(368),
    [sym_while_statement] = STATE(368),
    [sym_if_statement] = STATE(368),
    [sym_case_statement] = STATE(368),
    [sym_function_definition] = STATE(368),
    [sym_subshell] = STATE(368),
    [sym_pipeline] = STATE(368),
    [sym_list] = STATE(368),
    [sym_negated_command] = STATE(368),
    [sym_test_command] = STATE(368),
    [sym_declaration_command] = STATE(368),
    [sym_unset_command] = STATE(368),
    [sym_command] = STATE(368),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(369),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(370),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [108] = {
    [anon_sym_AMP_AMP] = ACTIONS(639),
    [anon_sym_PIPE_PIPE] = ACTIONS(639),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(609),
    [anon_sym_EQ_TILDE] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(641),
    [anon_sym_EQ] = ACTIONS(643),
    [anon_sym_LT] = ACTIONS(639),
    [anon_sym_GT] = ACTIONS(639),
    [anon_sym_BANG_EQ] = ACTIONS(639),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(639),
  },
  [109] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(645),
    [anon_sym_PLUS_EQ] = ACTIONS(645),
    [sym_comment] = ACTIONS(53),
  },
  [110] = {
    [aux_sym_concatenation_repeat1] = STATE(375),
    [sym__concat] = ACTIONS(647),
    [sym_variable_name] = ACTIONS(649),
    [ts_builtin_sym_end] = ACTIONS(649),
    [anon_sym_PIPE] = ACTIONS(651),
    [anon_sym_SEMI_SEMI] = ACTIONS(649),
    [anon_sym_PIPE_AMP] = ACTIONS(649),
    [anon_sym_AMP_AMP] = ACTIONS(649),
    [anon_sym_PIPE_PIPE] = ACTIONS(649),
    [sym__special_characters] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(649),
    [anon_sym_DOLLAR] = ACTIONS(651),
    [sym_raw_string] = ACTIONS(649),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(649),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(649),
    [anon_sym_BQUOTE] = ACTIONS(649),
    [anon_sym_LT_LPAREN] = ACTIONS(649),
    [anon_sym_GT_LPAREN] = ACTIONS(649),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(651),
    [sym_word] = ACTIONS(651),
    [anon_sym_SEMI] = ACTIONS(651),
    [anon_sym_LF] = ACTIONS(649),
    [anon_sym_AMP] = ACTIONS(651),
  },
  [111] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(378),
    [anon_sym_DQUOTE] = ACTIONS(653),
    [anon_sym_DOLLAR] = ACTIONS(655),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [112] = {
    [sym_string] = STATE(380),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(657),
    [sym_raw_string] = ACTIONS(659),
    [anon_sym_POUND] = ACTIONS(657),
    [anon_sym_DASH] = ACTIONS(657),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(661),
    [anon_sym_STAR] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(657),
    [anon_sym_QMARK] = ACTIONS(657),
    [anon_sym_0] = ACTIONS(663),
    [anon_sym__] = ACTIONS(663),
  },
  [113] = {
    [aux_sym_concatenation_repeat1] = STATE(375),
    [sym__concat] = ACTIONS(647),
    [sym_variable_name] = ACTIONS(665),
    [ts_builtin_sym_end] = ACTIONS(665),
    [anon_sym_PIPE] = ACTIONS(667),
    [anon_sym_SEMI_SEMI] = ACTIONS(665),
    [anon_sym_PIPE_AMP] = ACTIONS(665),
    [anon_sym_AMP_AMP] = ACTIONS(665),
    [anon_sym_PIPE_PIPE] = ACTIONS(665),
    [sym__special_characters] = ACTIONS(665),
    [anon_sym_DQUOTE] = ACTIONS(665),
    [anon_sym_DOLLAR] = ACTIONS(667),
    [sym_raw_string] = ACTIONS(665),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(665),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(665),
    [anon_sym_BQUOTE] = ACTIONS(665),
    [anon_sym_LT_LPAREN] = ACTIONS(665),
    [anon_sym_GT_LPAREN] = ACTIONS(665),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(667),
    [sym_word] = ACTIONS(667),
    [anon_sym_SEMI] = ACTIONS(667),
    [anon_sym_LF] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
  },
  [114] = {
    [sym_subscript] = STATE(386),
    [sym_variable_name] = ACTIONS(669),
    [anon_sym_BANG] = ACTIONS(671),
    [anon_sym_DOLLAR] = ACTIONS(673),
    [anon_sym_POUND] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(673),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(675),
    [anon_sym_STAR] = ACTIONS(673),
    [anon_sym_AT] = ACTIONS(673),
    [anon_sym_QMARK] = ACTIONS(673),
    [anon_sym_0] = ACTIONS(677),
    [anon_sym__] = ACTIONS(677),
  },
  [115] = {
    [sym__terminated_statement] = STATE(389),
    [sym_for_statement] = STATE(387),
    [sym_c_style_for_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_case_statement] = STATE(387),
    [sym_function_definition] = STATE(387),
    [sym_subshell] = STATE(387),
    [sym_pipeline] = STATE(387),
    [sym_list] = STATE(387),
    [sym_negated_command] = STATE(387),
    [sym_test_command] = STATE(387),
    [sym_declaration_command] = STATE(387),
    [sym_unset_command] = STATE(387),
    [sym_command] = STATE(387),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(388),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(389),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [116] = {
    [sym__terminated_statement] = STATE(392),
    [sym_for_statement] = STATE(390),
    [sym_c_style_for_statement] = STATE(390),
    [sym_while_statement] = STATE(390),
    [sym_if_statement] = STATE(390),
    [sym_case_statement] = STATE(390),
    [sym_function_definition] = STATE(390),
    [sym_subshell] = STATE(390),
    [sym_pipeline] = STATE(390),
    [sym_list] = STATE(390),
    [sym_negated_command] = STATE(390),
    [sym_test_command] = STATE(390),
    [sym_declaration_command] = STATE(390),
    [sym_unset_command] = STATE(390),
    [sym_command] = STATE(390),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(391),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(392),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [117] = {
    [sym__terminated_statement] = STATE(395),
    [sym_for_statement] = STATE(393),
    [sym_c_style_for_statement] = STATE(393),
    [sym_while_statement] = STATE(393),
    [sym_if_statement] = STATE(393),
    [sym_case_statement] = STATE(393),
    [sym_function_definition] = STATE(393),
    [sym_subshell] = STATE(393),
    [sym_pipeline] = STATE(393),
    [sym_list] = STATE(393),
    [sym_negated_command] = STATE(393),
    [sym_test_command] = STATE(393),
    [sym_declaration_command] = STATE(393),
    [sym_unset_command] = STATE(393),
    [sym_command] = STATE(393),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(394),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(395),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [118] = {
    [sym_variable_name] = ACTIONS(679),
    [ts_builtin_sym_end] = ACTIONS(679),
    [anon_sym_PIPE] = ACTIONS(681),
    [anon_sym_RPAREN] = ACTIONS(679),
    [anon_sym_SEMI_SEMI] = ACTIONS(679),
    [anon_sym_PIPE_AMP] = ACTIONS(679),
    [anon_sym_AMP_AMP] = ACTIONS(679),
    [anon_sym_PIPE_PIPE] = ACTIONS(679),
    [sym__special_characters] = ACTIONS(679),
    [anon_sym_DQUOTE] = ACTIONS(679),
    [anon_sym_DOLLAR] = ACTIONS(681),
    [sym_raw_string] = ACTIONS(679),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(679),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(679),
    [anon_sym_BQUOTE] = ACTIONS(679),
    [anon_sym_LT_LPAREN] = ACTIONS(679),
    [anon_sym_GT_LPAREN] = ACTIONS(679),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(681),
    [sym_word] = ACTIONS(681),
    [anon_sym_SEMI] = ACTIONS(681),
    [anon_sym_LF] = ACTIONS(679),
    [anon_sym_AMP] = ACTIONS(681),
  },
  [119] = {
    [anon_sym_EQ] = ACTIONS(645),
    [anon_sym_PLUS_EQ] = ACTIONS(645),
    [sym_comment] = ACTIONS(53),
  },
  [120] = {
    [sym_variable_assignment] = STATE(396),
    [sym_subscript] = STATE(119),
    [sym_concatenation] = STATE(396),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [aux_sym_declaration_command_repeat1] = STATE(396),
    [sym_variable_name] = ACTIONS(181),
    [ts_builtin_sym_end] = ACTIONS(683),
    [anon_sym_PIPE] = ACTIONS(685),
    [anon_sym_SEMI_SEMI] = ACTIONS(683),
    [anon_sym_PIPE_AMP] = ACTIONS(683),
    [anon_sym_AMP_AMP] = ACTIONS(683),
    [anon_sym_PIPE_PIPE] = ACTIONS(683),
    [sym__special_characters] = ACTIONS(187),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(193),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(203),
    [sym_word] = ACTIONS(205),
    [anon_sym_SEMI] = ACTIONS(685),
    [anon_sym_LF] = ACTIONS(683),
    [anon_sym_AMP] = ACTIONS(685),
  },
  [121] = {
    [aux_sym_concatenation_repeat1] = STATE(398),
    [sym__concat] = ACTIONS(687),
    [ts_builtin_sym_end] = ACTIONS(689),
    [anon_sym_PIPE] = ACTIONS(691),
    [anon_sym_SEMI_SEMI] = ACTIONS(689),
    [anon_sym_PIPE_AMP] = ACTIONS(689),
    [anon_sym_AMP_AMP] = ACTIONS(689),
    [anon_sym_PIPE_PIPE] = ACTIONS(689),
    [sym__special_characters] = ACTIONS(689),
    [anon_sym_DQUOTE] = ACTIONS(689),
    [anon_sym_DOLLAR] = ACTIONS(691),
    [sym_raw_string] = ACTIONS(689),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(689),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(689),
    [anon_sym_BQUOTE] = ACTIONS(689),
    [anon_sym_LT_LPAREN] = ACTIONS(689),
    [anon_sym_GT_LPAREN] = ACTIONS(689),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(691),
    [sym_word] = ACTIONS(691),
    [anon_sym_SEMI] = ACTIONS(691),
    [anon_sym_LF] = ACTIONS(689),
    [anon_sym_AMP] = ACTIONS(691),
  },
  [122] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(401),
    [anon_sym_DQUOTE] = ACTIONS(693),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [123] = {
    [sym_string] = STATE(403),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(697),
    [sym_raw_string] = ACTIONS(699),
    [anon_sym_POUND] = ACTIONS(697),
    [anon_sym_DASH] = ACTIONS(697),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(701),
    [anon_sym_STAR] = ACTIONS(697),
    [anon_sym_AT] = ACTIONS(697),
    [anon_sym_QMARK] = ACTIONS(697),
    [anon_sym_0] = ACTIONS(703),
    [anon_sym__] = ACTIONS(703),
  },
  [124] = {
    [aux_sym_concatenation_repeat1] = STATE(398),
    [sym__concat] = ACTIONS(687),
    [ts_builtin_sym_end] = ACTIONS(705),
    [anon_sym_PIPE] = ACTIONS(707),
    [anon_sym_SEMI_SEMI] = ACTIONS(705),
    [anon_sym_PIPE_AMP] = ACTIONS(705),
    [anon_sym_AMP_AMP] = ACTIONS(705),
    [anon_sym_PIPE_PIPE] = ACTIONS(705),
    [sym__special_characters] = ACTIONS(705),
    [anon_sym_DQUOTE] = ACTIONS(705),
    [anon_sym_DOLLAR] = ACTIONS(707),
    [sym_raw_string] = ACTIONS(705),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(705),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(705),
    [anon_sym_BQUOTE] = ACTIONS(705),
    [anon_sym_LT_LPAREN] = ACTIONS(705),
    [anon_sym_GT_LPAREN] = ACTIONS(705),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(707),
    [sym_word] = ACTIONS(707),
    [anon_sym_SEMI] = ACTIONS(707),
    [anon_sym_LF] = ACTIONS(705),
    [anon_sym_AMP] = ACTIONS(707),
  },
  [125] = {
    [sym_subscript] = STATE(409),
    [sym_variable_name] = ACTIONS(709),
    [anon_sym_BANG] = ACTIONS(711),
    [anon_sym_DOLLAR] = ACTIONS(713),
    [anon_sym_POUND] = ACTIONS(711),
    [anon_sym_DASH] = ACTIONS(713),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(715),
    [anon_sym_STAR] = ACTIONS(713),
    [anon_sym_AT] = ACTIONS(713),
    [anon_sym_QMARK] = ACTIONS(713),
    [anon_sym_0] = ACTIONS(717),
    [anon_sym__] = ACTIONS(717),
  },
  [126] = {
    [sym__terminated_statement] = STATE(412),
    [sym_for_statement] = STATE(410),
    [sym_c_style_for_statement] = STATE(410),
    [sym_while_statement] = STATE(410),
    [sym_if_statement] = STATE(410),
    [sym_case_statement] = STATE(410),
    [sym_function_definition] = STATE(410),
    [sym_subshell] = STATE(410),
    [sym_pipeline] = STATE(410),
    [sym_list] = STATE(410),
    [sym_negated_command] = STATE(410),
    [sym_test_command] = STATE(410),
    [sym_declaration_command] = STATE(410),
    [sym_unset_command] = STATE(410),
    [sym_command] = STATE(410),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(411),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(412),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [127] = {
    [sym__terminated_statement] = STATE(415),
    [sym_for_statement] = STATE(413),
    [sym_c_style_for_statement] = STATE(413),
    [sym_while_statement] = STATE(413),
    [sym_if_statement] = STATE(413),
    [sym_case_statement] = STATE(413),
    [sym_function_definition] = STATE(413),
    [sym_subshell] = STATE(413),
    [sym_pipeline] = STATE(413),
    [sym_list] = STATE(413),
    [sym_negated_command] = STATE(413),
    [sym_test_command] = STATE(413),
    [sym_declaration_command] = STATE(413),
    [sym_unset_command] = STATE(413),
    [sym_command] = STATE(413),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(414),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(415),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [128] = {
    [sym__terminated_statement] = STATE(418),
    [sym_for_statement] = STATE(416),
    [sym_c_style_for_statement] = STATE(416),
    [sym_while_statement] = STATE(416),
    [sym_if_statement] = STATE(416),
    [sym_case_statement] = STATE(416),
    [sym_function_definition] = STATE(416),
    [sym_subshell] = STATE(416),
    [sym_pipeline] = STATE(416),
    [sym_list] = STATE(416),
    [sym_negated_command] = STATE(416),
    [sym_test_command] = STATE(416),
    [sym_declaration_command] = STATE(416),
    [sym_unset_command] = STATE(416),
    [sym_command] = STATE(416),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(417),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(418),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [129] = {
    [ts_builtin_sym_end] = ACTIONS(719),
    [anon_sym_PIPE] = ACTIONS(721),
    [anon_sym_RPAREN] = ACTIONS(719),
    [anon_sym_SEMI_SEMI] = ACTIONS(719),
    [anon_sym_PIPE_AMP] = ACTIONS(719),
    [anon_sym_AMP_AMP] = ACTIONS(719),
    [anon_sym_PIPE_PIPE] = ACTIONS(719),
    [sym__special_characters] = ACTIONS(719),
    [anon_sym_DQUOTE] = ACTIONS(719),
    [anon_sym_DOLLAR] = ACTIONS(721),
    [sym_raw_string] = ACTIONS(719),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(719),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(719),
    [anon_sym_BQUOTE] = ACTIONS(719),
    [anon_sym_LT_LPAREN] = ACTIONS(719),
    [anon_sym_GT_LPAREN] = ACTIONS(719),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(721),
    [sym_word] = ACTIONS(721),
    [anon_sym_SEMI] = ACTIONS(721),
    [anon_sym_LF] = ACTIONS(719),
    [anon_sym_AMP] = ACTIONS(721),
  },
  [130] = {
    [sym_concatenation] = STATE(419),
    [sym_string] = STATE(124),
    [sym_simple_expansion] = STATE(124),
    [sym_string_expansion] = STATE(124),
    [sym_expansion] = STATE(124),
    [sym_command_substitution] = STATE(124),
    [sym_process_substitution] = STATE(124),
    [aux_sym_unset_command_repeat1] = STATE(419),
    [ts_builtin_sym_end] = ACTIONS(723),
    [anon_sym_PIPE] = ACTIONS(725),
    [anon_sym_SEMI_SEMI] = ACTIONS(723),
    [anon_sym_PIPE_AMP] = ACTIONS(723),
    [anon_sym_AMP_AMP] = ACTIONS(723),
    [anon_sym_PIPE_PIPE] = ACTIONS(723),
    [sym__special_characters] = ACTIONS(211),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(227),
    [sym_word] = ACTIONS(229),
    [anon_sym_SEMI] = ACTIONS(725),
    [anon_sym_LF] = ACTIONS(723),
    [anon_sym_AMP] = ACTIONS(725),
  },
  [131] = {
    [aux_sym_concatenation_repeat1] = STATE(421),
    [sym_file_descriptor] = ACTIONS(727),
    [sym__concat] = ACTIONS(729),
    [sym_variable_name] = ACTIONS(727),
    [anon_sym_LT] = ACTIONS(731),
    [anon_sym_GT] = ACTIONS(731),
    [anon_sym_GT_GT] = ACTIONS(727),
    [anon_sym_AMP_GT] = ACTIONS(731),
    [anon_sym_AMP_GT_GT] = ACTIONS(727),
    [anon_sym_LT_AMP] = ACTIONS(727),
    [anon_sym_GT_AMP] = ACTIONS(727),
    [sym__special_characters] = ACTIONS(727),
    [anon_sym_DQUOTE] = ACTIONS(727),
    [anon_sym_DOLLAR] = ACTIONS(731),
    [sym_raw_string] = ACTIONS(727),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(727),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(727),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [anon_sym_LT_LPAREN] = ACTIONS(727),
    [anon_sym_GT_LPAREN] = ACTIONS(727),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(727),
  },
  [132] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(424),
    [anon_sym_DQUOTE] = ACTIONS(733),
    [anon_sym_DOLLAR] = ACTIONS(735),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [133] = {
    [sym_string] = STATE(426),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [anon_sym_DOLLAR] = ACTIONS(737),
    [sym_raw_string] = ACTIONS(739),
    [anon_sym_POUND] = ACTIONS(737),
    [anon_sym_DASH] = ACTIONS(737),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(741),
    [anon_sym_STAR] = ACTIONS(737),
    [anon_sym_AT] = ACTIONS(737),
    [anon_sym_QMARK] = ACTIONS(737),
    [anon_sym_0] = ACTIONS(743),
    [anon_sym__] = ACTIONS(743),
  },
  [134] = {
    [aux_sym_concatenation_repeat1] = STATE(421),
    [sym_file_descriptor] = ACTIONS(745),
    [sym__concat] = ACTIONS(729),
    [sym_variable_name] = ACTIONS(745),
    [anon_sym_LT] = ACTIONS(747),
    [anon_sym_GT] = ACTIONS(747),
    [anon_sym_GT_GT] = ACTIONS(745),
    [anon_sym_AMP_GT] = ACTIONS(747),
    [anon_sym_AMP_GT_GT] = ACTIONS(745),
    [anon_sym_LT_AMP] = ACTIONS(745),
    [anon_sym_GT_AMP] = ACTIONS(745),
    [sym__special_characters] = ACTIONS(745),
    [anon_sym_DQUOTE] = ACTIONS(745),
    [anon_sym_DOLLAR] = ACTIONS(747),
    [sym_raw_string] = ACTIONS(745),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(745),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(745),
    [anon_sym_BQUOTE] = ACTIONS(745),
    [anon_sym_LT_LPAREN] = ACTIONS(745),
    [anon_sym_GT_LPAREN] = ACTIONS(745),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(745),
  },
  [135] = {
    [sym_subscript] = STATE(432),
    [sym_variable_name] = ACTIONS(749),
    [anon_sym_BANG] = ACTIONS(751),
    [anon_sym_DOLLAR] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(751),
    [anon_sym_DASH] = ACTIONS(753),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(755),
    [anon_sym_STAR] = ACTIONS(753),
    [anon_sym_AT] = ACTIONS(753),
    [anon_sym_QMARK] = ACTIONS(753),
    [anon_sym_0] = ACTIONS(757),
    [anon_sym__] = ACTIONS(757),
  },
  [136] = {
    [sym__terminated_statement] = STATE(435),
    [sym_for_statement] = STATE(433),
    [sym_c_style_for_statement] = STATE(433),
    [sym_while_statement] = STATE(433),
    [sym_if_statement] = STATE(433),
    [sym_case_statement] = STATE(433),
    [sym_function_definition] = STATE(433),
    [sym_subshell] = STATE(433),
    [sym_pipeline] = STATE(433),
    [sym_list] = STATE(433),
    [sym_negated_command] = STATE(433),
    [sym_test_command] = STATE(433),
    [sym_declaration_command] = STATE(433),
    [sym_unset_command] = STATE(433),
    [sym_command] = STATE(433),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(434),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(435),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [137] = {
    [sym__terminated_statement] = STATE(438),
    [sym_for_statement] = STATE(436),
    [sym_c_style_for_statement] = STATE(436),
    [sym_while_statement] = STATE(436),
    [sym_if_statement] = STATE(436),
    [sym_case_statement] = STATE(436),
    [sym_function_definition] = STATE(436),
    [sym_subshell] = STATE(436),
    [sym_pipeline] = STATE(436),
    [sym_list] = STATE(436),
    [sym_negated_command] = STATE(436),
    [sym_test_command] = STATE(436),
    [sym_declaration_command] = STATE(436),
    [sym_unset_command] = STATE(436),
    [sym_command] = STATE(436),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(437),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(438),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [138] = {
    [sym__terminated_statement] = STATE(441),
    [sym_for_statement] = STATE(439),
    [sym_c_style_for_statement] = STATE(439),
    [sym_while_statement] = STATE(439),
    [sym_if_statement] = STATE(439),
    [sym_case_statement] = STATE(439),
    [sym_function_definition] = STATE(439),
    [sym_subshell] = STATE(439),
    [sym_pipeline] = STATE(439),
    [sym_list] = STATE(439),
    [sym_negated_command] = STATE(439),
    [sym_test_command] = STATE(439),
    [sym_declaration_command] = STATE(439),
    [sym_unset_command] = STATE(439),
    [sym_command] = STATE(439),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(440),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(441),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [139] = {
    [sym_file_descriptor] = ACTIONS(745),
    [sym_variable_name] = ACTIONS(745),
    [anon_sym_LT] = ACTIONS(747),
    [anon_sym_GT] = ACTIONS(747),
    [anon_sym_GT_GT] = ACTIONS(745),
    [anon_sym_AMP_GT] = ACTIONS(747),
    [anon_sym_AMP_GT_GT] = ACTIONS(745),
    [anon_sym_LT_AMP] = ACTIONS(745),
    [anon_sym_GT_AMP] = ACTIONS(745),
    [sym__special_characters] = ACTIONS(745),
    [anon_sym_DQUOTE] = ACTIONS(745),
    [anon_sym_DOLLAR] = ACTIONS(747),
    [sym_raw_string] = ACTIONS(745),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(745),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(745),
    [anon_sym_BQUOTE] = ACTIONS(745),
    [anon_sym_LT_LPAREN] = ACTIONS(745),
    [anon_sym_GT_LPAREN] = ACTIONS(745),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(745),
  },
  [140] = {
    [sym_string] = STATE(442),
    [sym_simple_expansion] = STATE(442),
    [sym_string_expansion] = STATE(442),
    [sym_expansion] = STATE(442),
    [sym_command_substitution] = STATE(442),
    [sym_process_substitution] = STATE(442),
    [sym__special_characters] = ACTIONS(759),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(759),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(759),
  },
  [141] = {
    [aux_sym_concatenation_repeat1] = STATE(443),
    [sym__simple_heredoc_body] = ACTIONS(761),
    [sym__heredoc_body_beginning] = ACTIONS(761),
    [sym_file_descriptor] = ACTIONS(761),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(761),
    [anon_sym_PIPE] = ACTIONS(763),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [anon_sym_PIPE_AMP] = ACTIONS(761),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [anon_sym_EQ_TILDE] = ACTIONS(763),
    [anon_sym_EQ_EQ] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(763),
    [anon_sym_GT] = ACTIONS(763),
    [anon_sym_GT_GT] = ACTIONS(761),
    [anon_sym_AMP_GT] = ACTIONS(763),
    [anon_sym_AMP_GT_GT] = ACTIONS(761),
    [anon_sym_LT_AMP] = ACTIONS(761),
    [anon_sym_GT_AMP] = ACTIONS(761),
    [anon_sym_LT_LT] = ACTIONS(763),
    [anon_sym_LT_LT_DASH] = ACTIONS(761),
    [anon_sym_LT_LT_LT] = ACTIONS(761),
    [sym__special_characters] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(763),
    [sym_raw_string] = ACTIONS(761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(761),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(761),
    [anon_sym_LT_LPAREN] = ACTIONS(761),
    [anon_sym_GT_LPAREN] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(763),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
  },
  [142] = {
    [sym__simple_heredoc_body] = ACTIONS(765),
    [sym__heredoc_body_beginning] = ACTIONS(765),
    [sym_file_descriptor] = ACTIONS(765),
    [sym__concat] = ACTIONS(765),
    [ts_builtin_sym_end] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_RPAREN] = ACTIONS(765),
    [anon_sym_SEMI_SEMI] = ACTIONS(765),
    [anon_sym_PIPE_AMP] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_EQ_TILDE] = ACTIONS(767),
    [anon_sym_EQ_EQ] = ACTIONS(767),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_GT_GT] = ACTIONS(765),
    [anon_sym_AMP_GT] = ACTIONS(767),
    [anon_sym_AMP_GT_GT] = ACTIONS(765),
    [anon_sym_LT_AMP] = ACTIONS(765),
    [anon_sym_GT_AMP] = ACTIONS(765),
    [anon_sym_LT_LT] = ACTIONS(767),
    [anon_sym_LT_LT_DASH] = ACTIONS(765),
    [anon_sym_LT_LT_LT] = ACTIONS(765),
    [sym__special_characters] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(765),
    [anon_sym_DOLLAR] = ACTIONS(767),
    [sym_raw_string] = ACTIONS(765),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(765),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(765),
    [anon_sym_BQUOTE] = ACTIONS(765),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(767),
    [anon_sym_SEMI] = ACTIONS(767),
    [anon_sym_LF] = ACTIONS(765),
    [anon_sym_AMP] = ACTIONS(767),
  },
  [143] = {
    [anon_sym_DQUOTE] = ACTIONS(769),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [144] = {
    [sym__concat] = ACTIONS(779),
    [anon_sym_DQUOTE] = ACTIONS(781),
    [anon_sym_DOLLAR] = ACTIONS(781),
    [sym__string_content] = ACTIONS(783),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(781),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(781),
    [sym_comment] = ACTIONS(265),
  },
  [145] = {
    [sym_subscript] = STATE(453),
    [sym_variable_name] = ACTIONS(785),
    [anon_sym_BANG] = ACTIONS(787),
    [anon_sym_DOLLAR] = ACTIONS(789),
    [anon_sym_POUND] = ACTIONS(787),
    [anon_sym_DASH] = ACTIONS(789),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(791),
    [anon_sym_STAR] = ACTIONS(789),
    [anon_sym_AT] = ACTIONS(789),
    [anon_sym_QMARK] = ACTIONS(789),
    [anon_sym_0] = ACTIONS(793),
    [anon_sym__] = ACTIONS(793),
  },
  [146] = {
    [sym__terminated_statement] = STATE(456),
    [sym_for_statement] = STATE(454),
    [sym_c_style_for_statement] = STATE(454),
    [sym_while_statement] = STATE(454),
    [sym_if_statement] = STATE(454),
    [sym_case_statement] = STATE(454),
    [sym_function_definition] = STATE(454),
    [sym_subshell] = STATE(454),
    [sym_pipeline] = STATE(454),
    [sym_list] = STATE(454),
    [sym_negated_command] = STATE(454),
    [sym_test_command] = STATE(454),
    [sym_declaration_command] = STATE(454),
    [sym_unset_command] = STATE(454),
    [sym_command] = STATE(454),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(455),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(456),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [147] = {
    [sym__terminated_statement] = STATE(459),
    [sym_for_statement] = STATE(457),
    [sym_c_style_for_statement] = STATE(457),
    [sym_while_statement] = STATE(457),
    [sym_if_statement] = STATE(457),
    [sym_case_statement] = STATE(457),
    [sym_function_definition] = STATE(457),
    [sym_subshell] = STATE(457),
    [sym_pipeline] = STATE(457),
    [sym_list] = STATE(457),
    [sym_negated_command] = STATE(457),
    [sym_test_command] = STATE(457),
    [sym_declaration_command] = STATE(457),
    [sym_unset_command] = STATE(457),
    [sym_command] = STATE(457),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(458),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(459),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [148] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(769),
    [anon_sym_DOLLAR] = ACTIONS(795),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [149] = {
    [sym__simple_heredoc_body] = ACTIONS(797),
    [sym__heredoc_body_beginning] = ACTIONS(797),
    [sym_file_descriptor] = ACTIONS(797),
    [sym__concat] = ACTIONS(797),
    [ts_builtin_sym_end] = ACTIONS(797),
    [anon_sym_PIPE] = ACTIONS(799),
    [anon_sym_RPAREN] = ACTIONS(797),
    [anon_sym_SEMI_SEMI] = ACTIONS(797),
    [anon_sym_PIPE_AMP] = ACTIONS(797),
    [anon_sym_AMP_AMP] = ACTIONS(797),
    [anon_sym_PIPE_PIPE] = ACTIONS(797),
    [anon_sym_EQ_TILDE] = ACTIONS(799),
    [anon_sym_EQ_EQ] = ACTIONS(799),
    [anon_sym_LT] = ACTIONS(799),
    [anon_sym_GT] = ACTIONS(799),
    [anon_sym_GT_GT] = ACTIONS(797),
    [anon_sym_AMP_GT] = ACTIONS(799),
    [anon_sym_AMP_GT_GT] = ACTIONS(797),
    [anon_sym_LT_AMP] = ACTIONS(797),
    [anon_sym_GT_AMP] = ACTIONS(797),
    [anon_sym_LT_LT] = ACTIONS(799),
    [anon_sym_LT_LT_DASH] = ACTIONS(797),
    [anon_sym_LT_LT_LT] = ACTIONS(797),
    [sym__special_characters] = ACTIONS(797),
    [anon_sym_DQUOTE] = ACTIONS(797),
    [anon_sym_DOLLAR] = ACTIONS(799),
    [sym_raw_string] = ACTIONS(797),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(797),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(797),
    [anon_sym_BQUOTE] = ACTIONS(797),
    [anon_sym_LT_LPAREN] = ACTIONS(797),
    [anon_sym_GT_LPAREN] = ACTIONS(797),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(799),
    [anon_sym_SEMI] = ACTIONS(799),
    [anon_sym_LF] = ACTIONS(797),
    [anon_sym_AMP] = ACTIONS(799),
  },
  [150] = {
    [sym__simple_heredoc_body] = ACTIONS(801),
    [sym__heredoc_body_beginning] = ACTIONS(801),
    [sym_file_descriptor] = ACTIONS(801),
    [sym__concat] = ACTIONS(801),
    [ts_builtin_sym_end] = ACTIONS(801),
    [anon_sym_PIPE] = ACTIONS(803),
    [anon_sym_RPAREN] = ACTIONS(801),
    [anon_sym_SEMI_SEMI] = ACTIONS(801),
    [anon_sym_PIPE_AMP] = ACTIONS(801),
    [anon_sym_AMP_AMP] = ACTIONS(801),
    [anon_sym_PIPE_PIPE] = ACTIONS(801),
    [anon_sym_EQ_TILDE] = ACTIONS(803),
    [anon_sym_EQ_EQ] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(803),
    [anon_sym_GT] = ACTIONS(803),
    [anon_sym_GT_GT] = ACTIONS(801),
    [anon_sym_AMP_GT] = ACTIONS(803),
    [anon_sym_AMP_GT_GT] = ACTIONS(801),
    [anon_sym_LT_AMP] = ACTIONS(801),
    [anon_sym_GT_AMP] = ACTIONS(801),
    [anon_sym_LT_LT] = ACTIONS(803),
    [anon_sym_LT_LT_DASH] = ACTIONS(801),
    [anon_sym_LT_LT_LT] = ACTIONS(801),
    [sym__special_characters] = ACTIONS(801),
    [anon_sym_DQUOTE] = ACTIONS(801),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [sym_raw_string] = ACTIONS(801),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(801),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(801),
    [anon_sym_BQUOTE] = ACTIONS(801),
    [anon_sym_LT_LPAREN] = ACTIONS(801),
    [anon_sym_GT_LPAREN] = ACTIONS(801),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(803),
    [anon_sym_SEMI] = ACTIONS(803),
    [anon_sym_LF] = ACTIONS(801),
    [anon_sym_AMP] = ACTIONS(803),
  },
  [151] = {
    [sym__simple_heredoc_body] = ACTIONS(805),
    [sym__heredoc_body_beginning] = ACTIONS(805),
    [sym_file_descriptor] = ACTIONS(805),
    [sym__concat] = ACTIONS(805),
    [ts_builtin_sym_end] = ACTIONS(805),
    [anon_sym_PIPE] = ACTIONS(807),
    [anon_sym_RPAREN] = ACTIONS(805),
    [anon_sym_SEMI_SEMI] = ACTIONS(805),
    [anon_sym_PIPE_AMP] = ACTIONS(805),
    [anon_sym_AMP_AMP] = ACTIONS(805),
    [anon_sym_PIPE_PIPE] = ACTIONS(805),
    [anon_sym_EQ_TILDE] = ACTIONS(807),
    [anon_sym_EQ_EQ] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(807),
    [anon_sym_GT] = ACTIONS(807),
    [anon_sym_GT_GT] = ACTIONS(805),
    [anon_sym_AMP_GT] = ACTIONS(807),
    [anon_sym_AMP_GT_GT] = ACTIONS(805),
    [anon_sym_LT_AMP] = ACTIONS(805),
    [anon_sym_GT_AMP] = ACTIONS(805),
    [anon_sym_LT_LT] = ACTIONS(807),
    [anon_sym_LT_LT_DASH] = ACTIONS(805),
    [anon_sym_LT_LT_LT] = ACTIONS(805),
    [sym__special_characters] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(805),
    [anon_sym_DOLLAR] = ACTIONS(807),
    [sym_raw_string] = ACTIONS(805),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(805),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(805),
    [anon_sym_BQUOTE] = ACTIONS(805),
    [anon_sym_LT_LPAREN] = ACTIONS(805),
    [anon_sym_GT_LPAREN] = ACTIONS(805),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(807),
    [anon_sym_LF] = ACTIONS(805),
    [anon_sym_AMP] = ACTIONS(807),
  },
  [152] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(811),
    [sym_comment] = ACTIONS(53),
  },
  [153] = {
    [sym_subscript] = STATE(467),
    [sym_variable_name] = ACTIONS(813),
    [anon_sym_DOLLAR] = ACTIONS(815),
    [anon_sym_DASH] = ACTIONS(815),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(817),
    [anon_sym_STAR] = ACTIONS(815),
    [anon_sym_AT] = ACTIONS(815),
    [anon_sym_QMARK] = ACTIONS(815),
    [anon_sym_0] = ACTIONS(819),
    [anon_sym__] = ACTIONS(819),
  },
  [154] = {
    [sym_concatenation] = STATE(478),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(478),
    [anon_sym_RBRACE] = ACTIONS(821),
    [anon_sym_EQ] = ACTIONS(823),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(833),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(837),
    [anon_sym_COLON] = ACTIONS(823),
    [anon_sym_COLON_QMARK] = ACTIONS(823),
    [anon_sym_COLON_DASH] = ACTIONS(823),
    [anon_sym_PERCENT] = ACTIONS(823),
    [anon_sym_DASH] = ACTIONS(823),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [155] = {
    [sym_concatenation] = STATE(481),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(481),
    [anon_sym_RBRACE] = ACTIONS(847),
    [anon_sym_EQ] = ACTIONS(849),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(851),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(853),
    [anon_sym_COLON] = ACTIONS(849),
    [anon_sym_COLON_QMARK] = ACTIONS(849),
    [anon_sym_COLON_DASH] = ACTIONS(849),
    [anon_sym_PERCENT] = ACTIONS(849),
    [anon_sym_DASH] = ACTIONS(849),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [156] = {
    [sym_concatenation] = STATE(484),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(484),
    [anon_sym_RBRACE] = ACTIONS(855),
    [anon_sym_EQ] = ACTIONS(857),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(859),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(861),
    [anon_sym_COLON] = ACTIONS(857),
    [anon_sym_COLON_QMARK] = ACTIONS(857),
    [anon_sym_COLON_DASH] = ACTIONS(857),
    [anon_sym_PERCENT] = ACTIONS(857),
    [anon_sym_DASH] = ACTIONS(857),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [157] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(863),
    [anon_sym_SEMI_SEMI] = ACTIONS(865),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(867),
    [anon_sym_LF] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
  },
  [158] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(863),
    [anon_sym_SEMI_SEMI] = ACTIONS(865),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(867),
    [anon_sym_LF] = ACTIONS(865),
    [anon_sym_AMP] = ACTIONS(867),
  },
  [159] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(487),
    [sym_c_style_for_statement] = STATE(487),
    [sym_while_statement] = STATE(487),
    [sym_if_statement] = STATE(487),
    [sym_case_statement] = STATE(487),
    [sym_function_definition] = STATE(487),
    [sym_subshell] = STATE(487),
    [sym_pipeline] = STATE(487),
    [sym_list] = STATE(487),
    [sym_negated_command] = STATE(487),
    [sym_test_command] = STATE(487),
    [sym_declaration_command] = STATE(487),
    [sym_unset_command] = STATE(487),
    [sym_command] = STATE(487),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(488),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [160] = {
    [sym__terminated_statement] = STATE(489),
    [sym_for_statement] = STATE(51),
    [sym_c_style_for_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_case_statement] = STATE(51),
    [sym_function_definition] = STATE(51),
    [sym_subshell] = STATE(51),
    [sym_pipeline] = STATE(51),
    [sym_list] = STATE(51),
    [sym_negated_command] = STATE(51),
    [sym_test_command] = STATE(51),
    [sym_declaration_command] = STATE(51),
    [sym_unset_command] = STATE(51),
    [sym_command] = STATE(51),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(53),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [161] = {
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(869),
  },
  [162] = {
    [sym_subshell] = STATE(85),
    [sym_test_command] = STATE(85),
    [sym_command] = STATE(85),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(86),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(87),
  },
  [163] = {
    [sym__expression] = STATE(491),
    [sym_binary_expression] = STATE(491),
    [sym_unary_expression] = STATE(491),
    [sym_parenthesized_expression] = STATE(491),
    [sym_concatenation] = STATE(491),
    [sym_string] = STATE(92),
    [sym_simple_expansion] = STATE(92),
    [sym_string_expansion] = STATE(92),
    [sym_expansion] = STATE(92),
    [sym_command_substitution] = STATE(92),
    [sym_process_substitution] = STATE(92),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [164] = {
    [sym__expression] = STATE(492),
    [sym_binary_expression] = STATE(492),
    [sym_unary_expression] = STATE(492),
    [sym_parenthesized_expression] = STATE(492),
    [sym_concatenation] = STATE(492),
    [sym_string] = STATE(103),
    [sym_simple_expansion] = STATE(103),
    [sym_string_expansion] = STATE(103),
    [sym_expansion] = STATE(103),
    [sym_command_substitution] = STATE(103),
    [sym_process_substitution] = STATE(103),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [sym__special_characters] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(167),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(177),
    [sym_test_operator] = ACTIONS(179),
  },
  [165] = {
    [sym_variable_assignment] = STATE(493),
    [sym_subscript] = STATE(235),
    [sym_concatenation] = STATE(493),
    [sym_string] = STATE(234),
    [sym_simple_expansion] = STATE(234),
    [sym_string_expansion] = STATE(234),
    [sym_expansion] = STATE(234),
    [sym_command_substitution] = STATE(234),
    [sym_process_substitution] = STATE(234),
    [aux_sym_declaration_command_repeat1] = STATE(493),
    [sym_variable_name] = ACTIONS(421),
    [anon_sym_PIPE] = ACTIONS(185),
    [anon_sym_SEMI_SEMI] = ACTIONS(183),
    [anon_sym_PIPE_AMP] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [sym__special_characters] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(425),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(183),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(203),
    [sym_word] = ACTIONS(427),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_LF] = ACTIONS(183),
    [anon_sym_AMP] = ACTIONS(185),
  },
  [166] = {
    [sym_concatenation] = STATE(494),
    [sym_string] = STATE(238),
    [sym_simple_expansion] = STATE(238),
    [sym_string_expansion] = STATE(238),
    [sym_expansion] = STATE(238),
    [sym_command_substitution] = STATE(238),
    [sym_process_substitution] = STATE(238),
    [aux_sym_unset_command_repeat1] = STATE(494),
    [anon_sym_PIPE] = ACTIONS(209),
    [anon_sym_SEMI_SEMI] = ACTIONS(207),
    [anon_sym_PIPE_AMP] = ACTIONS(207),
    [anon_sym_AMP_AMP] = ACTIONS(207),
    [anon_sym_PIPE_PIPE] = ACTIONS(207),
    [sym__special_characters] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(431),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(207),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(227),
    [sym_word] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_LF] = ACTIONS(207),
    [anon_sym_AMP] = ACTIONS(209),
  },
  [167] = {
    [aux_sym_concatenation_repeat1] = STATE(240),
    [sym__simple_heredoc_body] = ACTIONS(275),
    [sym__heredoc_body_beginning] = ACTIONS(275),
    [sym_file_descriptor] = ACTIONS(275),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_SEMI_SEMI] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(871),
    [anon_sym_PIPE_AMP] = ACTIONS(275),
    [anon_sym_AMP_AMP] = ACTIONS(275),
    [anon_sym_PIPE_PIPE] = ACTIONS(275),
    [anon_sym_EQ_TILDE] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_GT_GT] = ACTIONS(275),
    [anon_sym_AMP_GT] = ACTIONS(277),
    [anon_sym_AMP_GT_GT] = ACTIONS(275),
    [anon_sym_LT_AMP] = ACTIONS(275),
    [anon_sym_GT_AMP] = ACTIONS(275),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_LT_LT_DASH] = ACTIONS(275),
    [anon_sym_LT_LT_LT] = ACTIONS(275),
    [sym__special_characters] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(275),
    [anon_sym_DOLLAR] = ACTIONS(277),
    [sym_raw_string] = ACTIONS(275),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(275),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(275),
    [anon_sym_LT_LPAREN] = ACTIONS(275),
    [anon_sym_GT_LPAREN] = ACTIONS(275),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_LF] = ACTIONS(275),
    [anon_sym_AMP] = ACTIONS(277),
  },
  [168] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(875),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(881),
    [anon_sym_LF] = ACTIONS(875),
    [anon_sym_AMP] = ACTIONS(881),
  },
  [169] = {
    [sym_file_redirect] = STATE(502),
    [sym_heredoc_redirect] = STATE(502),
    [sym_heredoc_body] = STATE(189),
    [sym_herestring_redirect] = STATE(502),
    [sym_concatenation] = STATE(503),
    [sym_string] = STATE(252),
    [sym_simple_expansion] = STATE(252),
    [sym_string_expansion] = STATE(252),
    [sym_expansion] = STATE(252),
    [sym_command_substitution] = STATE(252),
    [sym_process_substitution] = STATE(252),
    [aux_sym_while_statement_repeat1] = STATE(502),
    [aux_sym_command_repeat2] = STATE(503),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(883),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(327),
    [anon_sym_PIPE_AMP] = ACTIONS(327),
    [anon_sym_AMP_AMP] = ACTIONS(327),
    [anon_sym_PIPE_PIPE] = ACTIONS(327),
    [anon_sym_EQ_TILDE] = ACTIONS(451),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(885),
    [anon_sym_GT] = ACTIONS(885),
    [anon_sym_GT_GT] = ACTIONS(887),
    [anon_sym_AMP_GT] = ACTIONS(885),
    [anon_sym_AMP_GT_GT] = ACTIONS(887),
    [anon_sym_LT_AMP] = ACTIONS(887),
    [anon_sym_GT_AMP] = ACTIONS(887),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(889),
    [sym__special_characters] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(461),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(327),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_LF] = ACTIONS(327),
    [anon_sym_AMP] = ACTIONS(329),
  },
  [170] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(875),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(881),
    [anon_sym_LF] = ACTIONS(875),
    [anon_sym_AMP] = ACTIONS(881),
  },
  [171] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(504),
    [sym_c_style_for_statement] = STATE(504),
    [sym_while_statement] = STATE(504),
    [sym_if_statement] = STATE(504),
    [sym_case_statement] = STATE(504),
    [sym_function_definition] = STATE(504),
    [sym_subshell] = STATE(504),
    [sym_pipeline] = STATE(504),
    [sym_list] = STATE(504),
    [sym_negated_command] = STATE(504),
    [sym_test_command] = STATE(504),
    [sym_declaration_command] = STATE(504),
    [sym_unset_command] = STATE(504),
    [sym_command] = STATE(504),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(505),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [172] = {
    [sym_command_name] = STATE(506),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(86),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(196),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(87),
  },
  [173] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(891),
    [anon_sym_SEMI_SEMI] = ACTIONS(893),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(895),
    [anon_sym_LF] = ACTIONS(893),
    [anon_sym_AMP] = ACTIONS(895),
  },
  [174] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(891),
    [anon_sym_SEMI_SEMI] = ACTIONS(893),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(895),
    [anon_sym_LF] = ACTIONS(893),
    [anon_sym_AMP] = ACTIONS(895),
  },
  [175] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(509),
    [sym_c_style_for_statement] = STATE(509),
    [sym_while_statement] = STATE(509),
    [sym_if_statement] = STATE(509),
    [sym_case_statement] = STATE(509),
    [sym_function_definition] = STATE(509),
    [sym_subshell] = STATE(509),
    [sym_pipeline] = STATE(509),
    [sym_list] = STATE(509),
    [sym_negated_command] = STATE(509),
    [sym_test_command] = STATE(509),
    [sym_declaration_command] = STATE(509),
    [sym_unset_command] = STATE(509),
    [sym_command] = STATE(509),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(510),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [176] = {
    [anon_sym_RPAREN] = ACTIONS(897),
    [sym_comment] = ACTIONS(53),
  },
  [177] = {
    [sym_for_statement] = STATE(512),
    [sym_c_style_for_statement] = STATE(512),
    [sym_while_statement] = STATE(512),
    [sym_if_statement] = STATE(512),
    [sym_case_statement] = STATE(512),
    [sym_function_definition] = STATE(512),
    [sym_subshell] = STATE(512),
    [sym_pipeline] = STATE(512),
    [sym_list] = STATE(512),
    [sym_negated_command] = STATE(512),
    [sym_test_command] = STATE(512),
    [sym_declaration_command] = STATE(512),
    [sym_unset_command] = STATE(512),
    [sym_command] = STATE(512),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(513),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [178] = {
    [sym_file_descriptor] = ACTIONS(899),
    [sym_variable_name] = ACTIONS(899),
    [ts_builtin_sym_end] = ACTIONS(901),
    [anon_sym_for] = ACTIONS(903),
    [anon_sym_while] = ACTIONS(903),
    [anon_sym_if] = ACTIONS(903),
    [anon_sym_case] = ACTIONS(903),
    [anon_sym_function] = ACTIONS(903),
    [anon_sym_LPAREN] = ACTIONS(899),
    [anon_sym_BANG] = ACTIONS(903),
    [anon_sym_LBRACK] = ACTIONS(903),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(899),
    [anon_sym_declare] = ACTIONS(903),
    [anon_sym_typeset] = ACTIONS(903),
    [anon_sym_export] = ACTIONS(903),
    [anon_sym_readonly] = ACTIONS(903),
    [anon_sym_local] = ACTIONS(903),
    [anon_sym_unset] = ACTIONS(903),
    [anon_sym_unsetenv] = ACTIONS(903),
    [anon_sym_LT] = ACTIONS(903),
    [anon_sym_GT] = ACTIONS(903),
    [anon_sym_GT_GT] = ACTIONS(899),
    [anon_sym_AMP_GT] = ACTIONS(903),
    [anon_sym_AMP_GT_GT] = ACTIONS(899),
    [anon_sym_LT_AMP] = ACTIONS(899),
    [anon_sym_GT_AMP] = ACTIONS(899),
    [sym__special_characters] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(903),
    [sym_raw_string] = ACTIONS(899),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(899),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(899),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_LT_LPAREN] = ACTIONS(899),
    [anon_sym_GT_LPAREN] = ACTIONS(899),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(903),
  },
  [179] = {
    [sym_for_statement] = STATE(514),
    [sym_c_style_for_statement] = STATE(514),
    [sym_while_statement] = STATE(514),
    [sym_if_statement] = STATE(514),
    [sym_case_statement] = STATE(514),
    [sym_function_definition] = STATE(514),
    [sym_subshell] = STATE(514),
    [sym_pipeline] = STATE(514),
    [sym_list] = STATE(514),
    [sym_negated_command] = STATE(514),
    [sym_test_command] = STATE(514),
    [sym_declaration_command] = STATE(514),
    [sym_unset_command] = STATE(514),
    [sym_command] = STATE(514),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(515),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [180] = {
    [ts_builtin_sym_end] = ACTIONS(905),
    [anon_sym_esac] = ACTIONS(905),
    [anon_sym_PIPE] = ACTIONS(907),
    [anon_sym_RPAREN] = ACTIONS(905),
    [anon_sym_SEMI_SEMI] = ACTIONS(905),
    [anon_sym_PIPE_AMP] = ACTIONS(905),
    [anon_sym_AMP_AMP] = ACTIONS(905),
    [anon_sym_PIPE_PIPE] = ACTIONS(905),
    [anon_sym_BQUOTE] = ACTIONS(905),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(907),
    [anon_sym_LF] = ACTIONS(905),
    [anon_sym_AMP] = ACTIONS(907),
  },
  [181] = {
    [sym_simple_expansion] = STATE(519),
    [sym_expansion] = STATE(519),
    [aux_sym_heredoc_body_repeat1] = STATE(519),
    [sym__heredoc_body_middle] = ACTIONS(909),
    [sym__heredoc_body_end] = ACTIONS(911),
    [anon_sym_DOLLAR] = ACTIONS(913),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(915),
    [sym_comment] = ACTIONS(53),
  },
  [182] = {
    [anon_sym_LT] = ACTIONS(917),
    [anon_sym_GT] = ACTIONS(917),
    [anon_sym_GT_GT] = ACTIONS(919),
    [anon_sym_AMP_GT] = ACTIONS(917),
    [anon_sym_AMP_GT_GT] = ACTIONS(919),
    [anon_sym_LT_AMP] = ACTIONS(919),
    [anon_sym_GT_AMP] = ACTIONS(919),
    [sym_comment] = ACTIONS(53),
  },
  [183] = {
    [sym_concatenation] = STATE(523),
    [sym_string] = STATE(522),
    [sym_simple_expansion] = STATE(522),
    [sym_string_expansion] = STATE(522),
    [sym_expansion] = STATE(522),
    [sym_command_substitution] = STATE(522),
    [sym_process_substitution] = STATE(522),
    [sym__special_characters] = ACTIONS(921),
    [anon_sym_DQUOTE] = ACTIONS(923),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(925),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(927),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(929),
    [anon_sym_BQUOTE] = ACTIONS(931),
    [anon_sym_LT_LPAREN] = ACTIONS(933),
    [anon_sym_GT_LPAREN] = ACTIONS(933),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(925),
    [sym_regex] = ACTIONS(935),
  },
  [184] = {
    [sym_concatenation] = STATE(526),
    [sym_string] = STATE(525),
    [sym_simple_expansion] = STATE(525),
    [sym_string_expansion] = STATE(525),
    [sym_expansion] = STATE(525),
    [sym_command_substitution] = STATE(525),
    [sym_process_substitution] = STATE(525),
    [sym__special_characters] = ACTIONS(937),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(939),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(939),
  },
  [185] = {
    [sym_heredoc_start] = ACTIONS(941),
    [sym_comment] = ACTIONS(53),
  },
  [186] = {
    [sym_concatenation] = STATE(530),
    [sym_string] = STATE(529),
    [sym_simple_expansion] = STATE(529),
    [sym_string_expansion] = STATE(529),
    [sym_expansion] = STATE(529),
    [sym_command_substitution] = STATE(529),
    [sym_process_substitution] = STATE(529),
    [sym__special_characters] = ACTIONS(943),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(945),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(945),
  },
  [187] = {
    [aux_sym_concatenation_repeat1] = STATE(141),
    [sym__simple_heredoc_body] = ACTIONS(947),
    [sym__heredoc_body_beginning] = ACTIONS(947),
    [sym_file_descriptor] = ACTIONS(947),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(947),
    [anon_sym_PIPE] = ACTIONS(949),
    [anon_sym_SEMI_SEMI] = ACTIONS(947),
    [anon_sym_PIPE_AMP] = ACTIONS(947),
    [anon_sym_AMP_AMP] = ACTIONS(947),
    [anon_sym_PIPE_PIPE] = ACTIONS(947),
    [anon_sym_EQ_TILDE] = ACTIONS(949),
    [anon_sym_EQ_EQ] = ACTIONS(949),
    [anon_sym_LT] = ACTIONS(949),
    [anon_sym_GT] = ACTIONS(949),
    [anon_sym_GT_GT] = ACTIONS(947),
    [anon_sym_AMP_GT] = ACTIONS(949),
    [anon_sym_AMP_GT_GT] = ACTIONS(947),
    [anon_sym_LT_AMP] = ACTIONS(947),
    [anon_sym_GT_AMP] = ACTIONS(947),
    [anon_sym_LT_LT] = ACTIONS(949),
    [anon_sym_LT_LT_DASH] = ACTIONS(947),
    [anon_sym_LT_LT_LT] = ACTIONS(947),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(947),
    [anon_sym_DOLLAR] = ACTIONS(949),
    [sym_raw_string] = ACTIONS(947),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(947),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(947),
    [anon_sym_BQUOTE] = ACTIONS(947),
    [anon_sym_LT_LPAREN] = ACTIONS(947),
    [anon_sym_GT_LPAREN] = ACTIONS(947),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(949),
    [anon_sym_SEMI] = ACTIONS(949),
    [anon_sym_LF] = ACTIONS(947),
    [anon_sym_AMP] = ACTIONS(949),
  },
  [188] = {
    [aux_sym_concatenation_repeat1] = STATE(141),
    [sym__simple_heredoc_body] = ACTIONS(951),
    [sym__heredoc_body_beginning] = ACTIONS(951),
    [sym_file_descriptor] = ACTIONS(951),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(951),
    [anon_sym_PIPE] = ACTIONS(953),
    [anon_sym_SEMI_SEMI] = ACTIONS(951),
    [anon_sym_PIPE_AMP] = ACTIONS(951),
    [anon_sym_AMP_AMP] = ACTIONS(951),
    [anon_sym_PIPE_PIPE] = ACTIONS(951),
    [anon_sym_EQ_TILDE] = ACTIONS(953),
    [anon_sym_EQ_EQ] = ACTIONS(953),
    [anon_sym_LT] = ACTIONS(953),
    [anon_sym_GT] = ACTIONS(953),
    [anon_sym_GT_GT] = ACTIONS(951),
    [anon_sym_AMP_GT] = ACTIONS(953),
    [anon_sym_AMP_GT_GT] = ACTIONS(951),
    [anon_sym_LT_AMP] = ACTIONS(951),
    [anon_sym_GT_AMP] = ACTIONS(951),
    [anon_sym_LT_LT] = ACTIONS(953),
    [anon_sym_LT_LT_DASH] = ACTIONS(951),
    [anon_sym_LT_LT_LT] = ACTIONS(951),
    [sym__special_characters] = ACTIONS(951),
    [anon_sym_DQUOTE] = ACTIONS(951),
    [anon_sym_DOLLAR] = ACTIONS(953),
    [sym_raw_string] = ACTIONS(951),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(951),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(951),
    [anon_sym_BQUOTE] = ACTIONS(951),
    [anon_sym_LT_LPAREN] = ACTIONS(951),
    [anon_sym_GT_LPAREN] = ACTIONS(951),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(953),
    [anon_sym_SEMI] = ACTIONS(953),
    [anon_sym_LF] = ACTIONS(951),
    [anon_sym_AMP] = ACTIONS(953),
  },
  [189] = {
    [ts_builtin_sym_end] = ACTIONS(955),
    [anon_sym_esac] = ACTIONS(955),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_RPAREN] = ACTIONS(955),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_BQUOTE] = ACTIONS(955),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [190] = {
    [sym_file_redirect] = STATE(532),
    [sym_heredoc_redirect] = STATE(532),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(532),
    [aux_sym_while_statement_repeat1] = STATE(532),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(325),
    [ts_builtin_sym_end] = ACTIONS(955),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_LT] = ACTIONS(333),
    [anon_sym_GT] = ACTIONS(333),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(341),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [191] = {
    [sym_file_redirect] = STATE(533),
    [sym_heredoc_redirect] = STATE(533),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(533),
    [sym_concatenation] = STATE(534),
    [sym_string] = STATE(188),
    [sym_simple_expansion] = STATE(188),
    [sym_string_expansion] = STATE(188),
    [sym_expansion] = STATE(188),
    [sym_command_substitution] = STATE(188),
    [sym_process_substitution] = STATE(188),
    [aux_sym_while_statement_repeat1] = STATE(533),
    [aux_sym_command_repeat2] = STATE(534),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(325),
    [ts_builtin_sym_end] = ACTIONS(955),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_EQ_TILDE] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(331),
    [anon_sym_LT] = ACTIONS(333),
    [anon_sym_GT] = ACTIONS(333),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(341),
    [sym__special_characters] = ACTIONS(343),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(347),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [192] = {
    [ts_builtin_sym_end] = ACTIONS(901),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_SEMI_SEMI] = ACTIONS(959),
    [anon_sym_PIPE_AMP] = ACTIONS(315),
    [anon_sym_AMP_AMP] = ACTIONS(317),
    [anon_sym_PIPE_PIPE] = ACTIONS(317),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(961),
    [anon_sym_LF] = ACTIONS(959),
    [anon_sym_AMP] = ACTIONS(961),
  },
  [193] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [ts_builtin_sym_end] = ACTIONS(901),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_SEMI_SEMI] = ACTIONS(959),
    [anon_sym_PIPE_AMP] = ACTIONS(315),
    [anon_sym_AMP_AMP] = ACTIONS(317),
    [anon_sym_PIPE_PIPE] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(961),
    [anon_sym_LF] = ACTIONS(959),
    [anon_sym_AMP] = ACTIONS(961),
  },
  [194] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(536),
    [sym_c_style_for_statement] = STATE(536),
    [sym_while_statement] = STATE(536),
    [sym_if_statement] = STATE(536),
    [sym_case_statement] = STATE(536),
    [sym_function_definition] = STATE(536),
    [sym_subshell] = STATE(536),
    [sym_pipeline] = STATE(536),
    [sym_list] = STATE(536),
    [sym_negated_command] = STATE(536),
    [sym_test_command] = STATE(536),
    [sym_declaration_command] = STATE(536),
    [sym_unset_command] = STATE(536),
    [sym_command] = STATE(536),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(537),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(963),
    [sym_variable_name] = ACTIONS(966),
    [anon_sym_for] = ACTIONS(969),
    [anon_sym_while] = ACTIONS(972),
    [anon_sym_if] = ACTIONS(975),
    [anon_sym_case] = ACTIONS(978),
    [anon_sym_function] = ACTIONS(981),
    [anon_sym_LPAREN] = ACTIONS(984),
    [anon_sym_BANG] = ACTIONS(987),
    [anon_sym_LBRACK] = ACTIONS(990),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(993),
    [anon_sym_declare] = ACTIONS(996),
    [anon_sym_typeset] = ACTIONS(996),
    [anon_sym_export] = ACTIONS(996),
    [anon_sym_readonly] = ACTIONS(996),
    [anon_sym_local] = ACTIONS(996),
    [anon_sym_unset] = ACTIONS(999),
    [anon_sym_unsetenv] = ACTIONS(999),
    [anon_sym_LT] = ACTIONS(1002),
    [anon_sym_GT] = ACTIONS(1002),
    [anon_sym_GT_GT] = ACTIONS(1005),
    [anon_sym_AMP_GT] = ACTIONS(1002),
    [anon_sym_AMP_GT_GT] = ACTIONS(1005),
    [anon_sym_LT_AMP] = ACTIONS(1005),
    [anon_sym_GT_AMP] = ACTIONS(1005),
    [sym__special_characters] = ACTIONS(1008),
    [anon_sym_DQUOTE] = ACTIONS(1011),
    [anon_sym_DOLLAR] = ACTIONS(1014),
    [sym_raw_string] = ACTIONS(1017),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1020),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1023),
    [anon_sym_BQUOTE] = ACTIONS(1026),
    [anon_sym_LT_LPAREN] = ACTIONS(1029),
    [anon_sym_GT_LPAREN] = ACTIONS(1029),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1032),
  },
  [195] = {
    [sym_file_redirect] = STATE(533),
    [sym_heredoc_redirect] = STATE(533),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(533),
    [sym_concatenation] = STATE(538),
    [sym_string] = STATE(188),
    [sym_simple_expansion] = STATE(188),
    [sym_string_expansion] = STATE(188),
    [sym_expansion] = STATE(188),
    [sym_command_substitution] = STATE(188),
    [sym_process_substitution] = STATE(188),
    [aux_sym_while_statement_repeat1] = STATE(533),
    [aux_sym_command_repeat2] = STATE(538),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(325),
    [ts_builtin_sym_end] = ACTIONS(955),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_EQ_TILDE] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(331),
    [anon_sym_LT] = ACTIONS(333),
    [anon_sym_GT] = ACTIONS(333),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(341),
    [sym__special_characters] = ACTIONS(343),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(347),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [196] = {
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(86),
    [sym_file_redirect] = STATE(30),
    [aux_sym_command_repeat1] = STATE(196),
    [sym_file_descriptor] = ACTIONS(1035),
    [sym_variable_name] = ACTIONS(1038),
    [anon_sym_LT] = ACTIONS(1041),
    [anon_sym_GT] = ACTIONS(1041),
    [anon_sym_GT_GT] = ACTIONS(1044),
    [anon_sym_AMP_GT] = ACTIONS(1041),
    [anon_sym_AMP_GT_GT] = ACTIONS(1044),
    [anon_sym_LT_AMP] = ACTIONS(1044),
    [anon_sym_GT_AMP] = ACTIONS(1044),
    [sym__special_characters] = ACTIONS(1047),
    [anon_sym_DQUOTE] = ACTIONS(1047),
    [anon_sym_DOLLAR] = ACTIONS(1049),
    [sym_raw_string] = ACTIONS(1047),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1047),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1047),
    [anon_sym_BQUOTE] = ACTIONS(1047),
    [anon_sym_LT_LPAREN] = ACTIONS(1047),
    [anon_sym_GT_LPAREN] = ACTIONS(1047),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1047),
  },
  [197] = {
    [aux_sym_concatenation_repeat1] = STATE(421),
    [sym_file_descriptor] = ACTIONS(1051),
    [sym__concat] = ACTIONS(729),
    [sym_variable_name] = ACTIONS(1051),
    [anon_sym_LT] = ACTIONS(1053),
    [anon_sym_GT] = ACTIONS(1053),
    [anon_sym_GT_GT] = ACTIONS(1051),
    [anon_sym_AMP_GT] = ACTIONS(1053),
    [anon_sym_AMP_GT_GT] = ACTIONS(1051),
    [anon_sym_LT_AMP] = ACTIONS(1051),
    [anon_sym_GT_AMP] = ACTIONS(1051),
    [sym__special_characters] = ACTIONS(1051),
    [anon_sym_DQUOTE] = ACTIONS(1051),
    [anon_sym_DOLLAR] = ACTIONS(1053),
    [sym_raw_string] = ACTIONS(1051),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1051),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1051),
    [anon_sym_BQUOTE] = ACTIONS(1051),
    [anon_sym_LT_LPAREN] = ACTIONS(1051),
    [anon_sym_GT_LPAREN] = ACTIONS(1051),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1051),
  },
  [198] = {
    [aux_sym_concatenation_repeat1] = STATE(421),
    [sym_file_descriptor] = ACTIONS(1055),
    [sym__concat] = ACTIONS(729),
    [sym_variable_name] = ACTIONS(1055),
    [anon_sym_LT] = ACTIONS(1057),
    [anon_sym_GT] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_AMP_GT] = ACTIONS(1057),
    [anon_sym_AMP_GT_GT] = ACTIONS(1055),
    [anon_sym_LT_AMP] = ACTIONS(1055),
    [anon_sym_GT_AMP] = ACTIONS(1055),
    [sym__special_characters] = ACTIONS(1055),
    [anon_sym_DQUOTE] = ACTIONS(1055),
    [anon_sym_DOLLAR] = ACTIONS(1057),
    [sym_raw_string] = ACTIONS(1055),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1055),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1055),
    [anon_sym_BQUOTE] = ACTIONS(1055),
    [anon_sym_LT_LPAREN] = ACTIONS(1055),
    [anon_sym_GT_LPAREN] = ACTIONS(1055),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1055),
  },
  [199] = {
    [sym_file_descriptor] = ACTIONS(1055),
    [sym_variable_name] = ACTIONS(1055),
    [anon_sym_LT] = ACTIONS(1057),
    [anon_sym_GT] = ACTIONS(1057),
    [anon_sym_GT_GT] = ACTIONS(1055),
    [anon_sym_AMP_GT] = ACTIONS(1057),
    [anon_sym_AMP_GT_GT] = ACTIONS(1055),
    [anon_sym_LT_AMP] = ACTIONS(1055),
    [anon_sym_GT_AMP] = ACTIONS(1055),
    [sym__special_characters] = ACTIONS(1055),
    [anon_sym_DQUOTE] = ACTIONS(1055),
    [anon_sym_DOLLAR] = ACTIONS(1057),
    [sym_raw_string] = ACTIONS(1055),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1055),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1055),
    [anon_sym_BQUOTE] = ACTIONS(1055),
    [anon_sym_LT_LPAREN] = ACTIONS(1055),
    [anon_sym_GT_LPAREN] = ACTIONS(1055),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1055),
  },
  [200] = {
    [aux_sym_concatenation_repeat1] = STATE(541),
    [sym__concat] = ACTIONS(1059),
    [anon_sym_RBRACK] = ACTIONS(1061),
    [sym_comment] = ACTIONS(53),
  },
  [201] = {
    [aux_sym_concatenation_repeat1] = STATE(541),
    [sym__concat] = ACTIONS(1063),
    [anon_sym_RBRACK] = ACTIONS(1065),
    [sym_comment] = ACTIONS(53),
  },
  [202] = {
    [sym__concat] = ACTIONS(1067),
    [anon_sym_RBRACK] = ACTIONS(1065),
    [sym_comment] = ACTIONS(53),
  },
  [203] = {
    [sym_file_descriptor] = ACTIONS(1069),
    [sym_variable_name] = ACTIONS(1069),
    [ts_builtin_sym_end] = ACTIONS(1069),
    [anon_sym_PIPE] = ACTIONS(1071),
    [anon_sym_RPAREN] = ACTIONS(1069),
    [anon_sym_SEMI_SEMI] = ACTIONS(1069),
    [anon_sym_PIPE_AMP] = ACTIONS(1069),
    [anon_sym_AMP_AMP] = ACTIONS(1069),
    [anon_sym_PIPE_PIPE] = ACTIONS(1069),
    [anon_sym_LT] = ACTIONS(1071),
    [anon_sym_GT] = ACTIONS(1071),
    [anon_sym_GT_GT] = ACTIONS(1069),
    [anon_sym_AMP_GT] = ACTIONS(1071),
    [anon_sym_AMP_GT_GT] = ACTIONS(1069),
    [anon_sym_LT_AMP] = ACTIONS(1069),
    [anon_sym_GT_AMP] = ACTIONS(1069),
    [sym__special_characters] = ACTIONS(1069),
    [anon_sym_DQUOTE] = ACTIONS(1069),
    [anon_sym_DOLLAR] = ACTIONS(1071),
    [sym_raw_string] = ACTIONS(1069),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1069),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1069),
    [anon_sym_BQUOTE] = ACTIONS(1069),
    [anon_sym_LT_LPAREN] = ACTIONS(1069),
    [anon_sym_GT_LPAREN] = ACTIONS(1069),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1071),
    [anon_sym_SEMI] = ACTIONS(1071),
    [anon_sym_LF] = ACTIONS(1069),
    [anon_sym_AMP] = ACTIONS(1071),
  },
  [204] = {
    [sym_concatenation] = STATE(554),
    [sym_string] = STATE(549),
    [sym_simple_expansion] = STATE(549),
    [sym_string_expansion] = STATE(549),
    [sym_expansion] = STATE(549),
    [sym_command_substitution] = STATE(549),
    [sym_process_substitution] = STATE(549),
    [aux_sym_for_statement_repeat1] = STATE(554),
    [anon_sym_RPAREN] = ACTIONS(1073),
    [sym__special_characters] = ACTIONS(1075),
    [anon_sym_DQUOTE] = ACTIONS(1077),
    [anon_sym_DOLLAR] = ACTIONS(1079),
    [sym_raw_string] = ACTIONS(1081),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1083),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1085),
    [anon_sym_BQUOTE] = ACTIONS(1087),
    [anon_sym_LT_LPAREN] = ACTIONS(1089),
    [anon_sym_GT_LPAREN] = ACTIONS(1089),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1081),
  },
  [205] = {
    [aux_sym_concatenation_repeat1] = STATE(556),
    [sym_file_descriptor] = ACTIONS(1091),
    [sym__concat] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(1091),
    [ts_builtin_sym_end] = ACTIONS(1091),
    [anon_sym_PIPE] = ACTIONS(1095),
    [anon_sym_SEMI_SEMI] = ACTIONS(1091),
    [anon_sym_PIPE_AMP] = ACTIONS(1091),
    [anon_sym_AMP_AMP] = ACTIONS(1091),
    [anon_sym_PIPE_PIPE] = ACTIONS(1091),
    [anon_sym_LT] = ACTIONS(1095),
    [anon_sym_GT] = ACTIONS(1095),
    [anon_sym_GT_GT] = ACTIONS(1091),
    [anon_sym_AMP_GT] = ACTIONS(1095),
    [anon_sym_AMP_GT_GT] = ACTIONS(1091),
    [anon_sym_LT_AMP] = ACTIONS(1091),
    [anon_sym_GT_AMP] = ACTIONS(1091),
    [sym__special_characters] = ACTIONS(1091),
    [anon_sym_DQUOTE] = ACTIONS(1091),
    [anon_sym_DOLLAR] = ACTIONS(1095),
    [sym_raw_string] = ACTIONS(1091),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1091),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1091),
    [anon_sym_BQUOTE] = ACTIONS(1091),
    [anon_sym_LT_LPAREN] = ACTIONS(1091),
    [anon_sym_GT_LPAREN] = ACTIONS(1091),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1095),
    [anon_sym_SEMI] = ACTIONS(1095),
    [anon_sym_LF] = ACTIONS(1091),
    [anon_sym_AMP] = ACTIONS(1095),
  },
  [206] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(559),
    [anon_sym_DQUOTE] = ACTIONS(1097),
    [anon_sym_DOLLAR] = ACTIONS(1099),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [207] = {
    [sym_string] = STATE(561),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(1101),
    [sym_raw_string] = ACTIONS(1103),
    [anon_sym_POUND] = ACTIONS(1101),
    [anon_sym_DASH] = ACTIONS(1101),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1105),
    [anon_sym_STAR] = ACTIONS(1101),
    [anon_sym_AT] = ACTIONS(1101),
    [anon_sym_QMARK] = ACTIONS(1101),
    [anon_sym_0] = ACTIONS(1107),
    [anon_sym__] = ACTIONS(1107),
  },
  [208] = {
    [aux_sym_concatenation_repeat1] = STATE(556),
    [sym_file_descriptor] = ACTIONS(1069),
    [sym__concat] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(1069),
    [ts_builtin_sym_end] = ACTIONS(1069),
    [anon_sym_PIPE] = ACTIONS(1071),
    [anon_sym_SEMI_SEMI] = ACTIONS(1069),
    [anon_sym_PIPE_AMP] = ACTIONS(1069),
    [anon_sym_AMP_AMP] = ACTIONS(1069),
    [anon_sym_PIPE_PIPE] = ACTIONS(1069),
    [anon_sym_LT] = ACTIONS(1071),
    [anon_sym_GT] = ACTIONS(1071),
    [anon_sym_GT_GT] = ACTIONS(1069),
    [anon_sym_AMP_GT] = ACTIONS(1071),
    [anon_sym_AMP_GT_GT] = ACTIONS(1069),
    [anon_sym_LT_AMP] = ACTIONS(1069),
    [anon_sym_GT_AMP] = ACTIONS(1069),
    [sym__special_characters] = ACTIONS(1069),
    [anon_sym_DQUOTE] = ACTIONS(1069),
    [anon_sym_DOLLAR] = ACTIONS(1071),
    [sym_raw_string] = ACTIONS(1069),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1069),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1069),
    [anon_sym_BQUOTE] = ACTIONS(1069),
    [anon_sym_LT_LPAREN] = ACTIONS(1069),
    [anon_sym_GT_LPAREN] = ACTIONS(1069),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1071),
    [anon_sym_SEMI] = ACTIONS(1071),
    [anon_sym_LF] = ACTIONS(1069),
    [anon_sym_AMP] = ACTIONS(1071),
  },
  [209] = {
    [sym_subscript] = STATE(567),
    [sym_variable_name] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_DOLLAR] = ACTIONS(1113),
    [anon_sym_POUND] = ACTIONS(1111),
    [anon_sym_DASH] = ACTIONS(1113),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1115),
    [anon_sym_STAR] = ACTIONS(1113),
    [anon_sym_AT] = ACTIONS(1113),
    [anon_sym_QMARK] = ACTIONS(1113),
    [anon_sym_0] = ACTIONS(1117),
    [anon_sym__] = ACTIONS(1117),
  },
  [210] = {
    [sym__terminated_statement] = STATE(570),
    [sym_for_statement] = STATE(568),
    [sym_c_style_for_statement] = STATE(568),
    [sym_while_statement] = STATE(568),
    [sym_if_statement] = STATE(568),
    [sym_case_statement] = STATE(568),
    [sym_function_definition] = STATE(568),
    [sym_subshell] = STATE(568),
    [sym_pipeline] = STATE(568),
    [sym_list] = STATE(568),
    [sym_negated_command] = STATE(568),
    [sym_test_command] = STATE(568),
    [sym_declaration_command] = STATE(568),
    [sym_unset_command] = STATE(568),
    [sym_command] = STATE(568),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(569),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(570),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [211] = {
    [sym__terminated_statement] = STATE(573),
    [sym_for_statement] = STATE(571),
    [sym_c_style_for_statement] = STATE(571),
    [sym_while_statement] = STATE(571),
    [sym_if_statement] = STATE(571),
    [sym_case_statement] = STATE(571),
    [sym_function_definition] = STATE(571),
    [sym_subshell] = STATE(571),
    [sym_pipeline] = STATE(571),
    [sym_list] = STATE(571),
    [sym_negated_command] = STATE(571),
    [sym_test_command] = STATE(571),
    [sym_declaration_command] = STATE(571),
    [sym_unset_command] = STATE(571),
    [sym_command] = STATE(571),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(572),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(573),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [212] = {
    [sym__terminated_statement] = STATE(576),
    [sym_for_statement] = STATE(574),
    [sym_c_style_for_statement] = STATE(574),
    [sym_while_statement] = STATE(574),
    [sym_if_statement] = STATE(574),
    [sym_case_statement] = STATE(574),
    [sym_function_definition] = STATE(574),
    [sym_subshell] = STATE(574),
    [sym_pipeline] = STATE(574),
    [sym_list] = STATE(574),
    [sym_negated_command] = STATE(574),
    [sym_test_command] = STATE(574),
    [sym_declaration_command] = STATE(574),
    [sym_unset_command] = STATE(574),
    [sym_command] = STATE(574),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(575),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(576),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [213] = {
    [sym__expression] = STATE(578),
    [sym_binary_expression] = STATE(578),
    [sym_unary_expression] = STATE(578),
    [sym_parenthesized_expression] = STATE(578),
    [sym_concatenation] = STATE(578),
    [sym_string] = STATE(219),
    [sym_simple_expansion] = STATE(219),
    [sym_string_expansion] = STATE(219),
    [sym_expansion] = STATE(219),
    [sym_command_substitution] = STATE(219),
    [sym_process_substitution] = STATE(219),
    [anon_sym_SEMI_SEMI] = ACTIONS(1119),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [sym__special_characters] = ACTIONS(389),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(395),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(397),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(401),
    [anon_sym_LT_LPAREN] = ACTIONS(403),
    [anon_sym_GT_LPAREN] = ACTIONS(403),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(405),
    [sym_test_operator] = ACTIONS(407),
    [anon_sym_SEMI] = ACTIONS(1121),
    [anon_sym_LF] = ACTIONS(1119),
    [anon_sym_AMP] = ACTIONS(1119),
  },
  [214] = {
    [sym__expression] = STATE(579),
    [sym_binary_expression] = STATE(579),
    [sym_unary_expression] = STATE(579),
    [sym_parenthesized_expression] = STATE(579),
    [sym_concatenation] = STATE(579),
    [sym_string] = STATE(319),
    [sym_simple_expansion] = STATE(319),
    [sym_string_expansion] = STATE(319),
    [sym_expansion] = STATE(319),
    [sym_command_substitution] = STATE(319),
    [sym_process_substitution] = STATE(319),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(565),
    [sym__special_characters] = ACTIONS(567),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(569),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(571),
    [sym_test_operator] = ACTIONS(573),
  },
  [215] = {
    [sym__expression] = STATE(580),
    [sym_binary_expression] = STATE(580),
    [sym_unary_expression] = STATE(580),
    [sym_parenthesized_expression] = STATE(580),
    [sym_concatenation] = STATE(580),
    [sym_string] = STATE(219),
    [sym_simple_expansion] = STATE(219),
    [sym_string_expansion] = STATE(219),
    [sym_expansion] = STATE(219),
    [sym_command_substitution] = STATE(219),
    [sym_process_substitution] = STATE(219),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [sym__special_characters] = ACTIONS(389),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(395),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(397),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(401),
    [anon_sym_LT_LPAREN] = ACTIONS(403),
    [anon_sym_GT_LPAREN] = ACTIONS(403),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(405),
    [sym_test_operator] = ACTIONS(407),
  },
  [216] = {
    [aux_sym_concatenation_repeat1] = STATE(582),
    [sym__concat] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(577),
    [anon_sym_AMP_AMP] = ACTIONS(577),
    [anon_sym_PIPE_PIPE] = ACTIONS(577),
    [anon_sym_EQ_TILDE] = ACTIONS(577),
    [anon_sym_EQ_EQ] = ACTIONS(577),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_BANG_EQ] = ACTIONS(577),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(577),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_LF] = ACTIONS(577),
    [anon_sym_AMP] = ACTIONS(579),
  },
  [217] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(585),
    [anon_sym_DQUOTE] = ACTIONS(1125),
    [anon_sym_DOLLAR] = ACTIONS(1127),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [218] = {
    [sym_string] = STATE(587),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(1129),
    [sym_raw_string] = ACTIONS(1131),
    [anon_sym_POUND] = ACTIONS(1129),
    [anon_sym_DASH] = ACTIONS(1129),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1133),
    [anon_sym_STAR] = ACTIONS(1129),
    [anon_sym_AT] = ACTIONS(1129),
    [anon_sym_QMARK] = ACTIONS(1129),
    [anon_sym_0] = ACTIONS(1135),
    [anon_sym__] = ACTIONS(1135),
  },
  [219] = {
    [aux_sym_concatenation_repeat1] = STATE(582),
    [sym__concat] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(593),
    [anon_sym_AMP_AMP] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_EQ_TILDE] = ACTIONS(593),
    [anon_sym_EQ_EQ] = ACTIONS(593),
    [anon_sym_EQ] = ACTIONS(595),
    [anon_sym_LT] = ACTIONS(593),
    [anon_sym_GT] = ACTIONS(593),
    [anon_sym_BANG_EQ] = ACTIONS(593),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(593),
    [anon_sym_SEMI] = ACTIONS(595),
    [anon_sym_LF] = ACTIONS(593),
    [anon_sym_AMP] = ACTIONS(595),
  },
  [220] = {
    [sym_subscript] = STATE(593),
    [sym_variable_name] = ACTIONS(1137),
    [anon_sym_BANG] = ACTIONS(1139),
    [anon_sym_DOLLAR] = ACTIONS(1141),
    [anon_sym_POUND] = ACTIONS(1139),
    [anon_sym_DASH] = ACTIONS(1141),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1143),
    [anon_sym_STAR] = ACTIONS(1141),
    [anon_sym_AT] = ACTIONS(1141),
    [anon_sym_QMARK] = ACTIONS(1141),
    [anon_sym_0] = ACTIONS(1145),
    [anon_sym__] = ACTIONS(1145),
  },
  [221] = {
    [sym__terminated_statement] = STATE(596),
    [sym_for_statement] = STATE(594),
    [sym_c_style_for_statement] = STATE(594),
    [sym_while_statement] = STATE(594),
    [sym_if_statement] = STATE(594),
    [sym_case_statement] = STATE(594),
    [sym_function_definition] = STATE(594),
    [sym_subshell] = STATE(594),
    [sym_pipeline] = STATE(594),
    [sym_list] = STATE(594),
    [sym_negated_command] = STATE(594),
    [sym_test_command] = STATE(594),
    [sym_declaration_command] = STATE(594),
    [sym_unset_command] = STATE(594),
    [sym_command] = STATE(594),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(595),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(596),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [222] = {
    [sym__terminated_statement] = STATE(599),
    [sym_for_statement] = STATE(597),
    [sym_c_style_for_statement] = STATE(597),
    [sym_while_statement] = STATE(597),
    [sym_if_statement] = STATE(597),
    [sym_case_statement] = STATE(597),
    [sym_function_definition] = STATE(597),
    [sym_subshell] = STATE(597),
    [sym_pipeline] = STATE(597),
    [sym_list] = STATE(597),
    [sym_negated_command] = STATE(597),
    [sym_test_command] = STATE(597),
    [sym_declaration_command] = STATE(597),
    [sym_unset_command] = STATE(597),
    [sym_command] = STATE(597),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(598),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(599),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [223] = {
    [sym__terminated_statement] = STATE(602),
    [sym_for_statement] = STATE(600),
    [sym_c_style_for_statement] = STATE(600),
    [sym_while_statement] = STATE(600),
    [sym_if_statement] = STATE(600),
    [sym_case_statement] = STATE(600),
    [sym_function_definition] = STATE(600),
    [sym_subshell] = STATE(600),
    [sym_pipeline] = STATE(600),
    [sym_list] = STATE(600),
    [sym_negated_command] = STATE(600),
    [sym_test_command] = STATE(600),
    [sym_declaration_command] = STATE(600),
    [sym_unset_command] = STATE(600),
    [sym_command] = STATE(600),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(601),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(602),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [224] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(1147),
    [anon_sym_AMP_AMP] = ACTIONS(1149),
    [anon_sym_PIPE_PIPE] = ACTIONS(1149),
    [anon_sym_EQ_TILDE] = ACTIONS(1151),
    [anon_sym_EQ_EQ] = ACTIONS(1151),
    [anon_sym_EQ] = ACTIONS(1153),
    [anon_sym_LT] = ACTIONS(1149),
    [anon_sym_GT] = ACTIONS(1149),
    [anon_sym_BANG_EQ] = ACTIONS(1149),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(1149),
    [anon_sym_SEMI] = ACTIONS(1155),
    [anon_sym_LF] = ACTIONS(1147),
    [anon_sym_AMP] = ACTIONS(1155),
  },
  [225] = {
    [sym_concatenation] = STATE(614),
    [sym_string] = STATE(609),
    [sym_simple_expansion] = STATE(609),
    [sym_string_expansion] = STATE(609),
    [sym_expansion] = STATE(609),
    [sym_command_substitution] = STATE(609),
    [sym_process_substitution] = STATE(609),
    [aux_sym_for_statement_repeat1] = STATE(614),
    [sym__special_characters] = ACTIONS(1157),
    [anon_sym_DQUOTE] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(1161),
    [sym_raw_string] = ACTIONS(1163),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1165),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1167),
    [anon_sym_BQUOTE] = ACTIONS(1169),
    [anon_sym_LT_LPAREN] = ACTIONS(1171),
    [anon_sym_GT_LPAREN] = ACTIONS(1171),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1163),
  },
  [226] = {
    [sym_do_group] = STATE(616),
    [anon_sym_do] = ACTIONS(1173),
    [sym_comment] = ACTIONS(53),
  },
  [227] = {
    [sym_concatenation] = STATE(203),
    [sym_string] = STATE(618),
    [sym_array] = STATE(203),
    [sym_simple_expansion] = STATE(618),
    [sym_string_expansion] = STATE(618),
    [sym_expansion] = STATE(618),
    [sym_command_substitution] = STATE(618),
    [sym_process_substitution] = STATE(618),
    [sym__empty_value] = ACTIONS(363),
    [anon_sym_LPAREN] = ACTIONS(365),
    [sym__special_characters] = ACTIONS(1175),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(1177),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(375),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(377),
    [anon_sym_BQUOTE] = ACTIONS(379),
    [anon_sym_LT_LPAREN] = ACTIONS(381),
    [anon_sym_GT_LPAREN] = ACTIONS(381),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1177),
  },
  [228] = {
    [sym_do_group] = STATE(619),
    [anon_sym_do] = ACTIONS(437),
    [sym_comment] = ACTIONS(53),
  },
  [229] = {
    [sym_compound_statement] = STATE(621),
    [anon_sym_LPAREN] = ACTIONS(1179),
    [anon_sym_LBRACE] = ACTIONS(507),
    [sym_comment] = ACTIONS(53),
  },
  [230] = {
    [anon_sym_AMP_AMP] = ACTIONS(607),
    [anon_sym_PIPE_PIPE] = ACTIONS(607),
    [anon_sym_RBRACK] = ACTIONS(1181),
    [anon_sym_EQ_TILDE] = ACTIONS(611),
    [anon_sym_EQ_EQ] = ACTIONS(611),
    [anon_sym_EQ] = ACTIONS(613),
    [anon_sym_LT] = ACTIONS(607),
    [anon_sym_GT] = ACTIONS(607),
    [anon_sym_BANG_EQ] = ACTIONS(607),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(607),
  },
  [231] = {
    [anon_sym_AMP_AMP] = ACTIONS(639),
    [anon_sym_PIPE_PIPE] = ACTIONS(639),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1181),
    [anon_sym_EQ_TILDE] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(641),
    [anon_sym_EQ] = ACTIONS(643),
    [anon_sym_LT] = ACTIONS(639),
    [anon_sym_GT] = ACTIONS(639),
    [anon_sym_BANG_EQ] = ACTIONS(639),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(639),
  },
  [232] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(1183),
    [anon_sym_PLUS_EQ] = ACTIONS(1183),
    [sym_comment] = ACTIONS(53),
  },
  [233] = {
    [aux_sym_concatenation_repeat1] = STATE(624),
    [sym__concat] = ACTIONS(647),
    [sym_variable_name] = ACTIONS(649),
    [anon_sym_PIPE] = ACTIONS(651),
    [anon_sym_SEMI_SEMI] = ACTIONS(649),
    [anon_sym_PIPE_AMP] = ACTIONS(649),
    [anon_sym_AMP_AMP] = ACTIONS(649),
    [anon_sym_PIPE_PIPE] = ACTIONS(649),
    [sym__special_characters] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(649),
    [anon_sym_DOLLAR] = ACTIONS(651),
    [sym_raw_string] = ACTIONS(649),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(649),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(649),
    [anon_sym_BQUOTE] = ACTIONS(649),
    [anon_sym_LT_LPAREN] = ACTIONS(649),
    [anon_sym_GT_LPAREN] = ACTIONS(649),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(651),
    [sym_word] = ACTIONS(651),
    [anon_sym_SEMI] = ACTIONS(651),
    [anon_sym_LF] = ACTIONS(649),
    [anon_sym_AMP] = ACTIONS(651),
  },
  [234] = {
    [aux_sym_concatenation_repeat1] = STATE(624),
    [sym__concat] = ACTIONS(647),
    [sym_variable_name] = ACTIONS(665),
    [anon_sym_PIPE] = ACTIONS(667),
    [anon_sym_SEMI_SEMI] = ACTIONS(665),
    [anon_sym_PIPE_AMP] = ACTIONS(665),
    [anon_sym_AMP_AMP] = ACTIONS(665),
    [anon_sym_PIPE_PIPE] = ACTIONS(665),
    [sym__special_characters] = ACTIONS(665),
    [anon_sym_DQUOTE] = ACTIONS(665),
    [anon_sym_DOLLAR] = ACTIONS(667),
    [sym_raw_string] = ACTIONS(665),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(665),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(665),
    [anon_sym_BQUOTE] = ACTIONS(665),
    [anon_sym_LT_LPAREN] = ACTIONS(665),
    [anon_sym_GT_LPAREN] = ACTIONS(665),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(667),
    [sym_word] = ACTIONS(667),
    [anon_sym_SEMI] = ACTIONS(667),
    [anon_sym_LF] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
  },
  [235] = {
    [anon_sym_EQ] = ACTIONS(1183),
    [anon_sym_PLUS_EQ] = ACTIONS(1183),
    [sym_comment] = ACTIONS(53),
  },
  [236] = {
    [sym_variable_assignment] = STATE(625),
    [sym_subscript] = STATE(235),
    [sym_concatenation] = STATE(625),
    [sym_string] = STATE(234),
    [sym_simple_expansion] = STATE(234),
    [sym_string_expansion] = STATE(234),
    [sym_expansion] = STATE(234),
    [sym_command_substitution] = STATE(234),
    [sym_process_substitution] = STATE(234),
    [aux_sym_declaration_command_repeat1] = STATE(625),
    [sym_variable_name] = ACTIONS(421),
    [anon_sym_PIPE] = ACTIONS(685),
    [anon_sym_SEMI_SEMI] = ACTIONS(683),
    [anon_sym_PIPE_AMP] = ACTIONS(683),
    [anon_sym_AMP_AMP] = ACTIONS(683),
    [anon_sym_PIPE_PIPE] = ACTIONS(683),
    [sym__special_characters] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(425),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(203),
    [sym_word] = ACTIONS(427),
    [anon_sym_SEMI] = ACTIONS(685),
    [anon_sym_LF] = ACTIONS(683),
    [anon_sym_AMP] = ACTIONS(685),
  },
  [237] = {
    [aux_sym_concatenation_repeat1] = STATE(626),
    [sym__concat] = ACTIONS(687),
    [anon_sym_PIPE] = ACTIONS(691),
    [anon_sym_SEMI_SEMI] = ACTIONS(689),
    [anon_sym_PIPE_AMP] = ACTIONS(689),
    [anon_sym_AMP_AMP] = ACTIONS(689),
    [anon_sym_PIPE_PIPE] = ACTIONS(689),
    [sym__special_characters] = ACTIONS(689),
    [anon_sym_DQUOTE] = ACTIONS(689),
    [anon_sym_DOLLAR] = ACTIONS(691),
    [sym_raw_string] = ACTIONS(689),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(689),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(689),
    [anon_sym_BQUOTE] = ACTIONS(689),
    [anon_sym_LT_LPAREN] = ACTIONS(689),
    [anon_sym_GT_LPAREN] = ACTIONS(689),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(691),
    [sym_word] = ACTIONS(691),
    [anon_sym_SEMI] = ACTIONS(691),
    [anon_sym_LF] = ACTIONS(689),
    [anon_sym_AMP] = ACTIONS(691),
  },
  [238] = {
    [aux_sym_concatenation_repeat1] = STATE(626),
    [sym__concat] = ACTIONS(687),
    [anon_sym_PIPE] = ACTIONS(707),
    [anon_sym_SEMI_SEMI] = ACTIONS(705),
    [anon_sym_PIPE_AMP] = ACTIONS(705),
    [anon_sym_AMP_AMP] = ACTIONS(705),
    [anon_sym_PIPE_PIPE] = ACTIONS(705),
    [sym__special_characters] = ACTIONS(705),
    [anon_sym_DQUOTE] = ACTIONS(705),
    [anon_sym_DOLLAR] = ACTIONS(707),
    [sym_raw_string] = ACTIONS(705),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(705),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(705),
    [anon_sym_BQUOTE] = ACTIONS(705),
    [anon_sym_LT_LPAREN] = ACTIONS(705),
    [anon_sym_GT_LPAREN] = ACTIONS(705),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(707),
    [sym_word] = ACTIONS(707),
    [anon_sym_SEMI] = ACTIONS(707),
    [anon_sym_LF] = ACTIONS(705),
    [anon_sym_AMP] = ACTIONS(707),
  },
  [239] = {
    [sym_concatenation] = STATE(627),
    [sym_string] = STATE(238),
    [sym_simple_expansion] = STATE(238),
    [sym_string_expansion] = STATE(238),
    [sym_expansion] = STATE(238),
    [sym_command_substitution] = STATE(238),
    [sym_process_substitution] = STATE(238),
    [aux_sym_unset_command_repeat1] = STATE(627),
    [anon_sym_PIPE] = ACTIONS(725),
    [anon_sym_SEMI_SEMI] = ACTIONS(723),
    [anon_sym_PIPE_AMP] = ACTIONS(723),
    [anon_sym_AMP_AMP] = ACTIONS(723),
    [anon_sym_PIPE_PIPE] = ACTIONS(723),
    [sym__special_characters] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(431),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(227),
    [sym_word] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(725),
    [anon_sym_LF] = ACTIONS(723),
    [anon_sym_AMP] = ACTIONS(725),
  },
  [240] = {
    [aux_sym_concatenation_repeat1] = STATE(628),
    [sym__simple_heredoc_body] = ACTIONS(761),
    [sym__heredoc_body_beginning] = ACTIONS(761),
    [sym_file_descriptor] = ACTIONS(761),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(763),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [anon_sym_PIPE_AMP] = ACTIONS(761),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [anon_sym_EQ_TILDE] = ACTIONS(763),
    [anon_sym_EQ_EQ] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(763),
    [anon_sym_GT] = ACTIONS(763),
    [anon_sym_GT_GT] = ACTIONS(761),
    [anon_sym_AMP_GT] = ACTIONS(763),
    [anon_sym_AMP_GT_GT] = ACTIONS(761),
    [anon_sym_LT_AMP] = ACTIONS(761),
    [anon_sym_GT_AMP] = ACTIONS(761),
    [anon_sym_LT_LT] = ACTIONS(763),
    [anon_sym_LT_LT_DASH] = ACTIONS(761),
    [anon_sym_LT_LT_LT] = ACTIONS(761),
    [sym__special_characters] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(763),
    [sym_raw_string] = ACTIONS(761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(761),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(761),
    [anon_sym_LT_LPAREN] = ACTIONS(761),
    [anon_sym_GT_LPAREN] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(763),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
  },
  [241] = {
    [anon_sym_RPAREN] = ACTIONS(1185),
    [sym_comment] = ACTIONS(53),
  },
  [242] = {
    [sym__terminated_statement] = STATE(631),
    [sym_for_statement] = STATE(536),
    [sym_c_style_for_statement] = STATE(536),
    [sym_while_statement] = STATE(536),
    [sym_if_statement] = STATE(536),
    [sym_case_statement] = STATE(536),
    [sym_function_definition] = STATE(536),
    [sym_subshell] = STATE(536),
    [sym_pipeline] = STATE(536),
    [sym_list] = STATE(536),
    [sym_negated_command] = STATE(536),
    [sym_test_command] = STATE(536),
    [sym_declaration_command] = STATE(536),
    [sym_unset_command] = STATE(536),
    [sym_command] = STATE(536),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(537),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(631),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_done] = ACTIONS(1187),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [243] = {
    [sym_file_redirect] = STATE(633),
    [sym_heredoc_redirect] = STATE(633),
    [sym_heredoc_body] = STATE(632),
    [sym_herestring_redirect] = STATE(633),
    [aux_sym_while_statement_repeat1] = STATE(633),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(325),
    [ts_builtin_sym_end] = ACTIONS(1189),
    [anon_sym_PIPE] = ACTIONS(1191),
    [anon_sym_SEMI_SEMI] = ACTIONS(1189),
    [anon_sym_PIPE_AMP] = ACTIONS(1189),
    [anon_sym_AMP_AMP] = ACTIONS(1189),
    [anon_sym_PIPE_PIPE] = ACTIONS(1189),
    [anon_sym_LT] = ACTIONS(333),
    [anon_sym_GT] = ACTIONS(333),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(341),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1191),
    [anon_sym_LF] = ACTIONS(1189),
    [anon_sym_AMP] = ACTIONS(1191),
  },
  [244] = {
    [sym_for_statement] = STATE(512),
    [sym_c_style_for_statement] = STATE(512),
    [sym_while_statement] = STATE(512),
    [sym_if_statement] = STATE(512),
    [sym_case_statement] = STATE(512),
    [sym_function_definition] = STATE(512),
    [sym_subshell] = STATE(512),
    [sym_pipeline] = STATE(512),
    [sym_list] = STATE(512),
    [sym_negated_command] = STATE(512),
    [sym_test_command] = STATE(512),
    [sym_declaration_command] = STATE(512),
    [sym_unset_command] = STATE(512),
    [sym_command] = STATE(512),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(513),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [245] = {
    [anon_sym_do] = ACTIONS(899),
    [anon_sym_then] = ACTIONS(899),
    [sym_comment] = ACTIONS(53),
  },
  [246] = {
    [sym_for_statement] = STATE(634),
    [sym_c_style_for_statement] = STATE(634),
    [sym_while_statement] = STATE(634),
    [sym_if_statement] = STATE(634),
    [sym_case_statement] = STATE(634),
    [sym_function_definition] = STATE(634),
    [sym_subshell] = STATE(634),
    [sym_pipeline] = STATE(634),
    [sym_list] = STATE(634),
    [sym_negated_command] = STATE(634),
    [sym_test_command] = STATE(634),
    [sym_declaration_command] = STATE(634),
    [sym_unset_command] = STATE(634),
    [sym_command] = STATE(634),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(635),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [247] = {
    [anon_sym_LT] = ACTIONS(1193),
    [anon_sym_GT] = ACTIONS(1193),
    [anon_sym_GT_GT] = ACTIONS(1195),
    [anon_sym_AMP_GT] = ACTIONS(1193),
    [anon_sym_AMP_GT_GT] = ACTIONS(1195),
    [anon_sym_LT_AMP] = ACTIONS(1195),
    [anon_sym_GT_AMP] = ACTIONS(1195),
    [sym_comment] = ACTIONS(53),
  },
  [248] = {
    [sym_concatenation] = STATE(523),
    [sym_string] = STATE(638),
    [sym_simple_expansion] = STATE(638),
    [sym_string_expansion] = STATE(638),
    [sym_expansion] = STATE(638),
    [sym_command_substitution] = STATE(638),
    [sym_process_substitution] = STATE(638),
    [sym__special_characters] = ACTIONS(1197),
    [anon_sym_DQUOTE] = ACTIONS(923),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1199),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(927),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(929),
    [anon_sym_BQUOTE] = ACTIONS(931),
    [anon_sym_LT_LPAREN] = ACTIONS(933),
    [anon_sym_GT_LPAREN] = ACTIONS(933),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(1199),
    [sym_regex] = ACTIONS(935),
  },
  [249] = {
    [sym_concatenation] = STATE(526),
    [sym_string] = STATE(640),
    [sym_simple_expansion] = STATE(640),
    [sym_string_expansion] = STATE(640),
    [sym_expansion] = STATE(640),
    [sym_command_substitution] = STATE(640),
    [sym_process_substitution] = STATE(640),
    [sym__special_characters] = ACTIONS(1201),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1203),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1203),
  },
  [250] = {
    [sym_concatenation] = STATE(530),
    [sym_string] = STATE(642),
    [sym_simple_expansion] = STATE(642),
    [sym_string_expansion] = STATE(642),
    [sym_expansion] = STATE(642),
    [sym_command_substitution] = STATE(642),
    [sym_process_substitution] = STATE(642),
    [sym__special_characters] = ACTIONS(1205),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1207),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1207),
  },
  [251] = {
    [aux_sym_concatenation_repeat1] = STATE(240),
    [sym__simple_heredoc_body] = ACTIONS(947),
    [sym__heredoc_body_beginning] = ACTIONS(947),
    [sym_file_descriptor] = ACTIONS(947),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(949),
    [anon_sym_SEMI_SEMI] = ACTIONS(947),
    [anon_sym_PIPE_AMP] = ACTIONS(947),
    [anon_sym_AMP_AMP] = ACTIONS(947),
    [anon_sym_PIPE_PIPE] = ACTIONS(947),
    [anon_sym_EQ_TILDE] = ACTIONS(949),
    [anon_sym_EQ_EQ] = ACTIONS(949),
    [anon_sym_LT] = ACTIONS(949),
    [anon_sym_GT] = ACTIONS(949),
    [anon_sym_GT_GT] = ACTIONS(947),
    [anon_sym_AMP_GT] = ACTIONS(949),
    [anon_sym_AMP_GT_GT] = ACTIONS(947),
    [anon_sym_LT_AMP] = ACTIONS(947),
    [anon_sym_GT_AMP] = ACTIONS(947),
    [anon_sym_LT_LT] = ACTIONS(949),
    [anon_sym_LT_LT_DASH] = ACTIONS(947),
    [anon_sym_LT_LT_LT] = ACTIONS(947),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(947),
    [anon_sym_DOLLAR] = ACTIONS(949),
    [sym_raw_string] = ACTIONS(947),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(947),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(947),
    [anon_sym_BQUOTE] = ACTIONS(947),
    [anon_sym_LT_LPAREN] = ACTIONS(947),
    [anon_sym_GT_LPAREN] = ACTIONS(947),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(949),
    [anon_sym_SEMI] = ACTIONS(949),
    [anon_sym_LF] = ACTIONS(947),
    [anon_sym_AMP] = ACTIONS(949),
  },
  [252] = {
    [aux_sym_concatenation_repeat1] = STATE(240),
    [sym__simple_heredoc_body] = ACTIONS(951),
    [sym__heredoc_body_beginning] = ACTIONS(951),
    [sym_file_descriptor] = ACTIONS(951),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(953),
    [anon_sym_SEMI_SEMI] = ACTIONS(951),
    [anon_sym_PIPE_AMP] = ACTIONS(951),
    [anon_sym_AMP_AMP] = ACTIONS(951),
    [anon_sym_PIPE_PIPE] = ACTIONS(951),
    [anon_sym_EQ_TILDE] = ACTIONS(953),
    [anon_sym_EQ_EQ] = ACTIONS(953),
    [anon_sym_LT] = ACTIONS(953),
    [anon_sym_GT] = ACTIONS(953),
    [anon_sym_GT_GT] = ACTIONS(951),
    [anon_sym_AMP_GT] = ACTIONS(953),
    [anon_sym_AMP_GT_GT] = ACTIONS(951),
    [anon_sym_LT_AMP] = ACTIONS(951),
    [anon_sym_GT_AMP] = ACTIONS(951),
    [anon_sym_LT_LT] = ACTIONS(953),
    [anon_sym_LT_LT_DASH] = ACTIONS(951),
    [anon_sym_LT_LT_LT] = ACTIONS(951),
    [sym__special_characters] = ACTIONS(951),
    [anon_sym_DQUOTE] = ACTIONS(951),
    [anon_sym_DOLLAR] = ACTIONS(953),
    [sym_raw_string] = ACTIONS(951),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(951),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(951),
    [anon_sym_BQUOTE] = ACTIONS(951),
    [anon_sym_LT_LPAREN] = ACTIONS(951),
    [anon_sym_GT_LPAREN] = ACTIONS(951),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(953),
    [anon_sym_SEMI] = ACTIONS(953),
    [anon_sym_LF] = ACTIONS(951),
    [anon_sym_AMP] = ACTIONS(953),
  },
  [253] = {
    [sym_file_redirect] = STATE(643),
    [sym_heredoc_redirect] = STATE(643),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(643),
    [aux_sym_while_statement_repeat1] = STATE(643),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(455),
    [anon_sym_AMP_GT] = ACTIONS(453),
    [anon_sym_AMP_GT_GT] = ACTIONS(455),
    [anon_sym_LT_AMP] = ACTIONS(455),
    [anon_sym_GT_AMP] = ACTIONS(455),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(457),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [254] = {
    [sym_file_redirect] = STATE(644),
    [sym_heredoc_redirect] = STATE(644),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(644),
    [sym_concatenation] = STATE(645),
    [sym_string] = STATE(252),
    [sym_simple_expansion] = STATE(252),
    [sym_string_expansion] = STATE(252),
    [sym_expansion] = STATE(252),
    [sym_command_substitution] = STATE(252),
    [sym_process_substitution] = STATE(252),
    [aux_sym_while_statement_repeat1] = STATE(644),
    [aux_sym_command_repeat2] = STATE(645),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_EQ_TILDE] = ACTIONS(451),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(455),
    [anon_sym_AMP_GT] = ACTIONS(453),
    [anon_sym_AMP_GT_GT] = ACTIONS(455),
    [anon_sym_LT_AMP] = ACTIONS(455),
    [anon_sym_GT_AMP] = ACTIONS(455),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(457),
    [sym__special_characters] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(461),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [255] = {
    [sym_file_redirect] = STATE(644),
    [sym_heredoc_redirect] = STATE(644),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(644),
    [sym_concatenation] = STATE(646),
    [sym_string] = STATE(252),
    [sym_simple_expansion] = STATE(252),
    [sym_string_expansion] = STATE(252),
    [sym_expansion] = STATE(252),
    [sym_command_substitution] = STATE(252),
    [sym_process_substitution] = STATE(252),
    [aux_sym_while_statement_repeat1] = STATE(644),
    [aux_sym_command_repeat2] = STATE(646),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_EQ_TILDE] = ACTIONS(451),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(455),
    [anon_sym_AMP_GT] = ACTIONS(453),
    [anon_sym_AMP_GT_GT] = ACTIONS(455),
    [anon_sym_LT_AMP] = ACTIONS(455),
    [anon_sym_GT_AMP] = ACTIONS(455),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(457),
    [sym__special_characters] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(461),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [256] = {
    [sym__terminated_statement] = STATE(652),
    [sym_for_statement] = STATE(536),
    [sym_c_style_for_statement] = STATE(536),
    [sym_while_statement] = STATE(536),
    [sym_if_statement] = STATE(536),
    [sym_elif_clause] = STATE(650),
    [sym_else_clause] = STATE(651),
    [sym_case_statement] = STATE(536),
    [sym_function_definition] = STATE(536),
    [sym_subshell] = STATE(536),
    [sym_pipeline] = STATE(536),
    [sym_list] = STATE(536),
    [sym_negated_command] = STATE(536),
    [sym_test_command] = STATE(536),
    [sym_declaration_command] = STATE(536),
    [sym_unset_command] = STATE(536),
    [sym_command] = STATE(536),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(537),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(652),
    [aux_sym_if_statement_repeat1] = STATE(653),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_fi] = ACTIONS(1209),
    [anon_sym_elif] = ACTIONS(1211),
    [anon_sym_else] = ACTIONS(1213),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [257] = {
    [sym_string] = STATE(654),
    [sym_simple_expansion] = STATE(654),
    [sym_string_expansion] = STATE(654),
    [sym_expansion] = STATE(654),
    [sym_command_substitution] = STATE(654),
    [sym_process_substitution] = STATE(654),
    [sym__special_characters] = ACTIONS(1215),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym_raw_string] = ACTIONS(1215),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(99),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_BQUOTE] = ACTIONS(103),
    [anon_sym_LT_LPAREN] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(105),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1215),
  },
  [258] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(1217),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1219),
    [anon_sym_LF] = ACTIONS(1217),
    [anon_sym_AMP] = ACTIONS(1217),
  },
  [259] = {
    [anon_sym_in] = ACTIONS(1221),
    [sym_comment] = ACTIONS(53),
  },
  [260] = {
    [aux_sym_concatenation_repeat1] = STATE(657),
    [sym__concat] = ACTIONS(469),
    [anon_sym_in] = ACTIONS(761),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(761),
  },
  [261] = {
    [sym__concat] = ACTIONS(765),
    [anon_sym_in] = ACTIONS(765),
    [anon_sym_SEMI_SEMI] = ACTIONS(765),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(767),
    [anon_sym_LF] = ACTIONS(765),
    [anon_sym_AMP] = ACTIONS(765),
  },
  [262] = {
    [anon_sym_DQUOTE] = ACTIONS(1223),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [263] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(1223),
    [anon_sym_DOLLAR] = ACTIONS(1225),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [264] = {
    [sym__concat] = ACTIONS(797),
    [anon_sym_in] = ACTIONS(797),
    [anon_sym_SEMI_SEMI] = ACTIONS(797),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(799),
    [anon_sym_LF] = ACTIONS(797),
    [anon_sym_AMP] = ACTIONS(797),
  },
  [265] = {
    [sym__concat] = ACTIONS(801),
    [anon_sym_in] = ACTIONS(801),
    [anon_sym_SEMI_SEMI] = ACTIONS(801),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(803),
    [anon_sym_LF] = ACTIONS(801),
    [anon_sym_AMP] = ACTIONS(801),
  },
  [266] = {
    [sym__concat] = ACTIONS(805),
    [anon_sym_in] = ACTIONS(805),
    [anon_sym_SEMI_SEMI] = ACTIONS(805),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(807),
    [anon_sym_LF] = ACTIONS(805),
    [anon_sym_AMP] = ACTIONS(805),
  },
  [267] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(1227),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1229),
    [anon_sym_LF] = ACTIONS(1227),
    [anon_sym_AMP] = ACTIONS(1227),
  },
  [268] = {
    [anon_sym_in] = ACTIONS(1231),
    [sym_comment] = ACTIONS(53),
  },
  [269] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(1233),
    [sym_comment] = ACTIONS(53),
  },
  [270] = {
    [sym_subscript] = STATE(666),
    [sym_variable_name] = ACTIONS(1235),
    [anon_sym_DOLLAR] = ACTIONS(1237),
    [anon_sym_DASH] = ACTIONS(1237),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1239),
    [anon_sym_STAR] = ACTIONS(1237),
    [anon_sym_AT] = ACTIONS(1237),
    [anon_sym_QMARK] = ACTIONS(1237),
    [anon_sym_0] = ACTIONS(1241),
    [anon_sym__] = ACTIONS(1241),
  },
  [271] = {
    [sym_concatenation] = STATE(669),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(669),
    [anon_sym_RBRACE] = ACTIONS(1243),
    [anon_sym_EQ] = ACTIONS(1245),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1247),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1249),
    [anon_sym_COLON] = ACTIONS(1245),
    [anon_sym_COLON_QMARK] = ACTIONS(1245),
    [anon_sym_COLON_DASH] = ACTIONS(1245),
    [anon_sym_PERCENT] = ACTIONS(1245),
    [anon_sym_DASH] = ACTIONS(1245),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [272] = {
    [sym_concatenation] = STATE(672),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(672),
    [anon_sym_RBRACE] = ACTIONS(1251),
    [anon_sym_EQ] = ACTIONS(1253),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1255),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1257),
    [anon_sym_COLON] = ACTIONS(1253),
    [anon_sym_COLON_QMARK] = ACTIONS(1253),
    [anon_sym_COLON_DASH] = ACTIONS(1253),
    [anon_sym_PERCENT] = ACTIONS(1253),
    [anon_sym_DASH] = ACTIONS(1253),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [273] = {
    [sym_concatenation] = STATE(675),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(675),
    [anon_sym_RBRACE] = ACTIONS(1259),
    [anon_sym_EQ] = ACTIONS(1261),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1263),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1265),
    [anon_sym_COLON] = ACTIONS(1261),
    [anon_sym_COLON_QMARK] = ACTIONS(1261),
    [anon_sym_COLON_DASH] = ACTIONS(1261),
    [anon_sym_PERCENT] = ACTIONS(1261),
    [anon_sym_DASH] = ACTIONS(1261),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [274] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1267),
    [anon_sym_SEMI_SEMI] = ACTIONS(1269),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1271),
    [anon_sym_LF] = ACTIONS(1269),
    [anon_sym_AMP] = ACTIONS(1271),
  },
  [275] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1267),
    [anon_sym_SEMI_SEMI] = ACTIONS(1269),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1271),
    [anon_sym_LF] = ACTIONS(1269),
    [anon_sym_AMP] = ACTIONS(1271),
  },
  [276] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(678),
    [sym_c_style_for_statement] = STATE(678),
    [sym_while_statement] = STATE(678),
    [sym_if_statement] = STATE(678),
    [sym_case_statement] = STATE(678),
    [sym_function_definition] = STATE(678),
    [sym_subshell] = STATE(678),
    [sym_pipeline] = STATE(678),
    [sym_list] = STATE(678),
    [sym_negated_command] = STATE(678),
    [sym_test_command] = STATE(678),
    [sym_declaration_command] = STATE(678),
    [sym_unset_command] = STATE(678),
    [sym_command] = STATE(678),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(679),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [277] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1273),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(1267),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1275),
    [anon_sym_LF] = ACTIONS(1273),
    [anon_sym_AMP] = ACTIONS(1275),
  },
  [278] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1273),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(1267),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1275),
    [anon_sym_LF] = ACTIONS(1273),
    [anon_sym_AMP] = ACTIONS(1275),
  },
  [279] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(681),
    [sym_c_style_for_statement] = STATE(681),
    [sym_while_statement] = STATE(681),
    [sym_if_statement] = STATE(681),
    [sym_case_statement] = STATE(681),
    [sym_function_definition] = STATE(681),
    [sym_subshell] = STATE(681),
    [sym_pipeline] = STATE(681),
    [sym_list] = STATE(681),
    [sym_negated_command] = STATE(681),
    [sym_test_command] = STATE(681),
    [sym_declaration_command] = STATE(681),
    [sym_unset_command] = STATE(681),
    [sym_command] = STATE(681),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(682),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [280] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1277),
    [anon_sym_SEMI_SEMI] = ACTIONS(1279),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1281),
    [anon_sym_LF] = ACTIONS(1279),
    [anon_sym_AMP] = ACTIONS(1281),
  },
  [281] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1277),
    [anon_sym_SEMI_SEMI] = ACTIONS(1279),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1281),
    [anon_sym_LF] = ACTIONS(1279),
    [anon_sym_AMP] = ACTIONS(1281),
  },
  [282] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(685),
    [sym_c_style_for_statement] = STATE(685),
    [sym_while_statement] = STATE(685),
    [sym_if_statement] = STATE(685),
    [sym_case_statement] = STATE(685),
    [sym_function_definition] = STATE(685),
    [sym_subshell] = STATE(685),
    [sym_pipeline] = STATE(685),
    [sym_list] = STATE(685),
    [sym_negated_command] = STATE(685),
    [sym_test_command] = STATE(685),
    [sym_declaration_command] = STATE(685),
    [sym_unset_command] = STATE(685),
    [sym_command] = STATE(685),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(686),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [283] = {
    [anon_sym_RPAREN] = ACTIONS(1283),
    [sym_comment] = ACTIONS(53),
  },
  [284] = {
    [sym__terminated_statement] = STATE(691),
    [sym_for_statement] = STATE(689),
    [sym_c_style_for_statement] = STATE(689),
    [sym_while_statement] = STATE(689),
    [sym_if_statement] = STATE(689),
    [sym_case_statement] = STATE(689),
    [sym_function_definition] = STATE(689),
    [sym_subshell] = STATE(689),
    [sym_pipeline] = STATE(689),
    [sym_list] = STATE(689),
    [sym_negated_command] = STATE(689),
    [sym_test_command] = STATE(689),
    [sym_declaration_command] = STATE(689),
    [sym_unset_command] = STATE(689),
    [sym_command] = STATE(689),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(690),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(691),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(1285),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [285] = {
    [sym_file_redirect] = STATE(694),
    [sym_file_descriptor] = ACTIONS(1287),
    [ts_builtin_sym_end] = ACTIONS(1289),
    [anon_sym_PIPE] = ACTIONS(1291),
    [anon_sym_SEMI_SEMI] = ACTIONS(1289),
    [anon_sym_PIPE_AMP] = ACTIONS(1289),
    [anon_sym_AMP_AMP] = ACTIONS(1289),
    [anon_sym_PIPE_PIPE] = ACTIONS(1289),
    [anon_sym_LT] = ACTIONS(1293),
    [anon_sym_GT] = ACTIONS(1293),
    [anon_sym_GT_GT] = ACTIONS(1295),
    [anon_sym_AMP_GT] = ACTIONS(1293),
    [anon_sym_AMP_GT_GT] = ACTIONS(1295),
    [anon_sym_LT_AMP] = ACTIONS(1295),
    [anon_sym_GT_AMP] = ACTIONS(1295),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1291),
    [anon_sym_LF] = ACTIONS(1289),
    [anon_sym_AMP] = ACTIONS(1291),
  },
  [286] = {
    [sym_concatenation] = STATE(203),
    [sym_string] = STATE(696),
    [sym_array] = STATE(203),
    [sym_simple_expansion] = STATE(696),
    [sym_string_expansion] = STATE(696),
    [sym_expansion] = STATE(696),
    [sym_command_substitution] = STATE(696),
    [sym_process_substitution] = STATE(696),
    [sym__empty_value] = ACTIONS(363),
    [anon_sym_LPAREN] = ACTIONS(365),
    [sym__special_characters] = ACTIONS(1297),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(1299),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(375),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(377),
    [anon_sym_BQUOTE] = ACTIONS(379),
    [anon_sym_LT_LPAREN] = ACTIONS(381),
    [anon_sym_GT_LPAREN] = ACTIONS(381),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1299),
  },
  [287] = {
    [sym_do_group] = STATE(697),
    [anon_sym_do] = ACTIONS(437),
    [sym_comment] = ACTIONS(53),
  },
  [288] = {
    [sym_compound_statement] = STATE(699),
    [anon_sym_LPAREN] = ACTIONS(1301),
    [anon_sym_LBRACE] = ACTIONS(507),
    [sym_comment] = ACTIONS(53),
  },
  [289] = {
    [anon_sym_AMP_AMP] = ACTIONS(607),
    [anon_sym_PIPE_PIPE] = ACTIONS(607),
    [anon_sym_RBRACK] = ACTIONS(1303),
    [anon_sym_EQ_TILDE] = ACTIONS(611),
    [anon_sym_EQ_EQ] = ACTIONS(611),
    [anon_sym_EQ] = ACTIONS(613),
    [anon_sym_LT] = ACTIONS(607),
    [anon_sym_GT] = ACTIONS(607),
    [anon_sym_BANG_EQ] = ACTIONS(607),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(607),
  },
  [290] = {
    [anon_sym_AMP_AMP] = ACTIONS(639),
    [anon_sym_PIPE_PIPE] = ACTIONS(639),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1303),
    [anon_sym_EQ_TILDE] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(641),
    [anon_sym_EQ] = ACTIONS(643),
    [anon_sym_LT] = ACTIONS(639),
    [anon_sym_GT] = ACTIONS(639),
    [anon_sym_BANG_EQ] = ACTIONS(639),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(639),
  },
  [291] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(1305),
    [anon_sym_PLUS_EQ] = ACTIONS(1305),
    [sym_comment] = ACTIONS(53),
  },
  [292] = {
    [aux_sym_concatenation_repeat1] = STATE(702),
    [sym__concat] = ACTIONS(647),
    [sym_variable_name] = ACTIONS(649),
    [anon_sym_PIPE] = ACTIONS(651),
    [anon_sym_RPAREN] = ACTIONS(649),
    [anon_sym_SEMI_SEMI] = ACTIONS(649),
    [anon_sym_PIPE_AMP] = ACTIONS(649),
    [anon_sym_AMP_AMP] = ACTIONS(649),
    [anon_sym_PIPE_PIPE] = ACTIONS(649),
    [sym__special_characters] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(649),
    [anon_sym_DOLLAR] = ACTIONS(651),
    [sym_raw_string] = ACTIONS(649),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(649),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(649),
    [anon_sym_BQUOTE] = ACTIONS(649),
    [anon_sym_LT_LPAREN] = ACTIONS(649),
    [anon_sym_GT_LPAREN] = ACTIONS(649),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(651),
    [sym_word] = ACTIONS(651),
    [anon_sym_SEMI] = ACTIONS(651),
    [anon_sym_LF] = ACTIONS(649),
    [anon_sym_AMP] = ACTIONS(651),
  },
  [293] = {
    [aux_sym_concatenation_repeat1] = STATE(702),
    [sym__concat] = ACTIONS(647),
    [sym_variable_name] = ACTIONS(665),
    [anon_sym_PIPE] = ACTIONS(667),
    [anon_sym_RPAREN] = ACTIONS(665),
    [anon_sym_SEMI_SEMI] = ACTIONS(665),
    [anon_sym_PIPE_AMP] = ACTIONS(665),
    [anon_sym_AMP_AMP] = ACTIONS(665),
    [anon_sym_PIPE_PIPE] = ACTIONS(665),
    [sym__special_characters] = ACTIONS(665),
    [anon_sym_DQUOTE] = ACTIONS(665),
    [anon_sym_DOLLAR] = ACTIONS(667),
    [sym_raw_string] = ACTIONS(665),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(665),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(665),
    [anon_sym_BQUOTE] = ACTIONS(665),
    [anon_sym_LT_LPAREN] = ACTIONS(665),
    [anon_sym_GT_LPAREN] = ACTIONS(665),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(667),
    [sym_word] = ACTIONS(667),
    [anon_sym_SEMI] = ACTIONS(667),
    [anon_sym_LF] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
  },
  [294] = {
    [anon_sym_EQ] = ACTIONS(1305),
    [anon_sym_PLUS_EQ] = ACTIONS(1305),
    [sym_comment] = ACTIONS(53),
  },
  [295] = {
    [sym_variable_assignment] = STATE(703),
    [sym_subscript] = STATE(294),
    [sym_concatenation] = STATE(703),
    [sym_string] = STATE(293),
    [sym_simple_expansion] = STATE(293),
    [sym_string_expansion] = STATE(293),
    [sym_expansion] = STATE(293),
    [sym_command_substitution] = STATE(293),
    [sym_process_substitution] = STATE(293),
    [aux_sym_declaration_command_repeat1] = STATE(703),
    [sym_variable_name] = ACTIONS(513),
    [anon_sym_PIPE] = ACTIONS(685),
    [anon_sym_RPAREN] = ACTIONS(683),
    [anon_sym_SEMI_SEMI] = ACTIONS(683),
    [anon_sym_PIPE_AMP] = ACTIONS(683),
    [anon_sym_AMP_AMP] = ACTIONS(683),
    [anon_sym_PIPE_PIPE] = ACTIONS(683),
    [sym__special_characters] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(517),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(203),
    [sym_word] = ACTIONS(519),
    [anon_sym_SEMI] = ACTIONS(685),
    [anon_sym_LF] = ACTIONS(683),
    [anon_sym_AMP] = ACTIONS(685),
  },
  [296] = {
    [aux_sym_concatenation_repeat1] = STATE(704),
    [sym__concat] = ACTIONS(687),
    [anon_sym_PIPE] = ACTIONS(691),
    [anon_sym_RPAREN] = ACTIONS(689),
    [anon_sym_SEMI_SEMI] = ACTIONS(689),
    [anon_sym_PIPE_AMP] = ACTIONS(689),
    [anon_sym_AMP_AMP] = ACTIONS(689),
    [anon_sym_PIPE_PIPE] = ACTIONS(689),
    [sym__special_characters] = ACTIONS(689),
    [anon_sym_DQUOTE] = ACTIONS(689),
    [anon_sym_DOLLAR] = ACTIONS(691),
    [sym_raw_string] = ACTIONS(689),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(689),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(689),
    [anon_sym_BQUOTE] = ACTIONS(689),
    [anon_sym_LT_LPAREN] = ACTIONS(689),
    [anon_sym_GT_LPAREN] = ACTIONS(689),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(691),
    [sym_word] = ACTIONS(691),
    [anon_sym_SEMI] = ACTIONS(691),
    [anon_sym_LF] = ACTIONS(689),
    [anon_sym_AMP] = ACTIONS(691),
  },
  [297] = {
    [aux_sym_concatenation_repeat1] = STATE(704),
    [sym__concat] = ACTIONS(687),
    [anon_sym_PIPE] = ACTIONS(707),
    [anon_sym_RPAREN] = ACTIONS(705),
    [anon_sym_SEMI_SEMI] = ACTIONS(705),
    [anon_sym_PIPE_AMP] = ACTIONS(705),
    [anon_sym_AMP_AMP] = ACTIONS(705),
    [anon_sym_PIPE_PIPE] = ACTIONS(705),
    [sym__special_characters] = ACTIONS(705),
    [anon_sym_DQUOTE] = ACTIONS(705),
    [anon_sym_DOLLAR] = ACTIONS(707),
    [sym_raw_string] = ACTIONS(705),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(705),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(705),
    [anon_sym_BQUOTE] = ACTIONS(705),
    [anon_sym_LT_LPAREN] = ACTIONS(705),
    [anon_sym_GT_LPAREN] = ACTIONS(705),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(707),
    [sym_word] = ACTIONS(707),
    [anon_sym_SEMI] = ACTIONS(707),
    [anon_sym_LF] = ACTIONS(705),
    [anon_sym_AMP] = ACTIONS(707),
  },
  [298] = {
    [sym_concatenation] = STATE(705),
    [sym_string] = STATE(297),
    [sym_simple_expansion] = STATE(297),
    [sym_string_expansion] = STATE(297),
    [sym_expansion] = STATE(297),
    [sym_command_substitution] = STATE(297),
    [sym_process_substitution] = STATE(297),
    [aux_sym_unset_command_repeat1] = STATE(705),
    [anon_sym_PIPE] = ACTIONS(725),
    [anon_sym_RPAREN] = ACTIONS(723),
    [anon_sym_SEMI_SEMI] = ACTIONS(723),
    [anon_sym_PIPE_AMP] = ACTIONS(723),
    [anon_sym_AMP_AMP] = ACTIONS(723),
    [anon_sym_PIPE_PIPE] = ACTIONS(723),
    [sym__special_characters] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(523),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(227),
    [sym_word] = ACTIONS(525),
    [anon_sym_SEMI] = ACTIONS(725),
    [anon_sym_LF] = ACTIONS(723),
    [anon_sym_AMP] = ACTIONS(725),
  },
  [299] = {
    [aux_sym_concatenation_repeat1] = STATE(706),
    [sym__simple_heredoc_body] = ACTIONS(761),
    [sym__heredoc_body_beginning] = ACTIONS(761),
    [sym_file_descriptor] = ACTIONS(761),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(763),
    [anon_sym_RPAREN] = ACTIONS(761),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [anon_sym_PIPE_AMP] = ACTIONS(761),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [anon_sym_EQ_TILDE] = ACTIONS(763),
    [anon_sym_EQ_EQ] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(763),
    [anon_sym_GT] = ACTIONS(763),
    [anon_sym_GT_GT] = ACTIONS(761),
    [anon_sym_AMP_GT] = ACTIONS(763),
    [anon_sym_AMP_GT_GT] = ACTIONS(761),
    [anon_sym_LT_AMP] = ACTIONS(761),
    [anon_sym_GT_AMP] = ACTIONS(761),
    [anon_sym_LT_LT] = ACTIONS(763),
    [anon_sym_LT_LT_DASH] = ACTIONS(761),
    [anon_sym_LT_LT_LT] = ACTIONS(761),
    [sym__special_characters] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(763),
    [sym_raw_string] = ACTIONS(761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(761),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(761),
    [anon_sym_LT_LPAREN] = ACTIONS(761),
    [anon_sym_GT_LPAREN] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(763),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
  },
  [300] = {
    [anon_sym_RPAREN] = ACTIONS(1307),
    [sym_comment] = ACTIONS(53),
  },
  [301] = {
    [sym_for_statement] = STATE(512),
    [sym_c_style_for_statement] = STATE(512),
    [sym_while_statement] = STATE(512),
    [sym_if_statement] = STATE(512),
    [sym_case_statement] = STATE(512),
    [sym_function_definition] = STATE(512),
    [sym_subshell] = STATE(512),
    [sym_pipeline] = STATE(512),
    [sym_list] = STATE(512),
    [sym_negated_command] = STATE(512),
    [sym_test_command] = STATE(512),
    [sym_declaration_command] = STATE(512),
    [sym_unset_command] = STATE(512),
    [sym_command] = STATE(512),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(513),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [302] = {
    [ts_builtin_sym_end] = ACTIONS(1309),
    [anon_sym_esac] = ACTIONS(1309),
    [anon_sym_PIPE] = ACTIONS(1311),
    [anon_sym_RPAREN] = ACTIONS(1309),
    [anon_sym_SEMI_SEMI] = ACTIONS(1309),
    [anon_sym_PIPE_AMP] = ACTIONS(1309),
    [anon_sym_AMP_AMP] = ACTIONS(1309),
    [anon_sym_PIPE_PIPE] = ACTIONS(1309),
    [anon_sym_BQUOTE] = ACTIONS(1309),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1311),
    [anon_sym_LF] = ACTIONS(1309),
    [anon_sym_AMP] = ACTIONS(1311),
  },
  [303] = {
    [sym_file_descriptor] = ACTIONS(899),
    [sym_variable_name] = ACTIONS(899),
    [anon_sym_for] = ACTIONS(903),
    [anon_sym_while] = ACTIONS(903),
    [anon_sym_if] = ACTIONS(903),
    [anon_sym_case] = ACTIONS(903),
    [anon_sym_RPAREN] = ACTIONS(1313),
    [anon_sym_function] = ACTIONS(903),
    [anon_sym_LPAREN] = ACTIONS(899),
    [anon_sym_BANG] = ACTIONS(903),
    [anon_sym_LBRACK] = ACTIONS(903),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(899),
    [anon_sym_declare] = ACTIONS(903),
    [anon_sym_typeset] = ACTIONS(903),
    [anon_sym_export] = ACTIONS(903),
    [anon_sym_readonly] = ACTIONS(903),
    [anon_sym_local] = ACTIONS(903),
    [anon_sym_unset] = ACTIONS(903),
    [anon_sym_unsetenv] = ACTIONS(903),
    [anon_sym_LT] = ACTIONS(903),
    [anon_sym_GT] = ACTIONS(903),
    [anon_sym_GT_GT] = ACTIONS(899),
    [anon_sym_AMP_GT] = ACTIONS(903),
    [anon_sym_AMP_GT_GT] = ACTIONS(899),
    [anon_sym_LT_AMP] = ACTIONS(899),
    [anon_sym_GT_AMP] = ACTIONS(899),
    [sym__special_characters] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(903),
    [sym_raw_string] = ACTIONS(899),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(899),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(899),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_LT_LPAREN] = ACTIONS(899),
    [anon_sym_GT_LPAREN] = ACTIONS(899),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(903),
  },
  [304] = {
    [sym_for_statement] = STATE(709),
    [sym_c_style_for_statement] = STATE(709),
    [sym_while_statement] = STATE(709),
    [sym_if_statement] = STATE(709),
    [sym_case_statement] = STATE(709),
    [sym_function_definition] = STATE(709),
    [sym_subshell] = STATE(709),
    [sym_pipeline] = STATE(709),
    [sym_list] = STATE(709),
    [sym_negated_command] = STATE(709),
    [sym_test_command] = STATE(709),
    [sym_declaration_command] = STATE(709),
    [sym_unset_command] = STATE(709),
    [sym_command] = STATE(709),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(710),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [305] = {
    [anon_sym_LT] = ACTIONS(1315),
    [anon_sym_GT] = ACTIONS(1315),
    [anon_sym_GT_GT] = ACTIONS(1317),
    [anon_sym_AMP_GT] = ACTIONS(1315),
    [anon_sym_AMP_GT_GT] = ACTIONS(1317),
    [anon_sym_LT_AMP] = ACTIONS(1317),
    [anon_sym_GT_AMP] = ACTIONS(1317),
    [sym_comment] = ACTIONS(53),
  },
  [306] = {
    [sym_concatenation] = STATE(523),
    [sym_string] = STATE(713),
    [sym_simple_expansion] = STATE(713),
    [sym_string_expansion] = STATE(713),
    [sym_expansion] = STATE(713),
    [sym_command_substitution] = STATE(713),
    [sym_process_substitution] = STATE(713),
    [sym__special_characters] = ACTIONS(1319),
    [anon_sym_DQUOTE] = ACTIONS(923),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(927),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(929),
    [anon_sym_BQUOTE] = ACTIONS(931),
    [anon_sym_LT_LPAREN] = ACTIONS(933),
    [anon_sym_GT_LPAREN] = ACTIONS(933),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(1321),
    [sym_regex] = ACTIONS(935),
  },
  [307] = {
    [sym_concatenation] = STATE(526),
    [sym_string] = STATE(715),
    [sym_simple_expansion] = STATE(715),
    [sym_string_expansion] = STATE(715),
    [sym_expansion] = STATE(715),
    [sym_command_substitution] = STATE(715),
    [sym_process_substitution] = STATE(715),
    [sym__special_characters] = ACTIONS(1323),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1325),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1325),
  },
  [308] = {
    [sym_concatenation] = STATE(530),
    [sym_string] = STATE(717),
    [sym_simple_expansion] = STATE(717),
    [sym_string_expansion] = STATE(717),
    [sym_expansion] = STATE(717),
    [sym_command_substitution] = STATE(717),
    [sym_process_substitution] = STATE(717),
    [sym__special_characters] = ACTIONS(1327),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1329),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1329),
  },
  [309] = {
    [aux_sym_concatenation_repeat1] = STATE(299),
    [sym__simple_heredoc_body] = ACTIONS(947),
    [sym__heredoc_body_beginning] = ACTIONS(947),
    [sym_file_descriptor] = ACTIONS(947),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(949),
    [anon_sym_RPAREN] = ACTIONS(947),
    [anon_sym_SEMI_SEMI] = ACTIONS(947),
    [anon_sym_PIPE_AMP] = ACTIONS(947),
    [anon_sym_AMP_AMP] = ACTIONS(947),
    [anon_sym_PIPE_PIPE] = ACTIONS(947),
    [anon_sym_EQ_TILDE] = ACTIONS(949),
    [anon_sym_EQ_EQ] = ACTIONS(949),
    [anon_sym_LT] = ACTIONS(949),
    [anon_sym_GT] = ACTIONS(949),
    [anon_sym_GT_GT] = ACTIONS(947),
    [anon_sym_AMP_GT] = ACTIONS(949),
    [anon_sym_AMP_GT_GT] = ACTIONS(947),
    [anon_sym_LT_AMP] = ACTIONS(947),
    [anon_sym_GT_AMP] = ACTIONS(947),
    [anon_sym_LT_LT] = ACTIONS(949),
    [anon_sym_LT_LT_DASH] = ACTIONS(947),
    [anon_sym_LT_LT_LT] = ACTIONS(947),
    [sym__special_characters] = ACTIONS(947),
    [anon_sym_DQUOTE] = ACTIONS(947),
    [anon_sym_DOLLAR] = ACTIONS(949),
    [sym_raw_string] = ACTIONS(947),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(947),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(947),
    [anon_sym_BQUOTE] = ACTIONS(947),
    [anon_sym_LT_LPAREN] = ACTIONS(947),
    [anon_sym_GT_LPAREN] = ACTIONS(947),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(949),
    [anon_sym_SEMI] = ACTIONS(949),
    [anon_sym_LF] = ACTIONS(947),
    [anon_sym_AMP] = ACTIONS(949),
  },
  [310] = {
    [aux_sym_concatenation_repeat1] = STATE(299),
    [sym__simple_heredoc_body] = ACTIONS(951),
    [sym__heredoc_body_beginning] = ACTIONS(951),
    [sym_file_descriptor] = ACTIONS(951),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(953),
    [anon_sym_RPAREN] = ACTIONS(951),
    [anon_sym_SEMI_SEMI] = ACTIONS(951),
    [anon_sym_PIPE_AMP] = ACTIONS(951),
    [anon_sym_AMP_AMP] = ACTIONS(951),
    [anon_sym_PIPE_PIPE] = ACTIONS(951),
    [anon_sym_EQ_TILDE] = ACTIONS(953),
    [anon_sym_EQ_EQ] = ACTIONS(953),
    [anon_sym_LT] = ACTIONS(953),
    [anon_sym_GT] = ACTIONS(953),
    [anon_sym_GT_GT] = ACTIONS(951),
    [anon_sym_AMP_GT] = ACTIONS(953),
    [anon_sym_AMP_GT_GT] = ACTIONS(951),
    [anon_sym_LT_AMP] = ACTIONS(951),
    [anon_sym_GT_AMP] = ACTIONS(951),
    [anon_sym_LT_LT] = ACTIONS(953),
    [anon_sym_LT_LT_DASH] = ACTIONS(951),
    [anon_sym_LT_LT_LT] = ACTIONS(951),
    [sym__special_characters] = ACTIONS(951),
    [anon_sym_DQUOTE] = ACTIONS(951),
    [anon_sym_DOLLAR] = ACTIONS(953),
    [sym_raw_string] = ACTIONS(951),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(951),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(951),
    [anon_sym_BQUOTE] = ACTIONS(951),
    [anon_sym_LT_LPAREN] = ACTIONS(951),
    [anon_sym_GT_LPAREN] = ACTIONS(951),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(953),
    [anon_sym_SEMI] = ACTIONS(953),
    [anon_sym_LF] = ACTIONS(951),
    [anon_sym_AMP] = ACTIONS(953),
  },
  [311] = {
    [sym_file_redirect] = STATE(718),
    [sym_heredoc_redirect] = STATE(718),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(718),
    [aux_sym_while_statement_repeat1] = STATE(718),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(541),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_RPAREN] = ACTIONS(955),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_LT] = ACTIONS(545),
    [anon_sym_GT] = ACTIONS(545),
    [anon_sym_GT_GT] = ACTIONS(547),
    [anon_sym_AMP_GT] = ACTIONS(545),
    [anon_sym_AMP_GT_GT] = ACTIONS(547),
    [anon_sym_LT_AMP] = ACTIONS(547),
    [anon_sym_GT_AMP] = ACTIONS(547),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(549),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [312] = {
    [sym_file_redirect] = STATE(719),
    [sym_heredoc_redirect] = STATE(719),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(719),
    [sym_concatenation] = STATE(720),
    [sym_string] = STATE(310),
    [sym_simple_expansion] = STATE(310),
    [sym_string_expansion] = STATE(310),
    [sym_expansion] = STATE(310),
    [sym_command_substitution] = STATE(310),
    [sym_process_substitution] = STATE(310),
    [aux_sym_while_statement_repeat1] = STATE(719),
    [aux_sym_command_repeat2] = STATE(720),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(541),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_RPAREN] = ACTIONS(955),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_EQ_TILDE] = ACTIONS(543),
    [anon_sym_EQ_EQ] = ACTIONS(543),
    [anon_sym_LT] = ACTIONS(545),
    [anon_sym_GT] = ACTIONS(545),
    [anon_sym_GT_GT] = ACTIONS(547),
    [anon_sym_AMP_GT] = ACTIONS(545),
    [anon_sym_AMP_GT_GT] = ACTIONS(547),
    [anon_sym_LT_AMP] = ACTIONS(547),
    [anon_sym_GT_AMP] = ACTIONS(547),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(549),
    [sym__special_characters] = ACTIONS(551),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(553),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(555),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [313] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1313),
    [anon_sym_SEMI_SEMI] = ACTIONS(1331),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1333),
    [anon_sym_LF] = ACTIONS(1331),
    [anon_sym_AMP] = ACTIONS(1333),
  },
  [314] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1313),
    [anon_sym_SEMI_SEMI] = ACTIONS(1331),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1333),
    [anon_sym_LF] = ACTIONS(1331),
    [anon_sym_AMP] = ACTIONS(1333),
  },
  [315] = {
    [sym_file_redirect] = STATE(719),
    [sym_heredoc_redirect] = STATE(719),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(719),
    [sym_concatenation] = STATE(722),
    [sym_string] = STATE(310),
    [sym_simple_expansion] = STATE(310),
    [sym_string_expansion] = STATE(310),
    [sym_expansion] = STATE(310),
    [sym_command_substitution] = STATE(310),
    [sym_process_substitution] = STATE(310),
    [aux_sym_while_statement_repeat1] = STATE(719),
    [aux_sym_command_repeat2] = STATE(722),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(541),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_RPAREN] = ACTIONS(955),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_EQ_TILDE] = ACTIONS(543),
    [anon_sym_EQ_EQ] = ACTIONS(543),
    [anon_sym_LT] = ACTIONS(545),
    [anon_sym_GT] = ACTIONS(545),
    [anon_sym_GT_GT] = ACTIONS(547),
    [anon_sym_AMP_GT] = ACTIONS(545),
    [anon_sym_AMP_GT_GT] = ACTIONS(547),
    [anon_sym_LT_AMP] = ACTIONS(547),
    [anon_sym_GT_AMP] = ACTIONS(547),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(549),
    [sym__special_characters] = ACTIONS(551),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(553),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(555),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [316] = {
    [sym_concatenation] = STATE(723),
    [sym_string] = STATE(726),
    [sym_array] = STATE(723),
    [sym_simple_expansion] = STATE(726),
    [sym_string_expansion] = STATE(726),
    [sym_expansion] = STATE(726),
    [sym_command_substitution] = STATE(726),
    [sym_process_substitution] = STATE(726),
    [sym__empty_value] = ACTIONS(1335),
    [anon_sym_LPAREN] = ACTIONS(1337),
    [sym__special_characters] = ACTIONS(1339),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [anon_sym_DOLLAR] = ACTIONS(235),
    [sym_raw_string] = ACTIONS(1341),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(239),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(241),
    [anon_sym_BQUOTE] = ACTIONS(243),
    [anon_sym_LT_LPAREN] = ACTIONS(245),
    [anon_sym_GT_LPAREN] = ACTIONS(245),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1341),
  },
  [317] = {
    [sym__expression] = STATE(727),
    [sym_binary_expression] = STATE(727),
    [sym_unary_expression] = STATE(727),
    [sym_parenthesized_expression] = STATE(727),
    [sym_concatenation] = STATE(727),
    [sym_string] = STATE(319),
    [sym_simple_expansion] = STATE(319),
    [sym_string_expansion] = STATE(319),
    [sym_expansion] = STATE(319),
    [sym_command_substitution] = STATE(319),
    [sym_process_substitution] = STATE(319),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(565),
    [sym__special_characters] = ACTIONS(567),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(569),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(571),
    [sym_test_operator] = ACTIONS(573),
  },
  [318] = {
    [aux_sym_concatenation_repeat1] = STATE(728),
    [sym__concat] = ACTIONS(615),
    [anon_sym_RPAREN] = ACTIONS(577),
    [anon_sym_AMP_AMP] = ACTIONS(577),
    [anon_sym_PIPE_PIPE] = ACTIONS(577),
    [anon_sym_EQ_TILDE] = ACTIONS(577),
    [anon_sym_EQ_EQ] = ACTIONS(577),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_BANG_EQ] = ACTIONS(577),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(577),
  },
  [319] = {
    [aux_sym_concatenation_repeat1] = STATE(728),
    [sym__concat] = ACTIONS(615),
    [anon_sym_RPAREN] = ACTIONS(593),
    [anon_sym_AMP_AMP] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_EQ_TILDE] = ACTIONS(593),
    [anon_sym_EQ_EQ] = ACTIONS(593),
    [anon_sym_EQ] = ACTIONS(595),
    [anon_sym_LT] = ACTIONS(593),
    [anon_sym_GT] = ACTIONS(593),
    [anon_sym_BANG_EQ] = ACTIONS(593),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(593),
  },
  [320] = {
    [anon_sym_RPAREN] = ACTIONS(1343),
    [anon_sym_AMP_AMP] = ACTIONS(1345),
    [anon_sym_PIPE_PIPE] = ACTIONS(1345),
    [anon_sym_EQ_TILDE] = ACTIONS(1347),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ] = ACTIONS(1349),
    [anon_sym_LT] = ACTIONS(1345),
    [anon_sym_GT] = ACTIONS(1345),
    [anon_sym_BANG_EQ] = ACTIONS(1345),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(1345),
  },
  [321] = {
    [anon_sym_AMP_AMP] = ACTIONS(607),
    [anon_sym_PIPE_PIPE] = ACTIONS(607),
    [anon_sym_RBRACK] = ACTIONS(1351),
    [anon_sym_EQ_TILDE] = ACTIONS(611),
    [anon_sym_EQ_EQ] = ACTIONS(611),
    [anon_sym_EQ] = ACTIONS(613),
    [anon_sym_LT] = ACTIONS(607),
    [anon_sym_GT] = ACTIONS(607),
    [anon_sym_BANG_EQ] = ACTIONS(607),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(607),
  },
  [322] = {
    [sym_string] = STATE(732),
    [sym_simple_expansion] = STATE(732),
    [sym_string_expansion] = STATE(732),
    [sym_expansion] = STATE(732),
    [sym_command_substitution] = STATE(732),
    [sym_process_substitution] = STATE(732),
    [sym__special_characters] = ACTIONS(1353),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(1353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1353),
  },
  [323] = {
    [aux_sym_concatenation_repeat1] = STATE(733),
    [sym__concat] = ACTIONS(575),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [anon_sym_RBRACK] = ACTIONS(761),
    [anon_sym_EQ_TILDE] = ACTIONS(761),
    [anon_sym_EQ_EQ] = ACTIONS(761),
    [anon_sym_EQ] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(761),
    [anon_sym_GT] = ACTIONS(761),
    [anon_sym_BANG_EQ] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(761),
  },
  [324] = {
    [sym__concat] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_RBRACK] = ACTIONS(765),
    [anon_sym_EQ_TILDE] = ACTIONS(765),
    [anon_sym_EQ_EQ] = ACTIONS(765),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_LT] = ACTIONS(765),
    [anon_sym_GT] = ACTIONS(765),
    [anon_sym_BANG_EQ] = ACTIONS(765),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(765),
  },
  [325] = {
    [anon_sym_DQUOTE] = ACTIONS(1355),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [326] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(1355),
    [anon_sym_DOLLAR] = ACTIONS(1357),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [327] = {
    [sym__concat] = ACTIONS(797),
    [anon_sym_AMP_AMP] = ACTIONS(797),
    [anon_sym_PIPE_PIPE] = ACTIONS(797),
    [anon_sym_RBRACK] = ACTIONS(797),
    [anon_sym_EQ_TILDE] = ACTIONS(797),
    [anon_sym_EQ_EQ] = ACTIONS(797),
    [anon_sym_EQ] = ACTIONS(799),
    [anon_sym_LT] = ACTIONS(797),
    [anon_sym_GT] = ACTIONS(797),
    [anon_sym_BANG_EQ] = ACTIONS(797),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(797),
  },
  [328] = {
    [sym__concat] = ACTIONS(801),
    [anon_sym_AMP_AMP] = ACTIONS(801),
    [anon_sym_PIPE_PIPE] = ACTIONS(801),
    [anon_sym_RBRACK] = ACTIONS(801),
    [anon_sym_EQ_TILDE] = ACTIONS(801),
    [anon_sym_EQ_EQ] = ACTIONS(801),
    [anon_sym_EQ] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(801),
    [anon_sym_GT] = ACTIONS(801),
    [anon_sym_BANG_EQ] = ACTIONS(801),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(801),
  },
  [329] = {
    [sym__concat] = ACTIONS(805),
    [anon_sym_AMP_AMP] = ACTIONS(805),
    [anon_sym_PIPE_PIPE] = ACTIONS(805),
    [anon_sym_RBRACK] = ACTIONS(805),
    [anon_sym_EQ_TILDE] = ACTIONS(805),
    [anon_sym_EQ_EQ] = ACTIONS(805),
    [anon_sym_EQ] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(805),
    [anon_sym_GT] = ACTIONS(805),
    [anon_sym_BANG_EQ] = ACTIONS(805),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(805),
  },
  [330] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(1359),
    [sym_comment] = ACTIONS(53),
  },
  [331] = {
    [sym_subscript] = STATE(740),
    [sym_variable_name] = ACTIONS(1361),
    [anon_sym_DOLLAR] = ACTIONS(1363),
    [anon_sym_DASH] = ACTIONS(1363),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1365),
    [anon_sym_STAR] = ACTIONS(1363),
    [anon_sym_AT] = ACTIONS(1363),
    [anon_sym_QMARK] = ACTIONS(1363),
    [anon_sym_0] = ACTIONS(1367),
    [anon_sym__] = ACTIONS(1367),
  },
  [332] = {
    [sym_concatenation] = STATE(743),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(743),
    [anon_sym_RBRACE] = ACTIONS(1369),
    [anon_sym_EQ] = ACTIONS(1371),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1373),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1375),
    [anon_sym_COLON] = ACTIONS(1371),
    [anon_sym_COLON_QMARK] = ACTIONS(1371),
    [anon_sym_COLON_DASH] = ACTIONS(1371),
    [anon_sym_PERCENT] = ACTIONS(1371),
    [anon_sym_DASH] = ACTIONS(1371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [333] = {
    [sym_concatenation] = STATE(746),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(746),
    [anon_sym_RBRACE] = ACTIONS(1377),
    [anon_sym_EQ] = ACTIONS(1379),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1381),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1383),
    [anon_sym_COLON] = ACTIONS(1379),
    [anon_sym_COLON_QMARK] = ACTIONS(1379),
    [anon_sym_COLON_DASH] = ACTIONS(1379),
    [anon_sym_PERCENT] = ACTIONS(1379),
    [anon_sym_DASH] = ACTIONS(1379),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [334] = {
    [sym_concatenation] = STATE(749),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(749),
    [anon_sym_RBRACE] = ACTIONS(1385),
    [anon_sym_EQ] = ACTIONS(1387),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1389),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1391),
    [anon_sym_COLON] = ACTIONS(1387),
    [anon_sym_COLON_QMARK] = ACTIONS(1387),
    [anon_sym_COLON_DASH] = ACTIONS(1387),
    [anon_sym_PERCENT] = ACTIONS(1387),
    [anon_sym_DASH] = ACTIONS(1387),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [335] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1393),
    [anon_sym_SEMI_SEMI] = ACTIONS(1395),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1397),
    [anon_sym_LF] = ACTIONS(1395),
    [anon_sym_AMP] = ACTIONS(1397),
  },
  [336] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1393),
    [anon_sym_SEMI_SEMI] = ACTIONS(1395),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1397),
    [anon_sym_LF] = ACTIONS(1395),
    [anon_sym_AMP] = ACTIONS(1397),
  },
  [337] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(752),
    [sym_c_style_for_statement] = STATE(752),
    [sym_while_statement] = STATE(752),
    [sym_if_statement] = STATE(752),
    [sym_case_statement] = STATE(752),
    [sym_function_definition] = STATE(752),
    [sym_subshell] = STATE(752),
    [sym_pipeline] = STATE(752),
    [sym_list] = STATE(752),
    [sym_negated_command] = STATE(752),
    [sym_test_command] = STATE(752),
    [sym_declaration_command] = STATE(752),
    [sym_unset_command] = STATE(752),
    [sym_command] = STATE(752),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(753),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [338] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1399),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(1393),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1401),
    [anon_sym_LF] = ACTIONS(1399),
    [anon_sym_AMP] = ACTIONS(1401),
  },
  [339] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1399),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(1393),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1401),
    [anon_sym_LF] = ACTIONS(1399),
    [anon_sym_AMP] = ACTIONS(1401),
  },
  [340] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(755),
    [sym_c_style_for_statement] = STATE(755),
    [sym_while_statement] = STATE(755),
    [sym_if_statement] = STATE(755),
    [sym_case_statement] = STATE(755),
    [sym_function_definition] = STATE(755),
    [sym_subshell] = STATE(755),
    [sym_pipeline] = STATE(755),
    [sym_list] = STATE(755),
    [sym_negated_command] = STATE(755),
    [sym_test_command] = STATE(755),
    [sym_declaration_command] = STATE(755),
    [sym_unset_command] = STATE(755),
    [sym_command] = STATE(755),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(756),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [341] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1403),
    [anon_sym_SEMI_SEMI] = ACTIONS(1405),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_LF] = ACTIONS(1405),
    [anon_sym_AMP] = ACTIONS(1407),
  },
  [342] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1403),
    [anon_sym_SEMI_SEMI] = ACTIONS(1405),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_LF] = ACTIONS(1405),
    [anon_sym_AMP] = ACTIONS(1407),
  },
  [343] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(759),
    [sym_c_style_for_statement] = STATE(759),
    [sym_while_statement] = STATE(759),
    [sym_if_statement] = STATE(759),
    [sym_case_statement] = STATE(759),
    [sym_function_definition] = STATE(759),
    [sym_subshell] = STATE(759),
    [sym_pipeline] = STATE(759),
    [sym_list] = STATE(759),
    [sym_negated_command] = STATE(759),
    [sym_test_command] = STATE(759),
    [sym_declaration_command] = STATE(759),
    [sym_unset_command] = STATE(759),
    [sym_command] = STATE(759),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(760),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [344] = {
    [sym__expression] = STATE(761),
    [sym_binary_expression] = STATE(761),
    [sym_unary_expression] = STATE(761),
    [sym_parenthesized_expression] = STATE(761),
    [sym_concatenation] = STATE(761),
    [sym_string] = STATE(92),
    [sym_simple_expansion] = STATE(92),
    [sym_string_expansion] = STATE(92),
    [sym_expansion] = STATE(92),
    [sym_command_substitution] = STATE(92),
    [sym_process_substitution] = STATE(92),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [345] = {
    [sym_file_redirect] = STATE(766),
    [sym_heredoc_redirect] = STATE(766),
    [sym_herestring_redirect] = STATE(766),
    [aux_sym_while_statement_repeat1] = STATE(766),
    [sym_file_descriptor] = ACTIONS(1409),
    [ts_builtin_sym_end] = ACTIONS(1411),
    [anon_sym_PIPE] = ACTIONS(1413),
    [anon_sym_SEMI_SEMI] = ACTIONS(1411),
    [anon_sym_PIPE_AMP] = ACTIONS(1411),
    [anon_sym_AMP_AMP] = ACTIONS(1411),
    [anon_sym_PIPE_PIPE] = ACTIONS(1411),
    [anon_sym_LT] = ACTIONS(1415),
    [anon_sym_GT] = ACTIONS(1415),
    [anon_sym_GT_GT] = ACTIONS(1417),
    [anon_sym_AMP_GT] = ACTIONS(1415),
    [anon_sym_AMP_GT_GT] = ACTIONS(1417),
    [anon_sym_LT_AMP] = ACTIONS(1417),
    [anon_sym_GT_AMP] = ACTIONS(1417),
    [anon_sym_LT_LT] = ACTIONS(1419),
    [anon_sym_LT_LT_DASH] = ACTIONS(1421),
    [anon_sym_LT_LT_LT] = ACTIONS(1423),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1413),
    [anon_sym_LF] = ACTIONS(1411),
    [anon_sym_AMP] = ACTIONS(1413),
  },
  [346] = {
    [sym__expression] = STATE(761),
    [sym_binary_expression] = STATE(761),
    [sym_unary_expression] = STATE(761),
    [sym_parenthesized_expression] = STATE(761),
    [sym_concatenation] = STATE(761),
    [sym_string] = STATE(92),
    [sym_simple_expansion] = STATE(92),
    [sym_string_expansion] = STATE(92),
    [sym_expansion] = STATE(92),
    [sym_command_substitution] = STATE(92),
    [sym_process_substitution] = STATE(92),
    [anon_sym_LPAREN] = ACTIONS(1425),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(1427),
    [anon_sym_DQUOTE] = ACTIONS(1429),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(153),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1431),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1433),
    [anon_sym_BQUOTE] = ACTIONS(1435),
    [anon_sym_LT_LPAREN] = ACTIONS(1437),
    [anon_sym_GT_LPAREN] = ACTIONS(1437),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(135),
    [sym_regex] = ACTIONS(1439),
  },
  [347] = {
    [anon_sym_RPAREN] = ACTIONS(1441),
    [anon_sym_AMP_AMP] = ACTIONS(1345),
    [anon_sym_PIPE_PIPE] = ACTIONS(1345),
    [anon_sym_EQ_TILDE] = ACTIONS(1347),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ] = ACTIONS(1349),
    [anon_sym_LT] = ACTIONS(1345),
    [anon_sym_GT] = ACTIONS(1345),
    [anon_sym_BANG_EQ] = ACTIONS(1345),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(1345),
  },
  [348] = {
    [anon_sym_AMP_AMP] = ACTIONS(639),
    [anon_sym_PIPE_PIPE] = ACTIONS(639),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1351),
    [anon_sym_EQ_TILDE] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(641),
    [anon_sym_EQ] = ACTIONS(643),
    [anon_sym_LT] = ACTIONS(639),
    [anon_sym_GT] = ACTIONS(639),
    [anon_sym_BANG_EQ] = ACTIONS(639),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(639),
  },
  [349] = {
    [sym_string] = STATE(769),
    [sym_simple_expansion] = STATE(769),
    [sym_string_expansion] = STATE(769),
    [sym_expansion] = STATE(769),
    [sym_command_substitution] = STATE(769),
    [sym_process_substitution] = STATE(769),
    [sym__special_characters] = ACTIONS(1443),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(1443),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1443),
  },
  [350] = {
    [aux_sym_concatenation_repeat1] = STATE(770),
    [sym__concat] = ACTIONS(615),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(761),
    [anon_sym_EQ_TILDE] = ACTIONS(761),
    [anon_sym_EQ_EQ] = ACTIONS(761),
    [anon_sym_EQ] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(761),
    [anon_sym_GT] = ACTIONS(761),
    [anon_sym_BANG_EQ] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(761),
  },
  [351] = {
    [sym__concat] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_RPAREN] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(765),
    [anon_sym_EQ_TILDE] = ACTIONS(765),
    [anon_sym_EQ_EQ] = ACTIONS(765),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_LT] = ACTIONS(765),
    [anon_sym_GT] = ACTIONS(765),
    [anon_sym_BANG_EQ] = ACTIONS(765),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(765),
  },
  [352] = {
    [anon_sym_DQUOTE] = ACTIONS(1445),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [353] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(1445),
    [anon_sym_DOLLAR] = ACTIONS(1447),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [354] = {
    [sym__concat] = ACTIONS(797),
    [anon_sym_PIPE] = ACTIONS(799),
    [anon_sym_RPAREN] = ACTIONS(797),
    [anon_sym_AMP_AMP] = ACTIONS(797),
    [anon_sym_PIPE_PIPE] = ACTIONS(797),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(797),
    [anon_sym_EQ_TILDE] = ACTIONS(797),
    [anon_sym_EQ_EQ] = ACTIONS(797),
    [anon_sym_EQ] = ACTIONS(799),
    [anon_sym_LT] = ACTIONS(797),
    [anon_sym_GT] = ACTIONS(797),
    [anon_sym_BANG_EQ] = ACTIONS(797),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(797),
  },
  [355] = {
    [sym__concat] = ACTIONS(801),
    [anon_sym_PIPE] = ACTIONS(803),
    [anon_sym_RPAREN] = ACTIONS(801),
    [anon_sym_AMP_AMP] = ACTIONS(801),
    [anon_sym_PIPE_PIPE] = ACTIONS(801),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(801),
    [anon_sym_EQ_TILDE] = ACTIONS(801),
    [anon_sym_EQ_EQ] = ACTIONS(801),
    [anon_sym_EQ] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(801),
    [anon_sym_GT] = ACTIONS(801),
    [anon_sym_BANG_EQ] = ACTIONS(801),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(801),
  },
  [356] = {
    [sym__concat] = ACTIONS(805),
    [anon_sym_PIPE] = ACTIONS(807),
    [anon_sym_RPAREN] = ACTIONS(805),
    [anon_sym_AMP_AMP] = ACTIONS(805),
    [anon_sym_PIPE_PIPE] = ACTIONS(805),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(805),
    [anon_sym_EQ_TILDE] = ACTIONS(805),
    [anon_sym_EQ_EQ] = ACTIONS(805),
    [anon_sym_EQ] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(805),
    [anon_sym_GT] = ACTIONS(805),
    [anon_sym_BANG_EQ] = ACTIONS(805),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(805),
  },
  [357] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(1449),
    [sym_comment] = ACTIONS(53),
  },
  [358] = {
    [sym_subscript] = STATE(777),
    [sym_variable_name] = ACTIONS(1451),
    [anon_sym_DOLLAR] = ACTIONS(1453),
    [anon_sym_DASH] = ACTIONS(1453),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1455),
    [anon_sym_STAR] = ACTIONS(1453),
    [anon_sym_AT] = ACTIONS(1453),
    [anon_sym_QMARK] = ACTIONS(1453),
    [anon_sym_0] = ACTIONS(1457),
    [anon_sym__] = ACTIONS(1457),
  },
  [359] = {
    [sym_concatenation] = STATE(780),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(780),
    [anon_sym_RBRACE] = ACTIONS(1459),
    [anon_sym_EQ] = ACTIONS(1461),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1463),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1465),
    [anon_sym_COLON] = ACTIONS(1461),
    [anon_sym_COLON_QMARK] = ACTIONS(1461),
    [anon_sym_COLON_DASH] = ACTIONS(1461),
    [anon_sym_PERCENT] = ACTIONS(1461),
    [anon_sym_DASH] = ACTIONS(1461),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [360] = {
    [sym_concatenation] = STATE(783),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(783),
    [anon_sym_RBRACE] = ACTIONS(1467),
    [anon_sym_EQ] = ACTIONS(1469),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1471),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_COLON] = ACTIONS(1469),
    [anon_sym_COLON_QMARK] = ACTIONS(1469),
    [anon_sym_COLON_DASH] = ACTIONS(1469),
    [anon_sym_PERCENT] = ACTIONS(1469),
    [anon_sym_DASH] = ACTIONS(1469),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [361] = {
    [sym_concatenation] = STATE(786),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(786),
    [anon_sym_RBRACE] = ACTIONS(1475),
    [anon_sym_EQ] = ACTIONS(1477),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1479),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1481),
    [anon_sym_COLON] = ACTIONS(1477),
    [anon_sym_COLON_QMARK] = ACTIONS(1477),
    [anon_sym_COLON_DASH] = ACTIONS(1477),
    [anon_sym_PERCENT] = ACTIONS(1477),
    [anon_sym_DASH] = ACTIONS(1477),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [362] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1483),
    [anon_sym_SEMI_SEMI] = ACTIONS(1485),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1487),
    [anon_sym_LF] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
  },
  [363] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1483),
    [anon_sym_SEMI_SEMI] = ACTIONS(1485),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1487),
    [anon_sym_LF] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
  },
  [364] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(789),
    [sym_c_style_for_statement] = STATE(789),
    [sym_while_statement] = STATE(789),
    [sym_if_statement] = STATE(789),
    [sym_case_statement] = STATE(789),
    [sym_function_definition] = STATE(789),
    [sym_subshell] = STATE(789),
    [sym_pipeline] = STATE(789),
    [sym_list] = STATE(789),
    [sym_negated_command] = STATE(789),
    [sym_test_command] = STATE(789),
    [sym_declaration_command] = STATE(789),
    [sym_unset_command] = STATE(789),
    [sym_command] = STATE(789),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(790),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [365] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1489),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(1483),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1491),
    [anon_sym_LF] = ACTIONS(1489),
    [anon_sym_AMP] = ACTIONS(1491),
  },
  [366] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1489),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(1483),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1491),
    [anon_sym_LF] = ACTIONS(1489),
    [anon_sym_AMP] = ACTIONS(1491),
  },
  [367] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(792),
    [sym_c_style_for_statement] = STATE(792),
    [sym_while_statement] = STATE(792),
    [sym_if_statement] = STATE(792),
    [sym_case_statement] = STATE(792),
    [sym_function_definition] = STATE(792),
    [sym_subshell] = STATE(792),
    [sym_pipeline] = STATE(792),
    [sym_list] = STATE(792),
    [sym_negated_command] = STATE(792),
    [sym_test_command] = STATE(792),
    [sym_declaration_command] = STATE(792),
    [sym_unset_command] = STATE(792),
    [sym_command] = STATE(792),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(793),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [368] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1493),
    [anon_sym_SEMI_SEMI] = ACTIONS(1495),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1497),
    [anon_sym_LF] = ACTIONS(1495),
    [anon_sym_AMP] = ACTIONS(1497),
  },
  [369] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1493),
    [anon_sym_SEMI_SEMI] = ACTIONS(1495),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1497),
    [anon_sym_LF] = ACTIONS(1495),
    [anon_sym_AMP] = ACTIONS(1497),
  },
  [370] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(796),
    [sym_c_style_for_statement] = STATE(796),
    [sym_while_statement] = STATE(796),
    [sym_if_statement] = STATE(796),
    [sym_case_statement] = STATE(796),
    [sym_function_definition] = STATE(796),
    [sym_subshell] = STATE(796),
    [sym_pipeline] = STATE(796),
    [sym_list] = STATE(796),
    [sym_negated_command] = STATE(796),
    [sym_test_command] = STATE(796),
    [sym_declaration_command] = STATE(796),
    [sym_unset_command] = STATE(796),
    [sym_command] = STATE(796),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(797),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [371] = {
    [sym__expression] = STATE(798),
    [sym_binary_expression] = STATE(798),
    [sym_unary_expression] = STATE(798),
    [sym_parenthesized_expression] = STATE(798),
    [sym_concatenation] = STATE(798),
    [sym_string] = STATE(103),
    [sym_simple_expansion] = STATE(103),
    [sym_string_expansion] = STATE(103),
    [sym_expansion] = STATE(103),
    [sym_command_substitution] = STATE(103),
    [sym_process_substitution] = STATE(103),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [sym__special_characters] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(167),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(177),
    [sym_test_operator] = ACTIONS(179),
  },
  [372] = {
    [sym__expression] = STATE(798),
    [sym_binary_expression] = STATE(798),
    [sym_unary_expression] = STATE(798),
    [sym_parenthesized_expression] = STATE(798),
    [sym_concatenation] = STATE(798),
    [sym_string] = STATE(103),
    [sym_simple_expansion] = STATE(103),
    [sym_string_expansion] = STATE(103),
    [sym_expansion] = STATE(103),
    [sym_command_substitution] = STATE(103),
    [sym_process_substitution] = STATE(103),
    [anon_sym_LPAREN] = ACTIONS(1499),
    [anon_sym_BANG] = ACTIONS(159),
    [sym__special_characters] = ACTIONS(1501),
    [anon_sym_DQUOTE] = ACTIONS(1503),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(177),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1505),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1507),
    [anon_sym_BQUOTE] = ACTIONS(1509),
    [anon_sym_LT_LPAREN] = ACTIONS(1511),
    [anon_sym_GT_LPAREN] = ACTIONS(1511),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(177),
    [sym_test_operator] = ACTIONS(159),
    [sym_regex] = ACTIONS(1513),
  },
  [373] = {
    [sym_concatenation] = STATE(800),
    [sym_string] = STATE(803),
    [sym_array] = STATE(800),
    [sym_simple_expansion] = STATE(803),
    [sym_string_expansion] = STATE(803),
    [sym_expansion] = STATE(803),
    [sym_command_substitution] = STATE(803),
    [sym_process_substitution] = STATE(803),
    [sym__empty_value] = ACTIONS(1515),
    [anon_sym_LPAREN] = ACTIONS(1517),
    [sym__special_characters] = ACTIONS(1519),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(1521),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1521),
  },
  [374] = {
    [sym_string] = STATE(804),
    [sym_simple_expansion] = STATE(804),
    [sym_string_expansion] = STATE(804),
    [sym_expansion] = STATE(804),
    [sym_command_substitution] = STATE(804),
    [sym_process_substitution] = STATE(804),
    [sym__special_characters] = ACTIONS(1523),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(1523),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1523),
  },
  [375] = {
    [aux_sym_concatenation_repeat1] = STATE(805),
    [sym__concat] = ACTIONS(647),
    [sym_variable_name] = ACTIONS(761),
    [ts_builtin_sym_end] = ACTIONS(761),
    [anon_sym_PIPE] = ACTIONS(763),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [anon_sym_PIPE_AMP] = ACTIONS(761),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [sym__special_characters] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(763),
    [sym_raw_string] = ACTIONS(761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(761),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(761),
    [anon_sym_LT_LPAREN] = ACTIONS(761),
    [anon_sym_GT_LPAREN] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(763),
    [sym_word] = ACTIONS(763),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
  },
  [376] = {
    [sym__concat] = ACTIONS(765),
    [sym_variable_name] = ACTIONS(765),
    [ts_builtin_sym_end] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_RPAREN] = ACTIONS(765),
    [anon_sym_SEMI_SEMI] = ACTIONS(765),
    [anon_sym_PIPE_AMP] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [sym__special_characters] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(765),
    [anon_sym_DOLLAR] = ACTIONS(767),
    [sym_raw_string] = ACTIONS(765),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(765),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(765),
    [anon_sym_BQUOTE] = ACTIONS(765),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(767),
    [sym_word] = ACTIONS(767),
    [anon_sym_SEMI] = ACTIONS(767),
    [anon_sym_LF] = ACTIONS(765),
    [anon_sym_AMP] = ACTIONS(767),
  },
  [377] = {
    [anon_sym_DQUOTE] = ACTIONS(1525),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [378] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(1525),
    [anon_sym_DOLLAR] = ACTIONS(1527),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [379] = {
    [sym__concat] = ACTIONS(797),
    [sym_variable_name] = ACTIONS(797),
    [ts_builtin_sym_end] = ACTIONS(797),
    [anon_sym_PIPE] = ACTIONS(799),
    [anon_sym_RPAREN] = ACTIONS(797),
    [anon_sym_SEMI_SEMI] = ACTIONS(797),
    [anon_sym_PIPE_AMP] = ACTIONS(797),
    [anon_sym_AMP_AMP] = ACTIONS(797),
    [anon_sym_PIPE_PIPE] = ACTIONS(797),
    [sym__special_characters] = ACTIONS(797),
    [anon_sym_DQUOTE] = ACTIONS(797),
    [anon_sym_DOLLAR] = ACTIONS(799),
    [sym_raw_string] = ACTIONS(797),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(797),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(797),
    [anon_sym_BQUOTE] = ACTIONS(797),
    [anon_sym_LT_LPAREN] = ACTIONS(797),
    [anon_sym_GT_LPAREN] = ACTIONS(797),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(799),
    [sym_word] = ACTIONS(799),
    [anon_sym_SEMI] = ACTIONS(799),
    [anon_sym_LF] = ACTIONS(797),
    [anon_sym_AMP] = ACTIONS(799),
  },
  [380] = {
    [sym__concat] = ACTIONS(801),
    [sym_variable_name] = ACTIONS(801),
    [ts_builtin_sym_end] = ACTIONS(801),
    [anon_sym_PIPE] = ACTIONS(803),
    [anon_sym_RPAREN] = ACTIONS(801),
    [anon_sym_SEMI_SEMI] = ACTIONS(801),
    [anon_sym_PIPE_AMP] = ACTIONS(801),
    [anon_sym_AMP_AMP] = ACTIONS(801),
    [anon_sym_PIPE_PIPE] = ACTIONS(801),
    [sym__special_characters] = ACTIONS(801),
    [anon_sym_DQUOTE] = ACTIONS(801),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [sym_raw_string] = ACTIONS(801),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(801),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(801),
    [anon_sym_BQUOTE] = ACTIONS(801),
    [anon_sym_LT_LPAREN] = ACTIONS(801),
    [anon_sym_GT_LPAREN] = ACTIONS(801),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(803),
    [sym_word] = ACTIONS(803),
    [anon_sym_SEMI] = ACTIONS(803),
    [anon_sym_LF] = ACTIONS(801),
    [anon_sym_AMP] = ACTIONS(803),
  },
  [381] = {
    [sym__concat] = ACTIONS(805),
    [sym_variable_name] = ACTIONS(805),
    [ts_builtin_sym_end] = ACTIONS(805),
    [anon_sym_PIPE] = ACTIONS(807),
    [anon_sym_RPAREN] = ACTIONS(805),
    [anon_sym_SEMI_SEMI] = ACTIONS(805),
    [anon_sym_PIPE_AMP] = ACTIONS(805),
    [anon_sym_AMP_AMP] = ACTIONS(805),
    [anon_sym_PIPE_PIPE] = ACTIONS(805),
    [sym__special_characters] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(805),
    [anon_sym_DOLLAR] = ACTIONS(807),
    [sym_raw_string] = ACTIONS(805),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(805),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(805),
    [anon_sym_BQUOTE] = ACTIONS(805),
    [anon_sym_LT_LPAREN] = ACTIONS(805),
    [anon_sym_GT_LPAREN] = ACTIONS(805),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(807),
    [sym_word] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(807),
    [anon_sym_LF] = ACTIONS(805),
    [anon_sym_AMP] = ACTIONS(807),
  },
  [382] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(1529),
    [sym_comment] = ACTIONS(53),
  },
  [383] = {
    [sym_subscript] = STATE(812),
    [sym_variable_name] = ACTIONS(1531),
    [anon_sym_DOLLAR] = ACTIONS(1533),
    [anon_sym_DASH] = ACTIONS(1533),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1535),
    [anon_sym_STAR] = ACTIONS(1533),
    [anon_sym_AT] = ACTIONS(1533),
    [anon_sym_QMARK] = ACTIONS(1533),
    [anon_sym_0] = ACTIONS(1537),
    [anon_sym__] = ACTIONS(1537),
  },
  [384] = {
    [sym_concatenation] = STATE(815),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(815),
    [anon_sym_RBRACE] = ACTIONS(1539),
    [anon_sym_EQ] = ACTIONS(1541),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1543),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1545),
    [anon_sym_COLON] = ACTIONS(1541),
    [anon_sym_COLON_QMARK] = ACTIONS(1541),
    [anon_sym_COLON_DASH] = ACTIONS(1541),
    [anon_sym_PERCENT] = ACTIONS(1541),
    [anon_sym_DASH] = ACTIONS(1541),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [385] = {
    [sym_concatenation] = STATE(818),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(818),
    [anon_sym_RBRACE] = ACTIONS(1547),
    [anon_sym_EQ] = ACTIONS(1549),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1551),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1553),
    [anon_sym_COLON] = ACTIONS(1549),
    [anon_sym_COLON_QMARK] = ACTIONS(1549),
    [anon_sym_COLON_DASH] = ACTIONS(1549),
    [anon_sym_PERCENT] = ACTIONS(1549),
    [anon_sym_DASH] = ACTIONS(1549),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [386] = {
    [sym_concatenation] = STATE(821),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(821),
    [anon_sym_RBRACE] = ACTIONS(1555),
    [anon_sym_EQ] = ACTIONS(1557),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1559),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1561),
    [anon_sym_COLON] = ACTIONS(1557),
    [anon_sym_COLON_QMARK] = ACTIONS(1557),
    [anon_sym_COLON_DASH] = ACTIONS(1557),
    [anon_sym_PERCENT] = ACTIONS(1557),
    [anon_sym_DASH] = ACTIONS(1557),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [387] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1563),
    [anon_sym_SEMI_SEMI] = ACTIONS(1565),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1567),
    [anon_sym_LF] = ACTIONS(1565),
    [anon_sym_AMP] = ACTIONS(1567),
  },
  [388] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1563),
    [anon_sym_SEMI_SEMI] = ACTIONS(1565),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1567),
    [anon_sym_LF] = ACTIONS(1565),
    [anon_sym_AMP] = ACTIONS(1567),
  },
  [389] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(824),
    [sym_c_style_for_statement] = STATE(824),
    [sym_while_statement] = STATE(824),
    [sym_if_statement] = STATE(824),
    [sym_case_statement] = STATE(824),
    [sym_function_definition] = STATE(824),
    [sym_subshell] = STATE(824),
    [sym_pipeline] = STATE(824),
    [sym_list] = STATE(824),
    [sym_negated_command] = STATE(824),
    [sym_test_command] = STATE(824),
    [sym_declaration_command] = STATE(824),
    [sym_unset_command] = STATE(824),
    [sym_command] = STATE(824),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(825),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [390] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1569),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(1563),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1571),
    [anon_sym_LF] = ACTIONS(1569),
    [anon_sym_AMP] = ACTIONS(1571),
  },
  [391] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1569),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(1563),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1571),
    [anon_sym_LF] = ACTIONS(1569),
    [anon_sym_AMP] = ACTIONS(1571),
  },
  [392] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(827),
    [sym_c_style_for_statement] = STATE(827),
    [sym_while_statement] = STATE(827),
    [sym_if_statement] = STATE(827),
    [sym_case_statement] = STATE(827),
    [sym_function_definition] = STATE(827),
    [sym_subshell] = STATE(827),
    [sym_pipeline] = STATE(827),
    [sym_list] = STATE(827),
    [sym_negated_command] = STATE(827),
    [sym_test_command] = STATE(827),
    [sym_declaration_command] = STATE(827),
    [sym_unset_command] = STATE(827),
    [sym_command] = STATE(827),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(828),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [393] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1573),
    [anon_sym_SEMI_SEMI] = ACTIONS(1575),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1577),
    [anon_sym_LF] = ACTIONS(1575),
    [anon_sym_AMP] = ACTIONS(1577),
  },
  [394] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1573),
    [anon_sym_SEMI_SEMI] = ACTIONS(1575),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1577),
    [anon_sym_LF] = ACTIONS(1575),
    [anon_sym_AMP] = ACTIONS(1577),
  },
  [395] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(831),
    [sym_c_style_for_statement] = STATE(831),
    [sym_while_statement] = STATE(831),
    [sym_if_statement] = STATE(831),
    [sym_case_statement] = STATE(831),
    [sym_function_definition] = STATE(831),
    [sym_subshell] = STATE(831),
    [sym_pipeline] = STATE(831),
    [sym_list] = STATE(831),
    [sym_negated_command] = STATE(831),
    [sym_test_command] = STATE(831),
    [sym_declaration_command] = STATE(831),
    [sym_unset_command] = STATE(831),
    [sym_command] = STATE(831),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(832),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [396] = {
    [sym_variable_assignment] = STATE(396),
    [sym_subscript] = STATE(119),
    [sym_concatenation] = STATE(396),
    [sym_string] = STATE(113),
    [sym_simple_expansion] = STATE(113),
    [sym_string_expansion] = STATE(113),
    [sym_expansion] = STATE(113),
    [sym_command_substitution] = STATE(113),
    [sym_process_substitution] = STATE(113),
    [aux_sym_declaration_command_repeat1] = STATE(396),
    [sym_variable_name] = ACTIONS(1579),
    [ts_builtin_sym_end] = ACTIONS(1582),
    [anon_sym_PIPE] = ACTIONS(1584),
    [anon_sym_SEMI_SEMI] = ACTIONS(1582),
    [anon_sym_PIPE_AMP] = ACTIONS(1582),
    [anon_sym_AMP_AMP] = ACTIONS(1582),
    [anon_sym_PIPE_PIPE] = ACTIONS(1582),
    [sym__special_characters] = ACTIONS(1586),
    [anon_sym_DQUOTE] = ACTIONS(1589),
    [anon_sym_DOLLAR] = ACTIONS(1592),
    [sym_raw_string] = ACTIONS(1595),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1598),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1601),
    [anon_sym_BQUOTE] = ACTIONS(1604),
    [anon_sym_LT_LPAREN] = ACTIONS(1607),
    [anon_sym_GT_LPAREN] = ACTIONS(1607),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1610),
    [sym_word] = ACTIONS(1613),
    [anon_sym_SEMI] = ACTIONS(1584),
    [anon_sym_LF] = ACTIONS(1582),
    [anon_sym_AMP] = ACTIONS(1584),
  },
  [397] = {
    [sym_string] = STATE(833),
    [sym_simple_expansion] = STATE(833),
    [sym_string_expansion] = STATE(833),
    [sym_expansion] = STATE(833),
    [sym_command_substitution] = STATE(833),
    [sym_process_substitution] = STATE(833),
    [sym__special_characters] = ACTIONS(1616),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1616),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1616),
  },
  [398] = {
    [aux_sym_concatenation_repeat1] = STATE(834),
    [sym__concat] = ACTIONS(687),
    [ts_builtin_sym_end] = ACTIONS(761),
    [anon_sym_PIPE] = ACTIONS(763),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [anon_sym_PIPE_AMP] = ACTIONS(761),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [sym__special_characters] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(763),
    [sym_raw_string] = ACTIONS(761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(761),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(761),
    [anon_sym_LT_LPAREN] = ACTIONS(761),
    [anon_sym_GT_LPAREN] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(763),
    [sym_word] = ACTIONS(763),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
  },
  [399] = {
    [sym__concat] = ACTIONS(765),
    [ts_builtin_sym_end] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_RPAREN] = ACTIONS(765),
    [anon_sym_SEMI_SEMI] = ACTIONS(765),
    [anon_sym_PIPE_AMP] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [sym__special_characters] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(765),
    [anon_sym_DOLLAR] = ACTIONS(767),
    [sym_raw_string] = ACTIONS(765),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(765),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(765),
    [anon_sym_BQUOTE] = ACTIONS(765),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(767),
    [sym_word] = ACTIONS(767),
    [anon_sym_SEMI] = ACTIONS(767),
    [anon_sym_LF] = ACTIONS(765),
    [anon_sym_AMP] = ACTIONS(767),
  },
  [400] = {
    [anon_sym_DQUOTE] = ACTIONS(1618),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [401] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(1618),
    [anon_sym_DOLLAR] = ACTIONS(1620),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [402] = {
    [sym__concat] = ACTIONS(797),
    [ts_builtin_sym_end] = ACTIONS(797),
    [anon_sym_PIPE] = ACTIONS(799),
    [anon_sym_RPAREN] = ACTIONS(797),
    [anon_sym_SEMI_SEMI] = ACTIONS(797),
    [anon_sym_PIPE_AMP] = ACTIONS(797),
    [anon_sym_AMP_AMP] = ACTIONS(797),
    [anon_sym_PIPE_PIPE] = ACTIONS(797),
    [sym__special_characters] = ACTIONS(797),
    [anon_sym_DQUOTE] = ACTIONS(797),
    [anon_sym_DOLLAR] = ACTIONS(799),
    [sym_raw_string] = ACTIONS(797),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(797),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(797),
    [anon_sym_BQUOTE] = ACTIONS(797),
    [anon_sym_LT_LPAREN] = ACTIONS(797),
    [anon_sym_GT_LPAREN] = ACTIONS(797),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(799),
    [sym_word] = ACTIONS(799),
    [anon_sym_SEMI] = ACTIONS(799),
    [anon_sym_LF] = ACTIONS(797),
    [anon_sym_AMP] = ACTIONS(799),
  },
  [403] = {
    [sym__concat] = ACTIONS(801),
    [ts_builtin_sym_end] = ACTIONS(801),
    [anon_sym_PIPE] = ACTIONS(803),
    [anon_sym_RPAREN] = ACTIONS(801),
    [anon_sym_SEMI_SEMI] = ACTIONS(801),
    [anon_sym_PIPE_AMP] = ACTIONS(801),
    [anon_sym_AMP_AMP] = ACTIONS(801),
    [anon_sym_PIPE_PIPE] = ACTIONS(801),
    [sym__special_characters] = ACTIONS(801),
    [anon_sym_DQUOTE] = ACTIONS(801),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [sym_raw_string] = ACTIONS(801),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(801),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(801),
    [anon_sym_BQUOTE] = ACTIONS(801),
    [anon_sym_LT_LPAREN] = ACTIONS(801),
    [anon_sym_GT_LPAREN] = ACTIONS(801),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(803),
    [sym_word] = ACTIONS(803),
    [anon_sym_SEMI] = ACTIONS(803),
    [anon_sym_LF] = ACTIONS(801),
    [anon_sym_AMP] = ACTIONS(803),
  },
  [404] = {
    [sym__concat] = ACTIONS(805),
    [ts_builtin_sym_end] = ACTIONS(805),
    [anon_sym_PIPE] = ACTIONS(807),
    [anon_sym_RPAREN] = ACTIONS(805),
    [anon_sym_SEMI_SEMI] = ACTIONS(805),
    [anon_sym_PIPE_AMP] = ACTIONS(805),
    [anon_sym_AMP_AMP] = ACTIONS(805),
    [anon_sym_PIPE_PIPE] = ACTIONS(805),
    [sym__special_characters] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(805),
    [anon_sym_DOLLAR] = ACTIONS(807),
    [sym_raw_string] = ACTIONS(805),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(805),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(805),
    [anon_sym_BQUOTE] = ACTIONS(805),
    [anon_sym_LT_LPAREN] = ACTIONS(805),
    [anon_sym_GT_LPAREN] = ACTIONS(805),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(807),
    [sym_word] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(807),
    [anon_sym_LF] = ACTIONS(805),
    [anon_sym_AMP] = ACTIONS(807),
  },
  [405] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(1622),
    [sym_comment] = ACTIONS(53),
  },
  [406] = {
    [sym_subscript] = STATE(841),
    [sym_variable_name] = ACTIONS(1624),
    [anon_sym_DOLLAR] = ACTIONS(1626),
    [anon_sym_DASH] = ACTIONS(1626),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1628),
    [anon_sym_STAR] = ACTIONS(1626),
    [anon_sym_AT] = ACTIONS(1626),
    [anon_sym_QMARK] = ACTIONS(1626),
    [anon_sym_0] = ACTIONS(1630),
    [anon_sym__] = ACTIONS(1630),
  },
  [407] = {
    [sym_concatenation] = STATE(844),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(844),
    [anon_sym_RBRACE] = ACTIONS(1632),
    [anon_sym_EQ] = ACTIONS(1634),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1636),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1638),
    [anon_sym_COLON] = ACTIONS(1634),
    [anon_sym_COLON_QMARK] = ACTIONS(1634),
    [anon_sym_COLON_DASH] = ACTIONS(1634),
    [anon_sym_PERCENT] = ACTIONS(1634),
    [anon_sym_DASH] = ACTIONS(1634),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [408] = {
    [sym_concatenation] = STATE(847),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(847),
    [anon_sym_RBRACE] = ACTIONS(1640),
    [anon_sym_EQ] = ACTIONS(1642),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1644),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1646),
    [anon_sym_COLON] = ACTIONS(1642),
    [anon_sym_COLON_QMARK] = ACTIONS(1642),
    [anon_sym_COLON_DASH] = ACTIONS(1642),
    [anon_sym_PERCENT] = ACTIONS(1642),
    [anon_sym_DASH] = ACTIONS(1642),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [409] = {
    [sym_concatenation] = STATE(850),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(850),
    [anon_sym_RBRACE] = ACTIONS(1648),
    [anon_sym_EQ] = ACTIONS(1650),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1652),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1654),
    [anon_sym_COLON] = ACTIONS(1650),
    [anon_sym_COLON_QMARK] = ACTIONS(1650),
    [anon_sym_COLON_DASH] = ACTIONS(1650),
    [anon_sym_PERCENT] = ACTIONS(1650),
    [anon_sym_DASH] = ACTIONS(1650),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [410] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1656),
    [anon_sym_SEMI_SEMI] = ACTIONS(1658),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1660),
    [anon_sym_LF] = ACTIONS(1658),
    [anon_sym_AMP] = ACTIONS(1660),
  },
  [411] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1656),
    [anon_sym_SEMI_SEMI] = ACTIONS(1658),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1660),
    [anon_sym_LF] = ACTIONS(1658),
    [anon_sym_AMP] = ACTIONS(1660),
  },
  [412] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(853),
    [sym_c_style_for_statement] = STATE(853),
    [sym_while_statement] = STATE(853),
    [sym_if_statement] = STATE(853),
    [sym_case_statement] = STATE(853),
    [sym_function_definition] = STATE(853),
    [sym_subshell] = STATE(853),
    [sym_pipeline] = STATE(853),
    [sym_list] = STATE(853),
    [sym_negated_command] = STATE(853),
    [sym_test_command] = STATE(853),
    [sym_declaration_command] = STATE(853),
    [sym_unset_command] = STATE(853),
    [sym_command] = STATE(853),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(854),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [413] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1662),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(1656),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1664),
    [anon_sym_LF] = ACTIONS(1662),
    [anon_sym_AMP] = ACTIONS(1664),
  },
  [414] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1662),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(1656),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1664),
    [anon_sym_LF] = ACTIONS(1662),
    [anon_sym_AMP] = ACTIONS(1664),
  },
  [415] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(856),
    [sym_c_style_for_statement] = STATE(856),
    [sym_while_statement] = STATE(856),
    [sym_if_statement] = STATE(856),
    [sym_case_statement] = STATE(856),
    [sym_function_definition] = STATE(856),
    [sym_subshell] = STATE(856),
    [sym_pipeline] = STATE(856),
    [sym_list] = STATE(856),
    [sym_negated_command] = STATE(856),
    [sym_test_command] = STATE(856),
    [sym_declaration_command] = STATE(856),
    [sym_unset_command] = STATE(856),
    [sym_command] = STATE(856),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(857),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [416] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1666),
    [anon_sym_SEMI_SEMI] = ACTIONS(1668),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1670),
    [anon_sym_LF] = ACTIONS(1668),
    [anon_sym_AMP] = ACTIONS(1670),
  },
  [417] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1666),
    [anon_sym_SEMI_SEMI] = ACTIONS(1668),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1670),
    [anon_sym_LF] = ACTIONS(1668),
    [anon_sym_AMP] = ACTIONS(1670),
  },
  [418] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(860),
    [sym_c_style_for_statement] = STATE(860),
    [sym_while_statement] = STATE(860),
    [sym_if_statement] = STATE(860),
    [sym_case_statement] = STATE(860),
    [sym_function_definition] = STATE(860),
    [sym_subshell] = STATE(860),
    [sym_pipeline] = STATE(860),
    [sym_list] = STATE(860),
    [sym_negated_command] = STATE(860),
    [sym_test_command] = STATE(860),
    [sym_declaration_command] = STATE(860),
    [sym_unset_command] = STATE(860),
    [sym_command] = STATE(860),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(861),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [419] = {
    [sym_concatenation] = STATE(419),
    [sym_string] = STATE(124),
    [sym_simple_expansion] = STATE(124),
    [sym_string_expansion] = STATE(124),
    [sym_expansion] = STATE(124),
    [sym_command_substitution] = STATE(124),
    [sym_process_substitution] = STATE(124),
    [aux_sym_unset_command_repeat1] = STATE(419),
    [ts_builtin_sym_end] = ACTIONS(1672),
    [anon_sym_PIPE] = ACTIONS(1674),
    [anon_sym_SEMI_SEMI] = ACTIONS(1672),
    [anon_sym_PIPE_AMP] = ACTIONS(1672),
    [anon_sym_AMP_AMP] = ACTIONS(1672),
    [anon_sym_PIPE_PIPE] = ACTIONS(1672),
    [sym__special_characters] = ACTIONS(1676),
    [anon_sym_DQUOTE] = ACTIONS(1679),
    [anon_sym_DOLLAR] = ACTIONS(1682),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1688),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1691),
    [anon_sym_BQUOTE] = ACTIONS(1694),
    [anon_sym_LT_LPAREN] = ACTIONS(1697),
    [anon_sym_GT_LPAREN] = ACTIONS(1697),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1700),
    [sym_word] = ACTIONS(1703),
    [anon_sym_SEMI] = ACTIONS(1674),
    [anon_sym_LF] = ACTIONS(1672),
    [anon_sym_AMP] = ACTIONS(1674),
  },
  [420] = {
    [sym_string] = STATE(862),
    [sym_simple_expansion] = STATE(862),
    [sym_string_expansion] = STATE(862),
    [sym_expansion] = STATE(862),
    [sym_command_substitution] = STATE(862),
    [sym_process_substitution] = STATE(862),
    [sym__special_characters] = ACTIONS(1706),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [anon_sym_DOLLAR] = ACTIONS(235),
    [sym_raw_string] = ACTIONS(1706),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(239),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(241),
    [anon_sym_BQUOTE] = ACTIONS(243),
    [anon_sym_LT_LPAREN] = ACTIONS(245),
    [anon_sym_GT_LPAREN] = ACTIONS(245),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1706),
  },
  [421] = {
    [aux_sym_concatenation_repeat1] = STATE(863),
    [sym_file_descriptor] = ACTIONS(761),
    [sym__concat] = ACTIONS(729),
    [sym_variable_name] = ACTIONS(761),
    [anon_sym_LT] = ACTIONS(763),
    [anon_sym_GT] = ACTIONS(763),
    [anon_sym_GT_GT] = ACTIONS(761),
    [anon_sym_AMP_GT] = ACTIONS(763),
    [anon_sym_AMP_GT_GT] = ACTIONS(761),
    [anon_sym_LT_AMP] = ACTIONS(761),
    [anon_sym_GT_AMP] = ACTIONS(761),
    [sym__special_characters] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(763),
    [sym_raw_string] = ACTIONS(761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(761),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(761),
    [anon_sym_LT_LPAREN] = ACTIONS(761),
    [anon_sym_GT_LPAREN] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(761),
  },
  [422] = {
    [sym_file_descriptor] = ACTIONS(765),
    [sym__concat] = ACTIONS(765),
    [sym_variable_name] = ACTIONS(765),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_GT_GT] = ACTIONS(765),
    [anon_sym_AMP_GT] = ACTIONS(767),
    [anon_sym_AMP_GT_GT] = ACTIONS(765),
    [anon_sym_LT_AMP] = ACTIONS(765),
    [anon_sym_GT_AMP] = ACTIONS(765),
    [sym__special_characters] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(765),
    [anon_sym_DOLLAR] = ACTIONS(767),
    [sym_raw_string] = ACTIONS(765),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(765),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(765),
    [anon_sym_BQUOTE] = ACTIONS(765),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(765),
  },
  [423] = {
    [anon_sym_DQUOTE] = ACTIONS(1708),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [424] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(1708),
    [anon_sym_DOLLAR] = ACTIONS(1710),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [425] = {
    [sym_file_descriptor] = ACTIONS(797),
    [sym__concat] = ACTIONS(797),
    [sym_variable_name] = ACTIONS(797),
    [anon_sym_LT] = ACTIONS(799),
    [anon_sym_GT] = ACTIONS(799),
    [anon_sym_GT_GT] = ACTIONS(797),
    [anon_sym_AMP_GT] = ACTIONS(799),
    [anon_sym_AMP_GT_GT] = ACTIONS(797),
    [anon_sym_LT_AMP] = ACTIONS(797),
    [anon_sym_GT_AMP] = ACTIONS(797),
    [sym__special_characters] = ACTIONS(797),
    [anon_sym_DQUOTE] = ACTIONS(797),
    [anon_sym_DOLLAR] = ACTIONS(799),
    [sym_raw_string] = ACTIONS(797),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(797),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(797),
    [anon_sym_BQUOTE] = ACTIONS(797),
    [anon_sym_LT_LPAREN] = ACTIONS(797),
    [anon_sym_GT_LPAREN] = ACTIONS(797),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(797),
  },
  [426] = {
    [sym_file_descriptor] = ACTIONS(801),
    [sym__concat] = ACTIONS(801),
    [sym_variable_name] = ACTIONS(801),
    [anon_sym_LT] = ACTIONS(803),
    [anon_sym_GT] = ACTIONS(803),
    [anon_sym_GT_GT] = ACTIONS(801),
    [anon_sym_AMP_GT] = ACTIONS(803),
    [anon_sym_AMP_GT_GT] = ACTIONS(801),
    [anon_sym_LT_AMP] = ACTIONS(801),
    [anon_sym_GT_AMP] = ACTIONS(801),
    [sym__special_characters] = ACTIONS(801),
    [anon_sym_DQUOTE] = ACTIONS(801),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [sym_raw_string] = ACTIONS(801),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(801),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(801),
    [anon_sym_BQUOTE] = ACTIONS(801),
    [anon_sym_LT_LPAREN] = ACTIONS(801),
    [anon_sym_GT_LPAREN] = ACTIONS(801),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(801),
  },
  [427] = {
    [sym_file_descriptor] = ACTIONS(805),
    [sym__concat] = ACTIONS(805),
    [sym_variable_name] = ACTIONS(805),
    [anon_sym_LT] = ACTIONS(807),
    [anon_sym_GT] = ACTIONS(807),
    [anon_sym_GT_GT] = ACTIONS(805),
    [anon_sym_AMP_GT] = ACTIONS(807),
    [anon_sym_AMP_GT_GT] = ACTIONS(805),
    [anon_sym_LT_AMP] = ACTIONS(805),
    [anon_sym_GT_AMP] = ACTIONS(805),
    [sym__special_characters] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(805),
    [anon_sym_DOLLAR] = ACTIONS(807),
    [sym_raw_string] = ACTIONS(805),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(805),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(805),
    [anon_sym_BQUOTE] = ACTIONS(805),
    [anon_sym_LT_LPAREN] = ACTIONS(805),
    [anon_sym_GT_LPAREN] = ACTIONS(805),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(805),
  },
  [428] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(1712),
    [sym_comment] = ACTIONS(53),
  },
  [429] = {
    [sym_subscript] = STATE(870),
    [sym_variable_name] = ACTIONS(1714),
    [anon_sym_DOLLAR] = ACTIONS(1716),
    [anon_sym_DASH] = ACTIONS(1716),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1718),
    [anon_sym_STAR] = ACTIONS(1716),
    [anon_sym_AT] = ACTIONS(1716),
    [anon_sym_QMARK] = ACTIONS(1716),
    [anon_sym_0] = ACTIONS(1720),
    [anon_sym__] = ACTIONS(1720),
  },
  [430] = {
    [sym_concatenation] = STATE(873),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(873),
    [anon_sym_RBRACE] = ACTIONS(1722),
    [anon_sym_EQ] = ACTIONS(1724),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1726),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1728),
    [anon_sym_COLON] = ACTIONS(1724),
    [anon_sym_COLON_QMARK] = ACTIONS(1724),
    [anon_sym_COLON_DASH] = ACTIONS(1724),
    [anon_sym_PERCENT] = ACTIONS(1724),
    [anon_sym_DASH] = ACTIONS(1724),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [431] = {
    [sym_concatenation] = STATE(876),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(876),
    [anon_sym_RBRACE] = ACTIONS(1730),
    [anon_sym_EQ] = ACTIONS(1732),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1734),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1736),
    [anon_sym_COLON] = ACTIONS(1732),
    [anon_sym_COLON_QMARK] = ACTIONS(1732),
    [anon_sym_COLON_DASH] = ACTIONS(1732),
    [anon_sym_PERCENT] = ACTIONS(1732),
    [anon_sym_DASH] = ACTIONS(1732),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [432] = {
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(879),
    [anon_sym_RBRACE] = ACTIONS(1738),
    [anon_sym_EQ] = ACTIONS(1740),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1742),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1744),
    [anon_sym_COLON] = ACTIONS(1740),
    [anon_sym_COLON_QMARK] = ACTIONS(1740),
    [anon_sym_COLON_DASH] = ACTIONS(1740),
    [anon_sym_PERCENT] = ACTIONS(1740),
    [anon_sym_DASH] = ACTIONS(1740),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [433] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1746),
    [anon_sym_SEMI_SEMI] = ACTIONS(1748),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1750),
    [anon_sym_LF] = ACTIONS(1748),
    [anon_sym_AMP] = ACTIONS(1750),
  },
  [434] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1746),
    [anon_sym_SEMI_SEMI] = ACTIONS(1748),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1750),
    [anon_sym_LF] = ACTIONS(1748),
    [anon_sym_AMP] = ACTIONS(1750),
  },
  [435] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(882),
    [sym_c_style_for_statement] = STATE(882),
    [sym_while_statement] = STATE(882),
    [sym_if_statement] = STATE(882),
    [sym_case_statement] = STATE(882),
    [sym_function_definition] = STATE(882),
    [sym_subshell] = STATE(882),
    [sym_pipeline] = STATE(882),
    [sym_list] = STATE(882),
    [sym_negated_command] = STATE(882),
    [sym_test_command] = STATE(882),
    [sym_declaration_command] = STATE(882),
    [sym_unset_command] = STATE(882),
    [sym_command] = STATE(882),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(883),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [436] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1752),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(1746),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1754),
    [anon_sym_LF] = ACTIONS(1752),
    [anon_sym_AMP] = ACTIONS(1754),
  },
  [437] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1752),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(1746),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1754),
    [anon_sym_LF] = ACTIONS(1752),
    [anon_sym_AMP] = ACTIONS(1754),
  },
  [438] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(885),
    [sym_c_style_for_statement] = STATE(885),
    [sym_while_statement] = STATE(885),
    [sym_if_statement] = STATE(885),
    [sym_case_statement] = STATE(885),
    [sym_function_definition] = STATE(885),
    [sym_subshell] = STATE(885),
    [sym_pipeline] = STATE(885),
    [sym_list] = STATE(885),
    [sym_negated_command] = STATE(885),
    [sym_test_command] = STATE(885),
    [sym_declaration_command] = STATE(885),
    [sym_unset_command] = STATE(885),
    [sym_command] = STATE(885),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(886),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [439] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1756),
    [anon_sym_SEMI_SEMI] = ACTIONS(1758),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1760),
    [anon_sym_LF] = ACTIONS(1758),
    [anon_sym_AMP] = ACTIONS(1760),
  },
  [440] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1756),
    [anon_sym_SEMI_SEMI] = ACTIONS(1758),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1760),
    [anon_sym_LF] = ACTIONS(1758),
    [anon_sym_AMP] = ACTIONS(1760),
  },
  [441] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(889),
    [sym_c_style_for_statement] = STATE(889),
    [sym_while_statement] = STATE(889),
    [sym_if_statement] = STATE(889),
    [sym_case_statement] = STATE(889),
    [sym_function_definition] = STATE(889),
    [sym_subshell] = STATE(889),
    [sym_pipeline] = STATE(889),
    [sym_list] = STATE(889),
    [sym_negated_command] = STATE(889),
    [sym_test_command] = STATE(889),
    [sym_declaration_command] = STATE(889),
    [sym_unset_command] = STATE(889),
    [sym_command] = STATE(889),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(890),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [442] = {
    [sym__simple_heredoc_body] = ACTIONS(1762),
    [sym__heredoc_body_beginning] = ACTIONS(1762),
    [sym_file_descriptor] = ACTIONS(1762),
    [sym__concat] = ACTIONS(1762),
    [ts_builtin_sym_end] = ACTIONS(1762),
    [anon_sym_PIPE] = ACTIONS(1764),
    [anon_sym_RPAREN] = ACTIONS(1762),
    [anon_sym_SEMI_SEMI] = ACTIONS(1762),
    [anon_sym_PIPE_AMP] = ACTIONS(1762),
    [anon_sym_AMP_AMP] = ACTIONS(1762),
    [anon_sym_PIPE_PIPE] = ACTIONS(1762),
    [anon_sym_EQ_TILDE] = ACTIONS(1764),
    [anon_sym_EQ_EQ] = ACTIONS(1764),
    [anon_sym_LT] = ACTIONS(1764),
    [anon_sym_GT] = ACTIONS(1764),
    [anon_sym_GT_GT] = ACTIONS(1762),
    [anon_sym_AMP_GT] = ACTIONS(1764),
    [anon_sym_AMP_GT_GT] = ACTIONS(1762),
    [anon_sym_LT_AMP] = ACTIONS(1762),
    [anon_sym_GT_AMP] = ACTIONS(1762),
    [anon_sym_LT_LT] = ACTIONS(1764),
    [anon_sym_LT_LT_DASH] = ACTIONS(1762),
    [anon_sym_LT_LT_LT] = ACTIONS(1762),
    [sym__special_characters] = ACTIONS(1762),
    [anon_sym_DQUOTE] = ACTIONS(1762),
    [anon_sym_DOLLAR] = ACTIONS(1764),
    [sym_raw_string] = ACTIONS(1762),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1762),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1762),
    [anon_sym_BQUOTE] = ACTIONS(1762),
    [anon_sym_LT_LPAREN] = ACTIONS(1762),
    [anon_sym_GT_LPAREN] = ACTIONS(1762),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1764),
    [anon_sym_SEMI] = ACTIONS(1764),
    [anon_sym_LF] = ACTIONS(1762),
    [anon_sym_AMP] = ACTIONS(1764),
  },
  [443] = {
    [aux_sym_concatenation_repeat1] = STATE(443),
    [sym__simple_heredoc_body] = ACTIONS(1762),
    [sym__heredoc_body_beginning] = ACTIONS(1762),
    [sym_file_descriptor] = ACTIONS(1762),
    [sym__concat] = ACTIONS(1766),
    [ts_builtin_sym_end] = ACTIONS(1762),
    [anon_sym_PIPE] = ACTIONS(1764),
    [anon_sym_SEMI_SEMI] = ACTIONS(1762),
    [anon_sym_PIPE_AMP] = ACTIONS(1762),
    [anon_sym_AMP_AMP] = ACTIONS(1762),
    [anon_sym_PIPE_PIPE] = ACTIONS(1762),
    [anon_sym_EQ_TILDE] = ACTIONS(1764),
    [anon_sym_EQ_EQ] = ACTIONS(1764),
    [anon_sym_LT] = ACTIONS(1764),
    [anon_sym_GT] = ACTIONS(1764),
    [anon_sym_GT_GT] = ACTIONS(1762),
    [anon_sym_AMP_GT] = ACTIONS(1764),
    [anon_sym_AMP_GT_GT] = ACTIONS(1762),
    [anon_sym_LT_AMP] = ACTIONS(1762),
    [anon_sym_GT_AMP] = ACTIONS(1762),
    [anon_sym_LT_LT] = ACTIONS(1764),
    [anon_sym_LT_LT_DASH] = ACTIONS(1762),
    [anon_sym_LT_LT_LT] = ACTIONS(1762),
    [sym__special_characters] = ACTIONS(1762),
    [anon_sym_DQUOTE] = ACTIONS(1762),
    [anon_sym_DOLLAR] = ACTIONS(1764),
    [sym_raw_string] = ACTIONS(1762),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1762),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1762),
    [anon_sym_BQUOTE] = ACTIONS(1762),
    [anon_sym_LT_LPAREN] = ACTIONS(1762),
    [anon_sym_GT_LPAREN] = ACTIONS(1762),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1764),
    [anon_sym_SEMI] = ACTIONS(1764),
    [anon_sym_LF] = ACTIONS(1762),
    [anon_sym_AMP] = ACTIONS(1764),
  },
  [444] = {
    [sym__simple_heredoc_body] = ACTIONS(1769),
    [sym__heredoc_body_beginning] = ACTIONS(1769),
    [sym_file_descriptor] = ACTIONS(1769),
    [sym__concat] = ACTIONS(1769),
    [ts_builtin_sym_end] = ACTIONS(1769),
    [anon_sym_PIPE] = ACTIONS(1771),
    [anon_sym_RPAREN] = ACTIONS(1769),
    [anon_sym_SEMI_SEMI] = ACTIONS(1769),
    [anon_sym_PIPE_AMP] = ACTIONS(1769),
    [anon_sym_AMP_AMP] = ACTIONS(1769),
    [anon_sym_PIPE_PIPE] = ACTIONS(1769),
    [anon_sym_EQ_TILDE] = ACTIONS(1771),
    [anon_sym_EQ_EQ] = ACTIONS(1771),
    [anon_sym_LT] = ACTIONS(1771),
    [anon_sym_GT] = ACTIONS(1771),
    [anon_sym_GT_GT] = ACTIONS(1769),
    [anon_sym_AMP_GT] = ACTIONS(1771),
    [anon_sym_AMP_GT_GT] = ACTIONS(1769),
    [anon_sym_LT_AMP] = ACTIONS(1769),
    [anon_sym_GT_AMP] = ACTIONS(1769),
    [anon_sym_LT_LT] = ACTIONS(1771),
    [anon_sym_LT_LT_DASH] = ACTIONS(1769),
    [anon_sym_LT_LT_LT] = ACTIONS(1769),
    [sym__special_characters] = ACTIONS(1769),
    [anon_sym_DQUOTE] = ACTIONS(1769),
    [anon_sym_DOLLAR] = ACTIONS(1771),
    [sym_raw_string] = ACTIONS(1769),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1769),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1769),
    [anon_sym_BQUOTE] = ACTIONS(1769),
    [anon_sym_LT_LPAREN] = ACTIONS(1769),
    [anon_sym_GT_LPAREN] = ACTIONS(1769),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1771),
    [anon_sym_SEMI] = ACTIONS(1771),
    [anon_sym_LF] = ACTIONS(1769),
    [anon_sym_AMP] = ACTIONS(1771),
  },
  [445] = {
    [sym__concat] = ACTIONS(797),
    [anon_sym_DQUOTE] = ACTIONS(799),
    [anon_sym_DOLLAR] = ACTIONS(799),
    [sym__string_content] = ACTIONS(797),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(799),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(799),
    [anon_sym_BQUOTE] = ACTIONS(799),
    [sym_comment] = ACTIONS(265),
  },
  [446] = {
    [sym__concat] = ACTIONS(1773),
    [anon_sym_DQUOTE] = ACTIONS(1775),
    [anon_sym_DOLLAR] = ACTIONS(1775),
    [sym__string_content] = ACTIONS(1777),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1775),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1775),
    [anon_sym_BQUOTE] = ACTIONS(1775),
    [sym_comment] = ACTIONS(265),
  },
  [447] = {
    [sym__concat] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(807),
    [sym__string_content] = ACTIONS(805),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(807),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(807),
    [anon_sym_BQUOTE] = ACTIONS(807),
    [sym_comment] = ACTIONS(265),
  },
  [448] = {
    [anon_sym_DQUOTE] = ACTIONS(1775),
    [anon_sym_DOLLAR] = ACTIONS(1775),
    [sym__string_content] = ACTIONS(1777),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1775),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1775),
    [anon_sym_BQUOTE] = ACTIONS(1775),
    [sym_comment] = ACTIONS(265),
  },
  [449] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(1779),
    [sym_comment] = ACTIONS(53),
  },
  [450] = {
    [sym_subscript] = STATE(896),
    [sym_variable_name] = ACTIONS(1781),
    [anon_sym_DOLLAR] = ACTIONS(1783),
    [anon_sym_DASH] = ACTIONS(1783),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1785),
    [anon_sym_STAR] = ACTIONS(1783),
    [anon_sym_AT] = ACTIONS(1783),
    [anon_sym_QMARK] = ACTIONS(1783),
    [anon_sym_0] = ACTIONS(1787),
    [anon_sym__] = ACTIONS(1787),
  },
  [451] = {
    [sym_concatenation] = STATE(899),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(899),
    [anon_sym_RBRACE] = ACTIONS(1789),
    [anon_sym_EQ] = ACTIONS(1791),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1793),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1795),
    [anon_sym_COLON] = ACTIONS(1791),
    [anon_sym_COLON_QMARK] = ACTIONS(1791),
    [anon_sym_COLON_DASH] = ACTIONS(1791),
    [anon_sym_PERCENT] = ACTIONS(1791),
    [anon_sym_DASH] = ACTIONS(1791),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [452] = {
    [sym_concatenation] = STATE(902),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(902),
    [anon_sym_RBRACE] = ACTIONS(1797),
    [anon_sym_EQ] = ACTIONS(1799),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1801),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1803),
    [anon_sym_COLON] = ACTIONS(1799),
    [anon_sym_COLON_QMARK] = ACTIONS(1799),
    [anon_sym_COLON_DASH] = ACTIONS(1799),
    [anon_sym_PERCENT] = ACTIONS(1799),
    [anon_sym_DASH] = ACTIONS(1799),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [453] = {
    [sym_concatenation] = STATE(905),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(905),
    [anon_sym_RBRACE] = ACTIONS(1805),
    [anon_sym_EQ] = ACTIONS(1807),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1809),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1811),
    [anon_sym_COLON] = ACTIONS(1807),
    [anon_sym_COLON_QMARK] = ACTIONS(1807),
    [anon_sym_COLON_DASH] = ACTIONS(1807),
    [anon_sym_PERCENT] = ACTIONS(1807),
    [anon_sym_DASH] = ACTIONS(1807),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [454] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1813),
    [anon_sym_SEMI_SEMI] = ACTIONS(1815),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1817),
    [anon_sym_LF] = ACTIONS(1815),
    [anon_sym_AMP] = ACTIONS(1817),
  },
  [455] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1813),
    [anon_sym_SEMI_SEMI] = ACTIONS(1815),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1817),
    [anon_sym_LF] = ACTIONS(1815),
    [anon_sym_AMP] = ACTIONS(1817),
  },
  [456] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(908),
    [sym_c_style_for_statement] = STATE(908),
    [sym_while_statement] = STATE(908),
    [sym_if_statement] = STATE(908),
    [sym_case_statement] = STATE(908),
    [sym_function_definition] = STATE(908),
    [sym_subshell] = STATE(908),
    [sym_pipeline] = STATE(908),
    [sym_list] = STATE(908),
    [sym_negated_command] = STATE(908),
    [sym_test_command] = STATE(908),
    [sym_declaration_command] = STATE(908),
    [sym_unset_command] = STATE(908),
    [sym_command] = STATE(908),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(909),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [457] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1819),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(1813),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1821),
    [anon_sym_LF] = ACTIONS(1819),
    [anon_sym_AMP] = ACTIONS(1821),
  },
  [458] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1819),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(1813),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1821),
    [anon_sym_LF] = ACTIONS(1819),
    [anon_sym_AMP] = ACTIONS(1821),
  },
  [459] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(911),
    [sym_c_style_for_statement] = STATE(911),
    [sym_while_statement] = STATE(911),
    [sym_if_statement] = STATE(911),
    [sym_case_statement] = STATE(911),
    [sym_function_definition] = STATE(911),
    [sym_subshell] = STATE(911),
    [sym_pipeline] = STATE(911),
    [sym_list] = STATE(911),
    [sym_negated_command] = STATE(911),
    [sym_test_command] = STATE(911),
    [sym_declaration_command] = STATE(911),
    [sym_unset_command] = STATE(911),
    [sym_command] = STATE(911),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(912),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [460] = {
    [anon_sym_DQUOTE] = ACTIONS(1823),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [461] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(1775),
    [anon_sym_DOLLAR] = ACTIONS(1825),
    [sym__string_content] = ACTIONS(1828),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1831),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1834),
    [anon_sym_BQUOTE] = ACTIONS(1837),
    [sym_comment] = ACTIONS(265),
  },
  [462] = {
    [sym_concatenation] = STATE(917),
    [sym_string] = STATE(916),
    [sym_simple_expansion] = STATE(916),
    [sym_string_expansion] = STATE(916),
    [sym_expansion] = STATE(916),
    [sym_command_substitution] = STATE(916),
    [sym_process_substitution] = STATE(916),
    [sym__special_characters] = ACTIONS(1840),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(1842),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1842),
  },
  [463] = {
    [sym_concatenation] = STATE(927),
    [sym_string] = STATE(922),
    [sym_simple_expansion] = STATE(922),
    [sym_string_expansion] = STATE(922),
    [sym_expansion] = STATE(922),
    [sym_command_substitution] = STATE(922),
    [sym_process_substitution] = STATE(922),
    [anon_sym_RBRACE] = ACTIONS(1844),
    [sym__special_characters] = ACTIONS(1846),
    [anon_sym_DQUOTE] = ACTIONS(1848),
    [anon_sym_DOLLAR] = ACTIONS(1850),
    [sym_raw_string] = ACTIONS(1852),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1854),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1856),
    [anon_sym_BQUOTE] = ACTIONS(1858),
    [anon_sym_LT_LPAREN] = ACTIONS(1860),
    [anon_sym_GT_LPAREN] = ACTIONS(1860),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1852),
  },
  [464] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(1862),
    [sym_comment] = ACTIONS(53),
  },
  [465] = {
    [sym_concatenation] = STATE(931),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(931),
    [anon_sym_RBRACE] = ACTIONS(1864),
    [anon_sym_EQ] = ACTIONS(1866),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1868),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1870),
    [anon_sym_COLON] = ACTIONS(1866),
    [anon_sym_COLON_QMARK] = ACTIONS(1866),
    [anon_sym_COLON_DASH] = ACTIONS(1866),
    [anon_sym_PERCENT] = ACTIONS(1866),
    [anon_sym_DASH] = ACTIONS(1866),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [466] = {
    [sym_concatenation] = STATE(934),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(934),
    [anon_sym_RBRACE] = ACTIONS(1872),
    [anon_sym_EQ] = ACTIONS(1874),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1876),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1878),
    [anon_sym_COLON] = ACTIONS(1874),
    [anon_sym_COLON_QMARK] = ACTIONS(1874),
    [anon_sym_COLON_DASH] = ACTIONS(1874),
    [anon_sym_PERCENT] = ACTIONS(1874),
    [anon_sym_DASH] = ACTIONS(1874),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [467] = {
    [sym_concatenation] = STATE(936),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(936),
    [anon_sym_RBRACE] = ACTIONS(1844),
    [anon_sym_EQ] = ACTIONS(1880),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1882),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(1884),
    [anon_sym_COLON] = ACTIONS(1880),
    [anon_sym_COLON_QMARK] = ACTIONS(1880),
    [anon_sym_COLON_DASH] = ACTIONS(1880),
    [anon_sym_PERCENT] = ACTIONS(1880),
    [anon_sym_DASH] = ACTIONS(1880),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [468] = {
    [sym__simple_heredoc_body] = ACTIONS(1886),
    [sym__heredoc_body_beginning] = ACTIONS(1886),
    [sym_file_descriptor] = ACTIONS(1886),
    [sym__concat] = ACTIONS(1886),
    [ts_builtin_sym_end] = ACTIONS(1886),
    [anon_sym_PIPE] = ACTIONS(1888),
    [anon_sym_RPAREN] = ACTIONS(1886),
    [anon_sym_SEMI_SEMI] = ACTIONS(1886),
    [anon_sym_PIPE_AMP] = ACTIONS(1886),
    [anon_sym_AMP_AMP] = ACTIONS(1886),
    [anon_sym_PIPE_PIPE] = ACTIONS(1886),
    [anon_sym_EQ_TILDE] = ACTIONS(1888),
    [anon_sym_EQ_EQ] = ACTIONS(1888),
    [anon_sym_LT] = ACTIONS(1888),
    [anon_sym_GT] = ACTIONS(1888),
    [anon_sym_GT_GT] = ACTIONS(1886),
    [anon_sym_AMP_GT] = ACTIONS(1888),
    [anon_sym_AMP_GT_GT] = ACTIONS(1886),
    [anon_sym_LT_AMP] = ACTIONS(1886),
    [anon_sym_GT_AMP] = ACTIONS(1886),
    [anon_sym_LT_LT] = ACTIONS(1888),
    [anon_sym_LT_LT_DASH] = ACTIONS(1886),
    [anon_sym_LT_LT_LT] = ACTIONS(1886),
    [sym__special_characters] = ACTIONS(1886),
    [anon_sym_DQUOTE] = ACTIONS(1886),
    [anon_sym_DOLLAR] = ACTIONS(1888),
    [sym_raw_string] = ACTIONS(1886),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1886),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1886),
    [anon_sym_BQUOTE] = ACTIONS(1886),
    [anon_sym_LT_LPAREN] = ACTIONS(1886),
    [anon_sym_GT_LPAREN] = ACTIONS(1886),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1888),
    [anon_sym_SEMI] = ACTIONS(1888),
    [anon_sym_LF] = ACTIONS(1886),
    [anon_sym_AMP] = ACTIONS(1888),
  },
  [469] = {
    [aux_sym_concatenation_repeat1] = STATE(938),
    [sym__concat] = ACTIONS(1890),
    [anon_sym_RBRACE] = ACTIONS(1892),
    [anon_sym_EQ] = ACTIONS(1894),
    [sym__special_characters] = ACTIONS(1894),
    [anon_sym_DQUOTE] = ACTIONS(1892),
    [anon_sym_DOLLAR] = ACTIONS(1894),
    [sym_raw_string] = ACTIONS(1892),
    [anon_sym_POUND] = ACTIONS(1892),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1892),
    [anon_sym_COLON] = ACTIONS(1894),
    [anon_sym_COLON_QMARK] = ACTIONS(1894),
    [anon_sym_COLON_DASH] = ACTIONS(1894),
    [anon_sym_PERCENT] = ACTIONS(1894),
    [anon_sym_DASH] = ACTIONS(1894),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1892),
    [anon_sym_BQUOTE] = ACTIONS(1892),
    [anon_sym_LT_LPAREN] = ACTIONS(1892),
    [anon_sym_GT_LPAREN] = ACTIONS(1892),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(1894),
  },
  [470] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(941),
    [anon_sym_DQUOTE] = ACTIONS(1896),
    [anon_sym_DOLLAR] = ACTIONS(1898),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [471] = {
    [sym_string] = STATE(943),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(1900),
    [sym_raw_string] = ACTIONS(1902),
    [anon_sym_POUND] = ACTIONS(1900),
    [anon_sym_DASH] = ACTIONS(1900),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1904),
    [anon_sym_STAR] = ACTIONS(1900),
    [anon_sym_AT] = ACTIONS(1900),
    [anon_sym_QMARK] = ACTIONS(1900),
    [anon_sym_0] = ACTIONS(1906),
    [anon_sym__] = ACTIONS(1906),
  },
  [472] = {
    [aux_sym_concatenation_repeat1] = STATE(938),
    [sym__concat] = ACTIONS(1890),
    [anon_sym_RBRACE] = ACTIONS(1908),
    [anon_sym_EQ] = ACTIONS(1910),
    [sym__special_characters] = ACTIONS(1910),
    [anon_sym_DQUOTE] = ACTIONS(1908),
    [anon_sym_DOLLAR] = ACTIONS(1910),
    [sym_raw_string] = ACTIONS(1908),
    [anon_sym_POUND] = ACTIONS(1908),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1908),
    [anon_sym_COLON] = ACTIONS(1910),
    [anon_sym_COLON_QMARK] = ACTIONS(1910),
    [anon_sym_COLON_DASH] = ACTIONS(1910),
    [anon_sym_PERCENT] = ACTIONS(1910),
    [anon_sym_DASH] = ACTIONS(1910),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1908),
    [anon_sym_BQUOTE] = ACTIONS(1908),
    [anon_sym_LT_LPAREN] = ACTIONS(1908),
    [anon_sym_GT_LPAREN] = ACTIONS(1908),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(1910),
  },
  [473] = {
    [sym_subscript] = STATE(949),
    [sym_variable_name] = ACTIONS(1912),
    [anon_sym_BANG] = ACTIONS(1914),
    [anon_sym_DOLLAR] = ACTIONS(1916),
    [anon_sym_POUND] = ACTIONS(1914),
    [anon_sym_DASH] = ACTIONS(1916),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1918),
    [anon_sym_STAR] = ACTIONS(1916),
    [anon_sym_AT] = ACTIONS(1916),
    [anon_sym_QMARK] = ACTIONS(1916),
    [anon_sym_0] = ACTIONS(1920),
    [anon_sym__] = ACTIONS(1920),
  },
  [474] = {
    [sym_comment] = ACTIONS(265),
    [sym_regex_without_right_brace] = ACTIONS(1922),
  },
  [475] = {
    [sym__terminated_statement] = STATE(953),
    [sym_for_statement] = STATE(951),
    [sym_c_style_for_statement] = STATE(951),
    [sym_while_statement] = STATE(951),
    [sym_if_statement] = STATE(951),
    [sym_case_statement] = STATE(951),
    [sym_function_definition] = STATE(951),
    [sym_subshell] = STATE(951),
    [sym_pipeline] = STATE(951),
    [sym_list] = STATE(951),
    [sym_negated_command] = STATE(951),
    [sym_test_command] = STATE(951),
    [sym_declaration_command] = STATE(951),
    [sym_unset_command] = STATE(951),
    [sym_command] = STATE(951),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(952),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(953),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [476] = {
    [sym__terminated_statement] = STATE(956),
    [sym_for_statement] = STATE(954),
    [sym_c_style_for_statement] = STATE(954),
    [sym_while_statement] = STATE(954),
    [sym_if_statement] = STATE(954),
    [sym_case_statement] = STATE(954),
    [sym_function_definition] = STATE(954),
    [sym_subshell] = STATE(954),
    [sym_pipeline] = STATE(954),
    [sym_list] = STATE(954),
    [sym_negated_command] = STATE(954),
    [sym_test_command] = STATE(954),
    [sym_declaration_command] = STATE(954),
    [sym_unset_command] = STATE(954),
    [sym_command] = STATE(954),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(955),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(956),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [477] = {
    [sym__terminated_statement] = STATE(959),
    [sym_for_statement] = STATE(957),
    [sym_c_style_for_statement] = STATE(957),
    [sym_while_statement] = STATE(957),
    [sym_if_statement] = STATE(957),
    [sym_case_statement] = STATE(957),
    [sym_function_definition] = STATE(957),
    [sym_subshell] = STATE(957),
    [sym_pipeline] = STATE(957),
    [sym_list] = STATE(957),
    [sym_negated_command] = STATE(957),
    [sym_test_command] = STATE(957),
    [sym_declaration_command] = STATE(957),
    [sym_unset_command] = STATE(957),
    [sym_command] = STATE(957),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(958),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(959),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [478] = {
    [sym_concatenation] = STATE(961),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(961),
    [anon_sym_RBRACE] = ACTIONS(1924),
    [anon_sym_EQ] = ACTIONS(1926),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1928),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_COLON] = ACTIONS(1926),
    [anon_sym_COLON_QMARK] = ACTIONS(1926),
    [anon_sym_COLON_DASH] = ACTIONS(1926),
    [anon_sym_PERCENT] = ACTIONS(1926),
    [anon_sym_DASH] = ACTIONS(1926),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [479] = {
    [sym__simple_heredoc_body] = ACTIONS(1930),
    [sym__heredoc_body_beginning] = ACTIONS(1930),
    [sym_file_descriptor] = ACTIONS(1930),
    [sym__concat] = ACTIONS(1930),
    [ts_builtin_sym_end] = ACTIONS(1930),
    [anon_sym_PIPE] = ACTIONS(1932),
    [anon_sym_RPAREN] = ACTIONS(1930),
    [anon_sym_SEMI_SEMI] = ACTIONS(1930),
    [anon_sym_PIPE_AMP] = ACTIONS(1930),
    [anon_sym_AMP_AMP] = ACTIONS(1930),
    [anon_sym_PIPE_PIPE] = ACTIONS(1930),
    [anon_sym_EQ_TILDE] = ACTIONS(1932),
    [anon_sym_EQ_EQ] = ACTIONS(1932),
    [anon_sym_LT] = ACTIONS(1932),
    [anon_sym_GT] = ACTIONS(1932),
    [anon_sym_GT_GT] = ACTIONS(1930),
    [anon_sym_AMP_GT] = ACTIONS(1932),
    [anon_sym_AMP_GT_GT] = ACTIONS(1930),
    [anon_sym_LT_AMP] = ACTIONS(1930),
    [anon_sym_GT_AMP] = ACTIONS(1930),
    [anon_sym_LT_LT] = ACTIONS(1932),
    [anon_sym_LT_LT_DASH] = ACTIONS(1930),
    [anon_sym_LT_LT_LT] = ACTIONS(1930),
    [sym__special_characters] = ACTIONS(1930),
    [anon_sym_DQUOTE] = ACTIONS(1930),
    [anon_sym_DOLLAR] = ACTIONS(1932),
    [sym_raw_string] = ACTIONS(1930),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1930),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1930),
    [anon_sym_BQUOTE] = ACTIONS(1930),
    [anon_sym_LT_LPAREN] = ACTIONS(1930),
    [anon_sym_GT_LPAREN] = ACTIONS(1930),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1932),
    [anon_sym_SEMI] = ACTIONS(1932),
    [anon_sym_LF] = ACTIONS(1930),
    [anon_sym_AMP] = ACTIONS(1932),
  },
  [480] = {
    [sym_comment] = ACTIONS(265),
    [sym_regex_without_right_brace] = ACTIONS(1934),
  },
  [481] = {
    [sym_concatenation] = STATE(961),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(961),
    [anon_sym_RBRACE] = ACTIONS(1936),
    [anon_sym_EQ] = ACTIONS(1926),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1928),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_COLON] = ACTIONS(1926),
    [anon_sym_COLON_QMARK] = ACTIONS(1926),
    [anon_sym_COLON_DASH] = ACTIONS(1926),
    [anon_sym_PERCENT] = ACTIONS(1926),
    [anon_sym_DASH] = ACTIONS(1926),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [482] = {
    [sym__simple_heredoc_body] = ACTIONS(1938),
    [sym__heredoc_body_beginning] = ACTIONS(1938),
    [sym_file_descriptor] = ACTIONS(1938),
    [sym__concat] = ACTIONS(1938),
    [ts_builtin_sym_end] = ACTIONS(1938),
    [anon_sym_PIPE] = ACTIONS(1940),
    [anon_sym_RPAREN] = ACTIONS(1938),
    [anon_sym_SEMI_SEMI] = ACTIONS(1938),
    [anon_sym_PIPE_AMP] = ACTIONS(1938),
    [anon_sym_AMP_AMP] = ACTIONS(1938),
    [anon_sym_PIPE_PIPE] = ACTIONS(1938),
    [anon_sym_EQ_TILDE] = ACTIONS(1940),
    [anon_sym_EQ_EQ] = ACTIONS(1940),
    [anon_sym_LT] = ACTIONS(1940),
    [anon_sym_GT] = ACTIONS(1940),
    [anon_sym_GT_GT] = ACTIONS(1938),
    [anon_sym_AMP_GT] = ACTIONS(1940),
    [anon_sym_AMP_GT_GT] = ACTIONS(1938),
    [anon_sym_LT_AMP] = ACTIONS(1938),
    [anon_sym_GT_AMP] = ACTIONS(1938),
    [anon_sym_LT_LT] = ACTIONS(1940),
    [anon_sym_LT_LT_DASH] = ACTIONS(1938),
    [anon_sym_LT_LT_LT] = ACTIONS(1938),
    [sym__special_characters] = ACTIONS(1938),
    [anon_sym_DQUOTE] = ACTIONS(1938),
    [anon_sym_DOLLAR] = ACTIONS(1940),
    [sym_raw_string] = ACTIONS(1938),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1938),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1938),
    [anon_sym_BQUOTE] = ACTIONS(1938),
    [anon_sym_LT_LPAREN] = ACTIONS(1938),
    [anon_sym_GT_LPAREN] = ACTIONS(1938),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1940),
    [anon_sym_SEMI] = ACTIONS(1940),
    [anon_sym_LF] = ACTIONS(1938),
    [anon_sym_AMP] = ACTIONS(1940),
  },
  [483] = {
    [sym_comment] = ACTIONS(265),
    [sym_regex_without_right_brace] = ACTIONS(1942),
  },
  [484] = {
    [sym_concatenation] = STATE(961),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(961),
    [anon_sym_RBRACE] = ACTIONS(1844),
    [anon_sym_EQ] = ACTIONS(1926),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(1928),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_COLON] = ACTIONS(1926),
    [anon_sym_COLON_QMARK] = ACTIONS(1926),
    [anon_sym_COLON_DASH] = ACTIONS(1926),
    [anon_sym_PERCENT] = ACTIONS(1926),
    [anon_sym_DASH] = ACTIONS(1926),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [485] = {
    [sym__simple_heredoc_body] = ACTIONS(1944),
    [sym__heredoc_body_beginning] = ACTIONS(1944),
    [sym_file_descriptor] = ACTIONS(1944),
    [sym__concat] = ACTIONS(1944),
    [ts_builtin_sym_end] = ACTIONS(1944),
    [anon_sym_PIPE] = ACTIONS(1946),
    [anon_sym_RPAREN] = ACTIONS(1944),
    [anon_sym_SEMI_SEMI] = ACTIONS(1944),
    [anon_sym_PIPE_AMP] = ACTIONS(1944),
    [anon_sym_AMP_AMP] = ACTIONS(1944),
    [anon_sym_PIPE_PIPE] = ACTIONS(1944),
    [anon_sym_EQ_TILDE] = ACTIONS(1946),
    [anon_sym_EQ_EQ] = ACTIONS(1946),
    [anon_sym_LT] = ACTIONS(1946),
    [anon_sym_GT] = ACTIONS(1946),
    [anon_sym_GT_GT] = ACTIONS(1944),
    [anon_sym_AMP_GT] = ACTIONS(1946),
    [anon_sym_AMP_GT_GT] = ACTIONS(1944),
    [anon_sym_LT_AMP] = ACTIONS(1944),
    [anon_sym_GT_AMP] = ACTIONS(1944),
    [anon_sym_LT_LT] = ACTIONS(1946),
    [anon_sym_LT_LT_DASH] = ACTIONS(1944),
    [anon_sym_LT_LT_LT] = ACTIONS(1944),
    [sym__special_characters] = ACTIONS(1944),
    [anon_sym_DQUOTE] = ACTIONS(1944),
    [anon_sym_DOLLAR] = ACTIONS(1946),
    [sym_raw_string] = ACTIONS(1944),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1944),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1944),
    [anon_sym_BQUOTE] = ACTIONS(1944),
    [anon_sym_LT_LPAREN] = ACTIONS(1944),
    [anon_sym_GT_LPAREN] = ACTIONS(1944),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1946),
    [anon_sym_SEMI] = ACTIONS(1946),
    [anon_sym_LF] = ACTIONS(1944),
    [anon_sym_AMP] = ACTIONS(1946),
  },
  [486] = {
    [sym_file_descriptor] = ACTIONS(899),
    [sym_variable_name] = ACTIONS(899),
    [anon_sym_for] = ACTIONS(903),
    [anon_sym_while] = ACTIONS(903),
    [anon_sym_if] = ACTIONS(903),
    [anon_sym_case] = ACTIONS(903),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_function] = ACTIONS(903),
    [anon_sym_LPAREN] = ACTIONS(899),
    [anon_sym_BANG] = ACTIONS(903),
    [anon_sym_LBRACK] = ACTIONS(903),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(899),
    [anon_sym_declare] = ACTIONS(903),
    [anon_sym_typeset] = ACTIONS(903),
    [anon_sym_export] = ACTIONS(903),
    [anon_sym_readonly] = ACTIONS(903),
    [anon_sym_local] = ACTIONS(903),
    [anon_sym_unset] = ACTIONS(903),
    [anon_sym_unsetenv] = ACTIONS(903),
    [anon_sym_LT] = ACTIONS(903),
    [anon_sym_GT] = ACTIONS(903),
    [anon_sym_GT_GT] = ACTIONS(899),
    [anon_sym_AMP_GT] = ACTIONS(903),
    [anon_sym_AMP_GT_GT] = ACTIONS(899),
    [anon_sym_LT_AMP] = ACTIONS(899),
    [anon_sym_GT_AMP] = ACTIONS(899),
    [sym__special_characters] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(903),
    [sym_raw_string] = ACTIONS(899),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(899),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(899),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_LT_LPAREN] = ACTIONS(899),
    [anon_sym_GT_LPAREN] = ACTIONS(899),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(903),
  },
  [487] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_SEMI_SEMI] = ACTIONS(1950),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1952),
    [anon_sym_LF] = ACTIONS(1950),
    [anon_sym_AMP] = ACTIONS(1952),
  },
  [488] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_SEMI_SEMI] = ACTIONS(1950),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1952),
    [anon_sym_LF] = ACTIONS(1950),
    [anon_sym_AMP] = ACTIONS(1952),
  },
  [489] = {
    [sym_do_group] = STATE(967),
    [anon_sym_do] = ACTIONS(437),
    [sym_comment] = ACTIONS(53),
  },
  [490] = {
    [sym_compound_statement] = STATE(969),
    [anon_sym_LPAREN] = ACTIONS(1954),
    [anon_sym_LBRACE] = ACTIONS(507),
    [sym_comment] = ACTIONS(53),
  },
  [491] = {
    [anon_sym_AMP_AMP] = ACTIONS(607),
    [anon_sym_PIPE_PIPE] = ACTIONS(607),
    [anon_sym_RBRACK] = ACTIONS(1956),
    [anon_sym_EQ_TILDE] = ACTIONS(611),
    [anon_sym_EQ_EQ] = ACTIONS(611),
    [anon_sym_EQ] = ACTIONS(613),
    [anon_sym_LT] = ACTIONS(607),
    [anon_sym_GT] = ACTIONS(607),
    [anon_sym_BANG_EQ] = ACTIONS(607),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(607),
  },
  [492] = {
    [anon_sym_AMP_AMP] = ACTIONS(639),
    [anon_sym_PIPE_PIPE] = ACTIONS(639),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1956),
    [anon_sym_EQ_TILDE] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(641),
    [anon_sym_EQ] = ACTIONS(643),
    [anon_sym_LT] = ACTIONS(639),
    [anon_sym_GT] = ACTIONS(639),
    [anon_sym_BANG_EQ] = ACTIONS(639),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(639),
  },
  [493] = {
    [sym_variable_assignment] = STATE(625),
    [sym_subscript] = STATE(235),
    [sym_concatenation] = STATE(625),
    [sym_string] = STATE(234),
    [sym_simple_expansion] = STATE(234),
    [sym_string_expansion] = STATE(234),
    [sym_expansion] = STATE(234),
    [sym_command_substitution] = STATE(234),
    [sym_process_substitution] = STATE(234),
    [aux_sym_declaration_command_repeat1] = STATE(625),
    [sym_variable_name] = ACTIONS(421),
    [anon_sym_PIPE] = ACTIONS(685),
    [anon_sym_SEMI_SEMI] = ACTIONS(683),
    [anon_sym_PIPE_AMP] = ACTIONS(683),
    [anon_sym_AMP_AMP] = ACTIONS(683),
    [anon_sym_PIPE_PIPE] = ACTIONS(683),
    [sym__special_characters] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(425),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(683),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(203),
    [sym_word] = ACTIONS(427),
    [anon_sym_SEMI] = ACTIONS(685),
    [anon_sym_LF] = ACTIONS(683),
    [anon_sym_AMP] = ACTIONS(685),
  },
  [494] = {
    [sym_concatenation] = STATE(627),
    [sym_string] = STATE(238),
    [sym_simple_expansion] = STATE(238),
    [sym_string_expansion] = STATE(238),
    [sym_expansion] = STATE(238),
    [sym_command_substitution] = STATE(238),
    [sym_process_substitution] = STATE(238),
    [aux_sym_unset_command_repeat1] = STATE(627),
    [anon_sym_PIPE] = ACTIONS(725),
    [anon_sym_SEMI_SEMI] = ACTIONS(723),
    [anon_sym_PIPE_AMP] = ACTIONS(723),
    [anon_sym_AMP_AMP] = ACTIONS(723),
    [anon_sym_PIPE_PIPE] = ACTIONS(723),
    [sym__special_characters] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(431),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(723),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(227),
    [sym_word] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(725),
    [anon_sym_LF] = ACTIONS(723),
    [anon_sym_AMP] = ACTIONS(725),
  },
  [495] = {
    [anon_sym_RPAREN] = ACTIONS(1958),
    [sym_comment] = ACTIONS(53),
  },
  [496] = {
    [sym_for_statement] = STATE(512),
    [sym_c_style_for_statement] = STATE(512),
    [sym_while_statement] = STATE(512),
    [sym_if_statement] = STATE(512),
    [sym_case_statement] = STATE(512),
    [sym_function_definition] = STATE(512),
    [sym_subshell] = STATE(512),
    [sym_pipeline] = STATE(512),
    [sym_list] = STATE(512),
    [sym_negated_command] = STATE(512),
    [sym_test_command] = STATE(512),
    [sym_declaration_command] = STATE(512),
    [sym_unset_command] = STATE(512),
    [sym_command] = STATE(512),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(972),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [497] = {
    [sym_file_descriptor] = ACTIONS(899),
    [sym_variable_name] = ACTIONS(899),
    [anon_sym_for] = ACTIONS(903),
    [anon_sym_while] = ACTIONS(903),
    [anon_sym_if] = ACTIONS(903),
    [anon_sym_case] = ACTIONS(903),
    [anon_sym_function] = ACTIONS(903),
    [anon_sym_LPAREN] = ACTIONS(899),
    [anon_sym_BANG] = ACTIONS(903),
    [anon_sym_LBRACK] = ACTIONS(903),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(899),
    [anon_sym_declare] = ACTIONS(903),
    [anon_sym_typeset] = ACTIONS(903),
    [anon_sym_export] = ACTIONS(903),
    [anon_sym_readonly] = ACTIONS(903),
    [anon_sym_local] = ACTIONS(903),
    [anon_sym_unset] = ACTIONS(903),
    [anon_sym_unsetenv] = ACTIONS(903),
    [anon_sym_LT] = ACTIONS(903),
    [anon_sym_GT] = ACTIONS(903),
    [anon_sym_GT_GT] = ACTIONS(899),
    [anon_sym_AMP_GT] = ACTIONS(903),
    [anon_sym_AMP_GT_GT] = ACTIONS(899),
    [anon_sym_LT_AMP] = ACTIONS(899),
    [anon_sym_GT_AMP] = ACTIONS(899),
    [sym__special_characters] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(903),
    [sym_raw_string] = ACTIONS(899),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(899),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(899),
    [anon_sym_BQUOTE] = ACTIONS(1948),
    [anon_sym_LT_LPAREN] = ACTIONS(899),
    [anon_sym_GT_LPAREN] = ACTIONS(899),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(903),
  },
  [498] = {
    [sym_for_statement] = STATE(973),
    [sym_c_style_for_statement] = STATE(973),
    [sym_while_statement] = STATE(973),
    [sym_if_statement] = STATE(973),
    [sym_case_statement] = STATE(973),
    [sym_function_definition] = STATE(973),
    [sym_subshell] = STATE(973),
    [sym_pipeline] = STATE(973),
    [sym_list] = STATE(973),
    [sym_negated_command] = STATE(973),
    [sym_test_command] = STATE(973),
    [sym_declaration_command] = STATE(973),
    [sym_unset_command] = STATE(973),
    [sym_command] = STATE(973),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(974),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [499] = {
    [anon_sym_LT] = ACTIONS(1960),
    [anon_sym_GT] = ACTIONS(1960),
    [anon_sym_GT_GT] = ACTIONS(1962),
    [anon_sym_AMP_GT] = ACTIONS(1960),
    [anon_sym_AMP_GT_GT] = ACTIONS(1962),
    [anon_sym_LT_AMP] = ACTIONS(1962),
    [anon_sym_GT_AMP] = ACTIONS(1962),
    [sym_comment] = ACTIONS(53),
  },
  [500] = {
    [sym_concatenation] = STATE(526),
    [sym_string] = STATE(977),
    [sym_simple_expansion] = STATE(977),
    [sym_string_expansion] = STATE(977),
    [sym_expansion] = STATE(977),
    [sym_command_substitution] = STATE(977),
    [sym_process_substitution] = STATE(977),
    [sym__special_characters] = ACTIONS(1964),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1966),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1966),
  },
  [501] = {
    [sym_concatenation] = STATE(530),
    [sym_string] = STATE(979),
    [sym_simple_expansion] = STATE(979),
    [sym_string_expansion] = STATE(979),
    [sym_expansion] = STATE(979),
    [sym_command_substitution] = STATE(979),
    [sym_process_substitution] = STATE(979),
    [sym__special_characters] = ACTIONS(1968),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1970),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1970),
  },
  [502] = {
    [sym_file_redirect] = STATE(980),
    [sym_heredoc_redirect] = STATE(980),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(980),
    [aux_sym_while_statement_repeat1] = STATE(980),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(883),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_LT] = ACTIONS(885),
    [anon_sym_GT] = ACTIONS(885),
    [anon_sym_GT_GT] = ACTIONS(887),
    [anon_sym_AMP_GT] = ACTIONS(885),
    [anon_sym_AMP_GT_GT] = ACTIONS(887),
    [anon_sym_LT_AMP] = ACTIONS(887),
    [anon_sym_GT_AMP] = ACTIONS(887),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(889),
    [anon_sym_BQUOTE] = ACTIONS(955),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [503] = {
    [sym_file_redirect] = STATE(981),
    [sym_heredoc_redirect] = STATE(981),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(981),
    [sym_concatenation] = STATE(645),
    [sym_string] = STATE(252),
    [sym_simple_expansion] = STATE(252),
    [sym_string_expansion] = STATE(252),
    [sym_expansion] = STATE(252),
    [sym_command_substitution] = STATE(252),
    [sym_process_substitution] = STATE(252),
    [aux_sym_while_statement_repeat1] = STATE(981),
    [aux_sym_command_repeat2] = STATE(645),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(883),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_EQ_TILDE] = ACTIONS(451),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(885),
    [anon_sym_GT] = ACTIONS(885),
    [anon_sym_GT_GT] = ACTIONS(887),
    [anon_sym_AMP_GT] = ACTIONS(885),
    [anon_sym_AMP_GT_GT] = ACTIONS(887),
    [anon_sym_LT_AMP] = ACTIONS(887),
    [anon_sym_GT_AMP] = ACTIONS(887),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(889),
    [sym__special_characters] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(461),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(955),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [504] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1972),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(1948),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1974),
    [anon_sym_LF] = ACTIONS(1972),
    [anon_sym_AMP] = ACTIONS(1974),
  },
  [505] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(1972),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(1948),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1974),
    [anon_sym_LF] = ACTIONS(1972),
    [anon_sym_AMP] = ACTIONS(1974),
  },
  [506] = {
    [sym_file_redirect] = STATE(981),
    [sym_heredoc_redirect] = STATE(981),
    [sym_heredoc_body] = STATE(531),
    [sym_herestring_redirect] = STATE(981),
    [sym_concatenation] = STATE(983),
    [sym_string] = STATE(252),
    [sym_simple_expansion] = STATE(252),
    [sym_string_expansion] = STATE(252),
    [sym_expansion] = STATE(252),
    [sym_command_substitution] = STATE(252),
    [sym_process_substitution] = STATE(252),
    [aux_sym_while_statement_repeat1] = STATE(981),
    [aux_sym_command_repeat2] = STATE(983),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(883),
    [anon_sym_PIPE] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [anon_sym_EQ_TILDE] = ACTIONS(451),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(885),
    [anon_sym_GT] = ACTIONS(885),
    [anon_sym_GT_GT] = ACTIONS(887),
    [anon_sym_AMP_GT] = ACTIONS(885),
    [anon_sym_AMP_GT_GT] = ACTIONS(887),
    [anon_sym_LT_AMP] = ACTIONS(887),
    [anon_sym_GT_AMP] = ACTIONS(887),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(889),
    [sym__special_characters] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(461),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(955),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(957),
    [anon_sym_LF] = ACTIONS(955),
    [anon_sym_AMP] = ACTIONS(957),
  },
  [507] = {
    [sym__simple_heredoc_body] = ACTIONS(1976),
    [sym__heredoc_body_beginning] = ACTIONS(1976),
    [sym_file_descriptor] = ACTIONS(1976),
    [sym__concat] = ACTIONS(1976),
    [ts_builtin_sym_end] = ACTIONS(1976),
    [anon_sym_PIPE] = ACTIONS(1978),
    [anon_sym_RPAREN] = ACTIONS(1976),
    [anon_sym_SEMI_SEMI] = ACTIONS(1976),
    [anon_sym_PIPE_AMP] = ACTIONS(1976),
    [anon_sym_AMP_AMP] = ACTIONS(1976),
    [anon_sym_PIPE_PIPE] = ACTIONS(1976),
    [anon_sym_EQ_TILDE] = ACTIONS(1978),
    [anon_sym_EQ_EQ] = ACTIONS(1978),
    [anon_sym_LT] = ACTIONS(1978),
    [anon_sym_GT] = ACTIONS(1978),
    [anon_sym_GT_GT] = ACTIONS(1976),
    [anon_sym_AMP_GT] = ACTIONS(1978),
    [anon_sym_AMP_GT_GT] = ACTIONS(1976),
    [anon_sym_LT_AMP] = ACTIONS(1976),
    [anon_sym_GT_AMP] = ACTIONS(1976),
    [anon_sym_LT_LT] = ACTIONS(1978),
    [anon_sym_LT_LT_DASH] = ACTIONS(1976),
    [anon_sym_LT_LT_LT] = ACTIONS(1976),
    [sym__special_characters] = ACTIONS(1976),
    [anon_sym_DQUOTE] = ACTIONS(1976),
    [anon_sym_DOLLAR] = ACTIONS(1978),
    [sym_raw_string] = ACTIONS(1976),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1976),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1976),
    [anon_sym_BQUOTE] = ACTIONS(1976),
    [anon_sym_LT_LPAREN] = ACTIONS(1976),
    [anon_sym_GT_LPAREN] = ACTIONS(1976),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1978),
    [anon_sym_SEMI] = ACTIONS(1978),
    [anon_sym_LF] = ACTIONS(1976),
    [anon_sym_AMP] = ACTIONS(1978),
  },
  [508] = {
    [sym_file_descriptor] = ACTIONS(899),
    [sym_variable_name] = ACTIONS(899),
    [anon_sym_for] = ACTIONS(903),
    [anon_sym_while] = ACTIONS(903),
    [anon_sym_if] = ACTIONS(903),
    [anon_sym_case] = ACTIONS(903),
    [anon_sym_RPAREN] = ACTIONS(1980),
    [anon_sym_function] = ACTIONS(903),
    [anon_sym_LPAREN] = ACTIONS(899),
    [anon_sym_BANG] = ACTIONS(903),
    [anon_sym_LBRACK] = ACTIONS(903),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(899),
    [anon_sym_declare] = ACTIONS(903),
    [anon_sym_typeset] = ACTIONS(903),
    [anon_sym_export] = ACTIONS(903),
    [anon_sym_readonly] = ACTIONS(903),
    [anon_sym_local] = ACTIONS(903),
    [anon_sym_unset] = ACTIONS(903),
    [anon_sym_unsetenv] = ACTIONS(903),
    [anon_sym_LT] = ACTIONS(903),
    [anon_sym_GT] = ACTIONS(903),
    [anon_sym_GT_GT] = ACTIONS(899),
    [anon_sym_AMP_GT] = ACTIONS(903),
    [anon_sym_AMP_GT_GT] = ACTIONS(899),
    [anon_sym_LT_AMP] = ACTIONS(899),
    [anon_sym_GT_AMP] = ACTIONS(899),
    [sym__special_characters] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(903),
    [sym_raw_string] = ACTIONS(899),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(899),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(899),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_LT_LPAREN] = ACTIONS(899),
    [anon_sym_GT_LPAREN] = ACTIONS(899),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(903),
  },
  [509] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1980),
    [anon_sym_SEMI_SEMI] = ACTIONS(1982),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1984),
    [anon_sym_LF] = ACTIONS(1982),
    [anon_sym_AMP] = ACTIONS(1984),
  },
  [510] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(1980),
    [anon_sym_SEMI_SEMI] = ACTIONS(1982),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1984),
    [anon_sym_LF] = ACTIONS(1982),
    [anon_sym_AMP] = ACTIONS(1984),
  },
  [511] = {
    [sym_compound_statement] = STATE(986),
    [anon_sym_LBRACE] = ACTIONS(507),
    [sym_comment] = ACTIONS(53),
  },
  [512] = {
    [ts_builtin_sym_end] = ACTIONS(1986),
    [anon_sym_esac] = ACTIONS(1986),
    [anon_sym_PIPE] = ACTIONS(1988),
    [anon_sym_RPAREN] = ACTIONS(1986),
    [anon_sym_SEMI_SEMI] = ACTIONS(1986),
    [anon_sym_PIPE_AMP] = ACTIONS(1986),
    [anon_sym_AMP_AMP] = ACTIONS(1986),
    [anon_sym_PIPE_PIPE] = ACTIONS(1986),
    [anon_sym_BQUOTE] = ACTIONS(1986),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1988),
    [anon_sym_LF] = ACTIONS(1986),
    [anon_sym_AMP] = ACTIONS(1988),
  },
  [513] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [ts_builtin_sym_end] = ACTIONS(1986),
    [anon_sym_PIPE] = ACTIONS(1988),
    [anon_sym_RPAREN] = ACTIONS(1986),
    [anon_sym_SEMI_SEMI] = ACTIONS(1986),
    [anon_sym_PIPE_AMP] = ACTIONS(1986),
    [anon_sym_AMP_AMP] = ACTIONS(1986),
    [anon_sym_PIPE_PIPE] = ACTIONS(1986),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1988),
    [anon_sym_LF] = ACTIONS(1986),
    [anon_sym_AMP] = ACTIONS(1988),
  },
  [514] = {
    [ts_builtin_sym_end] = ACTIONS(1990),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_SEMI_SEMI] = ACTIONS(1990),
    [anon_sym_PIPE_AMP] = ACTIONS(315),
    [anon_sym_AMP_AMP] = ACTIONS(1990),
    [anon_sym_PIPE_PIPE] = ACTIONS(1990),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1992),
    [anon_sym_LF] = ACTIONS(1990),
    [anon_sym_AMP] = ACTIONS(1992),
  },
  [515] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [ts_builtin_sym_end] = ACTIONS(1990),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_SEMI_SEMI] = ACTIONS(1990),
    [anon_sym_PIPE_AMP] = ACTIONS(315),
    [anon_sym_AMP_AMP] = ACTIONS(1990),
    [anon_sym_PIPE_PIPE] = ACTIONS(1990),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1992),
    [anon_sym_LF] = ACTIONS(1990),
    [anon_sym_AMP] = ACTIONS(1992),
  },
  [516] = {
    [ts_builtin_sym_end] = ACTIONS(1994),
    [anon_sym_esac] = ACTIONS(1994),
    [anon_sym_PIPE] = ACTIONS(1996),
    [anon_sym_RPAREN] = ACTIONS(1994),
    [anon_sym_SEMI_SEMI] = ACTIONS(1994),
    [anon_sym_PIPE_AMP] = ACTIONS(1994),
    [anon_sym_AMP_AMP] = ACTIONS(1994),
    [anon_sym_PIPE_PIPE] = ACTIONS(1994),
    [anon_sym_BQUOTE] = ACTIONS(1994),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1996),
    [anon_sym_LF] = ACTIONS(1994),
    [anon_sym_AMP] = ACTIONS(1996),
  },
  [517] = {
    [anon_sym_DOLLAR] = ACTIONS(1998),
    [anon_sym_POUND] = ACTIONS(1998),
    [anon_sym_DASH] = ACTIONS(1998),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2000),
    [anon_sym_STAR] = ACTIONS(1998),
    [anon_sym_AT] = ACTIONS(1998),
    [anon_sym_QMARK] = ACTIONS(1998),
    [anon_sym_0] = ACTIONS(2002),
    [anon_sym__] = ACTIONS(2002),
  },
  [518] = {
    [sym_subscript] = STATE(993),
    [sym_variable_name] = ACTIONS(2004),
    [anon_sym_BANG] = ACTIONS(2006),
    [anon_sym_DOLLAR] = ACTIONS(2008),
    [anon_sym_POUND] = ACTIONS(2006),
    [anon_sym_DASH] = ACTIONS(2008),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2010),
    [anon_sym_STAR] = ACTIONS(2008),
    [anon_sym_AT] = ACTIONS(2008),
    [anon_sym_QMARK] = ACTIONS(2008),
    [anon_sym_0] = ACTIONS(2012),
    [anon_sym__] = ACTIONS(2012),
  },
  [519] = {
    [sym_simple_expansion] = STATE(995),
    [sym_expansion] = STATE(995),
    [aux_sym_heredoc_body_repeat1] = STATE(995),
    [sym__heredoc_body_middle] = ACTIONS(2014),
    [sym__heredoc_body_end] = ACTIONS(2016),
    [anon_sym_DOLLAR] = ACTIONS(913),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(915),
    [sym_comment] = ACTIONS(53),
  },
  [520] = {
    [sym_concatenation] = STATE(998),
    [sym_string] = STATE(997),
    [sym_simple_expansion] = STATE(997),
    [sym_string_expansion] = STATE(997),
    [sym_expansion] = STATE(997),
    [sym_command_substitution] = STATE(997),
    [sym_process_substitution] = STATE(997),
    [sym__special_characters] = ACTIONS(2018),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(2020),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2020),
  },
  [521] = {
    [aux_sym_concatenation_repeat1] = STATE(141),
    [sym__simple_heredoc_body] = ACTIONS(2022),
    [sym__heredoc_body_beginning] = ACTIONS(2022),
    [sym_file_descriptor] = ACTIONS(2022),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(2022),
    [anon_sym_PIPE] = ACTIONS(2024),
    [anon_sym_SEMI_SEMI] = ACTIONS(2022),
    [anon_sym_PIPE_AMP] = ACTIONS(2022),
    [anon_sym_AMP_AMP] = ACTIONS(2022),
    [anon_sym_PIPE_PIPE] = ACTIONS(2022),
    [anon_sym_EQ_TILDE] = ACTIONS(2024),
    [anon_sym_EQ_EQ] = ACTIONS(2024),
    [anon_sym_LT] = ACTIONS(2024),
    [anon_sym_GT] = ACTIONS(2024),
    [anon_sym_GT_GT] = ACTIONS(2022),
    [anon_sym_AMP_GT] = ACTIONS(2024),
    [anon_sym_AMP_GT_GT] = ACTIONS(2022),
    [anon_sym_LT_AMP] = ACTIONS(2022),
    [anon_sym_GT_AMP] = ACTIONS(2022),
    [anon_sym_LT_LT] = ACTIONS(2024),
    [anon_sym_LT_LT_DASH] = ACTIONS(2022),
    [anon_sym_LT_LT_LT] = ACTIONS(2022),
    [sym__special_characters] = ACTIONS(2022),
    [anon_sym_DQUOTE] = ACTIONS(2022),
    [anon_sym_DOLLAR] = ACTIONS(2024),
    [sym_raw_string] = ACTIONS(2022),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2022),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2022),
    [anon_sym_BQUOTE] = ACTIONS(2022),
    [anon_sym_LT_LPAREN] = ACTIONS(2022),
    [anon_sym_GT_LPAREN] = ACTIONS(2022),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2024),
    [anon_sym_SEMI] = ACTIONS(2024),
    [anon_sym_LF] = ACTIONS(2022),
    [anon_sym_AMP] = ACTIONS(2024),
  },
  [522] = {
    [aux_sym_concatenation_repeat1] = STATE(141),
    [sym__simple_heredoc_body] = ACTIONS(2026),
    [sym__heredoc_body_beginning] = ACTIONS(2026),
    [sym_file_descriptor] = ACTIONS(2026),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(2026),
    [anon_sym_PIPE] = ACTIONS(2028),
    [anon_sym_SEMI_SEMI] = ACTIONS(2026),
    [anon_sym_PIPE_AMP] = ACTIONS(2026),
    [anon_sym_AMP_AMP] = ACTIONS(2026),
    [anon_sym_PIPE_PIPE] = ACTIONS(2026),
    [anon_sym_EQ_TILDE] = ACTIONS(2028),
    [anon_sym_EQ_EQ] = ACTIONS(2028),
    [anon_sym_LT] = ACTIONS(2028),
    [anon_sym_GT] = ACTIONS(2028),
    [anon_sym_GT_GT] = ACTIONS(2026),
    [anon_sym_AMP_GT] = ACTIONS(2028),
    [anon_sym_AMP_GT_GT] = ACTIONS(2026),
    [anon_sym_LT_AMP] = ACTIONS(2026),
    [anon_sym_GT_AMP] = ACTIONS(2026),
    [anon_sym_LT_LT] = ACTIONS(2028),
    [anon_sym_LT_LT_DASH] = ACTIONS(2026),
    [anon_sym_LT_LT_LT] = ACTIONS(2026),
    [sym__special_characters] = ACTIONS(2026),
    [anon_sym_DQUOTE] = ACTIONS(2026),
    [anon_sym_DOLLAR] = ACTIONS(2028),
    [sym_raw_string] = ACTIONS(2026),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2026),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2026),
    [anon_sym_BQUOTE] = ACTIONS(2026),
    [anon_sym_LT_LPAREN] = ACTIONS(2026),
    [anon_sym_GT_LPAREN] = ACTIONS(2026),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2028),
    [anon_sym_SEMI] = ACTIONS(2028),
    [anon_sym_LF] = ACTIONS(2026),
    [anon_sym_AMP] = ACTIONS(2028),
  },
  [523] = {
    [sym__simple_heredoc_body] = ACTIONS(2026),
    [sym__heredoc_body_beginning] = ACTIONS(2026),
    [sym_file_descriptor] = ACTIONS(2026),
    [ts_builtin_sym_end] = ACTIONS(2026),
    [anon_sym_PIPE] = ACTIONS(2028),
    [anon_sym_RPAREN] = ACTIONS(2026),
    [anon_sym_SEMI_SEMI] = ACTIONS(2026),
    [anon_sym_PIPE_AMP] = ACTIONS(2026),
    [anon_sym_AMP_AMP] = ACTIONS(2026),
    [anon_sym_PIPE_PIPE] = ACTIONS(2026),
    [anon_sym_EQ_TILDE] = ACTIONS(2028),
    [anon_sym_EQ_EQ] = ACTIONS(2028),
    [anon_sym_LT] = ACTIONS(2028),
    [anon_sym_GT] = ACTIONS(2028),
    [anon_sym_GT_GT] = ACTIONS(2026),
    [anon_sym_AMP_GT] = ACTIONS(2028),
    [anon_sym_AMP_GT_GT] = ACTIONS(2026),
    [anon_sym_LT_AMP] = ACTIONS(2026),
    [anon_sym_GT_AMP] = ACTIONS(2026),
    [anon_sym_LT_LT] = ACTIONS(2028),
    [anon_sym_LT_LT_DASH] = ACTIONS(2026),
    [anon_sym_LT_LT_LT] = ACTIONS(2026),
    [sym__special_characters] = ACTIONS(2026),
    [anon_sym_DQUOTE] = ACTIONS(2026),
    [anon_sym_DOLLAR] = ACTIONS(2028),
    [sym_raw_string] = ACTIONS(2026),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2026),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2026),
    [anon_sym_BQUOTE] = ACTIONS(2026),
    [anon_sym_LT_LPAREN] = ACTIONS(2026),
    [anon_sym_GT_LPAREN] = ACTIONS(2026),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2028),
    [anon_sym_SEMI] = ACTIONS(2028),
    [anon_sym_LF] = ACTIONS(2026),
    [anon_sym_AMP] = ACTIONS(2028),
  },
  [524] = {
    [aux_sym_concatenation_repeat1] = STATE(999),
    [sym__simple_heredoc_body] = ACTIONS(727),
    [sym__heredoc_body_beginning] = ACTIONS(727),
    [sym_file_descriptor] = ACTIONS(727),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(727),
    [anon_sym_PIPE] = ACTIONS(731),
    [anon_sym_SEMI_SEMI] = ACTIONS(727),
    [anon_sym_PIPE_AMP] = ACTIONS(727),
    [anon_sym_AMP_AMP] = ACTIONS(727),
    [anon_sym_PIPE_PIPE] = ACTIONS(727),
    [anon_sym_LT] = ACTIONS(731),
    [anon_sym_GT] = ACTIONS(731),
    [anon_sym_GT_GT] = ACTIONS(727),
    [anon_sym_AMP_GT] = ACTIONS(731),
    [anon_sym_AMP_GT_GT] = ACTIONS(727),
    [anon_sym_LT_AMP] = ACTIONS(727),
    [anon_sym_GT_AMP] = ACTIONS(727),
    [anon_sym_LT_LT] = ACTIONS(731),
    [anon_sym_LT_LT_DASH] = ACTIONS(727),
    [anon_sym_LT_LT_LT] = ACTIONS(727),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(731),
    [anon_sym_LF] = ACTIONS(727),
    [anon_sym_AMP] = ACTIONS(731),
  },
  [525] = {
    [aux_sym_concatenation_repeat1] = STATE(999),
    [sym__simple_heredoc_body] = ACTIONS(745),
    [sym__heredoc_body_beginning] = ACTIONS(745),
    [sym_file_descriptor] = ACTIONS(745),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(745),
    [anon_sym_PIPE] = ACTIONS(747),
    [anon_sym_SEMI_SEMI] = ACTIONS(745),
    [anon_sym_PIPE_AMP] = ACTIONS(745),
    [anon_sym_AMP_AMP] = ACTIONS(745),
    [anon_sym_PIPE_PIPE] = ACTIONS(745),
    [anon_sym_LT] = ACTIONS(747),
    [anon_sym_GT] = ACTIONS(747),
    [anon_sym_GT_GT] = ACTIONS(745),
    [anon_sym_AMP_GT] = ACTIONS(747),
    [anon_sym_AMP_GT_GT] = ACTIONS(745),
    [anon_sym_LT_AMP] = ACTIONS(745),
    [anon_sym_GT_AMP] = ACTIONS(745),
    [anon_sym_LT_LT] = ACTIONS(747),
    [anon_sym_LT_LT_DASH] = ACTIONS(745),
    [anon_sym_LT_LT_LT] = ACTIONS(745),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(747),
    [anon_sym_LF] = ACTIONS(745),
    [anon_sym_AMP] = ACTIONS(747),
  },
  [526] = {
    [sym__simple_heredoc_body] = ACTIONS(745),
    [sym__heredoc_body_beginning] = ACTIONS(745),
    [sym_file_descriptor] = ACTIONS(745),
    [ts_builtin_sym_end] = ACTIONS(745),
    [anon_sym_esac] = ACTIONS(745),
    [anon_sym_PIPE] = ACTIONS(747),
    [anon_sym_RPAREN] = ACTIONS(745),
    [anon_sym_SEMI_SEMI] = ACTIONS(745),
    [anon_sym_PIPE_AMP] = ACTIONS(745),
    [anon_sym_AMP_AMP] = ACTIONS(745),
    [anon_sym_PIPE_PIPE] = ACTIONS(745),
    [anon_sym_LT] = ACTIONS(747),
    [anon_sym_GT] = ACTIONS(747),
    [anon_sym_GT_GT] = ACTIONS(745),
    [anon_sym_AMP_GT] = ACTIONS(747),
    [anon_sym_AMP_GT_GT] = ACTIONS(745),
    [anon_sym_LT_AMP] = ACTIONS(745),
    [anon_sym_GT_AMP] = ACTIONS(745),
    [anon_sym_LT_LT] = ACTIONS(747),
    [anon_sym_LT_LT_DASH] = ACTIONS(745),
    [anon_sym_LT_LT_LT] = ACTIONS(745),
    [anon_sym_BQUOTE] = ACTIONS(745),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(747),
    [anon_sym_LF] = ACTIONS(745),
    [anon_sym_AMP] = ACTIONS(747),
  },
  [527] = {
    [sym__simple_heredoc_body] = ACTIONS(2030),
    [sym__heredoc_body_beginning] = ACTIONS(2030),
    [sym_file_descriptor] = ACTIONS(2030),
    [ts_builtin_sym_end] = ACTIONS(2030),
    [anon_sym_esac] = ACTIONS(2030),
    [anon_sym_PIPE] = ACTIONS(2032),
    [anon_sym_RPAREN] = ACTIONS(2030),
    [anon_sym_SEMI_SEMI] = ACTIONS(2030),
    [anon_sym_PIPE_AMP] = ACTIONS(2030),
    [anon_sym_AMP_AMP] = ACTIONS(2030),
    [anon_sym_PIPE_PIPE] = ACTIONS(2030),
    [anon_sym_LT] = ACTIONS(2032),
    [anon_sym_GT] = ACTIONS(2032),
    [anon_sym_GT_GT] = ACTIONS(2030),
    [anon_sym_AMP_GT] = ACTIONS(2032),
    [anon_sym_AMP_GT_GT] = ACTIONS(2030),
    [anon_sym_LT_AMP] = ACTIONS(2030),
    [anon_sym_GT_AMP] = ACTIONS(2030),
    [anon_sym_LT_LT] = ACTIONS(2032),
    [anon_sym_LT_LT_DASH] = ACTIONS(2030),
    [anon_sym_LT_LT_LT] = ACTIONS(2030),
    [anon_sym_BQUOTE] = ACTIONS(2030),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2032),
    [anon_sym_LF] = ACTIONS(2030),
    [anon_sym_AMP] = ACTIONS(2032),
  },
  [528] = {
    [aux_sym_concatenation_repeat1] = STATE(999),
    [sym__simple_heredoc_body] = ACTIONS(2034),
    [sym__heredoc_body_beginning] = ACTIONS(2034),
    [sym_file_descriptor] = ACTIONS(2034),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(2034),
    [anon_sym_PIPE] = ACTIONS(2036),
    [anon_sym_SEMI_SEMI] = ACTIONS(2034),
    [anon_sym_PIPE_AMP] = ACTIONS(2034),
    [anon_sym_AMP_AMP] = ACTIONS(2034),
    [anon_sym_PIPE_PIPE] = ACTIONS(2034),
    [anon_sym_LT] = ACTIONS(2036),
    [anon_sym_GT] = ACTIONS(2036),
    [anon_sym_GT_GT] = ACTIONS(2034),
    [anon_sym_AMP_GT] = ACTIONS(2036),
    [anon_sym_AMP_GT_GT] = ACTIONS(2034),
    [anon_sym_LT_AMP] = ACTIONS(2034),
    [anon_sym_GT_AMP] = ACTIONS(2034),
    [anon_sym_LT_LT] = ACTIONS(2036),
    [anon_sym_LT_LT_DASH] = ACTIONS(2034),
    [anon_sym_LT_LT_LT] = ACTIONS(2034),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2036),
    [anon_sym_LF] = ACTIONS(2034),
    [anon_sym_AMP] = ACTIONS(2036),
  },
  [529] = {
    [aux_sym_concatenation_repeat1] = STATE(999),
    [sym__simple_heredoc_body] = ACTIONS(2038),
    [sym__heredoc_body_beginning] = ACTIONS(2038),
    [sym_file_descriptor] = ACTIONS(2038),
    [sym__concat] = ACTIONS(249),
    [ts_builtin_sym_end] = ACTIONS(2038),
    [anon_sym_PIPE] = ACTIONS(2040),
    [anon_sym_SEMI_SEMI] = ACTIONS(2038),
    [anon_sym_PIPE_AMP] = ACTIONS(2038),
    [anon_sym_AMP_AMP] = ACTIONS(2038),
    [anon_sym_PIPE_PIPE] = ACTIONS(2038),
    [anon_sym_LT] = ACTIONS(2040),
    [anon_sym_GT] = ACTIONS(2040),
    [anon_sym_GT_GT] = ACTIONS(2038),
    [anon_sym_AMP_GT] = ACTIONS(2040),
    [anon_sym_AMP_GT_GT] = ACTIONS(2038),
    [anon_sym_LT_AMP] = ACTIONS(2038),
    [anon_sym_GT_AMP] = ACTIONS(2038),
    [anon_sym_LT_LT] = ACTIONS(2040),
    [anon_sym_LT_LT_DASH] = ACTIONS(2038),
    [anon_sym_LT_LT_LT] = ACTIONS(2038),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2040),
    [anon_sym_LF] = ACTIONS(2038),
    [anon_sym_AMP] = ACTIONS(2040),
  },
  [530] = {
    [sym__simple_heredoc_body] = ACTIONS(2038),
    [sym__heredoc_body_beginning] = ACTIONS(2038),
    [sym_file_descriptor] = ACTIONS(2038),
    [ts_builtin_sym_end] = ACTIONS(2038),
    [anon_sym_esac] = ACTIONS(2038),
    [anon_sym_PIPE] = ACTIONS(2040),
    [anon_sym_RPAREN] = ACTIONS(2038),
    [anon_sym_SEMI_SEMI] = ACTIONS(2038),
    [anon_sym_PIPE_AMP] = ACTIONS(2038),
    [anon_sym_AMP_AMP] = ACTIONS(2038),
    [anon_sym_PIPE_PIPE] = ACTIONS(2038),
    [anon_sym_LT] = ACTIONS(2040),
    [anon_sym_GT] = ACTIONS(2040),
    [anon_sym_GT_GT] = ACTIONS(2038),
    [anon_sym_AMP_GT] = ACTIONS(2040),
    [anon_sym_AMP_GT_GT] = ACTIONS(2038),
    [anon_sym_LT_AMP] = ACTIONS(2038),
    [anon_sym_GT_AMP] = ACTIONS(2038),
    [anon_sym_LT_LT] = ACTIONS(2040),
    [anon_sym_LT_LT_DASH] = ACTIONS(2038),
    [anon_sym_LT_LT_LT] = ACTIONS(2038),
    [anon_sym_BQUOTE] = ACTIONS(2038),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2040),
    [anon_sym_LF] = ACTIONS(2038),
    [anon_sym_AMP] = ACTIONS(2040),
  },
  [531] = {
    [ts_builtin_sym_end] = ACTIONS(2042),
    [anon_sym_esac] = ACTIONS(2042),
    [anon_sym_PIPE] = ACTIONS(2044),
    [anon_sym_RPAREN] = ACTIONS(2042),
    [anon_sym_SEMI_SEMI] = ACTIONS(2042),
    [anon_sym_PIPE_AMP] = ACTIONS(2042),
    [anon_sym_AMP_AMP] = ACTIONS(2042),
    [anon_sym_PIPE_PIPE] = ACTIONS(2042),
    [anon_sym_BQUOTE] = ACTIONS(2042),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2044),
    [anon_sym_LF] = ACTIONS(2042),
    [anon_sym_AMP] = ACTIONS(2044),
  },
  [532] = {
    [sym_file_redirect] = STATE(532),
    [sym_heredoc_redirect] = STATE(532),
    [sym_herestring_redirect] = STATE(532),
    [aux_sym_while_statement_repeat1] = STATE(532),
    [sym__simple_heredoc_body] = ACTIONS(2046),
    [sym__heredoc_body_beginning] = ACTIONS(2046),
    [sym_file_descriptor] = ACTIONS(2048),
    [ts_builtin_sym_end] = ACTIONS(2046),
    [anon_sym_PIPE] = ACTIONS(2051),
    [anon_sym_SEMI_SEMI] = ACTIONS(2046),
    [anon_sym_PIPE_AMP] = ACTIONS(2046),
    [anon_sym_AMP_AMP] = ACTIONS(2046),
    [anon_sym_PIPE_PIPE] = ACTIONS(2046),
    [anon_sym_LT] = ACTIONS(2053),
    [anon_sym_GT] = ACTIONS(2053),
    [anon_sym_GT_GT] = ACTIONS(2056),
    [anon_sym_AMP_GT] = ACTIONS(2053),
    [anon_sym_AMP_GT_GT] = ACTIONS(2056),
    [anon_sym_LT_AMP] = ACTIONS(2056),
    [anon_sym_GT_AMP] = ACTIONS(2056),
    [anon_sym_LT_LT] = ACTIONS(2059),
    [anon_sym_LT_LT_DASH] = ACTIONS(2062),
    [anon_sym_LT_LT_LT] = ACTIONS(2065),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2051),
    [anon_sym_LF] = ACTIONS(2046),
    [anon_sym_AMP] = ACTIONS(2051),
  },
  [533] = {
    [sym_file_redirect] = STATE(532),
    [sym_heredoc_redirect] = STATE(532),
    [sym_heredoc_body] = STATE(1000),
    [sym_herestring_redirect] = STATE(532),
    [aux_sym_while_statement_repeat1] = STATE(532),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(325),
    [ts_builtin_sym_end] = ACTIONS(2042),
    [anon_sym_PIPE] = ACTIONS(2044),
    [anon_sym_SEMI_SEMI] = ACTIONS(2042),
    [anon_sym_PIPE_AMP] = ACTIONS(2042),
    [anon_sym_AMP_AMP] = ACTIONS(2042),
    [anon_sym_PIPE_PIPE] = ACTIONS(2042),
    [anon_sym_LT] = ACTIONS(333),
    [anon_sym_GT] = ACTIONS(333),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(341),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2044),
    [anon_sym_LF] = ACTIONS(2042),
    [anon_sym_AMP] = ACTIONS(2044),
  },
  [534] = {
    [sym_concatenation] = STATE(534),
    [sym_string] = STATE(188),
    [sym_simple_expansion] = STATE(188),
    [sym_string_expansion] = STATE(188),
    [sym_expansion] = STATE(188),
    [sym_command_substitution] = STATE(188),
    [sym_process_substitution] = STATE(188),
    [aux_sym_command_repeat2] = STATE(534),
    [sym__simple_heredoc_body] = ACTIONS(2026),
    [sym__heredoc_body_beginning] = ACTIONS(2026),
    [sym_file_descriptor] = ACTIONS(2026),
    [ts_builtin_sym_end] = ACTIONS(2026),
    [anon_sym_PIPE] = ACTIONS(2028),
    [anon_sym_SEMI_SEMI] = ACTIONS(2026),
    [anon_sym_PIPE_AMP] = ACTIONS(2026),
    [anon_sym_AMP_AMP] = ACTIONS(2026),
    [anon_sym_PIPE_PIPE] = ACTIONS(2026),
    [anon_sym_EQ_TILDE] = ACTIONS(2068),
    [anon_sym_EQ_EQ] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(2028),
    [anon_sym_GT] = ACTIONS(2028),
    [anon_sym_GT_GT] = ACTIONS(2026),
    [anon_sym_AMP_GT] = ACTIONS(2028),
    [anon_sym_AMP_GT_GT] = ACTIONS(2026),
    [anon_sym_LT_AMP] = ACTIONS(2026),
    [anon_sym_GT_AMP] = ACTIONS(2026),
    [anon_sym_LT_LT] = ACTIONS(2028),
    [anon_sym_LT_LT_DASH] = ACTIONS(2026),
    [anon_sym_LT_LT_LT] = ACTIONS(2026),
    [sym__special_characters] = ACTIONS(2071),
    [anon_sym_DQUOTE] = ACTIONS(2074),
    [anon_sym_DOLLAR] = ACTIONS(2077),
    [sym_raw_string] = ACTIONS(2080),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2083),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2086),
    [anon_sym_BQUOTE] = ACTIONS(2089),
    [anon_sym_LT_LPAREN] = ACTIONS(2092),
    [anon_sym_GT_LPAREN] = ACTIONS(2092),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2095),
    [anon_sym_SEMI] = ACTIONS(2028),
    [anon_sym_LF] = ACTIONS(2026),
    [anon_sym_AMP] = ACTIONS(2028),
  },
  [535] = {
    [sym_file_descriptor] = ACTIONS(899),
    [sym_variable_name] = ACTIONS(899),
    [ts_builtin_sym_end] = ACTIONS(2098),
    [anon_sym_for] = ACTIONS(903),
    [anon_sym_while] = ACTIONS(903),
    [anon_sym_if] = ACTIONS(903),
    [anon_sym_case] = ACTIONS(903),
    [anon_sym_function] = ACTIONS(903),
    [anon_sym_LPAREN] = ACTIONS(899),
    [anon_sym_BANG] = ACTIONS(903),
    [anon_sym_LBRACK] = ACTIONS(903),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(899),
    [anon_sym_declare] = ACTIONS(903),
    [anon_sym_typeset] = ACTIONS(903),
    [anon_sym_export] = ACTIONS(903),
    [anon_sym_readonly] = ACTIONS(903),
    [anon_sym_local] = ACTIONS(903),
    [anon_sym_unset] = ACTIONS(903),
    [anon_sym_unsetenv] = ACTIONS(903),
    [anon_sym_LT] = ACTIONS(903),
    [anon_sym_GT] = ACTIONS(903),
    [anon_sym_GT_GT] = ACTIONS(899),
    [anon_sym_AMP_GT] = ACTIONS(903),
    [anon_sym_AMP_GT_GT] = ACTIONS(899),
    [anon_sym_LT_AMP] = ACTIONS(899),
    [anon_sym_GT_AMP] = ACTIONS(899),
    [sym__special_characters] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(903),
    [sym_raw_string] = ACTIONS(899),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(899),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(899),
    [anon_sym_BQUOTE] = ACTIONS(899),
    [anon_sym_LT_LPAREN] = ACTIONS(899),
    [anon_sym_GT_LPAREN] = ACTIONS(899),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(903),
  },
  [536] = {
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(2100),
    [anon_sym_PIPE_AMP] = ACTIONS(443),
    [anon_sym_AMP_AMP] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2102),
    [anon_sym_LF] = ACTIONS(2100),
    [anon_sym_AMP] = ACTIONS(2102),
  },
  [537] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(2100),
    [anon_sym_PIPE_AMP] = ACTIONS(443),
    [anon_sym_AMP_AMP] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(2102),
    [anon_sym_LF] = ACTIONS(2100),
    [anon_sym_AMP] = ACTIONS(2102),
  },
  [538] = {
    [sym_file_redirect] = STATE(1002),
    [sym_heredoc_redirect] = STATE(1002),
    [sym_heredoc_body] = STATE(1000),
    [sym_herestring_redirect] = STATE(1002),
    [sym_concatenation] = STATE(534),
    [sym_string] = STATE(188),
    [sym_simple_expansion] = STATE(188),
    [sym_string_expansion] = STATE(188),
    [sym_expansion] = STATE(188),
    [sym_command_substitution] = STATE(188),
    [sym_process_substitution] = STATE(188),
    [aux_sym_while_statement_repeat1] = STATE(1002),
    [aux_sym_command_repeat2] = STATE(534),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(325),
    [ts_builtin_sym_end] = ACTIONS(2042),
    [anon_sym_PIPE] = ACTIONS(2044),
    [anon_sym_SEMI_SEMI] = ACTIONS(2042),
    [anon_sym_PIPE_AMP] = ACTIONS(2042),
    [anon_sym_AMP_AMP] = ACTIONS(2042),
    [anon_sym_PIPE_PIPE] = ACTIONS(2042),
    [anon_sym_EQ_TILDE] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(331),
    [anon_sym_LT] = ACTIONS(333),
    [anon_sym_GT] = ACTIONS(333),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(341),
    [sym__special_characters] = ACTIONS(343),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(347),
    [anon_sym_SEMI] = ACTIONS(2044),
    [anon_sym_LF] = ACTIONS(2042),
    [anon_sym_AMP] = ACTIONS(2044),
  },
  [539] = {
    [sym_string] = STATE(732),
    [sym_simple_expansion] = STATE(732),
    [sym_string_expansion] = STATE(732),
    [sym_expansion] = STATE(732),
    [sym_command_substitution] = STATE(732),
    [sym_process_substitution] = STATE(732),
    [anon_sym_RBRACK] = ACTIONS(2104),
    [sym__special_characters] = ACTIONS(2106),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(1353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1353),
  },
  [540] = {
    [sym__concat] = ACTIONS(2108),
    [anon_sym_EQ] = ACTIONS(2110),
    [anon_sym_PLUS_EQ] = ACTIONS(2110),
    [sym_comment] = ACTIONS(53),
  },
  [541] = {
    [aux_sym_concatenation_repeat1] = STATE(1005),
    [sym__concat] = ACTIONS(575),
    [anon_sym_RBRACK] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
  },
  [542] = {
    [sym_string] = STATE(732),
    [sym_simple_expansion] = STATE(732),
    [sym_string_expansion] = STATE(732),
    [sym_expansion] = STATE(732),
    [sym_command_substitution] = STATE(732),
    [sym_process_substitution] = STATE(732),
    [anon_sym_RBRACK] = ACTIONS(2112),
    [sym__special_characters] = ACTIONS(2106),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(1353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1353),
  },
  [543] = {
    [sym__concat] = ACTIONS(2114),
    [anon_sym_EQ] = ACTIONS(2116),
    [anon_sym_PLUS_EQ] = ACTIONS(2116),
    [sym_comment] = ACTIONS(53),
  },
  [544] = {
    [anon_sym_RBRACK] = ACTIONS(2112),
    [sym_comment] = ACTIONS(53),
  },
  [545] = {
    [sym_file_descriptor] = ACTIONS(2118),
    [sym_variable_name] = ACTIONS(2118),
    [ts_builtin_sym_end] = ACTIONS(2118),
    [anon_sym_PIPE] = ACTIONS(2120),
    [anon_sym_RPAREN] = ACTIONS(2118),
    [anon_sym_SEMI_SEMI] = ACTIONS(2118),
    [anon_sym_PIPE_AMP] = ACTIONS(2118),
    [anon_sym_AMP_AMP] = ACTIONS(2118),
    [anon_sym_PIPE_PIPE] = ACTIONS(2118),
    [anon_sym_LT] = ACTIONS(2120),
    [anon_sym_GT] = ACTIONS(2120),
    [anon_sym_GT_GT] = ACTIONS(2118),
    [anon_sym_AMP_GT] = ACTIONS(2120),
    [anon_sym_AMP_GT_GT] = ACTIONS(2118),
    [anon_sym_LT_AMP] = ACTIONS(2118),
    [anon_sym_GT_AMP] = ACTIONS(2118),
    [sym__special_characters] = ACTIONS(2118),
    [anon_sym_DQUOTE] = ACTIONS(2118),
    [anon_sym_DOLLAR] = ACTIONS(2120),
    [sym_raw_string] = ACTIONS(2118),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2118),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2118),
    [anon_sym_BQUOTE] = ACTIONS(2118),
    [anon_sym_LT_LPAREN] = ACTIONS(2118),
    [anon_sym_GT_LPAREN] = ACTIONS(2118),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2120),
    [anon_sym_SEMI] = ACTIONS(2120),
    [anon_sym_LF] = ACTIONS(2118),
    [anon_sym_AMP] = ACTIONS(2120),
  },
  [546] = {
    [aux_sym_concatenation_repeat1] = STATE(1009),
    [sym__concat] = ACTIONS(2122),
    [anon_sym_RPAREN] = ACTIONS(2124),
    [sym__special_characters] = ACTIONS(2124),
    [anon_sym_DQUOTE] = ACTIONS(2124),
    [anon_sym_DOLLAR] = ACTIONS(2126),
    [sym_raw_string] = ACTIONS(2124),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2124),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2124),
    [anon_sym_BQUOTE] = ACTIONS(2124),
    [anon_sym_LT_LPAREN] = ACTIONS(2124),
    [anon_sym_GT_LPAREN] = ACTIONS(2124),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2124),
  },
  [547] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(1012),
    [anon_sym_DQUOTE] = ACTIONS(2128),
    [anon_sym_DOLLAR] = ACTIONS(2130),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [548] = {
    [sym_string] = STATE(1014),
    [anon_sym_DQUOTE] = ACTIONS(1077),
    [anon_sym_DOLLAR] = ACTIONS(2132),
    [sym_raw_string] = ACTIONS(2134),
    [anon_sym_POUND] = ACTIONS(2132),
    [anon_sym_DASH] = ACTIONS(2132),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2136),
    [anon_sym_STAR] = ACTIONS(2132),
    [anon_sym_AT] = ACTIONS(2132),
    [anon_sym_QMARK] = ACTIONS(2132),
    [anon_sym_0] = ACTIONS(2138),
    [anon_sym__] = ACTIONS(2138),
  },
  [549] = {
    [aux_sym_concatenation_repeat1] = STATE(1009),
    [sym__concat] = ACTIONS(2122),
    [anon_sym_RPAREN] = ACTIONS(2140),
    [sym__special_characters] = ACTIONS(2140),
    [anon_sym_DQUOTE] = ACTIONS(2140),
    [anon_sym_DOLLAR] = ACTIONS(2142),
    [sym_raw_string] = ACTIONS(2140),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2140),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2140),
    [anon_sym_BQUOTE] = ACTIONS(2140),
    [anon_sym_LT_LPAREN] = ACTIONS(2140),
    [anon_sym_GT_LPAREN] = ACTIONS(2140),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2140),
  },
  [550] = {
    [sym_subscript] = STATE(1020),
    [sym_variable_name] = ACTIONS(2144),
    [anon_sym_BANG] = ACTIONS(2146),
    [anon_sym_DOLLAR] = ACTIONS(2148),
    [anon_sym_POUND] = ACTIONS(2146),
    [anon_sym_DASH] = ACTIONS(2148),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2150),
    [anon_sym_STAR] = ACTIONS(2148),
    [anon_sym_AT] = ACTIONS(2148),
    [anon_sym_QMARK] = ACTIONS(2148),
    [anon_sym_0] = ACTIONS(2152),
    [anon_sym__] = ACTIONS(2152),
  },
  [551] = {
    [sym__terminated_statement] = STATE(1023),
    [sym_for_statement] = STATE(1021),
    [sym_c_style_for_statement] = STATE(1021),
    [sym_while_statement] = STATE(1021),
    [sym_if_statement] = STATE(1021),
    [sym_case_statement] = STATE(1021),
    [sym_function_definition] = STATE(1021),
    [sym_subshell] = STATE(1021),
    [sym_pipeline] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_negated_command] = STATE(1021),
    [sym_test_command] = STATE(1021),
    [sym_declaration_command] = STATE(1021),
    [sym_unset_command] = STATE(1021),
    [sym_command] = STATE(1021),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(1022),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(1023),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [552] = {
    [sym__terminated_statement] = STATE(1026),
    [sym_for_statement] = STATE(1024),
    [sym_c_style_for_statement] = STATE(1024),
    [sym_while_statement] = STATE(1024),
    [sym_if_statement] = STATE(1024),
    [sym_case_statement] = STATE(1024),
    [sym_function_definition] = STATE(1024),
    [sym_subshell] = STATE(1024),
    [sym_pipeline] = STATE(1024),
    [sym_list] = STATE(1024),
    [sym_negated_command] = STATE(1024),
    [sym_test_command] = STATE(1024),
    [sym_declaration_command] = STATE(1024),
    [sym_unset_command] = STATE(1024),
    [sym_command] = STATE(1024),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(1025),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(1026),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [553] = {
    [sym__terminated_statement] = STATE(1029),
    [sym_for_statement] = STATE(1027),
    [sym_c_style_for_statement] = STATE(1027),
    [sym_while_statement] = STATE(1027),
    [sym_if_statement] = STATE(1027),
    [sym_case_statement] = STATE(1027),
    [sym_function_definition] = STATE(1027),
    [sym_subshell] = STATE(1027),
    [sym_pipeline] = STATE(1027),
    [sym_list] = STATE(1027),
    [sym_negated_command] = STATE(1027),
    [sym_test_command] = STATE(1027),
    [sym_declaration_command] = STATE(1027),
    [sym_unset_command] = STATE(1027),
    [sym_command] = STATE(1027),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(1028),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(1029),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [554] = {
    [sym_concatenation] = STATE(1031),
    [sym_string] = STATE(549),
    [sym_simple_expansion] = STATE(549),
    [sym_string_expansion] = STATE(549),
    [sym_expansion] = STATE(549),
    [sym_command_substitution] = STATE(549),
    [sym_process_substitution] = STATE(549),
    [aux_sym_for_statement_repeat1] = STATE(1031),
    [anon_sym_RPAREN] = ACTIONS(2154),
    [sym__special_characters] = ACTIONS(1075),
    [anon_sym_DQUOTE] = ACTIONS(1077),
    [anon_sym_DOLLAR] = ACTIONS(1079),
    [sym_raw_string] = ACTIONS(1081),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1083),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1085),
    [anon_sym_BQUOTE] = ACTIONS(1087),
    [anon_sym_LT_LPAREN] = ACTIONS(1089),
    [anon_sym_GT_LPAREN] = ACTIONS(1089),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1081),
  },
  [555] = {
    [sym_string] = STATE(1032),
    [sym_simple_expansion] = STATE(1032),
    [sym_string_expansion] = STATE(1032),
    [sym_expansion] = STATE(1032),
    [sym_command_substitution] = STATE(1032),
    [sym_process_substitution] = STATE(1032),
    [sym__special_characters] = ACTIONS(2156),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(2156),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(375),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(377),
    [anon_sym_BQUOTE] = ACTIONS(379),
    [anon_sym_LT_LPAREN] = ACTIONS(381),
    [anon_sym_GT_LPAREN] = ACTIONS(381),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2156),
  },
  [556] = {
    [aux_sym_concatenation_repeat1] = STATE(1033),
    [sym_file_descriptor] = ACTIONS(761),
    [sym__concat] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(761),
    [ts_builtin_sym_end] = ACTIONS(761),
    [anon_sym_PIPE] = ACTIONS(763),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [anon_sym_PIPE_AMP] = ACTIONS(761),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [anon_sym_LT] = ACTIONS(763),
    [anon_sym_GT] = ACTIONS(763),
    [anon_sym_GT_GT] = ACTIONS(761),
    [anon_sym_AMP_GT] = ACTIONS(763),
    [anon_sym_AMP_GT_GT] = ACTIONS(761),
    [anon_sym_LT_AMP] = ACTIONS(761),
    [anon_sym_GT_AMP] = ACTIONS(761),
    [sym__special_characters] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(763),
    [sym_raw_string] = ACTIONS(761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(761),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(761),
    [anon_sym_LT_LPAREN] = ACTIONS(761),
    [anon_sym_GT_LPAREN] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(763),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
  },
  [557] = {
    [sym_file_descriptor] = ACTIONS(765),
    [sym__concat] = ACTIONS(765),
    [sym_variable_name] = ACTIONS(765),
    [ts_builtin_sym_end] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_RPAREN] = ACTIONS(765),
    [anon_sym_SEMI_SEMI] = ACTIONS(765),
    [anon_sym_PIPE_AMP] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_GT_GT] = ACTIONS(765),
    [anon_sym_AMP_GT] = ACTIONS(767),
    [anon_sym_AMP_GT_GT] = ACTIONS(765),
    [anon_sym_LT_AMP] = ACTIONS(765),
    [anon_sym_GT_AMP] = ACTIONS(765),
    [sym__special_characters] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(765),
    [anon_sym_DOLLAR] = ACTIONS(767),
    [sym_raw_string] = ACTIONS(765),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(765),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(765),
    [anon_sym_BQUOTE] = ACTIONS(765),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(767),
    [anon_sym_SEMI] = ACTIONS(767),
    [anon_sym_LF] = ACTIONS(765),
    [anon_sym_AMP] = ACTIONS(767),
  },
  [558] = {
    [anon_sym_DQUOTE] = ACTIONS(2158),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [559] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(2158),
    [anon_sym_DOLLAR] = ACTIONS(2160),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [560] = {
    [sym_file_descriptor] = ACTIONS(797),
    [sym__concat] = ACTIONS(797),
    [sym_variable_name] = ACTIONS(797),
    [ts_builtin_sym_end] = ACTIONS(797),
    [anon_sym_PIPE] = ACTIONS(799),
    [anon_sym_RPAREN] = ACTIONS(797),
    [anon_sym_SEMI_SEMI] = ACTIONS(797),
    [anon_sym_PIPE_AMP] = ACTIONS(797),
    [anon_sym_AMP_AMP] = ACTIONS(797),
    [anon_sym_PIPE_PIPE] = ACTIONS(797),
    [anon_sym_LT] = ACTIONS(799),
    [anon_sym_GT] = ACTIONS(799),
    [anon_sym_GT_GT] = ACTIONS(797),
    [anon_sym_AMP_GT] = ACTIONS(799),
    [anon_sym_AMP_GT_GT] = ACTIONS(797),
    [anon_sym_LT_AMP] = ACTIONS(797),
    [anon_sym_GT_AMP] = ACTIONS(797),
    [sym__special_characters] = ACTIONS(797),
    [anon_sym_DQUOTE] = ACTIONS(797),
    [anon_sym_DOLLAR] = ACTIONS(799),
    [sym_raw_string] = ACTIONS(797),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(797),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(797),
    [anon_sym_BQUOTE] = ACTIONS(797),
    [anon_sym_LT_LPAREN] = ACTIONS(797),
    [anon_sym_GT_LPAREN] = ACTIONS(797),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(799),
    [anon_sym_SEMI] = ACTIONS(799),
    [anon_sym_LF] = ACTIONS(797),
    [anon_sym_AMP] = ACTIONS(799),
  },
  [561] = {
    [sym_file_descriptor] = ACTIONS(801),
    [sym__concat] = ACTIONS(801),
    [sym_variable_name] = ACTIONS(801),
    [ts_builtin_sym_end] = ACTIONS(801),
    [anon_sym_PIPE] = ACTIONS(803),
    [anon_sym_RPAREN] = ACTIONS(801),
    [anon_sym_SEMI_SEMI] = ACTIONS(801),
    [anon_sym_PIPE_AMP] = ACTIONS(801),
    [anon_sym_AMP_AMP] = ACTIONS(801),
    [anon_sym_PIPE_PIPE] = ACTIONS(801),
    [anon_sym_LT] = ACTIONS(803),
    [anon_sym_GT] = ACTIONS(803),
    [anon_sym_GT_GT] = ACTIONS(801),
    [anon_sym_AMP_GT] = ACTIONS(803),
    [anon_sym_AMP_GT_GT] = ACTIONS(801),
    [anon_sym_LT_AMP] = ACTIONS(801),
    [anon_sym_GT_AMP] = ACTIONS(801),
    [sym__special_characters] = ACTIONS(801),
    [anon_sym_DQUOTE] = ACTIONS(801),
    [anon_sym_DOLLAR] = ACTIONS(803),
    [sym_raw_string] = ACTIONS(801),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(801),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(801),
    [anon_sym_BQUOTE] = ACTIONS(801),
    [anon_sym_LT_LPAREN] = ACTIONS(801),
    [anon_sym_GT_LPAREN] = ACTIONS(801),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(803),
    [anon_sym_SEMI] = ACTIONS(803),
    [anon_sym_LF] = ACTIONS(801),
    [anon_sym_AMP] = ACTIONS(803),
  },
  [562] = {
    [sym_file_descriptor] = ACTIONS(805),
    [sym__concat] = ACTIONS(805),
    [sym_variable_name] = ACTIONS(805),
    [ts_builtin_sym_end] = ACTIONS(805),
    [anon_sym_PIPE] = ACTIONS(807),
    [anon_sym_RPAREN] = ACTIONS(805),
    [anon_sym_SEMI_SEMI] = ACTIONS(805),
    [anon_sym_PIPE_AMP] = ACTIONS(805),
    [anon_sym_AMP_AMP] = ACTIONS(805),
    [anon_sym_PIPE_PIPE] = ACTIONS(805),
    [anon_sym_LT] = ACTIONS(807),
    [anon_sym_GT] = ACTIONS(807),
    [anon_sym_GT_GT] = ACTIONS(805),
    [anon_sym_AMP_GT] = ACTIONS(807),
    [anon_sym_AMP_GT_GT] = ACTIONS(805),
    [anon_sym_LT_AMP] = ACTIONS(805),
    [anon_sym_GT_AMP] = ACTIONS(805),
    [sym__special_characters] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(805),
    [anon_sym_DOLLAR] = ACTIONS(807),
    [sym_raw_string] = ACTIONS(805),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(805),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(805),
    [anon_sym_BQUOTE] = ACTIONS(805),
    [anon_sym_LT_LPAREN] = ACTIONS(805),
    [anon_sym_GT_LPAREN] = ACTIONS(805),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(807),
    [anon_sym_SEMI] = ACTIONS(807),
    [anon_sym_LF] = ACTIONS(805),
    [anon_sym_AMP] = ACTIONS(807),
  },
  [563] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(2162),
    [sym_comment] = ACTIONS(53),
  },
  [564] = {
    [sym_subscript] = STATE(1040),
    [sym_variable_name] = ACTIONS(2164),
    [anon_sym_DOLLAR] = ACTIONS(2166),
    [anon_sym_DASH] = ACTIONS(2166),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2168),
    [anon_sym_STAR] = ACTIONS(2166),
    [anon_sym_AT] = ACTIONS(2166),
    [anon_sym_QMARK] = ACTIONS(2166),
    [anon_sym_0] = ACTIONS(2170),
    [anon_sym__] = ACTIONS(2170),
  },
  [565] = {
    [sym_concatenation] = STATE(1043),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(1043),
    [anon_sym_RBRACE] = ACTIONS(2172),
    [anon_sym_EQ] = ACTIONS(2174),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(2176),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(2178),
    [anon_sym_COLON] = ACTIONS(2174),
    [anon_sym_COLON_QMARK] = ACTIONS(2174),
    [anon_sym_COLON_DASH] = ACTIONS(2174),
    [anon_sym_PERCENT] = ACTIONS(2174),
    [anon_sym_DASH] = ACTIONS(2174),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [566] = {
    [sym_concatenation] = STATE(1046),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(1046),
    [anon_sym_RBRACE] = ACTIONS(2180),
    [anon_sym_EQ] = ACTIONS(2182),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(2184),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(2186),
    [anon_sym_COLON] = ACTIONS(2182),
    [anon_sym_COLON_QMARK] = ACTIONS(2182),
    [anon_sym_COLON_DASH] = ACTIONS(2182),
    [anon_sym_PERCENT] = ACTIONS(2182),
    [anon_sym_DASH] = ACTIONS(2182),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [567] = {
    [sym_concatenation] = STATE(1049),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(1049),
    [anon_sym_RBRACE] = ACTIONS(2188),
    [anon_sym_EQ] = ACTIONS(2190),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(2192),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(2194),
    [anon_sym_COLON] = ACTIONS(2190),
    [anon_sym_COLON_QMARK] = ACTIONS(2190),
    [anon_sym_COLON_DASH] = ACTIONS(2190),
    [anon_sym_PERCENT] = ACTIONS(2190),
    [anon_sym_DASH] = ACTIONS(2190),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [568] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(2196),
    [anon_sym_SEMI_SEMI] = ACTIONS(2198),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2200),
    [anon_sym_LF] = ACTIONS(2198),
    [anon_sym_AMP] = ACTIONS(2200),
  },
  [569] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(2196),
    [anon_sym_SEMI_SEMI] = ACTIONS(2198),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(2200),
    [anon_sym_LF] = ACTIONS(2198),
    [anon_sym_AMP] = ACTIONS(2200),
  },
  [570] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(1052),
    [sym_c_style_for_statement] = STATE(1052),
    [sym_while_statement] = STATE(1052),
    [sym_if_statement] = STATE(1052),
    [sym_case_statement] = STATE(1052),
    [sym_function_definition] = STATE(1052),
    [sym_subshell] = STATE(1052),
    [sym_pipeline] = STATE(1052),
    [sym_list] = STATE(1052),
    [sym_negated_command] = STATE(1052),
    [sym_test_command] = STATE(1052),
    [sym_declaration_command] = STATE(1052),
    [sym_unset_command] = STATE(1052),
    [sym_command] = STATE(1052),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(1053),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [571] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(2202),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(2196),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2204),
    [anon_sym_LF] = ACTIONS(2202),
    [anon_sym_AMP] = ACTIONS(2204),
  },
  [572] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(2202),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(2196),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(2204),
    [anon_sym_LF] = ACTIONS(2202),
    [anon_sym_AMP] = ACTIONS(2204),
  },
  [573] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(1055),
    [sym_c_style_for_statement] = STATE(1055),
    [sym_while_statement] = STATE(1055),
    [sym_if_statement] = STATE(1055),
    [sym_case_statement] = STATE(1055),
    [sym_function_definition] = STATE(1055),
    [sym_subshell] = STATE(1055),
    [sym_pipeline] = STATE(1055),
    [sym_list] = STATE(1055),
    [sym_negated_command] = STATE(1055),
    [sym_test_command] = STATE(1055),
    [sym_declaration_command] = STATE(1055),
    [sym_unset_command] = STATE(1055),
    [sym_command] = STATE(1055),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(1056),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [574] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(2206),
    [anon_sym_SEMI_SEMI] = ACTIONS(2208),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2210),
    [anon_sym_LF] = ACTIONS(2208),
    [anon_sym_AMP] = ACTIONS(2210),
  },
  [575] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(2206),
    [anon_sym_SEMI_SEMI] = ACTIONS(2208),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(2210),
    [anon_sym_LF] = ACTIONS(2208),
    [anon_sym_AMP] = ACTIONS(2210),
  },
  [576] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(1059),
    [sym_c_style_for_statement] = STATE(1059),
    [sym_while_statement] = STATE(1059),
    [sym_if_statement] = STATE(1059),
    [sym_case_statement] = STATE(1059),
    [sym_function_definition] = STATE(1059),
    [sym_subshell] = STATE(1059),
    [sym_pipeline] = STATE(1059),
    [sym_list] = STATE(1059),
    [sym_negated_command] = STATE(1059),
    [sym_test_command] = STATE(1059),
    [sym_declaration_command] = STATE(1059),
    [sym_unset_command] = STATE(1059),
    [sym_command] = STATE(1059),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(1060),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [577] = {
    [sym__expression] = STATE(1072),
    [sym_binary_expression] = STATE(1072),
    [sym_unary_expression] = STATE(1072),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_concatenation] = STATE(1072),
    [sym_string] = STATE(1067),
    [sym_simple_expansion] = STATE(1067),
    [sym_string_expansion] = STATE(1067),
    [sym_expansion] = STATE(1067),
    [sym_command_substitution] = STATE(1067),
    [sym_process_substitution] = STATE(1067),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(2212),
    [anon_sym_LPAREN] = ACTIONS(2214),
    [anon_sym_BANG] = ACTIONS(2216),
    [sym__special_characters] = ACTIONS(2218),
    [anon_sym_DQUOTE] = ACTIONS(2220),
    [anon_sym_DOLLAR] = ACTIONS(2222),
    [sym_raw_string] = ACTIONS(2224),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2226),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2228),
    [anon_sym_BQUOTE] = ACTIONS(2230),
    [anon_sym_LT_LPAREN] = ACTIONS(2232),
    [anon_sym_GT_LPAREN] = ACTIONS(2232),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2234),
    [sym_test_operator] = ACTIONS(2236),
  },
  [578] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(2238),
    [anon_sym_AMP_AMP] = ACTIONS(1149),
    [anon_sym_PIPE_PIPE] = ACTIONS(1149),
    [anon_sym_EQ_TILDE] = ACTIONS(1151),
    [anon_sym_EQ_EQ] = ACTIONS(1151),
    [anon_sym_EQ] = ACTIONS(1153),
    [anon_sym_LT] = ACTIONS(1149),
    [anon_sym_GT] = ACTIONS(1149),
    [anon_sym_BANG_EQ] = ACTIONS(1149),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(1149),
    [anon_sym_SEMI] = ACTIONS(2240),
    [anon_sym_LF] = ACTIONS(2238),
    [anon_sym_AMP] = ACTIONS(2240),
  },
  [579] = {
    [anon_sym_RPAREN] = ACTIONS(2242),
    [anon_sym_AMP_AMP] = ACTIONS(1345),
    [anon_sym_PIPE_PIPE] = ACTIONS(1345),
    [anon_sym_EQ_TILDE] = ACTIONS(1347),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ] = ACTIONS(1349),
    [anon_sym_LT] = ACTIONS(1345),
    [anon_sym_GT] = ACTIONS(1345),
    [anon_sym_BANG_EQ] = ACTIONS(1345),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(1345),
  },
  [580] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(1351),
    [anon_sym_AMP_AMP] = ACTIONS(1149),
    [anon_sym_PIPE_PIPE] = ACTIONS(1149),
    [anon_sym_EQ_TILDE] = ACTIONS(1151),
    [anon_sym_EQ_EQ] = ACTIONS(1151),
    [anon_sym_EQ] = ACTIONS(1153),
    [anon_sym_LT] = ACTIONS(1149),
    [anon_sym_GT] = ACTIONS(1149),
    [anon_sym_BANG_EQ] = ACTIONS(1149),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(1149),
    [anon_sym_SEMI] = ACTIONS(2244),
    [anon_sym_LF] = ACTIONS(1351),
    [anon_sym_AMP] = ACTIONS(2244),
  },
  [581] = {
    [sym_string] = STATE(1075),
    [sym_simple_expansion] = STATE(1075),
    [sym_string_expansion] = STATE(1075),
    [sym_expansion] = STATE(1075),
    [sym_command_substitution] = STATE(1075),
    [sym_process_substitution] = STATE(1075),
    [sym__special_characters] = ACTIONS(2246),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(2246),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(397),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(401),
    [anon_sym_LT_LPAREN] = ACTIONS(403),
    [anon_sym_GT_LPAREN] = ACTIONS(403),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2246),
  },
  [582] = {
    [aux_sym_concatenation_repeat1] = STATE(1076),
    [sym__concat] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [anon_sym_EQ_TILDE] = ACTIONS(761),
    [anon_sym_EQ_EQ] = ACTIONS(761),
    [anon_sym_EQ] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(761),
    [anon_sym_GT] = ACTIONS(761),
    [anon_sym_BANG_EQ] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(761),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
  },
  [583] = {
    [sym__concat] = ACTIONS(765),
    [anon_sym_esac] = ACTIONS(765),
    [anon_sym_PIPE] = ACTIONS(767),
    [anon_sym_SEMI_SEMI] = ACTIONS(765),
    [anon_sym_PIPE_AMP] = ACTIONS(765),
    [anon_sym_AMP_AMP] = ACTIONS(765),
    [anon_sym_PIPE_PIPE] = ACTIONS(765),
    [anon_sym_EQ_TILDE] = ACTIONS(765),
    [anon_sym_EQ_EQ] = ACTIONS(765),
    [anon_sym_EQ] = ACTIONS(767),
    [anon_sym_LT] = ACTIONS(765),
    [anon_sym_GT] = ACTIONS(765),
    [anon_sym_BANG_EQ] = ACTIONS(765),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(765),
    [anon_sym_SEMI] = ACTIONS(767),
    [anon_sym_LF] = ACTIONS(765),
    [anon_sym_AMP] = ACTIONS(767),
  },
  [584] = {
    [anon_sym_DQUOTE] = ACTIONS(2248),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [585] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(461),
    [anon_sym_DQUOTE] = ACTIONS(2248),
    [anon_sym_DOLLAR] = ACTIONS(2250),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [586] = {
    [sym__concat] = ACTIONS(797),
    [anon_sym_esac] = ACTIONS(797),
    [anon_sym_PIPE] = ACTIONS(799),
    [anon_sym_SEMI_SEMI] = ACTIONS(797),
    [anon_sym_PIPE_AMP] = ACTIONS(797),
    [anon_sym_AMP_AMP] = ACTIONS(797),
    [anon_sym_PIPE_PIPE] = ACTIONS(797),
    [anon_sym_EQ_TILDE] = ACTIONS(797),
    [anon_sym_EQ_EQ] = ACTIONS(797),
    [anon_sym_EQ] = ACTIONS(799),
    [anon_sym_LT] = ACTIONS(797),
    [anon_sym_GT] = ACTIONS(797),
    [anon_sym_BANG_EQ] = ACTIONS(797),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(797),
    [anon_sym_SEMI] = ACTIONS(799),
    [anon_sym_LF] = ACTIONS(797),
    [anon_sym_AMP] = ACTIONS(799),
  },
  [587] = {
    [sym__concat] = ACTIONS(801),
    [anon_sym_esac] = ACTIONS(801),
    [anon_sym_PIPE] = ACTIONS(803),
    [anon_sym_SEMI_SEMI] = ACTIONS(801),
    [anon_sym_PIPE_AMP] = ACTIONS(801),
    [anon_sym_AMP_AMP] = ACTIONS(801),
    [anon_sym_PIPE_PIPE] = ACTIONS(801),
    [anon_sym_EQ_TILDE] = ACTIONS(801),
    [anon_sym_EQ_EQ] = ACTIONS(801),
    [anon_sym_EQ] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(801),
    [anon_sym_GT] = ACTIONS(801),
    [anon_sym_BANG_EQ] = ACTIONS(801),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(801),
    [anon_sym_SEMI] = ACTIONS(803),
    [anon_sym_LF] = ACTIONS(801),
    [anon_sym_AMP] = ACTIONS(803),
  },
  [588] = {
    [sym__concat] = ACTIONS(805),
    [anon_sym_esac] = ACTIONS(805),
    [anon_sym_PIPE] = ACTIONS(807),
    [anon_sym_SEMI_SEMI] = ACTIONS(805),
    [anon_sym_PIPE_AMP] = ACTIONS(805),
    [anon_sym_AMP_AMP] = ACTIONS(805),
    [anon_sym_PIPE_PIPE] = ACTIONS(805),
    [anon_sym_EQ_TILDE] = ACTIONS(805),
    [anon_sym_EQ_EQ] = ACTIONS(805),
    [anon_sym_EQ] = ACTIONS(807),
    [anon_sym_LT] = ACTIONS(805),
    [anon_sym_GT] = ACTIONS(805),
    [anon_sym_BANG_EQ] = ACTIONS(805),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(805),
    [anon_sym_SEMI] = ACTIONS(807),
    [anon_sym_LF] = ACTIONS(805),
    [anon_sym_AMP] = ACTIONS(807),
  },
  [589] = {
    [anon_sym_LBRACK] = ACTIONS(809),
    [anon_sym_EQ] = ACTIONS(2252),
    [sym_comment] = ACTIONS(53),
  },
  [590] = {
    [sym_subscript] = STATE(1083),
    [sym_variable_name] = ACTIONS(2254),
    [anon_sym_DOLLAR] = ACTIONS(2256),
    [anon_sym_DASH] = ACTIONS(2256),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2258),
    [anon_sym_STAR] = ACTIONS(2256),
    [anon_sym_AT] = ACTIONS(2256),
    [anon_sym_QMARK] = ACTIONS(2256),
    [anon_sym_0] = ACTIONS(2260),
    [anon_sym__] = ACTIONS(2260),
  },
  [591] = {
    [sym_concatenation] = STATE(1086),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(1086),
    [anon_sym_RBRACE] = ACTIONS(2262),
    [anon_sym_EQ] = ACTIONS(2264),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(2266),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(2268),
    [anon_sym_COLON] = ACTIONS(2264),
    [anon_sym_COLON_QMARK] = ACTIONS(2264),
    [anon_sym_COLON_DASH] = ACTIONS(2264),
    [anon_sym_PERCENT] = ACTIONS(2264),
    [anon_sym_DASH] = ACTIONS(2264),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [592] = {
    [sym_concatenation] = STATE(1089),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(1089),
    [anon_sym_RBRACE] = ACTIONS(2270),
    [anon_sym_EQ] = ACTIONS(2272),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(2274),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(2276),
    [anon_sym_COLON] = ACTIONS(2272),
    [anon_sym_COLON_QMARK] = ACTIONS(2272),
    [anon_sym_COLON_DASH] = ACTIONS(2272),
    [anon_sym_PERCENT] = ACTIONS(2272),
    [anon_sym_DASH] = ACTIONS(2272),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [593] = {
    [sym_concatenation] = STATE(1092),
    [sym_string] = STATE(472),
    [sym_simple_expansion] = STATE(472),
    [sym_string_expansion] = STATE(472),
    [sym_expansion] = STATE(472),
    [sym_command_substitution] = STATE(472),
    [sym_process_substitution] = STATE(472),
    [aux_sym_expansion_repeat1] = STATE(1092),
    [anon_sym_RBRACE] = ACTIONS(2278),
    [anon_sym_EQ] = ACTIONS(2280),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(2282),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(835),
    [anon_sym_SLASH] = ACTIONS(2284),
    [anon_sym_COLON] = ACTIONS(2280),
    [anon_sym_COLON_QMARK] = ACTIONS(2280),
    [anon_sym_COLON_DASH] = ACTIONS(2280),
    [anon_sym_PERCENT] = ACTIONS(2280),
    [anon_sym_DASH] = ACTIONS(2280),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(839),
    [anon_sym_BQUOTE] = ACTIONS(841),
    [anon_sym_LT_LPAREN] = ACTIONS(843),
    [anon_sym_GT_LPAREN] = ACTIONS(843),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(845),
  },
  [594] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(2286),
    [anon_sym_SEMI_SEMI] = ACTIONS(2288),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2290),
    [anon_sym_LF] = ACTIONS(2288),
    [anon_sym_AMP] = ACTIONS(2290),
  },
  [595] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(2286),
    [anon_sym_SEMI_SEMI] = ACTIONS(2288),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(2290),
    [anon_sym_LF] = ACTIONS(2288),
    [anon_sym_AMP] = ACTIONS(2290),
  },
  [596] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(1095),
    [sym_c_style_for_statement] = STATE(1095),
    [sym_while_statement] = STATE(1095),
    [sym_if_statement] = STATE(1095),
    [sym_case_statement] = STATE(1095),
    [sym_function_definition] = STATE(1095),
    [sym_subshell] = STATE(1095),
    [sym_pipeline] = STATE(1095),
    [sym_list] = STATE(1095),
    [sym_negated_command] = STATE(1095),
    [sym_test_command] = STATE(1095),
    [sym_declaration_command] = STATE(1095),
    [sym_unset_command] = STATE(1095),
    [sym_command] = STATE(1095),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(1096),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [597] = {
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(2292),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_BQUOTE] = ACTIONS(2286),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2294),
    [anon_sym_LF] = ACTIONS(2292),
    [anon_sym_AMP] = ACTIONS(2294),
  },
  [598] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(873),
    [anon_sym_SEMI_SEMI] = ACTIONS(2292),
    [anon_sym_PIPE_AMP] = ACTIONS(877),
    [anon_sym_AMP_AMP] = ACTIONS(879),
    [anon_sym_PIPE_PIPE] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(2286),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(2294),
    [anon_sym_LF] = ACTIONS(2292),
    [anon_sym_AMP] = ACTIONS(2294),
  },
  [599] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(1098),
    [sym_c_style_for_statement] = STATE(1098),
    [sym_while_statement] = STATE(1098),
    [sym_if_statement] = STATE(1098),
    [sym_case_statement] = STATE(1098),
    [sym_function_definition] = STATE(1098),
    [sym_subshell] = STATE(1098),
    [sym_pipeline] = STATE(1098),
    [sym_list] = STATE(1098),
    [sym_negated_command] = STATE(1098),
    [sym_test_command] = STATE(1098),
    [sym_declaration_command] = STATE(1098),
    [sym_unset_command] = STATE(1098),
    [sym_command] = STATE(1098),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(1099),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [600] = {
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(2296),
    [anon_sym_SEMI_SEMI] = ACTIONS(2298),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2300),
    [anon_sym_LF] = ACTIONS(2298),
    [anon_sym_AMP] = ACTIONS(2300),
  },
  [601] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_RPAREN] = ACTIONS(2296),
    [anon_sym_SEMI_SEMI] = ACTIONS(2298),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(2300),
    [anon_sym_LF] = ACTIONS(2298),
    [anon_sym_AMP] = ACTIONS(2300),
  },
  [602] = {
    [sym__terminated_statement] = STATE(194),
    [sym_for_statement] = STATE(1102),
    [sym_c_style_for_statement] = STATE(1102),
    [sym_while_statement] = STATE(1102),
    [sym_if_statement] = STATE(1102),
    [sym_case_statement] = STATE(1102),
    [sym_function_definition] = STATE(1102),
    [sym_subshell] = STATE(1102),
    [sym_pipeline] = STATE(1102),
    [sym_list] = STATE(1102),
    [sym_negated_command] = STATE(1102),
    [sym_test_command] = STATE(1102),
    [sym_declaration_command] = STATE(1102),
    [sym_unset_command] = STATE(1102),
    [sym_command] = STATE(1102),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(1103),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(194),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [603] = {
    [sym__expression] = STATE(1104),
    [sym_binary_expression] = STATE(1104),
    [sym_unary_expression] = STATE(1104),
    [sym_parenthesized_expression] = STATE(1104),
    [sym_concatenation] = STATE(1104),
    [sym_string] = STATE(219),
    [sym_simple_expansion] = STATE(219),
    [sym_string_expansion] = STATE(219),
    [sym_expansion] = STATE(219),
    [sym_command_substitution] = STATE(219),
    [sym_process_substitution] = STATE(219),
    [anon_sym_SEMI_SEMI] = ACTIONS(2238),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [sym__special_characters] = ACTIONS(389),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(395),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(397),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(401),
    [anon_sym_LT_LPAREN] = ACTIONS(403),
    [anon_sym_GT_LPAREN] = ACTIONS(403),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(405),
    [sym_test_operator] = ACTIONS(407),
    [anon_sym_SEMI] = ACTIONS(2240),
    [anon_sym_LF] = ACTIONS(2238),
    [anon_sym_AMP] = ACTIONS(2238),
  },
  [604] = {
    [sym__expression] = STATE(1105),
    [sym_binary_expression] = STATE(1105),
    [sym_unary_expression] = STATE(1105),
    [sym_parenthesized_expression] = STATE(1105),
    [sym_concatenation] = STATE(1105),
    [sym_string] = STATE(219),
    [sym_simple_expansion] = STATE(219),
    [sym_string_expansion] = STATE(219),
    [sym_expansion] = STATE(219),
    [sym_command_substitution] = STATE(219),
    [sym_process_substitution] = STATE(219),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(387),
    [sym__special_characters] = ACTIONS(389),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(395),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(397),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(401),
    [anon_sym_LT_LPAREN] = ACTIONS(403),
    [anon_sym_GT_LPAREN] = ACTIONS(403),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(405),
    [sym_test_operator] = ACTIONS(407),
  },
  [605] = {
    [sym__expression] = STATE(1105),
    [sym_binary_expression] = STATE(1105),
    [sym_unary_expression] = STATE(1105),
    [sym_parenthesized_expression] = STATE(1105),
    [sym_concatenation] = STATE(1105),
    [sym_string] = STATE(219),
    [sym_simple_expansion] = STATE(219),
    [sym_string_expansion] = STATE(219),
    [sym_expansion] = STATE(219),
    [sym_command_substitution] = STATE(219),
    [sym_process_substitution] = STATE(219),
    [anon_sym_LPAREN] = ACTIONS(2302),
    [anon_sym_BANG] = ACTIONS(387),
    [sym__special_characters] = ACTIONS(2304),
    [anon_sym_DQUOTE] = ACTIONS(2306),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(405),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2308),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2310),
    [anon_sym_BQUOTE] = ACTIONS(2312),
    [anon_sym_LT_LPAREN] = ACTIONS(2314),
    [anon_sym_GT_LPAREN] = ACTIONS(2314),
    [sym_comment] = ACTIONS(265),
    [sym_word] = ACTIONS(405),
    [sym_test_operator] = ACTIONS(387),
    [sym_regex] = ACTIONS(2316),
  },
  [606] = {
    [aux_sym_concatenation_repeat1] = STATE(1108),
    [sym__concat] = ACTIONS(2318),
    [anon_sym_SEMI_SEMI] = ACTIONS(2124),
    [sym__special_characters] = ACTIONS(2124),
    [anon_sym_DQUOTE] = ACTIONS(2124),
    [anon_sym_DOLLAR] = ACTIONS(2126),
    [sym_raw_string] = ACTIONS(2124),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2124),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2124),
    [anon_sym_BQUOTE] = ACTIONS(2124),
    [anon_sym_LT_LPAREN] = ACTIONS(2124),
    [anon_sym_GT_LPAREN] = ACTIONS(2124),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2126),
    [anon_sym_SEMI] = ACTIONS(2126),
    [anon_sym_LF] = ACTIONS(2124),
    [anon_sym_AMP] = ACTIONS(2124),
  },
  [607] = {
    [sym_simple_expansion] = STATE(144),
    [sym_expansion] = STATE(144),
    [sym_command_substitution] = STATE(144),
    [aux_sym_string_repeat1] = STATE(1111),
    [anon_sym_DQUOTE] = ACTIONS(2320),
    [anon_sym_DOLLAR] = ACTIONS(2322),
    [sym__string_content] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(263),
    [sym_comment] = ACTIONS(265),
  },
  [608] = {
    [sym_string] = STATE(1113),
    [anon_sym_DQUOTE] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(2324),
    [sym_raw_string] = ACTIONS(2326),
    [anon_sym_POUND] = ACTIONS(2324),
    [anon_sym_DASH] = ACTIONS(2324),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2328),
    [anon_sym_STAR] = ACTIONS(2324),
    [anon_sym_AT] = ACTIONS(2324),
    [anon_sym_QMARK] = ACTIONS(2324),
    [anon_sym_0] = ACTIONS(2330),
    [anon_sym__] = ACTIONS(2330),
  },
  [609] = {
    [aux_sym_concatenation_repeat1] = STATE(1108),
    [sym__concat] = ACTIONS(2318),
    [anon_sym_SEMI_SEMI] = ACTIONS(2140),
    [sym__special_characters] = ACTIONS(2140),
    [anon_sym_DQUOTE] = ACTIONS(2140),
    [anon_sym_DOLLAR] = ACTIONS(2142),
    [sym_raw_string] = ACTIONS(2140),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2140),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2140),
    [anon_sym_BQUOTE] = ACTIONS(2140),
    [anon_sym_LT_LPAREN] = ACTIONS(2140),
    [anon_sym_GT_LPAREN] = ACTIONS(2140),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2142),
    [anon_sym_SEMI] = ACTIONS(2142),
    [anon_sym_LF] = ACTIONS(2140),
    [anon_sym_AMP] = ACTIONS(2140),
  },
  [610] = {
    [sym_subscript] = STATE(1119),
    [sym_variable_name] = ACTIONS(2332),
    [anon_sym_BANG] = ACTIONS(2334),
    [anon_sym_DOLLAR] = ACTIONS(2336),
    [anon_sym_POUND] = ACTIONS(2334),
    [anon_sym_DASH] = ACTIONS(2336),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2338),
    [anon_sym_STAR] = ACTIONS(2336),
    [anon_sym_AT] = ACTIONS(2336),
    [anon_sym_QMARK] = ACTIONS(2336),
    [anon_sym_0] = ACTIONS(2340),
    [anon_sym__] = ACTIONS(2340),
  },
  [611] = {
    [sym__terminated_statement] = STATE(1122),
    [sym_for_statement] = STATE(1120),
    [sym_c_style_for_statement] = STATE(1120),
    [sym_while_statement] = STATE(1120),
    [sym_if_statement] = STATE(1120),
    [sym_case_statement] = STATE(1120),
    [sym_function_definition] = STATE(1120),
    [sym_subshell] = STATE(1120),
    [sym_pipeline] = STATE(1120),
    [sym_list] = STATE(1120),
    [sym_negated_command] = STATE(1120),
    [sym_test_command] = STATE(1120),
    [sym_declaration_command] = STATE(1120),
    [sym_unset_command] = STATE(1120),
    [sym_command] = STATE(1120),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(1121),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(1122),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [612] = {
    [sym__terminated_statement] = STATE(1125),
    [sym_for_statement] = STATE(1123),
    [sym_c_style_for_statement] = STATE(1123),
    [sym_while_statement] = STATE(1123),
    [sym_if_statement] = STATE(1123),
    [sym_case_statement] = STATE(1123),
    [sym_function_definition] = STATE(1123),
    [sym_subshell] = STATE(1123),
    [sym_pipeline] = STATE(1123),
    [sym_list] = STATE(1123),
    [sym_negated_command] = STATE(1123),
    [sym_test_command] = STATE(1123),
    [sym_declaration_command] = STATE(1123),
    [sym_unset_command] = STATE(1123),
    [sym_command] = STATE(1123),
    [sym_command_name] = STATE(169),
    [sym_variable_assignment] = STATE(1124),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(1125),
    [aux_sym_command_repeat1] = STATE(172),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(293),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_typeset] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(299),
    [anon_sym_readonly] = ACTIONS(299),
    [anon_sym_local] = ACTIONS(299),
    [anon_sym_unset] = ACTIONS(301),
    [anon_sym_unsetenv] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(303),
  },
  [613] = {
    [sym__terminated_statement] = STATE(1128),
    [sym_for_statement] = STATE(1126),
    [sym_c_style_for_statement] = STATE(1126),
    [sym_while_statement] = STATE(1126),
    [sym_if_statement] = STATE(1126),
    [sym_case_statement] = STATE(1126),
    [sym_function_definition] = STATE(1126),
    [sym_subshell] = STATE(1126),
    [sym_pipeline] = STATE(1126),
    [sym_list] = STATE(1126),
    [sym_negated_command] = STATE(1126),
    [sym_test_command] = STATE(1126),
    [sym_declaration_command] = STATE(1126),
    [sym_unset_command] = STATE(1126),
    [sym_command] = STATE(1126),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(1127),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(76),
    [sym_simple_expansion] = STATE(76),
    [sym_string_expansion] = STATE(76),
    [sym_expansion] = STATE(76),
    [sym_command_substitution] = STATE(76),
    [sym_process_substitution] = STATE(76),
    [aux_sym__statements_repeat1] = STATE(1128),
    [aux_sym_command_repeat1] = STATE(83),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(127),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
  },
  [614] = {
    [sym_concatenation] = STATE(1130),
    [sym_string] = STATE(609),
    [sym_simple_expansion] = STATE(609),
    [sym_string_expansion] = STATE(609),
    [sym_expansion] = STATE(609),
    [sym_command_substitution] = STATE(609),
    [sym_process_substitution] = STATE(609),
    [aux_sym_for_statement_repeat1] = STATE(1130),
    [anon_sym_SEMI_SEMI] = ACTIONS(2342),
    [sym__special_characters] = ACTIONS(1157),
    [anon_sym_DQUOTE] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(1161),
    [sym_raw_string] = ACTIONS(1163),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1165),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1167),
    [anon_sym_BQUOTE] = ACTIONS(1169),
    [anon_sym_LT_LPAREN] = ACTIONS(1171),
    [anon_sym_GT_LPAREN] = ACTIONS(1171),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2344),
    [anon_sym_SEMI] = ACTIONS(2346),
    [anon_sym_LF] = ACTIONS(2342),
    [anon_sym_AMP] = ACTIONS(2342),
  },
  [615] = {
    [sym__terminated_statement] = STATE(1132),
    [sym_for_statement] = STATE(536),
    [sym_c_style_for_statement] = STATE(536),
    [sym_while_statement] = STATE(536),
    [sym_if_statement] = STATE(536),
    [sym_case_statement] = STATE(536),
    [sym_function_definition] = STATE(536),
    [sym_subshell] = STATE(536),
    [sym_pipeline] = STATE(536),
    [sym_list] = STATE(536),
    [sym_negated_command] = STATE(536),
    [sym_test_command] = STATE(536),
    [sym_declaration_command] = STATE(536),
    [sym_unset_command] = STATE(536),
    [sym_command] = STATE(536),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(537),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(1132),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_done] = ACTIONS(2348),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [616] = {
    [ts_builtin_sym_end] = ACTIONS(2350),
    [anon_sym_esac] = ACTIONS(2350),
    [anon_sym_PIPE] = ACTIONS(2352),
    [anon_sym_RPAREN] = ACTIONS(2350),
    [anon_sym_SEMI_SEMI] = ACTIONS(2350),
    [anon_sym_PIPE_AMP] = ACTIONS(2350),
    [anon_sym_AMP_AMP] = ACTIONS(2350),
    [anon_sym_PIPE_PIPE] = ACTIONS(2350),
    [anon_sym_BQUOTE] = ACTIONS(2350),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2352),
    [anon_sym_LF] = ACTIONS(2350),
    [anon_sym_AMP] = ACTIONS(2352),
  },
  [617] = {
    [aux_sym_concatenation_repeat1] = STATE(1133),
    [sym_file_descriptor] = ACTIONS(1091),
    [sym__concat] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(1091),
    [anon_sym_PIPE] = ACTIONS(1095),
    [anon_sym_SEMI_SEMI] = ACTIONS(1091),
    [anon_sym_PIPE_AMP] = ACTIONS(1091),
    [anon_sym_AMP_AMP] = ACTIONS(1091),
    [anon_sym_PIPE_PIPE] = ACTIONS(1091),
    [anon_sym_LT] = ACTIONS(1095),
    [anon_sym_GT] = ACTIONS(1095),
    [anon_sym_GT_GT] = ACTIONS(1091),
    [anon_sym_AMP_GT] = ACTIONS(1095),
    [anon_sym_AMP_GT_GT] = ACTIONS(1091),
    [anon_sym_LT_AMP] = ACTIONS(1091),
    [anon_sym_GT_AMP] = ACTIONS(1091),
    [sym__special_characters] = ACTIONS(1091),
    [anon_sym_DQUOTE] = ACTIONS(1091),
    [anon_sym_DOLLAR] = ACTIONS(1095),
    [sym_raw_string] = ACTIONS(1091),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1091),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1091),
    [anon_sym_BQUOTE] = ACTIONS(1091),
    [anon_sym_LT_LPAREN] = ACTIONS(1091),
    [anon_sym_GT_LPAREN] = ACTIONS(1091),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1095),
    [anon_sym_SEMI] = ACTIONS(1095),
    [anon_sym_LF] = ACTIONS(1091),
    [anon_sym_AMP] = ACTIONS(1095),
  },
  [618] = {
    [aux_sym_concatenation_repeat1] = STATE(1133),
    [sym_file_descriptor] = ACTIONS(1069),
    [sym__concat] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(1069),
    [anon_sym_PIPE] = ACTIONS(1071),
    [anon_sym_SEMI_SEMI] = ACTIONS(1069),
    [anon_sym_PIPE_AMP] = ACTIONS(1069),
    [anon_sym_AMP_AMP] = ACTIONS(1069),
    [anon_sym_PIPE_PIPE] = ACTIONS(1069),
    [anon_sym_LT] = ACTIONS(1071),
    [anon_sym_GT] = ACTIONS(1071),
    [anon_sym_GT_GT] = ACTIONS(1069),
    [anon_sym_AMP_GT] = ACTIONS(1071),
    [anon_sym_AMP_GT_GT] = ACTIONS(1069),
    [anon_sym_LT_AMP] = ACTIONS(1069),
    [anon_sym_GT_AMP] = ACTIONS(1069),
    [sym__special_characters] = ACTIONS(1069),
    [anon_sym_DQUOTE] = ACTIONS(1069),
    [anon_sym_DOLLAR] = ACTIONS(1071),
    [sym_raw_string] = ACTIONS(1069),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1069),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1069),
    [anon_sym_BQUOTE] = ACTIONS(1069),
    [anon_sym_LT_LPAREN] = ACTIONS(1069),
    [anon_sym_GT_LPAREN] = ACTIONS(1069),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1071),
    [anon_sym_SEMI] = ACTIONS(1071),
    [anon_sym_LF] = ACTIONS(1069),
    [anon_sym_AMP] = ACTIONS(1071),
  },
  [619] = {
    [sym_file_redirect] = STATE(1134),
    [sym_heredoc_redirect] = STATE(1134),
    [sym_heredoc_body] = STATE(632),
    [sym_herestring_redirect] = STATE(1134),
    [aux_sym_while_statement_repeat1] = STATE(1134),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(1191),
    [anon_sym_SEMI_SEMI] = ACTIONS(1189),
    [anon_sym_PIPE_AMP] = ACTIONS(1189),
    [anon_sym_AMP_AMP] = ACTIONS(1189),
    [anon_sym_PIPE_PIPE] = ACTIONS(1189),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(455),
    [anon_sym_AMP_GT] = ACTIONS(453),
    [anon_sym_AMP_GT_GT] = ACTIONS(455),
    [anon_sym_LT_AMP] = ACTIONS(455),
    [anon_sym_GT_AMP] = ACTIONS(455),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(457),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1191),
    [anon_sym_LF] = ACTIONS(1189),
    [anon_sym_AMP] = ACTIONS(1191),
  },
  [620] = {
    [anon_sym_RPAREN] = ACTIONS(2354),
    [sym_comment] = ACTIONS(53),
  },
  [621] = {
    [sym_file_redirect] = STATE(694),
    [sym_file_descriptor] = ACTIONS(2356),
    [anon_sym_PIPE] = ACTIONS(1291),
    [anon_sym_SEMI_SEMI] = ACTIONS(1289),
    [anon_sym_PIPE_AMP] = ACTIONS(1289),
    [anon_sym_AMP_AMP] = ACTIONS(1289),
    [anon_sym_PIPE_PIPE] = ACTIONS(1289),
    [anon_sym_LT] = ACTIONS(2358),
    [anon_sym_GT] = ACTIONS(2358),
    [anon_sym_GT_GT] = ACTIONS(2360),
    [anon_sym_AMP_GT] = ACTIONS(2358),
    [anon_sym_AMP_GT_GT] = ACTIONS(2360),
    [anon_sym_LT_AMP] = ACTIONS(2360),
    [anon_sym_GT_AMP] = ACTIONS(2360),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1291),
    [anon_sym_LF] = ACTIONS(1289),
    [anon_sym_AMP] = ACTIONS(1291),
  },
  [622] = {
    [sym_file_redirect] = STATE(1141),
    [sym_heredoc_redirect] = STATE(1141),
    [sym_herestring_redirect] = STATE(1141),
    [aux_sym_while_statement_repeat1] = STATE(1141),
    [sym_file_descriptor] = ACTIONS(2362),
    [anon_sym_PIPE] = ACTIONS(1413),
    [anon_sym_SEMI_SEMI] = ACTIONS(1411),
    [anon_sym_PIPE_AMP] = ACTIONS(1411),
    [anon_sym_AMP_AMP] = ACTIONS(1411),
    [anon_sym_PIPE_PIPE] = ACTIONS(1411),
    [anon_sym_LT] = ACTIONS(2364),
    [anon_sym_GT] = ACTIONS(2364),
    [anon_sym_GT_GT] = ACTIONS(2366),
    [anon_sym_AMP_GT] = ACTIONS(2364),
    [anon_sym_AMP_GT_GT] = ACTIONS(2366),
    [anon_sym_LT_AMP] = ACTIONS(2366),
    [anon_sym_GT_AMP] = ACTIONS(2366),
    [anon_sym_LT_LT] = ACTIONS(1419),
    [anon_sym_LT_LT_DASH] = ACTIONS(1421),
    [anon_sym_LT_LT_LT] = ACTIONS(2368),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1413),
    [anon_sym_LF] = ACTIONS(1411),
    [anon_sym_AMP] = ACTIONS(1413),
  },
  [623] = {
    [sym_concatenation] = STATE(800),
    [sym_string] = STATE(1143),
    [sym_array] = STATE(800),
    [sym_simple_expansion] = STATE(1143),
    [sym_string_expansion] = STATE(1143),
    [sym_expansion] = STATE(1143),
    [sym_command_substitution] = STATE(1143),
    [sym_process_substitution] = STATE(1143),
    [sym__empty_value] = ACTIONS(1515),
    [anon_sym_LPAREN] = ACTIONS(1517),
    [sym__special_characters] = ACTIONS(2370),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(2372),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(195),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(197),
    [anon_sym_BQUOTE] = ACTIONS(199),
    [anon_sym_LT_LPAREN] = ACTIONS(201),
    [anon_sym_GT_LPAREN] = ACTIONS(201),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2372),
  },
  [624] = {
    [aux_sym_concatenation_repeat1] = STATE(1144),
    [sym__concat] = ACTIONS(647),
    [sym_variable_name] = ACTIONS(761),
    [anon_sym_PIPE] = ACTIONS(763),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [anon_sym_PIPE_AMP] = ACTIONS(761),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [sym__special_characters] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(763),
    [sym_raw_string] = ACTIONS(761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(761),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(761),
    [anon_sym_LT_LPAREN] = ACTIONS(761),
    [anon_sym_GT_LPAREN] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(763),
    [sym_word] = ACTIONS(763),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
  },
  [625] = {
    [sym_variable_assignment] = STATE(625),
    [sym_subscript] = STATE(235),
    [sym_concatenation] = STATE(625),
    [sym_string] = STATE(234),
    [sym_simple_expansion] = STATE(234),
    [sym_string_expansion] = STATE(234),
    [sym_expansion] = STATE(234),
    [sym_command_substitution] = STATE(234),
    [sym_process_substitution] = STATE(234),
    [aux_sym_declaration_command_repeat1] = STATE(625),
    [sym_variable_name] = ACTIONS(2374),
    [anon_sym_PIPE] = ACTIONS(1584),
    [anon_sym_SEMI_SEMI] = ACTIONS(1582),
    [anon_sym_PIPE_AMP] = ACTIONS(1582),
    [anon_sym_AMP_AMP] = ACTIONS(1582),
    [anon_sym_PIPE_PIPE] = ACTIONS(1582),
    [sym__special_characters] = ACTIONS(2377),
    [anon_sym_DQUOTE] = ACTIONS(1589),
    [anon_sym_DOLLAR] = ACTIONS(1592),
    [sym_raw_string] = ACTIONS(2380),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1598),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1601),
    [anon_sym_BQUOTE] = ACTIONS(1604),
    [anon_sym_LT_LPAREN] = ACTIONS(1607),
    [anon_sym_GT_LPAREN] = ACTIONS(1607),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1610),
    [sym_word] = ACTIONS(2383),
    [anon_sym_SEMI] = ACTIONS(1584),
    [anon_sym_LF] = ACTIONS(1582),
    [anon_sym_AMP] = ACTIONS(1584),
  },
  [626] = {
    [aux_sym_concatenation_repeat1] = STATE(1145),
    [sym__concat] = ACTIONS(687),
    [anon_sym_PIPE] = ACTIONS(763),
    [anon_sym_SEMI_SEMI] = ACTIONS(761),
    [anon_sym_PIPE_AMP] = ACTIONS(761),
    [anon_sym_AMP_AMP] = ACTIONS(761),
    [anon_sym_PIPE_PIPE] = ACTIONS(761),
    [sym__special_characters] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(763),
    [sym_raw_string] = ACTIONS(761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(761),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(761),
    [anon_sym_LT_LPAREN] = ACTIONS(761),
    [anon_sym_GT_LPAREN] = ACTIONS(761),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(763),
    [sym_word] = ACTIONS(763),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_LF] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
  },
  [627] = {
    [sym_concatenation] = STATE(627),
    [sym_string] = STATE(238),
    [sym_simple_expansion] = STATE(238),
    [sym_string_expansion] = STATE(238),
    [sym_expansion] = STATE(238),
    [sym_command_substitution] = STATE(238),
    [sym_process_substitution] = STATE(238),
    [aux_sym_unset_command_repeat1] = STATE(627),
    [anon_sym_PIPE] = ACTIONS(1674),
    [anon_sym_SEMI_SEMI] = ACTIONS(1672),
    [anon_sym_PIPE_AMP] = ACTIONS(1672),
    [anon_sym_AMP_AMP] = ACTIONS(1672),
    [anon_sym_PIPE_PIPE] = ACTIONS(1672),
    [sym__special_characters] = ACTIONS(2386),
    [anon_sym_DQUOTE] = ACTIONS(1679),
    [anon_sym_DOLLAR] = ACTIONS(1682),
    [sym_raw_string] = ACTIONS(2389),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1688),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1691),
    [anon_sym_BQUOTE] = ACTIONS(1694),
    [anon_sym_LT_LPAREN] = ACTIONS(1697),
    [anon_sym_GT_LPAREN] = ACTIONS(1697),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1700),
    [sym_word] = ACTIONS(2392),
    [anon_sym_SEMI] = ACTIONS(1674),
    [anon_sym_LF] = ACTIONS(1672),
    [anon_sym_AMP] = ACTIONS(1674),
  },
  [628] = {
    [aux_sym_concatenation_repeat1] = STATE(628),
    [sym__simple_heredoc_body] = ACTIONS(1762),
    [sym__heredoc_body_beginning] = ACTIONS(1762),
    [sym_file_descriptor] = ACTIONS(1762),
    [sym__concat] = ACTIONS(1766),
    [anon_sym_PIPE] = ACTIONS(1764),
    [anon_sym_SEMI_SEMI] = ACTIONS(1762),
    [anon_sym_PIPE_AMP] = ACTIONS(1762),
    [anon_sym_AMP_AMP] = ACTIONS(1762),
    [anon_sym_PIPE_PIPE] = ACTIONS(1762),
    [anon_sym_EQ_TILDE] = ACTIONS(1764),
    [anon_sym_EQ_EQ] = ACTIONS(1764),
    [anon_sym_LT] = ACTIONS(1764),
    [anon_sym_GT] = ACTIONS(1764),
    [anon_sym_GT_GT] = ACTIONS(1762),
    [anon_sym_AMP_GT] = ACTIONS(1764),
    [anon_sym_AMP_GT_GT] = ACTIONS(1762),
    [anon_sym_LT_AMP] = ACTIONS(1762),
    [anon_sym_GT_AMP] = ACTIONS(1762),
    [anon_sym_LT_LT] = ACTIONS(1764),
    [anon_sym_LT_LT_DASH] = ACTIONS(1762),
    [anon_sym_LT_LT_LT] = ACTIONS(1762),
    [sym__special_characters] = ACTIONS(1762),
    [anon_sym_DQUOTE] = ACTIONS(1762),
    [anon_sym_DOLLAR] = ACTIONS(1764),
    [sym_raw_string] = ACTIONS(1762),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1762),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1762),
    [anon_sym_BQUOTE] = ACTIONS(1762),
    [anon_sym_LT_LPAREN] = ACTIONS(1762),
    [anon_sym_GT_LPAREN] = ACTIONS(1762),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1764),
    [anon_sym_SEMI] = ACTIONS(1764),
    [anon_sym_LF] = ACTIONS(1762),
    [anon_sym_AMP] = ACTIONS(1764),
  },
  [629] = {
    [sym_compound_statement] = STATE(1146),
    [anon_sym_LBRACE] = ACTIONS(507),
    [sym_comment] = ACTIONS(53),
  },
  [630] = {
    [sym__simple_heredoc_body] = ACTIONS(2395),
    [sym__heredoc_body_beginning] = ACTIONS(2395),
    [sym_file_descriptor] = ACTIONS(2395),
    [ts_builtin_sym_end] = ACTIONS(2395),
    [anon_sym_esac] = ACTIONS(2395),
    [anon_sym_PIPE] = ACTIONS(2397),
    [anon_sym_RPAREN] = ACTIONS(2395),
    [anon_sym_SEMI_SEMI] = ACTIONS(2395),
    [anon_sym_PIPE_AMP] = ACTIONS(2395),
    [anon_sym_AMP_AMP] = ACTIONS(2395),
    [anon_sym_PIPE_PIPE] = ACTIONS(2395),
    [anon_sym_LT] = ACTIONS(2397),
    [anon_sym_GT] = ACTIONS(2397),
    [anon_sym_GT_GT] = ACTIONS(2395),
    [anon_sym_AMP_GT] = ACTIONS(2397),
    [anon_sym_AMP_GT_GT] = ACTIONS(2395),
    [anon_sym_LT_AMP] = ACTIONS(2395),
    [anon_sym_GT_AMP] = ACTIONS(2395),
    [anon_sym_LT_LT] = ACTIONS(2397),
    [anon_sym_LT_LT_DASH] = ACTIONS(2395),
    [anon_sym_LT_LT_LT] = ACTIONS(2395),
    [anon_sym_BQUOTE] = ACTIONS(2395),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2397),
    [anon_sym_LF] = ACTIONS(2395),
    [anon_sym_AMP] = ACTIONS(2397),
  },
  [631] = {
    [sym__terminated_statement] = STATE(1148),
    [sym_for_statement] = STATE(536),
    [sym_c_style_for_statement] = STATE(536),
    [sym_while_statement] = STATE(536),
    [sym_if_statement] = STATE(536),
    [sym_case_statement] = STATE(536),
    [sym_function_definition] = STATE(536),
    [sym_subshell] = STATE(536),
    [sym_pipeline] = STATE(536),
    [sym_list] = STATE(536),
    [sym_negated_command] = STATE(536),
    [sym_test_command] = STATE(536),
    [sym_declaration_command] = STATE(536),
    [sym_unset_command] = STATE(536),
    [sym_command] = STATE(536),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(537),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(1148),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_done] = ACTIONS(2399),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [632] = {
    [ts_builtin_sym_end] = ACTIONS(2401),
    [anon_sym_esac] = ACTIONS(2401),
    [anon_sym_PIPE] = ACTIONS(2403),
    [anon_sym_RPAREN] = ACTIONS(2401),
    [anon_sym_SEMI_SEMI] = ACTIONS(2401),
    [anon_sym_PIPE_AMP] = ACTIONS(2401),
    [anon_sym_AMP_AMP] = ACTIONS(2401),
    [anon_sym_PIPE_PIPE] = ACTIONS(2401),
    [anon_sym_BQUOTE] = ACTIONS(2401),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2403),
    [anon_sym_LF] = ACTIONS(2401),
    [anon_sym_AMP] = ACTIONS(2403),
  },
  [633] = {
    [sym_file_redirect] = STATE(532),
    [sym_heredoc_redirect] = STATE(532),
    [sym_heredoc_body] = STATE(1149),
    [sym_herestring_redirect] = STATE(532),
    [aux_sym_while_statement_repeat1] = STATE(532),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(325),
    [ts_builtin_sym_end] = ACTIONS(2401),
    [anon_sym_PIPE] = ACTIONS(2403),
    [anon_sym_SEMI_SEMI] = ACTIONS(2401),
    [anon_sym_PIPE_AMP] = ACTIONS(2401),
    [anon_sym_AMP_AMP] = ACTIONS(2401),
    [anon_sym_PIPE_PIPE] = ACTIONS(2401),
    [anon_sym_LT] = ACTIONS(333),
    [anon_sym_GT] = ACTIONS(333),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(341),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2403),
    [anon_sym_LF] = ACTIONS(2401),
    [anon_sym_AMP] = ACTIONS(2403),
  },
  [634] = {
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(1990),
    [anon_sym_PIPE_AMP] = ACTIONS(443),
    [anon_sym_AMP_AMP] = ACTIONS(1990),
    [anon_sym_PIPE_PIPE] = ACTIONS(1990),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1992),
    [anon_sym_LF] = ACTIONS(1990),
    [anon_sym_AMP] = ACTIONS(1992),
  },
  [635] = {
    [sym_file_descriptor] = ACTIONS(349),
    [sym_variable_name] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(1990),
    [anon_sym_PIPE_AMP] = ACTIONS(443),
    [anon_sym_AMP_AMP] = ACTIONS(1990),
    [anon_sym_PIPE_PIPE] = ACTIONS(1990),
    [anon_sym_LT] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_AMP_GT] = ACTIONS(351),
    [anon_sym_AMP_GT_GT] = ACTIONS(349),
    [anon_sym_LT_AMP] = ACTIONS(349),
    [anon_sym_GT_AMP] = ACTIONS(349),
    [sym__special_characters] = ACTIONS(349),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [sym_raw_string] = ACTIONS(349),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(349),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_LT_LPAREN] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(349),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(1992),
    [anon_sym_LF] = ACTIONS(1990),
    [anon_sym_AMP] = ACTIONS(1992),
  },
  [636] = {
    [sym_concatenation] = STATE(998),
    [sym_string] = STATE(1151),
    [sym_simple_expansion] = STATE(1151),
    [sym_string_expansion] = STATE(1151),
    [sym_expansion] = STATE(1151),
    [sym_command_substitution] = STATE(1151),
    [sym_process_substitution] = STATE(1151),
    [sym__special_characters] = ACTIONS(2405),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(2407),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2407),
  },
  [637] = {
    [aux_sym_concatenation_repeat1] = STATE(240),
    [sym__simple_heredoc_body] = ACTIONS(2022),
    [sym__heredoc_body_beginning] = ACTIONS(2022),
    [sym_file_descriptor] = ACTIONS(2022),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(2024),
    [anon_sym_SEMI_SEMI] = ACTIONS(2022),
    [anon_sym_PIPE_AMP] = ACTIONS(2022),
    [anon_sym_AMP_AMP] = ACTIONS(2022),
    [anon_sym_PIPE_PIPE] = ACTIONS(2022),
    [anon_sym_EQ_TILDE] = ACTIONS(2024),
    [anon_sym_EQ_EQ] = ACTIONS(2024),
    [anon_sym_LT] = ACTIONS(2024),
    [anon_sym_GT] = ACTIONS(2024),
    [anon_sym_GT_GT] = ACTIONS(2022),
    [anon_sym_AMP_GT] = ACTIONS(2024),
    [anon_sym_AMP_GT_GT] = ACTIONS(2022),
    [anon_sym_LT_AMP] = ACTIONS(2022),
    [anon_sym_GT_AMP] = ACTIONS(2022),
    [anon_sym_LT_LT] = ACTIONS(2024),
    [anon_sym_LT_LT_DASH] = ACTIONS(2022),
    [anon_sym_LT_LT_LT] = ACTIONS(2022),
    [sym__special_characters] = ACTIONS(2022),
    [anon_sym_DQUOTE] = ACTIONS(2022),
    [anon_sym_DOLLAR] = ACTIONS(2024),
    [sym_raw_string] = ACTIONS(2022),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2022),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2022),
    [anon_sym_BQUOTE] = ACTIONS(2022),
    [anon_sym_LT_LPAREN] = ACTIONS(2022),
    [anon_sym_GT_LPAREN] = ACTIONS(2022),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2024),
    [anon_sym_SEMI] = ACTIONS(2024),
    [anon_sym_LF] = ACTIONS(2022),
    [anon_sym_AMP] = ACTIONS(2024),
  },
  [638] = {
    [aux_sym_concatenation_repeat1] = STATE(240),
    [sym__simple_heredoc_body] = ACTIONS(2026),
    [sym__heredoc_body_beginning] = ACTIONS(2026),
    [sym_file_descriptor] = ACTIONS(2026),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(2028),
    [anon_sym_SEMI_SEMI] = ACTIONS(2026),
    [anon_sym_PIPE_AMP] = ACTIONS(2026),
    [anon_sym_AMP_AMP] = ACTIONS(2026),
    [anon_sym_PIPE_PIPE] = ACTIONS(2026),
    [anon_sym_EQ_TILDE] = ACTIONS(2028),
    [anon_sym_EQ_EQ] = ACTIONS(2028),
    [anon_sym_LT] = ACTIONS(2028),
    [anon_sym_GT] = ACTIONS(2028),
    [anon_sym_GT_GT] = ACTIONS(2026),
    [anon_sym_AMP_GT] = ACTIONS(2028),
    [anon_sym_AMP_GT_GT] = ACTIONS(2026),
    [anon_sym_LT_AMP] = ACTIONS(2026),
    [anon_sym_GT_AMP] = ACTIONS(2026),
    [anon_sym_LT_LT] = ACTIONS(2028),
    [anon_sym_LT_LT_DASH] = ACTIONS(2026),
    [anon_sym_LT_LT_LT] = ACTIONS(2026),
    [sym__special_characters] = ACTIONS(2026),
    [anon_sym_DQUOTE] = ACTIONS(2026),
    [anon_sym_DOLLAR] = ACTIONS(2028),
    [sym_raw_string] = ACTIONS(2026),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2026),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2026),
    [anon_sym_BQUOTE] = ACTIONS(2026),
    [anon_sym_LT_LPAREN] = ACTIONS(2026),
    [anon_sym_GT_LPAREN] = ACTIONS(2026),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2028),
    [anon_sym_SEMI] = ACTIONS(2028),
    [anon_sym_LF] = ACTIONS(2026),
    [anon_sym_AMP] = ACTIONS(2028),
  },
  [639] = {
    [aux_sym_concatenation_repeat1] = STATE(1152),
    [sym__simple_heredoc_body] = ACTIONS(727),
    [sym__heredoc_body_beginning] = ACTIONS(727),
    [sym_file_descriptor] = ACTIONS(727),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(731),
    [anon_sym_SEMI_SEMI] = ACTIONS(727),
    [anon_sym_PIPE_AMP] = ACTIONS(727),
    [anon_sym_AMP_AMP] = ACTIONS(727),
    [anon_sym_PIPE_PIPE] = ACTIONS(727),
    [anon_sym_LT] = ACTIONS(731),
    [anon_sym_GT] = ACTIONS(731),
    [anon_sym_GT_GT] = ACTIONS(727),
    [anon_sym_AMP_GT] = ACTIONS(731),
    [anon_sym_AMP_GT_GT] = ACTIONS(727),
    [anon_sym_LT_AMP] = ACTIONS(727),
    [anon_sym_GT_AMP] = ACTIONS(727),
    [anon_sym_LT_LT] = ACTIONS(731),
    [anon_sym_LT_LT_DASH] = ACTIONS(727),
    [anon_sym_LT_LT_LT] = ACTIONS(727),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(731),
    [anon_sym_LF] = ACTIONS(727),
    [anon_sym_AMP] = ACTIONS(731),
  },
  [640] = {
    [aux_sym_concatenation_repeat1] = STATE(1152),
    [sym__simple_heredoc_body] = ACTIONS(745),
    [sym__heredoc_body_beginning] = ACTIONS(745),
    [sym_file_descriptor] = ACTIONS(745),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(747),
    [anon_sym_SEMI_SEMI] = ACTIONS(745),
    [anon_sym_PIPE_AMP] = ACTIONS(745),
    [anon_sym_AMP_AMP] = ACTIONS(745),
    [anon_sym_PIPE_PIPE] = ACTIONS(745),
    [anon_sym_LT] = ACTIONS(747),
    [anon_sym_GT] = ACTIONS(747),
    [anon_sym_GT_GT] = ACTIONS(745),
    [anon_sym_AMP_GT] = ACTIONS(747),
    [anon_sym_AMP_GT_GT] = ACTIONS(745),
    [anon_sym_LT_AMP] = ACTIONS(745),
    [anon_sym_GT_AMP] = ACTIONS(745),
    [anon_sym_LT_LT] = ACTIONS(747),
    [anon_sym_LT_LT_DASH] = ACTIONS(745),
    [anon_sym_LT_LT_LT] = ACTIONS(745),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(747),
    [anon_sym_LF] = ACTIONS(745),
    [anon_sym_AMP] = ACTIONS(747),
  },
  [641] = {
    [aux_sym_concatenation_repeat1] = STATE(1152),
    [sym__simple_heredoc_body] = ACTIONS(2034),
    [sym__heredoc_body_beginning] = ACTIONS(2034),
    [sym_file_descriptor] = ACTIONS(2034),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(2036),
    [anon_sym_SEMI_SEMI] = ACTIONS(2034),
    [anon_sym_PIPE_AMP] = ACTIONS(2034),
    [anon_sym_AMP_AMP] = ACTIONS(2034),
    [anon_sym_PIPE_PIPE] = ACTIONS(2034),
    [anon_sym_LT] = ACTIONS(2036),
    [anon_sym_GT] = ACTIONS(2036),
    [anon_sym_GT_GT] = ACTIONS(2034),
    [anon_sym_AMP_GT] = ACTIONS(2036),
    [anon_sym_AMP_GT_GT] = ACTIONS(2034),
    [anon_sym_LT_AMP] = ACTIONS(2034),
    [anon_sym_GT_AMP] = ACTIONS(2034),
    [anon_sym_LT_LT] = ACTIONS(2036),
    [anon_sym_LT_LT_DASH] = ACTIONS(2034),
    [anon_sym_LT_LT_LT] = ACTIONS(2034),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2036),
    [anon_sym_LF] = ACTIONS(2034),
    [anon_sym_AMP] = ACTIONS(2036),
  },
  [642] = {
    [aux_sym_concatenation_repeat1] = STATE(1152),
    [sym__simple_heredoc_body] = ACTIONS(2038),
    [sym__heredoc_body_beginning] = ACTIONS(2038),
    [sym_file_descriptor] = ACTIONS(2038),
    [sym__concat] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(2040),
    [anon_sym_SEMI_SEMI] = ACTIONS(2038),
    [anon_sym_PIPE_AMP] = ACTIONS(2038),
    [anon_sym_AMP_AMP] = ACTIONS(2038),
    [anon_sym_PIPE_PIPE] = ACTIONS(2038),
    [anon_sym_LT] = ACTIONS(2040),
    [anon_sym_GT] = ACTIONS(2040),
    [anon_sym_GT_GT] = ACTIONS(2038),
    [anon_sym_AMP_GT] = ACTIONS(2040),
    [anon_sym_AMP_GT_GT] = ACTIONS(2038),
    [anon_sym_LT_AMP] = ACTIONS(2038),
    [anon_sym_GT_AMP] = ACTIONS(2038),
    [anon_sym_LT_LT] = ACTIONS(2040),
    [anon_sym_LT_LT_DASH] = ACTIONS(2038),
    [anon_sym_LT_LT_LT] = ACTIONS(2038),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2040),
    [anon_sym_LF] = ACTIONS(2038),
    [anon_sym_AMP] = ACTIONS(2040),
  },
  [643] = {
    [sym_file_redirect] = STATE(643),
    [sym_heredoc_redirect] = STATE(643),
    [sym_herestring_redirect] = STATE(643),
    [aux_sym_while_statement_repeat1] = STATE(643),
    [sym__simple_heredoc_body] = ACTIONS(2046),
    [sym__heredoc_body_beginning] = ACTIONS(2046),
    [sym_file_descriptor] = ACTIONS(2409),
    [anon_sym_PIPE] = ACTIONS(2051),
    [anon_sym_SEMI_SEMI] = ACTIONS(2046),
    [anon_sym_PIPE_AMP] = ACTIONS(2046),
    [anon_sym_AMP_AMP] = ACTIONS(2046),
    [anon_sym_PIPE_PIPE] = ACTIONS(2046),
    [anon_sym_LT] = ACTIONS(2412),
    [anon_sym_GT] = ACTIONS(2412),
    [anon_sym_GT_GT] = ACTIONS(2415),
    [anon_sym_AMP_GT] = ACTIONS(2412),
    [anon_sym_AMP_GT_GT] = ACTIONS(2415),
    [anon_sym_LT_AMP] = ACTIONS(2415),
    [anon_sym_GT_AMP] = ACTIONS(2415),
    [anon_sym_LT_LT] = ACTIONS(2059),
    [anon_sym_LT_LT_DASH] = ACTIONS(2062),
    [anon_sym_LT_LT_LT] = ACTIONS(2418),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2051),
    [anon_sym_LF] = ACTIONS(2046),
    [anon_sym_AMP] = ACTIONS(2051),
  },
  [644] = {
    [sym_file_redirect] = STATE(643),
    [sym_heredoc_redirect] = STATE(643),
    [sym_heredoc_body] = STATE(1000),
    [sym_herestring_redirect] = STATE(643),
    [aux_sym_while_statement_repeat1] = STATE(643),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(2044),
    [anon_sym_SEMI_SEMI] = ACTIONS(2042),
    [anon_sym_PIPE_AMP] = ACTIONS(2042),
    [anon_sym_AMP_AMP] = ACTIONS(2042),
    [anon_sym_PIPE_PIPE] = ACTIONS(2042),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(455),
    [anon_sym_AMP_GT] = ACTIONS(453),
    [anon_sym_AMP_GT_GT] = ACTIONS(455),
    [anon_sym_LT_AMP] = ACTIONS(455),
    [anon_sym_GT_AMP] = ACTIONS(455),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(457),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2044),
    [anon_sym_LF] = ACTIONS(2042),
    [anon_sym_AMP] = ACTIONS(2044),
  },
  [645] = {
    [sym_concatenation] = STATE(645),
    [sym_string] = STATE(252),
    [sym_simple_expansion] = STATE(252),
    [sym_string_expansion] = STATE(252),
    [sym_expansion] = STATE(252),
    [sym_command_substitution] = STATE(252),
    [sym_process_substitution] = STATE(252),
    [aux_sym_command_repeat2] = STATE(645),
    [sym__simple_heredoc_body] = ACTIONS(2026),
    [sym__heredoc_body_beginning] = ACTIONS(2026),
    [sym_file_descriptor] = ACTIONS(2026),
    [anon_sym_PIPE] = ACTIONS(2028),
    [anon_sym_SEMI_SEMI] = ACTIONS(2026),
    [anon_sym_PIPE_AMP] = ACTIONS(2026),
    [anon_sym_AMP_AMP] = ACTIONS(2026),
    [anon_sym_PIPE_PIPE] = ACTIONS(2026),
    [anon_sym_EQ_TILDE] = ACTIONS(2421),
    [anon_sym_EQ_EQ] = ACTIONS(2421),
    [anon_sym_LT] = ACTIONS(2028),
    [anon_sym_GT] = ACTIONS(2028),
    [anon_sym_GT_GT] = ACTIONS(2026),
    [anon_sym_AMP_GT] = ACTIONS(2028),
    [anon_sym_AMP_GT_GT] = ACTIONS(2026),
    [anon_sym_LT_AMP] = ACTIONS(2026),
    [anon_sym_GT_AMP] = ACTIONS(2026),
    [anon_sym_LT_LT] = ACTIONS(2028),
    [anon_sym_LT_LT_DASH] = ACTIONS(2026),
    [anon_sym_LT_LT_LT] = ACTIONS(2026),
    [sym__special_characters] = ACTIONS(2424),
    [anon_sym_DQUOTE] = ACTIONS(2074),
    [anon_sym_DOLLAR] = ACTIONS(2077),
    [sym_raw_string] = ACTIONS(2427),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2083),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2086),
    [anon_sym_BQUOTE] = ACTIONS(2089),
    [anon_sym_LT_LPAREN] = ACTIONS(2092),
    [anon_sym_GT_LPAREN] = ACTIONS(2092),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2430),
    [anon_sym_SEMI] = ACTIONS(2028),
    [anon_sym_LF] = ACTIONS(2026),
    [anon_sym_AMP] = ACTIONS(2028),
  },
  [646] = {
    [sym_file_redirect] = STATE(1153),
    [sym_heredoc_redirect] = STATE(1153),
    [sym_heredoc_body] = STATE(1000),
    [sym_herestring_redirect] = STATE(1153),
    [sym_concatenation] = STATE(645),
    [sym_string] = STATE(252),
    [sym_simple_expansion] = STATE(252),
    [sym_string_expansion] = STATE(252),
    [sym_expansion] = STATE(252),
    [sym_command_substitution] = STATE(252),
    [sym_process_substitution] = STATE(252),
    [aux_sym_while_statement_repeat1] = STATE(1153),
    [aux_sym_command_repeat2] = STATE(645),
    [sym__simple_heredoc_body] = ACTIONS(321),
    [sym__heredoc_body_beginning] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(2044),
    [anon_sym_SEMI_SEMI] = ACTIONS(2042),
    [anon_sym_PIPE_AMP] = ACTIONS(2042),
    [anon_sym_AMP_AMP] = ACTIONS(2042),
    [anon_sym_PIPE_PIPE] = ACTIONS(2042),
    [anon_sym_EQ_TILDE] = ACTIONS(451),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(455),
    [anon_sym_AMP_GT] = ACTIONS(453),
    [anon_sym_AMP_GT_GT] = ACTIONS(455),
    [anon_sym_LT_AMP] = ACTIONS(455),
    [anon_sym_GT_AMP] = ACTIONS(455),
    [anon_sym_LT_LT] = ACTIONS(337),
    [anon_sym_LT_LT_DASH] = ACTIONS(339),
    [anon_sym_LT_LT_LT] = ACTIONS(457),
    [sym__special_characters] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(461),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(2044),
    [anon_sym_LF] = ACTIONS(2042),
    [anon_sym_AMP] = ACTIONS(2044),
  },
  [647] = {
    [ts_builtin_sym_end] = ACTIONS(2433),
    [anon_sym_esac] = ACTIONS(2433),
    [anon_sym_PIPE] = ACTIONS(2435),
    [anon_sym_RPAREN] = ACTIONS(2433),
    [anon_sym_SEMI_SEMI] = ACTIONS(2433),
    [anon_sym_PIPE_AMP] = ACTIONS(2433),
    [anon_sym_AMP_AMP] = ACTIONS(2433),
    [anon_sym_PIPE_PIPE] = ACTIONS(2433),
    [anon_sym_BQUOTE] = ACTIONS(2433),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2435),
    [anon_sym_LF] = ACTIONS(2433),
    [anon_sym_AMP] = ACTIONS(2435),
  },
  [648] = {
    [sym__terminated_statement] = STATE(1154),
    [sym_for_statement] = STATE(51),
    [sym_c_style_for_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_case_statement] = STATE(51),
    [sym_function_definition] = STATE(51),
    [sym_subshell] = STATE(51),
    [sym_pipeline] = STATE(51),
    [sym_list] = STATE(51),
    [sym_negated_command] = STATE(51),
    [sym_test_command] = STATE(51),
    [sym_declaration_command] = STATE(51),
    [sym_unset_command] = STATE(51),
    [sym_command] = STATE(51),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(53),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [649] = {
    [sym__terminated_statement] = STATE(1155),
    [sym_for_statement] = STATE(536),
    [sym_c_style_for_statement] = STATE(536),
    [sym_while_statement] = STATE(536),
    [sym_if_statement] = STATE(536),
    [sym_case_statement] = STATE(536),
    [sym_function_definition] = STATE(536),
    [sym_subshell] = STATE(536),
    [sym_pipeline] = STATE(536),
    [sym_list] = STATE(536),
    [sym_negated_command] = STATE(536),
    [sym_test_command] = STATE(536),
    [sym_declaration_command] = STATE(536),
    [sym_unset_command] = STATE(536),
    [sym_command] = STATE(536),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(537),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(1155),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_fi] = ACTIONS(2437),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [650] = {
    [anon_sym_fi] = ACTIONS(2439),
    [anon_sym_elif] = ACTIONS(2439),
    [anon_sym_else] = ACTIONS(2439),
    [sym_comment] = ACTIONS(53),
  },
  [651] = {
    [anon_sym_fi] = ACTIONS(2441),
    [sym_comment] = ACTIONS(53),
  },
  [652] = {
    [sym__terminated_statement] = STATE(1158),
    [sym_for_statement] = STATE(536),
    [sym_c_style_for_statement] = STATE(536),
    [sym_while_statement] = STATE(536),
    [sym_if_statement] = STATE(536),
    [sym_elif_clause] = STATE(650),
    [sym_else_clause] = STATE(1157),
    [sym_case_statement] = STATE(536),
    [sym_function_definition] = STATE(536),
    [sym_subshell] = STATE(536),
    [sym_pipeline] = STATE(536),
    [sym_list] = STATE(536),
    [sym_negated_command] = STATE(536),
    [sym_test_command] = STATE(536),
    [sym_declaration_command] = STATE(536),
    [sym_unset_command] = STATE(536),
    [sym_command] = STATE(536),
    [sym_command_name] = STATE(52),
    [sym_variable_assignment] = STATE(537),
    [sym_subscript] = STATE(54),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(48),
    [sym_simple_expansion] = STATE(48),
    [sym_string_expansion] = STATE(48),
    [sym_expansion] = STATE(48),
    [sym_command_substitution] = STATE(48),
    [sym_process_substitution] = STATE(48),
    [aux_sym__statements_repeat1] = STATE(1158),
    [aux_sym_if_statement_repeat1] = STATE(1159),
    [aux_sym_command_repeat1] = STATE(55),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(69),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_fi] = ACTIONS(2443),
    [anon_sym_elif] = ACTIONS(1211),
    [anon_sym_else] = ACTIONS(1213),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(79),
    [anon_sym_declare] = ACTIONS(81),
    [anon_sym_typeset] = ACTIONS(81),
    [anon_sym_export] = ACTIONS(81),
    [anon_sym_readonly] = ACTIONS(81),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_unset] = ACTIONS(83),
    [anon_sym_unsetenv] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(87),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(89),
  },
  [653] = {
    [sym_elif_clause] = STATE(650),
    [sym_else_clause] = STATE(1157),
    [aux_sym_if_statement_repeat1] = STATE(1160),
    [anon_sym_fi] = ACTIONS(2441),
    [anon_sym_elif] = ACTIONS(2445),
    [anon_sym_else] = ACTIONS(2447),
    [sym_comment] = ACTIONS(53),
  },
  [654] = {
    [sym__concat] = ACTIONS(1762),
    [anon_sym_in] = ACTIONS(1762),
    [anon_sym_SEMI_SEMI] = ACTIONS(1762),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1764),
    [anon_sym_LF] = ACTIONS(1762),
    [anon_sym_AMP] = ACTIONS(1762),
  },
  [655] = {
    [sym_case_item] = STATE(1166),
    [sym_last_case_item] = STATE(1164),
    [sym_concatenation] = STATE(1165),
    [sym_string] = STATE(1163),
    [sym_simple_expansion] = STATE(1163),
    [sym_string_expansion] = STATE(1163),
    [sym_expansion] = STATE(1163),
    [sym_command_substitution] = STATE(1163),
    [sym_process_substitution] = STATE(1163),
    [aux_sym_case_statement_repeat1] = STATE(1166),
    [anon_sym_esac] = ACTIONS(2449),
    [sym__special_characters] = ACTIONS(2451),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(2453),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2455),
  },
  [656] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(2457),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2459),
    [anon_sym_LF] = ACTIONS(2457),
    [anon_sym_AMP] = ACTIONS(2457),
  },
  [657] = {
    [aux_sym_concatenation_repeat1] = STATE(657),
    [sym__concat] = ACTIONS(2461),
    [anon_sym_in] = ACTIONS(1762),
    [anon_sym_SEMI_SEMI] = ACTIONS(1762),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1764),
    [anon_sym_LF] = ACTIONS(1762),
    [anon_sym_AMP] = ACTIONS(1762),
  },
  [658] = {
    [sym__concat] = ACTIONS(1769),
    [anon_sym_in] = ACTIONS(1769),
    [anon_sym_SEMI_SEMI] = ACTIONS(1769),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(1771),
    [anon_sym_LF] = ACTIONS(1769),
    [anon_sym_AMP] = ACTIONS(1769),
  },
  [659] = {
    [anon_sym_DQUOTE] = ACTIONS(2464),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [sym__string_content] = ACTIONS(773),
    [anon_sym_POUND] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(775),
    [sym_comment] = ACTIONS(265),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(777),
    [anon_sym_STAR] = ACTIONS(775),
    [anon_sym_AT] = ACTIONS(775),
    [anon_sym_QMARK] = ACTIONS(775),
    [anon_sym_0] = ACTIONS(771),
    [anon_sym__] = ACTIONS(771),
  },
  [660] = {
    [sym_case_item] = STATE(1171),
    [sym_last_case_item] = STATE(1170),
    [sym_concatenation] = STATE(1165),
    [sym_string] = STATE(1163),
    [sym_simple_expansion] = STATE(1163),
    [sym_string_expansion] = STATE(1163),
    [sym_expansion] = STATE(1163),
    [sym_command_substitution] = STATE(1163),
    [sym_process_substitution] = STATE(1163),
    [aux_sym_case_statement_repeat1] = STATE(1171),
    [anon_sym_esac] = ACTIONS(2466),
    [sym__special_characters] = ACTIONS(2451),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(2453),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2455),
  },
  [661] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(2468),
    [sym_comment] = ACTIONS(53),
    [anon_sym_SEMI] = ACTIONS(2470),
    [anon_sym_LF] = ACTIONS(2468),
    [anon_sym_AMP] = ACTIONS(2468),
  },
  [662] = {
    [sym_concatenation] = STATE(1176),
    [sym_string] = STATE(1175)