/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ByteVector;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.Context;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Item;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.MethodWriter;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.Opcodes;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.TypePath;

public class ClassReader {
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public static final int EXPAND_FRAMES = 8;
    static final int EXPAND_ASM_INSNS = 256;
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;

    public ClassReader(byte[] b2) {
        this(b2, 0, b2.length);
    }

    public ClassReader(byte[] b2, int off, int len) {
        this.b = b2;
        if (this.readShort(off + 6) > 53) {
            throw new IllegalArgumentException();
        }
        this.items = new int[this.readUnsignedShort(off + 8)];
        int n = this.items.length;
        this.strings = new String[n];
        int max2 = 0;
        int index2 = off + 10;
        for (int i2 = 1; i2 < n; ++i2) {
            int size2;
            this.items[i2] = index2 + 1;
            switch (b2[index2]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    size2 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size2 = 9;
                    ++i2;
                    break;
                }
                case 1: {
                    size2 = 3 + this.readUnsignedShort(index2 + 1);
                    if (size2 <= max2) break;
                    max2 = size2;
                    break;
                }
                case 15: {
                    size2 = 4;
                    break;
                }
                default: {
                    size2 = 3;
                }
            }
            index2 += size2;
        }
        this.maxStringLength = max2;
        this.header = index2;
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + 2, new char[this.maxStringLength]);
    }

    public String getSuperName() {
        return this.readClass(this.header + 4, new char[this.maxStringLength]);
    }

    public String[] getInterfaces() {
        int index2 = this.header + 6;
        int n = this.readUnsignedShort(index2);
        String[] interfaces2 = new String[n];
        if (n > 0) {
            char[] buf = new char[this.maxStringLength];
            for (int i2 = 0; i2 < n; ++i2) {
                interfaces2[i2] = this.readClass(index2 += 2, buf);
            }
        }
        return interfaces2;
    }

    void copyPool(ClassWriter classWriter) {
        char[] buf = new char[this.maxStringLength];
        int ll = this.items.length;
        Item[] items2 = new Item[ll];
        for (int i2 = 1; i2 < ll; ++i2) {
            int index2 = this.items[i2];
            byte tag2 = this.b[index2 - 1];
            Item item = new Item(i2);
            switch (tag2) {
                case 9: 
                case 10: 
                case 11: {
                    int nameType = this.items[this.readUnsignedShort(index2 + 2)];
                    item.set(tag2, this.readClass(index2, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 3: {
                    item.set(this.readInt(index2));
                    break;
                }
                case 4: {
                    item.set(Float.intBitsToFloat(this.readInt(index2)));
                    break;
                }
                case 12: {
                    item.set(tag2, this.readUTF8(index2, buf), this.readUTF8(index2 + 2, buf), null);
                    break;
                }
                case 5: {
                    item.set(this.readLong(index2));
                    ++i2;
                    break;
                }
                case 6: {
                    item.set(Double.longBitsToDouble(this.readLong(index2)));
                    ++i2;
                    break;
                }
                case 1: {
                    String s2 = this.strings[i2];
                    if (s2 == null) {
                        index2 = this.items[i2];
                        s2 = this.strings[i2] = this.readUTF(index2 + 2, this.readUnsignedShort(index2), buf);
                    }
                    item.set(tag2, s2, null, null);
                    break;
                }
                case 15: {
                    int fieldOrMethodRef = this.items[this.readUnsignedShort(index2 + 1)];
                    int nameType = this.items[this.readUnsignedShort(fieldOrMethodRef + 2)];
                    item.set(20 + this.readByte(index2), this.readClass(fieldOrMethodRef, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 18: {
                    if (classWriter.bootstrapMethods == null) {
                        this.copyBootstrapMethods(classWriter, items2, buf);
                    }
                    int nameType = this.items[this.readUnsignedShort(index2 + 2)];
                    item.set(this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf), this.readUnsignedShort(index2));
                    break;
                }
                default: {
                    item.set(tag2, this.readUTF8(index2, buf), null, null);
                }
            }
            int index22 = item.hashCode % items2.length;
            item.next = items2[index22];
            items2[index22] = item;
        }
        int off = this.items[1] - 1;
        classWriter.pool.putByteArray(this.b, off, this.header - off);
        classWriter.items = items2;
        classWriter.threshold = (int)(0.75 * (double)ll);
        classWriter.index = ll;
    }

    private void copyBootstrapMethods(ClassWriter classWriter, Item[] items, char[] c) {
        int u = this.getAttributes();
        boolean found = false;
        for (int i2 = this.readUnsignedShort(u); i2 > 0; --i2) {
            String attrName = this.readUTF8(u + 2, c);
            if ("BootstrapMethods".equals(attrName)) {
                found = true;
                break;
            }
            u += 6 + this.readInt(u + 4);
        }
        if (!found) {
            return;
        }
        int boostrapMethodCount = this.readUnsignedShort(u + 8);
        int v = u + 10;
        for (int j = 0; j < boostrapMethodCount; ++j) {
            int position = v - u - 10;
            int hashCode = this.readConst(this.readUnsignedShort(v), c).hashCode();
            for (int k = this.readUnsignedShort(v + 2); k > 0; --k) {
                hashCode ^= this.readConst(this.readUnsignedShort(v + 4), c).hashCode();
                v += 2;
            }
            v += 4;
            Item item = new Item(j);
            item.set(position, hashCode & Integer.MAX_VALUE);
            int index2 = item.hashCode % items.length;
            item.next = items[index2];
            items[index2] = item;
        }
        int attrSize = this.readInt(u + 4);
        ByteVector bootstrapMethods = new ByteVector(attrSize + 62);
        bootstrapMethods.putByteArray(this.b, u + 10, attrSize - 2);
        classWriter.bootstrapMethodsCount = boostrapMethodCount;
        classWriter.bootstrapMethods = bootstrapMethods;
    }

    public ClassReader(InputStream is) throws IOException {
        this(ClassReader.readClass(is, false));
    }

    public ClassReader(String name2) throws IOException {
        this(ClassReader.readClass(ClassLoader.getSystemResourceAsStream(name2.replace('.', '/') + ".class"), true));
    }

    private static byte[] readClass(InputStream is, boolean close2) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        try {
            byte[] b2 = new byte[is.available()];
            int len = 0;
            while (true) {
                int n;
                if ((n = is.read(b2, len, b2.length - len)) == -1) {
                    byte[] c;
                    if (len < b2.length) {
                        c = new byte[len];
                        System.arraycopy(b2, 0, c, 0, len);
                        b2 = c;
                    }
                    c = b2;
                    return c;
                }
                if ((len += n) != b2.length) continue;
                int last2 = is.read();
                if (last2 < 0) {
                    byte[] byArray = b2;
                    return byArray;
                }
                byte[] c = new byte[b2.length + 1000];
                System.arraycopy(b2, 0, c, 0, len);
                c[len++] = (byte)last2;
                b2 = c;
            }
        }
        finally {
            if (close2) {
                is.close();
            }
        }
    }

    public void accept(ClassVisitor classVisitor, int flags2) {
        this.accept(classVisitor, new Attribute[0], flags2);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attrs, int flags2) {
        int i2;
        int u = this.header;
        char[] c = new char[this.maxStringLength];
        Context context = new Context();
        context.attrs = attrs;
        context.flags = flags2;
        context.buffer = c;
        int access = this.readUnsignedShort(u);
        String name2 = this.readClass(u + 2, c);
        String superClass = this.readClass(u + 4, c);
        String[] interfaces2 = new String[this.readUnsignedShort(u + 6)];
        u += 8;
        for (int i3 = 0; i3 < interfaces2.length; ++i3) {
            interfaces2[i3] = this.readClass(u, c);
            u += 2;
        }
        String signature = null;
        String sourceFile = null;
        String sourceDebug = null;
        String enclosingOwner = null;
        String enclosingName = null;
        String enclosingDesc = null;
        String moduleMainClass = null;
        int anns = 0;
        int ianns = 0;
        int tanns = 0;
        int itanns = 0;
        int innerClasses = 0;
        int module = 0;
        int packages = 0;
        Attribute attributes = null;
        u = this.getAttributes();
        for (i2 = this.readUnsignedShort(u); i2 > 0; --i2) {
            String attrName = this.readUTF8(u + 2, c);
            if ("SourceFile".equals(attrName)) {
                sourceFile = this.readUTF8(u + 8, c);
            } else if ("InnerClasses".equals(attrName)) {
                innerClasses = u + 8;
            } else if ("EnclosingMethod".equals(attrName)) {
                enclosingOwner = this.readClass(u + 8, c);
                int item = this.readUnsignedShort(u + 10);
                if (item != 0) {
                    enclosingName = this.readUTF8(this.items[item], c);
                    enclosingDesc = this.readUTF8(this.items[item] + 2, c);
                }
            } else if ("Signature".equals(attrName)) {
                signature = this.readUTF8(u + 8, c);
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = u + 8;
            } else if ("Deprecated".equals(attrName)) {
                access |= 0x20000;
            } else if ("Synthetic".equals(attrName)) {
                access |= 0x41000;
            } else if ("SourceDebugExtension".equals(attrName)) {
                int len = this.readInt(u + 4);
                sourceDebug = this.readUTF(u + 8, len, new char[len]);
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = u + 8;
            } else if ("Module".equals(attrName)) {
                module = u + 8;
            } else if ("ModuleMainClass".equals(attrName)) {
                moduleMainClass = this.readClass(u + 8, c);
            } else if ("ModulePackages".equals(attrName)) {
                packages = u + 10;
            } else if ("BootstrapMethods".equals(attrName)) {
                int[] bootstrapMethods = new int[this.readUnsignedShort(u + 8)];
                int v = u + 10;
                for (int j = 0; j < bootstrapMethods.length; ++j) {
                    bootstrapMethods[j] = v;
                    v += 2 + this.readUnsignedShort(v + 2) << 1;
                }
                context.bootstrapMethods = bootstrapMethods;
            } else {
                Attribute attr2 = this.readAttribute(attrs, attrName, u + 8, this.readInt(u + 4), c, -1, null);
                if (attr2 != null) {
                    attr2.next = attributes;
                    attributes = attr2;
                }
            }
            u += 6 + this.readInt(u + 4);
        }
        classVisitor.visit(this.readInt(this.items[1] - 7), access, name2, signature, superClass, interfaces2);
        if ((flags2 & 2) == 0 && (sourceFile != null || sourceDebug != null)) {
            classVisitor.visitSource(sourceFile, sourceDebug);
        }
        if (module != 0) {
            this.readModule(classVisitor, context, module, moduleMainClass, packages);
        }
        if (enclosingOwner != null) {
            classVisitor.visitOuterClass(enclosingOwner, enclosingName, enclosingDesc);
        }
        if (anns != 0) {
            int v = anns + 2;
            for (i2 = this.readUnsignedShort(anns); i2 > 0; --i2) {
                v = this.readAnnotationValues(v + 2, c, true, classVisitor.visitAnnotation(this.readUTF8(v, c), true));
            }
        }
        if (ianns != 0) {
            int v = ianns + 2;
            for (i2 = this.readUnsignedShort(ianns); i2 > 0; --i2) {
                v = this.readAnnotationValues(v + 2, c, true, classVisitor.visitAnnotation(this.readUTF8(v, c), false));
            }
        }
        if (tanns != 0) {
            int v = tanns + 2;
            for (i2 = this.readUnsignedShort(tanns); i2 > 0; --i2) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, classVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), true));
            }
        }
        if (itanns != 0) {
            int v = itanns + 2;
            for (i2 = this.readUnsignedShort(itanns); i2 > 0; --i2) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, classVisitor.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), false));
            }
        }
        while (attributes != null) {
            Attribute attr3 = attributes.next;
            attributes.next = null;
            classVisitor.visitAttribute(attributes);
            attributes = attr3;
        }
        if (innerClasses != 0) {
            int v = innerClasses + 2;
            for (int i4 = this.readUnsignedShort(innerClasses); i4 > 0; --i4) {
                classVisitor.visitInnerClass(this.readClass(v, c), this.readClass(v + 2, c), this.readUTF8(v + 4, c), this.readUnsignedShort(v + 6));
                v += 8;
            }
        }
        u = this.header + 10 + 2 * interfaces2.length;
        for (i2 = this.readUnsignedShort(u - 2); i2 > 0; --i2) {
            u = this.readField(classVisitor, context, u);
        }
        for (i2 = this.readUnsignedShort((u += 2) - 2); i2 > 0; --i2) {
            u = this.readMethod(classVisitor, context, u);
        }
        classVisitor.visitEnd();
    }

    private void readModule(ClassVisitor classVisitor, Context context, int u, String mainClass, int packages) {
        int j;
        String[] tos;
        int access;
        int i2;
        char[] buffer = context.buffer;
        String name2 = this.readModule(u, buffer);
        int flags2 = this.readUnsignedShort(u + 2);
        String version = this.readUTF8(u + 4, buffer);
        u += 6;
        ModuleVisitor mv = classVisitor.visitModule(name2, flags2, version);
        if (mv == null) {
            return;
        }
        if (mainClass != null) {
            mv.visitMainClass(mainClass);
        }
        if (packages != 0) {
            for (i2 = this.readUnsignedShort(packages - 2); i2 > 0; --i2) {
                String packaze = this.readPackage(packages, buffer);
                mv.visitPackage(packaze);
                packages += 2;
            }
        }
        for (i2 = this.readUnsignedShort((u += 2) - 2); i2 > 0; --i2) {
            String module = this.readModule(u, buffer);
            access = this.readUnsignedShort(u + 2);
            String requireVersion = this.readUTF8(u + 4, buffer);
            mv.visitRequire(module, access, requireVersion);
            u += 6;
        }
        for (i2 = this.readUnsignedShort((u += 2) - 2); i2 > 0; --i2) {
            String export = this.readPackage(u, buffer);
            access = this.readUnsignedShort(u + 2);
            int exportToCount = this.readUnsignedShort(u + 4);
            u += 6;
            tos = null;
            if (exportToCount != 0) {
                tos = new String[exportToCount];
                for (j = 0; j < tos.length; ++j) {
                    tos[j] = this.readModule(u, buffer);
                    u += 2;
                }
            }
            mv.visitExport(export, access, tos);
        }
        for (i2 = this.readUnsignedShort((u += 2) - 2); i2 > 0; --i2) {
            String open2 = this.readPackage(u, buffer);
            access = this.readUnsignedShort(u + 2);
            int openToCount = this.readUnsignedShort(u + 4);
            u += 6;
            tos = null;
            if (openToCount != 0) {
                tos = new String[openToCount];
                for (j = 0; j < tos.length; ++j) {
                    tos[j] = this.readModule(u, buffer);
                    u += 2;
                }
            }
            mv.visitOpen(open2, access, tos);
        }
        for (i2 = this.readUnsignedShort((u += 2) - 2); i2 > 0; --i2) {
            mv.visitUse(this.readClass(u, buffer));
            u += 2;
        }
        for (i2 = this.readUnsignedShort((u += 2) - 2); i2 > 0; --i2) {
            String service = this.readClass(u, buffer);
            int provideWithCount = this.readUnsignedShort(u + 2);
            u += 4;
            String[] withs = new String[provideWithCount];
            for (int j2 = 0; j2 < withs.length; ++j2) {
                withs[j2] = this.readClass(u, buffer);
                u += 2;
            }
            mv.visitProvide(service, withs);
        }
        mv.visitEnd();
    }

    private int readField(ClassVisitor classVisitor, Context context, int u) {
        int v;
        char[] c = context.buffer;
        int access = this.readUnsignedShort(u);
        String name2 = this.readUTF8(u + 2, c);
        String desc = this.readUTF8(u + 4, c);
        u += 6;
        String signature = null;
        int anns = 0;
        int ianns = 0;
        int tanns = 0;
        int itanns = 0;
        Object value2 = null;
        Attribute attributes = null;
        for (int i2 = this.readUnsignedShort(u); i2 > 0; --i2) {
            String attrName = this.readUTF8(u + 2, c);
            if ("ConstantValue".equals(attrName)) {
                int item = this.readUnsignedShort(u + 8);
                value2 = item == 0 ? null : this.readConst(item, c);
            } else if ("Signature".equals(attrName)) {
                signature = this.readUTF8(u + 8, c);
            } else if ("Deprecated".equals(attrName)) {
                access |= 0x20000;
            } else if ("Synthetic".equals(attrName)) {
                access |= 0x41000;
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = u + 8;
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = u + 8;
            } else {
                Attribute attr2 = this.readAttribute(context.attrs, attrName, u + 8, this.readInt(u + 4), c, -1, null);
                if (attr2 != null) {
                    attr2.next = attributes;
                    attributes = attr2;
                }
            }
            u += 6 + this.readInt(u + 4);
        }
        u += 2;
        FieldVisitor fv = classVisitor.visitField(access, name2, desc, signature, value2);
        if (fv == null) {
            return u;
        }
        if (anns != 0) {
            v = anns + 2;
            for (int i3 = this.readUnsignedShort(anns); i3 > 0; --i3) {
                v = this.readAnnotationValues(v + 2, c, true, fv.visitAnnotation(this.readUTF8(v, c), true));
            }
        }
        if (ianns != 0) {
            v = ianns + 2;
            for (int i4 = this.readUnsignedShort(ianns); i4 > 0; --i4) {
                v = this.readAnnotationValues(v + 2, c, true, fv.visitAnnotation(this.readUTF8(v, c), false));
            }
        }
        if (tanns != 0) {
            v = tanns + 2;
            for (int i5 = this.readUnsignedShort(tanns); i5 > 0; --i5) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, fv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), true));
            }
        }
        if (itanns != 0) {
            v = itanns + 2;
            for (int i6 = this.readUnsignedShort(itanns); i6 > 0; --i6) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, fv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), false));
            }
        }
        while (attributes != null) {
            Attribute attr3 = attributes.next;
            attributes.next = null;
            fv.visitAttribute(attributes);
            attributes = attr3;
        }
        fv.visitEnd();
        return u;
    }

    private int readMethod(ClassVisitor classVisitor, Context context, int u) {
        int v;
        char[] c = context.buffer;
        context.access = this.readUnsignedShort(u);
        context.name = this.readUTF8(u + 2, c);
        context.desc = this.readUTF8(u + 4, c);
        u += 6;
        int code = 0;
        int exception2 = 0;
        String[] exceptions = null;
        String signature = null;
        int methodParameters = 0;
        int anns = 0;
        int ianns = 0;
        int tanns = 0;
        int itanns = 0;
        int dann = 0;
        int mpanns = 0;
        int impanns = 0;
        int firstAttribute = u;
        Attribute attributes = null;
        for (int i2 = this.readUnsignedShort(u); i2 > 0; --i2) {
            String attrName = this.readUTF8(u + 2, c);
            if ("Code".equals(attrName)) {
                if ((context.flags & 1) == 0) {
                    code = u + 8;
                }
            } else if ("Exceptions".equals(attrName)) {
                exceptions = new String[this.readUnsignedShort(u + 8)];
                exception2 = u + 10;
                for (int j = 0; j < exceptions.length; ++j) {
                    exceptions[j] = this.readClass(exception2, c);
                    exception2 += 2;
                }
            } else if ("Signature".equals(attrName)) {
                signature = this.readUTF8(u + 8, c);
            } else if ("Deprecated".equals(attrName)) {
                context.access |= 0x20000;
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = u + 8;
            } else if ("AnnotationDefault".equals(attrName)) {
                dann = u + 8;
            } else if ("Synthetic".equals(attrName)) {
                context.access |= 0x41000;
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = u + 8;
            } else if ("RuntimeVisibleParameterAnnotations".equals(attrName)) {
                mpanns = u + 8;
            } else if ("RuntimeInvisibleParameterAnnotations".equals(attrName)) {
                impanns = u + 8;
            } else if ("MethodParameters".equals(attrName)) {
                methodParameters = u + 8;
            } else {
                Attribute attr2 = this.readAttribute(context.attrs, attrName, u + 8, this.readInt(u + 4), c, -1, null);
                if (attr2 != null) {
                    attr2.next = attributes;
                    attributes = attr2;
                }
            }
            u += 6 + this.readInt(u + 4);
        }
        u += 2;
        MethodVisitor mv = classVisitor.visitMethod(context.access, context.name, context.desc, signature, exceptions);
        if (mv == null) {
            return u;
        }
        if (mv instanceof MethodWriter) {
            MethodWriter mw = (MethodWriter)mv;
            if (mw.cw.cr == this && signature == mw.signature) {
                boolean sameExceptions = false;
                if (exceptions == null) {
                    sameExceptions = mw.exceptionCount == 0;
                } else if (exceptions.length == mw.exceptionCount) {
                    sameExceptions = true;
                    for (int j = exceptions.length - 1; j >= 0; --j) {
                        if (mw.exceptions[j] == this.readUnsignedShort(exception2 -= 2)) continue;
                        sameExceptions = false;
                        break;
                    }
                }
                if (sameExceptions) {
                    mw.classReaderOffset = firstAttribute;
                    mw.classReaderLength = u - firstAttribute;
                    return u;
                }
            }
        }
        if (methodParameters != 0) {
            int i3 = this.b[methodParameters] & 0xFF;
            v = methodParameters + 1;
            while (i3 > 0) {
                mv.visitParameter(this.readUTF8(v, c), this.readUnsignedShort(v + 2));
                --i3;
                v += 4;
            }
        }
        if (dann != 0) {
            AnnotationVisitor dv = mv.visitAnnotationDefault();
            this.readAnnotationValue(dann, c, null, dv);
            if (dv != null) {
                dv.visitEnd();
            }
        }
        if (anns != 0) {
            v = anns + 2;
            for (int i4 = this.readUnsignedShort(anns); i4 > 0; --i4) {
                v = this.readAnnotationValues(v + 2, c, true, mv.visitAnnotation(this.readUTF8(v, c), true));
            }
        }
        if (ianns != 0) {
            v = ianns + 2;
            for (int i5 = this.readUnsignedShort(ianns); i5 > 0; --i5) {
                v = this.readAnnotationValues(v + 2, c, true, mv.visitAnnotation(this.readUTF8(v, c), false));
            }
        }
        if (tanns != 0) {
            v = tanns + 2;
            for (int i6 = this.readUnsignedShort(tanns); i6 > 0; --i6) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, mv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), true));
            }
        }
        if (itanns != 0) {
            v = itanns + 2;
            for (int i7 = this.readUnsignedShort(itanns); i7 > 0; --i7) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, mv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), false));
            }
        }
        if (mpanns != 0) {
            this.readParameterAnnotations(mv, context, mpanns, true);
        }
        if (impanns != 0) {
            this.readParameterAnnotations(mv, context, impanns, false);
        }
        while (attributes != null) {
            Attribute attr3 = attributes.next;
            attributes.next = null;
            mv.visitAttribute(attributes);
            attributes = attr3;
        }
        if (code != 0) {
            mv.visitCode();
            this.readCode(mv, context, code);
        }
        mv.visitEnd();
        return u;
    }

    private void readCode(MethodVisitor mv, Context context, int u) {
        int i2;
        byte[] b2 = this.b;
        char[] c = context.buffer;
        int maxStack = this.readUnsignedShort(u);
        int maxLocals = this.readUnsignedShort(u + 2);
        int codeLength = this.readInt(u + 4);
        int codeStart = u += 8;
        int codeEnd = u + codeLength;
        context.labels = new Label[codeLength + 2];
        Label[] labels = context.labels;
        this.createLabel(codeLength + 1, labels);
        block32: while (u < codeEnd) {
            int offset2 = u - codeStart;
            int opcode = b2[u] & 0xFF;
            switch (ClassWriter.TYPE[opcode]) {
                case 0: 
                case 4: {
                    ++u;
                    continue block32;
                }
                case 9: {
                    this.createLabel(offset2 + this.readShort(u + 1), labels);
                    u += 3;
                    continue block32;
                }
                case 18: {
                    this.createLabel(offset2 + this.readUnsignedShort(u + 1), labels);
                    u += 3;
                    continue block32;
                }
                case 10: 
                case 19: {
                    this.createLabel(offset2 + this.readInt(u + 1), labels);
                    u += 5;
                    continue block32;
                }
                case 17: {
                    opcode = b2[u + 1] & 0xFF;
                    if (opcode == 132) {
                        u += 6;
                        continue block32;
                    }
                    u += 4;
                    continue block32;
                }
                case 14: {
                    int i3;
                    u = u + 4 - (offset2 & 3);
                    this.createLabel(offset2 + this.readInt(u), labels);
                    for (i3 = this.readInt(u + 8) - this.readInt(u + 4) + 1; i3 > 0; --i3) {
                        this.createLabel(offset2 + this.readInt(u + 12), labels);
                        u += 4;
                    }
                    u += 12;
                    continue block32;
                }
                case 15: {
                    int i3;
                    u = u + 4 - (offset2 & 3);
                    this.createLabel(offset2 + this.readInt(u), labels);
                    for (i3 = this.readInt(u + 4); i3 > 0; --i3) {
                        this.createLabel(offset2 + this.readInt(u + 12), labels);
                        u += 8;
                    }
                    u += 8;
                    continue block32;
                }
                case 1: 
                case 3: 
                case 11: {
                    u += 2;
                    continue block32;
                }
                case 2: 
                case 5: 
                case 6: 
                case 12: 
                case 13: {
                    u += 3;
                    continue block32;
                }
                case 7: 
                case 8: {
                    u += 5;
                    continue block32;
                }
            }
            u += 4;
        }
        for (int i4 = this.readUnsignedShort(u); i4 > 0; --i4) {
            Label start2 = this.createLabel(this.readUnsignedShort(u + 2), labels);
            Label end2 = this.createLabel(this.readUnsignedShort(u + 4), labels);
            Label handler = this.createLabel(this.readUnsignedShort(u + 6), labels);
            String type2 = this.readUTF8(this.items[this.readUnsignedShort(u + 8)], c);
            mv.visitTryCatchBlock(start2, end2, handler, type2);
            u += 8;
        }
        u += 2;
        int[] tanns = null;
        int[] itanns = null;
        int tann = 0;
        int itann = 0;
        int ntoff = -1;
        int nitoff = -1;
        int varTable = 0;
        int varTypeTable = 0;
        boolean zip2 = true;
        boolean unzip = (context.flags & 8) != 0;
        int stackMap = 0;
        int stackMapSize = 0;
        int frameCount = 0;
        Context frame = null;
        Attribute attributes = null;
        for (i2 = this.readUnsignedShort(u); i2 > 0; --i2) {
            int label2;
            int j;
            int v;
            String attrName = this.readUTF8(u + 2, c);
            if ("LocalVariableTable".equals(attrName)) {
                if ((context.flags & 2) == 0) {
                    varTable = u + 8;
                    v = u;
                    for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                        label2 = this.readUnsignedShort(v + 10);
                        this.createDebugLabel(label2, labels);
                        this.createDebugLabel(label2 += this.readUnsignedShort(v + 12), labels);
                        v += 10;
                    }
                }
            } else if ("LocalVariableTypeTable".equals(attrName)) {
                varTypeTable = u + 8;
            } else if ("LineNumberTable".equals(attrName)) {
                if ((context.flags & 2) == 0) {
                    v = u;
                    for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                        label2 = this.readUnsignedShort(v + 10);
                        this.createDebugLabel(label2, labels);
                        Label l = labels[label2];
                        while (l.line > 0) {
                            if (l.next == null) {
                                l.next = new Label();
                            }
                            l = l.next;
                        }
                        l.line = this.readUnsignedShort(v + 12);
                        v += 4;
                    }
                }
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = this.readTypeAnnotations(mv, context, u + 8, true);
                ntoff = tanns.length == 0 || this.readByte(tanns[0]) < 67 ? -1 : this.readUnsignedShort(tanns[0] + 1);
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = this.readTypeAnnotations(mv, context, u + 8, false);
                nitoff = itanns.length == 0 || this.readByte(itanns[0]) < 67 ? -1 : this.readUnsignedShort(itanns[0] + 1);
            } else if ("StackMapTable".equals(attrName)) {
                if ((context.flags & 4) == 0) {
                    stackMap = u + 10;
                    stackMapSize = this.readInt(u + 4);
                    frameCount = this.readUnsignedShort(u + 8);
                }
            } else if ("StackMap".equals(attrName)) {
                if ((context.flags & 4) == 0) {
                    zip2 = false;
                    stackMap = u + 10;
                    stackMapSize = this.readInt(u + 4);
                    frameCount = this.readUnsignedShort(u + 8);
                }
            } else {
                for (j = 0; j < context.attrs.length; ++j) {
                    Attribute attr2;
                    if (!context.attrs[j].type.equals(attrName) || (attr2 = context.attrs[j].read(this, u + 8, this.readInt(u + 4), c, codeStart - 8, labels)) == null) continue;
                    attr2.next = attributes;
                    attributes = attr2;
                }
            }
            u += 6 + this.readInt(u + 4);
        }
        u += 2;
        if (stackMap != 0) {
            frame = context;
            frame.offset = -1;
            frame.mode = 0;
            frame.localCount = 0;
            frame.localDiff = 0;
            frame.stackCount = 0;
            frame.local = new Object[maxLocals];
            frame.stack = new Object[maxStack];
            if (unzip) {
                this.getImplicitFrame(context);
            }
            for (i2 = stackMap; i2 < stackMap + stackMapSize - 2; ++i2) {
                int v;
                if (b2[i2] != 8 || (v = this.readUnsignedShort(i2 + 1)) < 0 || v >= codeLength || (b2[codeStart + v] & 0xFF) != 187) continue;
                this.createLabel(v, labels);
            }
        }
        if ((context.flags & 0x100) != 0 && (context.flags & 8) != 0) {
            mv.visitFrame(-1, maxLocals, null, 0, null);
        }
        int opcodeDelta = (context.flags & 0x100) == 0 ? -33 : 0;
        boolean insertFrame = false;
        u = codeStart;
        while (u < codeEnd) {
            int offset3 = u - codeStart;
            Label l = labels[offset3];
            if (l != null) {
                Label next2 = l.next;
                l.next = null;
                mv.visitLabel(l);
                if ((context.flags & 2) == 0 && l.line > 0) {
                    mv.visitLineNumber(l.line, l);
                    while (next2 != null) {
                        mv.visitLineNumber(next2.line, l);
                        next2 = next2.next;
                    }
                }
            }
            while (frame != null && (frame.offset == offset3 || frame.offset == -1)) {
                if (frame.offset != -1) {
                    if (!zip2 || unzip) {
                        mv.visitFrame(-1, frame.localCount, frame.local, frame.stackCount, frame.stack);
                    } else {
                        mv.visitFrame(frame.mode, frame.localDiff, frame.local, frame.stackCount, frame.stack);
                    }
                    insertFrame = false;
                }
                if (frameCount > 0) {
                    stackMap = this.readFrame(stackMap, zip2, unzip, frame);
                    --frameCount;
                    continue;
                }
                frame = null;
            }
            if (insertFrame) {
                mv.visitFrame(256, 0, null, 0, null);
                insertFrame = false;
            }
            int opcode = b2[u] & 0xFF;
            switch (ClassWriter.TYPE[opcode]) {
                case 0: {
                    mv.visitInsn(opcode);
                    ++u;
                    break;
                }
                case 4: {
                    if (opcode > 54) {
                        mv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                    } else {
                        mv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                    }
                    ++u;
                    break;
                }
                case 9: {
                    mv.visitJumpInsn(opcode, labels[offset3 + this.readShort(u + 1)]);
                    u += 3;
                    break;
                }
                case 10: {
                    mv.visitJumpInsn(opcode + opcodeDelta, labels[offset3 + this.readInt(u + 1)]);
                    u += 5;
                    break;
                }
                case 18: {
                    opcode = opcode < 218 ? opcode - 49 : opcode - 20;
                    Label target = labels[offset3 + this.readUnsignedShort(u + 1)];
                    if (opcode == 167 || opcode == 168) {
                        mv.visitJumpInsn(opcode + 33, target);
                    } else {
                        opcode = opcode <= 166 ? (opcode + 1 ^ 1) - 1 : opcode ^ 1;
                        Label endif = this.createLabel(offset3 + 3, labels);
                        mv.visitJumpInsn(opcode, endif);
                        mv.visitJumpInsn(200, target);
                        insertFrame = true;
                    }
                    u += 3;
                    break;
                }
                case 19: {
                    mv.visitJumpInsn(200, labels[offset3 + this.readInt(u + 1)]);
                    insertFrame = true;
                    u += 5;
                    break;
                }
                case 17: {
                    opcode = b2[u + 1] & 0xFF;
                    if (opcode == 132) {
                        mv.visitIincInsn(this.readUnsignedShort(u + 2), this.readShort(u + 4));
                        u += 6;
                        break;
                    }
                    mv.visitVarInsn(opcode, this.readUnsignedShort(u + 2));
                    u += 4;
                    break;
                }
                case 14: {
                    u = u + 4 - (offset3 & 3);
                    int label3 = offset3 + this.readInt(u);
                    int min2 = this.readInt(u + 4);
                    int max2 = this.readInt(u + 8);
                    Label[] table = new Label[max2 - min2 + 1];
                    u += 12;
                    for (int i5 = 0; i5 < table.length; ++i5) {
                        table[i5] = labels[offset3 + this.readInt(u)];
                        u += 4;
                    }
                    mv.visitTableSwitchInsn(min2, max2, labels[label3], table);
                    break;
                }
                case 15: {
                    u = u + 4 - (offset3 & 3);
                    int label4 = offset3 + this.readInt(u);
                    int len = this.readInt(u + 4);
                    int[] keys2 = new int[len];
                    Label[] values2 = new Label[len];
                    u += 8;
                    for (int i6 = 0; i6 < len; ++i6) {
                        keys2[i6] = this.readInt(u);
                        values2[i6] = labels[offset3 + this.readInt(u + 4)];
                        u += 8;
                    }
                    mv.visitLookupSwitchInsn(labels[label4], keys2, values2);
                    break;
                }
                case 3: {
                    mv.visitVarInsn(opcode, b2[u + 1] & 0xFF);
                    u += 2;
                    break;
                }
                case 1: {
                    mv.visitIntInsn(opcode, b2[u + 1]);
                    u += 2;
                    break;
                }
                case 2: {
                    mv.visitIntInsn(opcode, this.readShort(u + 1));
                    u += 3;
                    break;
                }
                case 11: {
                    mv.visitLdcInsn(this.readConst(b2[u + 1] & 0xFF, c));
                    u += 2;
                    break;
                }
                case 12: {
                    mv.visitLdcInsn(this.readConst(this.readUnsignedShort(u + 1), c));
                    u += 3;
                    break;
                }
                case 6: 
                case 7: {
                    int cpIndex = this.items[this.readUnsignedShort(u + 1)];
                    boolean itf = b2[cpIndex - 1] == 11;
                    String iowner = this.readClass(cpIndex, c);
                    cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                    String iname = this.readUTF8(cpIndex, c);
                    String idesc = this.readUTF8(cpIndex + 2, c);
                    if (opcode < 182) {
                        mv.visitFieldInsn(opcode, iowner, iname, idesc);
                    } else {
                        mv.visitMethodInsn(opcode, iowner, iname, idesc, itf);
                    }
                    if (opcode == 185) {
                        u += 5;
                        break;
                    }
                    u += 3;
                    break;
                }
                case 8: {
                    int cpIndex = this.items[this.readUnsignedShort(u + 1)];
                    int bsmIndex = context.bootstrapMethods[this.readUnsignedShort(cpIndex)];
                    Handle bsm = (Handle)this.readConst(this.readUnsignedShort(bsmIndex), c);
                    int bsmArgCount = this.readUnsignedShort(bsmIndex + 2);
                    Object[] bsmArgs = new Object[bsmArgCount];
                    bsmIndex += 4;
                    for (int i7 = 0; i7 < bsmArgCount; ++i7) {
                        bsmArgs[i7] = this.readConst(this.readUnsignedShort(bsmIndex), c);
                        bsmIndex += 2;
                    }
                    cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                    String iname = this.readUTF8(cpIndex, c);
                    String idesc = this.readUTF8(cpIndex + 2, c);
                    mv.visitInvokeDynamicInsn(iname, idesc, bsm, bsmArgs);
                    u += 5;
                    break;
                }
                case 5: {
                    mv.visitTypeInsn(opcode, this.readClass(u + 1, c));
                    u += 3;
                    break;
                }
                case 13: {
                    mv.visitIincInsn(b2[u + 1] & 0xFF, b2[u + 2]);
                    u += 3;
                    break;
                }
                default: {
                    mv.visitMultiANewArrayInsn(this.readClass(u + 1, c), b2[u + 3] & 0xFF);
                    u += 4;
                }
            }
            while (tanns != null && tann < tanns.length && ntoff <= offset3) {
                if (ntoff == offset3) {
                    int v = this.readAnnotationTarget(context, tanns[tann]);
                    this.readAnnotationValues(v + 2, c, true, mv.visitInsnAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), true));
                }
                ntoff = ++tann >= tanns.length || this.readByte(tanns[tann]) < 67 ? -1 : this.readUnsignedShort(tanns[tann] + 1);
            }
            while (itanns != null && itann < itanns.length && nitoff <= offset3) {
                if (nitoff == offset3) {
                    int v = this.readAnnotationTarget(context, itanns[itann]);
                    this.readAnnotationValues(v + 2, c, true, mv.visitInsnAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), false));
                }
                nitoff = ++itann >= itanns.length || this.readByte(itanns[itann]) < 67 ? -1 : this.readUnsignedShort(itanns[itann] + 1);
            }
        }
        if (labels[codeLength] != null) {
            mv.visitLabel(labels[codeLength]);
        }
        if ((context.flags & 2) == 0 && varTable != 0) {
            int[] typeTable = null;
            if (varTypeTable != 0) {
                u = varTypeTable + 2;
                typeTable = new int[this.readUnsignedShort(varTypeTable) * 3];
                int i8 = typeTable.length;
                while (i8 > 0) {
                    typeTable[--i8] = u + 6;
                    typeTable[--i8] = this.readUnsignedShort(u + 8);
                    typeTable[--i8] = this.readUnsignedShort(u);
                    u += 10;
                }
            }
            u = varTable + 2;
            for (int i9 = this.readUnsignedShort(varTable); i9 > 0; --i9) {
                int start3 = this.readUnsignedShort(u);
                int length2 = this.readUnsignedShort(u + 2);
                int index2 = this.readUnsignedShort(u + 8);
                String vsignature = null;
                if (typeTable != null) {
                    for (int j = 0; j < typeTable.length; j += 3) {
                        if (typeTable[j] != start3 || typeTable[j + 1] != index2) continue;
                        vsignature = this.readUTF8(typeTable[j + 2], c);
                        break;
                    }
                }
                mv.visitLocalVariable(this.readUTF8(u + 4, c), this.readUTF8(u + 6, c), vsignature, labels[start3], labels[start3 + length2], index2);
                u += 10;
            }
        }
        if (tanns != null) {
            for (int i10 = 0; i10 < tanns.length; ++i10) {
                if (this.readByte(tanns[i10]) >> 1 != 32) continue;
                int v = this.readAnnotationTarget(context, tanns[i10]);
                v = this.readAnnotationValues(v + 2, c, true, mv.visitLocalVariableAnnotation(context.typeRef, context.typePath, context.start, context.end, context.index, this.readUTF8(v, c), true));
            }
        }
        if (itanns != null) {
            for (int i11 = 0; i11 < itanns.length; ++i11) {
                if (this.readByte(itanns[i11]) >> 1 != 32) continue;
                int v = this.readAnnotationTarget(context, itanns[i11]);
                v = this.readAnnotationValues(v + 2, c, true, mv.visitLocalVariableAnnotation(context.typeRef, context.typePath, context.start, context.end, context.index, this.readUTF8(v, c), false));
            }
        }
        while (attributes != null) {
            Attribute attr3 = attributes.next;
            attributes.next = null;
            mv.visitAttribute(attributes);
            attributes = attr3;
        }
        mv.visitMaxs(maxStack, maxLocals);
    }

    private int[] readTypeAnnotations(MethodVisitor mv, Context context, int u, boolean visible) {
        char[] c = context.buffer;
        int[] offsets2 = new int[this.readUnsignedShort(u)];
        u += 2;
        for (int i2 = 0; i2 < offsets2.length; ++i2) {
            offsets2[i2] = u;
            int target = this.readInt(u);
            switch (target >>> 24) {
                case 0: 
                case 1: 
                case 22: {
                    u += 2;
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    ++u;
                    break;
                }
                case 64: 
                case 65: {
                    for (int j = this.readUnsignedShort(u + 1); j > 0; --j) {
                        int start2 = this.readUnsignedShort(u + 3);
                        int length2 = this.readUnsignedShort(u + 5);
                        this.createLabel(start2, context.labels);
                        this.createLabel(start2 + length2, context.labels);
                        u += 6;
                    }
                    u += 3;
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    u += 4;
                    break;
                }
                default: {
                    u += 3;
                }
            }
            int pathLength = this.readByte(u);
            if (target >>> 24 == 66) {
                TypePath path2 = pathLength == 0 ? null : new TypePath(this.b, u);
                u += 1 + 2 * pathLength;
                u = this.readAnnotationValues(u + 2, c, true, mv.visitTryCatchAnnotation(target, path2, this.readUTF8(u, c), visible));
                continue;
            }
            u = this.readAnnotationValues(u + 3 + 2 * pathLength, c, true, null);
        }
        return offsets2;
    }

    private int readAnnotationTarget(Context context, int u) {
        int target = this.readInt(u);
        switch (target >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                target &= 0xFFFF0000;
                u += 2;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                target &= 0xFF000000;
                ++u;
                break;
            }
            case 64: 
            case 65: {
                target &= 0xFF000000;
                int n = this.readUnsignedShort(u + 1);
                context.start = new Label[n];
                context.end = new Label[n];
                context.index = new int[n];
                u += 3;
                for (int i2 = 0; i2 < n; ++i2) {
                    int start2 = this.readUnsignedShort(u);
                    int length2 = this.readUnsignedShort(u + 2);
                    context.start[i2] = this.createLabel(start2, context.labels);
                    context.end[i2] = this.createLabel(start2 + length2, context.labels);
                    context.index[i2] = this.readUnsignedShort(u + 4);
                    u += 6;
                }
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                target &= 0xFF0000FF;
                u += 4;
                break;
            }
            default: {
                target &= target >>> 24 < 67 ? -256 : -16777216;
                u += 3;
            }
        }
        int pathLength = this.readByte(u);
        context.typeRef = target;
        context.typePath = pathLength == 0 ? null : new TypePath(this.b, u);
        return u + 1 + 2 * pathLength;
    }

    private void readParameterAnnotations(MethodVisitor mv, Context context, int v, boolean visible) {
        AnnotationVisitor av;
        int i2;
        int n = this.b[v++] & 0xFF;
        int synthetics = Type.getArgumentTypes(context.desc).length - n;
        for (i2 = 0; i2 < synthetics; ++i2) {
            av = mv.visitParameterAnnotation(i2, "Ljava/lang/Synthetic;", false);
            if (av == null) continue;
            av.visitEnd();
        }
        char[] c = context.buffer;
        while (i2 < n + synthetics) {
            int j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                av = mv.visitParameterAnnotation(i2, this.readUTF8(v, c), visible);
                v = this.readAnnotationValues(v + 2, c, true, av);
                --j;
            }
            ++i2;
        }
    }

    private int readAnnotationValues(int v, char[] buf, boolean named, AnnotationVisitor av) {
        int i2 = this.readUnsignedShort(v);
        v += 2;
        if (named) {
            while (i2 > 0) {
                v = this.readAnnotationValue(v + 2, buf, this.readUTF8(v, buf), av);
                --i2;
            }
        } else {
            while (i2 > 0) {
                v = this.readAnnotationValue(v, buf, null, av);
                --i2;
            }
        }
        if (av != null) {
            av.visitEnd();
        }
        return v;
    }

    private int readAnnotationValue(int v, char[] buf, String name2, AnnotationVisitor av) {
        if (av == null) {
            switch (this.b[v] & 0xFF) {
                case 101: {
                    return v + 5;
                }
                case 64: {
                    return this.readAnnotationValues(v + 3, buf, true, null);
                }
                case 91: {
                    return this.readAnnotationValues(v + 1, buf, false, null);
                }
            }
            return v + 3;
        }
        block5 : switch (this.b[v++] & 0xFF) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                av.visit(name2, this.readConst(this.readUnsignedShort(v), buf));
                v += 2;
                break;
            }
            case 66: {
                av.visit(name2, (byte)this.readInt(this.items[this.readUnsignedShort(v)]));
                v += 2;
                break;
            }
            case 90: {
                av.visit(name2, this.readInt(this.items[this.readUnsignedShort(v)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                v += 2;
                break;
            }
            case 83: {
                av.visit(name2, (short)this.readInt(this.items[this.readUnsignedShort(v)]));
                v += 2;
                break;
            }
            case 67: {
                av.visit(name2, Character.valueOf((char)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 115: {
                av.visit(name2, this.readUTF8(v, buf));
                v += 2;
                break;
            }
            case 101: {
                av.visitEnum(name2, this.readUTF8(v, buf), this.readUTF8(v + 2, buf));
                v += 4;
                break;
            }
            case 99: {
                av.visit(name2, Type.getType(this.readUTF8(v, buf)));
                v += 2;
                break;
            }
            case 64: {
                v = this.readAnnotationValues(v + 2, buf, true, av.visitAnnotation(name2, this.readUTF8(v, buf)));
                break;
            }
            case 91: {
                int size2 = this.readUnsignedShort(v);
                v += 2;
                if (size2 == 0) {
                    return this.readAnnotationValues(v - 2, buf, false, av.visitArray(name2));
                }
                switch (this.b[v++] & 0xFF) {
                    case 66: {
                        byte[] bv = new byte[size2];
                        for (int i2 = 0; i2 < size2; ++i2) {
                            bv[i2] = (byte)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, bv);
                        --v;
                        break block5;
                    }
                    case 90: {
                        boolean[] zv = new boolean[size2];
                        for (int i3 = 0; i3 < size2; ++i3) {
                            zv[i3] = this.readInt(this.items[this.readUnsignedShort(v)]) != 0;
                            v += 3;
                        }
                        av.visit(name2, zv);
                        --v;
                        break block5;
                    }
                    case 83: {
                        short[] sv = new short[size2];
                        for (int i4 = 0; i4 < size2; ++i4) {
                            sv[i4] = (short)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, sv);
                        --v;
                        break block5;
                    }
                    case 67: {
                        char[] cv = new char[size2];
                        for (int i5 = 0; i5 < size2; ++i5) {
                            cv[i5] = (char)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, cv);
                        --v;
                        break block5;
                    }
                    case 73: {
                        int[] iv = new int[size2];
                        for (int i6 = 0; i6 < size2; ++i6) {
                            iv[i6] = this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, iv);
                        --v;
                        break block5;
                    }
                    case 74: {
                        long[] lv = new long[size2];
                        for (int i7 = 0; i7 < size2; ++i7) {
                            lv[i7] = this.readLong(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, lv);
                        --v;
                        break block5;
                    }
                    case 70: {
                        float[] fv = new float[size2];
                        for (int i8 = 0; i8 < size2; ++i8) {
                            fv[i8] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name2, fv);
                        --v;
                        break block5;
                    }
                    case 68: {
                        double[] dv = new double[size2];
                        for (int i9 = 0; i9 < size2; ++i9) {
                            dv[i9] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name2, dv);
                        --v;
                        break block5;
                    }
                }
                v = this.readAnnotationValues(v - 3, buf, false, av.visitArray(name2));
            }
        }
        return v;
    }

    private void getImplicitFrame(Context frame) {
        String desc = frame.desc;
        Object[] locals = frame.local;
        int local2 = 0;
        if ((frame.access & 8) == 0) {
            locals[local2++] = "<init>".equals(frame.name) ? Opcodes.UNINITIALIZED_THIS : this.readClass(this.header + 2, frame.buffer);
        }
        int i2 = 1;
        block8: while (true) {
            int j = i2;
            switch (desc.charAt(i2++)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    locals[local2++] = Opcodes.INTEGER;
                    continue block8;
                }
                case 'F': {
                    locals[local2++] = Opcodes.FLOAT;
                    continue block8;
                }
                case 'J': {
                    locals[local2++] = Opcodes.LONG;
                    continue block8;
                }
                case 'D': {
                    locals[local2++] = Opcodes.DOUBLE;
                    continue block8;
                }
                case '[': {
                    while (desc.charAt(i2) == '[') {
                        ++i2;
                    }
                    if (desc.charAt(i2) == 'L') {
                        ++i2;
                        while (desc.charAt(i2) != ';') {
                            ++i2;
                        }
                    }
                    locals[local2++] = desc.substring(j, ++i2);
                    continue block8;
                }
                case 'L': {
                    while (desc.charAt(i2) != ';') {
                        ++i2;
                    }
                    locals[local2++] = desc.substring(j + 1, i2++);
                    continue block8;
                }
            }
            break;
        }
        frame.localCount = local2;
    }

    private int readFrame(int stackMap, boolean zip2, boolean unzip, Context frame) {
        int delta;
        int tag2;
        char[] c = frame.buffer;
        Label[] labels = frame.labels;
        if (zip2) {
            tag2 = this.b[stackMap++] & 0xFF;
        } else {
            tag2 = 255;
            frame.offset = -1;
        }
        frame.localDiff = 0;
        if (tag2 < 64) {
            delta = tag2;
            frame.mode = 3;
            frame.stackCount = 0;
        } else if (tag2 < 128) {
            delta = tag2 - 64;
            stackMap = this.readFrameType(frame.stack, 0, stackMap, c, labels);
            frame.mode = 4;
            frame.stackCount = 1;
        } else {
            delta = this.readUnsignedShort(stackMap);
            stackMap += 2;
            if (tag2 == 247) {
                stackMap = this.readFrameType(frame.stack, 0, stackMap, c, labels);
                frame.mode = 4;
                frame.stackCount = 1;
            } else if (tag2 >= 248 && tag2 < 251) {
                frame.mode = 2;
                frame.localDiff = 251 - tag2;
                frame.localCount -= frame.localDiff;
                frame.stackCount = 0;
            } else if (tag2 == 251) {
                frame.mode = 3;
                frame.stackCount = 0;
            } else if (tag2 < 255) {
                int local2 = unzip ? frame.localCount : 0;
                for (int i2 = tag2 - 251; i2 > 0; --i2) {
                    stackMap = this.readFrameType(frame.local, local2++, stackMap, c, labels);
                }
                frame.mode = 1;
                frame.localDiff = tag2 - 251;
                frame.localCount += frame.localDiff;
                frame.stackCount = 0;
            } else {
                frame.mode = 0;
                int n = this.readUnsignedShort(stackMap);
                stackMap += 2;
                frame.localDiff = n;
                frame.localCount = n;
                int local3 = 0;
                while (n > 0) {
                    stackMap = this.readFrameType(frame.local, local3++, stackMap, c, labels);
                    --n;
                }
                n = this.readUnsignedShort(stackMap);
                stackMap += 2;
                frame.stackCount = n;
                int stack = 0;
                while (n > 0) {
                    stackMap = this.readFrameType(frame.stack, stack++, stackMap, c, labels);
                    --n;
                }
            }
        }
        frame.offset += delta + 1;
        this.createLabel(frame.offset, labels);
        return stackMap;
    }

    private int readFrameType(Object[] frame, int index2, int v, char[] buf, Label[] labels) {
        int type2 = this.b[v++] & 0xFF;
        switch (type2) {
            case 0: {
                frame[index2] = Opcodes.TOP;
                break;
            }
            case 1: {
                frame[index2] = Opcodes.INTEGER;
                break;
            }
            case 2: {
                frame[index2] = Opcodes.FLOAT;
                break;
            }
            case 3: {
                frame[index2] = Opcodes.DOUBLE;
                break;
            }
            case 4: {
                frame[index2] = Opcodes.LONG;
                break;
            }
            case 5: {
                frame[index2] = Opcodes.NULL;
                break;
            }
            case 6: {
                frame[index2] = Opcodes.UNINITIALIZED_THIS;
                break;
            }
            case 7: {
                frame[index2] = this.readClass(v, buf);
                v += 2;
                break;
            }
            default: {
                frame[index2] = this.createLabel(this.readUnsignedShort(v), labels);
                v += 2;
            }
        }
        return v;
    }

    protected Label readLabel(int offset2, Label[] labels) {
        if (labels[offset2] == null) {
            labels[offset2] = new Label();
        }
        return labels[offset2];
    }

    private Label createLabel(int offset2, Label[] labels) {
        Label label2 = this.readLabel(offset2, labels);
        label2.status &= 0xFFFFFFFE;
        return label2;
    }

    private void createDebugLabel(int offset2, Label[] labels) {
        if (labels[offset2] == null) {
            this.readLabel((int)offset2, (Label[])labels).status |= 1;
        }
    }

    private int getAttributes() {
        int j;
        int i2;
        int u = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;
        for (i2 = this.readUnsignedShort(u); i2 > 0; --i2) {
            for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                u += 6 + this.readInt(u + 12);
            }
            u += 8;
        }
        for (i2 = this.readUnsignedShort(u += 2); i2 > 0; --i2) {
            for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                u += 6 + this.readInt(u + 12);
            }
            u += 8;
        }
        return u + 2;
    }

    private Attribute readAttribute(Attribute[] attrs, String type2, int off, int len, char[] buf, int codeOff, Label[] labels) {
        for (int i2 = 0; i2 < attrs.length; ++i2) {
            if (!attrs[i2].type.equals(type2)) continue;
            return attrs[i2].read(this, off, len, buf, codeOff, labels);
        }
        return new Attribute(type2).read(this, off, len, null, -1, null);
    }

    public int getItemCount() {
        return this.items.length;
    }

    public int getItem(int item) {
        return this.items[item];
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int readByte(int index2) {
        return this.b[index2] & 0xFF;
    }

    public int readUnsignedShort(int index2) {
        byte[] b2 = this.b;
        return (b2[index2] & 0xFF) << 8 | b2[index2 + 1] & 0xFF;
    }

    public short readShort(int index2) {
        byte[] b2 = this.b;
        return (short)((b2[index2] & 0xFF) << 8 | b2[index2 + 1] & 0xFF);
    }

    public int readInt(int index2) {
        byte[] b2 = this.b;
        return (b2[index2] & 0xFF) << 24 | (b2[index2 + 1] & 0xFF) << 16 | (b2[index2 + 2] & 0xFF) << 8 | b2[index2 + 3] & 0xFF;
    }

    public long readLong(int index2) {
        long l1 = this.readInt(index2);
        long l0 = (long)this.readInt(index2 + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index2, char[] buf) {
        int item = this.readUnsignedShort(index2);
        if (index2 == 0 || item == 0) {
            return null;
        }
        String s2 = this.strings[item];
        if (s2 != null) {
            return s2;
        }
        index2 = this.items[item];
        this.strings[item] = this.readUTF(index2 + 2, this.readUnsignedShort(index2), buf);
        return this.strings[item];
    }

    private String readUTF(int index2, int utfLen, char[] buf) {
        int endIndex = index2 + utfLen;
        byte[] b2 = this.b;
        int strLen = 0;
        int st = 0;
        int cc = 0;
        while (index2 < endIndex) {
            int c = b2[index2++];
            switch (st) {
                case 0: {
                    if ((c &= 0xFF) < 128) {
                        buf[strLen++] = (char)c;
                        break;
                    }
                    if (c < 224 && c > 191) {
                        cc = (char)(c & 0x1F);
                        st = 1;
                        break;
                    }
                    cc = (char)(c & 0xF);
                    st = 2;
                    break;
                }
                case 1: {
                    buf[strLen++] = (char)(cc << 6 | c & 0x3F);
                    st = 0;
                    break;
                }
                case 2: {
                    cc = (char)(cc << 6 | c & 0x3F);
                    st = 1;
                }
            }
        }
        return new String(buf, 0, strLen);
    }

    private String readStringish(int index2, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index2)], buf);
    }

    public String readClass(int index2, char[] buf) {
        return this.readStringish(index2, buf);
    }

    public String readModule(int index2, char[] buf) {
        return this.readStringish(index2, buf);
    }

    public String readPackage(int index2, char[] buf) {
        return this.readStringish(index2, buf);
    }

    public Object readConst(int item, char[] buf) {
        int index2 = this.items[item];
        switch (this.b[index2 - 1]) {
            case 3: {
                return this.readInt(index2);
            }
            case 4: {
                return Float.valueOf(Float.intBitsToFloat(this.readInt(index2)));
            }
            case 5: {
                return this.readLong(index2);
            }
            case 6: {
                return Double.longBitsToDouble(this.readLong(index2));
            }
            case 7: {
                return Type.getObjectType(this.readUTF8(index2, buf));
            }
            case 8: {
                return this.readUTF8(index2, buf);
            }
            case 16: {
                return Type.getMethodType(this.readUTF8(index2, buf));
            }
        }
        int tag2 = this.readByte(index2);
        int[] items = this.items;
        int cpIndex = items[this.readUnsignedShort(index2 + 1)];
        boolean itf = this.b[cpIndex - 1] == 11;
        String owner2 = this.readClass(cpIndex, buf);
        cpIndex = items[this.readUnsignedShort(cpIndex + 2)];
        String name2 = this.readUTF8(cpIndex, buf);
        String desc = this.readUTF8(cpIndex + 2, buf);
        return new Handle(tag2, owner2, name2, desc, itf);
    }
}

