/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTManager;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.memory.MemoryJavaNameRenderer;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class LivenessTreeTableView
extends MemoryView {
    private LivenessTreeTableModel treeTableModel;
    private ProfilerTreeTable treeTable;
    private Map<TreeNode, ClientUtils.SourceCodeSelection> nodesMap;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private final boolean includeTotalAllocs;
    private boolean filterObjects = true;
    private boolean filterAllocations = false;
    private boolean searchObjects = true;
    private boolean searchAllocations = false;
    private HideableBarRenderer[] renderers;
    private NumberRenderer[] renderersEx;

    LivenessTreeTableView(Set<ClientUtils.SourceCodeSelection> set, boolean bl) {
        this.selection = set;
        this.includeTotalAllocs = bl;
        this.initUI();
    }

    @Override
    protected RowFilter getExcludesFilter() {
        return new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)entry.getIdentifier();
                CCTNode cCTNode = presoObjAllocCCTNode.getParent();
                if (cCTNode == null) {
                    return true;
                }
                if (cCTNode.getParent() == null) {
                    return !LivenessTreeTableView.this.filterObjects;
                }
                return !LivenessTreeTableView.this.filterAllocations;
            }
        };
    }

    @Override
    protected Component[] getFilterOptions() {
        PopupButton popupButton = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JCheckBoxMenuItem(MemoryView.SEARCH_CLASSES_SCOPE, LivenessTreeTableView.this.filterObjects){
                    {
                        if (!LivenessTreeTableView.this.filterAllocations) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        LivenessTreeTableView.this.filterObjects = !LivenessTreeTableView.this.filterObjects;
                        LivenessTreeTableView.this.enableFilter();
                    }
                });
                jPopupMenu.add(new JCheckBoxMenuItem(MemoryView.FILTER_ALLOCATIONS_SCOPE, LivenessTreeTableView.this.filterAllocations){
                    {
                        if (!LivenessTreeTableView.this.filterObjects) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        LivenessTreeTableView.this.filterAllocations = !LivenessTreeTableView.this.filterAllocations;
                        LivenessTreeTableView.this.enableFilter();
                    }
                });
            }
        };
        popupButton.setToolTipText(FILTER_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), popupButton};
    }

    @Override
    protected SearchUtils.TreeHelper getSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode treeNode) {
                PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)treeNode;
                CCTNode cCTNode = presoObjAllocCCTNode.getParent();
                if (cCTNode == null) {
                    return 100;
                }
                if (cCTNode.getParent() == null) {
                    if (LivenessTreeTableView.this.searchObjects) {
                        return LivenessTreeTableView.this.searchAllocations ? 10 : 11;
                    }
                    return LivenessTreeTableView.this.searchAllocations ? 100 : 101;
                }
                return LivenessTreeTableView.this.searchAllocations ? 10 : 101;
            }
        };
    }

    @Override
    protected Component[] getSearchOptions() {
        PopupButton popupButton = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JCheckBoxMenuItem(MemoryView.SEARCH_CLASSES_SCOPE, LivenessTreeTableView.this.searchObjects){
                    {
                        if (!LivenessTreeTableView.this.searchAllocations) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        LivenessTreeTableView.this.searchObjects = !LivenessTreeTableView.this.searchObjects;
                    }
                });
                jPopupMenu.add(new JCheckBoxMenuItem(MemoryView.SEARCH_ALLOCATIONS_SCOPE, LivenessTreeTableView.this.searchAllocations){
                    {
                        if (!LivenessTreeTableView.this.searchObjects) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        LivenessTreeTableView.this.searchAllocations = !LivenessTreeTableView.this.searchAllocations;
                    }
                });
            }
        };
        popupButton.setToolTipText(SEARCH_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), popupButton};
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    @Override
    public void setData(MemoryResultsSnapshot memoryResultsSnapshot, GenericFilter genericFilter, int n) {
        final boolean bl = genericFilter != null;
        final boolean bl2 = memoryResultsSnapshot instanceof LivenessMemoryResultsDiff;
        final LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot = (LivenessMemoryResultsSnapshot)memoryResultsSnapshot;
        String[] stringArray = livenessMemoryResultsSnapshot.getClassNames();
        long[] lArray = livenessMemoryResultsSnapshot.getNTrackedAllocObjects();
        long[] lArray2 = livenessMemoryResultsSnapshot.getObjectsSizePerClass();
        int[] nArray = livenessMemoryResultsSnapshot.getNTrackedLiveObjects();
        int[] nArray2 = livenessMemoryResultsSnapshot.getnTotalAllocObjects();
        float[] fArray = livenessMemoryResultsSnapshot.getAvgObjectAge();
        int[] nArray3 = livenessMemoryResultsSnapshot.getMaxSurvGen();
        int n2 = Math.min(livenessMemoryResultsSnapshot.getNProfiledClasses(), stringArray.length);
        n2 = Math.min(n2, nArray2.length);
        class Node
        extends PresoObjLivenessCCTNode {
            Node(String string, long l, long l2, int n, int n2, float f, int n32) {
                super(string, l, l2, n, n2, f, n32);
            }

            public CCTNode[] getChildren() {
                if (this.children == null) {
                    MemoryCCTManager memoryCCTManager = new MemoryCCTManager((MemoryResultsSnapshot)livenessMemoryResultsSnapshot, n3, true);
                    PresoObjAllocCCTNode presoObjAllocCCTNode = memoryCCTManager.getRootNode();
                    this.setChildren(presoObjAllocCCTNode == null ? new PresoObjAllocCCTNode[]{} : (PresoObjAllocCCTNode[])presoObjAllocCCTNode.getChildren());
                }
                return this.children;
            }

            public boolean isLeaf() {
                if (this.children == null) {
                    return bl ? this.nCalls == 0L : false;
                }
                return super.isLeaf();
            }

            public int getChildCount() {
                if (this.children == null) {
                    this.getChildren();
                }
                return super.getChildCount();
            }
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        final HashMap<Node, ClientUtils.SourceCodeSelection> hashMap = new HashMap<Node, ClientUtils.SourceCodeSelection>();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        for (int i = 0; i < n2; ++i) {
            Node node;
            if (bl2) {
                l = Math.max(l, lArray2[i]);
                l2 = Math.min(l2, lArray2[i]);
                l3 = Math.max(l3, (long)nArray[i]);
                l4 = Math.min(l4, (long)nArray[i]);
                l5 = Math.max(l5, lArray[i]);
                l6 = Math.min(l6, lArray[i]);
                if (this.includeTotalAllocs) {
                    l7 = Math.max(l7, (long)nArray2[i]);
                    l8 = Math.min(l8, (long)nArray2[i]);
                }
            } else {
                l += lArray2[i];
                l3 += (long)nArray[i];
                l5 += lArray[i];
                if (this.includeTotalAllocs) {
                    l7 += (long)nArray2[i];
                }
            }
            final int n3 = i;
            if (!bl) {
                if (nArray[i] <= 0) continue;
                node = new Node(stringArray[i], lArray[i], lArray2[i], nArray[i], nArray2[i], fArray[i], nArray3[i]);
                arrayList.add(node);
                hashMap.put(node, new ClientUtils.SourceCodeSelection(stringArray[i], "*", null));
                continue;
            }
            if (!genericFilter.passes(stringArray[i].replace('.', '/'))) continue;
            node = new Node(stringArray[i], lArray[i], lArray2[i], nArray[i], nArray2[i], fArray[i], nArray3[i]);
            arrayList.add(node);
            hashMap.put(node, new ClientUtils.SourceCodeSelection(stringArray[i], "*", null));
        }
        final long l9 = !bl2 ? l : Math.max(Math.abs(l), Math.abs(l2));
        final long l10 = !bl2 ? l3 : Math.max(Math.abs(l3), Math.abs(l4));
        final long l11 = !bl2 ? l5 : Math.max(Math.abs(l5), Math.abs(l6));
        final long l12 = !bl2 ? l7 : Math.max(Math.abs(l7), Math.abs(l8));
        final PresoObjLivenessCCTNode presoObjLivenessCCTNode = PresoObjLivenessCCTNode.rootNode((PresoObjLivenessCCTNode[])arrayList.toArray(new PresoObjLivenessCCTNode[0]));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LivenessTreeTableView.this.nodesMap = hashMap;
                LivenessTreeTableView.this.renderers[0].setMaxValue(l9);
                LivenessTreeTableView.this.renderers[1].setMaxValue(l10);
                LivenessTreeTableView.this.renderers[2].setMaxValue(l11);
                if (LivenessTreeTableView.this.includeTotalAllocs) {
                    LivenessTreeTableView.this.renderers[3].setMaxValue(l12);
                }
                LivenessTreeTableView.this.renderers[0].setDiffMode(bl2);
                LivenessTreeTableView.this.renderers[1].setDiffMode(bl2);
                LivenessTreeTableView.this.renderers[2].setDiffMode(bl2);
                if (LivenessTreeTableView.this.includeTotalAllocs) {
                    LivenessTreeTableView.this.renderers[3].setDiffMode(bl2);
                }
                LivenessTreeTableView.this.renderersEx[0].setDiffMode(bl2);
                LivenessTreeTableView.this.renderersEx[1].setDiffMode(bl2);
                LivenessTreeTableView.this.treeTableModel.setRoot((TreeNode)presoObjLivenessCCTNode);
            }
        });
    }

    @Override
    public void resetData() {
        final PresoObjLivenessCCTNode presoObjLivenessCCTNode = PresoObjLivenessCCTNode.rootNode((PresoObjLivenessCCTNode[])new PresoObjLivenessCCTNode[0]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LivenessTreeTableView.this.nodesMap = null;
                LivenessTreeTableView.this.renderers[0].setMaxValue(0L);
                LivenessTreeTableView.this.renderers[1].setMaxValue(0L);
                LivenessTreeTableView.this.renderers[2].setMaxValue(0L);
                if (LivenessTreeTableView.this.includeTotalAllocs) {
                    LivenessTreeTableView.this.renderers[3].setMaxValue(0L);
                }
                LivenessTreeTableView.this.renderers[0].setDiffMode(false);
                LivenessTreeTableView.this.renderers[1].setDiffMode(false);
                LivenessTreeTableView.this.renderers[2].setDiffMode(false);
                if (LivenessTreeTableView.this.includeTotalAllocs) {
                    LivenessTreeTableView.this.renderers[3].setDiffMode(false);
                }
                LivenessTreeTableView.this.renderersEx[0].setDiffMode(false);
                LivenessTreeTableView.this.renderersEx[1].setDiffMode(false);
                LivenessTreeTableView.this.treeTableModel.setRoot((TreeNode)presoObjLivenessCCTNode);
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.treeTable.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.treeTableModel.dataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.treeTable.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.treeTable);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider((ProfilerTable)this.treeTable, EXPORT_ALLOCATED_LIVE);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider((ProfilerTable)this.treeTable, EXPORT_ALLOCATED_LIVE);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.treeTable);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        String[] stringArray;
        int n = this.selection == null ? -1 : 0;
        this.treeTableModel = new LivenessTreeTableModel((TreeNode)PrestimeCPUCCTNode.EMPTY);
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{1 + n}){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
                return LivenessTreeTableView.this.getUserValueForRow(n);
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
                LivenessTreeTableView.this.populatePopup(jPopupMenu, object, (ClientUtils.SourceCodeSelection)object2);
            }

            @Override
            protected void popupShowing() {
                LivenessTreeTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LivenessTreeTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray2[2] = LIVE_COUNT_COLUMN_TOOLTIP;
            stringArray2[3] = ALLOC_COUNT_COLUMN_TOOLTIP;
            stringArray2[4] = AVG_AGE_COLUMN_TOOLTIP;
            stringArray2[5] = GENERATIONS_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[6] = TOTAL_ALLOC_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[8];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray3[3] = LIVE_COUNT_COLUMN_TOOLTIP;
            stringArray3[4] = ALLOC_COUNT_COLUMN_TOOLTIP;
            stringArray3[5] = AVG_AGE_COLUMN_TOOLTIP;
            stringArray3[6] = GENERATIONS_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[7] = TOTAL_ALLOC_COUNT_COLUMN_TOOLTIP;
        }
        this.treeTable.setColumnToolTips(stringArray);
        this.treeTable.providePopupMenu(true);
        this.treeTable.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = LivenessTreeTableView.this.treeTable.getSelectedRow();
                ClientUtils.SourceCodeSelection sourceCodeSelection = LivenessTreeTableView.this.getUserValueForRow(n);
                if (sourceCodeSelection != null) {
                    LivenessTreeTableView.this.performDefaultAction(sourceCodeSelection);
                }
            }
        });
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.makeTreeAutoExpandable(2);
        this.treeTable.setMainColumn(1 + n);
        this.treeTable.setFitWidthColumn(1 + n);
        this.treeTable.setSortColumn(2 + n);
        this.treeTable.setDefaultSortOrder(1 + n, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.treeTable.setColumnVisibility(0, false);
        }
        this.treeTable.setColumnVisibility(5 + n, false);
        if (this.includeTotalAllocs) {
            this.treeTable.setColumnVisibility(7 + n, false);
        }
        this.renderers = new HideableBarRenderer[4];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[2] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[3] = new HideableBarRenderer(new NumberPercentRenderer(){

            @Override
            public void setValue(Object object, int n) {
                if (object == null || ((Number)object).longValue() == -1L) {
                    super.setValue(null, n);
                } else {
                    super.setValue(object, n);
                }
            }
        });
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        this.renderers[2].setMaxValue(12345678L);
        this.renderers[3].setMaxValue(12345678L);
        this.renderersEx = new NumberRenderer[2];
        this.renderersEx[0] = new NumberRenderer(){

            @Override
            protected String getValueString(Object object, int n, Format format) {
                if (object == null) {
                    return "-";
                }
                float f = ((Float)object).floatValue();
                String string = StringUtils.floatPerCentToString((float)f);
                if (this.renderingDiff && f >= 0.0f) {
                    string = '+' + string;
                }
                return string;
            }
        };
        this.renderersEx[1] = new NumberRenderer();
        if (this.selection != null) {
            this.treeTable.setColumnRenderer(0, new CheckBoxRenderer(){
                private boolean visible;

                @Override
                public void setValue(Object object, int n) {
                    TreePath treePath = LivenessTreeTableView.this.treeTable.getPathForRow(n);
                    this.visible = LivenessTreeTableView.this.nodesMap.containsKey((TreeNode)treePath.getLastPathComponent());
                    if (this.visible) {
                        super.setValue(object, n);
                    }
                }

                @Override
                public void paint(Graphics graphics) {
                    if (this.visible) {
                        super.paint(graphics);
                    } else {
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(0, 0, this.size.width, this.size.height);
                    }
                }
            });
        }
        this.treeTable.setTreeCellRenderer(new MemoryJavaNameRenderer());
        this.treeTable.setColumnRenderer(2 + n, this.renderers[0]);
        this.treeTable.setColumnRenderer(3 + n, this.renderers[1]);
        this.treeTable.setColumnRenderer(4 + n, this.renderers[2]);
        this.treeTable.setColumnRenderer(5 + n, this.renderersEx[0]);
        this.treeTable.setColumnRenderer(6 + n, this.renderersEx[1]);
        if (this.includeTotalAllocs) {
            this.treeTable.setColumnRenderer(7 + n, this.renderers[3]);
        }
        if (this.selection != null) {
            int n2 = new JLabel((String)this.treeTable.getColumnName((int)0)).getPreferredSize().width;
            this.treeTable.setDefaultColumnWidth(0, n2 + 15);
        }
        this.treeTable.setDefaultColumnWidth(2 + n, this.renderers[0].getOptimalWidth());
        this.treeTable.setDefaultColumnWidth(3 + n, this.renderers[1].getMaxNoBarWidth());
        this.treeTable.setDefaultColumnWidth(4 + n, this.renderers[2].getMaxNoBarWidth());
        this.treeTable.setDefaultColumnWidth(5 + n, this.renderers[2].getNoBarWidth() - 25);
        if (this.includeTotalAllocs) {
            this.treeTable.setDefaultColumnWidth(7 + n, this.renderers[3].getMaxNoBarWidth());
        }
        ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(this.treeTable, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)profilerTableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = (PresoObjLivenessCCTNode)this.treeTable.getValueForRow(n);
        if (presoObjLivenessCCTNode == null || presoObjLivenessCCTNode.isFiltered()) {
            return null;
        }
        String[] stringArray = presoObjLivenessCCTNode.getMethodClassNameAndSig();
        return new ClientUtils.SourceCodeSelection(stringArray[0], stringArray[1], stringArray[2]);
    }

    private class LivenessTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        private final int columns;

        LivenessTreeTableModel(TreeNode treeNode) {
            super(treeNode);
            this.columns = 6 + (LivenessTreeTableView.this.selection == null ? 0 : 1) + (LivenessTreeTableView.this.includeTotalAllocs ? 1 : 0);
        }

        @Override
        public String getColumnName(int n) {
            if (LivenessTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (n == 2) {
                return MemoryView.COLUMN_LIVE_BYTES;
            }
            if (n == 3) {
                return MemoryView.COLUMN_LIVE_OBJECTS;
            }
            if (n == 4) {
                return MemoryView.COLUMN_ALLOCATED_OBJECTS;
            }
            if (n == 5) {
                return MemoryView.COLUMN_AVG_AGE;
            }
            if (n == 6) {
                return MemoryView.COLUMN_GENERATIONS;
            }
            if (n == 7) {
                return MemoryView.COLUMN_TOTAL_ALLOCATED_OBJECTS;
            }
            if (n == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (LivenessTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return JTree.class;
            }
            if (n == 2) {
                return Long.class;
            }
            if (n == 3) {
                return Integer.class;
            }
            if (n == 4) {
                return Long.class;
            }
            if (n == 5) {
                return Float.class;
            }
            if (n == 6) {
                return Integer.class;
            }
            if (n == 7) {
                return Integer.class;
            }
            if (n == 0) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columns;
        }

        @Override
        public Object getValueAt(TreeNode treeNode, int n) {
            PresoObjLivenessCCTNode presoObjLivenessCCTNode = (PresoObjLivenessCCTNode)treeNode;
            if (LivenessTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return presoObjLivenessCCTNode.getNodeName();
            }
            if (n == 2) {
                return presoObjLivenessCCTNode.totalObjSize;
            }
            if (n == 3) {
                return presoObjLivenessCCTNode.nLiveObjects;
            }
            if (n == 4) {
                return presoObjLivenessCCTNode.nCalls;
            }
            if (n == 5) {
                return Float.valueOf(presoObjLivenessCCTNode.avgObjectAge);
            }
            if (n == 6) {
                return presoObjLivenessCCTNode.survGen;
            }
            if (n == 7) {
                return presoObjLivenessCCTNode.nTotalAllocObjects;
            }
            if (n == 0) {
                if (LivenessTreeTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return LivenessTreeTableView.this.selection.contains(LivenessTreeTableView.this.nodesMap.get(treeNode));
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, TreeNode treeNode, int n) {
            if (LivenessTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 0) {
                if (Boolean.TRUE.equals(object)) {
                    LivenessTreeTableView.this.selection.add(LivenessTreeTableView.this.nodesMap.get(treeNode));
                } else {
                    LivenessTreeTableView.this.selection.remove(LivenessTreeTableView.this.nodesMap.get(treeNode));
                }
            }
        }

        @Override
        public boolean isCellEditable(TreeNode treeNode, int n) {
            if (LivenessTreeTableView.this.selection == null) {
                ++n;
            }
            if (n != 0) {
                return false;
            }
            return LivenessTreeTableView.this.nodesMap.containsKey(treeNode);
        }
    }
}

