/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.rollup.action.DeleteRollupJobAction;
import org.elasticsearch.xpack.core.rollup.job.RollupJob;

public class TransportDeleteRollupJobAction
extends TransportMasterNodeAction<DeleteRollupJobAction.Request, DeleteRollupJobAction.Response> {
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportDeleteRollupJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksService persistentTasksService, ClusterService clusterService) {
        super(settings, "cluster:admin/xpack/rollup/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, DeleteRollupJobAction.Request::new);
        this.persistentTasksService = persistentTasksService;
    }

    protected String executor() {
        return "same";
    }

    protected DeleteRollupJobAction.Response newResponse() {
        return new DeleteRollupJobAction.Response();
    }

    protected void masterOperation(DeleteRollupJobAction.Request request, ClusterState state, final ActionListener<DeleteRollupJobAction.Response> listener) throws Exception {
        final String jobId = request.getId();
        final TimeValue timeout = new TimeValue(60L, TimeUnit.SECONDS);
        this.persistentTasksService.sendRemoveRequest(jobId, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                TransportDeleteRollupJobAction.this.logger.debug("Request to cancel Task for Rollup job [" + jobId + "] successful.");
                TransportDeleteRollupJobAction.this.persistentTasksService.waitForPersistentTaskCondition(jobId, Objects::isNull, timeout, (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<RollupJob>(){

                    public void onResponse(PersistentTasksCustomMetaData.PersistentTask<RollupJob> task) {
                        TransportDeleteRollupJobAction.this.logger.debug("Task for Rollup job [" + jobId + "] successfully canceled.");
                        listener.onResponse((Object)new DeleteRollupJobAction.Response(true));
                    }

                    public void onFailure(Exception e) {
                        TransportDeleteRollupJobAction.this.logger.error("Error while cancelling task for Rollup job [" + jobId + "]." + e);
                        listener.onFailure(e);
                    }

                    public void onTimeout(TimeValue timeout) {
                        String msg = "Stopping of Rollup job [" + jobId + "] timed out after [" + timeout + "].";
                        TransportDeleteRollupJobAction.this.logger.warn(msg);
                        listener.onFailure((Exception)new ElasticsearchException(msg, new Object[0]));
                    }
                });
            }

            public void onFailure(Exception e) {
                TransportDeleteRollupJobAction.this.logger.error("Error while requesting to cancel task for Rollup job [" + jobId + "]" + e);
                listener.onFailure(e);
            }
        });
    }

    protected ClusterBlockException checkBlock(DeleteRollupJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

