/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.SearchHit;

public final class ScrollHelper {
    private ScrollHelper() {
    }

    public static <T> void fetchAllByEntity(final Client client, final SearchRequest request, final ActionListener<Collection<T>> listener, final Function<SearchHit, T> hitParser) {
        final ArrayList results = new ArrayList();
        if (request.scroll() == null) {
            request.scroll(TimeValue.timeValueSeconds((long)10L));
        }
        final Consumer<SearchResponse> clearScroll = response -> {
            if (response != null && response.getScrollId() != null) {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(response.getScrollId());
                client.clearScroll(clearScrollRequest, ActionListener.wrap(r -> {}, e -> {}));
            }
        };
        client.search(request, (ActionListener)new ContextPreservingActionListener(client.threadPool().getThreadContext().newRestorableContext(true), (ActionListener)new ActionListener<SearchResponse>(){
            private volatile SearchResponse lastResponse = null;

            public void onResponse(SearchResponse resp) {
                try {
                    this.lastResponse = resp;
                    if (resp.getHits().getHits().length > 0) {
                        for (SearchHit hit : resp.getHits().getHits()) {
                            Object oneResult = hitParser.apply(hit);
                            if (oneResult == null) continue;
                            results.add(oneResult);
                        }
                        if ((long)results.size() > resp.getHits().getTotalHits()) {
                            clearScroll.accept(this.lastResponse);
                            listener.onFailure((Exception)new IllegalStateException("scrolling returned more hits [" + results.size() + "] than expected [" + resp.getHits().getTotalHits() + "] so bailing out to prevent unbounded memory consumption."));
                        } else if ((long)results.size() == resp.getHits().getTotalHits()) {
                            clearScroll.accept(resp);
                            listener.onResponse(Collections.unmodifiableList(results));
                        } else {
                            SearchScrollRequest scrollRequest = new SearchScrollRequest(resp.getScrollId());
                            scrollRequest.scroll(request.scroll().keepAlive());
                            client.searchScroll(scrollRequest, (ActionListener)this);
                        }
                    } else {
                        clearScroll.accept(resp);
                        listener.onResponse(Collections.unmodifiableList(results));
                    }
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception t) {
                try {
                    clearScroll.accept(this.lastResponse);
                }
                finally {
                    if (t instanceof IndexNotFoundException) {
                        listener.onResponse(Collections.emptyList());
                    } else {
                        listener.onFailure(t);
                    }
                }
            }
        }));
    }
}

