/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.script.ExplainableSearchScript;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.Script;

public class ScriptScoreFunction
extends ScoreFunction {
    private final Script sScript;
    private final ScoreScript.LeafFactory script;

    public ScriptScoreFunction(Script sScript, ScoreScript.LeafFactory script) {
        super(CombineFunction.REPLACE);
        this.sScript = sScript;
        this.script = script;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) throws IOException {
        final ScoreScript leafScript = this.script.newInstance(ctx);
        final CannedScorer scorer = new CannedScorer();
        leafScript.setScorer(scorer);
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) throws IOException {
                leafScript.setDocument(docId);
                scorer.docid = docId;
                scorer.score = subQueryScore;
                double result = leafScript.execute();
                return result;
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                if (!(leafScript instanceof ExplainableSearchScript)) {
                    double score = this.score(docId, subQueryScore.getValue());
                    String explanation = "script score function, computed with script:\"" + ScriptScoreFunction.this.sScript + "\"";
                    if (ScriptScoreFunction.this.sScript.getParams() != null) {
                        explanation = explanation + " and parameters: \n" + ScriptScoreFunction.this.sScript.getParams().toString();
                    }
                    Explanation scoreExp = Explanation.match(subQueryScore.getValue(), "_score: ", subQueryScore);
                    return Explanation.match((float)score, explanation, scoreExp);
                }
                leafScript.setDocument(docId);
                scorer.docid = docId;
                scorer.score = subQueryScore.getValue();
                Explanation exp = ((ExplainableSearchScript)((Object)leafScript)).explain(subQueryScore);
                return exp;
            }
        };
    }

    @Override
    public boolean needsScores() {
        return this.script.needs_score();
    }

    public String toString() {
        return "script" + this.sScript.toString();
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        ScriptScoreFunction scriptScoreFunction = (ScriptScoreFunction)other;
        return Objects.equals(this.sScript, scriptScoreFunction.sScript);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.sScript);
    }

    static final class CannedScorer
    extends Scorer {
        protected int docid;
        protected float score;

        CannedScorer() {
            super(null);
        }

        @Override
        public int docID() {
            return this.docid;
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }

        @Override
        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

