/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.PersistentCredentialsAuthenticationStrategy;
import org.elasticsearch.client.RestClient;

public final class RestClientBuilder {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 1000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_MAX_RETRY_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_MAX_CONN_PER_ROUTE = 10;
    public static final int DEFAULT_MAX_CONN_TOTAL = 30;
    private static final Header[] EMPTY_HEADERS = new Header[0];
    private final List<Node> nodes;
    private int maxRetryTimeout = 30000;
    private Header[] defaultHeaders = EMPTY_HEADERS;
    private RestClient.FailureListener failureListener;
    private HttpClientConfigCallback httpClientConfigCallback;
    private RequestConfigCallback requestConfigCallback;
    private String pathPrefix;
    private NodeSelector nodeSelector = NodeSelector.ANY;

    RestClientBuilder(List<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        for (Node node : nodes) {
            if (node != null) continue;
            throw new IllegalArgumentException("node cannot be null");
        }
        this.nodes = nodes;
    }

    public RestClientBuilder setDefaultHeaders(Header[] defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders must not be null");
        for (Header defaultHeader : defaultHeaders) {
            Objects.requireNonNull(defaultHeader, "default header must not be null");
        }
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public RestClientBuilder setFailureListener(RestClient.FailureListener failureListener) {
        Objects.requireNonNull(failureListener, "failureListener must not be null");
        this.failureListener = failureListener;
        return this;
    }

    public RestClientBuilder setMaxRetryTimeoutMillis(int maxRetryTimeoutMillis) {
        if (maxRetryTimeoutMillis <= 0) {
            throw new IllegalArgumentException("maxRetryTimeoutMillis must be greater than 0");
        }
        this.maxRetryTimeout = maxRetryTimeoutMillis;
        return this;
    }

    public RestClientBuilder setHttpClientConfigCallback(HttpClientConfigCallback httpClientConfigCallback) {
        Objects.requireNonNull(httpClientConfigCallback, "httpClientConfigCallback must not be null");
        this.httpClientConfigCallback = httpClientConfigCallback;
        return this;
    }

    public RestClientBuilder setRequestConfigCallback(RequestConfigCallback requestConfigCallback) {
        Objects.requireNonNull(requestConfigCallback, "requestConfigCallback must not be null");
        this.requestConfigCallback = requestConfigCallback;
        return this;
    }

    public RestClientBuilder setPathPrefix(String pathPrefix) {
        Objects.requireNonNull(pathPrefix, "pathPrefix must not be null");
        if (pathPrefix.isEmpty()) {
            throw new IllegalArgumentException("pathPrefix must not be empty");
        }
        String cleanPathPrefix = pathPrefix;
        if (!cleanPathPrefix.startsWith("/")) {
            cleanPathPrefix = "/" + cleanPathPrefix;
        }
        if (cleanPathPrefix.endsWith("/") && cleanPathPrefix.length() > 1 && (cleanPathPrefix = cleanPathPrefix.substring(0, cleanPathPrefix.length() - 1)).endsWith("/")) {
            throw new IllegalArgumentException("pathPrefix is malformed. too many trailing slashes: [" + pathPrefix + "]");
        }
        this.pathPrefix = cleanPathPrefix;
        return this;
    }

    public RestClientBuilder setNodeSelector(NodeSelector nodeSelector) {
        Objects.requireNonNull(nodeSelector, "nodeSelector must not be null");
        this.nodeSelector = nodeSelector;
        return this;
    }

    public RestClient build() {
        if (this.failureListener == null) {
            this.failureListener = new RestClient.FailureListener();
        }
        CloseableHttpAsyncClient httpClient = AccessController.doPrivileged(new PrivilegedAction<CloseableHttpAsyncClient>(){

            @Override
            public CloseableHttpAsyncClient run() {
                return RestClientBuilder.this.createHttpClient();
            }
        });
        RestClient restClient = new RestClient(httpClient, this.maxRetryTimeout, this.defaultHeaders, this.nodes, this.pathPrefix, this.failureListener, this.nodeSelector);
        httpClient.start();
        return restClient;
    }

    private CloseableHttpAsyncClient createHttpClient() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(1000).setSocketTimeout(30000);
        if (this.requestConfigCallback != null) {
            requestConfigBuilder = this.requestConfigCallback.customizeRequestConfig(requestConfigBuilder);
        }
        try {
            HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build()).setMaxConnPerRoute(10).setMaxConnTotal(30).setSSLContext(SSLContext.getDefault()).setTargetAuthenticationStrategy((AuthenticationStrategy)new PersistentCredentialsAuthenticationStrategy());
            if (this.httpClientConfigCallback != null) {
                httpClientBuilder = this.httpClientConfigCallback.customizeHttpClient(httpClientBuilder);
            }
            final HttpAsyncClientBuilder finalBuilder = httpClientBuilder;
            return AccessController.doPrivileged(new PrivilegedAction<CloseableHttpAsyncClient>(){

                @Override
                public CloseableHttpAsyncClient run() {
                    return finalBuilder.build();
                }
            });
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("could not create the default ssl context", e);
        }
    }

    public static interface HttpClientConfigCallback {
        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder var1);
    }

    public static interface RequestConfigCallback {
        public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder var1);
    }
}

