/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessClass;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;

final class PSubMapShortcut
extends AStoreable {
    private final PainlessClass struct;
    private AExpression index;
    private PainlessMethod getter;
    private PainlessMethod setter;

    PSubMapShortcut(Location location, PainlessClass struct, AExpression index) {
        super(location);
        this.struct = Objects.requireNonNull(struct);
        this.index = Objects.requireNonNull(index);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        this.getter = this.struct.methods.get(PainlessLookupUtility.buildPainlessMethodKey("get", 1));
        this.setter = this.struct.methods.get(PainlessLookupUtility.buildPainlessMethodKey("put", 2));
        if (this.getter != null && (this.getter.rtn == Void.TYPE || this.getter.arguments.size() != 1)) {
            throw this.createError(new IllegalArgumentException("Illegal map get shortcut for type [" + this.struct.name + "]."));
        }
        if (this.setter != null && this.setter.arguments.size() != 2) {
            throw this.createError(new IllegalArgumentException("Illegal map set shortcut for type [" + this.struct.name + "]."));
        }
        if (!(this.getter == null || this.setter == null || this.getter.arguments.get(0).equals(this.setter.arguments.get(0)) && this.getter.rtn.equals(this.setter.arguments.get(1)))) {
            throw this.createError(new IllegalArgumentException("Shortcut argument types must match."));
        }
        if (!this.read && !this.write || this.read && this.getter == null || this.write && this.setter == null) {
            throw this.createError(new IllegalArgumentException("Illegal map shortcut for type [" + this.struct.name + "]."));
        }
        this.index.expected = this.setter != null ? this.setter.arguments.get(0) : this.getter.arguments.get(0);
        this.index.analyze(locals);
        this.index = this.index.cast(locals);
        this.actual = this.setter != null ? this.setter.arguments.get(1) : this.getter.rtn;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        this.index.write(writer, globals);
        writer.writeDebugInfo(this.location);
        this.getter.write(writer);
        if (this.getter.rtn != this.getter.handle.type().returnType()) {
            writer.checkCast(MethodWriter.getType(this.getter.rtn));
        }
    }

    @Override
    int accessElementCount() {
        return 2;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Class<?> actual) {
        throw new IllegalArgumentException("Illegal tree structure.");
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
        this.index.write(writer, globals);
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        this.getter.write(writer);
        if (this.getter.rtn != this.getter.handle.type().returnType()) {
            writer.checkCast(MethodWriter.getType(this.getter.rtn));
        }
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        this.setter.write(writer);
        writer.writePop(MethodWriter.getType(this.setter.rtn).getSize());
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.index);
    }
}

