/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedDeleteRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedDeleteResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedDeleteOperation
extends InterceptedOperation
implements InMemoryInterceptedDeleteRequest,
InMemoryInterceptedDeleteResult {
    private DeleteRequest deleteRequest;
    private LDAPResult deleteResult;

    InterceptedDeleteOperation(LDAPListenerClientConnection clientConnection, int messageID, DeleteRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.deleteRequest = requestOp.toDeleteRequest(requestControls);
        this.deleteResult = null;
    }

    public ReadOnlyDeleteRequest getRequest() {
        return this.deleteRequest;
    }

    public void setRequest(DeleteRequest deleteRequest) {
        this.deleteRequest = deleteRequest;
    }

    public LDAPResult getResult() {
        return this.deleteResult;
    }

    public void setResult(LDAPResult deleteResult) {
        this.deleteResult = deleteResult;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("InterceptedDeleteOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.deleteRequest);
        buffer.append(", result=");
        buffer.append(this.deleteResult);
        buffer.append(')');
    }
}

