/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public abstract class AbstractScopedSettings
extends AbstractComponent {
    public static final String ARCHIVED_SETTINGS_PREFIX = "archived.";
    private Settings lastSettingsApplied = Settings.EMPTY;
    private final List<SettingUpdater<?>> settingUpdaters = new CopyOnWriteArrayList();
    private final Map<String, Setting<?>> complexMatchers;
    private final Map<String, Setting<?>> keySettings;
    private final Setting.Property scope;
    private static final Pattern KEY_PATTERN = Pattern.compile("^(?:[-\\w]+[.])*[-\\w]+$");
    private static final Pattern GROUP_KEY_PATTERN = Pattern.compile("^(?:[-\\w]+[.])+$");
    private static final Pattern AFFIX_KEY_PATTERN = Pattern.compile("^(?:[-\\w]+[.])+[*](?:[.][-\\w]+)+$");

    protected AbstractScopedSettings(Settings settings, Set<Setting<?>> settingsSet, Setting.Property scope) {
        super(settings);
        this.lastSettingsApplied = Settings.EMPTY;
        this.scope = scope;
        HashMap complexMatchers = new HashMap();
        HashMap keySettings = new HashMap();
        for (Setting<?> setting : settingsSet) {
            if (!setting.getProperties().contains((Object)scope)) {
                throw new IllegalArgumentException("Setting must be a " + (Object)((Object)scope) + " setting but has: " + setting.getProperties());
            }
            this.validateSettingKey(setting);
            if (setting.hasComplexMatcher()) {
                Setting<?> overlappingSetting = AbstractScopedSettings.findOverlappingSetting(setting, complexMatchers);
                if (overlappingSetting != null) {
                    throw new IllegalArgumentException("complex setting key: [" + setting.getKey() + "] overlaps existing setting key: [" + overlappingSetting.getKey() + "]");
                }
                complexMatchers.putIfAbsent(setting.getKey(), setting);
                continue;
            }
            keySettings.putIfAbsent(setting.getKey(), setting);
        }
        this.complexMatchers = Collections.unmodifiableMap(complexMatchers);
        this.keySettings = Collections.unmodifiableMap(keySettings);
    }

    protected void validateSettingKey(Setting setting) {
        if (!AbstractScopedSettings.isValidKey(setting.getKey()) && !(setting.isGroupSetting() && AbstractScopedSettings.isValidGroupKey(setting.getKey()) || AbstractScopedSettings.isValidAffixKey(setting.getKey())) || setting.getKey().endsWith(".0")) {
            throw new IllegalArgumentException("illegal settings key: [" + setting.getKey() + "]");
        }
    }

    protected AbstractScopedSettings(Settings nodeSettings, Settings scopeSettings, AbstractScopedSettings other) {
        super(nodeSettings);
        this.lastSettingsApplied = scopeSettings;
        this.scope = other.scope;
        this.complexMatchers = other.complexMatchers;
        this.keySettings = other.keySettings;
        this.settingUpdaters.addAll(other.settingUpdaters);
    }

    public static boolean isValidKey(String key) {
        return KEY_PATTERN.matcher(key).matches();
    }

    private static boolean isValidGroupKey(String key) {
        return GROUP_KEY_PATTERN.matcher(key).matches();
    }

    static boolean isValidAffixKey(String key) {
        return AFFIX_KEY_PATTERN.matcher(key).matches();
    }

    public Setting.Property getScope() {
        return this.scope;
    }

    public synchronized Settings validateUpdate(Settings settings) {
        Settings current = Settings.builder().put(this.settings).put(settings).build();
        Settings previous = Settings.builder().put(this.settings).put(this.lastSettingsApplied).build();
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        for (SettingUpdater<?> settingUpdater : this.settingUpdaters) {
            try {
                settingUpdater.getValue(current, previous);
            }
            catch (RuntimeException ex) {
                exceptions.add(ex);
                this.logger.debug(() -> new ParameterizedMessage("failed to prepareCommit settings for [{}]", (Object)settingUpdater), (Throwable)ex);
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
        return current;
    }

    public synchronized Settings applySettings(Settings newSettings) {
        if (this.lastSettingsApplied != null && newSettings.equals(this.lastSettingsApplied)) {
            return newSettings;
        }
        Settings current = Settings.builder().put(this.settings).put(newSettings).build();
        Settings previous = Settings.builder().put(this.settings).put(this.lastSettingsApplied).build();
        try {
            ArrayList<Runnable> applyRunnables = new ArrayList<Runnable>();
            for (SettingUpdater<?> settingUpdater : this.settingUpdaters) {
                try {
                    applyRunnables.add(settingUpdater.updater(current, previous));
                }
                catch (Exception ex) {
                    this.logger.warn(() -> new ParameterizedMessage("failed to prepareCommit settings for [{}]", settingUpdater), (Throwable)ex);
                    throw ex;
                }
            }
            for (Runnable runnable : applyRunnables) {
                runnable.run();
            }
        }
        catch (Exception ex) {
            this.logger.warn("failed to apply settings", (Throwable)ex);
            throw ex;
        }
        this.lastSettingsApplied = newSettings;
        return this.lastSettingsApplied;
    }

    public synchronized <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer, Consumer<T> validator) {
        if (setting != this.get(setting.getKey())) {
            throw new IllegalArgumentException("Setting is not registered for key [" + setting.getKey() + "]");
        }
        this.addSettingsUpdater(setting.newUpdater(consumer, this.logger, validator));
    }

    public synchronized void addSettingsUpdateConsumer(Consumer<Settings> consumer, List<? extends Setting<?>> settings) {
        this.addSettingsUpdater(Setting.groupedSettingsUpdater(consumer, this.logger, settings));
    }

    public synchronized <T> void addAffixUpdateConsumer(Setting.AffixSetting<T> setting, BiConsumer<String, T> consumer, BiConsumer<String, T> validator) {
        Setting<?> registeredSetting = this.complexMatchers.get(setting.getKey());
        if (setting != registeredSetting) {
            throw new IllegalArgumentException("Setting is not registered for key [" + setting.getKey() + "]");
        }
        this.addSettingsUpdater(setting.newAffixUpdater(consumer, this.logger, validator));
    }

    public synchronized <T> void addAffixMapUpdateConsumer(Setting.AffixSetting<T> setting, Consumer<Map<String, T>> consumer, BiConsumer<String, T> validator, boolean omitDefaults) {
        Setting<?> registeredSetting = this.complexMatchers.get(setting.getKey());
        if (setting != registeredSetting) {
            throw new IllegalArgumentException("Setting is not registered for key [" + setting.getKey() + "]");
        }
        this.addSettingsUpdater(setting.newAffixMapUpdater(consumer, this.logger, validator, omitDefaults));
    }

    synchronized void addSettingsUpdater(SettingUpdater<?> updater) {
        this.settingUpdaters.add(updater);
    }

    public synchronized <A, B> void addSettingsUpdateConsumer(Setting<A> a, Setting<B> b, BiConsumer<A, B> consumer) {
        this.addSettingsUpdateConsumer(a, b, consumer, (i, j) -> {});
    }

    public synchronized <A, B> void addSettingsUpdateConsumer(Setting<A> a, Setting<B> b, BiConsumer<A, B> consumer, BiConsumer<A, B> validator) {
        if (a != this.get(a.getKey())) {
            throw new IllegalArgumentException("Setting is not registered for key [" + a.getKey() + "]");
        }
        if (b != this.get(b.getKey())) {
            throw new IllegalArgumentException("Setting is not registered for key [" + b.getKey() + "]");
        }
        this.addSettingsUpdater(Setting.compoundUpdater(consumer, validator, a, b, this.logger));
    }

    public synchronized <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer) {
        this.addSettingsUpdateConsumer(setting, consumer, (T s) -> {});
    }

    public final void validate(Settings settings, boolean validateDependencies) {
        this.validate(settings, validateDependencies, false, false);
    }

    public final void validate(Settings settings, boolean validateDependencies, boolean validateInternalIndex) {
        this.validate(settings, validateDependencies, false, false, validateInternalIndex);
    }

    public final void validate(Settings settings, boolean validateDependencies, boolean ignorePrivateSettings, boolean ignoreArchivedSettings) {
        this.validate(settings, validateDependencies, ignorePrivateSettings, ignoreArchivedSettings, false);
    }

    public final void validate(Settings settings, boolean validateDependencies, boolean ignorePrivateSettings, boolean ignoreArchivedSettings, boolean validateInternalIndex) {
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        for (String key : settings.keySet()) {
            if (this.isPrivateSetting(key) && ignorePrivateSettings || key.startsWith(ARCHIVED_SETTINGS_PREFIX) && ignoreArchivedSettings) continue;
            try {
                this.validate(key, settings, validateDependencies, validateInternalIndex);
            }
            catch (RuntimeException ex) {
                exceptions.add(ex);
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    void validate(String key, Settings settings, boolean validateDependencies) {
        this.validate(key, settings, validateDependencies, false);
    }

    void validate(String key, Settings settings, boolean validateDependencies, boolean validateInternalIndex) {
        Setting<?> setting = this.getRaw(key);
        if (setting == null) {
            LevensteinDistance ld = new LevensteinDistance();
            ArrayList<Tuple> scoredKeys = new ArrayList<Tuple>();
            for (String k : this.keySettings.keySet()) {
                float distance = ld.getDistance(key, k);
                if (!(distance > 0.7f)) continue;
                scoredKeys.add(new Tuple((Object)Float.valueOf(distance), (Object)k));
            }
            CollectionUtil.timSort(scoredKeys, (a, b) -> ((Float)b.v1()).compareTo((Float)a.v1()));
            String msgPrefix = "unknown setting";
            SecureSettings secureSettings = settings.getSecureSettings();
            if (secureSettings != null && settings.getSecureSettings().getSettingNames().contains(key)) {
                msgPrefix = "unknown secure setting";
            }
            String msg = msgPrefix + " [" + key + "]";
            List keys = scoredKeys.stream().map(a -> (String)a.v2()).collect(Collectors.toList());
            msg = !keys.isEmpty() ? msg + " did you mean " + (keys.size() == 1 ? "[" + (String)keys.get(0) + "]" : "any of " + keys.toString()) + "?" : msg + " please check that any required plugins are installed, or check the breaking changes documentation for removed settings";
            throw new IllegalArgumentException(msg);
        }
        Set<String> settingsDependencies = setting.getSettingsDependencies(key);
        if (setting.hasComplexMatcher()) {
            setting = setting.getConcreteSetting(key);
        }
        if (validateDependencies && !settingsDependencies.isEmpty()) {
            Set<String> settingKeys = settings.keySet();
            for (String requiredSetting : settingsDependencies) {
                if (settingKeys.contains(requiredSetting)) continue;
                throw new IllegalArgumentException("Missing required setting [" + requiredSetting + "] for setting [" + setting.getKey() + "]");
            }
        }
        if (validateInternalIndex && setting.getProperties().contains((Object)Setting.Property.InternalIndex)) {
            throw new IllegalArgumentException("can not update internal setting [" + setting.getKey() + "]; this setting is managed via a dedicated API");
        }
        setting.get(settings);
    }

    public final Setting<?> get(String key) {
        Setting<?> raw = this.getRaw(key);
        if (raw == null) {
            return null;
        }
        if (raw.hasComplexMatcher()) {
            return raw.getConcreteSetting(key);
        }
        return raw;
    }

    private Setting<?> getRaw(String key) {
        Setting<?> setting = this.keySettings.get(key);
        if (setting != null) {
            return setting;
        }
        for (Map.Entry<String, Setting<?>> entry : this.complexMatchers.entrySet()) {
            if (!entry.getValue().match(key)) continue;
            assert (this.assertMatcher(key, 1));
            assert (entry.getValue().hasComplexMatcher());
            return entry.getValue();
        }
        return null;
    }

    private boolean assertMatcher(String key, int numComplexMatchers) {
        ArrayList list = new ArrayList();
        for (Map.Entry<String, Setting<?>> entry : this.complexMatchers.entrySet()) {
            if (!entry.getValue().match(key)) continue;
            list.add(entry.getValue().getConcreteSetting(key));
        }
        assert (list.size() == numComplexMatchers) : "Expected " + numComplexMatchers + " complex matchers to match key [" + key + "] but got: " + ((Object)list).toString();
        return true;
    }

    public boolean isDynamicSetting(String key) {
        Setting<?> setting = this.get(key);
        return setting != null && setting.isDynamic();
    }

    public boolean isFinalSetting(String key) {
        Setting<?> setting = this.get(key);
        return setting != null && setting.isFinal();
    }

    public Settings diff(Settings source, Settings defaultSettings) {
        Settings.Builder builder = Settings.builder();
        for (Setting<?> setting : this.keySettings.values()) {
            setting.diff(builder, source, defaultSettings);
        }
        for (Setting<?> setting : this.complexMatchers.values()) {
            setting.diff(builder, source, defaultSettings);
        }
        return builder.build();
    }

    public <T> T get(Setting<T> setting) {
        if (!setting.getProperties().contains((Object)this.scope)) {
            throw new IllegalArgumentException("settings scope doesn't match the setting scope [" + (Object)((Object)this.scope) + "] not in [" + setting.getProperties() + "]");
        }
        if (this.get(setting.getKey()) == null) {
            throw new IllegalArgumentException("setting " + setting.getKey() + " has not been registered");
        }
        return setting.get(this.lastSettingsApplied, this.settings);
    }

    public boolean updateDynamicSettings(Settings toApply, Settings.Builder target, Settings.Builder updates, String type) {
        return this.updateSettings(toApply, target, updates, type, true);
    }

    public boolean updateSettings(Settings toApply, Settings.Builder target, Settings.Builder updates, String type) {
        return this.updateSettings(toApply, target, updates, type, false);
    }

    private boolean isValidDelete(String key, boolean onlyDynamic) {
        return !this.isFinalSetting(key) && (onlyDynamic && this.isDynamicSetting(key) || this.get(key) == null && key.startsWith(ARCHIVED_SETTINGS_PREFIX) || !onlyDynamic && this.get(key) != null);
    }

    private boolean updateSettings(Settings toApply, Settings.Builder target, Settings.Builder updates, String type, boolean onlyDynamic) {
        boolean changed = false;
        HashSet<String> toRemove = new HashSet<String>();
        Settings.Builder settingsBuilder = Settings.builder();
        Predicate<String> canUpdate = key -> !this.isFinalSetting((String)key) && (!onlyDynamic && this.get((String)key) != null || this.isDynamicSetting((String)key));
        for (String key2 : toApply.keySet()) {
            boolean isDelete;
            boolean bl = isDelete = !toApply.hasValue(key2);
            if (isDelete && (this.isValidDelete(key2, onlyDynamic) || key2.endsWith("*"))) {
                toRemove.add(key2);
                continue;
            }
            if (this.get(key2) == null) {
                throw new IllegalArgumentException(type + " setting [" + key2 + "], not recognized");
            }
            if (!isDelete && canUpdate.test(key2)) {
                this.validate(key2, toApply, false);
                settingsBuilder.copy(key2, toApply);
                updates.copy(key2, toApply);
                changed = true;
                continue;
            }
            if (this.isFinalSetting(key2)) {
                throw new IllegalArgumentException("final " + type + " setting [" + key2 + "], not updateable");
            }
            throw new IllegalArgumentException(type + " setting [" + key2 + "], not dynamically updateable");
        }
        target.put(settingsBuilder.build());
        return changed |= AbstractScopedSettings.applyDeletes(toRemove, target, k -> this.isValidDelete((String)k, onlyDynamic));
    }

    private static boolean applyDeletes(Set<String> deletes, Settings.Builder builder, Predicate<String> canRemove) {
        boolean changed = false;
        for (String entry : deletes) {
            HashSet<String> keysToRemove = new HashSet<String>();
            Set<String> keySet = builder.keys();
            for (String key : keySet) {
                if (!Regex.simpleMatch(entry, key) || !canRemove.test(key)) continue;
                keysToRemove.add(key);
            }
            for (String key : keysToRemove) {
                builder.remove(key);
                changed = true;
            }
        }
        return changed;
    }

    private static Setting<?> findOverlappingSetting(Setting<?> newSetting, Map<String, Setting<?>> complexMatchers) {
        assert (newSetting.hasComplexMatcher());
        if (complexMatchers.containsKey(newSetting.getKey())) {
            return null;
        }
        for (Setting<?> existingSetting : complexMatchers.values()) {
            if (!newSetting.match(existingSetting.getKey()) && !existingSetting.match(newSetting.getKey())) continue;
            return existingSetting;
        }
        return null;
    }

    public Settings archiveUnknownOrInvalidSettings(Settings settings, Consumer<Map.Entry<String, String>> unknownConsumer, BiConsumer<Map.Entry<String, String>, IllegalArgumentException> invalidConsumer) {
        Settings.Builder builder = Settings.builder();
        boolean changed = false;
        for (String key : settings.keySet()) {
            try {
                Setting<?> setting = this.get(key);
                if (setting != null) {
                    setting.get(settings);
                    builder.copy(key, settings);
                    continue;
                }
                if (key.startsWith(ARCHIVED_SETTINGS_PREFIX) || this.isPrivateSetting(key)) {
                    builder.copy(key, settings);
                    continue;
                }
                changed = true;
                unknownConsumer.accept(new Entry(key, settings));
                builder.copy(ARCHIVED_SETTINGS_PREFIX + key, key, settings);
            }
            catch (IllegalArgumentException ex) {
                changed = true;
                invalidConsumer.accept(new Entry(key, settings), ex);
                builder.copy(ARCHIVED_SETTINGS_PREFIX + key, key, settings);
            }
        }
        if (changed) {
            return builder.build();
        }
        return settings;
    }

    public boolean isPrivateSetting(String key) {
        return false;
    }

    private static final class Entry
    implements Map.Entry<String, String> {
        private final String key;
        private final Settings settings;

        private Entry(String key, Settings settings) {
            this.key = key;
            this.settings = settings;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.settings.get(this.key);
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface SettingUpdater<T> {
        public boolean hasChanged(Settings var1, Settings var2);

        public T getValue(Settings var1, Settings var2);

        public void apply(T var1, Settings var2, Settings var3);

        default public boolean apply(Settings current, Settings previous) {
            if (this.hasChanged(current, previous)) {
                T value = this.getValue(current, previous);
                this.apply(value, current, previous);
                return true;
            }
            return false;
        }

        default public Runnable updater(Settings current, Settings previous) {
            if (this.hasChanged(current, previous)) {
                T value = this.getValue(current, previous);
                return () -> this.apply(value, current, previous);
            }
            return () -> {};
        }
    }
}

