/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;

public class ChainTaskExecutor {
    private final ExecutorService executorService;
    private final boolean shortCircuit;
    private final LinkedList<ChainTask> tasks = new LinkedList();

    public ChainTaskExecutor(ExecutorService executorService, boolean shortCircuit) {
        this.executorService = Objects.requireNonNull(executorService);
        this.shortCircuit = shortCircuit;
    }

    public synchronized void add(ChainTask task) {
        this.tasks.add(task);
    }

    public synchronized void execute(final ActionListener<Void> listener) {
        if (this.tasks.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        final ChainTask task = this.tasks.pop();
        this.executorService.execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                if (ChainTaskExecutor.this.shortCircuit) {
                    listener.onFailure(e);
                } else {
                    ChainTaskExecutor.this.execute((ActionListener<Void>)listener);
                }
            }

            protected void doRun() {
                task.run((ActionListener<Void>)ActionListener.wrap(nullValue -> ChainTaskExecutor.this.execute((ActionListener<Void>)listener), this::onFailure));
            }
        });
    }

    public static interface ChainTask {
        public void run(ActionListener<Void> var1);
    }
}

