/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.script.T;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class SymmetryDesc {
    private ModelSet modelSet;
    private static final String[] keys = new String[]{"xyz", "xyzOriginal", "label", null, "fractionalTranslation", "cartesianTranslation", "inversionCenter", null, "axisVector", "rotationAngle", "matrix", "unitTranslation", "centeringVector", "timeReversal", "plane", "_type", "id"};

    public SymmetryDesc set(ModelSet modelSet) {
        this.modelSet = modelSet;
        return this;
    }

    Object getSymopInfo(int iAtom, String xyz, int op, P3 pt, P3 pt2, String id, int type, float scaleFactor, int nth) {
        String ret;
        if (type == 0) {
            type = SymmetryDesc.getType(id);
        }
        String string = ret = type == 0x44000001 ? new BS() : "";
        if (iAtom < 0) {
            return ret;
        }
        short iModel = this.modelSet.at[iAtom].mi;
        SymmetryInterface uc = this.modelSet.am[iModel].biosymmetry;
        if (uc == null && (uc = this.modelSet.getUnitCell((int)iModel)) == null) {
            return ret;
        }
        if (type != 135176 || op != Integer.MAX_VALUE) {
            return this.getSymmetryInfo((Symmetry)uc, iModel, iAtom, (Symmetry)uc, xyz, op, pt, pt2, id, type, scaleFactor, nth);
        }
        String s = "";
        M4[] ops = uc.getSymmetryOperations();
        if (ops != null) {
            if (id == null) {
                id = "sg";
            }
            int n = ops.length;
            for (op = 0; op < n; ++op) {
                s = s + (String)this.getSymmetryInfo((Symmetry)uc, iModel, iAtom, (Symmetry)uc, xyz, op, pt, pt2, id + op, 135176, scaleFactor, nth);
            }
        }
        return s;
    }

    Map<String, Object> getSpaceGroupInfo(Symmetry sym, int modelIndex, String sgName, int symOp, P3 pt1, P3 pt2, String drawID, float scaleFactor, int nth, boolean isFull, boolean isForModel) {
        Object data;
        boolean haveRawName;
        Map<String, Object> info = null;
        SymmetryInterface cellInfo = null;
        boolean isStandard = pt1 == null && drawID == null && nth <= 0;
        boolean isBio = false;
        String sgNote = null;
        boolean haveName = sgName != null && sgName.length() > 0;
        boolean bl = haveRawName = haveName && sgName.indexOf("[--]") >= 0;
        if (isForModel || !haveName) {
            boolean saveModelInfo;
            boolean bl2 = saveModelInfo = isStandard && symOp == 0;
            if (modelIndex < 0) {
                modelIndex = pt1 instanceof Atom ? ((Atom)pt1).mi : this.modelSet.vwr.am.cmi;
            }
            if (modelIndex < 0) {
                sgNote = "no single current model";
            } else {
                cellInfo = this.modelSet.am[modelIndex].biosymmetry;
                isBio = cellInfo != null;
                if (!isBio && (cellInfo = this.modelSet.getUnitCell(modelIndex)) == null) {
                    sgNote = "not applicable";
                }
            }
            if (sgNote != null) {
                info = new Hashtable();
                info.put("spaceGroupInfo", "");
                info.put("spaceGroupNote", sgNote);
                info.put("symmetryInfo", "");
            } else if (isStandard) {
                info = (Map)this.modelSet.getInfo(modelIndex, "spaceGroupInfo");
            }
            if (info != null) {
                return info;
            }
            info = new Hashtable();
            sgName = cellInfo.getSpaceGroupName();
            SymmetryOperation[] ops = (SymmetryOperation[])cellInfo.getSymmetryOperations();
            SpaceGroup sg = isBio ? ((Symmetry)cellInfo).spaceGroup : null;
            String slist = haveRawName ? "" : null;
            int opCount = 0;
            if (ops != null) {
                if (isBio) {
                    sym.spaceGroup = SpaceGroup.getNull(false, false, false);
                } else {
                    sym.setSpaceGroup(false);
                }
                if (ops[0].timeReversal != 0) {
                    ((SymmetryOperation)sym.getSpaceGroupOperation((int)0)).timeReversal = 1;
                }
                Object[][] infolist = new Object[ops.length][];
                String sops = "";
                int nop = 0;
                for (int i = 0; i < ops.length && nop != nth; ++i) {
                    Object[] ret;
                    int iop;
                    boolean isNewIncomm;
                    SymmetryOperation op = ops[i];
                    boolean bl3 = isNewIncomm = i == 0 && op.xyz.indexOf("x4") >= 0;
                    int n = !isNewIncomm && sym.getSpaceGroupOperation(i) != null ? i : (iop = isBio ? sym.addBioMoleculeOperation(sg.finalOperations[i], false) : sym.addSpaceGroupOperation("=" + op.xyz, i + 1));
                    if (iop < 0 || (op = (SymmetryOperation)sym.getSpaceGroupOperation(i)) == null) continue;
                    if (op.timeReversal != 0 || op.modDim > 0) {
                        isStandard = false;
                    }
                    if (slist != null) {
                        slist = slist + ";" + op.xyz;
                    }
                    Object[] objectArray = ret = symOp > 0 && symOp - 1 != iop ? null : this.createInfoArray(op, cellInfo, pt1, pt2, drawID, scaleFactor);
                    if (ret != null) {
                        if (nth > 0 && ++nop != nth) continue;
                        infolist[i] = ret;
                        sops = sops + "\n" + (i + 1) + "\t" + ret[0] + "\t" + ret[2];
                        ++opCount;
                    }
                    info.put("operations", infolist);
                }
                info.put("symmetryInfo", sops.length() == 0 ? "" : sops.substring(1));
            }
            String string = opCount == 0 ? "\n no symmetry operations" : (nth <= 0 && symOp <= 0 ? "\n" + opCount + " symmetry operation" + (opCount == 1 ? ":\n" : "s:\n") : (sgNote = ""));
            if (slist != null) {
                sgName = slist.substring(slist.indexOf(";") + 1);
            }
            if (saveModelInfo) {
                this.modelSet.setInfo(modelIndex, (Object)"spaceGroupInfo", info);
            }
        } else {
            info = new Hashtable<String, Object>();
        }
        info.put("spaceGroupName", sgName);
        info.put("spaceGroupNote", sgNote == null ? "" : sgNote);
        if (isBio) {
            data = sgName;
        } else {
            if (haveName && !haveRawName) {
                sym.setSpaceGroupName(sgName);
            }
            if ((data = sym.getSpaceGroupInfoObj(sgName, cellInfo, isFull)) == null || data.equals("?")) {
                data = "could not identify space group from name: " + sgName + "\nformat: show spacegroup \"2\" or \"P 2c\" or \"C m m m\" or \"x, y, z;-x ,-y, -z\"";
            }
        }
        info.put("spaceGroupInfo", data);
        return info;
    }

    private static int getType(String id) {
        if (id == null) {
            return 1073742001;
        }
        if (id.equalsIgnoreCase("matrix")) {
            return 12;
        }
        if (id.equalsIgnoreCase("description")) {
            return 1825200146;
        }
        if (id.equalsIgnoreCase("axispoint")) {
            return 134217751;
        }
        if (id.equalsIgnoreCase("time")) {
            return 0x100000B1;
        }
        if (id.equalsIgnoreCase("info")) {
            return 1275068418;
        }
        int type = T.getTokFromName((String)id);
        if (type != 0) {
            return type;
        }
        for (type = 0; type < keys.length; ++type) {
            if (!id.equalsIgnoreCase(keys[type])) continue;
            return -1 - type;
        }
        return 1073741961;
    }

    private static Object getInfo(Object[] info, int type) {
        if (info == null) {
            return "";
        }
        if (type < 0 && type >= -keys.length) {
            return info[-1 - type];
        }
        switch (type) {
            case 1073742327: {
                return info;
            }
            case 1275068418: {
                Hashtable<String, Object> lst = new Hashtable<String, Object>();
                int n = info.length;
                for (int j = 0; j < n; ++j) {
                    if (keys[j] == null || info[j] == null) continue;
                    lst.put(keys[j], info[j]);
                }
                return lst;
            }
            case 0x8000001: {
                return info[9];
            }
            case 1073741854: {
                return info[8];
            }
            case 12289: {
                return info[6];
            }
            case 135176: {
                return info[3] + "\nprint " + PT.esc((String)(info[0] + " " + info[2]));
            }
            case 1073741961: {
                return info[0] + "  \t" + info[2];
            }
            case 1073741982: {
                return info;
            }
            default: {
                return info[2];
            }
            case 12: {
                return info[10];
            }
            case 134217751: {
                return info[7];
            }
            case 0x100000B1: {
                return info[13];
            }
            case 134217750: {
                return info[14];
            }
            case 1073742178: {
                return info[5];
            }
            case 1814695966: {
                return info[11];
            }
            case 1145047050: {
                return info[0];
            }
            case 1073741974: 
        }
        return info[16];
    }

    private Object[] createInfoArray(SymmetryOperation op, SymmetryInterface uc, P3 pta00, P3 ptTarget, String id, float scaleFactor) {
        String xyzNew;
        String info1;
        V3 trans;
        boolean haveInversion;
        boolean isTimeReversed;
        if (!op.isFinalized) {
            op.doFinalize();
        }
        boolean bl = isTimeReversed = op.timeReversal == -1;
        if (scaleFactor == 0.0f) {
            scaleFactor = 1.0f;
        }
        V3 vtemp = new V3();
        P3 ptemp = new P3();
        P3 ptemp2 = new P3();
        P3 pta01 = new P3();
        P3 pta02 = new P3();
        V3 ftrans = new V3();
        V3 vtrans = new V3();
        P4 plane = null;
        if (pta00 == null || Float.isNaN(pta00.x)) {
            pta00 = new P3();
        }
        if (ptTarget != null) {
            SymmetryDesc.setFractional(uc, (T3)pta00, pta01, ptemp);
            op.rotTrans((T3)pta01);
            uc.toCartesian((T3)pta01, false);
            uc.toUnitCell((T3)pta01, (T3)ptemp);
            pta02.setT((T3)ptTarget);
            uc.toUnitCell((T3)pta02, (T3)ptemp);
            if (pta01.distance((T3)pta02) > 0.1f) {
                return null;
            }
            SymmetryDesc.setFractional(uc, (T3)pta00, pta01, null);
            op.rotTrans((T3)pta01);
            SymmetryDesc.setFractional(uc, (T3)ptTarget, pta02, null);
            vtrans.sub2((T3)pta02, (T3)pta01);
        }
        pta01.set(1.0f, 0.0f, 0.0f);
        pta02.set(0.0f, 1.0f, 0.0f);
        P3 pta03 = P3.new3((float)0.0f, (float)0.0f, (float)1.0f);
        pta01.add((T3)pta00);
        pta02.add((T3)pta00);
        pta03.add((T3)pta00);
        P3 pt0 = SymmetryDesc.rotTransCart(op, uc, pta00, vtrans);
        P3 pt1 = SymmetryDesc.rotTransCart(op, uc, pta01, vtrans);
        P3 pt2 = SymmetryDesc.rotTransCart(op, uc, pta02, vtrans);
        P3 pt3 = SymmetryDesc.rotTransCart(op, uc, pta03, vtrans);
        V3 vt1 = V3.newVsub((T3)pt1, (T3)pt0);
        V3 vt2 = V3.newVsub((T3)pt2, (T3)pt0);
        V3 vt3 = V3.newVsub((T3)pt3, (T3)pt0);
        SymmetryDesc.approx((T3)vtrans);
        vtemp.cross((T3)vt1, (T3)vt2);
        boolean bl2 = haveInversion = vtemp.dot((T3)vt3) < 0.0f;
        if (haveInversion) {
            pt1.sub2((T3)pt0, (T3)vt1);
            pt2.sub2((T3)pt0, (T3)vt2);
            pt3.sub2((T3)pt0, (T3)vt3);
        }
        T3[] info = Measure.computeHelicalAxis((P3)pta00, (P3)pt0, (Quat)Quat.getQuaternionFrame((P3)pt0, (T3)pt1, (T3)pt2).div(Quat.getQuaternionFrame((P3)pta00, (T3)pta01, (T3)pta02)));
        P3 pa1 = (P3)info[0];
        V3 ax1 = (V3)info[1];
        int ang1 = (int)Math.abs(PT.approx((float)((P3)info[3]).x, (float)1.0f));
        float pitch1 = SymmetryOperation.approxF(((P3)info[3]).y);
        if (haveInversion) {
            pt1.add2((T3)pt0, (T3)vt1);
            pt2.add2((T3)pt0, (T3)vt2);
            pt3.add2((T3)pt0, (T3)vt3);
        }
        if ((trans = V3.newVsub((T3)pt0, (T3)pta00)).length() < 0.1f) {
            trans = null;
        }
        P3 ptinv = null;
        P3 ipt = null;
        P3 ptref = null;
        boolean isTranslation = ang1 == 0;
        boolean isRotation = !isTranslation;
        boolean isInversionOnly = false;
        boolean isMirrorPlane = false;
        if (isRotation || haveInversion) {
            trans = null;
        }
        if (haveInversion && isTranslation) {
            ipt = P3.newP((T3)pta00);
            ipt.add((T3)pt0);
            ipt.scale(0.5f);
            ptinv = pt0;
            isInversionOnly = true;
        } else if (haveInversion) {
            V3 d = pitch1 == 0.0f ? new V3() : ax1;
            float f = 0.0f;
            switch (ang1) {
                case 60: {
                    f = 0.6666667f;
                    break;
                }
                case 120: {
                    f = 2.0f;
                    break;
                }
                case 90: {
                    f = 1.0f;
                    break;
                }
                case 180: {
                    ptref = P3.newP((T3)pta00);
                    ptref.add((T3)d);
                    pa1.scaleAdd2(0.5f, (T3)d, (T3)pta00);
                    if (ptref.distance((T3)pt0) > 0.1f) {
                        trans = V3.newVsub((T3)pt0, (T3)ptref);
                        SymmetryDesc.setFractional(uc, (T3)trans, ptemp, null);
                        ftrans.setT((T3)ptemp);
                    } else {
                        trans = null;
                    }
                    isRotation = false;
                    haveInversion = false;
                    isMirrorPlane = true;
                    break;
                }
                default: {
                    haveInversion = false;
                }
            }
            if (f != 0.0f) {
                vtemp.sub2((T3)pta00, (T3)pa1);
                vtemp.add((T3)pt0);
                vtemp.sub((T3)pa1);
                vtemp.sub((T3)d);
                vtemp.scale(f);
                pa1.add((T3)vtemp);
                ipt = new P3();
                ipt.scaleAdd2(0.5f, (T3)d, (T3)pa1);
                ptinv = new P3();
                ptinv.scaleAdd2(-2.0f, (T3)ipt, (T3)pta00);
                ptinv.scale(-1.0f);
            }
        } else if (trans != null) {
            ptemp.setT((T3)trans);
            uc.toFractional((T3)ptemp, false);
            ftrans.setT((T3)ptemp);
            uc.toCartesian((T3)ptemp, false);
            trans.setT((T3)ptemp);
        }
        int ang = ang1;
        SymmetryDesc.approx0((T3)ax1);
        if (isRotation) {
            P3 ptr = new P3();
            vtemp.setT((T3)ax1);
            int ang2 = ang1;
            if (haveInversion) {
                ptr.add2((T3)pa1, (T3)vtemp);
                ang2 = Math.round(Measure.computeTorsion((T3)ptinv, (T3)pa1, (T3)ptr, (T3)pt0, (boolean)true));
            } else if (pitch1 == 0.0f) {
                ptr.setT((T3)pa1);
                ptemp.scaleAdd2(1.0f, (T3)ptr, (T3)vtemp);
                ang2 = Math.round(Measure.computeTorsion((T3)pta00, (T3)pa1, (T3)ptemp, (T3)pt0, (boolean)true));
            } else {
                ptemp.add2((T3)pa1, (T3)vtemp);
                ptr.scaleAdd2(0.5f, (T3)vtemp, (T3)pa1);
                ang2 = Math.round(Measure.computeTorsion((T3)pta00, (T3)pa1, (T3)ptemp, (T3)pt0, (boolean)true));
            }
            if (ang2 != 0) {
                ang1 = ang2;
            }
            if (!haveInversion && pitch1 == 0.0f && (ax1.z < 0.0f || ax1.z == 0.0f && (ax1.y < 0.0f || ax1.y == 0.0f && ax1.x < 0.0f))) {
                ax1.scale(-1.0f);
                ang1 = -ang1;
            }
        }
        String type = info1 = "identity";
        if (isInversionOnly) {
            ptemp.setT((T3)ipt);
            uc.toFractional((T3)ptemp, false);
            info1 = "Ci: " + SymmetryDesc.strCoord((T3)ptemp, op.isBio);
            type = "inversion center";
        } else if (isRotation) {
            if (haveInversion) {
                type = info1 = 360 / ang + "-bar axis";
            } else if (pitch1 != 0.0f) {
                type = info1 = 360 / ang + "-fold screw axis";
                ptemp.setT((T3)ax1);
                uc.toFractional((T3)ptemp, false);
                info1 = info1 + "|translation: " + SymmetryDesc.strCoord((T3)ptemp, op.isBio);
            } else {
                type = info1 = "C" + 360 / ang + " axis";
            }
        } else if (trans != null) {
            String s = " " + SymmetryDesc.strCoord((T3)ftrans, op.isBio);
            if (isTranslation) {
                info1 = "translation";
                type = "translation";
                info1 = info1 + ":" + s;
            } else if (isMirrorPlane) {
                float fx = Math.abs(SymmetryOperation.approxF(ftrans.x));
                float fy = Math.abs(SymmetryOperation.approxF(ftrans.y));
                float fz = Math.abs(SymmetryOperation.approxF(ftrans.z));
                s = " " + SymmetryDesc.strCoord((T3)ftrans, op.isBio);
                info1 = fx != 0.0f && fy != 0.0f && fz != 0.0f ? (!(fx != 0.25f && fx != 0.75f || fy != 0.25f && fy != 0.75f || fz != 0.25f && fz != 0.75f) ? "d-" : (fx == 0.5f && fy == 0.5f && fz == 0.5f ? "n-" : "g-")) : (fx != 0.0f && fy != 0.0f || fy != 0.0f && fz != 0.0f || fz != 0.0f && fx != 0.0f ? (fx == 0.25f && fy == 0.25f || fx == 0.25f && fz == 0.25f || fy == 0.25f && fz == 0.25f ? "d-" : (fx == 0.5f && fy == 0.5f || fx == 0.5f && fz == 0.5f || fy == 0.5f && fz == 0.5f ? (fx == 0.0f && ax1.x == 0.0f || fy == 0.0f && ax1.y == 0.0f || fz == 0.0f && ax1.z == 0.0f ? "g-" : "n-") : "g-")) : (fx != 0.0f ? "a-" : (fy != 0.0f ? "b-" : "c-")));
                type = info1 = info1 + "glide plane";
                info1 = info1 + "|translation:" + s;
            }
        } else if (isMirrorPlane) {
            info1 = "mirror plane";
            type = "mirror plane";
        }
        if (haveInversion && !isInversionOnly) {
            ptemp.setT((T3)ipt);
            uc.toFractional((T3)ptemp, false);
            info1 = info1 + "|inversion center at " + SymmetryDesc.strCoord((T3)ptemp, op.isBio);
        }
        if (isTimeReversed) {
            info1 = info1 + "|time-reversed";
            type = type + " (time-reversed)";
        }
        String cmds = null;
        String string = xyzNew = op.isBio ? op.xyzOriginal : SymmetryOperation.getXYZFromMatrix(op, false, false, false);
        if (id != null) {
            String opType = null;
            String drawid = "\ndraw ID " + id + "_";
            SB draw1 = new SB();
            draw1.append(drawid).append("* delete");
            SymmetryDesc.drawLine(draw1, drawid + "frame1X", 0.15f, pta00, pta01, "red");
            SymmetryDesc.drawLine(draw1, drawid + "frame1Y", 0.15f, pta00, pta02, "green");
            SymmetryDesc.drawLine(draw1, drawid + "frame1Z", 0.15f, pta00, pta03, "blue");
            if (isRotation) {
                P3 ptr = new P3();
                String color = "red";
                ang = ang1;
                float scale = 1.0f;
                vtemp.setT((T3)ax1);
                if (haveInversion) {
                    opType = drawid + "rotinv";
                    ptr.add2((T3)pa1, (T3)vtemp);
                    if (pitch1 == 0.0f) {
                        ptr.setT((T3)ipt);
                        vtemp.scale(3.0f * scaleFactor);
                        ptemp.scaleAdd2(-1.0f, (T3)vtemp, (T3)pa1);
                        SymmetryDesc.drawVector(draw1, drawid, "rotVector2", "", (T3)pa1, (T3)ptemp, "red");
                    }
                    scale = pt0.distance((T3)ptr);
                    draw1.append(drawid).append("rotLine1 ").append(Escape.eP((T3)ptr)).append(Escape.eP((T3)ptinv)).append(" color red");
                    draw1.append(drawid).append("rotLine2 ").append(Escape.eP((T3)ptr)).append(Escape.eP((T3)pt0)).append(" color red");
                } else if (pitch1 == 0.0f) {
                    boolean isSpecial;
                    opType = drawid + "rot";
                    boolean bl3 = isSpecial = pta00.distance((T3)pt0) < 0.2f;
                    if (!isSpecial) {
                        draw1.append(drawid).append("rotLine1 ").append(Escape.eP((T3)pta00)).append(Escape.eP((T3)pa1)).append(" color red");
                        draw1.append(drawid).append("rotLine2 ").append(Escape.eP((T3)pt0)).append(Escape.eP((T3)pa1)).append(" color red");
                    }
                    vtemp.scale(3.0f * scaleFactor);
                    ptemp.scaleAdd2(-1.0f, (T3)vtemp, (T3)pa1);
                    SymmetryDesc.drawVector(draw1, drawid, "rotVector2", "", (T3)pa1, (T3)ptemp, isTimeReversed ? "gray" : "red");
                    ptr.setT((T3)pa1);
                    if (pitch1 == 0.0f && (double)pta00.distance((T3)pt0) < 0.2) {
                        ptr.scaleAdd2(0.5f, (T3)vtemp, (T3)ptr);
                    }
                } else {
                    opType = drawid + "screw";
                    color = "orange";
                    draw1.append(drawid).append("rotLine1 ").append(Escape.eP((T3)pta00)).append(Escape.eP((T3)pa1)).append(" color red");
                    ptemp.add2((T3)pa1, (T3)vtemp);
                    draw1.append(drawid).append("rotLine2 ").append(Escape.eP((T3)pt0)).append(Escape.eP((T3)ptemp)).append(" color red");
                    ptr.scaleAdd2(0.5f, (T3)vtemp, (T3)pa1);
                }
                ptemp.add2((T3)ptr, (T3)vtemp);
                if (haveInversion && pitch1 != 0.0f) {
                    draw1.append(drawid).append("rotRotLine1").append(Escape.eP((T3)ptr)).append(Escape.eP((T3)ptinv)).append(" color red");
                    draw1.append(drawid).append("rotRotLine2").append(Escape.eP((T3)ptr)).append(Escape.eP((T3)pt0)).append(" color red");
                }
                draw1.append(drawid).append("rotRotArrow arrow width 0.1 scale " + PT.escF((float)scale) + " arc ").append(Escape.eP((T3)ptr)).append(Escape.eP((T3)ptemp));
                ptemp.setT((T3)(haveInversion ? ptinv : pta00));
                if (ptemp.distance((T3)pt0) < 0.1f) {
                    ptemp.set((float)Math.random(), (float)Math.random(), (float)Math.random());
                }
                draw1.append(Escape.eP((T3)ptemp));
                ptemp.set(0.0f, (float)ang, 0.0f);
                draw1.append(Escape.eP((T3)ptemp)).append(" color red");
                SymmetryDesc.drawVector(draw1, drawid, "rotVector1", "vector", (T3)pa1, (T3)vtemp, isTimeReversed ? "Gray" : color);
            } else if (isMirrorPlane) {
                ptemp.sub2((T3)ptref, (T3)pta00);
                if ((double)pta00.distance((T3)ptref) > 0.2) {
                    SymmetryDesc.drawVector(draw1, drawid, "planeVector", "vector", (T3)pta00, (T3)ptemp, isTimeReversed ? "Gray" : "cyan");
                }
                opType = drawid + "plane";
                if (trans != null) {
                    opType = drawid + "glide";
                    SymmetryDesc.drawFrameLine("X", ptref, vt1, 0.15f, ptemp, draw1, opType, "red");
                    SymmetryDesc.drawFrameLine("Y", ptref, vt2, 0.15f, ptemp, draw1, opType, "green");
                    SymmetryDesc.drawFrameLine("Z", ptref, vt3, 0.15f, ptemp, draw1, opType, "blue");
                }
                String color = trans == null ? "green" : "blue";
                vtemp.setT((T3)ax1);
                vtemp.normalize();
                float w = -vtemp.x * pa1.x - vtemp.y * pa1.y - vtemp.z * pa1.z;
                plane = P4.new4((float)vtemp.x, (float)vtemp.y, (float)vtemp.z, (float)w);
                float margin = Math.abs(w) < 0.01f && (double)(vtemp.x * vtemp.y) > 0.4 ? 1.3f : 1.05f;
                Lst v = this.modelSet.vwr.getTriangulator().intersectPlane(plane, (T3[])uc.getCanonicalCopy(margin, false), 3);
                int i = v.size();
                while (--i >= 0) {
                    P3[] pts = (P3[])v.get(i);
                    draw1.append(drawid).append("planep").appendI(i).append(" ").append(Escape.eP((T3)pts[0])).append(Escape.eP((T3)pts[1]));
                    if (pts.length == 3) {
                        draw1.append(Escape.eP((T3)pts[2]));
                    }
                    draw1.append(" color translucent ").append(color);
                }
                if (v.size() == 0) {
                    ptemp.add2((T3)pa1, (T3)ax1);
                    draw1.append(drawid).append("planeCircle scale 2.0 circle ").append(Escape.eP((T3)pa1)).append(Escape.eP((T3)ptemp)).append(" color translucent ").append(color).append(" mesh fill");
                }
            }
            if (haveInversion) {
                opType = drawid + "inv";
                draw1.append(drawid).append("invPoint diameter 0.4 ").append(Escape.eP((T3)ipt));
                ptemp.sub2((T3)ptinv, (T3)pta00);
                SymmetryDesc.drawVector(draw1, drawid, "invArrow", "vector", (T3)pta00, (T3)ptemp, isTimeReversed ? "gray" : "cyan");
                if (!isInversionOnly) {
                    SymmetryDesc.drawFrameLine("X", ptinv, vt1, 0.15f, ptemp, draw1, opType, "red");
                    SymmetryDesc.drawFrameLine("Y", ptinv, vt2, 0.15f, ptemp, draw1, opType, "green");
                    SymmetryDesc.drawFrameLine("Z", ptinv, vt3, 0.15f, ptemp, draw1, opType, "blue");
                }
            }
            if (trans != null) {
                if (ptref == null) {
                    ptref = P3.newP((T3)pta00);
                }
                SymmetryDesc.drawVector(draw1, drawid, "transVector", "vector", (T3)ptref, (T3)trans, isTimeReversed && !haveInversion && !isMirrorPlane && !isRotation ? "darkGray" : "gold");
            }
            ptemp2.setT((T3)pt0);
            ptemp.sub2((T3)pt1, (T3)pt0);
            ptemp.scaleAdd2(0.9f, (T3)ptemp, (T3)ptemp2);
            SymmetryDesc.drawLine(draw1, drawid + "frame2X", 0.2f, ptemp2, ptemp, "red");
            ptemp.sub2((T3)pt2, (T3)pt0);
            ptemp.scaleAdd2(0.9f, (T3)ptemp, (T3)ptemp2);
            SymmetryDesc.drawLine(draw1, drawid + "frame2Y", 0.2f, ptemp2, ptemp, "green");
            ptemp.sub2((T3)pt3, (T3)pt0);
            ptemp.scaleAdd2(0.9f, (T3)ptemp, (T3)ptemp2);
            SymmetryDesc.drawLine(draw1, drawid + "frame2Z", 0.2f, ptemp2, ptemp, "purple");
            draw1.append("\nsym_point = " + Escape.eP((T3)pta00));
            draw1.append("\nvar p0 = " + Escape.eP((T3)ptemp2));
            draw1.append("\nvar set2 = within(0.2,p0);if(!set2){set2 = within(0.2,p0.uxyz.xyz)}");
            if (pta00 instanceof Atom) {
                draw1.append("\n set2 &= {_" + ((Atom)pta00).getElementSymbol() + "}");
            }
            draw1.append("\nsym_target = set2;if (set2) {");
            draw1.append(drawid).append("offsetFrameX diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((T3)vt1)).append("*0.9} color red");
            draw1.append(drawid).append("offsetFrameY diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((T3)vt2)).append("*0.9} color green");
            draw1.append(drawid).append("offsetFrameZ diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((T3)vt3)).append("*0.9} color purple");
            draw1.append("\n}\n");
            cmds = draw1.toString();
            if (Logger.debugging) {
                Logger.info((String)cmds);
            }
            draw1 = null;
            drawid = null;
        }
        if (trans == null) {
            ftrans = null;
        }
        if (isRotation && !haveInversion && pitch1 != 0.0f) {
            trans = V3.newV((T3)ax1);
            ptemp.setT((T3)trans);
            uc.toFractional((T3)ptemp, false);
            ftrans = V3.newV((T3)ptemp);
        }
        if (isMirrorPlane) {
            ang1 = 0;
        }
        if (haveInversion) {
            if (isInversionOnly) {
                pa1 = null;
                ax1 = null;
                trans = null;
                ftrans = null;
            }
        } else if (isTranslation) {
            pa1 = null;
            ax1 = null;
        }
        if (ax1 != null) {
            ax1.normalize();
        }
        M4 m2 = null;
        m2 = M4.newM4((M4)op);
        if (vtrans.length() != 0.0f) {
            m2.m03 += vtrans.x;
            m2.m13 += vtrans.y;
            m2.m23 += vtrans.z;
        }
        String string2 = op.isBio ? m2.toString() : (xyzNew = op.modDim > 0 ? op.xyzOriginal : SymmetryOperation.getXYZFromMatrix(m2, false, false, false));
        if (op.timeReversal != 0) {
            xyzNew = op.fixMagneticXYZ(m2, xyzNew, true);
        }
        return new Object[]{xyzNew, op.xyzOriginal, info1, cmds, SymmetryDesc.approx0((T3)ftrans), SymmetryDesc.approx0((T3)trans), SymmetryDesc.approx0((T3)ipt), SymmetryDesc.approx0((T3)pa1), plane == null ? SymmetryDesc.approx0((T3)ax1) : null, ang1 != 0 ? Integer.valueOf(ang1) : null, m2, vtrans.lengthSquared() > 0.0f ? vtrans : null, op.getCentering(), op.timeReversal, plane, type, op.index};
    }

    private static void drawLine(SB s, String id, float diameter, P3 pt0, P3 pt1, String color) {
        s.append(id).append(" diameter ").appendF(diameter).append(Escape.eP((T3)pt0)).append(Escape.eP((T3)pt1)).append(" color ").append(color);
    }

    private static void drawFrameLine(String xyz, P3 pt, V3 v, float width, P3 ptemp, SB draw1, String key, String color) {
        ptemp.setT((T3)pt);
        ptemp.add((T3)v);
        SymmetryDesc.drawLine(draw1, key + "Pt" + xyz, width, pt, ptemp, "translucent " + color);
    }

    private static void drawVector(SB draw1, String drawid, String label, String type, T3 pt1, T3 v, String color) {
        draw1.append(drawid).append(label).append(" diameter 0.1 ").append(type).append(Escape.eP((T3)pt1)).append(Escape.eP((T3)v)).append(" color ").append(color);
    }

    private static void setFractional(SymmetryInterface uc, T3 pt00, P3 pt01, P3 offset) {
        pt01.setT(pt00);
        if (offset != null) {
            uc.toUnitCell((T3)pt01, (T3)offset);
        }
        uc.toFractional((T3)pt01, false);
    }

    private static P3 rotTransCart(SymmetryOperation op, SymmetryInterface uc, P3 pt00, V3 vtrans) {
        P3 p0 = P3.newP((T3)pt00);
        uc.toFractional((T3)p0, false);
        op.rotTrans((T3)p0);
        p0.add((T3)vtrans);
        uc.toCartesian((T3)p0, false);
        return p0;
    }

    private static String strCoord(T3 p, boolean isBio) {
        SymmetryDesc.approx0(p);
        return isBio ? p.x + " " + p.y + " " + p.z : SymmetryOperation.fcoord(p);
    }

    private static T3 approx0(T3 pt) {
        if (pt != null) {
            if (Math.abs(pt.x) < 1.0E-4f) {
                pt.x = 0.0f;
            }
            if (Math.abs(pt.y) < 1.0E-4f) {
                pt.y = 0.0f;
            }
            if (Math.abs(pt.z) < 1.0E-4f) {
                pt.z = 0.0f;
            }
        }
        return pt;
    }

    private static T3 approx(T3 pt) {
        if (pt != null) {
            pt.x = SymmetryOperation.approxF(pt.x);
            pt.y = SymmetryOperation.approxF(pt.y);
            pt.z = SymmetryOperation.approxF(pt.z);
        }
        return pt;
    }

    private Object getSymmetryInfo(Symmetry sym, int iModel, int iatom, Symmetry uc, String xyz, int op, P3 pt, P3 pt2, String id, int type, float scaleFactor, int nth) {
        if (type == 0x400000AA) {
            return uc.getLatticeType();
        }
        Object ret = type == 135176 ? "draw ID sym_* delete" : (type == 0x44000001 ? new BS() : "");
        int iop = op;
        Object[] info = null;
        if (pt2 == null) {
            int i;
            if (xyz == null) {
                SymmetryOperation[] ops = (SymmetryOperation[])uc.getSymmetryOperations();
                if (ops == null || op == 0 || Math.abs(op) > ops.length) {
                    return ret;
                }
                iop = Math.abs(op) - 1;
                xyz = ops[iop].xyz;
            } else {
                op = 0;
                iop = 0;
            }
            Symmetry symTemp = new Symmetry();
            symTemp.setSpaceGroup(false);
            boolean isBio = uc.isBio();
            int n = isBio ? symTemp.addBioMoleculeOperation(uc.spaceGroup.finalOperations[iop], op < 0) : (i = symTemp.addSpaceGroupOperation((op < 0 ? "!" : "=") + xyz, Math.abs(op)));
            if (i < 0) {
                return ret;
            }
            SymmetryOperation opTemp = (SymmetryOperation)symTemp.getSpaceGroupOperation(i);
            opTemp.index = op - 1;
            if (!isBio) {
                opTemp.getCentering();
            }
            if (pt == null && iatom >= 0) {
                pt = this.modelSet.at[iatom];
            }
            if (type == 134217751 || type == 0x44000001) {
                if (isBio) {
                    return ret;
                }
                symTemp.setUnitCell(uc.getUnitCellParams(), false);
                pt = P3.newP((T3)pt);
                uc.toFractional((T3)pt, false);
                if (Float.isNaN(pt.x)) {
                    return ret;
                }
                P3 sympt = new P3();
                symTemp.newSpaceGroupPoint(i, pt, sympt, 0, 0, 0, null);
                symTemp.toCartesian((T3)sympt, false);
                return type == 0x44000001 ? this.getAtom(uc, iModel, iatom, (T3)sympt) : sympt;
            }
            info = this.createInfoArray(opTemp, uc, pt, pt2, id == null ? "sym" : id, scaleFactor);
        } else {
            String stype = "info";
            boolean asString = false;
            switch (type) {
                case 1073742001: {
                    stype = null;
                    id = null;
                    asString = true;
                    if (nth != 0) break;
                    nth = -1;
                    break;
                }
                case 135176: {
                    if (id == null) {
                        id = "sym";
                    }
                    stype = "all";
                    asString = true;
                    break;
                }
                case 0x44000001: {
                    stype = null;
                    id = null;
                }
                default: {
                    if (nth != 0) break;
                    nth = 1;
                }
            }
            ret = this.getSymopInfoForPoints(sym, iModel, op, pt, pt2, id, stype, scaleFactor, nth, asString);
            if (asString) {
                return ret;
            }
            if (ret instanceof String) {
                return null;
            }
            info = (Object[])ret;
            if (type == 0x44000001) {
                if (!(pt instanceof Atom) && !(pt2 instanceof Atom)) {
                    iatom = -1;
                }
                return info == null ? new BS() : this.getAtom(uc, iModel, iatom, (T3)info[7]);
            }
        }
        return SymmetryDesc.getInfo(info, type);
    }

    private BS getAtom(Symmetry uc, int iModel, int iAtom, T3 sympt) {
        BS bsElement = null;
        if (iAtom >= 0) {
            bsElement = new BS();
            this.modelSet.getAtomBitsMDa(1094715402, (Object)this.modelSet.at[iAtom].getElementNumber(), bsElement);
        }
        BS bsResult = new BS();
        this.modelSet.getAtomsWithin(0.02f, sympt, bsResult, iModel);
        if (bsElement != null) {
            bsResult.and(bsElement);
        }
        if (bsResult.isEmpty()) {
            sympt = P3.newP((T3)sympt);
            uc.toUnitCell(sympt, null);
            uc.toCartesian(sympt, false);
            this.modelSet.getAtomsWithin(0.02f, sympt, bsResult, iModel);
            if (bsElement != null) {
                bsResult.and(bsElement);
            }
        }
        return bsResult;
    }

    private Object getSymopInfoForPoints(Symmetry sym, int modelIndex, int symOp, P3 pt1, P3 pt2, String drawID, String stype, float scaleFactor, int nth, boolean asString) {
        String strOperations = "";
        String ret = asString ? "" : null;
        Map<String, Object> sginfo = this.getSpaceGroupInfo(sym, modelIndex, null, symOp, pt1, pt2, drawID, scaleFactor, nth, false, true);
        if (sginfo == null) {
            return ret;
        }
        strOperations = (String)sginfo.get("symmetryInfo");
        Object[][] infolist = (Object[][])sginfo.get("operations");
        if (infolist == null) {
            return ret;
        }
        SB sb = new SB();
        --symOp;
        boolean labelOnly = "label".equals(stype);
        for (int i = 0; i < infolist.length; ++i) {
            if (infolist[i] == null || symOp >= 0 && symOp != i) continue;
            if (!asString) {
                return infolist[i];
            }
            if (drawID != null) {
                return (String)infolist[i][3] + "\nprint " + PT.esc((String)strOperations);
            }
            if (sb.length() > 0) {
                sb.appendC('\n');
            }
            if (!labelOnly) {
                if (symOp < 0) {
                    sb.appendI(i + 1).appendC('\t');
                }
                sb.append((String)infolist[i][0]).appendC('\t');
            }
            sb.append((String)infolist[i][2]);
        }
        if (sb.length() == 0) {
            return drawID != null ? "draw " + drawID + "* delete" : ret;
        }
        return sb.toString();
    }
}

