/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverTable;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class TagConflictResolver
extends JPanel {
    private final TagConflictResolverModel model;
    private final JCheckBox cbShowTagsWithConflictsOnly = new JCheckBox(I18n.tr("Show tags with conflicts only", new Object[0]));
    private final JCheckBox cbShowTagsWithMultiValuesOnly = new JCheckBox(I18n.tr("Show tags with multiple values only", new Object[0]));

    public TagConflictResolver(TagConflictResolverModel model) {
        this.model = model;
        this.build();
    }

    protected JPanel buildInfoPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.anchor = 21;
        gc.gridwidth = 2;
        pnl.add((Component)new JLabel(I18n.tr("<html>Please select the values to keep for the following tags.</html>", new Object[0])), gc);
        gc.gridwidth = 1;
        gc.gridy = 1;
        gc.fill = 2;
        gc.weighty = 0.0;
        pnl.add((Component)this.cbShowTagsWithConflictsOnly, gc);
        pnl.add((Component)this.cbShowTagsWithMultiValuesOnly, gc);
        this.cbShowTagsWithConflictsOnly.addChangeListener(e -> {
            this.model.setShowTagsWithConflictsOnly(this.cbShowTagsWithConflictsOnly.isSelected());
            this.cbShowTagsWithMultiValuesOnly.setEnabled(this.cbShowTagsWithConflictsOnly.isSelected());
        });
        this.cbShowTagsWithConflictsOnly.setSelected(Config.getPref().getBoolean(this.getClass().getName() + ".showTagsWithConflictsOnly", false));
        this.cbShowTagsWithMultiValuesOnly.addChangeListener(e -> this.model.setShowTagsWithMultiValuesOnly(this.cbShowTagsWithMultiValuesOnly.isSelected()));
        this.cbShowTagsWithMultiValuesOnly.setSelected(Config.getPref().getBoolean(this.getClass().getName() + ".showTagsWithMultiValuesOnly", false));
        this.cbShowTagsWithMultiValuesOnly.setEnabled(this.cbShowTagsWithConflictsOnly.isSelected());
        return pnl;
    }

    public void rememberPreferences() {
        Config.getPref().putBoolean(this.getClass().getName() + ".showTagsWithConflictsOnly", this.cbShowTagsWithConflictsOnly.isSelected());
        Config.getPref().putBoolean(this.getClass().getName() + ".showTagsWithMultiValuesOnly", this.cbShowTagsWithMultiValuesOnly.isSelected());
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildInfoPanel(), "North");
        this.add((Component)new JScrollPane(new TagConflictResolverTable(this.model)), "Center");
    }

    public TagConflictResolverModel getModel() {
        return this.model;
    }
}

