/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.actions.AbstractSelectAction;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class ValidatorDialog
extends ToggleDialog
implements DataSelectionListener,
MainLayerManager.ActiveLayerChangeListener {
    public ValidatorTreePanel tree;
    public static final ValidateAction validateAction = new ValidateAction();
    private final SideButton fixButton;
    private final SideButton ignoreButton;
    private final SideButton selectButton;
    private final SideButton lookupButton;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final transient PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
    private DefaultMutableTreeNode lastSelectedNode;

    public ValidatorDialog() {
        super(I18n.tr("Validation Results", new Object[0]), "validator", I18n.tr("Open the validation window.", new Object[0]), Shortcut.registerShortcut("subwindow:validator", I18n.tr("Toggle: {0}", I18n.tr("Validation Results", new Object[0])), 86, 5007), 150, false, ValidatorPreference.class);
        this.popupMenuHandler.addAction(MainApplication.getMenu().autoScaleActions.get("problem"));
        this.popupMenuHandler.addAction(new EditRelationAction());
        this.tree = new ValidatorTreePanel();
        this.tree.addMouseListener(new MouseEventHandler());
        this.addTreeSelectionListener(new SelectionWatch());
        InputMapUtils.unassignCtrlShiftUpDown(this.tree, 0);
        LinkedList<SideButton> buttons = new LinkedList<SideButton>();
        this.selectButton = new SideButton(new AbstractSelectAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatorDialog.this.setSelectedItems();
            }
        });
        InputMapUtils.addEnterAction(this.tree, this.selectButton.getAction());
        this.selectButton.setEnabled(false);
        buttons.add(this.selectButton);
        this.lookupButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Lookup", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Looks up the selected primitives in the error list.", new Object[0]));
                new ImageProvider("dialogs", "search").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
                if (ds == null) {
                    return;
                }
                ValidatorDialog.this.tree.selectRelatedErrors(ds.getSelected());
            }
        });
        buttons.add(this.lookupButton);
        buttons.add(new SideButton(validateAction));
        this.fixButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Fix", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Fix the selected issue.", new Object[0]));
                new ImageProvider("dialogs", "fix").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatorDialog.this.fixErrors();
            }
        });
        this.fixButton.setEnabled(false);
        buttons.add(this.fixButton);
        if (ValidatorPrefHelper.PREF_USE_IGNORE.get().booleanValue()) {
            this.ignoreButton = new SideButton(new AbstractAction(){
                {
                    this.putValue("Name", I18n.tr("Ignore", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Ignore the selected issue next time.", new Object[0]));
                    new ImageProvider("dialogs", "fix").getResource().attachImageIcon(this, true);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValidatorDialog.this.ignoreErrors();
                }
            });
            this.ignoreButton.setEnabled(false);
            buttons.add(this.ignoreButton);
        } else {
            this.ignoreButton = null;
        }
        this.createLayout(this.tree, true, buttons);
    }

    @Override
    public void showNotify() {
        SelectionEventManager.getInstance().addSelectionListener(this);
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (ds != null) {
            this.updateSelection(ds.getAllSelected());
        }
        MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(this);
    }

    @Override
    public void hideNotify() {
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
        SelectionEventManager.getInstance().removeSelectionListener(this);
    }

    @Override
    public void setVisible(boolean v) {
        if (this.tree != null) {
            this.tree.setVisible(v);
        }
        super.setVisible(v);
    }

    private void fixErrors() {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> processedNodes = new HashSet<DefaultMutableTreeNode>();
        LinkedList<TestError> errorsToFix = new LinkedList<TestError>();
        for (TreePath path : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) continue;
            ValidatorTreePanel.visitTestErrors(node, errorsToFix::add, processedNodes);
        }
        MainApplication.worker.submit(new FixTask(errorsToFix));
    }

    private void ignoreErrors() {
        int asked = -1;
        AtomicBoolean changed = new AtomicBoolean();
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> processedNodes = new HashSet<DefaultMutableTreeNode>();
        for (TreePath path : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) continue;
            Object mainNodeInfo = node.getUserObject();
            if (!(mainNodeInfo instanceof TestError)) {
                HashSet state = new HashSet();
                if (asked == -1) {
                    Object[] a = new String[]{I18n.tr("Whole group", new Object[0]), I18n.tr("Single elements", new Object[0]), I18n.tr("Nothing", new Object[0])};
                    asked = JOptionPane.showOptionDialog(MainApplication.getMainFrame(), I18n.tr("Ignore whole group or individual elements?", new Object[0]), I18n.tr("Ignoring elements", new Object[0]), 1, 2, null, a, a[1]);
                }
                if (asked == 0) {
                    ValidatorTreePanel.visitTestErrors(node, err -> {
                        err.setIgnored(true);
                        changed.set(true);
                        state.add(node.getDepth() == 1 ? err.getIgnoreSubGroup() : err.getIgnoreGroup());
                    }, processedNodes);
                    for (String s : state) {
                        OsmValidator.addIgnoredError(s);
                    }
                    continue;
                }
                if (asked == 2 || asked == -1) continue;
            }
            ValidatorTreePanel.visitTestErrors(node, error -> {
                String state = error.getIgnoreState();
                if (state != null) {
                    OsmValidator.addIgnoredError(state);
                }
                changed.set(true);
                error.setIgnored(true);
            }, processedNodes);
        }
        if (changed.get()) {
            this.tree.resetErrors();
            OsmValidator.saveIgnoredErrors();
            ValidatorDialog.invalidateValidatorLayers();
        }
    }

    private void setSelectedItems() {
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (this.tree == null || ds == null) {
            return;
        }
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths == null) {
            return;
        }
        HashSet sel = new HashSet(40);
        for (TreePath path : selectedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> children = node.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                Object nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                TestError error = (TestError)nodeInfo;
                error.getPrimitives().stream().filter(OsmPrimitive::isSelectable).forEach(sel::add);
            }
        }
        ds.setSelected(sel);
    }

    private boolean setSelection(Collection<OsmPrimitive> sel, boolean addSelected) {
        AtomicBoolean hasFixes = new AtomicBoolean();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.lastSelectedNode != null && !this.lastSelectedNode.equals(node)) {
            ValidatorTreePanel.visitTestErrors(this.lastSelectedNode, error -> error.setSelected(false));
        }
        this.lastSelectedNode = node;
        if (node != null) {
            ValidatorTreePanel.visitTestErrors(node, error -> {
                error.setSelected(true);
                hasFixes.set(hasFixes.get() || error.isFixable());
                if (addSelected) {
                    error.getPrimitives().stream().filter(OsmPrimitive::isSelectable).forEach(sel::add);
                }
            });
            this.selectButton.setEnabled(true);
            if (this.ignoreButton != null) {
                this.ignoreButton.setEnabled(true);
            }
        }
        return hasFixes.get();
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        OsmDataLayer editLayer = e.getSource().getEditLayer();
        if (editLayer == null) {
            this.tree.setErrorList(new ArrayList<TestError>());
        } else {
            this.tree.setErrorList(editLayer.validationErrors);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.removeTreeSelectionListener(listener);
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    public TestError getSelectedError() {
        Object object;
        Object comp = this.tree.getLastSelectedPathComponent();
        if (comp instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)comp).getUserObject()) instanceof TestError) {
            return (TestError)object;
        }
        return null;
    }

    public void updateSelection(Collection<? extends OsmPrimitive> newSelection) {
        if (!Config.getPref().getBoolean("validator.selectionFilter", false)) {
            return;
        }
        if (newSelection.isEmpty()) {
            this.tree.setFilter(null);
        }
        this.tree.setFilter(new HashSet<OsmPrimitive>(newSelection));
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.updateSelection(event.getSelection());
    }

    private static void invalidateValidatorLayers() {
        MainApplication.getLayerManager().getLayersOfType(ValidatorLayer.class).forEach(AbstractMapViewPaintable::invalidate);
    }

    class FixTask
    extends PleaseWaitRunnable {
        private final Collection<TestError> testErrors;
        private boolean canceled;

        FixTask(Collection<TestError> testErrors) {
            super(I18n.tr("Fixing errors ...", new Object[0]), false);
            this.testErrors = testErrors == null ? new ArrayList() : testErrors;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
        }

        protected void fixError(TestError error) throws InterruptedException, InvocationTargetException {
            if (error.isFixable()) {
                Command fixCommand = error.getFix();
                if (fixCommand != null) {
                    SwingUtilities.invokeAndWait(() -> UndoRedoHandler.getInstance().addNoRedraw(fixCommand));
                }
                error.setIgnored(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            ProgressMonitor monitor = this.getProgressMonitor();
            try {
                monitor.setTicksCount(this.testErrors.size());
                DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
                int i = 0;
                SwingUtilities.invokeAndWait(ds::beginUpdate);
                try {
                    for (TestError error : this.testErrors) {
                        monitor.subTask(I18n.tr("Fixing ({0}/{1}): ''{2}''", ++i, this.testErrors.size(), error.getMessage()));
                        if (!this.canceled) break block10;
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeAndWait(ds::endUpdate);
                    throw throwable;
                }
                {
                    TestError error;
                    block10: {
                        SwingUtilities.invokeAndWait(ds::endUpdate);
                        return;
                    }
                    this.fixError(error);
                    monitor.worked(1);
                    continue;
                }
                SwingUtilities.invokeAndWait(ds::endUpdate);
                monitor.subTask(I18n.tr("Updating map ...", new Object[0]));
                SwingUtilities.invokeAndWait(() -> {
                    UndoRedoHandler.getInstance().afterAdd(null);
                    ValidatorDialog.invalidateValidatorLayers();
                    ValidatorDialog.this.tree.resetErrors();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new JosmRuntimeException(e);
            }
            finally {
                monitor.finishTask();
            }
        }
    }

    public static class ValidatorBoundingXYVisitor
    extends BoundingXYVisitor
    implements ValidatorVisitor {
        @Override
        public void visit(OsmPrimitive p) {
            if (p.isUsable()) {
                p.accept(this);
            }
        }

        @Override
        public void visit(WaySegment ws) {
            if (ws.lowerIndex < 0 || ws.lowerIndex + 1 >= ws.way.getNodesCount()) {
                return;
            }
            this.visit(ws.way.getNodes().get(ws.lowerIndex));
            this.visit(ws.way.getNodes().get(ws.lowerIndex + 1));
        }

        @Override
        public void visit(List<Node> nodes) {
            for (Node n : nodes) {
                this.visit(n);
            }
        }

        @Override
        public void visit(TestError error) {
            if (error != null) {
                error.visitHighlighted(this);
            }
        }
    }

    public class SelectionWatch
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            HashSet sel = new HashSet();
            boolean hasFixes = ValidatorDialog.this.setSelection(sel, true);
            ValidatorDialog.this.fixButton.setEnabled(hasFixes);
            ValidatorDialog.this.popupMenuHandler.setPrimitives(sel);
            ValidatorDialog.invalidateValidatorLayers();
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        MouseEventHandler() {
            super(ValidatorDialog.this.popupMenu);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath selPath = ValidatorDialog.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                ValidatorDialog.this.tree.clearSelection();
            }
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            boolean isDblClick = MouseEventHandler.isDoubleClick(e);
            HashSet sel = isDblClick ? new HashSet(40) : null;
            boolean hasFixes = ValidatorDialog.this.setSelection(sel, isDblClick);
            ValidatorDialog.this.fixButton.setEnabled(hasFixes);
            if (isDblClick) {
                DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
                if (ds != null) {
                    ds.setSelected(sel);
                }
                if (Config.getPref().getBoolean("validator.autozoom", false)) {
                    AutoScaleAction.zoomTo(sel);
                }
            }
        }

        @Override
        public void launch(MouseEvent e) {
            TreePath selPath = ValidatorDialog.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
            if (!(node.getUserObject() instanceof TestError)) {
                return;
            }
            super.launch(e);
        }
    }
}

