/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.awt.Point;
import java.util.Collections;
import java.util.Map;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class AddNodeHandler
extends RequestHandler {
    public static final String command = "add_node";
    private double lat;
    private double lon;

    @Override
    protected void handleRequest() {
        GuiHelper.runInEDTAndWait(() -> this.addNode(this.args));
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"lat", "lon"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"addtags"};
    }

    @Override
    public String getUsage() {
        return "adds a node (given by its latitude and longitude) to the current dataset";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/add_node?lat=11&lon=22", "/add_node?lon=13.3&lat=53.2&addtags=natural=tree|name=%20%20%20==Great%20Oak=="};
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to create a new node.", new Object[0]) + "<br>" + I18n.tr("Coordinates: ", new Object[0]) + (String)this.args.get("lat") + ", " + (String)this.args.get("lon");
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.CREATE_OBJECTS;
    }

    private void addNode(Map<String, String> args) {
        Point p;
        MapView mapView;
        Logging.info("Adding node at (" + this.lat + ", " + this.lon + ')');
        LatLon ll = new LatLon(this.lat, this.lon);
        Node node = null;
        if (MainApplication.isDisplayingMapView() && (node = (mapView = MainApplication.getMap().mapView).getNearestNode(p = mapView.getPoint(ll), AbstractPrimitive::isUsable)) != null && node.getCoor().greatCircleDistance(ll) > Config.getPref().getDouble("remotecontrol.tolerance", 0.1)) {
            node = null;
        }
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (node == null) {
            node = new Node(ll);
            UndoRedoHandler.getInstance().add(new AddCommand(ds, node));
        }
        ds.setSelected(node);
        if (PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            AutoScaleAction.autoScale("selection");
        } else {
            MainApplication.getMap().mapView.repaint();
        }
        AddTagsDialog.addTags(args, this.sender, Collections.singleton(node));
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        try {
            this.lat = Double.parseDouble(this.args != null ? (String)this.args.get("lat") : "");
            this.lon = Double.parseDouble(this.args != null ? (String)this.args.get("lon") : "");
        }
        catch (NumberFormatException e) {
            throw new RequestHandler.RequestHandlerBadRequestException("NumberFormatException (" + e.getMessage() + ')', e);
        }
        if (MainApplication.getLayerManager().getEditLayer() == null) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("There is no layer opened to add node", new Object[0]));
        }
    }
}

