/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.ApiCleanupNeeded;
import org.languagetool.rules.MatchPosition;
import org.languagetool.rules.Rule;
import org.languagetool.tools.StringTools;

public class RuleMatch
implements Comparable<RuleMatch> {
    private static final Pattern SUGGESTION_PATTERN = Pattern.compile("<suggestion>(.*?)</suggestion>");
    private final Rule rule;
    private final OffsetPosition offsetPosition;
    private final String message;
    private final String shortMessage;
    private final AnalyzedSentence sentence;
    private LinePosition linePosition = new LinePosition(-1, -1);
    private ColumnPosition columnPosition = new ColumnPosition(-1, -1);
    private List<String> suggestedReplacements = new ArrayList<String>();
    private URL url;

    public RuleMatch(Rule rule, int fromPos, int toPos, String message) {
        this(rule, fromPos, toPos, message, null, false, null);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, String message) {
        this(rule, sentence, fromPos, toPos, message, null, false, null);
    }

    public RuleMatch(Rule rule, int fromPos, int toPos, String message, String shortMessage) {
        this(rule, fromPos, toPos, message, shortMessage, false, null);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, String message, String shortMessage) {
        this(rule, sentence, fromPos, toPos, message, shortMessage, false, null);
    }

    public RuleMatch(Rule rule, int fromPos, int toPos, String message, String shortMessage, boolean startWithUppercase, String suggestionsOutMsg) {
        this(rule, null, fromPos, toPos, message, shortMessage, startWithUppercase, suggestionsOutMsg);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, String message, String shortMessage, boolean startWithUppercase, String suggestionsOutMsg) {
        this.rule = Objects.requireNonNull(rule);
        if (toPos <= fromPos) {
            throw new RuntimeException("fromPos (" + fromPos + ") must be less than toPos (" + toPos + ")");
        }
        this.offsetPosition = new OffsetPosition(fromPos, toPos);
        this.message = Objects.requireNonNull(message);
        this.shortMessage = shortMessage;
        Matcher matcher = SUGGESTION_PATTERN.matcher(message + suggestionsOutMsg);
        int pos = 0;
        while (matcher.find(pos)) {
            pos = matcher.end();
            String replacement = matcher.group(1);
            if (startWithUppercase) {
                replacement = StringTools.uppercaseFirstChar(replacement);
            }
            if (this.suggestedReplacements.contains(replacement)) continue;
            this.suggestedReplacements.add(replacement);
        }
        this.sentence = sentence;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setLine(int fromLine) {
        this.linePosition = new LinePosition(fromLine, this.linePosition.getEnd());
    }

    public int getLine() {
        return this.linePosition.getStart();
    }

    public void setEndLine(int endLine) {
        this.linePosition = new LinePosition(this.linePosition.getStart(), endLine);
    }

    public int getEndLine() {
        return this.linePosition.getEnd();
    }

    public void setColumn(int column) {
        this.columnPosition = new ColumnPosition(column, this.columnPosition.getEnd());
    }

    public int getColumn() {
        return this.columnPosition.getStart();
    }

    public void setEndColumn(int endColumn) {
        this.columnPosition = new ColumnPosition(this.columnPosition.getStart(), endColumn);
    }

    public int getEndColumn() {
        return this.columnPosition.getEnd();
    }

    public int getFromPos() {
        return this.offsetPosition.getStart();
    }

    public int getToPos() {
        return this.offsetPosition.getEnd();
    }

    public String getMessage() {
        return this.message;
    }

    @ApiCleanupNeeded(value="Should return an Optional")
    public String getShortMessage() {
        if (this.shortMessage == null) {
            return "";
        }
        return this.shortMessage;
    }

    public void setSuggestedReplacement(String replacement) {
        Objects.requireNonNull(replacement, "replacement may be empty but not null");
        ArrayList<String> replacements = new ArrayList<String>();
        replacements.add(replacement);
        this.setSuggestedReplacements(replacements);
    }

    public void setSuggestedReplacements(List<String> replacements) {
        this.suggestedReplacements = Objects.requireNonNull(replacements, "replacements may be empty but not null");
    }

    public List<String> getSuggestedReplacements() {
        return Collections.unmodifiableList(this.suggestedReplacements);
    }

    @Nullable
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public AnalyzedSentence getSentence() {
        return this.sentence;
    }

    public String toString() {
        return this.rule.getId() + ":" + this.offsetPosition + ":" + this.message;
    }

    @Override
    public int compareTo(RuleMatch other) {
        Objects.requireNonNull(other);
        return Integer.compare(this.getFromPos(), other.getFromPos());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleMatch other = (RuleMatch)o;
        return Objects.equals(this.rule.getId(), other.rule.getId()) && Objects.equals(this.offsetPosition, other.offsetPosition) && Objects.equals(this.message, other.message) && Objects.equals(this.suggestedReplacements, other.suggestedReplacements) && Objects.equals(this.sentence, other.sentence);
    }

    public int hashCode() {
        return Objects.hash(this.rule.getId(), this.offsetPosition, this.message, this.suggestedReplacements, this.sentence);
    }

    static class ColumnPosition
    extends MatchPosition {
        ColumnPosition(int start, int end) {
            super(start, end);
        }
    }

    static class LinePosition
    extends MatchPosition {
        LinePosition(int start, int end) {
            super(start, end);
        }
    }

    static class OffsetPosition
    extends MatchPosition {
        OffsetPosition(int start, int end) {
            super(start, end);
        }
    }
}

