/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.UnknownHostException;
import sun.security.krb5.internal.NetClient;

class UDPClient
extends NetClient {
    InetAddress iaddr;
    int iport;
    int bufSize = 65507;
    DatagramSocket dgSocket;
    DatagramPacket dgPacketIn;

    UDPClient(String hostname, int port, int timeout) throws UnknownHostException, SocketException {
        this.iaddr = InetAddress.getByName(hostname);
        this.iport = port;
        this.dgSocket = new DatagramSocket();
        this.dgSocket.setSoTimeout(timeout);
        this.dgSocket.connect(this.iaddr, this.iport);
    }

    @Override
    public void send(byte[] data) throws IOException {
        DatagramPacket dgPacketOut = new DatagramPacket(data, data.length, this.iaddr, this.iport);
        this.dgSocket.send(dgPacketOut);
    }

    @Override
    public byte[] receive() throws IOException {
        byte[] ibuf = new byte[this.bufSize];
        this.dgPacketIn = new DatagramPacket(ibuf, ibuf.length);
        try {
            this.dgSocket.receive(this.dgPacketIn);
        }
        catch (SocketException e) {
            if (e instanceof PortUnreachableException) {
                throw e;
            }
            this.dgSocket.receive(this.dgPacketIn);
        }
        byte[] data = new byte[this.dgPacketIn.getLength()];
        System.arraycopy(this.dgPacketIn.getData(), 0, data, 0, this.dgPacketIn.getLength());
        return data;
    }

    @Override
    public void close() {
        this.dgSocket.close();
    }
}

