/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.accessibility.fo;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.accessibility.fo.StructureTreeEventTrigger;
import org.apache.fop.fo.DelegatingFOEventHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.fo.flow.AbstractRetrieveMarker;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.fo.flow.RetrieveTableMarker;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.SAXException;

public class FO2StructureTreeConverter
extends DelegatingFOEventHandler {
    private FOEventHandler converter;
    private Stack<FOEventHandler> converters = new Stack();
    private final StructureTreeEventTrigger structureTreeEventTrigger;
    private final FOEventHandler eventSwallower = new FOEventHandler(){};
    private final Map<AbstractRetrieveMarker, State> states = new HashMap<AbstractRetrieveMarker, State>();

    public FO2StructureTreeConverter(StructureTreeEventHandler structureTreeEventHandler, FOEventHandler delegate) {
        super(delegate);
        this.structureTreeEventTrigger = new StructureTreeEventTrigger(structureTreeEventHandler);
        this.converter = this.structureTreeEventTrigger;
    }

    @Override
    public void startDocument() throws SAXException {
        this.converter.startDocument();
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.converter.endDocument();
        super.endDocument();
    }

    @Override
    public void startRoot(Root root) {
        this.converter.startRoot(root);
        super.startRoot(root);
    }

    @Override
    public void endRoot(Root root) {
        this.converter.endRoot(root);
        super.endRoot(root);
    }

    @Override
    public void startPageSequence(PageSequence pageSeq) {
        this.converter.startPageSequence(pageSeq);
        super.startPageSequence(pageSeq);
    }

    @Override
    public void endPageSequence(PageSequence pageSeq) {
        this.converter.endPageSequence(pageSeq);
        super.endPageSequence(pageSeq);
    }

    @Override
    public void startPageNumber(PageNumber pagenum) {
        this.converter.startPageNumber(pagenum);
        super.startPageNumber(pagenum);
    }

    @Override
    public void endPageNumber(PageNumber pagenum) {
        this.converter.endPageNumber(pagenum);
        super.endPageNumber(pagenum);
    }

    @Override
    public void startPageNumberCitation(PageNumberCitation pageCite) {
        this.converter.startPageNumberCitation(pageCite);
        super.startPageNumberCitation(pageCite);
    }

    @Override
    public void endPageNumberCitation(PageNumberCitation pageCite) {
        this.converter.endPageNumberCitation(pageCite);
        super.endPageNumberCitation(pageCite);
    }

    @Override
    public void startPageNumberCitationLast(PageNumberCitationLast pageLast) {
        this.converter.startPageNumberCitationLast(pageLast);
        super.startPageNumberCitationLast(pageLast);
    }

    @Override
    public void endPageNumberCitationLast(PageNumberCitationLast pageLast) {
        this.converter.endPageNumberCitationLast(pageLast);
        super.endPageNumberCitationLast(pageLast);
    }

    @Override
    public void startStatic(StaticContent staticContent) {
        this.handleStartArtifact(staticContent);
        this.converter.startStatic(staticContent);
        super.startStatic(staticContent);
    }

    @Override
    public void endStatic(StaticContent staticContent) {
        this.converter.endStatic(staticContent);
        this.handleEndArtifact(staticContent);
        super.endStatic(staticContent);
    }

    @Override
    public void startFlow(Flow fl) {
        this.converter.startFlow(fl);
        super.startFlow(fl);
    }

    @Override
    public void endFlow(Flow fl) {
        this.converter.endFlow(fl);
        super.endFlow(fl);
    }

    @Override
    public void startBlock(Block bl) {
        this.converter.startBlock(bl);
        super.startBlock(bl);
    }

    @Override
    public void endBlock(Block bl) {
        this.converter.endBlock(bl);
        super.endBlock(bl);
    }

    @Override
    public void startBlockContainer(BlockContainer blc) {
        this.converter.startBlockContainer(blc);
        super.startBlockContainer(blc);
    }

    @Override
    public void endBlockContainer(BlockContainer blc) {
        this.converter.endBlockContainer(blc);
        super.endBlockContainer(blc);
    }

    @Override
    public void startInline(Inline inl) {
        this.converter.startInline(inl);
        super.startInline(inl);
    }

    @Override
    public void endInline(Inline inl) {
        this.converter.endInline(inl);
        super.endInline(inl);
    }

    @Override
    public void startTable(Table tbl) {
        this.converter.startTable(tbl);
        super.startTable(tbl);
    }

    @Override
    public void endTable(Table tbl) {
        this.converter.endTable(tbl);
        super.endTable(tbl);
    }

    @Override
    public void startColumn(TableColumn tc) {
        this.converter.startColumn(tc);
        super.startColumn(tc);
    }

    @Override
    public void endColumn(TableColumn tc) {
        this.converter.endColumn(tc);
        super.endColumn(tc);
    }

    @Override
    public void startHeader(TableHeader header) {
        this.converter.startHeader(header);
        super.startHeader(header);
    }

    @Override
    public void endHeader(TableHeader header) {
        this.converter.endHeader(header);
        super.endHeader(header);
    }

    @Override
    public void startFooter(TableFooter footer) {
        this.converter.startFooter(footer);
        super.startFooter(footer);
    }

    @Override
    public void endFooter(TableFooter footer) {
        this.converter.endFooter(footer);
        super.endFooter(footer);
    }

    @Override
    public void startBody(TableBody body) {
        this.converter.startBody(body);
        super.startBody(body);
    }

    @Override
    public void endBody(TableBody body) {
        this.converter.endBody(body);
        super.endBody(body);
    }

    @Override
    public void startRow(TableRow tr) {
        this.converter.startRow(tr);
        super.startRow(tr);
    }

    @Override
    public void endRow(TableRow tr) {
        this.converter.endRow(tr);
        super.endRow(tr);
    }

    @Override
    public void startCell(TableCell tc) {
        this.converter.startCell(tc);
        super.startCell(tc);
    }

    @Override
    public void endCell(TableCell tc) {
        this.converter.endCell(tc);
        super.endCell(tc);
    }

    @Override
    public void startList(ListBlock lb) {
        this.converter.startList(lb);
        super.startList(lb);
    }

    @Override
    public void endList(ListBlock lb) {
        this.converter.endList(lb);
        super.endList(lb);
    }

    @Override
    public void startListItem(ListItem li) {
        this.converter.startListItem(li);
        super.startListItem(li);
    }

    @Override
    public void endListItem(ListItem li) {
        this.converter.endListItem(li);
        super.endListItem(li);
    }

    @Override
    public void startListLabel(ListItemLabel listItemLabel) {
        this.converter.startListLabel(listItemLabel);
        super.startListLabel(listItemLabel);
    }

    @Override
    public void endListLabel(ListItemLabel listItemLabel) {
        this.converter.endListLabel(listItemLabel);
        super.endListLabel(listItemLabel);
    }

    @Override
    public void startListBody(ListItemBody listItemBody) {
        this.converter.startListBody(listItemBody);
        super.startListBody(listItemBody);
    }

    @Override
    public void endListBody(ListItemBody listItemBody) {
        this.converter.endListBody(listItemBody);
        super.endListBody(listItemBody);
    }

    @Override
    public void startMarkup() {
        this.converter.startMarkup();
        super.startMarkup();
    }

    @Override
    public void endMarkup() {
        this.converter.endMarkup();
        super.endMarkup();
    }

    @Override
    public void startLink(BasicLink basicLink) {
        this.converter.startLink(basicLink);
        super.startLink(basicLink);
    }

    @Override
    public void endLink(BasicLink basicLink) {
        this.converter.endLink(basicLink);
        super.endLink(basicLink);
    }

    @Override
    public void image(ExternalGraphic eg) {
        this.converter.image(eg);
        super.image(eg);
    }

    @Override
    public void pageRef() {
        this.converter.pageRef();
        super.pageRef();
    }

    @Override
    public void startInstreamForeignObject(InstreamForeignObject ifo) {
        this.converter.startInstreamForeignObject(ifo);
        super.startInstreamForeignObject(ifo);
    }

    @Override
    public void endInstreamForeignObject(InstreamForeignObject ifo) {
        this.converter.endInstreamForeignObject(ifo);
        super.endInstreamForeignObject(ifo);
    }

    @Override
    public void startFootnote(Footnote footnote) {
        this.converter.startFootnote(footnote);
        super.startFootnote(footnote);
    }

    @Override
    public void endFootnote(Footnote footnote) {
        this.converter.endFootnote(footnote);
        super.endFootnote(footnote);
    }

    @Override
    public void startFootnoteBody(FootnoteBody body) {
        this.converter.startFootnoteBody(body);
        super.startFootnoteBody(body);
    }

    @Override
    public void endFootnoteBody(FootnoteBody body) {
        this.converter.endFootnoteBody(body);
        super.endFootnoteBody(body);
    }

    @Override
    public void startLeader(Leader l) {
        this.converters.push(this.converter);
        this.converter = this.eventSwallower;
        this.converter.startLeader(l);
        super.startLeader(l);
    }

    @Override
    public void endLeader(Leader l) {
        this.converter.endLeader(l);
        this.converter = this.converters.pop();
        super.endLeader(l);
    }

    @Override
    public void startWrapper(Wrapper wrapper) {
        this.handleStartArtifact(wrapper);
        this.converter.startWrapper(wrapper);
        super.startWrapper(wrapper);
    }

    @Override
    public void endWrapper(Wrapper wrapper) {
        this.converter.endWrapper(wrapper);
        this.handleEndArtifact(wrapper);
        super.endWrapper(wrapper);
    }

    @Override
    public void startRetrieveMarker(RetrieveMarker retrieveMarker) {
        this.converter.startRetrieveMarker(retrieveMarker);
        this.saveState(retrieveMarker);
        super.startRetrieveMarker(retrieveMarker);
    }

    private void saveState(AbstractRetrieveMarker retrieveMarker) {
        this.states.put(retrieveMarker, new State(this));
    }

    @Override
    public void endRetrieveMarker(RetrieveMarker retrieveMarker) {
        this.converter.endRetrieveMarker(retrieveMarker);
        super.endRetrieveMarker(retrieveMarker);
    }

    @Override
    public void restoreState(RetrieveMarker retrieveMarker) {
        this.restoreRetrieveMarkerState(retrieveMarker);
        this.converter.restoreState(retrieveMarker);
        super.restoreState(retrieveMarker);
    }

    private void restoreRetrieveMarkerState(AbstractRetrieveMarker retrieveMarker) {
        State state = this.states.get(retrieveMarker);
        this.converter = state.converter;
        this.converters = (Stack)state.converters.clone();
    }

    @Override
    public void startRetrieveTableMarker(RetrieveTableMarker retrieveTableMarker) {
        this.converter.startRetrieveTableMarker(retrieveTableMarker);
        this.saveState(retrieveTableMarker);
        super.startRetrieveTableMarker(retrieveTableMarker);
    }

    @Override
    public void endRetrieveTableMarker(RetrieveTableMarker retrieveTableMarker) {
        this.converter.endRetrieveTableMarker(retrieveTableMarker);
        super.endRetrieveTableMarker(retrieveTableMarker);
    }

    @Override
    public void restoreState(RetrieveTableMarker retrieveTableMarker) {
        this.restoreRetrieveMarkerState(retrieveTableMarker);
        this.converter.restoreState(retrieveTableMarker);
        super.restoreState(retrieveTableMarker);
    }

    @Override
    public void character(Character c) {
        this.converter.character(c);
        super.character(c);
    }

    @Override
    public void characters(FOText foText) {
        this.converter.characters(foText);
        super.characters(foText);
    }

    @Override
    public void startExternalDocument(ExternalDocument document) {
        this.converter.startExternalDocument(document);
        super.startExternalDocument(document);
    }

    @Override
    public void endExternalDocument(ExternalDocument document) {
        this.converter.endExternalDocument(document);
        super.endExternalDocument(document);
    }

    private void handleStartArtifact(CommonAccessibilityHolder fobj) {
        if (this.isArtifact(fobj)) {
            this.converters.push(this.converter);
            this.converter = this.eventSwallower;
        }
    }

    private void handleEndArtifact(CommonAccessibilityHolder fobj) {
        if (this.isArtifact(fobj)) {
            this.converter = this.converters.pop();
        }
    }

    private boolean isArtifact(CommonAccessibilityHolder fobj) {
        CommonAccessibility accessibility = fobj.getCommonAccessibility();
        return "artifact".equalsIgnoreCase(accessibility.getRole());
    }

    private static final class State {
        private final FOEventHandler converter;
        private final Stack<FOEventHandler> converters;

        State(FO2StructureTreeConverter o) {
            this.converter = o.converter;
            this.converters = (Stack)o.converters.clone();
        }
    }
}

