/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineModuleInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private final IRModuleBody newIRModuleBody;

    public DefineModuleInstr(Variable result2, IRModuleBody newIRModuleBody, Operand container) {
        super(Operation.DEF_MODULE, result2, container);
        assert (result2 != null) : "DefineModuleInstr result is null";
        this.newIRModuleBody = newIRModuleBody;
    }

    public IRModuleBody getNewIRModuleBody() {
        return this.newIRModuleBody;
    }

    public Operand getContainer() {
        return this.getOperand1();
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.newIRModuleBody.getId()};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new DefineModuleInstr(ii.getRenamedVariable(this.result), this.newIRModuleBody, this.getContainer().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getNewIRModuleBody());
        e.encode(this.getContainer());
    }

    public static DefineModuleInstr decode(IRReaderDecoder d) {
        return new DefineModuleInstr(d.decodeVariable(), (IRModuleBody)d.decodeScope(), d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object rubyContainer = this.getContainer().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.newInterpretedModuleBody(context, this.newIRModuleBody, rubyContainer);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineModuleInstr(this);
    }
}

