/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.Locale;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.sql.ClientSqlException;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.Node;

public class FoldingException
extends ClientSqlException {
    private final int line;
    private final int column;

    public FoldingException(Node<?> source, String message, Object ... args) {
        super(message, args);
        Location loc = Location.EMPTY;
        if (source != null && source.location() != null) {
            loc = source.location();
        }
        this.line = loc.getLineNumber();
        this.column = loc.getColumnNumber();
    }

    public FoldingException(Node<?> source, String message, Throwable cause) {
        super(message, cause);
        Location loc = Location.EMPTY;
        if (source != null && source.location() != null) {
            loc = source.location();
        }
        this.line = loc.getLineNumber();
        this.column = loc.getColumnNumber();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    public String getMessage() {
        return String.format(Locale.ROOT, "line %s:%s: %s", this.getLineNumber(), this.getColumnNumber(), super.getMessage());
    }
}

