/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetLicenseRequest;
import org.elasticsearch.license.GetLicenseResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public class RestGetLicenseAction
extends XPackRestHandler {
    @Inject
    public RestGetLicenseAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, URI_BASE + "/license", (RestHandler)this, RestRequest.Method.GET, "/_license", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/_licenses", (RestHandler)this, "[GET /_licenses] is deprecated! Use [GET /_xpack/license] instead.", this.deprecationLogger);
    }

    public String getName() {
        return "xpack_get_license_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        HashMap<String, String> overrideParams = new HashMap<String, String>(2);
        overrideParams.put("rest_view", "true");
        overrideParams.put("license_version", String.valueOf(4));
        ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(overrideParams, (ToXContent.Params)request);
        GetLicenseRequest getLicenseRequest = new GetLicenseRequest();
        getLicenseRequest.local(request.paramAsBoolean("local", getLicenseRequest.local()));
        return arg_0 -> this.lambda$doPrepareRequest$0(client, getLicenseRequest, request, (ToXContent.Params)params, arg_0);
    }

    private /* synthetic */ void lambda$doPrepareRequest$0(XPackClient client, GetLicenseRequest getLicenseRequest, final RestRequest request, final ToXContent.Params params, RestChannel channel) throws Exception {
        client.es().admin().cluster().execute((Action)GetLicenseAction.INSTANCE, (ActionRequest)getLicenseRequest, (ActionListener)new RestBuilderListener<GetLicenseResponse>(channel){

            public RestResponse buildResponse(GetLicenseResponse response, XContentBuilder builder) throws Exception {
                if (!request.hasParam("pretty")) {
                    builder.prettyPrint().lfAtEnd();
                }
                boolean hasLicense = response.license() != null;
                builder.startObject();
                if (hasLicense) {
                    builder.startObject("license");
                    response.license().toInnerXContent(builder, params);
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(hasLicense ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
            }
        });
    }
}

