/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.logfile;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackUser;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class LoggingAuditTrail
extends AbstractComponent
implements AuditTrail,
ClusterStateListener {
    public static final String NAME = "logfile";
    public static final Setting<Boolean> HOST_ADDRESS_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.prefix.emit_node_host_address"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> HOST_NAME_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.prefix.emit_node_host_name"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> NODE_NAME_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.prefix.emit_node_name"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final List<String> DEFAULT_EVENT_INCLUDES = Arrays.asList(AuditLevel.ACCESS_DENIED.toString(), AuditLevel.ACCESS_GRANTED.toString(), AuditLevel.ANONYMOUS_ACCESS_DENIED.toString(), AuditLevel.AUTHENTICATION_FAILED.toString(), AuditLevel.CONNECTION_DENIED.toString(), AuditLevel.TAMPERED_REQUEST.toString(), AuditLevel.RUN_AS_DENIED.toString(), AuditLevel.RUN_AS_GRANTED.toString());
    public static final Setting<List<String>> INCLUDE_EVENT_SETTINGS = Setting.listSetting((String)SecurityField.setting((String)"audit.logfile.events.include"), DEFAULT_EVENT_INCLUDES, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<List<String>> EXCLUDE_EVENT_SETTINGS = Setting.listSetting((String)SecurityField.setting((String)"audit.logfile.events.exclude"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> INCLUDE_REQUEST_BODY = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.events.emit_request_body"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final String FILTER_POLICY_PREFIX = SecurityField.setting((String)"audit.logfile.events.ignore_filters.");
    private static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_PRINCIPALS = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"users", key -> Setting.listSetting((String)key, Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_REALMS = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"realms", key -> Setting.listSetting((String)key, Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_ROLES = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"roles", key -> Setting.listSetting((String)key, Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_INDICES = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"indices", key -> Setting.listSetting((String)key, Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private final Logger logger;
    final EventFilterPolicyRegistry eventFilterPolicyRegistry;
    private final ThreadContext threadContext;
    volatile EnumSet<AuditLevel> events;
    boolean includeRequestBody;
    LocalNodeInfo localNodeInfo;

    @Override
    public String name() {
        return NAME;
    }

    public LoggingAuditTrail(Settings settings, ClusterService clusterService, ThreadPool threadPool) {
        this(settings, clusterService, Loggers.getLogger(LoggingAuditTrail.class), threadPool.getThreadContext());
    }

    LoggingAuditTrail(Settings settings, ClusterService clusterService, Logger logger, ThreadContext threadContext) {
        super(settings);
        this.logger = logger;
        this.events = AuditLevel.parse((List)INCLUDE_EVENT_SETTINGS.get(settings), (List)EXCLUDE_EVENT_SETTINGS.get(settings));
        this.includeRequestBody = (Boolean)INCLUDE_REQUEST_BODY.get(settings);
        this.threadContext = threadContext;
        this.localNodeInfo = new LocalNodeInfo(settings, null);
        this.eventFilterPolicyRegistry = new EventFilterPolicyRegistry(settings);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(newSettings -> {
            LocalNodeInfo localNodeInfo = this.localNodeInfo;
            Settings.Builder builder = Settings.builder().put(localNodeInfo.settings).put(newSettings, false);
            this.localNodeInfo = new LocalNodeInfo(builder.build(), localNodeInfo.localNode);
            this.includeRequestBody = (Boolean)INCLUDE_REQUEST_BODY.get(newSettings);
            this.events = AuditLevel.parse((List)INCLUDE_EVENT_SETTINGS.get(newSettings), (List)EXCLUDE_EVENT_SETTINGS.get(newSettings));
        }, Arrays.asList(HOST_ADDRESS_SETTING, HOST_NAME_SETTING, NODE_NAME_SETTING, INCLUDE_EVENT_SETTINGS, EXCLUDE_EVENT_SETTINGS, INCLUDE_REQUEST_BODY));
        clusterService.getClusterSettings().addAffixUpdateConsumer(FILTER_POLICY_IGNORE_PRINCIPALS, (policyName, filtersList) -> {
            Optional policy = this.eventFilterPolicyRegistry.get(policyName);
            EventFilterPolicy newPolicy = policy.orElse(new EventFilterPolicy((String)policyName, settings)).changePrincipalsFilter(filtersList);
            this.eventFilterPolicyRegistry.set(policyName, newPolicy);
        }, (policyName, filtersList) -> EventFilterPolicy.parsePredicate(filtersList));
        clusterService.getClusterSettings().addAffixUpdateConsumer(FILTER_POLICY_IGNORE_REALMS, (policyName, filtersList) -> {
            Optional policy = this.eventFilterPolicyRegistry.get(policyName);
            EventFilterPolicy newPolicy = policy.orElse(new EventFilterPolicy((String)policyName, settings)).changeRealmsFilter(filtersList);
            this.eventFilterPolicyRegistry.set(policyName, newPolicy);
        }, (policyName, filtersList) -> EventFilterPolicy.parsePredicate(filtersList));
        clusterService.getClusterSettings().addAffixUpdateConsumer(FILTER_POLICY_IGNORE_ROLES, (policyName, filtersList) -> {
            Optional policy = this.eventFilterPolicyRegistry.get(policyName);
            EventFilterPolicy newPolicy = policy.orElse(new EventFilterPolicy((String)policyName, settings)).changeRolesFilter(filtersList);
            this.eventFilterPolicyRegistry.set(policyName, newPolicy);
        }, (policyName, filtersList) -> EventFilterPolicy.parsePredicate(filtersList));
        clusterService.getClusterSettings().addAffixUpdateConsumer(FILTER_POLICY_IGNORE_INDICES, (policyName, filtersList) -> {
            Optional policy = this.eventFilterPolicyRegistry.get(policyName);
            EventFilterPolicy newPolicy = policy.orElse(new EventFilterPolicy((String)policyName, settings)).changeIndicesFilter(filtersList);
            this.eventFilterPolicyRegistry.set(policyName, newPolicy);
        }, (policyName, filtersList) -> EventFilterPolicy.parsePredicate(filtersList));
    }

    @Override
    public void authenticationSuccess(String realm, User user, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.of(realm), Optional.empty(), Optional.empty()))) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [authentication_success]\t{}, realm=[{}], uri=[{}], params=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.principal(user), (Object)realm, (Object)request.uri(), (Object)request.params(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [authentication_success]\t{}, realm=[{}], uri=[{}], params=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.principal(user), (Object)realm, (Object)request.uri(), (Object)request.params(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void authenticationSuccess(String realm, User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.of(realm), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [authentication_success]\t{}, {}, realm=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.principal(user), (Object)realm, (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [authentication_success]\t{}, {}, realm=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.principal(user), (Object)realm, (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [anonymous_access_denied]\t{}, action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [anonymous_access_denied]\t{}, action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void anonymousAccessDenied(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [anonymous_access_denied]\t{}, uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [anonymous_access_denied]\t{}, uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)token.principal(), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)token.principal(), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void authenticationFailed(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [authentication_failed]\t{}, uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [authentication_failed]\t{}, uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void authenticationFailed(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [authentication_failed]\t{}, action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [authentication_failed]\t{}, action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.empty(), Optional.empty()))) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [authentication_failed]\t{}, principal=[{}], uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [authentication_failed]\t{}, principal=[{}], uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.of(realm), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)realm, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)token.principal(), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)realm, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)token.principal(), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.of(realm), Optional.empty()))) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)realm, (Object)LoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)realm, (Object)LoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void accessGranted(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        boolean isSystem;
        User user = authentication.getUser();
        boolean bl = isSystem = SystemUser.is((User)user) || XPackUser.is((User)user);
        if (isSystem && this.events.contains((Object)AuditLevel.SYSTEM_ACCESS_GRANTED) || !isSystem && this.events.contains((Object)AuditLevel.ACCESS_GRANTED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [access_granted]\t{}, {}, roles=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.subject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [access_granted]\t{}, {}, roles=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.subject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void accessDenied(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.ACCESS_DENIED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [access_denied]\t{}, {}, roles=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.subject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [access_denied]\t{}, {}, roles=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.subject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void tamperedRequest(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [tampered_request]\t{}, uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [tampered_request]\t{}, uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void tamperedRequest(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [tampered_request]\t{}, action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [tampered_request]\t{}, action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void tamperedRequest(User user, String action, TransportMessage request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(request);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.empty(), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [tampered_request]\t{}, {}, action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, request, localNodeInfo), (Object)LoggingAuditTrail.principal(user), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)request.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [tampered_request]\t{}, {}, action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, request, localNodeInfo), (Object)LoggingAuditTrail.principal(user), (Object)action, (Object)request.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_GRANTED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            this.logger.info("{}[ip_filter] [connection_granted]\torigin_address=[{}], transport_profile=[{}], rule=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)NetworkAddress.format((InetAddress)inetAddress), (Object)profile, (Object)rule, (Object)this.opaqueId());
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            this.logger.info("{}[ip_filter] [connection_denied]\torigin_address=[{}], transport_profile=[{}], rule=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)NetworkAddress.format((InetAddress)inetAddress), (Object)profile, (Object)rule, (Object)this.opaqueId());
        }
    }

    @Override
    public void runAsGranted(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_GRANTED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [run_as_granted]\t{}, {}, roles=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [run_as_granted]\t{}, {}, roles=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void runAsDenied(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [run_as_denied]\t{}, {}, roles=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [run_as_denied]\t{}, {}, roles=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)LoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)LoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void runAsDenied(Authentication authentication, RestRequest request, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), Optional.empty()))) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [run_as_denied]\t{}, {}, roles=[{}], uri=[{}], request_body=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)LoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)request.uri(), (Object)AuditUtil.restRequestContent(request), (Object)this.opaqueId());
            } else {
                this.logger.info("{}[rest] [run_as_denied]\t{}, {}, roles=[{}], uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)LoggingAuditTrail.hostAttributes(request), (Object)LoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    static String runAsSubject(Authentication authentication) {
        StringBuilder sb = new StringBuilder("principal=[");
        sb.append(authentication.getUser().authenticatedUser().principal());
        sb.append("], realm=[");
        sb.append(authentication.getAuthenticatedBy().getName());
        sb.append("], run_as_principal=[");
        sb.append(authentication.getUser().principal());
        if (authentication.getLookedUpBy() != null) {
            sb.append("], run_as_realm=[").append(authentication.getLookedUpBy().getName());
        }
        sb.append("]");
        return sb.toString();
    }

    static String subject(Authentication authentication) {
        StringBuilder sb = new StringBuilder("principal=[");
        sb.append(authentication.getUser().principal()).append("], realm=[");
        if (authentication.getUser().isRunAs()) {
            sb.append(authentication.getLookedUpBy().getName()).append("], run_by_principal=[");
            sb.append(authentication.getUser().authenticatedUser().principal()).append("], run_by_realm=[");
        }
        sb.append(authentication.getAuthenticatedBy().getName()).append("]");
        return sb.toString();
    }

    private static String hostAttributes(RestRequest request) {
        SocketAddress socketAddress = request.getRemoteAddress();
        String formattedAddress = socketAddress instanceof InetSocketAddress ? NetworkAddress.format((InetAddress)((InetSocketAddress)socketAddress).getAddress()) : socketAddress.toString();
        return "origin_address=[" + formattedAddress + "]";
    }

    protected static String originAttributes(ThreadContext threadContext, TransportMessage message, LocalNodeInfo localNodeInfo) {
        return LoggingAuditTrail.restOriginTag(threadContext).orElse(LoggingAuditTrail.transportOriginTag(message).orElse(localNodeInfo.localOriginTag));
    }

    private String opaqueId() {
        String opaqueId = this.threadContext.getHeader("X-Opaque-Id");
        if (opaqueId != null) {
            return ", opaque_id=[" + opaqueId + "]";
        }
        return "";
    }

    private static Optional<String> restOriginTag(ThreadContext threadContext) {
        InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(threadContext);
        if (restAddress == null) {
            return Optional.empty();
        }
        return Optional.of("origin_type=[rest], origin_address=[" + NetworkAddress.format((InetAddress)restAddress.getAddress()) + "]");
    }

    private static Optional<String> transportOriginTag(TransportMessage message) {
        TransportAddress address = message.remoteAddress();
        if (address == null) {
            return Optional.empty();
        }
        return Optional.of("origin_type=[transport], origin_address=[" + NetworkAddress.format((InetAddress)address.address().getAddress()) + "]");
    }

    static Optional<String[]> indices(TransportMessage message) {
        String[] indices;
        if (message instanceof IndicesRequest && (indices = ((IndicesRequest)message).indices()) != null && indices.length != 0) {
            return Optional.of(((IndicesRequest)message).indices());
        }
        return Optional.empty();
    }

    static String effectiveRealmName(Authentication authentication) {
        return authentication.getLookedUpBy() != null ? authentication.getLookedUpBy().getName() : authentication.getAuthenticatedBy().getName();
    }

    static String principal(User user) {
        StringBuilder builder = new StringBuilder("principal=[");
        builder.append(user.principal());
        if (user.isRunAs()) {
            builder.append("], run_by_principal=[").append(user.authenticatedUser().principal());
        }
        return builder.append("]").toString();
    }

    public static void registerSettings(List<Setting<?>> settings) {
        settings.add(HOST_ADDRESS_SETTING);
        settings.add(HOST_NAME_SETTING);
        settings.add(NODE_NAME_SETTING);
        settings.add(INCLUDE_EVENT_SETTINGS);
        settings.add(EXCLUDE_EVENT_SETTINGS);
        settings.add(INCLUDE_REQUEST_BODY);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_PRINCIPALS);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_INDICES);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_ROLES);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_REALMS);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        this.updateLocalNodeInfo(event.state().getNodes().getLocalNode());
    }

    void updateLocalNodeInfo(DiscoveryNode newLocalNode) {
        LocalNodeInfo localNodeInfo = this.localNodeInfo;
        if (localNodeInfo.localNode == null || !localNodeInfo.localNode.equals((Object)newLocalNode)) {
            this.localNodeInfo = new LocalNodeInfo(localNodeInfo.settings, newLocalNode);
        }
    }

    static class LocalNodeInfo {
        private final Settings settings;
        private final DiscoveryNode localNode;
        final String prefix;
        private final String localOriginTag;

        LocalNodeInfo(Settings settings, @Nullable DiscoveryNode newLocalNode) {
            this.settings = settings;
            this.localNode = newLocalNode;
            this.prefix = LocalNodeInfo.resolvePrefix(settings, newLocalNode);
            this.localOriginTag = LocalNodeInfo.localOriginTag(newLocalNode);
        }

        static String resolvePrefix(Settings settings, @Nullable DiscoveryNode localNode) {
            String name;
            StringBuilder builder = new StringBuilder();
            if (((Boolean)HOST_ADDRESS_SETTING.get(settings)).booleanValue()) {
                String address;
                String string = address = localNode != null ? localNode.getHostAddress() : null;
                if (address != null) {
                    builder.append("[").append(address).append("] ");
                }
            }
            if (((Boolean)HOST_NAME_SETTING.get(settings)).booleanValue()) {
                String hostName;
                String string = hostName = localNode != null ? localNode.getHostName() : null;
                if (hostName != null) {
                    builder.append("[").append(hostName).append("] ");
                }
            }
            if (((Boolean)NODE_NAME_SETTING.get(settings)).booleanValue() && (name = (String)Node.NODE_NAME_SETTING.get(settings)) != null) {
                builder.append("[").append(name).append("] ");
            }
            return builder.toString();
        }

        private static String localOriginTag(@Nullable DiscoveryNode localNode) {
            if (localNode == null) {
                return "origin_type=[local_node]";
            }
            return "origin_type=[local_node], origin_address=[" + localNode.getHostAddress() + "]";
        }
    }

    static final class AuditEventMetaInfo {
        final String principal;
        final String realm;
        final Supplier<Stream<String>> roles;
        final Supplier<Stream<String>> indices;
        static final AuditEventMetaInfo EMPTY = new AuditEventMetaInfo(Optional.empty(), Optional.empty(), Optional.empty());

        AuditEventMetaInfo(Optional<User> user, Optional<String> realm, Optional<String[]> roles, Optional<String[]> indices) {
            this.principal = user.map(u -> u.principal()).orElse("");
            this.realm = realm.orElse("");
            this.roles = () -> roles.filter(r -> ((String[])r).length != 0).map(Arrays::stream).orElse(Stream.of(""));
            this.indices = () -> indices.filter(i -> ((String[])i).length != 0).map(Arrays::stream).orElse(Stream.of(""));
        }

        AuditEventMetaInfo(Optional<AuthenticationToken> authenticationToken, Optional<String> realm, Optional<String[]> indices) {
            this.principal = authenticationToken.map(u -> u.principal()).orElse("");
            this.realm = realm.orElse("");
            this.roles = () -> Stream.of("");
            this.indices = () -> indices.filter(r -> ((String[])r).length != 0).map(i -> Arrays.stream(i)).orElse(Stream.of(""));
        }
    }

    static final class EventFilterPolicyRegistry {
        private volatile Map<String, EventFilterPolicy> policyMap;
        private volatile Predicate<AuditEventMetaInfo> predicate;

        private EventFilterPolicyRegistry(Settings settings) {
            MapBuilder mapBuilder = MapBuilder.newMapBuilder();
            for (String policyName : settings.getGroups(FILTER_POLICY_PREFIX, true).keySet()) {
                mapBuilder.put((Object)policyName, (Object)new EventFilterPolicy(policyName, settings));
            }
            this.policyMap = mapBuilder.immutableMap();
            this.predicate = EventFilterPolicyRegistry.buildIgnorePredicate(this.policyMap);
        }

        private Optional<EventFilterPolicy> get(String policyName) {
            return Optional.ofNullable(this.policyMap.get(policyName));
        }

        private synchronized void set(String policyName, EventFilterPolicy eventFilterPolicy) {
            this.policyMap = MapBuilder.newMapBuilder(this.policyMap).put((Object)policyName, (Object)eventFilterPolicy).immutableMap();
            this.predicate = EventFilterPolicyRegistry.buildIgnorePredicate(this.policyMap);
        }

        Predicate<AuditEventMetaInfo> ignorePredicate() {
            return this.predicate;
        }

        private static Predicate<AuditEventMetaInfo> buildIgnorePredicate(Map<String, EventFilterPolicy> policyMap) {
            return policyMap.values().stream().map(EventFilterPolicy::ignorePredicate).reduce(x -> false, (x, y) -> x.or(y));
        }

        public String toString() {
            TreeMap<String, EventFilterPolicy> treeMap = new TreeMap<String, EventFilterPolicy>(this.policyMap);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : treeMap.entrySet()) {
                sb.append((String)entry.getKey()).append(":").append(((EventFilterPolicy)entry.getValue()).toString());
            }
            return sb.toString();
        }
    }

    private static final class EventFilterPolicy {
        private final String name;
        private final Predicate<String> ignorePrincipalsPredicate;
        private final Predicate<String> ignoreRealmsPredicate;
        private final Predicate<String> ignoreRolesPredicate;
        private final Predicate<String> ignoreIndicesPredicate;

        EventFilterPolicy(String name, Settings settings) {
            this(name, EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_PRINCIPALS.getConcreteSettingForNamespace(name).get(settings)), EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_REALMS.getConcreteSettingForNamespace(name).get(settings)), EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_ROLES.getConcreteSettingForNamespace(name).get(settings)), EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_INDICES.getConcreteSettingForNamespace(name).get(settings)));
        }

        EventFilterPolicy(String name, Predicate<String> ignorePrincipalsPredicate, Predicate<String> ignoreRealmsPredicate, Predicate<String> ignoreRolesPredicate, Predicate<String> ignoreIndicesPredicate) {
            this.name = name;
            this.ignorePrincipalsPredicate = ignorePrincipalsPredicate;
            this.ignoreRealmsPredicate = ignoreRealmsPredicate;
            this.ignoreRolesPredicate = ignoreRolesPredicate;
            this.ignoreIndicesPredicate = ignoreIndicesPredicate;
        }

        private EventFilterPolicy changePrincipalsFilter(List<String> filtersList) {
            return new EventFilterPolicy(this.name, EventFilterPolicy.parsePredicate(filtersList), this.ignoreRealmsPredicate, this.ignoreRolesPredicate, this.ignoreIndicesPredicate);
        }

        private EventFilterPolicy changeRealmsFilter(List<String> filtersList) {
            return new EventFilterPolicy(this.name, this.ignorePrincipalsPredicate, EventFilterPolicy.parsePredicate(filtersList), this.ignoreRolesPredicate, this.ignoreIndicesPredicate);
        }

        private EventFilterPolicy changeRolesFilter(List<String> filtersList) {
            return new EventFilterPolicy(this.name, this.ignorePrincipalsPredicate, this.ignoreRealmsPredicate, EventFilterPolicy.parsePredicate(filtersList), this.ignoreIndicesPredicate);
        }

        private EventFilterPolicy changeIndicesFilter(List<String> filtersList) {
            return new EventFilterPolicy(this.name, this.ignorePrincipalsPredicate, this.ignoreRealmsPredicate, this.ignoreRolesPredicate, EventFilterPolicy.parsePredicate(filtersList));
        }

        static Predicate<String> parsePredicate(List<String> l) {
            return Automatons.predicate(EventFilterPolicy.emptyStringBuildsEmptyAutomaton(l));
        }

        private static List<String> emptyStringBuildsEmptyAutomaton(List<String> l) {
            if (l.isEmpty()) {
                return Collections.singletonList("//");
            }
            return l.stream().map(f -> f.isEmpty() ? "//" : f).collect(Collectors.toList());
        }

        Predicate<AuditEventMetaInfo> ignorePredicate() {
            return eventInfo -> this.ignorePrincipalsPredicate.test(eventInfo.principal) && this.ignoreRealmsPredicate.test(eventInfo.realm) && eventInfo.roles.get().allMatch(this.ignoreRolesPredicate) && eventInfo.indices.get().allMatch(this.ignoreIndicesPredicate);
        }

        public String toString() {
            return "[users]:" + this.ignorePrincipalsPredicate.toString() + "&[realms]:" + this.ignoreRealmsPredicate.toString() + "&[roles]:" + this.ignoreRolesPredicate.toString() + "&[indices]:" + this.ignoreIndicesPredicate.toString();
        }
    }
}

