/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.ActiveDirectorySessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.PoolingSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.core.security.authc.support.CharArrays;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectoryGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.PoolingSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapMetaDataResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class ActiveDirectorySessionFactory
extends PoolingSessionFactory {
    private static final String NETBIOS_NAME_FILTER_TEMPLATE = "(netbiosname={0})";
    final DefaultADAuthenticator defaultADAuthenticator;
    final DownLevelADAuthenticator downLevelADAuthenticator;
    final UpnADAuthenticator upnADAuthenticator;

    ActiveDirectorySessionFactory(RealmConfig config, SSLService sslService, ThreadPool threadPool) throws LDAPException {
        super(config, sslService, new ActiveDirectoryGroupsResolver(config.settings()), (Setting<Boolean>)ActiveDirectorySessionFactorySettings.POOL_ENABLED, PoolingSessionFactorySettings.BIND_DN.exists(config.settings()) ? ActiveDirectorySessionFactory.getBindDN(config.settings()) : null, () -> {
            String healthCheckDn;
            if (PoolingSessionFactorySettings.BIND_DN.exists(config.settings()) && (healthCheckDn = (String)PoolingSessionFactorySettings.BIND_DN.get(config.settings())).isEmpty() && healthCheckDn.indexOf(61) > 0) {
                return healthCheckDn;
            }
            return config.settings().get("user_search.base_dn", config.settings().get("domain_name"));
        }, threadPool);
        Settings settings = config.settings();
        String domainName = settings.get("domain_name");
        if (domainName == null) {
            throw new IllegalArgumentException("missing [domain_name] setting for active directory");
        }
        String domainDN = ActiveDirectorySessionFactory.buildDnFromDomain(domainName);
        int ldapPort = (Integer)ActiveDirectorySessionFactorySettings.AD_LDAP_PORT_SETTING.get(settings);
        int ldapsPort = (Integer)ActiveDirectorySessionFactorySettings.AD_LDAPS_PORT_SETTING.get(settings);
        int gcLdapPort = (Integer)ActiveDirectorySessionFactorySettings.AD_GC_LDAP_PORT_SETTING.get(settings);
        int gcLdapsPort = (Integer)ActiveDirectorySessionFactorySettings.AD_GC_LDAPS_PORT_SETTING.get(settings);
        this.defaultADAuthenticator = new DefaultADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, this.groupResolver, this.metaDataResolver, domainDN, threadPool);
        this.downLevelADAuthenticator = new DownLevelADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, this.groupResolver, this.metaDataResolver, domainDN, sslService, threadPool, ldapPort, ldapsPort, gcLdapPort, gcLdapsPort);
        this.upnADAuthenticator = new UpnADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, this.groupResolver, this.metaDataResolver, domainDN, threadPool);
    }

    @Override
    protected List<String> getDefaultLdapUrls(Settings settings) {
        return Collections.singletonList("ldap://" + settings.get("domain_name") + ":" + ActiveDirectorySessionFactorySettings.AD_LDAP_PORT_SETTING.get(settings));
    }

    @Override
    public boolean supportsUnauthenticatedSession() {
        return true;
    }

    @Override
    void getSessionWithPool(LDAPConnectionPool connectionPool, String user, SecureString password, ActionListener<LdapSession> listener) {
        this.getADAuthenticator(user).authenticate(connectionPool, user, password, this.threadPool, listener);
    }

    @Override
    void getSessionWithoutPool(String username, SecureString password, ActionListener<LdapSession> listener) {
        try {
            LDAPConnection connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((ServerSet)this.serverSet).getConnection());
            this.getADAuthenticator(username).authenticate(connection, username, password, (ActionListener<LdapSession>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                listener.onFailure(e);
            }));
        }
        catch (LDAPException e2) {
            listener.onFailure((Exception)((Object)e2));
        }
    }

    @Override
    void getUnauthenticatedSessionWithPool(LDAPConnectionPool connectionPool, String user, ActionListener<LdapSession> listener) {
        this.getADAuthenticator(user).searchForDN((LDAPInterface)connectionPool, user, null, Math.toIntExact(this.timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                String dn = entry.getDN();
                listener.onResponse((Object)new LdapSession(this.logger, this.config, (LDAPInterface)connectionPool, dn, this.groupResolver, this.metaDataResolver, this.timeout, null));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    void getUnauthenticatedSessionWithoutPool(final String user, final ActionListener<LdapSession> listener) {
        if (!PoolingSessionFactorySettings.BIND_DN.exists(this.config.settings())) {
            listener.onResponse(null);
            return;
        }
        try {
            final LDAPConnection connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((ServerSet)this.serverSet).getConnection());
            LdapUtils.maybeForkThenBind(connection, (BindRequest)this.bindCredentials, this.threadPool, new AbstractRunnable(){

                public void onFailure(Exception e) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    listener.onFailure(e);
                }

                protected void doRun() throws Exception {
                    ActiveDirectorySessionFactory.this.getADAuthenticator(user).searchForDN((LDAPInterface)connection, user, null, Math.toIntExact(ActiveDirectorySessionFactory.this.timeout.getSeconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                        if (entry == null) {
                            IOUtils.close((Closeable[])new Closeable[]{connection});
                            listener.onResponse(null);
                        } else {
                            listener.onResponse((Object)new LdapSession(ActiveDirectorySessionFactory.this.logger, ActiveDirectorySessionFactory.this.config, (LDAPInterface)connection, entry.getDN(), ActiveDirectorySessionFactory.this.groupResolver, ActiveDirectorySessionFactory.this.metaDataResolver, ActiveDirectorySessionFactory.this.timeout, null));
                        }
                    }, e -> {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                        listener.onFailure(e);
                    }));
                }
            });
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    static String buildDnFromDomain(String domain) {
        return "DC=" + domain.replace(".", ",DC=");
    }

    static String getBindDN(Settings settings) {
        String bindDN = (String)PoolingSessionFactorySettings.BIND_DN.get(settings);
        if (!bindDN.isEmpty() && bindDN.indexOf(92) < 0 && bindDN.indexOf(64) < 0 && bindDN.indexOf(61) < 0) {
            bindDN = bindDN + "@" + settings.get("domain_name");
        }
        return bindDN;
    }

    ServerSet getServerSet() {
        return this.serverSet;
    }

    ADAuthenticator getADAuthenticator(String username) {
        if (username.indexOf(92) > 0) {
            return this.downLevelADAuthenticator;
        }
        if (username.indexOf("@") > 0) {
            return this.upnADAuthenticator;
        }
        return this.defaultADAuthenticator;
    }

    static class UpnADAuthenticator
    extends ADAuthenticator {
        static final String UPN_USER_FILTER = "(&(objectClass=user)(userPrincipalName={1}))";

        UpnADAuthenticator(RealmConfig config, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN, ThreadPool threadPool) {
            super(config, timeout, ignoreReferralErrors, logger, groupsResolver, metaDataResolver, domainDN, "user_search.upn_filter", UPN_USER_FILTER, threadPool);
            if (this.userSearchFilter.contains("{0}")) {
                new DeprecationLogger(logger).deprecated("The use of the account name variable {0} in the setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, (String)"user_search.upn_filter") + "] has been deprecated and will be removed in a future version!", new Object[0]);
            }
        }

        @Override
        void searchForDN(LDAPInterface connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("@");
            assert (parts.length == 2) : "there should have only been two values for " + username + " after splitting on '@'";
            String accountName = parts[0];
            try {
                Filter filter = LdapUtils.createFilter(this.userSearchFilter, accountName, username);
                LdapUtils.searchForEntry(connection, this.userSearchDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
            }
        }
    }

    static class DownLevelADAuthenticator
    extends ADAuthenticator {
        static final String DOWN_LEVEL_FILTER = "(&(objectClass=user)(sAMAccountName={0}))";
        Cache<String, String> domainNameCache = CacheBuilder.builder().setMaximumWeight(100L).build();
        final String domainDN;
        final Settings settings;
        final SSLService sslService;
        final RealmConfig config;
        private final int ldapPort;
        private final int ldapsPort;
        private final int gcLdapPort;
        private final int gcLdapsPort;

        DownLevelADAuthenticator(RealmConfig config, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN, SSLService sslService, ThreadPool threadPool, int ldapPort, int ldapsPort, int gcLdapPort, int gcLdapsPort) {
            super(config, timeout, ignoreReferralErrors, logger, groupsResolver, metaDataResolver, domainDN, "user_search.down_level_filter", DOWN_LEVEL_FILTER, threadPool);
            this.domainDN = domainDN;
            this.settings = config.settings();
            this.sslService = sslService;
            this.config = config;
            this.ldapPort = ldapPort;
            this.ldapsPort = ldapsPort;
            this.gcLdapPort = gcLdapPort;
            this.gcLdapsPort = gcLdapsPort;
        }

        @Override
        void searchForDN(LDAPInterface connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("\\\\");
            assert (parts.length == 2);
            String netBiosDomainName = parts[0];
            String accountName = parts[1];
            this.netBiosDomainNameToDn(connection, netBiosDomainName, username, password, timeLimitSeconds, (ActionListener<String>)ActionListener.wrap(domainDN -> {
                if (domainDN == null) {
                    listener.onResponse(null);
                } else {
                    LdapUtils.searchForEntry(connection, domainDN, LdapSearchScope.SUB_TREE.scope(), LdapUtils.createFilter(this.userSearchFilter, accountName), timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void netBiosDomainNameToDn(LDAPInterface ldapInterface, final String netBiosDomainName, String username, SecureString password, final int timeLimitSeconds, ActionListener<String> listener) {
            LDAPConnection ldapConnection = null;
            try {
                final Filter filter = LdapUtils.createFilter(ActiveDirectorySessionFactory.NETBIOS_NAME_FILTER_TEMPLATE, netBiosDomainName);
                String cachedName = (String)this.domainNameCache.get((Object)netBiosDomainName);
                if (cachedName != null) {
                    listener.onResponse((Object)cachedName);
                } else if (!this.usingGlobalCatalog(ldapInterface)) {
                    LdapUtils.search(ldapInterface, "CN=Configuration," + this.domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, this.domainNameCache, listener), arg_0 -> listener.onFailure(arg_0)), "ncname");
                } else {
                    ldapConnection = ldapInterface instanceof LDAPConnection ? (LDAPConnection)ldapInterface : (LDAPConnection)LdapUtils.privilegedConnect(() -> ((LDAPConnectionPool)((LDAPConnectionPool)ldapInterface)).getConnection());
                    LDAPConnection finalLdapConnection = ldapConnection;
                    final LDAPConnection searchConnection = (LDAPConnection)LdapUtils.privilegedConnect(() -> new LDAPConnection(finalLdapConnection.getSocketFactory(), ActiveDirectorySessionFactory.connectionOptions(this.config, this.sslService, this.logger), finalLdapConnection.getConnectedAddress(), finalLdapConnection.getSSLSession() != null ? this.ldapsPort : this.ldapPort));
                    byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])password.getChars());
                    SimpleBindRequest bind = this.bindDN.isEmpty() ? new SimpleBindRequest(username, passwordBytes) : new SimpleBindRequest(this.bindDN, CharArrays.toUtf8Bytes((char[])this.bindPassword.getChars()));
                    LdapUtils.maybeForkThenBind(searchConnection, (BindRequest)bind, this.threadPool, (AbstractRunnable)new ActionRunnable<String>(listener){

                        protected void doRun() throws Exception {
                            LdapUtils.search(searchConnection, "CN=Configuration," + domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> {
                                IOUtils.close((Closeable[])new Closeable[]{searchConnection});
                                DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, domainNameCache, (ActionListener<String>)this.listener);
                            }, e -> {
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searchConnection});
                                this.listener.onFailure(e);
                            }), "ncname");
                        }

                        public void onFailure(Exception e) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searchConnection});
                            this.listener.onFailure(e);
                        }
                    });
                }
                if (!(ldapInterface instanceof LDAPConnectionPool) || ldapConnection == null) return;
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
                return;
            }
            finally {
                if (ldapInterface instanceof LDAPConnectionPool && ldapConnection != null) {
                    ((LDAPConnectionPool)ldapInterface).releaseConnection(ldapConnection);
                }
            }
            ((LDAPConnectionPool)ldapInterface).releaseConnection(ldapConnection);
            return;
        }

        static void handleSearchResults(List<SearchResultEntry> results, String netBiosDomainName, Cache<String, String> domainNameCache, ActionListener<String> listener) {
            Optional<SearchResultEntry> entry = results.stream().filter(r -> r.hasAttribute("ncname")).findFirst();
            if (entry.isPresent()) {
                String value = entry.get().getAttributeValue("ncname");
                try {
                    domainNameCache.computeIfAbsent((Object)netBiosDomainName, s -> value);
                }
                catch (ExecutionException e) {
                    throw new AssertionError("failed to load constant non-null value", e);
                }
                listener.onResponse((Object)value);
            } else {
                listener.onResponse(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean usingGlobalCatalog(LDAPInterface ldap) throws LDAPException {
            boolean bl;
            block4: {
                if (ldap instanceof LDAPConnection) {
                    return this.usingGlobalCatalog((LDAPConnection)ldap);
                }
                LDAPConnectionPool pool = (LDAPConnectionPool)ldap;
                LDAPConnection connection = null;
                try {
                    connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((LDAPConnectionPool)pool).getConnection());
                    bl = this.usingGlobalCatalog(connection);
                    if (connection == null) break block4;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        pool.releaseConnection(connection);
                    }
                    throw throwable;
                }
                pool.releaseConnection(connection);
            }
            return bl;
        }

        private boolean usingGlobalCatalog(LDAPConnection ldapConnection) {
            return ldapConnection.getConnectedPort() == this.gcLdapPort || ldapConnection.getConnectedPort() == this.gcLdapsPort;
        }
    }

    static class DefaultADAuthenticator
    extends ADAuthenticator {
        final String domainName;

        DefaultADAuthenticator(RealmConfig realm, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN, ThreadPool threadPool) {
            super(realm, timeout, ignoreReferralErrors, logger, groupsResolver, metaDataResolver, domainDN, "user_search.filter", "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={0}@" + DefaultADAuthenticator.domainName(realm) + ")))", threadPool);
            this.domainName = DefaultADAuthenticator.domainName(realm);
        }

        private static String domainName(RealmConfig realm) {
            return realm.settings().get("domain_name");
        }

        @Override
        void searchForDN(LDAPInterface connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            try {
                LdapUtils.searchForEntry(connection, this.userSearchDN, this.userSearchScope.scope(), LdapUtils.createFilter(this.userSearchFilter, username), timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
            }
        }

        @Override
        String bindUsername(String username) {
            return username + "@" + this.domainName;
        }
    }

    static abstract class ADAuthenticator {
        private final RealmConfig realm;
        final TimeValue timeout;
        final boolean ignoreReferralErrors;
        final Logger logger;
        final LdapSession.GroupsResolver groupsResolver;
        final LdapMetaDataResolver metaDataResolver;
        final String userSearchDN;
        final LdapSearchScope userSearchScope;
        final String userSearchFilter;
        final String bindDN;
        final SecureString bindPassword;
        final ThreadPool threadPool;

        ADAuthenticator(RealmConfig realm, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN, String userSearchFilterSetting, String defaultUserSearchFilter, ThreadPool threadPool) {
            this.realm = realm;
            this.timeout = timeout;
            this.ignoreReferralErrors = ignoreReferralErrors;
            this.logger = logger;
            this.groupsResolver = groupsResolver;
            this.metaDataResolver = metaDataResolver;
            Settings settings = realm.settings();
            this.bindDN = ActiveDirectorySessionFactory.getBindDN(settings);
            this.bindPassword = (SecureString)PoolingSessionFactorySettings.SECURE_BIND_PASSWORD.get(settings);
            this.threadPool = threadPool;
            this.userSearchDN = settings.get("user_search.base_dn", domainDN);
            this.userSearchScope = LdapSearchScope.resolve((String)settings.get("user_search.scope"), (LdapSearchScope)LdapSearchScope.SUB_TREE);
            this.userSearchFilter = settings.get(userSearchFilterSetting, defaultUserSearchFilter);
        }

        final void authenticate(final LDAPConnection connection, final String username, final SecureString password, ActionListener<LdapSession> listener) {
            byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])password.getChars());
            SimpleBindRequest userBind = new SimpleBindRequest(this.bindUsername(username), passwordBytes, new Control[]{new AuthorizationIdentityRequestControl()});
            LdapUtils.maybeForkThenBind(connection, (BindRequest)userBind, this.threadPool, (AbstractRunnable)new ActionRunnable<LdapSession>(listener){

                protected void doRun() throws Exception {
                    ActionRunnable<LdapSession> searchRunnable = new ActionRunnable<LdapSession>(this.listener){

                        protected void doRun() throws Exception {
                            this.searchForDN((LDAPInterface)connection, username, password, Math.toIntExact(timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                                if (entry == null) {
                                    this.listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("search for user [" + username + "] by principal name yielded no results", new Object[0])));
                                } else {
                                    this.listener.onResponse((Object)new LdapSession(logger, realm, (LDAPInterface)connection, entry.getDN(), groupsResolver, metaDataResolver, timeout, null));
                                }
                            }, e -> this.listener.onFailure(e)));
                        }
                    };
                    if (bindDN.isEmpty()) {
                        searchRunnable.run();
                    } else {
                        SimpleBindRequest bind = new SimpleBindRequest(bindDN, CharArrays.toUtf8Bytes((char[])bindPassword.getChars()));
                        LdapUtils.maybeForkThenBind(connection, (BindRequest)bind, threadPool, (AbstractRunnable)searchRunnable);
                    }
                }
            });
        }

        final void authenticate(final LDAPConnectionPool pool, final String username, final SecureString password, ThreadPool threadPool, ActionListener<LdapSession> listener) {
            byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])password.getChars());
            SimpleBindRequest bind = new SimpleBindRequest(this.bindUsername(username), passwordBytes);
            LdapUtils.maybeForkThenBindAndRevert(pool, (BindRequest)bind, threadPool, (AbstractRunnable)new ActionRunnable<LdapSession>(listener){

                protected void doRun() throws Exception {
                    this.searchForDN((LDAPInterface)pool, username, password, Math.toIntExact(timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                        if (entry == null) {
                            this.listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("search for user [" + username + "] by principal name yielded no results", new Object[0])));
                        } else {
                            this.listener.onResponse((Object)new LdapSession(logger, realm, (LDAPInterface)pool, entry.getDN(), groupsResolver, metaDataResolver, timeout, null));
                        }
                    }, e -> this.listener.onFailure(e)));
                }
            });
        }

        String bindUsername(String username) {
            return username;
        }

        final String getUserSearchFilter() {
            return this.userSearchFilter;
        }

        abstract void searchForDN(LDAPInterface var1, String var2, SecureString var3, int var4, ActionListener<SearchResultEntry> var5);
    }
}

