#ifndef _EFL_TASK_EO_H_
#define _EFL_TASK_EO_H_

#ifndef _EFL_TASK_EO_CLASS_TYPE
#define _EFL_TASK_EO_CLASS_TYPE

typedef Eo Efl_Task;

#endif

#ifndef _EFL_TASK_EO_TYPES
#define _EFL_TASK_EO_TYPES

/** No description supplied.
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_TASK_PRIORITY_NORMAL = 0,
  EFL_TASK_PRIORITY_BACKGROUND,
  EFL_TASK_PRIORITY_LOW,
  EFL_TASK_PRIORITY_HIGH,
  EFL_TASK_PRIORITY_ULTRA
} Efl_Task_Priority;

/** No description supplied.
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_TASK_FLAGS_NONE = 0,
  EFL_TASK_FLAGS_USE_STDIN = 1,
  EFL_TASK_FLAGS_USE_STDOUT = 2,
  EFL_TASK_FLAGS_NO_EXIT_CODE_ERROR = 4
} Efl_Task_Flags;


#endif
/** No description supplied.
 *
 * @ingroup Efl_Task
 */
#define EFL_TASK_CLASS efl_task_class_get()

EWAPI const Efl_Class *efl_task_class_get(void);

/**
 * @brief A commandline that encodes arguments in a command string. This
 * command is unix shell-style, thus whitespace separates arguments unless
 * escaped. Also a semi-colon ';', ampersand '&', pipe/bar '|', hash '#',
 * bracket, square brace, brace character ('(', ')', '[', ']', '{', '}'),
 * exclamation mark '!',  backquote '`', greator or less than ('>' '<')
 * character unless escaped or in quotes would cause args_count/value to not be
 * generated properly, because it would force complex shell interpretation
 * which will not be supported in evaluating the arg_count/value information,
 * but the final shell may interpret this if this is executed via a
 * command-line shell. To not be a complex shell command, it should be simple
 * with paths, options and variable expansions, but nothing more complex
 * involving the above unescaped characters.
 *
 * "cat -option /path/file" "cat 'quoted argument'" "cat ~/path/escaped\
 * argument" "/bin/cat escaped\ argument @c VARIABLE" etc.
 *
 * It should not try and use "complex shell features" if you want the arg_count
 * and arg_value set to be correct after setting the command string. For
 * example none of:
 *
 * "VAR=x /bin/command && /bin/othercommand >& /dev/null" "VAR=x /bin/command
 * `/bin/othercommand` | /bin/cmd2 && cmd3 &" etc.
 *
 * If you set the command the arg_count/value property contents can change and
 * be completely re-evaluated by parsing the command string into an argument
 * array set along with interpreting escapes back into individual argument
 * strings.
 *
 * @param[in] obj The object.
 * @param[in] command The command string as described
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_command_set(Eo *obj, const char *command);

/**
 * @brief A commandline that encodes arguments in a command string. This
 * command is unix shell-style, thus whitespace separates arguments unless
 * escaped. Also a semi-colon ';', ampersand '&', pipe/bar '|', hash '#',
 * bracket, square brace, brace character ('(', ')', '[', ']', '{', '}'),
 * exclamation mark '!',  backquote '`', greator or less than ('>' '<')
 * character unless escaped or in quotes would cause args_count/value to not be
 * generated properly, because it would force complex shell interpretation
 * which will not be supported in evaluating the arg_count/value information,
 * but the final shell may interpret this if this is executed via a
 * command-line shell. To not be a complex shell command, it should be simple
 * with paths, options and variable expansions, but nothing more complex
 * involving the above unescaped characters.
 *
 * "cat -option /path/file" "cat 'quoted argument'" "cat ~/path/escaped\
 * argument" "/bin/cat escaped\ argument @c VARIABLE" etc.
 *
 * It should not try and use "complex shell features" if you want the arg_count
 * and arg_value set to be correct after setting the command string. For
 * example none of:
 *
 * "VAR=x /bin/command && /bin/othercommand >& /dev/null" "VAR=x /bin/command
 * `/bin/othercommand` | /bin/cmd2 && cmd3 &" etc.
 *
 * If you set the command the arg_count/value property contents can change and
 * be completely re-evaluated by parsing the command string into an argument
 * array set along with interpreting escapes back into individual argument
 * strings.
 *
 * @param[in] obj The object.
 *
 * @return The command string as described
 *
 * @ingroup Efl_Task
 */
EOAPI const char *efl_task_command_get(const Eo *obj);

/**
 * @brief Number of arguments passed in or arguments that are to be passed as
 * sepcified by arg_value
 *
 * @param[in] obj The object.
 *
 * @return No description supplied.
 *
 * @ingroup Efl_Task
 */
EOAPI unsigned int efl_task_arg_count_get(const Eo *obj);

/**
 * @brief Argument number by index. If the index does not exist when set, it is
 * allocated and created. Getting an argument that Has not been set yet will
 * return @c NULL. Empty arguments will Be ignored. Setting an argument will
 * result in the command porperty being re-evaluated and escaped into a single
 * command string if needed.
 *
 * @param[in] obj The object.
 * @param[in] num No description supplied.
 * @param[in] arg No description supplied.
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_arg_value_set(Eo *obj, unsigned int num, const char *arg);

/**
 * @brief Argument number by index. If the index does not exist when set, it is
 * allocated and created. Getting an argument that Has not been set yet will
 * return @c NULL. Empty arguments will Be ignored. Setting an argument will
 * result in the command porperty being re-evaluated and escaped into a single
 * command string if needed.
 *
 * @param[in] obj The object.
 * @param[in] num No description supplied.
 *
 * @return No description supplied.
 *
 * @ingroup Efl_Task
 */
EOAPI const char *efl_task_arg_value_get(const Eo *obj, unsigned int num);

/**
 * @brief Append a new string argument at the end of the arg set. This
 * functions like setting an arg_value at the end of the current set so the set
 * increases by 1 in size.
 *
 * @param[in] obj The object.
 * @param[in] arg No description supplied.
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_arg_append(Eo *obj, const char *arg);

/** Clear all arguments in arg_value/count set. Will result in the command
 * property also being cleared.
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_arg_reset(Eo *obj);

/**
 * @brief The environment to be passed in or that was passed to the task. This
 * is a string key, value list which map to environment variables where
 * appropriate. The var string must contain only an underscore ('_'), letters
 * ('a-z', 'A-Z'), numbers ('0-9'), but the first character may not be a
 * number.
 *
 * @param[in] obj The object.
 * @param[in] var The variable name as a string
 * @param[in] value Set var to this value if not @c NULL, otherwise clear this
 * env value if value is @c NULL or if it is an empty string
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_env_set(Eo *obj, const char *var, const char *value);

/**
 * @brief The environment to be passed in or that was passed to the task. This
 * is a string key, value list which map to environment variables where
 * appropriate. The var string must contain only an underscore ('_'), letters
 * ('a-z', 'A-Z'), numbers ('0-9'), but the first character may not be a
 * number.
 *
 * @param[in] obj The object.
 * @param[in] var The variable name as a string
 *
 * @return Set var to this value if not @c NULL, otherwise clear this env value
 * if value is @c NULL or if it is an empty string
 *
 * @ingroup Efl_Task
 */
EOAPI const char *efl_task_env_get(const Eo *obj, const char *var);

/** Clear all environment variables.
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_env_reset(Eo *obj);

/**
 * @brief The priority of this task.
 *
 * @param[in] obj The object.
 * @param[in] priority No description supplied.
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_priority_set(Eo *obj, Efl_Task_Priority priority);

/**
 * @brief The priority of this task.
 *
 * @param[in] obj The object.
 *
 * @return No description supplied.
 *
 * @ingroup Efl_Task
 */
EOAPI Efl_Task_Priority efl_task_priority_get(const Eo *obj);

/**
 * @brief The final exit code of this task.
 *
 * @param[in] obj The object.
 *
 * @return No description supplied.
 *
 * @ingroup Efl_Task
 */
EOAPI int efl_task_exit_code_get(const Eo *obj);

EOAPI void efl_task_flags_set(Eo *obj, Efl_Task_Flags flags);

EOAPI Efl_Task_Flags efl_task_flags_get(const Eo *obj);

/**
 * @brief Actually run the task
 *
 * @param[in] obj The object.
 *
 * @return A future triggered when task exits and is passed int exit code
 *
 * @ingroup Efl_Task
 */
EOAPI Eina_Future *efl_task_run(Eo *obj);

/** Request the task end (may send a signal or interrupt signal resulting in a
 * terminate event being tiggered in the target task loop)
 *
 * @ingroup Efl_Task
 */
EOAPI void efl_task_end(Eo *obj);

#endif
