#ifndef _EFL_GFX_IMAGE_EO_LEGACY_H_
#define _EFL_GFX_IMAGE_EO_LEGACY_H_

#ifndef _EFL_GFX_IMAGE_EO_CLASS_TYPE
#define _EFL_GFX_IMAGE_EO_CLASS_TYPE

typedef Eo Efl_Gfx_Image;

#endif

#ifndef _EFL_GFX_IMAGE_EO_TYPES
#define _EFL_GFX_IMAGE_EO_TYPES

/** How an image's data is to be treated by EFL, for optimization.
 *
 * @ingroup Efl_Gfx
 */
typedef enum
{
  EFL_GFX_IMAGE_CONTENT_HINT_NONE = 0, /**< No hint on the content (default). */
  EFL_GFX_IMAGE_CONTENT_HINT_DYNAMIC = 1, /**< The content will change over
                                           * time. */
  EFL_GFX_IMAGE_CONTENT_HINT_STATIC = 2 /**< The content won't change over time.
                                         */
} Efl_Gfx_Image_Content_Hint;

/** How an image's data is to be treated by EFL, with regard to scaling cache.
 *
 * @ingroup Efl_Gfx
 */
typedef enum
{
  EFL_GFX_IMAGE_SCALE_HINT_NONE = 0, /**< No hint on the scaling (default). */
  EFL_GFX_IMAGE_SCALE_HINT_DYNAMIC = 1, /**< Image will be re-scaled over time,
                                         * thus turning scaling cache OFF for
                                         * its data. */
  EFL_GFX_IMAGE_SCALE_HINT_STATIC = 2 /**< Image will not be re-scaled over
                                       * time, thus turning scaling cache ON
                                       * for its data. */
} Efl_Gfx_Image_Scale_Hint;

/** Enumeration that defines scale types of an image.
 *
 * @ingroup Efl_Gfx
 */
typedef enum
{
  EFL_GFX_IMAGE_SCALE_TYPE_FILL = 0, /**< Scale the image so that it matches
                                      *  the object's area exactly. The image's
                                      * aspect ratio might be changed. */
  EFL_GFX_IMAGE_SCALE_TYPE_FIT_INSIDE, /**< Scale the image so that it fits
                                        * inside the object's area while
                                        * maintaining the aspect ratio. At
                                        * least one of the dimensions of the
                                        * image should be equal to the
                                        * corresponding dimension  of the
                                        * object. */
  EFL_GFX_IMAGE_SCALE_TYPE_FIT_OUTSIDE, /**< Scale the image so that it covers
                                         * the entire object area while
                                         * maintaining the aspect ratio. At
                                         * least one of the dimensions of the
                                         * image should be equal to the
                                         * corresponding  dimension of the
                                         * object. */
  EFL_GFX_IMAGE_SCALE_TYPE_TILE, /**< Tile image at its original size. */
  EFL_GFX_IMAGE_SCALE_TYPE_NONE /**< Not scale the image */
} Efl_Gfx_Image_Scale_Type;


#endif

















#endif
